/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.io.File;
import jet.ReportEnv;
import jet.jetc.JetCReader;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReportLoader;
import jet.log.JRLogger;
import jet.report.JRObjectTemplate;
import jet.report.JetRptReportPanel;
import jet.util.HeadlessHelper;
import jet.util.WildcardMatcher;

public class ConvertUnit {
    private static JRLogger SEDU = JRLogger.getLogger(ConvertUnit.class.getName());

    public static void main(String[] stringArray) {
        Object object;
        int n;
        File file;
        int n2;
        if (stringArray.length == 0 || stringArray[0].equals("/?") || stringArray[0].equals("-?") || stringArray[0].equalsIgnoreCase("/help") || stringArray[0].equalsIgnoreCase("-help")) {
            System.out.println("java -Dreporthome=<drive>:<path> -Dresolution=number jet.report.ConvertUnit ");
            System.out.println("  [[drive:][path][filename] +]");
            System.out.println("\t[drive:][path][filename]");
            System.out.println("\t\tSpecifies drive, directory, and/or files to list.");
            System.out.println("\t\tSeparates by space.");
            System.out.println(" If the report file is saved before build 472 (472 not included), please remove the resolution option.");
            System.out.println(" If the report file is saved before build 495 (495 not included), please set the resolution to 72.");
            System.out.println(" If the report file is saved before build 501 (501 not included), please remove the resolution option.");
            System.out.println(" If the report file is saved after build 501, please do not use this program.");
            System.exit(0);
        }
        String string = System.getProperty("resolution");
        int n3 = n2 = HeadlessHelper.getScreenResolution();
        if (string != null && string.equals("72")) {
            n3 = 72;
        }
        ReportEnv.checkEnv(new Object(), null, 0);
        if (ReportEnv.ie()) {
            System.out.println("Your version is a evaluation version.");
            System.exit(0);
        }
        String[] stringArray2 = null;
        String string2 = System.getProperty("user.dir");
        if (stringArray.length == 0) {
            file = new File(string2);
            stringArray2 = file.list(new WildcardMatcher("*.cls", false));
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = string2 + File.separator + stringArray2[i];
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                String[] stringArray3;
                file = new File(stringArray[n]);
                object = file.getName();
                if (((String)object).indexOf("*") == -1 && ((String)object).indexOf("?") == -1) {
                    stringArray3 = new String[]{object};
                } else {
                    stringArray3 = file.list(new WildcardMatcher((String)object, false));
                    if (stringArray3 == null) continue;
                }
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string3 = file.getParent();
                    if (string3 == null) {
                        string3 = string2;
                    }
                    stringArray3[i] = string3 + File.separator + stringArray3[i];
                }
                stringArray2 = ConvertUnit.appendArray(stringArray2, stringArray3);
            }
        }
        if (stringArray2 != null) {
            int n4 = 0;
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.print("Converting " + stringArray2[n]);
                try {
                    File file2 = new File(stringArray2[n]);
                    JetCReader jetCReader = new JetCReader(file2.getPath(), true);
                    jetCReader.readHeader(stringArray2[n]);
                    int n5 = jetCReader.getBuildNumber();
                    if (n5 >= 501 || n3 == 96) continue;
                    JRObjectTemplate.setDefaultResolution(n3);
                    LoaderNoCache loaderNoCache = new LoaderNoCache(file2.getParent(), file2.getName());
                    loaderNoCache.setEditable(true);
                    object = loaderNoCache.loadNoInit();
                    if (!(object instanceof JetRptReportPanel)) continue;
                    JRObjectTemplate.setDefaultResolution(96);
                    JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)object;
                    ReportLoader.save(null, jetRptReportPanel, jetRptReportPanel.getInstName(), stringArray2[n]);
                    ++n4;
                    System.out.println("\t\tOk!");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("\t\tError!");
                    System.out.println("Cannot convert the file " + stringArray2[n] + ", because of " + exception);
                    if (!SEDU.isErrorEnabled()) continue;
                    SEDU.error("", exception);
                }
            }
            System.out.println("\n" + n4 + " reports Converted.");
        }
        System.exit(0);
    }

    public static String[] appendArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        int n = stringArray.length + stringArray2.length;
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }
}

