/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.io.File;
import jet.Env;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReportLoader;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.WildcardMatcher;

public class EvlConverter {
    private static JRLogger SEDU = JRLogger.getLogger(EvlConverter.class.getName());

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length == 1 && (stringArray[0].equals("/?") || stringArray[0].equals("-?") || stringArray[0].equalsIgnoreCase("/help") || stringArray[0].equalsIgnoreCase("-help"))) {
            System.out.println("java -Dreporthome=<drive>:<path> jet.report.EvlConverter ");
            System.out.println("  [[drive:][path][filename] +]");
            System.out.println("\t[drive:][path][filename]");
            System.out.println("\t\tSpecifies drive, directory, and/or files to list.");
            System.out.println("\t\tDefault is *.cls.");
            System.out.println("\t\tSeparates by space.");
            System.exit(0);
        }
        ReportEnv.checkEnv(new Object(), null, 0);
        if (ReportEnv.ie()) {
            System.out.println("Your version is a evaluation version.");
            System.exit(0);
        }
        JRLoggingUtil.configLog(null);
        String[] stringArray2 = null;
        String string = System.getProperty("user.dir");
        if (stringArray.length == 0) {
            file = new File(string);
            stringArray2 = file.list(new WildcardMatcher("*.cls", false));
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = string + File.separator + stringArray2[i];
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray3;
                file = new File(stringArray[i]);
                String string2 = file.getName();
                if (string2.indexOf("*") == -1 && string2.indexOf("?") == -1) {
                    stringArray3 = new String[]{string2};
                } else {
                    stringArray3 = file.list(new WildcardMatcher(string2, false));
                    if (stringArray3 == null) continue;
                }
                for (int j = 0; j < stringArray3.length; ++j) {
                    String string3 = file.getParent();
                    if (string3 == null) {
                        string3 = string;
                    }
                    stringArray3[j] = string3 + File.separator + stringArray3[j];
                }
                stringArray2 = EvlConverter.appendArray(stringArray2, stringArray3);
            }
        }
        if (stringArray2 != null) {
            JetObject jetObject = null;
            int n = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.print("Converting " + stringArray2[i]);
                try {
                    File file2 = new File(stringArray2[i]);
                    LoaderNoCache loaderNoCache = new LoaderNoCache(file2.getParent(), file2.getName());
                    loaderNoCache.setEditable(true);
                    jetObject = loaderNoCache.loadNoInit();
                    int n2 = EvlConverter.appendArray(jetObject);
                    int n3 = EvlConverter.append(jetObject);
                    if (jetObject.getInstNameDirectly().equals("")) {
                        String string4 = file2.getName();
                        jetObject.setInstNameDirectly(Env.getFileName(string4, 6));
                    }
                    EvlConverter.SEDU(jetObject, null);
                    if (n2 != EvlConverter.appendArray(jetObject) || n3 != EvlConverter.append(jetObject)) {
                        ReportLoader.save(null, jetObject, jetObject.getInstName(), stringArray2[i]);
                        ++n;
                        System.out.println("\t\tOk!");
                        continue;
                    }
                    System.out.println("\t\tPassed!");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("\t\tError!");
                    System.out.println("Cannot convert the file " + stringArray2[i] + ", because of " + exception);
                    exception.printStackTrace();
                    if (!SEDU.isErrorEnabled()) continue;
                    SEDU.error("", exception);
                }
            }
            System.out.println(n + " reports Converted.");
        }
        System.exit(0);
    }

    private static void SEDU(JetObject jetObject, JetUUniverse jetUUniverse) {
        if (jetObject instanceof JetRptReportPanel) {
            ((JetRptReportPanel)jetObject).beforeSave(jetUUniverse, null);
        } else if (jetObject instanceof JetRptReportSet) {
            ((JetRptReportSet)jetObject).beforeSave(jetUUniverse, null);
        }
    }

    private static int append(JetObject jetObject) {
        if (jetObject instanceof JetRptReportPanel) {
            return ((JetRptReportPanel)jetObject).restrict.get();
        }
        if (jetObject instanceof JetRptReportSet) {
            return ((JetRptReportSet)jetObject).restrict.get();
        }
        return -1;
    }

    private static int appendArray(JetObject jetObject) {
        if (jetObject instanceof JetRptReportPanel) {
            return ((JetRptReportPanel)jetObject).key.get();
        }
        if (jetObject instanceof JetRptReportSet) {
            return ((JetRptReportSet)jetObject).key.get();
        }
        return -1;
    }

    public static boolean convertReports(String[] stringArray) {
        boolean bl = true;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            String[] stringArray2 = null;
            File file = new File(string);
            if (string.endsWith("*.rpt")) {
                string = string.substring(0, string.length() - 5);
                file = new File(string);
                stringArray2 = file.list(new WildcardMatcher("*.rpt", false));
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = string + stringArray2[j];
                }
            } else if (string.endsWith("*.cls")) {
                string = string.substring(0, string.length() - 5);
                file = new File(string);
                stringArray2 = file.list(new WildcardMatcher("*.cls", false));
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = string + stringArray2[j];
                }
            } else if (string.endsWith("*.*")) {
                string = string.substring(0, string.length() - 3);
                file = new File(string);
                stringArray2 = file.list(new WildcardMatcher("*.cls", false));
                String[] stringArray3 = file.list(new WildcardMatcher("*.rpt", false));
                String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
                System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
                System.arraycopy(stringArray3, 0, stringArray4, stringArray2.length, stringArray3.length);
                stringArray2 = stringArray4;
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = string + stringArray2[j];
                }
            } else if (file.isDirectory()) {
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                stringArray2 = file.list(new WildcardMatcher("*.cls", false));
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = string + stringArray2[j];
                }
            } else {
                stringArray2 = new String[]{string};
            }
            if (stringArray2 != null && stringArray2.length != 0) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    try {
                        File file2 = new File(stringArray2[j]);
                        LoaderNoCache loaderNoCache = new LoaderNoCache(file2.getParent(), file2.getName());
                        loaderNoCache.setEditable(true);
                        JetObject jetObject = loaderNoCache.loadNoInit();
                        int n = EvlConverter.appendArray(jetObject);
                        int n2 = EvlConverter.append(jetObject);
                        EvlConverter.SEDU(jetObject, null);
                        if (n != EvlConverter.appendArray(jetObject) || n2 != EvlConverter.append(jetObject)) {
                            ReportLoader.save(null, jetObject, jetObject.getInstName(), stringArray2[j]);
                            System.out.println(stringArray2[j] + " Convert Ok!");
                            continue;
                        }
                        System.out.println(stringArray2[j] + " Passed!");
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Cannot convert the file " + stringArray2[j] + ", because of " + exception);
                        bl = false;
                    }
                }
                continue;
            }
            if (stringArray2 != null && stringArray2.length != 0) continue;
            bl = false;
        }
        return bl;
    }

    public static String[] appendArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        int n = stringArray.length + stringArray2.length;
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }
}

