/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import jet.icontrols.QueryInfo;
import jet.ireport.IReport;
import jet.naming.ClassType;
import jet.report.IDispNamePrefixCreator;
import jet.report.JetRptArea;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.report.JetRptCTAggField;
import jet.report.JetRptDBField;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMap;
import jet.report.JetRptMapTextField;
import jet.report.JetRptObject;
import jet.report.JetRptParamForm;
import jet.report.JetRptParameterField;
import jet.report.JetRptPolyLine;
import jet.report.JetRptRefParameterField;
import jet.report.JetRptSection;
import jet.report.JetRptSliderCtrl;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.report.gmap.JetRptGMap;
import jet.report.gmap.JetRptGMarker;
import jet.report.navigation.JetRptNavigation;
import jet.report.navigation.JetRptNavigationItem;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.report.table.JetRptTableCell;
import jet.report.table.JetRptTableColGroup;
import jet.report.table.JetRptTableColumn;
import jet.report.table.JetRptTableGroup;
import jet.report.table.JetRptTableGroupFooter;
import jet.report.table.JetRptTableGroupHeader;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

class JRDisplayPrefixCreator
implements IDispNamePrefixCreator {
    private static final String SEDU = "Label";
    private static final String append = "Rank";
    private static final String blColumnName = "Barcode";
    private static final String get = "Image";
    private static final String getBLName = "CheckBox";
    private static final String getBLNodeByQualifiedDisplayName = "RadioButton";
    private static final String getBusinessView = "Button";
    private static final String getByDisplayName = "ImageButton";
    private static final String getClass = "TextField";
    private static final String getClassTagByClassName = "TextArea";
    private static final String getColumnName = "List";
    private static final String getCurrentUsedRenderer = "DropDownList";
    private static JRDisplayPrefixCreator getDataResoureType = null;

    JRDisplayPrefixCreator() {
    }

    protected static JRDisplayPrefixCreator getInstance() {
        if (getDataResoureType == null) {
            getDataResoureType = new JRDisplayPrefixCreator();
        }
        return getDataResoureType;
    }

    @Override
    public String createDisplayPrefix(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, JetRptObject jetRptObject) {
        String string = ClassType.getClassTagByClassName(jetRptObject.getClass().getName());
        if (jetRptObject instanceof JetRptTextField) {
            if (jetRptObject instanceof JetRptAreaText) {
                string = this.SEDU((JetRptAreaText)jetRptObject, string);
            } else if (jetRptObject instanceof JetRptMapTextField) {
                string = "Global Label";
            } else {
                int n = ((JetRptTextField)jetRptObject).getCurrentUsedRenderer().getRenderType();
                string = this.blColumnName(n);
            }
        } else if (jetRptObject instanceof JetRptDBField || jetRptObject instanceof JetRptParameterField) {
            string = this.get(jetUUniverse, iReport, queryInfo, jetRptObject);
        } else if (jetRptObject instanceof JetRptSystemField) {
            string = this.append((JetRptSystemField)jetRptObject, string);
        } else if (jetRptObject instanceof JetRptArea) {
            string = ((JetRptArea)jetRptObject).name.get();
        } else if (jetRptObject instanceof JetRptPolyLine) {
            string = "Line";
        } else if (jetRptObject instanceof JetRptTableColGroup) {
            string = "TableColumns";
        } else if (jetRptObject instanceof JetRptTableColumn) {
            JetRptTableColumn jetRptTableColumn = (JetRptTableColumn)jetRptObject;
            int n = jetRptTableColumn.getTableColumnType();
            if (n == 1) {
                string = "CommonColumn";
            } else if (n == 2) {
                string = "DetailColumn";
            } else if (n == 3) {
                string = "GroupColumn";
            } else if (n == 4) {
                string = "SummaryColumn";
            }
        } else if (jetRptObject instanceof JetRptNavigation) {
            string = "NavigationControl";
        } else if (jetRptObject instanceof JetRptNavigationItem) {
            string = getBusinessView;
        } else if (jetRptObject instanceof JetRptParamForm) {
            string = "ParameterFormControl";
        } else if (jetRptObject instanceof JetRptRefParameterField) {
            string = "ParameterControl";
        } else if (jetRptObject instanceof JetRptSliderCtrl) {
            string = "Slider";
        } else if (jetRptObject instanceof JetRptMap) {
            string = "ShapeMap";
        } else if (jetRptObject instanceof JetRptGMap) {
            string = "GeographicMap";
        } else if (jetRptObject instanceof JetRptGMarker) {
            string = "GMarker";
        }
        return string;
    }

    private String SEDU(JetRptObject jetRptObject, String string) {
        if (jetRptObject.getParent() instanceof JetRptArea) {
            JetRptArea jetRptArea = (JetRptArea)jetRptObject.getParent();
            string = "Label for " + jetRptArea.name.get();
        }
        return string;
    }

    private String append(JetRptSystemField jetRptSystemField, String string) {
        if (jetRptSystemField.getFieldType() == 9) {
            JetRptObject jetRptObject;
            JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptSystemField.getParent());
            if (jetRptObject2 instanceof JetRptSection) {
                JetRptSection jetRptSection = (JetRptSection)jetRptObject2;
                if (jetRptSection.getParent() instanceof JetRptGroupPanel && !(jetRptSection instanceof JetRptDetailPanel)) {
                    string = ((JetRptGroupPanel)jetRptSection.getParent()).groupBy.get();
                }
            } else if (jetRptObject2 instanceof JetRptTableCell && (jetRptObject2.getParent() instanceof JetRptTableGroupFooter || jetRptObject2.getParent() instanceof JetRptTableGroupHeader) && (jetRptObject = (JetRptObject)((Object)((JetRptObject)((Object)jetRptObject2.getParent())).getParent())) instanceof JetRptTableGroup) {
                string = ((JetRptTableGroup)jetRptObject).groupBy.get();
            }
        }
        if (string == null || string.isEmpty()) {
            string = jetRptSystemField.getInstancePrefix();
        }
        return string;
    }

    private String blColumnName(int n) {
        switch (n) {
            case 0: {
                return SEDU;
            }
            case 1: {
                return append;
            }
            case 2: {
                return blColumnName;
            }
            case 3: {
                return get;
            }
            case 6: {
                return getBLName;
            }
            case 7: {
                return getBLNodeByQualifiedDisplayName;
            }
            case 11: 
            case 12: 
            case 13: {
                return getBusinessView;
            }
            case 10: {
                return getByDisplayName;
            }
            case 4: {
                return getClass;
            }
            case 5: {
                return getClassTagByClassName;
            }
            case 8: {
                return getColumnName;
            }
            case 9: {
                return getCurrentUsedRenderer;
            }
        }
        return SEDU;
    }

    private String get(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptDBField) {
            if (jetRptObject instanceof JetRptCTAggField) {
                String string = "";
                string = ((JetRptCTAggField)jetRptObject).getUseTypeValue() == 2 ? ((JetRptCTAggField)jetRptObject).getUsedCTFDispName() : ((JetRptCTAggField)jetRptObject).getColumnName();
                return this.getBLNodeByQualifiedDisplayName(jetUUniverse, iReport, queryInfo, ((JetRptCTAggField)jetRptObject).blColumnName.get(), string);
            }
            if (jetRptObject instanceof JetRptAreaDBText) {
                String string = ClassType.getClassTagByClassName(jetRptObject.getClass().getName());
                return this.getBLName(jetUUniverse, iReport, queryInfo, (JetRptAreaDBText)jetRptObject, string);
            }
            return this.getBLNodeByQualifiedDisplayName(jetUUniverse, iReport, queryInfo, ((JetRptDBField)jetRptObject).blColumnName.get(), ((JetRptDBField)jetRptObject).getColumnName());
        }
        if (jetRptObject instanceof JetRptParameterField) {
            String string = ((JetRptParameterField)jetRptObject).sNParameter;
            if (string == null || string.isEmpty()) {
                string = ClassType.getClassTagByClassName(jetRptObject.getClass().getName());
            }
            return string;
        }
        return ClassType.getClassTagByClassName(jetRptObject.getClass().getName());
    }

    private String getBLName(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, JetRptAreaDBText jetRptAreaDBText, String string) {
        if (jetRptAreaDBText.getParent() instanceof JetRptArea) {
            JetRptArea jetRptArea = (JetRptArea)jetRptAreaDBText.getParent();
            string = this.getBLNodeByQualifiedDisplayName(jetUUniverse, iReport, queryInfo, jetRptAreaDBText.blColumnName.get(), jetRptAreaDBText.getColumnName()) + " for " + jetRptArea.name.get();
        }
        return string;
    }

    private String getBLNodeByQualifiedDisplayName(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, String string, String string2) {
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet;
        if (string == null || queryInfo == null || queryInfo.getDataResoureType() != 2) {
            return string2;
        }
        BLNode bLNode = null;
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet2 = jetRptFlyFormulaMeasureSet = iReport != null ? iReport.getFlyFormulaMeasureSet(queryInfo) : null;
        if (jetRptFlyFormulaMeasureSet != null) {
            bLNode = jetRptFlyFormulaMeasureSet.getBLNodeByQualifiedDisplayName(string);
        }
        if (bLNode == null) {
            UnifiedBusinessView unifiedBusinessView;
            JetUDatabase jetUDatabase;
            JetUDatabase jetUDatabase2 = jetUDatabase = jetUUniverse != null ? jetUUniverse.getDatabase(queryInfo.getDatasourceName()) : null;
            if (jetUDatabase != null && (unifiedBusinessView = jetUDatabase.getBusinessView(queryInfo.getBLName())) != null) {
                bLNode = unifiedBusinessView.getByDisplayName(string);
            }
        }
        return bLNode != null ? bLNode.getDisplayName() : string2;
    }
}

