/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import com.jinfonet.util.JRLog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import jet.controls.JetColumnable;
import jet.controls.JetCustomerProperty;
import jet.controls.JetObject;
import jet.report.SubReportLinks;
import jet.report.link.URLPattern;

public class JetLink
extends JetCustomerProperty
implements JetColumnable {
    public static final int LINK_TYPE_REPORT = 0;
    public static final int LINK_TYPE_URL = 1;
    public static final int LINK_TYPE_FILTER = 2;
    public static final int LINK_TYPE_MAIL = 3;
    public static final String RPTPREFIX = "0:";
    public static final String URLPREFIX = "1:";
    public static final String FLTPREFIX = "2:";
    public static final String MAILPREFIX = "3:";

    public JetLink() {
        this.value = new SubReportLinks(this);
    }

    public JetLink(JetObject jetObject, String string) {
        super(jetObject, string);
        this.value = new SubReportLinks(this);
    }

    public int getLinkType() {
        return ((SubReportLinks)this.value).getLinkType();
    }

    public void setLinkType(int n) {
        ((SubReportLinks)this.value).setLinkType(n);
    }

    @Override
    public String toString() {
        return ((SubReportLinks)this.value).getAsUnitString();
    }

    @Override
    public String getInspValue() {
        switch (this.getLinkType()) {
            case 0: 
            case 2: {
                String string = this.getFileName();
                return string == null ? "" : string;
            }
            case 1: 
            case 3: {
                StringBuilder stringBuilder = new StringBuilder();
                List list = ((SubReportLinks)this.value).getURLPatternList();
                int n = list == null ? 0 : list.size();
                for (int i = 0; i < n; ++i) {
                    URLPattern uRLPattern = (URLPattern)list.get(i);
                    if (uRLPattern.getPatternType() == 1) {
                        stringBuilder.append(this.SEDU(uRLPattern.getPatternValue()));
                        continue;
                    }
                    if (uRLPattern.getPatternType() == 2) {
                        stringBuilder.append("<");
                        String string = uRLPattern.getBLPatternValue();
                        if (string == null || string.isEmpty()) {
                            string = uRLPattern.getPatternValue();
                        }
                        if (string != null && string.length() > 0) {
                            stringBuilder.append(this.SEDU(string));
                        }
                        stringBuilder.append(">");
                        continue;
                    }
                    if (uRLPattern.getPatternType() == 4) {
                        stringBuilder.append(this.SEDU(uRLPattern.getPatternValue()));
                        continue;
                    }
                    stringBuilder.append("${d*_^").append(uRLPattern.getPatternValue()).append("}");
                }
                return stringBuilder.toString();
            }
            case 6: {
                return "Link to Content";
            }
        }
        return "";
    }

    private String SEDU(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = string.indexOf(60)) >= 0) {
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append("\\<");
            string = string.substring(n + 1);
        }
        stringBuilder.append(string);
        string = stringBuilder.toString();
        stringBuilder.setLength(0);
        while ((n = string.indexOf(62)) >= 0) {
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append("\\>");
            string = string.substring(n + 1);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void set(SubReportLinks subReportLinks) {
        if (subReportLinks == null) {
            this.value = new SubReportLinks(this);
        } else {
            this.value = subReportLinks;
            ((SubReportLinks)this.value).setOwner(this);
        }
    }

    @Override
    public void set(String string) {
        Object object = this.value;
        this.value = new SubReportLinks(this);
        if (string != null) {
            ((SubReportLinks)this.value).setAsUnitString(string);
        }
        this.isnull = false;
        this.propertyChanged(new PropertyChangeEvent(this, this.getName(), object, this.value));
        this.propertyChanged();
    }

    @Override
    public byte[] toByteArray() {
        try {
            return this.toString().getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    @Override
    public void setByteArray(byte[] byArray) {
        if (byArray == null) {
            this.set("");
        } else if (byArray.length > 2 && byArray[0] == -2 && byArray[1] == -1) {
            try {
                this.set(new String(byArray, "UTF-16"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.set(new String(byArray));
            }
        } else {
            this.set(new String(byArray));
        }
    }

    @Override
    public PropertyEditor getEditor() {
        try {
            PropertyEditor propertyEditor = (PropertyEditor)Class.forName("jet.report.ide.dialog.LinkPanel").newInstance();
            propertyEditor.setValue(((SubReportLinks)this.value).cloneIt());
            return propertyEditor;
        }
        catch (Exception exception) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6200000, (Throwable)exception);
            }
            return null;
        }
    }

    public SubReportLinks getLink() {
        return (SubReportLinks)this.value;
    }

    @Override
    public Object getValue() {
        return ((SubReportLinks)this.value).cloneIt();
    }

    @Override
    public Object getObject() {
        return this.getValue();
    }

    public boolean linkReport() {
        int n = this.getLinkType();
        return n == 0 || n == 2;
    }

    public boolean isEmpty() {
        return ((SubReportLinks)this.value).isEmptyLinkURN();
    }

    public boolean isFiltered() {
        return this.getLinkType() == 2;
    }

    @Override
    public int getPropType() {
        return 13;
    }

    public List getURLColumnNames() {
        Vector<String> vector = new Vector<String>();
        List list = ((SubReportLinks)this.value).getURLPatternList();
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            String string;
            URLPattern uRLPattern = (URLPattern)list.get(i);
            if (uRLPattern.getPatternType() != 2 || (string = uRLPattern.getPatternValue()) == null || string.isEmpty() || vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    public List getURLBLColumnNames() {
        Vector<String> vector = new Vector<String>();
        List list = ((SubReportLinks)this.value).getURLPatternList();
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            String string;
            URLPattern uRLPattern = (URLPattern)list.get(i);
            if (uRLPattern.getPatternType() != 2 || (string = uRLPattern.getBLPatternValue()) == null || string.isEmpty() || vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    public List getURLPatternList() {
        return ((SubReportLinks)this.value).getURLPatternList();
    }

    public String getFileName() {
        return ((SubReportLinks)this.value).getFileName();
    }

    public String getRptInstName() {
        return ((SubReportLinks)this.value).getInstName();
    }

    public String getRptViewName() {
        return ((SubReportLinks)this.value).getViewName();
    }

    public List getParamLinks() {
        return ((SubReportLinks)this.value).getLinks();
    }

    public void setURLPatternList(List list) {
        ((SubReportLinks)this.value).setURLPatternList(list);
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof SubReportLinks) {
            this.set((SubReportLinks)object);
        } else {
            super.setObject(object);
        }
    }
}

