/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetBigString;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetMultiValue;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.datastream.DSTemplatible;
import jet.report.JetLink;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.report.JetRptBorderStyle;
import jet.report.JetRptDataContainer;
import jet.report.JetRptLineWidth;
import jet.report.JetRptMap;
import jet.report.conditionallink.JetRptConditionalLinkList;
import jet.report.link.ConditionalLinkValue;
import jet.report.link.JetLinkProperties;
import jet.report.link.Linkable;
import jet.report.link.LinkableSetAPI;
import jet.report.link.SimpleLinkValue;
import jet.util.HashVector;
import jet.util.MapUtil;

public class JetRptArea
extends JetRptDataContainer
implements Linkable {
    public static final int RECTANGLE = 1;
    public static final int CIRCLE = 2;
    public static final int POLYGON = 3;
    public static final int EDIT_CANRECOORD = 0;
    private static final int SEDU = 1;
    private static final int Z = 2;
    private static final int add = 3;
    private static final int addItem = 4;
    public JetString name;
    public JetString alt;
    public JetColor fillColor;
    public JetEnumeration type;
    public JetBigString coords;
    public JetRptLineWidth boundaryWidth;
    public JetColor boundaryColor;
    public JetRptBorderStyle boundaryStyle;
    private JetString afterInit;
    private JetString black;
    private JetNumber booleanValue;
    private JetString conditionLink;
    private JetBoolean contains;
    public JetString coordParts;
    private JetMultiValue convertUnitToPixel;
    public JetLinkProperties linkProps;
    private static HashSet duplicatePropGrpsDesc = new HashSet();
    private static HashMap elementAt;
    private static HashVector equals;

    public JetRptArea() {
        this.SEDU();
        this.setObjectType(41);
    }

    @Override
    public void afterInit() {
        super.afterInit();
    }

    @Override
    public String getInstancePrefix() {
        if (this.name.get().length() > 0) {
            return this.name.get();
        }
        return "Area";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Area");
    }

    public int[][] parseShape() {
        int[][] nArray = this.parseShapeInUnit();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray[i][j] = Unit.convertUnitToPixel(nArray[i][j]);
            }
        }
        return nArray;
    }

    public int[][] parseShapeInUnit() {
        return MapUtil.parseAreaShapeCoordinate(this.type.intValue(), this.coords.get(), this.coordParts.get());
    }

    public boolean getCoordinateEditable(int n) {
        return this.convertUnitToPixel.isSelected(n);
    }

    public boolean isDefaultTypeArea() {
        return this.type.intValue() == 0;
    }

    @Override
    public DSTemplatible getBasedArea() {
        JetObject jetObject = (JetObject)((Object)this.getParent());
        if (jetObject instanceof JetRptMap) {
            Vector vector = jetObject.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof JetRptArea)) continue;
                JetRptArea jetRptArea = (JetRptArea)vector.elementAt(i);
                if (jetRptArea.type.intValue() != 0) continue;
                return jetRptArea;
            }
        }
        return null;
    }

    @Override
    public Hashtable getDefaultProperties() {
        JetRptArea jetRptArea = null;
        jetRptArea = this.isDefaultTypeArea() ? this : (JetRptArea)this.getBasedArea();
        if (jetRptArea == null) {
            return null;
        }
        return jetRptArea.getAreaDefSettings();
    }

    public Hashtable getAreaDefSettings() {
        if (this.isDefaultTypeArea()) {
            Hashtable<String, JetProperty> hashtable = new Hashtable<String, JetProperty>(this.getProperties().size());
            for (String string : JetRptArea.getUseDefaultCtrlPropNames()) {
                hashtable.put(string, this.nameToProperty(string));
            }
            return hashtable;
        }
        throw new IllegalAccessError();
    }

    public void forbidenEditOnProps() {
    }

    public static List getUseDefaultCtrlPropNames() {
        Vector<String> vector = new Vector<String>();
        if (equals == null) {
            JetRptArea jetRptArea = new JetRptArea();
            jetRptArea.setEditable();
            jetRptArea.Z();
            jetRptArea.fullDestory();
        }
        for (int i = 0; i < equals.size(); ++i) {
            String string = (String)equals.get(i);
            if (string.equals("Shape") || string.equals("General")) continue;
            List list = (List)equals.get(string);
            for (int j = 0; j < list.size(); ++j) {
                String string2 = (String)list.get(j);
                if (duplicatePropGrpsDesc.contains(string2)) continue;
                vector.add(string2);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public JetRptAreaText getAreaText() {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptAreaText)) continue;
            return (JetRptAreaText)vector.elementAt(i);
        }
        return null;
    }

    public JetRptAreaDBText[] getAllAreaDBTexts() {
        Vector<JetRptAreaDBText> vector = new Vector<JetRptAreaDBText>();
        Vector vector2 = this.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            if (!(vector2.elementAt(i) instanceof JetRptAreaDBText)) continue;
            vector.add((JetRptAreaDBText)vector2.elementAt(i));
        }
        return vector.toArray(new JetRptAreaDBText[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (elementAt == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (elementAt == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Name", n++);
                    hashMap.put("Alt", n++);
                    hashMap.put("FillColor", n++);
                    hashMap.put("Type", n++);
                    hashMap.put("Coordinates", n++);
                    hashMap.put("BoundaryWidth", n++);
                    hashMap.put("BoundaryColor", n++);
                    hashMap.put("BoundaryStyle", n++);
                    hashMap.put("ExternalAccessKey", n++);
                    hashMap.put("HrefLang", n++);
                    hashMap.put("ExternalTabIndex", n++);
                    hashMap.put("ExternalTitle", n++);
                    hashMap.put("CoordParts", n++);
                    hashMap.put("CoordEditable", n++);
                    hashMap.put("UseDefault", n++);
                    n = JetLinkProperties.fillIndecialMap(hashMap);
                    elementAt = hashMap;
                }
            }
        }
        return elementAt;
    }

    private void SEDU() {
        this.name = new JetString(this, "Name");
        this.alt = new JetString(this, "Alt");
        this.fillColor = new JetColor(this, "FillColor", null, true);
        this.type = new JetEnumeration(this, "Type", 8);
        this.coords = new JetBigString(this, "Coordinates");
        this.boundaryWidth = new JetRptLineWidth(this, "BoundaryWidth");
        this.boundaryColor = new JetColor(this, "BoundaryColor", Color.black);
        this.boundaryStyle = new JetRptBorderStyle(this, "BoundaryStyle");
        this.afterInit = new JetString(this, "ExternalAccessKey");
        this.black = new JetString(this, "HrefLang");
        this.booleanValue = new JetNumber(this, "ExternalTabIndex");
        this.conditionLink = new JetString(this, "ExternalTitle");
        this.type.set(1);
        this.boundaryStyle.set(1);
        this.boundaryWidth.setCanChangeByOthers(true);
        this.boundaryStyle.setCanChangeByOthers(true);
        this.coords.setEditFlag(0);
        this.type.setEditFlag(0);
        this.contains = new JetBoolean(this, "UseDefault");
        this.contains.setCanChangeByBL(false);
        this.contains.setCanChangeByFmtt(false);
        this.contains.setCanChangeByOthers(false);
        this.coordParts = new JetString(this, "CoordParts", "0");
        this.coordParts.setCanChangeByBL(false);
        this.coordParts.setCanChangeByFmtt(false);
        this.coordParts.setCanChangeByOthers(false);
        this.coordParts.setEditFlag(0);
        this.convertUnitToPixel = new JetMultiValue(this, "CoordEditable");
        this.convertUnitToPixel.addItem(0, true);
        this.convertUnitToPixel.addItem(1, true);
        this.convertUnitToPixel.addItem(2, true);
        this.convertUnitToPixel.addItem(3, true);
        this.convertUnitToPixel.addItem(4, true);
        this.convertUnitToPixel.setCanChangeByBL(false);
        this.convertUnitToPixel.setCanChangeByFmtt(false);
        this.convertUnitToPixel.setCanChangeByOthers(false);
        this.convertUnitToPixel.setEditFlag(0);
        this.linkProps = new JetLinkProperties(this);
        this.linkProps.linkURLTargetFrame.set(4);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (this.type.intValue() == 0) {
                HashVector hashVector = JetRptArea.duplicatePropGrpsDesc(this.Z());
                List list = (List)hashVector.get("Area");
                list.remove("Name");
                hashVector.remove("General");
                hashVector.remove("Shape");
                return hashVector;
            }
            return this.Z();
        }
        return null;
    }

    private HashVector Z() {
        if (this.bEditable) {
            if (equals != null) {
                return equals;
            }
            equals = JetRptArea.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (equals == null) {
                equals = new HashVector();
            }
            String string = "CSS";
            equals.remove(string);
            string = "Others";
            equals.remove(string);
            string = "Geometry";
            equals.remove(string);
            string = "Color";
            equals.remove(string);
            string = "Excel";
            equals.remove(string);
            string = "Border";
            equals.remove(string);
            string = "Area";
            List<String> list = new Vector<String>(4);
            list.add("Name");
            list.add("Alt");
            list.add("DetailReport");
            list.add("Link");
            list.add("FillColor");
            equals.put(string, list);
            string = "Shape";
            list = new Vector(2);
            list.add("Type");
            list.add("Coordinates");
            equals.put(string, list);
            string = "Boundary";
            list = new Vector(3);
            list.add("BoundaryWidth");
            list.add("BoundaryColor");
            list.add("BoundaryStyle");
            equals.put(string, list);
            string = "Accessibility";
            list = (List)equals.get(string);
            list.add("ExternalAccessKey");
            list.add("HrefLang");
            list.add("ExternalTabIndex");
            list.add("ExternalTitle");
            equals.remove(string);
            equals.put(string, list);
            string = "General";
            list = new Vector(1);
            list.add("UseDefault");
            equals.put(string, list);
            return equals;
        }
        return null;
    }

    public JetLinkProperties getUsedJetLinkProperties() {
        if (this.type.intValue() == 0 || !this.contains.booleanValue()) {
            return this.linkProps;
        }
        JetRptArea jetRptArea = (JetRptArea)this.getBasedArea();
        if (jetRptArea == null) {
            return this.linkProps;
        }
        return jetRptArea.linkProps;
    }

    @Override
    public JetLink getLinkProperty() {
        return this.getUsedJetLinkProperties().link;
    }

    @Override
    public boolean isLinkable() {
        return !this.getUsedJetLinkProperties().link.isEmpty();
    }

    @Override
    public boolean isSupportNormalLink() {
        return this.getUsedJetLinkProperties().isSupportNormalLink();
    }

    @Override
    public boolean isSupportMasterDetailLink() {
        return this.getUsedJetLinkProperties().isSupportMasterDetailLink();
    }

    @Override
    public boolean isSupportConditionalLink() {
        return this.getUsedJetLinkProperties().isSupportConditionalLink();
    }

    @Override
    public boolean isEnableConditionalLink() {
        return this.getUsedJetLinkProperties().isEnableConditionalLink();
    }

    @Override
    public ConditionalLinkValue getConditionalLinkValue() {
        return this.getUsedJetLinkProperties().toConditionalLinkValue();
    }

    @Override
    public SimpleLinkValue getSimpleLinkValue() {
        return this.getUsedJetLinkProperties().toSimpleLinkValue();
    }

    @Override
    public boolean isLinkValueEmpty() {
        return this.getUsedJetLinkProperties().isLinkValueEmpty();
    }

    @Override
    public LinkableSetAPI getLinkableSetor() {
        return this.getUsedJetLinkProperties();
    }

    public JetRptConditionalLinkList getConditionalLinkObject() {
        return (JetRptConditionalLinkList)this.getUsedJetLinkProperties().conditionLink.getObject();
    }

    static {
        duplicatePropGrpsDesc.add("Name");
        duplicatePropGrpsDesc.add("Coordinates");
        duplicatePropGrpsDesc.add("UseDefault");
        duplicatePropGrpsDesc.add("Type");
        elementAt = null;
        equals = null;
    }
}

