/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import barcode.linearBarcode.BarcodeConstraints;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetBoolean;
import jet.controls.JetColumnName;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.report.JetRptDBField;
import jet.report.JetRptParameterField;
import jet.util.FontSets;
import jet.util.HashVector;

public class JetRptBarcode
extends JetRptDBField {
    public JetNumber barheight;
    public JetEnumeration bar128;
    public JetNumber narrowwidth;
    public JetBoolean hrdisplay;
    public JetString message;
    public JetNumber ratio;
    public JetBoolean checkenable;
    public JetNumber quietzone;
    public JetEnumeration symbology;
    public JetString supplement;
    public JetEnumeration scalemode;
    public JetString displayNull;
    public JetColumnName param;
    public JetBoolean paramdatasource;
    public JetNumber orientation;
    public JetBoolean useDefaultMessage;
    private BarcodeConstraints SEDU = new BarcodeConstraints();
    private static HashMap Z = null;
    private static HashVector add = null;

    public JetRptBarcode() {
        this.SEDU();
        this.setObjectType(264);
        this.sNFormat = "";
    }

    public JetRptBarcode(JetObject jetObject, BarcodeConstraints barcodeConstraints) {
        this();
        JetRptBarcode.copyProperties(this, jetObject);
        this.bar128.set(barcodeConstraints.getBar128Type());
        this.checkenable.set(barcodeConstraints.getBarCheckEnable());
        this.narrowwidth.set(barcodeConstraints.getBarNarrowWidth());
        this.message.set(barcodeConstraints.getBarMessage());
        this.quietzone.set(barcodeConstraints.getBarQuietZone());
        this.ratio.set(barcodeConstraints.getBarRatio());
        this.scalemode.set(barcodeConstraints.getBarScaleMode());
        this.supplement.set(barcodeConstraints.getBarSupplement());
        this.symbology.set(barcodeConstraints.getBarSymbology());
        if (barcodeConstraints.getBarSymbology() != 5) {
            this.bar128.setEditFlag(0);
        }
        this.barheight.set(barcodeConstraints.getBarHeight());
        this.hrdisplay.set(barcodeConstraints.getBarHRDisplay());
        this.orientation.set(barcodeConstraints.getBarOrientation());
        this.SEDU = barcodeConstraints;
        if (jetObject instanceof JetRptParameterField) {
            this.paramdatasource.set(true);
        }
    }

    public Dimension getPreferredSize() {
        String string = this.getProperty("FontFace").toString();
        int n = 0;
        if (((JetBoolean)this.getProperty("Bold")).get()) {
            n = 1;
        }
        if (((JetBoolean)this.getProperty("Italic")).get()) {
            n |= 2;
        }
        int n2 = ((JetNumber)this.getProperty("FontSize")).get();
        if (this.SEDU == null) {
            this.SEDU = new BarcodeConstraints();
            this.SEDU.setBarScaleMode(2);
        }
        this.SEDU.setBarHRFont(FontSets.getFont(string, n, n2));
        this.SEDU.setBar128Type((Integer)this.bar128.get());
        this.SEDU.setBarCheckEnable(this.checkenable.get());
        this.SEDU.setBarNarrowWidth((short)this.narrowwidth.get());
        this.SEDU.setBarMessage(this.message.get());
        this.SEDU.setBarQuietZone((short)this.quietzone.get());
        this.SEDU.setBarRatio(this.ratio.get());
        this.SEDU.setBarScaleMode((Integer)this.scalemode.get());
        this.SEDU.setBarSupplement(this.supplement.get());
        this.SEDU.setBarSymbology((Integer)this.symbology.get());
        this.SEDU.setBarHeight((short)this.barheight.get());
        this.SEDU.setBarHRDisplay(this.hrdisplay.get());
        this.SEDU.setBackground(this.backColor.get());
        this.SEDU.setForeground(super.getForeColor());
        this.SEDU.setBarOrientation(this.orientation.get());
        return this.SEDU.getPreferredSize();
    }

    @Override
    public String getInstancePrefix() {
        return "Barcode";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Barcode");
    }

    public boolean isParamDataSource() {
        return this.paramdatasource.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (Z == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (Z == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Symbology", n++);
                    hashMap.put("ParamDataSource", n++);
                    hashMap.put("NarrowWidth", n++);
                    hashMap.put("CheckEnable", n++);
                    hashMap.put("Message", n++);
                    hashMap.put("UseDefaultMessage", n++);
                    hashMap.put("Supplement", n++);
                    hashMap.put("QuietZone", n++);
                    hashMap.put("Orientation", n++);
                    hashMap.put("Ratio", n++);
                    hashMap.put("ScaleMode", n++);
                    hashMap.put("Bar128Type", n++);
                    hashMap.put("HRDisplay", n++);
                    hashMap.put("BarHeight", n++);
                    hashMap.put("Parameter", n++);
                    Z = hashMap;
                }
            }
        }
        return Z;
    }

    private void SEDU() {
        this.barheight = new JetNumber(this, "BarHeight", 50);
        this.bar128 = new JetEnumeration(this, "Bar128Type", 10);
        this.narrowwidth = new JetNumber(this, "NarrowWidth");
        this.hrdisplay = new JetBoolean(this, "HRDisplay", true);
        this.message = new JetString(this, "Message", "");
        this.ratio = new JetNumber(this, "Ratio", 2);
        this.checkenable = new JetBoolean(this, "CheckEnable", true);
        this.quietzone = new JetNumber(this, "QuietZone");
        this.symbology = new JetEnumeration(this, "Symbology", 92);
        this.supplement = new JetString(this, "Supplement", "");
        this.scalemode = new JetEnumeration(this, "ScaleMode", 11);
        this.param = new JetColumnName(this, "Parameter");
        this.paramdatasource = new JetBoolean(this, "ParamDataSource", false);
        this.orientation = new JetNumber(this, "Orientation", 0);
        this.useDefaultMessage = new JetBoolean(this, "UseDefaultMessage", false);
        this.displayNull = new JetString(this, "DisplayNull");
        this.displayNull.set("invalide");
        this.scalemode.set(2);
        this.checkenable.set(false);
        this.symbology.set(5);
        this.bar128.set(3);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return this.getPropGrpsDescDirectly();
    }

    @Override
    public HashVector getPropGrpsDescDirectly() {
        if (!this.bEditable) {
            return null;
        }
        if (add != null) {
            return add;
        }
        add = JetRptBarcode.duplicatePropGrpsDesc(super.getPropGrpsDescDirectly());
        if (add == null) {
            add = new HashVector();
        }
        String string = "Barcode";
        List list = new Vector<String>(13);
        list.add("BarHeight");
        list.add("NarrowWidth");
        list.add("HRDisplay");
        list.add("Supplement");
        list.add("Orientation");
        list.add("ScaleMode");
        list.add("Message");
        list.add("UseDefaultMessage");
        list.add("Ratio");
        list.add("CheckEnable");
        list.add("QuietZone");
        list.add("Symbology");
        list.add("Bar128Type");
        add.put(string, list);
        string = "TextFormat";
        list = (List)add.get(string);
        list.remove("Format");
        string = "Accessibility";
        list = (List)add.get(string);
        add.remove(string);
        add.put(string, list);
        return add;
    }
}

