/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.Record;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetUnitNumber;
import jet.datastream.JRObjectResult;
import jet.ie.WriterTool;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBorderStyle;
import jet.report.JetRptLineWidth;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.image.ImageProvider;

public abstract class JetRptBox
extends JRObjectTemplate
implements PainterConstants {
    public static final int SHADOW_WIDTH = 3;
    public JetRptLineWidth borderWidth;
    public JetRptBorderStyle top;
    public JetRptBorderStyle bottom;
    public JetRptBorderStyle left;
    public JetRptBorderStyle right;
    public JetColor borderColor;
    public JetColor shadowColor;
    public JetBoolean drawShadow;
    public int iNBorderWidth = Unit.convertPixelToUnit(1);
    public int iNTopLine;
    public int iNBottomLine;
    public int iNLeftLine;
    public int iNRightLine;
    public boolean bNShadow = false;
    public boolean bFShadow = false;
    public boolean bFBorderColor = false;
    public boolean bFShadowColor = false;
    public String cFShadow;
    public String cFBorderColor;
    public String cFShadowColor;
    public Color cNBorderColor = Color.black;
    public Color cNShadowColor = Color.black;
    private boolean BORDERSTYLE_STR_NAMES = false;
    private Hashtable BorderWidth = new Hashtable();
    private static Hashtable BottomLine = new Hashtable();
    public JetUnitNumber topPadding;
    public JetUnitNumber bottomPadding;
    public JetUnitNumber leftPadding;
    public JetUnitNumber rightPadding;
    private static HashMap LeftLine;
    private static HashVector RightLine;

    public JetRptBox() {
        this.BORDERSTYLE_STR_NAMES();
        this.primProSize = (short)(this.primProSize + 8);
        this.iNTopLine = 1;
        this.iNBottomLine = 1;
        this.iNLeftLine = 1;
        this.iNRightLine = 1;
        this.cNShadowColor = Color.black;
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.BORDERSTYLE_STR_NAMES) {
            this.BORDERSTYLE_STR_NAMES = true;
            this.BorderWidth = super.getPrimProp();
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.Shadow), 29);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.BorderWidth), 31);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.TopLine), 33);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.BottomLine), 34);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.LeftLine), 35);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.RightLine), 36);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.BorderColor), 42);
            this.BorderWidth.put(PropertyNames.getDefinitionName(PropertyNames.ShadowColor), 96);
        }
        return this.BorderWidth;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.BorderColor();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.shadowColor != null) {
            String string2 = null;
            int n = 0;
            Integer n2 = (Integer)BottomLine.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch ((Integer)BottomLine.get(string)) {
                case 29: {
                    this.bNShadow = this.drawShadow.get();
                    this.cFShadow = (String)this.drawShadow.getRuntimeChangeBy();
                    boolean bl = this.bFShadow = this.cFShadow != null;
                    if (!this.bFShadow) break;
                    string2 = this.cFShadow;
                    break;
                }
                case 31: {
                    this.iNBorderWidth = this.borderWidth.getUnit();
                    break;
                }
                case 33: {
                    this.iNTopLine = this.top.intValue();
                    break;
                }
                case 34: {
                    this.iNBottomLine = this.bottom.intValue();
                    break;
                }
                case 35: {
                    this.iNLeftLine = this.left.intValue();
                    break;
                }
                case 36: {
                    this.iNRightLine = this.right.intValue();
                    break;
                }
                case 42: {
                    this.cNBorderColor = this.borderColor.get();
                    this.cFBorderColor = (String)this.borderColor.getRuntimeChangeBy();
                    boolean bl = this.bFBorderColor = this.cFBorderColor != null;
                    if (!this.bFBorderColor) break;
                    string2 = this.cFBorderColor;
                    break;
                }
                case 96: {
                    this.cNShadowColor = this.shadowColor.get();
                    this.cFShadowColor = (String)this.shadowColor.getRuntimeChangeBy();
                    boolean bl = this.bFShadowColor = this.cFShadowColor != null;
                    if (!this.bFShadowColor) break;
                    string2 = this.cFShadowColor;
                }
            }
            if (string2 != null) {
                this.addPrimByF(string2, n);
            }
        }
    }

    @Override
    public boolean getShadow(JRObjectResult jRObjectResult) {
        if (!this.bFShadow) {
            return this.bNShadow;
        }
        return jRObjectResult.getBoolean(this.cFShadow, this.bNShadow);
    }

    @Override
    public int getBorderWidth(JRObjectResult jRObjectResult) {
        return this.iNBorderWidth;
    }

    @Override
    public int getTopLine(JRObjectResult jRObjectResult) {
        return this.iNTopLine;
    }

    @Override
    public int getBottomLine(JRObjectResult jRObjectResult) {
        return this.iNBottomLine;
    }

    @Override
    public int getLeftLine(JRObjectResult jRObjectResult) {
        return this.iNLeftLine;
    }

    @Override
    public int getRightLine(JRObjectResult jRObjectResult) {
        return this.iNRightLine;
    }

    @Override
    public Color getBorderColor(JRObjectResult jRObjectResult) {
        if (!this.bFBorderColor) {
            return this.cNBorderColor;
        }
        return jRObjectResult.getColor(this.cFBorderColor, this.cNBorderColor);
    }

    @Override
    public Color getShadowColor(JRObjectResult jRObjectResult) {
        if (!this.bFShadowColor) {
            return this.cNShadowColor;
        }
        return jRObjectResult.getColor(this.cFShadowColor, this.cNShadowColor);
    }

    public boolean getShadow(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFShadow) {
            return this.bNShadow;
        }
        return jRObjectResult.getBoolean(this.cFShadow, record, this.bNShadow);
    }

    public Color getBorderColor(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFBorderColor) {
            return this.cNBorderColor;
        }
        return jRObjectResult.getColor(this.cFBorderColor, record, this.cNBorderColor);
    }

    public Color getShadowColor(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFShadowColor) {
            return this.cNShadowColor;
        }
        return jRObjectResult.getColor(this.cFShadowColor, record, this.cNShadowColor);
    }

    @Override
    public boolean getShadowChBy() {
        return this.bFShadow;
    }

    @Override
    public boolean getBorderWidthChBy() {
        return false;
    }

    @Override
    public boolean getTopLineChBy() {
        return false;
    }

    @Override
    public boolean getBottomLineChBy() {
        return false;
    }

    @Override
    public boolean getLeftLineChBy() {
        return false;
    }

    @Override
    public boolean getRightLineChBy() {
        return false;
    }

    @Override
    public boolean getBorderColorChBy() {
        return this.bFBorderColor;
    }

    @Override
    public boolean getShadowColorChBy() {
        return this.bFShadowColor;
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        if ((Integer)BottomLine.get(string) != null) {
            switch ((Integer)BottomLine.get(string)) {
                case 29: {
                    this.bNShadow = n != 0;
                    bl = true;
                    break;
                }
                case 31: {
                    this.iNBorderWidth = Unit.upgrade(n, n2, true);
                    bl = true;
                }
            }
        } else if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        if ((Integer)BottomLine.get(string) != null) {
            switch ((Integer)BottomLine.get(string)) {
                case 33: {
                    bl = true;
                    boolean bl2 = false;
                    int n = 0;
                    if (n < EnumerationConstant.BORDERSTYLE_STR_NAMES.length) {
                        if (string2.equals(EnumerationConstant.BORDERSTYLE_STR_NAMES[n])) {
                            // empty if block
                        }
                        this.iNTopLine = n;
                        bl2 = true;
                    }
                    if (bl2) break;
                    this.iNTopLine = 0;
                    break;
                }
                case 34: {
                    bl = true;
                    boolean bl3 = false;
                    int n = 0;
                    if (n < EnumerationConstant.BORDERSTYLE_STR_NAMES.length) {
                        if (string2.equals(EnumerationConstant.BORDERSTYLE_STR_NAMES[n])) {
                            // empty if block
                        }
                        this.iNBottomLine = n;
                        bl3 = true;
                    }
                    if (bl3) break;
                    this.iNBottomLine = 0;
                    break;
                }
                case 35: {
                    bl = true;
                    boolean bl4 = false;
                    int n = 0;
                    if (n < EnumerationConstant.BORDERSTYLE_STR_NAMES.length) {
                        if (string2.equals(EnumerationConstant.BORDERSTYLE_STR_NAMES[n])) {
                            // empty if block
                        }
                        this.iNLeftLine = n;
                        bl4 = true;
                    }
                    if (bl4) break;
                    this.iNLeftLine = 0;
                    break;
                }
                case 36: {
                    bl = true;
                    boolean bl5 = false;
                    int n = 0;
                    if (n < EnumerationConstant.BORDERSTYLE_STR_NAMES.length) {
                        if (string2.equals(EnumerationConstant.BORDERSTYLE_STR_NAMES[n])) {
                            // empty if block
                        }
                        this.iNRightLine = n;
                        bl5 = true;
                    }
                    if (bl5) break;
                    this.iNRightLine = 0;
                    break;
                }
                case 42: {
                    bl = true;
                    this.cNBorderColor = MiscTools._mapStringToColor(string2);
                    break;
                }
                case 96: {
                    bl = true;
                    this.cNShadowColor = MiscTools._mapStringToColor(string2);
                }
            }
        } else if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    @Override
    public void setChangeBy(String string, String string2) {
        boolean bl = false;
        int n = 0;
        if ((Integer)BottomLine.get(string) != null) {
            n = (Integer)BottomLine.get(string);
            switch (n) {
                case 29: {
                    this.bFShadow = true;
                    this.cFShadow = string2;
                    bl = true;
                    break;
                }
                case 42: {
                    this.bFBorderColor = true;
                    this.cFBorderColor = string2;
                    bl = true;
                    break;
                }
                case 96: {
                    this.bFShadowColor = true;
                    this.cFShadowColor = string2;
                    bl = true;
                }
            }
        } else if (!bl) {
            super.setChangeBy(string, string2);
        }
        this.addPrimByF(string2, n);
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.Shadow));
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.Shadow), s2);
        }
        WriterTool.writePrimBool(s2, this.bFShadow, this.bNShadow, this.cFShadow, dataOutput);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.BorderWidth), s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNBorderWidth, null, dataOutput, 4);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.TopLine));
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.TopLine), s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNTopLine, null, dataOutput, 3);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.BottomLine));
        if (s2 == null) {
            short s6 = s;
            s = (short)(s + 1);
            s2 = s6;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.BottomLine), s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNBottomLine, null, dataOutput, 3);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.LeftLine));
        if (s2 == null) {
            short s7 = s;
            s = (short)(s + 1);
            s2 = s7;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.LeftLine), s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNLeftLine, null, dataOutput, 3);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.RightLine));
        if (s2 == null) {
            short s8 = s;
            s = (short)(s + 1);
            s2 = s8;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.RightLine), s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNRightLine, null, dataOutput, 3);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.BorderColor));
        if (s2 == null) {
            short s9 = s;
            s = (short)(s + 1);
            s2 = s9;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.BorderColor), s2);
        }
        WriterTool.writePrimColor(s2, this.bFBorderColor, this.cNBorderColor, this.cFBorderColor, dataOutput);
        s2 = (Short)hashVector.get(PropertyNames.getDefinitionName(PropertyNames.ShadowColor));
        if (s2 == null) {
            short s10 = s;
            s = (short)(s + 1);
            s2 = s10;
            hashVector.put(PropertyNames.getDefinitionName(PropertyNames.ShadowColor), s2);
        }
        WriterTool.writePrimColor(s2, this.bFShadowColor, this.cNShadowColor, this.cFShadowColor, dataOutput);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (LeftLine == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (LeftLine == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Shadow", n++);
                    hashMap.put("RightLine", n++);
                    hashMap.put("BottomLine", n++);
                    hashMap.put("padding-bottom", n++);
                    hashMap.put("ShadowColor", n++);
                    hashMap.put("BorderColor", n++);
                    hashMap.put("padding-top", n++);
                    hashMap.put("BorderWidth", n++);
                    hashMap.put("padding-right", n++);
                    hashMap.put("padding-left", n++);
                    hashMap.put("LeftLine", n++);
                    hashMap.put("TopLine", n++);
                    LeftLine = hashMap;
                }
            }
        }
        return LeftLine;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (RightLine != null) {
                return RightLine;
            }
            RightLine = JetRptBox.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (RightLine == null) {
                RightLine = new HashVector();
            }
            String string = "";
            Vector<String> vector = new Vector<String>();
            string = "Padding";
            vector = new Vector(4);
            vector.add(PropertyNames.getDefinitionName(PropertyNames.padding_top));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.padding_bottom));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.padding_left));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.padding_right));
            RightLine.put(string, vector);
            string = "Border";
            vector = new Vector(8);
            vector.add(PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.TopLine));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.BottomLine));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.LeftLine));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.RightLine));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.Shadow));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.BorderColor));
            vector.add(PropertyNames.getDefinitionName(PropertyNames.ShadowColor));
            RightLine.put(string, vector);
            return RightLine;
        }
        return null;
    }

    private void BORDERSTYLE_STR_NAMES() {
        this.topPadding = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_top));
        this.bottomPadding = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_bottom));
        this.leftPadding = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_left));
        this.rightPadding = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_right));
    }

    private void BorderColor() {
        this.borderWidth = new JetRptLineWidth(this, PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
        this.top = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.TopLine));
        this.bottom = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.BottomLine));
        this.left = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.LeftLine));
        this.right = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.RightLine));
        this.borderColor = new JetColor(this, PropertyNames.getDefinitionName(PropertyNames.BorderColor), Color.black);
        this.drawShadow = new JetBoolean(this, PropertyNames.getDefinitionName(PropertyNames.Shadow));
        this.shadowColor = new JetColor(this, PropertyNames.getDefinitionName(PropertyNames.ShadowColor), Color.black);
        this.top.set(1);
        this.bottom.set(1);
        this.left.set(1);
        this.right.set(1);
        this.drawShadow.set(false);
        this.shadowColor.set(Color.black);
    }

    @Override
    public short getTopLineChangeByType() {
        if (this.top == null) {
            return -1;
        }
        short s = 0;
        if (this.top.isChangeByOther()) {
            s = 1;
        }
        if (this.top.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.top.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getBottomLineChangeByType() {
        if (this.bottom == null) {
            return -1;
        }
        short s = 0;
        if (this.bottom.isChangeByOther()) {
            s = 1;
        }
        if (this.bottom.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.bottom.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getLeftLineChangeByType() {
        if (this.left == null) {
            return -1;
        }
        short s = 0;
        if (this.left.isChangeByOther()) {
            s = 1;
        }
        if (this.left.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.left.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getRightLineChangeByType() {
        if (this.right == null) {
            return -1;
        }
        short s = 0;
        if (this.right.isChangeByOther()) {
            s = 1;
        }
        if (this.right.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.right.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    static {
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.Shadow), 29);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.BorderWidth), 31);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.TopLine), 33);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.BottomLine), 34);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.LeftLine), 35);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.RightLine), 36);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.BorderColor), 42);
        BottomLine.put(PropertyNames.getDefinitionName(PropertyNames.ShadowColor), 96);
        LeftLine = null;
        RightLine = null;
    }
}

