/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.connect.Record;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JRObjectResult;
import jet.ie.WriterTool;
import jet.report.CrosstabArchitecture;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggInfo;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptCTHdTextField;
import jet.report.JetRptDataContainer;
import jet.report.JetRptObject;
import jet.report.JetRptTitleTextField;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.image.ImageProvider;

public class JetRptCTCrossTab
extends JetRptDataContainer {
    public static final String TOTAL_STRING = "Total";
    public JetUnitNumber hGap;
    public JetUnitNumber vGap;
    public JetBoolean hasborder;
    public JetBoolean verticalLayout;
    public JetNumber boundaryValue;
    public JetBoolean rowTotalOnTop;
    public JetBoolean columnTotalOnLeft;
    public JetBoolean repeatRowHeader;
    public JetBoolean avoidOrphanHeader;
    public int iNHorizontalGap = Unit.GRID;
    public int iNVerticalGap = Unit.GRID;
    public int iNBoundaryValue = -1;
    public boolean bNHasBorder = true;
    public boolean bNVerticalLayout = true;
    public boolean bNRowTotalOnTop = false;
    public boolean bNColumnTotalOnLeft = false;
    public boolean bNRepeatRowHeader = false;
    public boolean bNAvoidOrphanHeader = false;
    public boolean bFHasBorder = false;
    public boolean bFVerticalLayout = false;
    public boolean bFBoundaryValue = false;
    public String cFHasBorder;
    public String cFBoundaryValue;
    public String cFVerticalLayout;
    private boolean S = false;
    private Hashtable SEDU = new Hashtable();
    private static Hashtable _mapStringToColor = new Hashtable();
    public JetBoolean suppressRowHeader;
    public JetBoolean suppressColumnHeader;
    public JetUnitNumber bGap;
    public JetNumber currentRowBlockIndex;
    public JetNumber currentColBlockIndex;
    public JetNumber itemsPerRowBlock;
    public JetNumber itemsPerColBlock;
    public JetBoolean isTableStyle;
    public JetBoolean repeatAgg;
    public JetBoolean canExpandData;
    public JetBoolean cache;
    public JetBoolean isOutSideAggTitle;
    public JetBoolean suppressEmpty;
    public JetString styleFile;
    public JetBoolean styleInherit;
    public JetVector styleList;
    private JetString add;
    private JetQualifyReference addPrimByF;
    private JetBoolean append;
    private JetUnitNumber booleanValue;
    private JetUnitNumber contains;
    public JetBoolean enableAlternativeLineColor;
    public JetVector alternativeLineColorPatternList;
    public JetNumber alternativeLineColorDirection;
    public static int ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL;
    public static int ALTERNATIVE_LINE_COLOR_DIRECTION_VERTICAL;
    private JetBoolean depth;
    private JetBoolean duplicatePropGrpsDesc;
    private JetNumber elementAt;
    private static HashMap enableAllChangeBys;
    private static HashVector equals;

    public JetRptCTCrossTab() {
        this.ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL();
        this.primProSize = (short)(this.primProSize + 10);
        this.setObjectType(34);
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.S) {
            this.S = true;
            this.SEDU = super.getPrimProp();
            this.SEDU.put("HorizontalGap", 86);
            this.SEDU.put("VerticalGap", 87);
            this.SEDU.put("Hasborder", 88);
            this.SEDU.put("VerticalLayout", 89);
            this.SEDU.put("BoundaryValue", 90);
            this.SEDU.put("RowTotalOnTop", 91);
            this.SEDU.put("ColumnTotalOnLeft", 92);
            this.SEDU.put("RepeatRowHeader", 93);
            this.SEDU.put("AvoidOrphanHeader", 94);
        }
        return this.SEDU;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.ALTERNATIVE_LINE_COLOR_DIRECTION_VERTICAL();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.avoidOrphanHeader != null) {
            String string2 = null;
            int n = 0;
            Integer n2 = (Integer)_mapStringToColor.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch ((Integer)_mapStringToColor.get(string)) {
                case 86: {
                    this.iNHorizontalGap = this.hGap.getUnit();
                    break;
                }
                case 87: {
                    this.iNVerticalGap = this.vGap.getUnit();
                    break;
                }
                case 88: {
                    this.bNHasBorder = this.hasborder.get();
                    this.cFHasBorder = (String)this.hasborder.getRuntimeChangeBy();
                    boolean bl = this.bFHasBorder = this.cFHasBorder != null;
                    if (!this.bFHasBorder) break;
                    string2 = this.cFHasBorder;
                    break;
                }
                case 89: {
                    this.bNVerticalLayout = this.verticalLayout.get();
                    this.cFVerticalLayout = (String)this.verticalLayout.getRuntimeChangeBy();
                    boolean bl = this.bFVerticalLayout = this.cFVerticalLayout != null;
                    if (!this.bFVerticalLayout) break;
                    string2 = this.cFVerticalLayout;
                    break;
                }
                case 90: {
                    this.iNBoundaryValue = this.boundaryValue.get();
                    this.cFBoundaryValue = (String)this.boundaryValue.getRuntimeChangeBy();
                    boolean bl = this.bFBoundaryValue = this.cFBoundaryValue != null;
                    if (!this.bFBoundaryValue) break;
                    string2 = this.cFBoundaryValue;
                    break;
                }
                case 91: {
                    this.bNRowTotalOnTop = this.rowTotalOnTop.get();
                    break;
                }
                case 92: {
                    this.bNColumnTotalOnLeft = this.columnTotalOnLeft.get();
                    break;
                }
                case 93: {
                    this.bNRepeatRowHeader = this.repeatRowHeader.get();
                    break;
                }
                case 94: {
                    this.bNAvoidOrphanHeader = this.avoidOrphanHeader.get();
                    break;
                }
                case 42: {
                    this.cNBorderColor = this.borderColor.get();
                    this.cFBorderColor = (String)this.borderColor.getRuntimeChangeBy();
                    boolean bl = this.bFBorderColor = this.cFBorderColor != null;
                    if (!this.bFBorderColor) break;
                    string2 = this.cFBorderColor;
                }
            }
            if (string2 != null) {
                this.addPrimByF(string2, n);
            }
        }
    }

    @Override
    public String getInstancePrefix() {
        return "CTCrossTab";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("CTCrossTab");
    }

    @Override
    public boolean isGroupListener() {
        return true;
    }

    @Override
    public int getHorizontalGap(JRObjectResult jRObjectResult) {
        return this.iNHorizontalGap;
    }

    @Override
    public int getVerticalGap(JRObjectResult jRObjectResult) {
        return this.iNVerticalGap;
    }

    @Override
    public boolean getHasBorder(JRObjectResult jRObjectResult) {
        if (!this.bFHasBorder) {
            return this.bNHasBorder;
        }
        return jRObjectResult.getBoolean(this.cFHasBorder, this.bNHasBorder);
    }

    @Override
    public Color getBorderColor(JRObjectResult jRObjectResult) {
        if (!this.bFBorderColor) {
            return this.cNBorderColor;
        }
        return jRObjectResult.getColor(this.cFBorderColor, this.cNBorderColor);
    }

    @Override
    public boolean getVerticalLayout(JRObjectResult jRObjectResult) {
        if (!this.bFVerticalLayout) {
            return this.bNVerticalLayout;
        }
        return jRObjectResult.getBoolean(this.cFVerticalLayout, this.bNVerticalLayout);
    }

    @Override
    public int getBoundaryValue(JRObjectResult jRObjectResult) {
        if (!this.bFBoundaryValue) {
            return this.iNBoundaryValue;
        }
        return jRObjectResult.getInt(this.cFBoundaryValue, true, this.iNBoundaryValue);
    }

    @Override
    public boolean getRowTotalOnTop(JRObjectResult jRObjectResult) {
        return this.bNRowTotalOnTop;
    }

    @Override
    public boolean getColumnTotalOnLeft(JRObjectResult jRObjectResult) {
        return this.bNColumnTotalOnLeft;
    }

    @Override
    public boolean getRepeatRowHeader(JRObjectResult jRObjectResult) {
        return this.bNRepeatRowHeader;
    }

    @Override
    public boolean getAvoidOrphanHeader(JRObjectResult jRObjectResult) {
        return this.bNAvoidOrphanHeader;
    }

    public boolean getHasBorder(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFHasBorder) {
            return this.bNHasBorder;
        }
        return jRObjectResult.getBoolean(this.cFHasBorder, record, this.bNHasBorder);
    }

    @Override
    public Color getBorderColor(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFBorderColor) {
            return this.cNBorderColor;
        }
        return jRObjectResult.getColor(this.cFBorderColor, record, this.cNBorderColor);
    }

    @Override
    public boolean getBorderColorChBy() {
        return this.bFBorderColor;
    }

    public boolean getVerticalLayout(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFVerticalLayout) {
            return this.bNVerticalLayout;
        }
        return jRObjectResult.getBoolean(this.cFVerticalLayout, record, this.bNVerticalLayout);
    }

    public int getBoundaryValue(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFBoundaryValue) {
            return this.iNBoundaryValue;
        }
        return jRObjectResult.getInt(this.cFBoundaryValue, true, record, this.iNBoundaryValue);
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        Integer n4 = (Integer)_mapStringToColor.get(string);
        if (n4 != null) {
            n3 = n4;
        } else {
            super.setInt(string, n, n2);
        }
        switch (n3) {
            case 86: {
                this.iNHorizontalGap = Unit.upgrade(n, n2, false);
                bl = true;
                break;
            }
            case 87: {
                this.iNVerticalGap = Unit.upgrade(n, n2, false);
                bl = true;
                break;
            }
            case 88: {
                this.bNHasBorder = n != 0;
                bl = true;
                break;
            }
            case 89: {
                this.bNVerticalLayout = n != 0;
                bl = true;
                break;
            }
            case 90: {
                this.iNBoundaryValue = n;
                bl = true;
                break;
            }
            case 91: {
                this.bNRowTotalOnTop = n != 0;
                bl = true;
                break;
            }
            case 92: {
                this.bNColumnTotalOnLeft = n != 0;
                bl = true;
                break;
            }
            case 93: {
                this.bNRepeatRowHeader = n != 0;
                bl = true;
                break;
            }
            case 94: {
                this.bNAvoidOrphanHeader = n != 0;
                bl = true;
            }
        }
        if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)_mapStringToColor.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setPrimUnit(string, string2);
        }
        switch (n) {
            case 42: {
                bl = true;
                this.cNBorderColor = MiscTools._mapStringToColor(string2);
            }
        }
        if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    @Override
    public void setChangeBy(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)_mapStringToColor.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setChangeBy(string, string2);
        }
        switch (n) {
            case 88: {
                this.bFHasBorder = true;
                this.cFHasBorder = string2;
                bl = true;
                break;
            }
            case 42: {
                this.bFBorderColor = true;
                this.cFBorderColor = string2;
                bl = true;
                break;
            }
            case 89: {
                this.bFVerticalLayout = true;
                this.cFVerticalLayout = string2;
                bl = true;
                break;
            }
            case 90: {
                this.bFBoundaryValue = true;
                this.cFBoundaryValue = string2;
                bl = true;
            }
        }
        if (!bl) {
            super.setChangeBy(string, string2);
        } else {
            this.addPrimByF(string2, n);
        }
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get("HorizontalGap");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("HorizontalGap", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNHorizontalGap, null, dataOutput, 4);
        s2 = (Short)hashVector.get("VerticalGap");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("VerticalGap", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNVerticalGap, null, dataOutput, 4);
        s2 = (Short)hashVector.get("Hasborder");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("Hasborder", s2);
        }
        WriterTool.writePrimBool(s2, this.bFHasBorder, this.bNHasBorder, this.cFHasBorder, dataOutput);
        s2 = (Short)hashVector.get("BorderColor");
        if (s2 == null) {
            short s6 = s;
            s = (short)(s + 1);
            s2 = s6;
            hashVector.put("BorderColor", s2);
        }
        WriterTool.writePrimColor(s2, this.bFBorderColor, this.cNBorderColor, this.cFBorderColor, dataOutput);
        s2 = (Short)hashVector.get("VerticalLayout");
        if (s2 == null) {
            short s7 = s;
            s = (short)(s + 1);
            s2 = s7;
            hashVector.put("VerticalLayout", s2);
        }
        WriterTool.writePrimBool(s2, this.bFVerticalLayout, this.bNVerticalLayout, this.cFVerticalLayout, dataOutput);
        s2 = (Short)hashVector.get("BoundaryValue");
        if (s2 == null) {
            short s8 = s;
            s = (short)(s + 1);
            s2 = s8;
            hashVector.put("BoundaryValue", s2);
        }
        WriterTool.writePrimUnit(s2, this.bFBoundaryValue, this.iNBoundaryValue, this.cFBoundaryValue, dataOutput, 5);
        s2 = (Short)hashVector.get("RowTotalOnTop");
        if (s2 == null) {
            short s9 = s;
            s = (short)(s + 1);
            s2 = s9;
            hashVector.put("RowTotalOnTop", s2);
        }
        WriterTool.writePrimBool(s2, false, this.bNRowTotalOnTop, null, dataOutput);
        s2 = (Short)hashVector.get("ColumnTotalOnLeft");
        if (s2 == null) {
            short s10 = s;
            s = (short)(s + 1);
            s2 = s10;
            hashVector.put("ColumnTotalOnLeft", s2);
        }
        WriterTool.writePrimBool(s2, false, this.bNColumnTotalOnLeft, null, dataOutput);
        s2 = (Short)hashVector.get("RepeatRowHeader");
        if (s2 == null) {
            short s11 = s;
            s = (short)(s + 1);
            s2 = s11;
            hashVector.put("RepeatRowHeader", s2);
        }
        WriterTool.writePrimBool(s2, false, this.bNRepeatRowHeader, null, dataOutput);
        s2 = (Short)hashVector.get("AvoidOrphanHeader");
        if (s2 == null) {
            short s12 = s;
            s = (short)(s + 1);
            s2 = s12;
            hashVector.put("AvoidOrphanHeader", s2);
        }
        WriterTool.writePrimBool(s2, false, this.bNAvoidOrphanHeader, null, dataOutput);
        return s;
    }

    public CrosstabArchitecture getArchitecture() {
        Vector vector = this.getChildren();
        Vector<JetRptCTHdDBField> vector2 = new Vector<JetRptCTHdDBField>();
        Vector<JetRptCTHdTextField> vector3 = new Vector<JetRptCTHdTextField>();
        Vector<JetRptCTHdDBField> vector4 = new Vector<JetRptCTHdDBField>();
        Vector<JetRptCTHdTextField> vector5 = new Vector<JetRptCTHdTextField>();
        Vector<JetRptCTAggInfo> vector6 = new Vector<JetRptCTAggInfo>();
        Hashtable<String, Vector<JetRptCTAggField>> hashtable = new Hashtable<String, Vector<JetRptCTAggField>>();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            boolean bl;
            Object e = vector.elementAt(i);
            if (e instanceof JetRptCTHdDBField) {
                JetRptCTHdDBField jetRptCTHdDBField = (JetRptCTHdDBField)e;
                bl = jetRptCTHdDBField.isXheader.get();
                n = jetRptCTHdDBField.depth.get();
                if (bl) {
                    vector2.add(n, jetRptCTHdDBField);
                    continue;
                }
                vector4.add(n, jetRptCTHdDBField);
                continue;
            }
            if (e instanceof JetRptCTAggInfo) {
                JetRptCTAggInfo jetRptCTAggInfo = (JetRptCTAggInfo)e;
                n = jetRptCTAggInfo.index.get();
                vector6.add(n, jetRptCTAggInfo);
                continue;
            }
            if (e instanceof JetRptCTHdTextField) {
                JetRptCTHdTextField jetRptCTHdTextField = (JetRptCTHdTextField)e;
                bl = jetRptCTHdTextField.isXheader.get();
                n = jetRptCTHdTextField.depth.get();
                if (bl) {
                    vector3.add(n, jetRptCTHdTextField);
                    continue;
                }
                vector5.add(n, jetRptCTHdTextField);
                continue;
            }
            JetRptCTAggField jetRptCTAggField = (JetRptCTAggField)e;
            String string = jetRptCTAggField.xdepth.get() + "," + jetRptCTAggField.ydepth.get();
            Vector<JetRptCTAggField> vector7 = (Vector<JetRptCTAggField>)hashtable.get(string);
            if (vector7 == null) {
                vector7 = new Vector<JetRptCTAggField>();
                hashtable.put(string, vector7);
            }
            vector7.add(jetRptCTAggField.index.get(), jetRptCTAggField);
        }
        return new CrosstabArchitecture(vector2, vector3, vector4, vector5, vector6, hashtable);
    }

    public JetRptCTHdDBField getCTHdDBField(boolean bl, int n) {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptCTHdDBField)) continue;
            JetRptCTHdDBField jetRptCTHdDBField = (JetRptCTHdDBField)vector.elementAt(i);
            if (jetRptCTHdDBField.isXheader.get() != bl || jetRptCTHdDBField.depth.get() != n) continue;
            return jetRptCTHdDBField;
        }
        return null;
    }

    public JetRptObject getChildByInstName(String string) {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = ((JetObject)vector.elementAt(i)).getInstName();
            if (string2 == null || !string2.equals(string)) continue;
            return (JetRptObject)vector.elementAt(i);
        }
        return null;
    }

    public boolean isRunInFlash() {
        return this.depth.booleanValue();
    }

    public void setRunInFlash(boolean bl) {
        this.depth.set(bl);
    }

    @Override
    public JetRptTitleTextField getTitleObject() {
        return (JetRptTitleTextField)this.addPrimByF.getObject();
    }

    @Override
    public void setTitleObject(JetRptTitleTextField jetRptTitleTextField) {
        this.addPrimByF.setObject(jetRptTitleTextField);
    }

    @Override
    public void clearTitleObject() {
        this.addPrimByF.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (enableAllChangeBys == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (enableAllChangeBys == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Summary", n++);
                    hashMap.put("repeatAgg", n++);
                    hashMap.put("StyleInherit", n++);
                    hashMap.put("SuppressColumnHeader", n++);
                    hashMap.put("StyleFile", n++);
                    hashMap.put("isOutSideAggTitle", n++);
                    hashMap.put("itemsPerRowBlock", n++);
                    hashMap.put("StyleList", n++);
                    hashMap.put("AvoidOrphanHeader", n++);
                    hashMap.put("currentRowBlockIndex", n++);
                    hashMap.put("Cache", n++);
                    hashMap.put("isTableStyle", n++);
                    hashMap.put("RepeatRowHeader", n++);
                    hashMap.put("ColumnTotalOnLeft", n++);
                    hashMap.put("RowTotalOnTop", n++);
                    hashMap.put("Hasborder", n++);
                    hashMap.put("currentColBlockIndex", n++);
                    hashMap.put("itemsPerColBlock", n++);
                    hashMap.put("HorizontalGap", n++);
                    hashMap.put("VerticalGap", n++);
                    hashMap.put("canExpandData", n++);
                    hashMap.put("BlockGap", n++);
                    hashMap.put("SuppressEmpty", n++);
                    hashMap.put("BoundaryValue", n++);
                    hashMap.put("SuppressRowHeader", n++);
                    hashMap.put("VerticalLayout", n++);
                    hashMap.put("TitleObject", n++);
                    hashMap.put("CDNUsed", n++);
                    hashMap.put("CDNHeight", n++);
                    hashMap.put("CDNWidth", n++);
                    hashMap.put("EnableAlternativeLineColor", n++);
                    hashMap.put("AlternativeLineColorDirection", n++);
                    hashMap.put("AlternativeLineColorPatternList", n++);
                    hashMap.put("RunInFlash", n++);
                    hashMap.put("InvisibleInBFDlg", n++);
                    hashMap.put("IndexInBFDlg", n++);
                    enableAllChangeBys = hashMap;
                }
            }
        }
        return enableAllChangeBys;
    }

    private void ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL() {
        Vector<Object> vector;
        this.suppressRowHeader = new JetBoolean(this, "SuppressRowHeader");
        this.suppressColumnHeader = new JetBoolean(this, "SuppressColumnHeader");
        this.bGap = new JetUnitNumber(this, "BlockGap", Unit.GRID * 4);
        this.currentRowBlockIndex = new JetNumber(this, "currentRowBlockIndex", 0);
        this.currentColBlockIndex = new JetNumber(this, "currentColBlockIndex", 0);
        this.itemsPerRowBlock = new JetNumber(this, "itemsPerRowBlock", -1);
        this.itemsPerColBlock = new JetNumber(this, "itemsPerColBlock", -1);
        this.isTableStyle = new JetBoolean(this, "isTableStyle", false);
        this.repeatAgg = new JetBoolean(this, "repeatAgg", false);
        this.canExpandData = new JetBoolean(this, "canExpandData", false);
        this.cache = new JetBoolean(this, "Cache", true);
        this.isOutSideAggTitle = new JetBoolean(this, "isOutSideAggTitle", false);
        this.suppressEmpty = new JetBoolean(this, "SuppressEmpty", false);
        this.styleFile = new JetString(this, "StyleFile");
        this.styleInherit = new JetBoolean(this, "StyleInherit", true);
        this.styleList = new JetVector(this, "StyleList");
        this.add = new JetString(this, "Summary");
        this.suppressRowHeader.setCanChangeByOthers(false);
        this.suppressColumnHeader.setCanChangeByOthers(false);
        this.style.setDefault("CTCrossTab");
        if (this.style.getList() == null) {
            vector = new Vector<Object>();
            vector.add("CTCrossTab");
            this.style.setList(vector);
        } else if (!this.style.getList().contains("CTCrossTab")) {
            this.style.getList().insertElementAt("CTCrossTab", 0);
        }
        this.styleFile.setCanChangeByOthers(false);
        this.cache.setCanChangeByOthers(false);
        this.addPrimByF = new JetQualifyReference(this, "TitleObject");
        this.append = new JetBoolean(this, "CDNUsed", true);
        this.contains = new JetUnitNumber(this, "CDNHeight", -5760);
        this.booleanValue = new JetUnitNumber(this, "CDNWidth", -5760);
        this.append.enableAllChangeBys(false);
        this.contains.enableAllChangeBys(false);
        this.booleanValue.enableAllChangeBys(false);
        this.enableAlternativeLineColor = new JetBoolean(this, "EnableAlternativeLineColor", true);
        this.alternativeLineColorDirection = new JetNumber(this, "AlternativeLineColorDirection", ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL);
        this.alternativeLineColorPatternList = new JetVector(this, "AlternativeLineColorPatternList");
        this.alternativeLineColorPatternList.add("c0xffffff000");
        this.alternativeLineColorPatternList.add("c0xffffcc000");
        this.enableAlternativeLineColor.setCanChangeByOthers(false);
        this.enableAlternativeLineColor.setCanChangeByFmtt(false);
        this.alternativeLineColorDirection.setCanChangeByOthers(false);
        this.alternativeLineColorDirection.setCanChangeByFmtt(false);
        this.alternativeLineColorPatternList.setCanChangeByOthers(false);
        this.alternativeLineColorPatternList.setCanChangeByFmtt(false);
        vector = new Vector(2);
        vector.add(ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL);
        vector.add(ALTERNATIVE_LINE_COLOR_DIRECTION_VERTICAL);
        this.alternativeLineColorDirection.setPropertyChoice(vector);
        this.depth = new JetBoolean(this, "RunInFlash", false);
        this.depth.enableAllChangeBys(false);
        this.duplicatePropGrpsDesc = new JetBoolean(this, "InvisibleInBFDlg", false);
        this.duplicatePropGrpsDesc.enableAllChangeBys(false);
        this.elementAt = new JetNumber(this, "IndexInBFDlg", 0);
        this.elementAt.enableAllChangeBys(false);
    }

    private void ALTERNATIVE_LINE_COLOR_DIRECTION_VERTICAL() {
        this.hGap = new JetUnitNumber(this, "HorizontalGap", Unit.GRID);
        this.vGap = new JetUnitNumber(this, "VerticalGap", Unit.GRID);
        this.hasborder = new JetBoolean(this, "Hasborder", true);
        this.verticalLayout = new JetBoolean(this, "VerticalLayout", true);
        this.boundaryValue = new JetNumber(this, "BoundaryValue", -1);
        this.rowTotalOnTop = new JetBoolean(this, "RowTotalOnTop", false);
        this.columnTotalOnLeft = new JetBoolean(this, "ColumnTotalOnLeft", false);
        this.repeatRowHeader = new JetBoolean(this, "RepeatRowHeader", false);
        this.avoidOrphanHeader = new JetBoolean(this, "AvoidOrphanHeader", false);
        this.width.setEditFlag(0);
        this.height.setEditFlag(0);
        this.verticalLayout.setEditFlag(0);
        this.verticalLayout.setCanChangeByOthers(false);
        this.boundaryValue.setCanChangeByOthers(false);
        this.rowTotalOnTop.setCanChangeByOthers(false);
        this.columnTotalOnLeft.setCanChangeByOthers(false);
        this.repeatRowHeader.setCanChangeByOthers(false);
        this.avoidOrphanHeader.setCanChangeByOthers(false);
    }

    public int getIndexInBrowserFilterDialog() {
        return this.elementAt.intValue();
    }

    public boolean isInvisibleInBrowserFilterDialog() {
        return this.duplicatePropGrpsDesc.booleanValue();
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (equals != null) {
                return equals;
            }
            equals = JetRptCTCrossTab.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (equals == null) {
                equals = new HashVector();
            }
            String string = "Border";
            List<String> list = (Vector<String>)equals.get(string);
            list.add("Hasborder");
            list.remove("TopLine");
            list.remove("LeftLine");
            list.remove("RightLine");
            list.remove("BottomLine");
            list.remove("BorderWidth");
            list.remove("Shadow");
            list.remove("ShadowColor");
            string = "Others";
            list = (List)equals.get(string);
            list.add("currentRowBlockIndex");
            list.add("currentColBlockIndex");
            list.add("itemsPerRowBlock");
            list.add("itemsPerColBlock");
            list.add("Cache");
            list.add("SuppressEmpty");
            list.add("CDNUsed");
            list.add("CDNHeight");
            list.add("CDNWidth");
            list.add("ExportToHTML");
            list.add("ExportToPDF");
            list.add("ExportToText");
            list.add("ExportToRTF");
            list.add("ExportToXML");
            list.add("ExportToPostScript");
            list.add("ExportToApplet");
            list.add("InvisibleInBFDlg");
            list.add("IndexInBFDlg");
            string = "CrossTabProperty";
            list = new Vector<String>(15);
            equals.put(string, list);
            list.add("HorizontalGap");
            list.add("VerticalGap");
            list.add("VerticalLayout");
            list.add("BoundaryValue");
            list.add("RowTotalOnTop");
            list.add("ColumnTotalOnLeft");
            list.add("RepeatRowHeader");
            list.add("AvoidOrphanHeader");
            list.add("BlockGap");
            list.add("SuppressRowHeader");
            list.add("SuppressColumnHeader");
            list.add("isTableStyle");
            list.add("repeatAgg");
            list.add("canExpandData");
            list.add("isOutSideAggTitle");
            string = "TOC";
            list = new Vector();
            equals.put(string, list);
            list.add("TOCAnchor");
            list.add("AnchorDispValue");
            string = "Accessibility";
            list = (List)equals.get(string);
            list.add("ExternalID");
            list.add("ExternalStyle");
            list.add("Lang");
            list.add("Summary");
            equals.remove(string);
            equals.put(string, list);
            string = "Alternating Line Color";
            list = new Vector(3);
            list.add("EnableAlternativeLineColor");
            list.add("AlternativeLineColorDirection");
            list.add("AlternativeLineColorPatternList");
            equals.putAt(string, list, equals.indexOf("CSS"));
            return equals;
        }
        return null;
    }

    static {
        _mapStringToColor.put("HorizontalGap", 86);
        _mapStringToColor.put("VerticalGap", 87);
        _mapStringToColor.put("Hasborder", 88);
        _mapStringToColor.put("VerticalLayout", 89);
        _mapStringToColor.put("BoundaryValue", 90);
        _mapStringToColor.put("RowTotalOnTop", 91);
        _mapStringToColor.put("ColumnTotalOnLeft", 92);
        _mapStringToColor.put("RepeatRowHeader", 93);
        _mapStringToColor.put("AvoidOrphanHeader", 94);
        ALTERNATIVE_LINE_COLOR_DIRECTION_HORIZONTAL = 0;
        ALTERNATIVE_LINE_COLOR_DIRECTION_VERTICAL = 1;
        enableAllChangeBys = null;
        equals = null;
    }
}

