/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import chart.data.ChartDataFilter;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import com.jinfonet.awt.JFont;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.ChangedProperties;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.JetChartTypeEnumeration;
import jet.report.JetRptChart2DCoordinatepaper;
import jet.report.JetRptChartBorderStyle;
import jet.report.JetRptChartCoordinatepaper;
import jet.report.JetRptChartLabel;
import jet.report.JetRptChartLegend;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDataSource;
import jet.report.JetRptDataSourceProperty;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptLineWidth;
import jet.report.JetRptReportPanel;
import jet.reportset.DataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.rptservice.util.ReportTools;
import jet.upgrade.kit.V7XObjectUtil;
import jet.util.FontSets;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.ReportFormat;
import jet.util.TreeIterater;

public class JetRptChartPlatform
extends JetRptDataContainer
implements PropertyChangeListener {
    public static final Hashtable chartTypes = new Hashtable();
    public static final Hashtable comboTypes = new Hashtable();
    private transient JetRptChartPlatform BUILTINTYPES;
    public JetRptDataSourceProperty dataSource;
    public JetBoolean horizontal;
    public JetChartTypeEnumeration type;
    public JetBoolean isCombo;
    public JetChartTypeEnumeration primaryType;
    public JetChartTypeEnumeration secondType;
    public JetColumnVector group1;
    public JetColumnVector group2;
    public JetColumnVector value;
    public JetVector catGroup;
    public JetString section;
    public JetBoolean level;
    public JetNumber start1st;
    public JetNumber end1st;
    public JetNumber start2nd;
    public JetNumber end2nd;
    public JetBoolean reverseInRow;
    public JetBoolean reverseInColumn;
    public JetStringList format;
    public JetStringList grpValueFormat;
    public JetBoolean antiAliasing;
    public JetVector grp1Patternlist;
    public JetVector grp2Patternlist;
    public JetVector grp3Patternlist;
    public JetString hyperlink;
    public JetString xhyperlink;
    public JetString zhyperlink;
    public JetEnumeration sortX;
    public JetEnumeration sortZ;
    public JetVector priFilter;
    public JetVector secFilter;
    public JetVector catFilter;
    public JetVector serFilter;
    public JetBoolean autoLayout;
    public JetRptChartBorderStyle borderStyle;
    public JetEnumeration penStyle;
    public JetColor penColor;
    public JetRptLineWidth penThickness;
    public JetEnumeration endCaps;
    public JetEnumeration lineJoint;
    public JetBoolean outlined;
    public JetBoolean variabledDash;
    public JetNumber borderTrans;
    public JetEnumeration fillPattern;
    public JetNumber bgTrans;
    public JetNumber top;
    public JetNumber left;
    public JetNumber right;
    public JetNumber bottom;
    public JetColor bgColor;
    public JetEnumeration textureStyle;
    public JetColor tForeColor;
    public JetColor tBackColor;
    public JetEnumeration gradientStyle;
    public JetColor startColor;
    public JetColor endColor;
    public JetNumber gradX1;
    public JetNumber gradY1;
    public JetNumber gradX2;
    public JetNumber gradY2;
    public JetImgProperty image;
    public JetEnumeration layout;
    public JetNumber imgX;
    public JetNumber imgY;
    public JetNumber imgWidth;
    public JetNumber imgHeight;
    public JetNumber sizeOfPart1;
    public JetNumber columnNum;
    public JetNumber rowNum;
    private static HashMap CHART_FILTER_EDITOR;
    private static HashVector CHART_FILTER_EDITOR_NO_DATE;

    private void BUILTINTYPES() {
        this.dataSource = new JetRptDataSourceProperty(this, "DataSource");
        this.horizontal = new JetBoolean(this, "Horizontal");
        this.type = new JetChartTypeEnumeration(this, "Type");
        this.isCombo = new JetBoolean(this, "IsCombo");
        this.primaryType = new JetChartTypeEnumeration(this, "PrimaryType");
        this.secondType = new JetChartTypeEnumeration(this, "SecondType");
        this.group1 = new JetColumnVector(this, "Category");
        this.group2 = new JetColumnVector(this, "Series");
        this.value = new JetColumnVector(this, "Value");
        this.catGroup = new JetVector(this, "CatGroup");
        this.section = new JetString(this, "Section");
        this.level = new JetBoolean(this, "SameLevel");
        this.start1st = new JetNumber(this, "StartOffset(1st Data Set)", -1);
        this.end1st = new JetNumber(this, "EndOffset(1st Data Set)", -1);
        this.start2nd = new JetNumber(this, "StartOffset(2nd Data Set)", -1);
        this.end2nd = new JetNumber(this, "EndOffset(2nd Data Set)", -1);
        this.reverseInRow = new JetBoolean(this, "ReverseRows", false);
        this.reverseInColumn = new JetBoolean(this, "ReverseColumns", false);
        this.format = new JetStringList(this, "HintFormat");
        this.grpValueFormat = new JetStringList(this, "GroupValueFormat");
        this.antiAliasing = new JetBoolean(this, "AntiAliasing", true);
        this.grp1Patternlist = new JetVector(this, "OuterGroupPatternList");
        this.grp2Patternlist = new JetVector(this, "InnerGroupPatternList");
        this.grp3Patternlist = new JetVector(this, "PatternList");
        this.hyperlink = new JetString(this, "HyperLink");
        this.xhyperlink = new JetString(this, "XHyperLink");
        this.zhyperlink = new JetString(this, "ZHyperLink");
        this.sortX = new JetEnumeration(this, "SortX", 88);
        this.sortZ = new JetEnumeration(this, "SortZ", 88);
        this.priFilter = new JetVector(this, "PrimaryDataFilter");
        this.secFilter = new JetVector(this, "SecondaryDataFilter");
        this.catFilter = new JetVector(this, "CategoryFilter");
        this.serFilter = new JetVector(this, "SeriesFilter");
        this.autoLayout = new JetBoolean(this, "AutoLayout", true);
        this.borderStyle = new JetRptChartBorderStyle(this, "BorderStyle");
        this.penStyle = new JetEnumeration(this, "PenStyle", 18);
        this.penColor = new JetColor(this, "PenColor", null, true);
        this.penThickness = new JetRptLineWidth(this, "PenThickness");
        this.endCaps = new JetEnumeration(this, "EndCaps", 14);
        this.lineJoint = new JetEnumeration(this, "LineJoint", 57);
        this.outlined = new JetBoolean(this, "Outline", false);
        this.variabledDash = new JetBoolean(this, "VariabledDash", false);
        this.borderTrans = new JetNumber(this, "BorderTransparency", 0);
        this.fillPattern = new JetEnumeration(this, "FillPattern", 76);
        this.bgTrans = new JetNumber(this, "BackgroundTransparency");
        this.top = new JetNumber(this, "Top");
        this.left = new JetNumber(this, "Left");
        this.right = new JetNumber(this, "Right");
        this.bottom = new JetNumber(this, "Bottom");
        this.bgColor = new JetColor(this, "BackgroundColor", null, true);
        this.textureStyle = new JetEnumeration(this, "TextureStyle", 96);
        this.tForeColor = new JetColor(this, "TextureForeColor", Color.black, true);
        this.tBackColor = new JetColor(this, "TextureBackColor", Color.white, true);
        this.gradientStyle = new JetEnumeration(this, "GradientStyle", 43);
        this.startColor = new JetColor(this, "GradientStartColor", Color.blue, true);
        this.endColor = new JetColor(this, "GradientEndColor", Color.red, true);
        this.gradX1 = new JetNumber(this, "GradientStartX");
        this.gradY1 = new JetNumber(this, "GradientStartY");
        this.gradX2 = new JetNumber(this, "GradientEndX", 100);
        this.gradY2 = new JetNumber(this, "GradientEndY", 100);
        this.image = new JetImgProperty(this, "Image");
        this.layout = new JetEnumeration(this, "ImageLayout", 49);
        this.imgX = new JetNumber(this, "ImageX");
        this.imgY = new JetNumber(this, "ImageY", 100);
        this.imgWidth = new JetNumber(this, "ImageWidth", 100);
        this.imgHeight = new JetNumber(this, "ImageHeight", 100);
        this.sizeOfPart1 = new JetNumber(this, "SizeOfPart1", -1);
        this.columnNum = new JetNumber(this, "ColumnNumber", 0);
        this.rowNum = new JetNumber(this, "RowNumber", 0);
    }

    public JetRptChartPlatform() {
        this.BUILTINTYPES();
        Vector vector = ReportFormat.getMoreFormat(2, 0);
        Vector vector2 = ReportFormat.getMoreFormat(-5, 0);
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector.contains(vector2.elementAt(i))) continue;
            vector.addElement(vector2.elementAt(i));
        }
        this.format.setList(vector);
        this.format.set((String)vector.elementAt(0));
        vector = ReportFormat.getMoreFormat(12, 0);
        this.grpValueFormat.setList(vector);
        this.grpValueFormat.set((String)vector.elementAt(0));
        this.sortX.set("None");
        this.sortZ.set("None");
        this.isCombo.set(false);
        this.primaryType.setEnumerationSet(chartTypes);
        this.secondType.setEnumerationSet(comboTypes);
        this.I();
        this.penStyle.set("Solid Line");
        this.endCaps.set("Square");
        this.lineJoint.set("Miter");
        this.fillPattern.set("None");
        this.layout.set("Tile");
        this.textureStyle.set("Small Dot");
        this.gradientStyle.set("Linear");
        this.iNHeight = JetRptChartPlatform.convertSize(400);
        this.iNWidth = JetRptChartPlatform.convertSize(500);
        this.setObjectType(71);
        this.dataSource.setEditFlag(0);
        this.primaryType.setEditFlag(0);
        this.secondType.setEditFlag(0);
        this.isCombo.setEditFlag(0);
        this.group1.setEditFlag(0);
        this.group2.setEditFlag(0);
        this.value.setEditFlag(0);
        this.grp1Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.grp2Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.grp3Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.priFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.secFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.catFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.serFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.outlined.setCanChangeByOthers(false);
        this.variabledDash.setCanChangeByOthers(false);
        this.top.setCanChangeByOthers(false);
        this.bottom.setCanChangeByOthers(false);
        this.left.setCanChangeByOthers(false);
        this.right.setCanChangeByOthers(false);
        this.columnNum.setCanChangeByOthers(false);
        this.rowNum.setCanChangeByOthers(false);
        this.style.setDefault("ChartPlatform");
        if (this.style.getList() == null) {
            Vector<String> vector3 = new Vector<String>();
            vector3.add("ChartPlatform");
            this.style.setList(vector3);
        } else if (!this.style.getList().contains("ChartPlatform")) {
            this.style.getList().insertElementAt("ChartPlatform", 0);
        }
    }

    public ChartDataSetInfo[] getChartDataSetInfos() {
        ChartDataSetInfo[] chartDataSetInfoArray = this.isCombo.get() ? new ChartDataSetInfo[]{new ChartDataSetInfo((Integer)this.primaryType.get()), new ChartDataSetInfo((Integer)this.secondType.get())} : new ChartDataSetInfo[]{new ChartDataSetInfo((Integer)this.primaryType.get())};
        return chartDataSetInfoArray;
    }

    public void setChartDataSetInfos(ChartDataSetInfo[] chartDataSetInfoArray) {
        boolean bl = chartDataSetInfoArray.length > 1;
        this.isCombo.set(bl);
        this.primaryType.set(JetChartPropertyValues.mapTypeFromIntToStr(chartDataSetInfoArray[0].getChartType()));
        if (bl) {
            this.secondType.set(JetChartPropertyValues.mapTypeFromIntToStr(chartDataSetInfoArray[1].getChartType()));
        }
    }

    public static ChartDataFilter getFilter(JetVector jetVector) {
        Vector vector = jetVector.get();
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        ChartDataFilter chartDataFilter = new ChartDataFilter();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            String string = vector.elementAt(i).toString();
            Object[] objectArray = new Object[]{(int)Integer.valueOf(string.substring(0, 1)), string.substring(1)};
            vector2.add(objectArray);
        }
        chartDataFilter.setFilters(vector2);
        return chartDataFilter;
    }

    public static String getFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            for (int i = 0; i < chartDataFilter.getFilters().size(); ++i) {
                if (i != 0) {
                    string = string + "\u0007";
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(i);
                string = string + objectArray[0].toString() + objectArray[1].toString();
            }
        }
        return string;
    }

    public ChartPenStyle getPen() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(this.penColor.get());
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setDashPattern(this.penStyle.intValue());
        chartColorPattern.setColor((Color)this.penColor.getValue());
        chartColorPattern.setAlpha((float)this.borderTrans.intValue() / 100.0f);
        chartPenStyle.setPenWidth(this.penThickness.intValue());
        chartPenStyle.setEndCaps(this.endCaps.intValue());
        chartPenStyle.setPenColor(chartColorPattern);
        chartPenStyle.setLineJoints(this.lineJoint.intValue());
        chartPenStyle.setOutlined(this.outlined.booleanValue());
        chartPenStyle.setVariabledDash(this.variabledDash.booleanValue());
        return chartPenStyle;
    }

    public ChartFillPattern getPattern(Component component) {
        ChartFillPattern chartFillPattern = null;
        switch (this.fillPattern.intValue()) {
            case 0: {
                return null;
            }
            case 1: {
                chartFillPattern = new ChartColorPattern((Color)this.bgColor.getValue());
                ((ChartColorPattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                break;
            }
            case 2: {
                try {
                    chartFillPattern = new ChartTexturePattern(this.textureStyle.intValue(), new ChartColorPattern((Color)this.tForeColor.getValue()), new ChartColorPattern((Color)this.tBackColor.getValue()));
                    ((ChartTexturePattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                try {
                    chartFillPattern = new ChartGradientPattern(this.gradientStyle.intValue());
                    ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern((Color)this.startColor.getValue()));
                    ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern((Color)this.endColor.getValue()));
                    ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)this.gradX1.intValue() / 100.0f, 1.0f - (float)this.gradY1.intValue() / 100.0f));
                    ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)this.gradX2.intValue() / 100.0f, 1.0f - (float)this.gradY2.intValue() / 100.0f));
                    ((ChartGradientPattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                String string = this.image.get();
                if (string == null || string.length() <= 0) break;
                float f = (float)this.imgX.intValue() / 100.0f;
                float f2 = 1.0f - (float)this.imgY.intValue() / 100.0f;
                float f3 = (float)this.imgWidth.intValue() / 100.0f;
                float f4 = (float)this.imgHeight.intValue() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = this.layout.intValue();
                float f5 = (float)this.bgTrans.intValue() / 100.0f;
                String string2 = "";
                String string3 = string2 + File.separator + this.image.get();
                chartFillPattern = new ChartCustomizedPattern(string3, float_, n, f5);
            }
        }
        return chartFillPattern;
    }

    @Override
    public String getInstancePrefix() {
        return "ChartPlatform";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("ChartPlatform");
    }

    @Override
    public synchronized void afterInit() {
        if (!this.isAfterInit()) {
            Vector vector;
            int n;
            if (((JetRootable)((Object)JetObject.getRoot(this))).getVersion() <= 65550) {
                n = 1;
                vector = this.group1.get();
                for (String string : vector) {
                    if (string.equals("")) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    this.set("Category", "");
                }
            }
            if (((JetRootable)((Object)JetObject.getRoot(this))).getVersion() <= 65541) {
                int n2;
                if (this.start1st.isChangeByOther()) {
                    String string = (String)this.start1st.getChangeByObject();
                    this.start1st.set(0);
                    this.end1st.setChangeByObject(string);
                    this.start2nd.set(0);
                    this.end2nd.setChangeByObject(string);
                } else {
                    n = this.start1st.intValue();
                    if (n > 0) {
                        this.start1st.set(0);
                        this.end1st.set(n - 1);
                        n = this.start2nd.intValue();
                        this.start2nd.set(0);
                        this.end2nd.set(n - 1);
                    }
                }
                if (this.getBackgroundChBy()) {
                    this.bgColor.setChangeByObject(this.cFBackground);
                    this.penColor.setChangeByObject(this.cFBackground);
                } else {
                    Color color = this.cNBackground;
                    this.bgColor.set(color);
                    this.penColor.set(color);
                }
                String string = (String)this.image.getValue();
                if (string == null || string.length() < 1) {
                    this.fillPattern.set(1);
                } else {
                    this.fillPattern.set(4);
                    this.layout.set(2);
                }
                vector = this.grp1Patternlist.get();
                Vector<String> vector2 = new Vector();
                int n3 = vector == null ? 0 : vector.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    vector2.addElement("c" + this.CHART_PATTERN_LIST_EDITOR((String)vector.elementAt(n2)) + "000");
                }
                if (n3 > 0) {
                    this.grp1Patternlist.set(vector2);
                }
                vector = this.grp2Patternlist.get();
                vector2 = new Vector<String>();
                n3 = vector == null ? 0 : vector.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    vector2.addElement("c" + this.CHART_PATTERN_LIST_EDITOR((String)vector.elementAt(n2)) + "000");
                }
                if (n3 > 0) {
                    this.grp2Patternlist.set(vector2);
                }
                this.CHART_FILTER_EDITOR_NO_DATE();
            }
        }
        this.CHART_FILTER_EDITOR();
        this.DEFAULTCOLORS();
        super.afterInit();
    }

    private void CHART_FILTER_EDITOR() {
        int n;
        Vector vector = this.grp1Patternlist.get();
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            this.grp3Patternlist.set(vector);
        }
        int n3 = n = (vector = this.grp2Patternlist.get()) == null ? 0 : vector.size();
        if (n > 0) {
            this.grp3Patternlist.set(vector);
        }
        int n4 = n = (vector = this.grp3Patternlist.get()) == null ? 0 : vector.size();
        if (n == 0) {
            this.grp3Patternlist.set(JetChartPropertyValues.getDefaultPatternString());
        } else if (n < JetChartPropertyValues.COLORLENGTH) {
            for (int i = n; i < JetChartPropertyValues.COLORLENGTH; ++i) {
                vector.add("c0x" + Integer.toHexString(JetChartPropertyValues.DEFAULTCOLORS[i]) + "000");
            }
            this.grp3Patternlist.set(vector);
        }
    }

    private void CHART_FILTER_EDITOR_NO_DATE() {
        Object object;
        int n;
        Vector vector = this.getChildren();
        Object var2_2 = null;
        int n2 = Unit.convertInchToUnit(0.02);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (n = vector.size() - 1; n >= 0; --n) {
            JRObjectTemplate jRObjectTemplate;
            var2_2 = vector.elementAt(n);
            if (var2_2 instanceof JetRptChartLegend) {
                jRObjectTemplate = var2_2;
                bl = jRObjectTemplate.showlegend.get() && (!jRObjectTemplate.hideCategory.get() || !jRObjectTemplate.hideSeries.get());
                jRObjectTemplate.iNX = -1;
                jRObjectTemplate.iNY = -1;
                jRObjectTemplate.iNWidth = -1;
                jRObjectTemplate.iNHeight = -1;
                if (jRObjectTemplate.x == null) continue;
                jRObjectTemplate.x.setUnitValue(-1);
                jRObjectTemplate.y.setUnitValue(-1);
                jRObjectTemplate.width.setUnitValue(-1);
                jRObjectTemplate.height.setUnitValue(-1);
                continue;
            }
            if (!(var2_2 instanceof JetRptChartLabel)) continue;
            jRObjectTemplate = var2_2;
            object = ((JetRptChartLabel)jRObjectTemplate).text.get();
            if (object != null && !((String)object).equals("")) {
                String string = (String)((JetRptChartLabel)jRObjectTemplate).location.get();
                ((JetRptChartLabel)jRObjectTemplate).iNHeight += 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit();
                if (string.equals("North")) {
                    n4 = ((JetRptChartLabel)jRObjectTemplate).iNHeight;
                } else if (string.equals("South")) {
                    n5 = ((JetRptChartLabel)jRObjectTemplate).iNHeight;
                }
                if (object == null || ((String)object).length() == 0) {
                    this.remove(jRObjectTemplate);
                    continue;
                }
                Font font = FontSets.getFont(((JetRptChartLabel)jRObjectTemplate).fontName.get(), (int)((Integer)((JetRptChartLabel)jRObjectTemplate).fontStyle.get()), ((JetRptChartLabel)jRObjectTemplate).fontSize.get());
                FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n6 = Unit.convertPixelToUnit(fontMetrics.stringWidth((String)object));
                if (string.equals("North")) {
                    ((JetRptChartLabel)jRObjectTemplate).iNX = (this.iNWidth - (n6 + n2 * 2)) / 2;
                    ((JetRptChartLabel)jRObjectTemplate).iNY = n2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0);
                    ((JetRptChartLabel)jRObjectTemplate).iNWidth = n6 + n2 * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit();
                    ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Center");
                } else if (string.equals("South")) {
                    ((JetRptChartLabel)jRObjectTemplate).iNX = (this.iNWidth - (n6 + n2 * 2)) / 2;
                    ((JetRptChartLabel)jRObjectTemplate).iNY = this.iNHeight - (((JetRptChartLabel)jRObjectTemplate).iNHeight + n2) - (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0);
                    ((JetRptChartLabel)jRObjectTemplate).iNWidth = n6 + n2 * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit();
                    ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Center");
                } else {
                    n3 = n6 + n2 * 2;
                    ((JetRptChartLabel)jRObjectTemplate).iNX = n2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0);
                    ((JetRptChartLabel)jRObjectTemplate).iNY = (this.iNHeight - (((JetRptChartLabel)jRObjectTemplate).iNHeight + n2 * 2)) / 2;
                    ((JetRptChartLabel)jRObjectTemplate).iNWidth = n6 + n2 * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit();
                    ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Left");
                }
            } else {
                this.remove((JetObject)var2_2);
            }
            if (((JetRptChartLabel)jRObjectTemplate).x == null) continue;
            ((JetRptChartLabel)jRObjectTemplate).x.setUnitValue(((JetRptChartLabel)jRObjectTemplate).iNX);
            ((JetRptChartLabel)jRObjectTemplate).y.setUnitValue(((JetRptChartLabel)jRObjectTemplate).iNY);
            ((JetRptChartLabel)jRObjectTemplate).width.setUnitValue(((JetRptChartLabel)jRObjectTemplate).iNWidth);
            ((JetRptChartLabel)jRObjectTemplate).height.setUnitValue(((JetRptChartLabel)jRObjectTemplate).iNHeight);
        }
        n = Unit.convertPixelToUnit(3);
        for (int i = 0; i < vector.size(); ++i) {
            var2_2 = vector.elementAt(i);
            if (!(var2_2 instanceof JetRptChartCoordinatepaper)) continue;
            object = var2_2;
            ((JetRptChartCoordinatepaper)object).iNX = n3 + n2 * 2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0);
            ((JetRptChartCoordinatepaper)object).iNY = n4 + n2 * 2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0);
            ((JetRptChartCoordinatepaper)object).iNWidth = this.iNWidth - n3 - (bl ? this.iNWidth * 3 / 16 + n2 * (this.borderStyle.intValue() != 3 ? 5 : 6) + n : 0) - 2 * this.penThickness.getUnit();
            ((JetRptChartCoordinatepaper)object).iNHeight = this.iNHeight - (n4 + n5 + n2 * 4) - 2 * this.penThickness.getUnit();
            if (((JetRptChartCoordinatepaper)object).x == null) continue;
            ((JetRptChartCoordinatepaper)object).x.setUnitValue(((JetRptChartCoordinatepaper)object).iNX);
            ((JetRptChartCoordinatepaper)object).y.setUnitValue(((JetRptChartCoordinatepaper)object).iNY);
            ((JetRptChartCoordinatepaper)object).width.setUnitValue(((JetRptChartCoordinatepaper)object).iNWidth);
            ((JetRptChartCoordinatepaper)object).height.setUnitValue(((JetRptChartCoordinatepaper)object).iNHeight);
        }
        Vector vector2 = this.group1.get();
        object = (String)vector2.elementAt(0);
        if (object != null && !((String)object).equals("")) {
            this.section.set((String)object);
        }
        this.catGroup.add("1");
    }

    private String CHART_PATTERN_LIST_EDITOR(String string) {
        String string2;
        int n = 8 - string.length();
        switch (n) {
            case 1: {
                string2 = "0";
                break;
            }
            case 2: {
                string2 = "00";
                break;
            }
            case 3: {
                string2 = "000";
                break;
            }
            case 4: {
                string2 = "0000";
                break;
            }
            case 5: {
                string2 = "00000";
                break;
            }
            case 6: {
                string2 = "000000";
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (n <= 0) {
            return string;
        }
        return "0x" + string2 + string.substring(2);
    }

    private static int COLORLENGTH(int n) {
        int n2 = 3;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 1;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        return n2;
    }

    public JetRptChartCoordinatepaper get3DPaper() {
        Vector vector = this.getChildren();
        JetRptChartCoordinatepaper jetRptChartCoordinatepaper = null;
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)vector.get(i);
            if (jRObjectTemplate.getObjectType() != 72) continue;
            jetRptChartCoordinatepaper = (JetRptChartCoordinatepaper)jRObjectTemplate;
            break;
        }
        return jetRptChartCoordinatepaper;
    }

    public JetRptChart2DCoordinatepaper get2DPaper() {
        Vector vector = this.getChildren();
        JetRptChart2DCoordinatepaper jetRptChart2DCoordinatepaper = null;
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)vector.get(i);
            if (jRObjectTemplate.getObjectType() != 74) continue;
            jetRptChart2DCoordinatepaper = (JetRptChart2DCoordinatepaper)jRObjectTemplate;
            break;
        }
        return jetRptChart2DCoordinatepaper;
    }

    public JetRptChartLegend getLegend() {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        for (int i = 0; i < vector.size() && (jRObjectTemplate = (JRObjectTemplate)vector.elementAt(i)).getObjectType() != 70; ++i) {
        }
        return (JetRptChartLegend)jRObjectTemplate;
    }

    public JetRptChartLabel getChartLabel(String string) {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        for (int i = 0; i < vector.size(); ++i) {
            jRObjectTemplate = (JRObjectTemplate)vector.elementAt(i);
            if (jRObjectTemplate.getObjectType() != 69 || !((String)((JetEnumeration)jRObjectTemplate.getPropertyByName("LabelLocation")).getObject()).equals(string)) continue;
            return (JetRptChartLabel)jRObjectTemplate;
        }
        return null;
    }

    public boolean isByOneGroup() {
        Vector vector = this.group2.get();
        return vector == null || vector.size() == 0;
    }

    @Override
    public JetProperty nameToProperty(String string) {
        String[] stringArray = (String[])ChangedProperties.htJetRptChartPlatform.get(string);
        if (stringArray != null) {
            return super.nameToProperty(stringArray[0]);
        }
        return super.nameToProperty(string);
    }

    public void checkChart() {
        JetObject jetObject;
        JetObject jetObject2 = JetRptChartPlatform.getRoot(this);
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)jetObject2;
        TreeIterater treeIterater = new TreeIterater(jetRptReportPanel, false);
        String string = null;
        String string2 = null;
        JetRptDataSource jetRptDataSource = V7XObjectUtil.getDataSource(jetRptReportPanel);
        DataSet dataSet = ReportTools.getDataSet(this);
        String string3 = dataSet != null ? ((JetRptQueryDataSet)dataSet).getQueryName() : jetRptDataSource.uQueryName.get();
        if (string3 == null || string3.length() <= 0) {
            return;
        }
        Vector vector = V7XObjectUtil.getGroupPanels(jetRptReportPanel);
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)vector.elementAt(i);
            vector2.addElement(jetRptGroupPanel.nameToProperty("GroupBy").toUnitString());
        }
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject != this) continue;
            JetRptChartPlatform jetRptChartPlatform = (JetRptChartPlatform)jetObject;
            if (!jetRptChartPlatform.isByOneGroup()) {
                int n2 = 0;
                int n3 = 0;
                Vector vector3 = jetRptChartPlatform.group1.get();
                Vector vector4 = jetRptChartPlatform.group2.get();
                if (vector3 != null && vector3.size() > 0) {
                    string = (String)vector3.elementAt(0);
                }
                if (vector4 != null && vector4.size() > 0) {
                    string2 = (String)vector4.elementAt(0);
                }
                for (int i = 0; i < n; ++i) {
                    if (((String)vector2.elementAt(i)).equalsIgnoreCase(string)) {
                        n2 = i;
                        continue;
                    }
                    if (!((String)vector2.elementAt(i)).equalsIgnoreCase(string2)) continue;
                    n3 = i;
                }
                if (n3 > n2) {
                    return;
                }
                String string4 = new String(string);
                string = string2;
                string2 = string4;
                this.group1 = new JetColumnVector(this, "Category");
                this.group2 = new JetColumnVector(this, "Series");
                this.group1.add(string);
                this.group2.add(string2);
            }
            return;
        }
    }

    private void DEFAULTCOLORS() {
        int n;
        Object object;
        Object object2;
        if (this.primaryType.get() == null && this.secondType.get() == null) {
            if (this.type.get() instanceof Integer) {
                this.isCombo.set(false);
                this.primaryType.set(this.type.get());
            } else if (this.type.get() instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.type.get();
                object2 = (int[])arrayList.get(0);
                object = (int[])arrayList.get(1);
                this.isCombo.set(true);
                this.primaryType.set(ChartTypeInfo.BUILTINTYPES[object2[0]][object2[1]]);
                this.secondType.set(ChartTypeInfo.BUILTINTYPES[object[0]][object[1]]);
                if (object[0] == 3) {
                    this.get2DPaper().reversePaintingOrder.set(true);
                }
            }
        }
        if ((n = ((JetRootable)((Object)JetObject.getRoot(this))).getVersion()) >= 65541 && n < 65545) {
            object2 = this.get2DPaper();
            if (object2 != null) {
                ((JetRptChart2DCoordinatepaper)object2).keepOldLayout.set(true);
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapX.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapX.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapY.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapY.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapY2.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapY2.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthX.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthX.set(8);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY1.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY1.set(8);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY2.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY2.set(8);
                }
            }
            object = this.getLegend();
            ((JetRptChartLegend)object).showlegend.set(this.isByOneGroup() && !this.isCombo.booleanValue() ? !((JetRptChartLegend)object).hideCategory.booleanValue() : !((JetRptChartLegend)object).hideSeries.booleanValue());
        }
    }

    private void I() {
        this.type.setEnumerationSet((Hashtable)chartTypes.clone());
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = 0;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 2};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[2];
        nArray[0] = 0;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 1;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[2];
        nArray[0] = 2;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DLineArray-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[]{3, 1};
        nArray[0] = 0;
        nArray[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-AreaStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-AreaStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 2};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-AreaStack2Y", arrayList);
        this.type.set("3DBarArray");
    }

    public Hashtable getPropertiesForAdhoc() {
        int n = Unit.convertPixelToUnit(this.x.intValue());
        int n2 = Unit.convertPixelToUnit(this.y.intValue());
        int n3 = Unit.convertPixelToUnit(this.width.intValue());
        int n4 = Unit.convertPixelToUnit(this.height.intValue());
        int n5 = this.start2nd.intValue();
        int n6 = this.end2nd.intValue();
        int n7 = this.start1st.intValue();
        int n8 = this.end1st.intValue();
        Hashtable hashtable = (Hashtable)this.getProperties().clone();
        hashtable.put("X", n);
        hashtable.put("Y", n2);
        hashtable.put("Width", n3);
        hashtable.put("Height", n4);
        hashtable.put("StartOffsetX", n7);
        hashtable.put("EndOffsetX", n8);
        hashtable.put("StartOffsetZ", n5);
        hashtable.put("EndOffsetZ", n6);
        hashtable.put("SortX", this.sortX.intValue());
        hashtable.put("SortZ", this.sortZ.intValue());
        ChartFillPattern[] chartFillPatternArray = null;
        ChartFillPattern[] chartFillPatternArray2 = null;
        ChartFillPattern[] chartFillPatternArray3 = null;
        Vector vector = this.grp1Patternlist.get();
        int n9 = 0;
        if (vector != null) {
            n9 = vector.size();
        }
        if (n9 != 0) {
            chartFillPatternArray = JetChartPropertyValues.mapPatterns(vector);
        }
        if (chartFillPatternArray == null) {
            hashtable.put("OuterPatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray);
            hashtable.put("OuterPatternList", string);
            hashtable.put("OuterFillPatternLength", chartFillPatternArray.length);
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", chartFillPatternArray.length);
        }
        Vector vector2 = this.grp2Patternlist.get();
        n9 = 0;
        if (vector2 != null) {
            n9 = vector2.size();
        }
        if (n9 != 0) {
            chartFillPatternArray2 = JetChartPropertyValues.mapPatterns(vector2);
        }
        if (chartFillPatternArray2 == null) {
            hashtable.put("InnerPatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray2);
            hashtable.put("InnerPatternList", string);
            hashtable.put("InnerFillPatternLength", chartFillPatternArray2.length);
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", chartFillPatternArray2.length);
        }
        Vector vector3 = this.grp3Patternlist.get();
        n9 = 0;
        if (vector3 != null) {
            n9 = vector3.size();
        }
        if (n9 != 0) {
            chartFillPatternArray3 = JetChartPropertyValues.mapPatterns(vector3);
        }
        if (chartFillPatternArray3 == null) {
            hashtable.put("PatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray3);
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", chartFillPatternArray3.length);
        }
        hashtable.put("PrimaryDataFilter", "");
        hashtable.put("SecondaryDataFilter", "");
        hashtable.put("CategoryFilter", "");
        hashtable.put("SeriesFilter", "");
        hashtable.put("BorderStyle", this.borderStyle.intValue());
        hashtable.put("PenStyle", this.penStyle.intValue());
        hashtable.put("EndCaps", this.endCaps.intValue());
        hashtable.put("LineJoint", this.lineJoint.intValue());
        hashtable.put("FillPattern", this.fillPattern.intValue());
        hashtable.put("TextureStyle", this.textureStyle.intValue());
        hashtable.put("GradientStyle", this.gradientStyle.intValue());
        hashtable.put("ImageLayout", this.layout.intValue());
        return hashtable;
    }

    public String getGroupPatternString(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        for (int i = 0; i < chartFillPatternArray.length; ++i) {
            String string2;
            Color color;
            String string3;
            String string4;
            int n;
            ChartFillPattern chartFillPattern;
            Color color2;
            if (i != 0) {
                string = string + "@";
            }
            string = string + i;
            if (chartFillPatternArray[i] == null) {
                string = string + "~";
                string = string + "0";
                string = string + "~";
                string = string + "0";
                continue;
            }
            if (chartFillPatternArray[i] instanceof ChartColorPattern) {
                string = string + "~";
                string = string + chartFillPatternArray[i].getAlpha();
                string = string + "~1~";
                color2 = ((ChartColorPattern)chartFillPatternArray[i]).getColor();
                if (color2 != null) {
                    string = string + MiscTools.mapColorToString(color2);
                    continue;
                }
                string = string + "Transparent";
                continue;
            }
            if (chartFillPatternArray[i] instanceof ChartTexturePattern) {
                string = string + "~";
                string = string + chartFillPatternArray[i].getAlpha();
                string = string + "~2~";
                chartFillPattern = (ChartTexturePattern)chartFillPatternArray[i];
                n = ((ChartTexturePattern)chartFillPattern).getPattern();
                string4 = "";
                if (n < 10) {
                    string4 = "0";
                }
                string4 = string4 + String.valueOf((Object)n);
                color2 = ((ChartTexturePattern)chartFillPattern).getForeground().getColor();
                string3 = color2 != null ? MiscTools.mapColorToString(color2) : "Transparent";
                color = ((ChartTexturePattern)chartFillPattern).getBackground().getColor();
                string2 = color != null ? MiscTools.mapColorToString(color) : "Transparent";
                string = string + string4 + "~" + string3 + "~" + string2;
                continue;
            }
            if (!(chartFillPatternArray[i] instanceof ChartGradientPattern)) continue;
            string = string + "~";
            string = string + chartFillPatternArray[i].getAlpha();
            string = string + "~3~";
            chartFillPattern = (ChartGradientPattern)chartFillPatternArray[i];
            n = ((ChartGradientPattern)chartFillPattern).getPattern();
            string4 = "";
            if (n < 10) {
                string4 = "0";
            }
            string4 = string4 + String.valueOf((Object)n);
            color2 = ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
            string3 = color2 != null ? MiscTools.mapColorToString(color2) : "Transparent";
            color = ((ChartGradientPattern)chartFillPattern).getEndColor().getColor();
            string2 = color != null ? MiscTools.mapColorToString(color) : "Transparent";
            int n2 = (int)(((ChartGradientPattern)chartFillPattern).getStartPoint().getX() * 100.0);
            int n3 = (int)((1.0 - ((ChartGradientPattern)chartFillPattern).getStartPoint().getY()) * 100.0);
            int n4 = (int)(((ChartGradientPattern)chartFillPattern).getEndPoint().getX() * 100.0);
            int n5 = (int)((1.0 - ((ChartGradientPattern)chartFillPattern).getEndPoint().getY()) * 100.0);
            String string5 = "";
            if (n2 < 10) {
                string5 = "00";
            } else if (n2 < 100) {
                string5 = "0";
            }
            string5 = string5 + String.valueOf((Object)n2);
            String string6 = "";
            if (n4 < 10) {
                string6 = "00";
            } else if (n4 < 100) {
                string6 = "0";
            }
            string6 = string6 + String.valueOf((Object)n4);
            String string7 = "";
            if (n3 < 10) {
                string7 = "00";
            } else if (n3 < 100) {
                string7 = "0";
            }
            string7 = string7 + String.valueOf((Object)n3);
            String string8 = "";
            if (n5 < 10) {
                string8 = "00";
            } else if (n5 < 100) {
                string8 = "0";
            }
            string8 = string8 + String.valueOf((Object)n5);
            string = string + string4 + "~" + string3 + "~" + string2 + "~" + string5 + "~" + string7 + "~" + string6 + "~" + string8;
        }
        return string;
    }

    @Override
    public JetRptChartPlatform deepDupWithoutCopyProperties(Hashtable hashtable, Hashtable hashtable2, boolean bl, boolean bl2) {
        JetRptChartPlatform jetRptChartPlatform = null;
        jetRptChartPlatform = (JetRptChartPlatform)super.deepDupWithoutCopyProperties(hashtable, hashtable2, bl, bl2);
        jetRptChartPlatform.setLinkedTemplate(this);
        jetRptChartPlatform.primaryType.addPropertyChangeListener(jetRptChartPlatform);
        jetRptChartPlatform.secondType.addPropertyChangeListener(jetRptChartPlatform);
        return jetRptChartPlatform;
    }

    public JetRptChartPlatform getLinkedTemplate() {
        return this.BUILTINTYPES;
    }

    public void setLinkedTemplate(JetRptChartPlatform jetRptChartPlatform) {
        this.BUILTINTYPES = jetRptChartPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.BUILTINTYPES != null) {
            JetRptChartPlatform jetRptChartPlatform = this.BUILTINTYPES;
            synchronized (jetRptChartPlatform) {
                JetChartTypeEnumeration jetChartTypeEnumeration = this.BUILTINTYPES.primaryType;
                JetChartTypeEnumeration jetChartTypeEnumeration2 = this.BUILTINTYPES.secondType;
                jetChartTypeEnumeration.runtime = true;
                if (this.primaryType.runtime) {
                    jetChartTypeEnumeration.set(this.primaryType.get());
                } else if (this.secondType.runtime) {
                    jetChartTypeEnumeration2.runtime = true;
                    jetChartTypeEnumeration2.set(this.secondType.get());
                }
            }
        }
    }

    @Override
    public Vector getChildren() {
        Vector vector = this.BUILTINTYPES != null ? this.BUILTINTYPES.getChildren() : super.getChildren();
        return vector;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.height.setUnitValue(JetRptChartPlatform.convertSize(400));
        this.width.setUnitValue(JetRptChartPlatform.convertSize(500));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (CHART_FILTER_EDITOR == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (CHART_FILTER_EDITOR == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("PenThickness", n++);
                    hashMap.put("Outline", n++);
                    hashMap.put("FillPattern", n++);
                    hashMap.put("SortX", n++);
                    hashMap.put("AntiAliasing", n++);
                    hashMap.put("Left", n++);
                    hashMap.put("GradientEndColor", n++);
                    hashMap.put("Section", n++);
                    hashMap.put("ColumnNumber", n++);
                    hashMap.put("VariabledDash", n++);
                    hashMap.put("SizeOfPart1", n++);
                    hashMap.put("GradientStartColor", n++);
                    hashMap.put("InnerGroupPatternList", n++);
                    hashMap.put("GradientStartX", n++);
                    hashMap.put("ImageLayout", n++);
                    hashMap.put("SortZ", n++);
                    hashMap.put("TextureBackColor", n++);
                    hashMap.put("SeriesFilter", n++);
                    hashMap.put("GroupValueFormat", n++);
                    hashMap.put("PrimaryDataFilter", n++);
                    hashMap.put("PrimaryType", n++);
                    hashMap.put("ImageX", n++);
                    hashMap.put("OuterGroupPatternList", n++);
                    hashMap.put("BackgroundColor", n++);
                    hashMap.put("IsCombo", n++);
                    hashMap.put("StartOffset(1st Data Set)", n++);
                    hashMap.put("Type", n++);
                    hashMap.put("Right", n++);
                    hashMap.put("GradientEndX", n++);
                    hashMap.put("ImageHeight", n++);
                    hashMap.put("CatGroup", n++);
                    hashMap.put("ImageY", n++);
                    hashMap.put("EndOffset(2nd Data Set)", n++);
                    hashMap.put("RowNumber", n++);
                    hashMap.put("SecondType", n++);
                    hashMap.put("PatternList", n++);
                    hashMap.put("Top", n++);
                    hashMap.put("ReverseRows", n++);
                    hashMap.put("BorderTransparency", n++);
                    hashMap.put("HintFormat", n++);
                    hashMap.put("Category", n++);
                    hashMap.put("Series", n++);
                    hashMap.put("ReverseColumns", n++);
                    hashMap.put("AutoLayout", n++);
                    hashMap.put("StartOffset(2nd Data Set)", n++);
                    hashMap.put("Bottom", n++);
                    hashMap.put("CategoryFilter", n++);
                    hashMap.put("SecondaryDataFilter", n++);
                    hashMap.put("ImageWidth", n++);
                    hashMap.put("EndOffset(1st Data Set)", n++);
                    hashMap.put("PenColor", n++);
                    hashMap.put("PenStyle", n++);
                    hashMap.put("TextureStyle", n++);
                    hashMap.put("LineJoint", n++);
                    hashMap.put("ZHyperLink", n++);
                    hashMap.put("BackgroundTransparency", n++);
                    hashMap.put("Horizontal", n++);
                    hashMap.put("GradientEndY", n++);
                    hashMap.put("TextureForeColor", n++);
                    hashMap.put("HyperLink", n++);
                    hashMap.put("DataSource", n++);
                    hashMap.put("Image", n++);
                    hashMap.put("EndCaps", n++);
                    hashMap.put("GradientStyle", n++);
                    hashMap.put("GradientStartY", n++);
                    hashMap.put("Value", n++);
                    hashMap.put("SameLevel", n++);
                    hashMap.put("XHyperLink", n++);
                    hashMap.put("BorderStyle", n++);
                    CHART_FILTER_EDITOR = hashMap;
                }
            }
        }
        return CHART_FILTER_EDITOR;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (CHART_FILTER_EDITOR_NO_DATE != null) {
                return CHART_FILTER_EDITOR_NO_DATE;
            }
            CHART_FILTER_EDITOR_NO_DATE = JetRptChartPlatform.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (CHART_FILTER_EDITOR_NO_DATE == null) {
                CHART_FILTER_EDITOR_NO_DATE = new HashVector();
            }
        } else {
            return null;
        }
        String string = "Excel";
        Vector<String> vector = (Vector<String>)CHART_FILTER_EDITOR_NO_DATE.get(string);
        vector.add("ColumnNumber");
        vector.add("RowNumber");
        string = "Color";
        CHART_FILTER_EDITOR_NO_DATE.remove(string);
        string = "Others";
        vector = (List)CHART_FILTER_EDITOR_NO_DATE.get(string);
        vector.remove("RecordLocation");
        string = "DataSource";
        vector = new Vector<String>(23);
        CHART_FILTER_EDITOR_NO_DATE.putAt(string, vector, 0);
        vector.add("IsCombo");
        vector.add("PrimaryType");
        vector.add("SecondType");
        vector.add("Category");
        vector.add("Series");
        vector.add("Value");
        vector.add("StartOffset(1st Data Set)");
        vector.add("EndOffset(1st Data Set)");
        vector.add("StartOffset(2nd Data Set)");
        vector.add("EndOffset(2nd Data Set)");
        vector.add("ReverseRows");
        vector.add("ReverseColumns");
        vector.add("PatternList");
        vector.add("PrimaryDataFilter");
        vector.add("SecondaryDataFilter");
        vector.add("CategoryFilter");
        vector.add("SeriesFilter");
        vector.add("SizeOfPart1");
        vector.add("SortX");
        vector.add("SortZ");
        vector.add("HyperLink");
        vector.add("XHyperLink");
        vector.add("ZHyperLink");
        string = "Platform";
        vector = new Vector(35);
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        vector.add("BorderStyle");
        vector.add("PenStyle");
        vector.add("PenColor");
        vector.add("PenThickness");
        vector.add("EndCaps");
        vector.add("LineJoint");
        vector.add("Outline");
        vector.add("VariabledDash");
        vector.add("BorderTransparency");
        vector.add("FillPattern");
        vector.add("BackgroundTransparency");
        vector.add("Top");
        vector.add("Left");
        vector.add("Right");
        vector.add("Bottom");
        vector.add("BackgroundColor");
        vector.add("TextureStyle");
        vector.add("TextureForeColor");
        vector.add("TextureBackColor");
        vector.add("GradientStyle");
        vector.add("GradientStartColor");
        vector.add("GradientEndColor");
        vector.add("GradientStartX");
        vector.add("GradientStartY");
        vector.add("GradientEndX");
        vector.add("GradientEndY");
        vector.add("Image");
        vector.add("ImageLayout");
        vector.add("ImageX");
        vector.add("ImageY");
        vector.add("ImageWidth");
        vector.add("ImageHeight");
        vector.add("AntiAliasing");
        vector.add("HintFormat");
        vector.add("GroupValueFormat");
        return CHART_FILTER_EDITOR_NO_DATE;
    }

    static {
        chartTypes.put("2DBarSideBySide", ChartTypeInfo.BUILTINTYPES[0][0]);
        chartTypes.put("2DBarStack", ChartTypeInfo.BUILTINTYPES[0][1]);
        chartTypes.put("2DBarPercent", ChartTypeInfo.BUILTINTYPES[0][2]);
        chartTypes.put("3DBarSideBySide", ChartTypeInfo.BUILTINTYPES[0][3]);
        chartTypes.put("3DBarStack", ChartTypeInfo.BUILTINTYPES[0][4]);
        chartTypes.put("3DBarPercent", ChartTypeInfo.BUILTINTYPES[0][5]);
        chartTypes.put("3DBarArray", ChartTypeInfo.BUILTINTYPES[0][6]);
        chartTypes.put("2DBenchSideBySide", ChartTypeInfo.BUILTINTYPES[1][0]);
        chartTypes.put("2DBenchStack", ChartTypeInfo.BUILTINTYPES[1][1]);
        chartTypes.put("2DBenchPercent", ChartTypeInfo.BUILTINTYPES[1][2]);
        chartTypes.put("3DBenchSideBySide", ChartTypeInfo.BUILTINTYPES[1][3]);
        chartTypes.put("3DBenchStack", ChartTypeInfo.BUILTINTYPES[1][4]);
        chartTypes.put("3DBenchPercent", ChartTypeInfo.BUILTINTYPES[1][5]);
        chartTypes.put("3DBenchArray", ChartTypeInfo.BUILTINTYPES[1][6]);
        chartTypes.put("2DLineArray", ChartTypeInfo.BUILTINTYPES[2][0]);
        chartTypes.put("2DLineStack", ChartTypeInfo.BUILTINTYPES[2][1]);
        chartTypes.put("2DLinePercent", ChartTypeInfo.BUILTINTYPES[2][2]);
        chartTypes.put("3DLineArray", ChartTypeInfo.BUILTINTYPES[2][3]);
        chartTypes.put("2DAreaArray", ChartTypeInfo.BUILTINTYPES[3][0]);
        chartTypes.put("2DAreaStack", ChartTypeInfo.BUILTINTYPES[3][1]);
        chartTypes.put("2DAreaPercent", ChartTypeInfo.BUILTINTYPES[3][2]);
        chartTypes.put("3DAreaArray", ChartTypeInfo.BUILTINTYPES[3][3]);
        chartTypes.put("3DAreaStack", ChartTypeInfo.BUILTINTYPES[3][4]);
        chartTypes.put("3DAreaPercent", ChartTypeInfo.BUILTINTYPES[3][5]);
        chartTypes.put("2DPieSideBySide", ChartTypeInfo.BUILTINTYPES[4][0]);
        chartTypes.put("3DPieSideBySide", ChartTypeInfo.BUILTINTYPES[4][1]);
        chartTypes.put("2DRadar", ChartTypeInfo.BUILTINTYPES[5][0]);
        chartTypes.put("2DGaugeDial", ChartTypeInfo.BUILTINTYPES[6][0]);
        chartTypes.put("2DGaugeBar", ChartTypeInfo.BUILTINTYPES[6][1]);
        chartTypes.put("2DGaugeBall", ChartTypeInfo.BUILTINTYPES[6][2]);
        chartTypes.put("3DSurface", ChartTypeInfo.BUILTINTYPES[7][0]);
        chartTypes.put("2DScatterArray", ChartTypeInfo.BUILTINTYPES[8][0]);
        chartTypes.put("2DScatterStack", ChartTypeInfo.BUILTINTYPES[8][1]);
        chartTypes.put("2DScatterSideBySide", ChartTypeInfo.BUILTINTYPES[8][2]);
        chartTypes.put("2DBubble", ChartTypeInfo.BUILTINTYPES[9][0]);
        chartTypes.put("2DHigh_LowStock", ChartTypeInfo.BUILTINTYPES[10][0]);
        chartTypes.put("2DHigh_Low_CloseStock", ChartTypeInfo.BUILTINTYPES[10][1]);
        chartTypes.put("2DOpen_High_Low_CloseStock", ChartTypeInfo.BUILTINTYPES[10][2]);
        comboTypes.put("2DBarSideBySide", ChartTypeInfo.BUILTINTYPES[0][0]);
        comboTypes.put("2DBarStack", ChartTypeInfo.BUILTINTYPES[0][1]);
        comboTypes.put("2DBarPercent", ChartTypeInfo.BUILTINTYPES[0][2]);
        comboTypes.put("3DBarSideBySide", ChartTypeInfo.BUILTINTYPES[0][3]);
        comboTypes.put("3DBarStack", ChartTypeInfo.BUILTINTYPES[0][4]);
        comboTypes.put("3DBarPercent", ChartTypeInfo.BUILTINTYPES[0][5]);
        comboTypes.put("3DBarArray", ChartTypeInfo.BUILTINTYPES[0][6]);
        comboTypes.put("2DBenchSideBySide", ChartTypeInfo.BUILTINTYPES[1][0]);
        comboTypes.put("2DBenchStack", ChartTypeInfo.BUILTINTYPES[1][1]);
        comboTypes.put("2DBenchPercent", ChartTypeInfo.BUILTINTYPES[1][2]);
        comboTypes.put("3DBenchSideBySide", ChartTypeInfo.BUILTINTYPES[1][3]);
        comboTypes.put("3DBenchStack", ChartTypeInfo.BUILTINTYPES[1][4]);
        comboTypes.put("3DBenchPercent", ChartTypeInfo.BUILTINTYPES[1][5]);
        comboTypes.put("3DBenchArray", ChartTypeInfo.BUILTINTYPES[1][6]);
        comboTypes.put("2DLineArray", ChartTypeInfo.BUILTINTYPES[2][0]);
        comboTypes.put("2DLineStack", ChartTypeInfo.BUILTINTYPES[2][1]);
        comboTypes.put("2DLinePercent", ChartTypeInfo.BUILTINTYPES[2][2]);
        comboTypes.put("3DLineArray", ChartTypeInfo.BUILTINTYPES[2][3]);
        comboTypes.put("2DAreaArray", ChartTypeInfo.BUILTINTYPES[3][0]);
        comboTypes.put("2DAreaStack", ChartTypeInfo.BUILTINTYPES[3][1]);
        comboTypes.put("2DAreaPercent", ChartTypeInfo.BUILTINTYPES[3][2]);
        comboTypes.put("3DAreaArray", ChartTypeInfo.BUILTINTYPES[3][3]);
        comboTypes.put("3DAreaStack", ChartTypeInfo.BUILTINTYPES[3][4]);
        comboTypes.put("3DAreaPercent", ChartTypeInfo.BUILTINTYPES[3][5]);
        CHART_FILTER_EDITOR = null;
        CHART_FILTER_EDITOR_NO_DATE = null;
    }
}

