/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.connect.Record;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.TextobjFieldable;
import jet.ie.WriterTool;
import jet.lc.LCConfiguration;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptBox;
import jet.report.JetRptRefParameterField;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.report.Renderable;
import jet.report.conditionallink.JetRptConditionalLinkList;
import jet.report.link.ConditionalLinkValue;
import jet.report.link.JetLinkProperties;
import jet.report.link.Linkable;
import jet.report.link.LinkableSetAPI;
import jet.report.link.SimpleLinkValue;
import jet.report.mode.JetRptMode;
import jet.report.mode.common.RptRenderer;
import jet.report.mode.renderer.JetRptTextRender;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableCell;
import jet.report.table.JetRptTableColumn;
import jet.textobj.ChrObj;
import jet.textobj.ExtGraphics;
import jet.textobj.Field;
import jet.textobj.FieldDest;
import jet.textobj.Obj;
import jet.textobj.RtfDest;
import jet.util.CharBuf;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.image.ImageProvider;

public abstract class JetRptField
extends JetRptBox
implements Renderable,
Linkable,
Field,
TextobjFieldable {
    public static final String[] JOINOP = new String[]{"=", ">", ">=", "<", "<=", "<>"};
    public static final String[] LOGIC = new String[]{"AND", "OR", "END"};
    public static final int FILTEROPTIONS_ALL = 0;
    public static final int FILTEROPTIONS_TOPN = 1;
    public static final int FILTEROPTIONS_BOTTOMN = 2;
    public static final int FILTEROPTIONS_MORE = 3;
    public static final int FILTEROPTIONS_DEFAULT = 4;
    public static final int POPUP_WINDOW_VALUE_DEFAULT = 0;
    public static final int POPUP_WINDOW_VALUE_TRUE = 1;
    public static final int POPUP_WINDOW_VALUE_FALSE = 2;
    public static final String POPUP_WINDOW_KEY_DEFAULT = EnumerationConstant.POPUP_WINDOW[0];
    public static final String POPUP_WINDOW_KEY_TRUE = EnumerationConstant.POPUP_WINDOW[1];
    public static final String POPUP_WINDOW_KEY_FALSE = EnumerationConstant.POPUP_WINDOW[2];
    public JetColor patternColor;
    public JetColor fontColor;
    public JetFont fontName;
    public JetUnitNumber fontSize;
    public JetBoolean bold;
    public JetBoolean italic;
    public JetBoolean strikeout;
    public JetBoolean underline;
    public JetEnumeration align;
    public JetEnumeration patternStyle;
    public JetStringList format;
    public JetUnitNumber maxWidth;
    public JetBoolean autoFit;
    public JetBoolean wordWrap;
    public JetBoolean transWhileToHtml;
    public String sNFontFace = "SansSerif";
    public int iNFontSize;
    public int iNAlignment;
    public int iNPatternStyle;
    public int iNMaxWidth = 0;
    public boolean bNBold = false;
    public boolean bNItalic = false;
    public boolean bNStrikeOut = false;
    public boolean bNUnderline = false;
    public boolean bNAutoFit = false;
    public boolean bNWordWrap = false;
    public boolean bNTransWhileToHtml = true;
    public boolean bFFontFace = false;
    public boolean bFBold = false;
    public boolean bFItalic = false;
    public boolean bFStrikeOut = false;
    public boolean bFUnderline = false;
    public boolean bFPatternColor = false;
    public boolean bFForeground = false;
    public boolean bFAutoFit = false;
    public boolean bFWordWrap = false;
    public boolean bFTransWhileToHtml = false;
    public boolean bFFormat = false;
    public String cFFontFace;
    public String cFBold;
    public String cFItalic;
    public String cFStrikeOut;
    public String cFUnderline;
    public String cFPatternColor;
    public String cFForeground;
    public String cFAutoFit;
    public String cFWordWrap;
    public String cFTransWhileToHtml;
    public String sNFormat = "";
    public String cFFormat;
    private boolean ALIGNMENT_ALL_STR_NAMES = false;
    private Hashtable HorizontalAlignment = new Hashtable();
    private static Hashtable PATTERN_STYLE_STR_NAMES = new Hashtable();
    public Color cNPatternColor = Color.black;
    public Color cNForeground = Color.black;
    public JetBoolean enableHyperlinkOnPDF;
    public JetBoolean enableHyperlinkOnExcel;
    public JetBoolean enableHyperlinkOnHTML;
    public JetBoolean gotoDetail;
    private JetStringList POPUP_WINDOW;
    public JetEnumeration HAlignment;
    public JetEnumeration VAlignment;
    private JetEnumeration VerticalAlignment;
    private JetString addToMappingTbl;
    private JetString black;
    private JetString booleanValue;
    private JetString buildInst;
    private JetString buildRslt;
    private JetNumber conditionLink;
    private Color convertPixelToUnit;
    private String copyJetPropToTxt;
    private Font copyJetPropsToTxt;
    private boolean copyTxtPropToJet;
    private boolean dup;
    private boolean endsWith;
    boolean isTextobjFieldable = false;
    private JetNumber equals;
    private JetLinkProperties equalsIgnoreCase;
    private FieldDest fieldUpdated;
    private boolean fillIndecialMap = false;
    private RtfDest get;
    private ChrObj getBoolean;
    private ChrObj getClass;
    public static final String JET_FIELD_INST_HEADER = "JetField_";
    static Hashtable jetToTxt;
    static Hashtable txtToJet;
    private static HashMap getColor;
    private static HashVector getColumn;
    private static RptRenderer getCurrentRender;

    public JetRptField() {
        this.DEFAULT_FONTSIZE();
        this.primProSize = (short)(this.primProSize + 13);
        this.iNPatternStyle = 0;
        this.iNTopLine = 0;
        this.iNBottomLine = 0;
        this.iNLeftLine = 0;
        this.iNRightLine = 0;
        this.iNFontSize = DEFAULT_FONTSIZE;
        this.iNAlignment = 5;
        this.setObjectType(256);
    }

    @Override
    public void afterInit() {
        super.afterInit();
        if (this.gotoDetail.isChangeByOther() || this.gotoDetail.booleanValue()) {
            this.POPUP_WINDOW.setEditFlag(2);
        } else {
            this.POPUP_WINDOW.setEditFlag(0);
        }
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.ALIGNMENT_ALL_STR_NAMES) {
            this.ALIGNMENT_ALL_STR_NAMES = true;
            this.HorizontalAlignment = super.getPrimProp();
            this.HorizontalAlignment.put("FontFace", 30);
            this.HorizontalAlignment.put("FontSize", 20);
            this.HorizontalAlignment.put("Bold", 21);
            this.HorizontalAlignment.put("Italic", 22);
            this.HorizontalAlignment.put("StrikeOut", 23);
            this.HorizontalAlignment.put("Underline", 24);
            this.HorizontalAlignment.put("Alignment", 37);
            this.HorizontalAlignment.put("PatternStyle", 38);
            this.HorizontalAlignment.put("PatternColor", 39);
            this.HorizontalAlignment.put("Foreground", 40);
            this.HorizontalAlignment.put("MaxWidth", 25);
            this.HorizontalAlignment.put("AutoFit", 26);
            this.HorizontalAlignment.put("WordWrap", 27);
            this.HorizontalAlignment.put("TransWhileToHtml", 28);
            this.HorizontalAlignment.put("Format", 41);
        }
        return this.HorizontalAlignment;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.HAlignment();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.transWhileToHtml != null) {
            String string2 = null;
            int n = 0;
            Integer n2 = (Integer)PATTERN_STYLE_STR_NAMES.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch ((Integer)PATTERN_STYLE_STR_NAMES.get(string)) {
                case 20: {
                    this.iNFontSize = this.fontSize.getUnit();
                    break;
                }
                case 21: {
                    this.bNBold = this.bold.get();
                    this.cFBold = (String)this.bold.getRuntimeChangeBy();
                    boolean bl = this.bFBold = this.cFBold != null;
                    if (!this.bFBold) break;
                    string2 = this.cFBold;
                    break;
                }
                case 22: {
                    this.bNItalic = this.italic.get();
                    this.cFItalic = (String)this.italic.getRuntimeChangeBy();
                    boolean bl = this.bFItalic = this.cFItalic != null;
                    if (!this.bFItalic) break;
                    string2 = this.cFItalic;
                    break;
                }
                case 23: {
                    this.bNStrikeOut = this.strikeout.get();
                    this.cFStrikeOut = (String)this.strikeout.getRuntimeChangeBy();
                    boolean bl = this.bFStrikeOut = this.cFStrikeOut != null;
                    if (!this.bFStrikeOut) break;
                    string2 = this.cFStrikeOut;
                    break;
                }
                case 24: {
                    this.bNUnderline = this.underline.get();
                    this.cFUnderline = (String)this.underline.getRuntimeChangeBy();
                    boolean bl = this.bFUnderline = this.cFUnderline != null;
                    if (!this.bFUnderline) break;
                    string2 = this.cFUnderline;
                    break;
                }
                case 25: {
                    this.iNMaxWidth = this.maxWidth.getUnit();
                    break;
                }
                case 26: {
                    this.bNAutoFit = this.autoFit.get();
                    this.cFAutoFit = (String)this.autoFit.getRuntimeChangeBy();
                    boolean bl = this.bFAutoFit = this.cFAutoFit != null;
                    if (!this.bFAutoFit) break;
                    string2 = this.cFAutoFit;
                    break;
                }
                case 27: {
                    this.bNWordWrap = this.wordWrap.get();
                    this.cFWordWrap = (String)this.wordWrap.getRuntimeChangeBy();
                    boolean bl = this.bFWordWrap = this.cFWordWrap != null;
                    if (!this.bFWordWrap) break;
                    string2 = this.cFWordWrap;
                    break;
                }
                case 28: {
                    this.bNTransWhileToHtml = this.transWhileToHtml.get();
                    this.cFTransWhileToHtml = (String)this.transWhileToHtml.getRuntimeChangeBy();
                    boolean bl = this.bFTransWhileToHtml = this.cFTransWhileToHtml != null;
                    if (!this.bFTransWhileToHtml) break;
                    string2 = this.cFTransWhileToHtml;
                    break;
                }
                case 38: {
                    this.iNPatternStyle = this.patternStyle.intValue();
                    break;
                }
                case 37: {
                    this.iNAlignment = this.align.intValue();
                    break;
                }
                case 39: {
                    this.cNPatternColor = this.patternColor.get();
                    this.cFPatternColor = (String)this.patternColor.getRuntimeChangeBy();
                    boolean bl = this.bFPatternColor = this.cFPatternColor != null;
                    if (!this.bFPatternColor) break;
                    string2 = this.cFPatternColor;
                    break;
                }
                case 40: {
                    this.cNForeground = this.fontColor.get();
                    this.cFForeground = (String)this.fontColor.getRuntimeChangeBy();
                    boolean bl = this.bFForeground = this.cFForeground != null;
                    if (!this.bFForeground) break;
                    string2 = this.cFForeground;
                    break;
                }
                case 41: {
                    this.sNFormat = this.format.get();
                    this.cFFormat = (String)this.format.getRuntimeChangeBy();
                    boolean bl = this.bFFormat = this.cFFormat != null;
                    if (!this.bFFormat) break;
                    string2 = this.cFFormat;
                    break;
                }
                case 30: {
                    this.sNFontFace = this.fontName.get();
                    this.cFFontFace = (String)this.fontName.getRuntimeChangeBy();
                    boolean bl = this.bFFontFace = this.cFFontFace != null;
                    if (!this.bFFontFace) break;
                    string2 = this.cFFontFace;
                }
            }
            if (string2 != null) {
                this.addPrimByF(string2, n);
            }
        }
    }

    @Override
    public void setTxtOwner(FieldDest fieldDest) {
        this.fieldUpdated = fieldDest;
    }

    @Override
    public FieldDest getTxtOwner() {
        return this.fieldUpdated;
    }

    @Override
    public void setRtf(RtfDest rtfDest) {
        this.get = rtfDest;
    }

    @Override
    public RtfDest getRtf() {
        return this.get;
    }

    @Override
    public void ownerUpdated() {
    }

    @Override
    public boolean isFixedField() {
        return this.fillIndecialMap;
    }

    @Override
    public void paint(ExtGraphics extGraphics) {
    }

    @Override
    public Dimension getSize() {
        return null;
    }

    @Override
    public void setSize(Dimension dimension) {
    }

    public static int getJetRtfId(String string) {
        int n = string.indexOf(" \\*");
        int n2 = string.indexOf(JET_FIELD_INST_HEADER);
        int n3 = Integer.valueOf(string.substring(n2 + 9, n));
        return n3;
    }

    @Override
    public ChrObj getInst() {
        if (this.getBoolean == null) {
            this.buildInst();
            if (this.getBoolean.hasProp("chrfmt.fs")) {
                String string = "" + (double)this.getBoolean.getIntValue("chrfmt.fs") / 2.0;
                this.getBoolean.setPropValue("chrfmt.fs", string, this.get);
            }
        }
        return this.getBoolean;
    }

    void buildInst() {
        this.getBoolean = ChrObj.newChrObj(null, new CharBuf(JET_FIELD_INST_HEADER + this.rtfId.get() + " \\* "));
        JetRptField.copyJetPropsToTxt(this, this.getBoolean, this.get);
    }

    @Override
    public ChrObj getRslt() {
        if (this.getClass == null) {
            this.buildRslt();
            if (this.getClass.hasProp("chrfmt.fs")) {
                String string = "" + (double)this.getClass.getIntValue("chrfmt.fs") / 2.0;
                this.getClass.setPropValue("chrfmt.fs", string, this.get);
            }
        }
        return this.getClass;
    }

    void buildRslt() {
        String string = this.sNFormat;
        if (string == null || string.length() == 0) {
            string = "[Null Field]";
        }
        this.getClass = ChrObj.newChrObj(null, new CharBuf(string));
        JetRptField.copyJetPropsToTxt(this, this.getClass, this.get);
    }

    public void propsUpdated(Vector vector) {
        if (this.fieldUpdated == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (jetToTxt.get(string) != null) {
                bl = true;
                if (this.getBoolean == null) {
                    this.buildInst();
                } else {
                    JetRptField.copyJetPropToTxt(this, string, this.getBoolean, this.get);
                }
                if (this.getClass == null) {
                    this.buildRslt();
                    continue;
                }
                JetRptField.copyJetPropToTxt(this, string, this.getClass, this.get);
                continue;
            }
            if (string.equalsIgnoreCase("Format")) {
                bl2 = true;
                this.buildRslt();
                bl = true;
                continue;
            }
            if (!string.equalsIgnoreCase("RTFID")) continue;
            this.buildInst();
            bl = true;
        }
        if (bl) {
            this.fieldUpdated.fieldUpdated(bl2);
        }
    }

    public void refreshField() {
        this.buildInst();
        this.buildRslt();
        this.fieldUpdated.fieldUpdated(false);
    }

    public static final void copyJetPropToTxt(DSTemplatible dSTemplatible, String string, Obj obj, RtfDest rtfDest) {
        String string2 = (String)jetToTxt.get(string);
        String string3 = string2.equals("chrfmt.fs") ? Integer.toString(((JetRptField)dSTemplatible).iNFontSize / 80) : (string.equals("FontFace") ? ((JetRptField)dSTemplatible).sNFontFace : (string.equals("Background") ? (((JetRptField)dSTemplatible).cNBackground == null ? "Transparent" : MiscTools.mapColorToString(((JetRptField)dSTemplatible).cNBackground)) : (string.equals("Italic") ? (!((JetRptField)dSTemplatible).bNItalic ? "false" : "true") : (string.equals("Bold") ? (!((JetRptField)dSTemplatible).bNBold ? "false" : "true") : (string.equals("Foreground") ? MiscTools.mapColorToString(((JetRptField)dSTemplatible).cNForeground) : (string.equals("StrikeOut") ? (!((JetRptField)dSTemplatible).bNStrikeOut ? "false" : "true") : (string.equals("Underline") ? (!((JetRptField)dSTemplatible).bNUnderline ? "false" : "true") : dSTemplatible.getPropertyByName(string).toString())))))));
        if (string3 != null && obj.hasProp(string2)) {
            obj.setPropValue(string2, string3, rtfDest);
        }
    }

    public static final void copyTxtPropToJet(Obj obj, String string, JetObject jetObject, RtfDest rtfDest) {
        String string2 = (String)txtToJet.get(string);
        if (obj.hasProp(string)) {
            String string3 = obj.getPropValue(string, rtfDest);
            if (string3 != null && string3.length() > 0) {
                if (string.equals("chrfmt.fs")) {
                    try {
                        int n = Integer.parseInt(string3);
                        ((JetRptTextField)jetObject).iNFontSize = n * 80;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((JetRptTextField)jetObject).iNFontSize = Unit.convertPixelToUnit(Integer.parseInt(string3));
                    }
                } else if (string2.equals("FontFace")) {
                    ((JetRptTextField)jetObject).sNFontFace = JetRptField.ALIGNMENT_ALL_STR_NAMES(string3);
                } else if (string2.equals("Background")) {
                    ((JetRptTextField)jetObject).cNBackground = MiscTools._mapStringToColor(string3);
                } else if (string2.equals("Italic")) {
                    ((JetRptTextField)jetObject).bNItalic = string3.toLowerCase().startsWith("t");
                } else if (string2.equals("Bold")) {
                    ((JetRptTextField)jetObject).bNBold = string3.toLowerCase().startsWith("t");
                } else if (string2.equals("Foreground")) {
                    if (!((JetRptTextField)jetObject).bFForeground) {
                        ((JetRptTextField)jetObject).cNForeground = MiscTools._mapStringToColor(string3);
                    } else {
                        ((JetRptTextField)jetObject).cFForeground = string3;
                    }
                } else if (string2.equals("StrikeOut")) {
                    ((JetRptTextField)jetObject).bNStrikeOut = string3.toLowerCase().startsWith("t");
                    ((JetRptTextField)jetObject).cFStrikeOut = string3;
                } else if (string2.equals("Underline")) {
                    ((JetRptTextField)jetObject).bNUnderline = string3.toLowerCase().startsWith("t");
                }
            } else if (string.endsWith("cb")) {
                ((JetRptTextField)jetObject).cNBackground = MiscTools._mapStringToColor("Transparent");
            }
        }
    }

    public static void copyJetPropsToTxt(DSTemplatible dSTemplatible, Obj obj, RtfDest rtfDest) {
        Enumeration enumeration = jetToTxt.keys();
        while (enumeration.hasMoreElements()) {
            JetRptField.copyJetPropToTxt(dSTemplatible, (String)enumeration.nextElement(), obj, rtfDest);
        }
    }

    public static void copyTxtPropsToJet(Obj obj, JetObject jetObject, RtfDest rtfDest) {
        Enumeration enumeration = txtToJet.keys();
        while (enumeration.hasMoreElements()) {
            JetRptField.copyTxtPropToJet(obj, (String)enumeration.nextElement(), jetObject, rtfDest);
        }
    }

    static void addToMappingTbl(String string, String string2) {
        jetToTxt.put(string, string2);
        txtToJet.put(string2, string);
    }

    public static String getJetPropName(String string) {
        return (String)txtToJet.get(string);
    }

    public static String getTxtPropName(String string) {
        return (String)jetToTxt.get(string);
    }

    @Override
    public Object clone() {
        return this.dup();
    }

    @Override
    public boolean isTextobjFieldable() {
        return this.isTextobjFieldable;
    }

    @Override
    public void setTextobjFieldable(boolean bl) {
        this.isTextobjFieldable = bl;
    }

    public Color getForeColor() {
        return this.convertPixelToUnit;
    }

    public String getFormat() {
        return this.copyJetPropToTxt;
    }

    public Font getFont() {
        return this.copyJetPropsToTxt;
    }

    public boolean getForeByOther() {
        return this.endsWith;
    }

    public boolean getFormatByOther() {
        return this.dup;
    }

    public boolean getFontByOther() {
        return this.copyTxtPropToJet;
    }

    @Override
    public String getFontFace(JRObjectResult jRObjectResult) {
        if (!this.bFFontFace) {
            return this.sNFontFace;
        }
        return jRObjectResult.getString(this.cFFontFace, this.sNFontFace);
    }

    @Override
    public int getFontSize(JRObjectResult jRObjectResult) {
        return this.iNFontSize;
    }

    @Override
    public boolean getBold(JRObjectResult jRObjectResult) {
        if (!this.bFBold) {
            return this.bNBold;
        }
        return jRObjectResult.getBoolean(this.cFBold, this.bNBold);
    }

    @Override
    public boolean getItalic(JRObjectResult jRObjectResult) {
        if (!this.bFItalic) {
            return this.bNItalic;
        }
        return jRObjectResult.getBoolean(this.cFItalic, this.bNItalic);
    }

    @Override
    public boolean getStrikeOut(JRObjectResult jRObjectResult) {
        if (!this.bFStrikeOut) {
            return this.bNStrikeOut;
        }
        return jRObjectResult.getBoolean(this.cFStrikeOut, this.bNStrikeOut);
    }

    @Override
    public boolean getUnderline(JRObjectResult jRObjectResult) {
        if (!this.bFUnderline) {
            return this.bNUnderline;
        }
        return jRObjectResult.getBoolean(this.cFUnderline, this.bNUnderline);
    }

    @Override
    public int getMaxWidth(JRObjectResult jRObjectResult) {
        return this.iNMaxWidth;
    }

    @Override
    public boolean getAutoFit(JRObjectResult jRObjectResult) {
        if (!this.bFAutoFit) {
            return this.bNAutoFit;
        }
        return jRObjectResult.getBoolean(this.cFAutoFit, this.bNAutoFit);
    }

    @Override
    public boolean getWordWrap(JRObjectResult jRObjectResult) {
        if (!this.bFWordWrap) {
            return this.bNWordWrap;
        }
        return jRObjectResult.getBoolean(this.cFWordWrap, this.bNWordWrap);
    }

    @Override
    public boolean getTransWhileToHtml(JRObjectResult jRObjectResult) {
        if (!this.bFTransWhileToHtml) {
            return this.bNTransWhileToHtml;
        }
        return jRObjectResult.getBoolean(this.cFTransWhileToHtml, this.bNTransWhileToHtml);
    }

    @Override
    public int getAlignment(JRObjectResult jRObjectResult) {
        return this.iNAlignment;
    }

    @Override
    public int getPatternStyle(JRObjectResult jRObjectResult) {
        return this.iNPatternStyle;
    }

    @Override
    public Color getPatternColor(JRObjectResult jRObjectResult) {
        if (!this.bFPatternColor) {
            return this.cNPatternColor;
        }
        return jRObjectResult.getColor(this.cFPatternColor, this.cNPatternColor);
    }

    @Override
    public Color getForeground(JRObjectResult jRObjectResult) {
        if (!this.bFForeground) {
            return this.cNForeground;
        }
        return jRObjectResult.getColor(this.cFForeground, this.cNForeground);
    }

    @Override
    public String getFormat(JRObjectResult jRObjectResult) {
        if (!this.bFFormat) {
            return this.sNFormat;
        }
        return jRObjectResult.getString(this.cFFormat, this.sNFormat);
    }

    public String getFontFace(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFFontFace) {
            return this.sNFontFace;
        }
        return jRObjectResult.getString(this.cFFontFace, record, this.sNFontFace);
    }

    public boolean getBold(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFBold) {
            return this.bNBold;
        }
        return jRObjectResult.getBoolean(this.cFBold, record, this.bNBold);
    }

    public boolean getItalic(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFItalic) {
            return this.bNItalic;
        }
        return jRObjectResult.getBoolean(this.cFItalic, record, this.bNItalic);
    }

    public boolean getStrikeOut(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFStrikeOut) {
            return this.bNStrikeOut;
        }
        return jRObjectResult.getBoolean(this.cFStrikeOut, record, this.bNStrikeOut);
    }

    public boolean getUnderline(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFUnderline) {
            return this.bNUnderline;
        }
        return jRObjectResult.getBoolean(this.cFUnderline, record, this.bNUnderline);
    }

    public boolean getAutoFit(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFAutoFit) {
            return this.bNAutoFit;
        }
        return jRObjectResult.getBoolean(this.cFAutoFit, record, this.bNAutoFit);
    }

    public boolean getWordWrap(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFWordWrap) {
            return this.bNWordWrap;
        }
        return jRObjectResult.getBoolean(this.cFWordWrap, record, this.bNWordWrap);
    }

    public boolean getTransWhileToHtml(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFTransWhileToHtml) {
            return this.bNTransWhileToHtml;
        }
        return jRObjectResult.getBoolean(this.cFTransWhileToHtml, record, this.bNTransWhileToHtml);
    }

    public Color getPatternColor(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFPatternColor) {
            return this.cNPatternColor;
        }
        return jRObjectResult.getColor(this.cFPatternColor, record, this.cNPatternColor);
    }

    public Color getForeground(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFForeground) {
            return this.cNForeground;
        }
        return jRObjectResult.getColor(this.cFForeground, record, this.cNForeground);
    }

    @Override
    public String getFormat(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFFormat) {
            return this.sNFormat;
        }
        return jRObjectResult.getString(this.cFFormat, record, this.sNFormat);
    }

    @Override
    public boolean getFontFaceChBy() {
        return this.bFFontFace;
    }

    @Override
    public boolean getFontSizeChBy() {
        return false;
    }

    @Override
    public boolean getBoldChBy() {
        return this.bFBold;
    }

    @Override
    public boolean getItalicChBy() {
        return this.bFItalic;
    }

    @Override
    public boolean getStrikeOutChBy() {
        return this.bFStrikeOut;
    }

    @Override
    public boolean getUnderlineChBy() {
        return this.bFUnderline;
    }

    @Override
    public boolean getForegroundChBy() {
        return this.bFForeground;
    }

    @Override
    public boolean getAlignmentChBy() {
        return false;
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        if ((Integer)PATTERN_STYLE_STR_NAMES.get(string) != null) {
            switch ((Integer)PATTERN_STYLE_STR_NAMES.get(string)) {
                case 20: {
                    this.iNFontSize = Unit.upgrade(n, n2, true);
                    bl = true;
                    break;
                }
                case 21: {
                    this.bNBold = n != 0;
                    bl = true;
                    break;
                }
                case 22: {
                    this.bNItalic = n != 0;
                    bl = true;
                    break;
                }
                case 23: {
                    this.bNStrikeOut = n != 0;
                    bl = true;
                    break;
                }
                case 24: {
                    this.bNUnderline = n != 0;
                    bl = true;
                    break;
                }
                case 25: {
                    this.iNMaxWidth = Unit.upgrade(n, n2, false);
                    bl = true;
                    break;
                }
                case 26: {
                    this.bNAutoFit = n != 0;
                    bl = true;
                    break;
                }
                case 27: {
                    this.bNWordWrap = n != 0;
                    bl = true;
                    break;
                }
                case 28: {
                    this.bNTransWhileToHtml = n != 0;
                    bl = true;
                }
            }
        } else if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        if ((Integer)PATTERN_STYLE_STR_NAMES.get(string) != null) {
            switch ((Integer)PATTERN_STYLE_STR_NAMES.get(string)) {
                case 38: {
                    bl = true;
                    boolean bl2 = false;
                    for (int i = 0; !bl2 && i < EnumerationConstant.PATTERN_STYLE_STR_NAMES.length; ++i) {
                        if (!string2.equals(EnumerationConstant.PATTERN_STYLE_STR_NAMES[i])) continue;
                        this.iNPatternStyle = i;
                        bl2 = true;
                    }
                    if (bl2) break;
                    this.iNPatternStyle = 0;
                    break;
                }
                case 37: {
                    bl = true;
                    boolean bl3 = false;
                    for (int i = 0; i < EnumerationConstant.ALIGNMENT_ALL_STR_NAMES.length; ++i) {
                        if (!string2.equals(EnumerationConstant.ALIGNMENT_ALL_STR_NAMES[i])) continue;
                        this.iNAlignment = i;
                        bl3 = true;
                        break;
                    }
                    if (bl3) break;
                    this.iNAlignment = 5;
                    break;
                }
                case 39: {
                    bl = true;
                    this.cNPatternColor = MiscTools._mapStringToColor(string2);
                    break;
                }
                case 40: {
                    bl = true;
                    this.cNForeground = MiscTools._mapStringToColor(string2);
                    break;
                }
                case 41: {
                    bl = true;
                    this.sNFormat = string2;
                    break;
                }
                case 30: {
                    bl = true;
                    this.sNFontFace = JetRptField.ALIGNMENT_ALL_STR_NAMES(string2);
                }
            }
        } else if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    private static String ALIGNMENT_ALL_STR_NAMES(String string) {
        String string2 = string;
        if (string.equalsIgnoreCase("TimesRoman")) {
            string2 = "Serif";
        } else if (string.equalsIgnoreCase("Helvetica")) {
            string2 = "SansSerif";
        } else if (string.equalsIgnoreCase("Courier")) {
            string2 = "Monospaced";
        }
        return string2;
    }

    @Override
    public void setChangeBy(String string, String string2) {
        boolean bl = false;
        int n = 0;
        if ((Integer)PATTERN_STYLE_STR_NAMES.get(string) != null) {
            n = (Integer)PATTERN_STYLE_STR_NAMES.get(string);
            switch (n) {
                case 30: {
                    this.bFFontFace = true;
                    this.cFFontFace = string2;
                    bl = true;
                    break;
                }
                case 21: {
                    this.bFBold = true;
                    this.cFBold = string2;
                    bl = true;
                    break;
                }
                case 22: {
                    this.bFItalic = true;
                    this.cFItalic = string2;
                    bl = true;
                    break;
                }
                case 23: {
                    this.bFStrikeOut = true;
                    this.cFStrikeOut = string2;
                    bl = true;
                    break;
                }
                case 24: {
                    this.bFUnderline = true;
                    this.cFUnderline = string2;
                    bl = true;
                    break;
                }
                case 26: {
                    this.bFAutoFit = true;
                    this.cFAutoFit = string2;
                    bl = true;
                    break;
                }
                case 27: {
                    this.bFWordWrap = true;
                    this.cFWordWrap = string2;
                    bl = true;
                    break;
                }
                case 28: {
                    this.bFTransWhileToHtml = true;
                    this.cFTransWhileToHtml = string2;
                    bl = true;
                    break;
                }
                case 39: {
                    bl = true;
                    this.bFPatternColor = true;
                    this.cFPatternColor = string2;
                    break;
                }
                case 40: {
                    bl = true;
                    this.bFForeground = true;
                    this.cFForeground = string2;
                    break;
                }
                case 41: {
                    bl = true;
                    this.bFFormat = true;
                    this.cFFormat = string2;
                }
            }
        } else if (!bl) {
            super.setChangeBy(string, string2);
        }
        this.addPrimByF(string2, n);
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get("FontFace");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("FontFace", s2);
        }
        WriterTool.writePrimString(s2, this.bFFontFace, this.sNFontFace, this.cFFontFace, dataOutput);
        s2 = (Short)hashVector.get("FontSize");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("FontSize", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNFontSize, null, dataOutput, 4);
        s2 = (Short)hashVector.get("Bold");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("Bold", s2);
        }
        WriterTool.writePrimBool(s2, this.bFBold, this.bNBold, this.cFBold, dataOutput);
        s2 = (Short)hashVector.get("Italic");
        if (s2 == null) {
            short s6 = s;
            s = (short)(s + 1);
            s2 = s6;
            hashVector.put("Italic", s2);
        }
        WriterTool.writePrimBool(s2, this.bFItalic, this.bNItalic, this.cFItalic, dataOutput);
        s2 = (Short)hashVector.get("StrikeOut");
        if (s2 == null) {
            short s7 = s;
            s = (short)(s + 1);
            s2 = s7;
            hashVector.put("StrikeOut", s2);
        }
        WriterTool.writePrimBool(s2, this.bFStrikeOut, this.bNStrikeOut, this.cFStrikeOut, dataOutput);
        s2 = (Short)hashVector.get("Underline");
        if (s2 == null) {
            short s8 = s;
            s = (short)(s + 1);
            s2 = s8;
            hashVector.put("Underline", s2);
        }
        WriterTool.writePrimBool(s2, this.bFUnderline, this.bNUnderline, this.cFUnderline, dataOutput);
        s2 = (Short)hashVector.get("WordWrap");
        if (s2 == null) {
            short s9 = s;
            s = (short)(s + 1);
            s2 = s9;
            hashVector.put("WordWrap", s2);
        }
        WriterTool.writePrimBool(s2, this.bFWordWrap, this.bNWordWrap, this.cFWordWrap, dataOutput);
        s2 = (Short)hashVector.get("TransWhileToHtml");
        if (s2 == null) {
            short s10 = s;
            s = (short)(s + 1);
            s2 = s10;
            hashVector.put("TransWhileToHtml", s2);
        }
        WriterTool.writePrimBool(s2, this.bFTransWhileToHtml, this.bNTransWhileToHtml, this.cFTransWhileToHtml, dataOutput);
        s2 = (Short)hashVector.get("Alignment");
        if (s2 == null) {
            short s11 = s;
            s = (short)(s + 1);
            s2 = s11;
            hashVector.put("Alignment", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNAlignment, null, dataOutput, 3);
        s2 = (Short)hashVector.get("PatternStyle");
        if (s2 == null) {
            short s12 = s;
            s = (short)(s + 1);
            s2 = s12;
            hashVector.put("PatternStyle", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNPatternStyle, null, dataOutput, 3);
        s2 = (Short)hashVector.get("PatternColor");
        if (s2 == null) {
            short s13 = s;
            s = (short)(s + 1);
            s2 = s13;
            hashVector.put("PatternColor", s2);
        }
        WriterTool.writePrimColor(s2, this.bFPatternColor, this.cNPatternColor, this.cFPatternColor, dataOutput);
        s2 = (Short)hashVector.get("Foreground");
        if (s2 == null) {
            short s14 = s;
            s = (short)(s + 1);
            s2 = s14;
            hashVector.put("Foreground", s2);
        }
        WriterTool.writePrimColor(s2, this.bFForeground, this.cNForeground, this.cFForeground, dataOutput);
        s2 = (Short)hashVector.get("Format");
        if (s2 == null) {
            short s15 = s;
            s = (short)(s + 1);
            s2 = s15;
            hashVector.put("Format", s2);
        }
        WriterTool.writePrimString(s2, this.bFFormat, this.sNFormat, this.cFFormat, dataOutput);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (getColor == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (getColor == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Alignment", n++);
                    hashMap.put("AutoFit", n++);
                    hashMap.put("Bold", n++);
                    hashMap.put("EnableHyperlinkOnExcel", n++);
                    hashMap.put("EnableHyperlinkOnHTML", n++);
                    hashMap.put("EnableHyperlinkOnPDF", n++);
                    hashMap.put("FontFace", n++);
                    hashMap.put("FontSize", n++);
                    hashMap.put("Foreground", n++);
                    hashMap.put("Format", n++);
                    hashMap.put("Italic", n++);
                    hashMap.put("MaxWidth", n++);
                    hashMap.put("PatternColor", n++);
                    hashMap.put("PatternStyle", n++);
                    hashMap.put("StrikeOut", n++);
                    hashMap.put("TransWhileToHtml", n++);
                    hashMap.put("Underline", n++);
                    hashMap.put("WordWrap", n++);
                    hashMap.put("GotoDetail", n++);
                    hashMap.put("HorizontalAlignment", n++);
                    hashMap.put("PopUpNewWindow", n++);
                    hashMap.put("VerticalAlignment", n++);
                    hashMap.put("ExternalAccessKey", n++);
                    hashMap.put("ExternalDir", n++);
                    hashMap.put("ExternalTabIndex", n++);
                    hashMap.put("ExternalTitle", n++);
                    hashMap.put("HrefLang", n++);
                    hashMap.put("LongDesc", n++);
                    hashMap.put("DetailTargetFrame", n++);
                    hashMap.put("LogicColumn", n++);
                    n = JetLinkProperties.fillIndecialMap(hashMap);
                    getColor = hashMap;
                }
            }
        }
        return getColor;
    }

    private void DEFAULT_FONTSIZE() {
        this.enableHyperlinkOnPDF = new JetBoolean(this, "EnableHyperlinkOnPDF", true);
        this.enableHyperlinkOnExcel = new JetBoolean(this, "EnableHyperlinkOnExcel", true);
        this.enableHyperlinkOnHTML = new JetBoolean(this, "EnableHyperlinkOnHTML", true);
        this.gotoDetail = new JetBoolean(this, "GotoDetail", true);
        this.POPUP_WINDOW = new JetStringList(this, "DetailTargetFrame", "");
        this.HAlignment = new JetEnumeration(this, PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment), 2);
        this.VAlignment = new JetEnumeration(this, PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment), 6);
        this.VerticalAlignment = new JetEnumeration(this, "PopUpNewWindow", 79);
        this.topPadding.set(2);
        this.bottomPadding.set(2);
        this.leftPadding.set(2);
        this.rightPadding.set(2);
        this.VerticalAlignment.set(0);
        this.HAlignment.set(2);
        this.VAlignment.set(0);
        this.addToMappingTbl = new JetString(this, "HrefLang");
        this.black = new JetString(this, "ExternalAccessKey");
        this.booleanValue = new JetString(this, "ExternalDir");
        this.conditionLink = new JetNumber(this, "ExternalTabIndex");
        this.buildInst = new JetString(this, "LongDesc");
        this.buildRslt = new JetString(this, "ExternalTitle");
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("_self");
        vector.add("_top");
        vector.add("_blank");
        vector.add("_parent");
        this.POPUP_WINDOW.setList(vector);
        this.POPUP_WINDOW.setCanChangeByOthers(false);
        this.POPUP_WINDOW.setCanChangeByBL(false);
        this.POPUP_WINDOW.setCanChangeByFmtt(false);
        this.POPUP_WINDOW.set("_self");
        this.equals = new JetNumber(this, "LogicColumn", 1);
        this.equals.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> vector2 = new Vector<String>();
        vector2.add(String.valueOf(1));
        vector2.add(String.valueOf(2));
        this.equals.setPropertyChoice(vector2);
        this.equals.setCanChangeByBL(false);
        this.equals.setCanChangeByFmtt(false);
        this.equals.setCanChangeByOthers(false);
        this.equalsIgnoreCase = new JetLinkProperties(this);
    }

    private void HAlignment() {
        this.patternColor = new JetColor(this, "PatternColor", Color.black, false);
        this.fontColor = new JetColor(this, "Foreground", Color.black);
        this.fontName = new JetFont(this, "FontFace");
        this.fontSize = new JetUnitNumber(this, "FontSize");
        this.bold = new JetBoolean(this, "Bold", false);
        this.italic = new JetBoolean(this, "Italic", false);
        this.strikeout = new JetBoolean(this, "StrikeOut", false);
        this.underline = new JetBoolean(this, "Underline", false);
        this.align = new JetEnumeration(this, "Alignment", 0);
        this.patternStyle = new JetEnumeration(this, "PatternStyle", 78);
        this.format = new JetStringList(this, "Format");
        this.maxWidth = new JetUnitNumber(this, "MaxWidth", 0);
        this.autoFit = new JetBoolean(this, "AutoFit", false);
        this.wordWrap = new JetBoolean(this, "WordWrap", false);
        this.transWhileToHtml = new JetBoolean(this, "TransWhileToHtml", true);
        this.patternStyle.set(0);
        this.top.set(0);
        this.bottom.set(0);
        this.left.set(0);
        this.right.set(0);
        this.fontSize.setUnitValue(DEFAULT_FONTSIZE);
        this.align.set(5);
        this.autoFit.setTransient(true);
        this.maxWidth.setTransient(true);
        this.x.setCanChangeByOthers(true);
        this.y.setCanChangeByOthers(true);
        this.width.setCanChangeByOthers(true);
        this.height.setCanChangeByOthers(true);
    }

    public HashVector getPropGrpsDescDirectly() {
        if (this.bEditable) {
            if (getColumn != null) {
                return getColumn;
            }
            getColumn = JetRptField.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (getColumn == null) {
                getColumn = new HashVector();
            }
            String string = "";
            List<String> list = new Vector<String>();
            string = "Pattern";
            list = new Vector(2);
            list.add("PatternColor");
            list.add("PatternStyle");
            getColumn.put(string, list);
            string = "TextFormat";
            list = new Vector(13);
            list.add("FontFace");
            list.add("FontSize");
            list.add("Bold");
            list.add("Italic");
            list.add("StrikeOut");
            list.add("Underline");
            list.add("Format");
            list.add("AutoFit");
            list.add("MaxWidth");
            list.add("WordWrap");
            list.add("TransWhileToHtml");
            list.add(PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment));
            list.add(PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
            getColumn.put(string, list);
            string = "Others";
            list = (List)getColumn.get(string);
            list.add("Link");
            list.add("EnableHyperlinkOnPDF");
            list.add("EnableHyperlinkOnExcel");
            list.add("EnableHyperlinkOnHTML");
            list.add("DetailReport");
            list.add("TransferStyle");
            list.add("GotoDetail");
            list.add("DetailTargetFrame");
            list.add("ExportToHTML");
            list.add("ExportToPDF");
            list.add("ExportToText");
            list.add("ExportToRTF");
            list.add("ExportToXML");
            list.add("ExportToPostScript");
            list.add("ExportToApplet");
            getColumn.remove(string);
            getColumn.put(string, list);
            list = (List)getColumn.get("Color");
            list.add("Foreground");
            list = (List)getColumn.get("CSS");
            list.add(list.indexOf("class"), "id");
            string = "Accessibility";
            list = (List)getColumn.get(string);
            list.add("ExternalAccessKey");
            list.add("ExternalDir");
            list.add("ExternalTabIndex");
            list.add("ExternalTitle");
            list.add("LongDesc");
            list.add("HrefLang");
            getColumn.remove(string);
            getColumn.put(string, list);
            return getColumn;
        }
        return null;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return this.HorizontalAlignment(this.getPropGrpsDescDirectly());
    }

    private HashVector HorizontalAlignment(HashVector hashVector) {
        if (!this.bEditable) {
            return null;
        }
        JetObject jetObject = (JetObject)((Object)this.getParent());
        if (jetObject == null) {
            HashVector hashVector2 = JetRptField.duplicatePropGrpsDesc(hashVector);
            RptRenderer rptRenderer = this.getCurrentUsedRenderer();
            int n = rptRenderer == null ? 0 : rptRenderer.getRenderType();
            this.PATTERN_STYLE_STR_NAMES(n, hashVector2);
            return hashVector2;
        }
        if (jetObject instanceof JRObjectTemplate) {
            RptRenderer rptRenderer;
            int n;
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)jetObject;
            if (jRObjectTemplate.getObjectType() == 262180) {
                return this.JOINOP(hashVector, jRObjectTemplate);
            }
            if (jRObjectTemplate.getObjectType() == 262183) {
                return this.LOGIC(hashVector);
            }
            if (jRObjectTemplate.getObjectType() == 524293) {
                HashVector hashVector3 = JetRptField.duplicatePropGrpsDesc(hashVector);
                JetObject jetObject2 = (JetObject)((Object)jRObjectTemplate.getParent());
                JetObject jetObject3 = jetObject2 = jetObject2 == null ? null : (JetObject)((Object)jetObject2.getParent());
                if (jetObject2 != null) {
                    RptRenderer rptRenderer2;
                    Object object;
                    if (jetObject2 instanceof DSTemplatible) {
                        if (((DSTemplatible)((Object)jetObject2)).getObjectType() == 262180) {
                            if (this instanceof JetRptSystemField && ((JetRptSystemField)this).fieldType.intValue() == 9) {
                                ((List)hashVector3.get("Others")).add("Repeat");
                                int n2 = ((JetRptTableCell)jetObject2).getXIndex();
                                object = null;
                                while (object == null && (jetObject2 = (JetObject)((Object)jetObject2.getParent())) != null) {
                                    if (!(jetObject2 instanceof JRObjectTemplate) || ((JRObjectTemplate)jetObject2).getObjectType() != 262179) continue;
                                    object = (JetRptNewTable)jetObject2;
                                }
                                if (object != null && ((JetRptTableColumn)((JetRptNewTable)object).getColumn(n2)).getTableColumnType() == 3) {
                                    ((List)hashVector3.get("Others")).add("DataEvaluationSetting");
                                }
                            }
                            ((List)hashVector3.get("Others")).add("LogicColumn");
                        } else if (((DSTemplatible)((Object)jetObject2)).getObjectType() == 79) {
                            ((List)hashVector3.get("Others")).remove("position");
                        }
                    } else if (jetObject2 instanceof LCConfiguration && (rptRenderer2 = this.getCurrentUsedRenderer()) != null && rptRenderer2.getRenderType() == 11 && (object = (JetNumber)rptRenderer2.getRenderPropertyByName("SpecialID")) != null && ((JetNumber)object).intValue() != 0) {
                        List list = (List)hashVector3.get("Others");
                        list.remove("BindColumn");
                        list.remove("DetailReport");
                        list.remove("FilterOptions");
                        list.remove("Filterable");
                        list.remove("Sortable");
                        list.remove("Invisible");
                        list.remove("Link");
                        list.remove("RecordLocation");
                        list.remove("Suppressed");
                        list.remove("Suppressed");
                        list.remove("SuppressedIfNoRecords");
                    }
                }
                if (this.position.intValue() == 0) {
                    List list = (List)hashVector3.get("Geometry");
                    list.remove("X");
                    list.remove("Y");
                    hashVector3.remove("TOC");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() == 0) {
                        list = (List)hashVector3.get("Geometry");
                        list.remove("Width");
                        list.remove("Height");
                        list = (List)hashVector3.get("TextFormat");
                        list.remove("HorizontalAlignment");
                        list.remove("VerticalAlignment");
                    }
                    if (this.display.intValue() == 1) {
                        hashVector3.remove("Border");
                        hashVector3.remove("Padding");
                    }
                    list = (List)hashVector3.get("TextFormat");
                    list.remove("WordWrap");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() != 3) {
                        list.remove("AutoFit");
                    }
                } else {
                    hashVector3.remove("TOC");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() != 0) {
                        hashVector3.remove("Padding");
                    }
                    if (this.position.intValue() == 2) {
                        if (this.getJetRptMode() == null || this.getJetRptMode().getCurrentRender().getRenderType() != 0) {
                            ((List)hashVector3.get("TextFormat")).remove("WordWrap");
                            ((List)hashVector3.get("TextFormat")).remove("AutoFit");
                        }
                    } else {
                        ((List)hashVector3.get("TextFormat")).remove("WordWrap");
                        ((List)hashVector3.get("TextFormat")).remove("AutoFit");
                    }
                }
                RptRenderer rptRenderer3 = this.getCurrentUsedRenderer();
                int n3 = rptRenderer3 == null ? 0 : rptRenderer3.getRenderType();
                this.PATTERN_STYLE_STR_NAMES(n3, hashVector3);
                return hashVector3;
            }
            HashVector hashVector4 = hashVector;
            if (this.getJetRptMode() == null) {
                if (this instanceof JetRptSystemField) {
                    hashVector4 = JetRptField.duplicatePropGrpsDesc(hashVector);
                    ((List)hashVector4.get("Others")).remove("Repeat");
                    ((List)hashVector4.get("Others")).remove("DataEvaluationSetting");
                }
                return hashVector4;
            }
            hashVector4 = JetRptField.duplicatePropGrpsDesc(hashVector);
            if (this instanceof JetRptSystemField) {
                ((List)hashVector4.get("Others")).remove("Repeat");
                ((List)hashVector4.get("Others")).remove("DataEvaluationSetting");
            }
            int n4 = n = (rptRenderer = this.getCurrentUsedRenderer()) == null ? 0 : rptRenderer.getRenderType();
            if (n != 0) {
                hashVector4.remove("Padding");
                List list = (List)hashVector4.get("TextFormat");
                list.remove("WordWrap");
                if (n != 3) {
                    list.remove("AutoFit");
                }
                this.PATTERN_STYLE_STR_NAMES(n, hashVector4);
                return hashVector4;
            }
            this.PATTERN_STYLE_STR_NAMES(n, hashVector4);
            return hashVector4;
        }
        return hashVector;
    }

    private HashVector JOINOP(HashVector hashVector, JRObjectTemplate jRObjectTemplate) {
        int n;
        Object object;
        HashVector hashVector2 = JetRptField.duplicatePropGrpsDesc(hashVector);
        hashVector2.remove("TOC");
        ((List)hashVector2.get("Others")).add("LogicColumn");
        if (this instanceof JetRptSystemField && ((JetRptSystemField)this).fieldType.intValue() == 9) {
            ((List)hashVector2.get("Others")).add("Repeat");
            object = jRObjectTemplate;
            n = ((JetRptTableCell)jRObjectTemplate).getXIndex();
            JetRptNewTable jetRptNewTable = null;
            while (jetRptNewTable == null && (object = (JetObject)((Object)((JetObject)object).getParent())) != null) {
                if (!(object instanceof JRObjectTemplate) || (jRObjectTemplate = (JRObjectTemplate)object).getObjectType() != 262179) continue;
                jetRptNewTable = (JetRptNewTable)jRObjectTemplate;
            }
            if (jetRptNewTable != null && ((JetRptTableColumn)jetRptNewTable.getColumn(n)).getTableColumnType() == 3) {
                ((List)hashVector2.get("Others")).add("DataEvaluationSetting");
            }
        }
        n = (object = this.getCurrentUsedRenderer()) == null ? 0 : object.getRenderType();
        this.PATTERN_STYLE_STR_NAMES(n, hashVector2);
        return hashVector2;
    }

    private HashVector LOGIC(HashVector hashVector) {
        HashVector hashVector2 = JetRptField.duplicatePropGrpsDesc(hashVector);
        hashVector2.remove("Border");
        hashVector2.remove("Color");
        hashVector2.remove("Pattern");
        hashVector2.remove("Geometry");
        hashVector2.remove("Excel");
        hashVector2.remove("TOC");
        List list = (List)hashVector2.get("TextFormat");
        if (this instanceof JetRptTextField && ((JetRptTextField)this).isMVSpecial.booleanValue()) {
            list.clear();
        } else {
            list.remove("AutoFit");
            list.remove("Bold");
            list.remove("FontFace");
            list.remove("FontSize");
            list.remove("Italic");
            list.remove("MaxWidth");
            list.remove("StrikeOut");
            list.remove("Underline");
            list.remove("WordWrap");
            list.remove("TransWhileToHtml");
        }
        list = (List)hashVector2.get("Others");
        list.remove("clear");
        list.remove("display");
        list.remove("float");
        list.remove("position");
        list.remove("id");
        list.remove("class");
        list.remove("SuppressedIfNull");
        list.remove("Invisible");
        list.remove("ExportToPDF");
        list.remove("ExportToHTML");
        list.remove("ExportToText");
        list.remove("ExportToRTF");
        list.remove("ExportToXML");
        list.remove("ExportToPostScript");
        list.remove("ExportToApplet");
        return hashVector2;
    }

    private void PATTERN_STYLE_STR_NAMES(int n, HashVector hashVector) {
        List list = (List)hashVector.get("Others");
        if (this instanceof JetRptRefParameterField) {
            return;
        }
        if (n == 1 || n == 3 || n == 10) {
            list.remove("ExportToCSV");
            list.remove("ExportToText");
            list.remove("ExportToXML");
        } else if (n != 0 && n != 2 && n != 4 && n != 5 && n != 6 && n != 7 && n != 9 && n != 8 && n != 11 && n != 12 && n != 13) {
            list.remove("ExportToHTML");
            list.remove("ExportToPDF");
            list.remove("ExportToText");
            list.remove("ExportToRTF");
            list.remove("ExportToXML");
            list.remove("ExportToPostScript");
            list.remove("ExportToApplet");
        }
    }

    @Override
    public int[] getCanUsedRenderTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RptRenderer getCurrentUsedRenderer() {
        JetRptMode jetRptMode = this.getJetRptMode();
        if (jetRptMode == null) {
            JetRptField jetRptField = this;
            synchronized (jetRptField) {
                if (getCurrentRender == null) {
                    getCurrentRender = new JetRptTextRender();
                }
            }
            return getCurrentRender;
        }
        return jetRptMode.getCurrentRender();
    }

    @Override
    public short getFontFaceChangeByType() {
        if (this.fontName == null) {
            return -1;
        }
        short s = 0;
        if (this.fontName.isChangeByOther()) {
            s = 1;
        }
        if (this.fontName.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontName.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getFontSizeChangeByType() {
        if (this.fontSize == null) {
            return -1;
        }
        short s = 0;
        if (this.fontSize.isChangeByOther()) {
            s = 1;
        }
        if (this.fontSize.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontSize.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getBoldChangeByType() {
        if (this.bold == null) {
            return -1;
        }
        short s = 0;
        if (this.bold.isChangeByOther()) {
            s = 1;
        }
        if (this.bold.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.bold.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getItalicChangeByType() {
        if (this.italic == null) {
            return -1;
        }
        short s = 0;
        if (this.italic.isChangeByOther()) {
            s = 1;
        }
        if (this.italic.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.italic.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getUnderlineChangeByType() {
        if (this.underline == null) {
            return -1;
        }
        short s = 0;
        if (this.underline.isChangeByOther()) {
            s = 1;
        }
        if (this.underline.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.underline.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    @Override
    public short getForegroundChangeByType() {
        if (this.fontColor == null) {
            return -1;
        }
        short s = 0;
        if (this.fontColor.isChangeByOther()) {
            s = 1;
        }
        if (this.fontColor.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontColor.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public JetLinkProperties getLinkGroupProperty() {
        return this.equalsIgnoreCase;
    }

    @Override
    public JetLink getLinkProperty() {
        return this.equalsIgnoreCase.link;
    }

    @Override
    public boolean isLinkable() {
        return !this.equalsIgnoreCase.link.isEmpty();
    }

    @Override
    public boolean isSupportNormalLink() {
        return this.equalsIgnoreCase.isSupportNormalLink();
    }

    @Override
    public boolean isSupportMasterDetailLink() {
        return this.equalsIgnoreCase.isSupportMasterDetailLink();
    }

    @Override
    public boolean isSupportConditionalLink() {
        return this.equalsIgnoreCase.isSupportConditionalLink();
    }

    @Override
    public boolean isEnableConditionalLink() {
        return this.equalsIgnoreCase.isEnableConditionalLink();
    }

    @Override
    public ConditionalLinkValue getConditionalLinkValue() {
        return this.equalsIgnoreCase.toConditionalLinkValue();
    }

    @Override
    public SimpleLinkValue getSimpleLinkValue() {
        return this.equalsIgnoreCase.toSimpleLinkValue();
    }

    @Override
    public boolean isLinkValueEmpty() {
        return this.equalsIgnoreCase.isLinkValueEmpty();
    }

    @Override
    public LinkableSetAPI getLinkableSetor() {
        return this.equalsIgnoreCase;
    }

    public JetRptConditionalLinkList getConditionalLinkObject() {
        return (JetRptConditionalLinkList)this.equalsIgnoreCase.conditionLink.getObject();
    }

    static {
        PATTERN_STYLE_STR_NAMES.put("FontFace", 30);
        PATTERN_STYLE_STR_NAMES.put("FontSize", 20);
        PATTERN_STYLE_STR_NAMES.put("Bold", 21);
        PATTERN_STYLE_STR_NAMES.put("Italic", 22);
        PATTERN_STYLE_STR_NAMES.put("StrikeOut", 23);
        PATTERN_STYLE_STR_NAMES.put("Underline", 24);
        PATTERN_STYLE_STR_NAMES.put("Alignment", 37);
        PATTERN_STYLE_STR_NAMES.put("PatternStyle", 38);
        PATTERN_STYLE_STR_NAMES.put("PatternColor", 39);
        PATTERN_STYLE_STR_NAMES.put("Foreground", 40);
        PATTERN_STYLE_STR_NAMES.put("MaxWidth", 25);
        PATTERN_STYLE_STR_NAMES.put("AutoFit", 26);
        PATTERN_STYLE_STR_NAMES.put("WordWrap", 27);
        PATTERN_STYLE_STR_NAMES.put("TransWhileToHtml", 28);
        PATTERN_STYLE_STR_NAMES.put("Format", 41);
        jetToTxt = new Hashtable();
        txtToJet = new Hashtable();
        JetRptField.addToMappingTbl("Background", "chrfmt.cb");
        JetRptField.addToMappingTbl("Foreground", "chrfmt.cf");
        JetRptField.addToMappingTbl("FontFace", "chrfmt.f");
        JetRptField.addToMappingTbl("FontSize", "chrfmt.fs");
        JetRptField.addToMappingTbl("Bold", "chrfmt.b");
        JetRptField.addToMappingTbl("Italic", "chrfmt.i");
        JetRptField.addToMappingTbl("StrikeOut", "chrfmt.strike");
        JetRptField.addToMappingTbl("Underline", "chrfmt.ul");
        getColor = null;
        getColumn = null;
        getCurrentRender = null;
    }
}

