/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbBuffer;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.controls.JetEnumeration;
import jet.controls.JetString;
import jet.naming.EnumerationConstant;
import jet.report.JetRptObject;
import jet.util.HashVector;

public class JetRptFilter
extends JetRptObject {
    public static final String[] OPS = EnumerationConstant.OPERATOR_STR_NAMES;
    public static final int EQUAL = 0;
    public static final int GE = 1;
    public static final int GREATER = 2;
    public static final int LESS = 3;
    public static final int LE = 4;
    public static final int UNEQUAL = 5;
    public static final String[] LOGIC = EnumerationConstant.LOGIC_STR_NAMES;
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int END = 2;
    private boolean LOGIC_STR_NAMES = true;
    private boolean OPERATOR_STR_NAMES;
    private int SEDU = -1;
    private int add;
    private DbBuffer append;
    private DbValue compareTo;
    public JetString column;
    public JetString value;
    public JetEnumeration operator;
    public JetEnumeration logic;
    private static HashMap createRecord = null;
    private static final HashVector equals = new HashVector(1);

    public JetRptFilter() {
        this.LOGIC();
    }

    public JetRptFilter(String string, String string2, int n, int n2) {
        this();
        this.setColumn(string);
        this.setValue(string2);
        this.setOperator(n);
        this.setLogic(n2);
        this.column.setCanChangeByOthers(true);
        this.operator.setCanChangeByOthers(true);
        this.value.setCanChangeByOthers(true);
        this.logic.setCanChangeByOthers(true);
        this.getProperties().put("Column", this.column);
        this.getProperties().put("Operator", this.operator);
        this.getProperties().put("Value", this.value);
        this.getProperties().put("Logic", this.logic);
    }

    public JetRptFilter(JetRptFilter jetRptFilter) {
        this(jetRptFilter.getColumn(), jetRptFilter.getValue(), jetRptFilter.getOperator(), jetRptFilter.getLogic());
        this.add = jetRptFilter.add;
        this.SEDU = jetRptFilter.SEDU;
        this.LOGIC_STR_NAMES = jetRptFilter.LOGIC_STR_NAMES;
        this.compareTo = jetRptFilter.compareTo;
        this.append = jetRptFilter.append;
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("FilterPrefix");
    }

    @Override
    public String getInstancePrefix() {
        return "FilterCondition";
    }

    public JetRptFilter copy() {
        return new JetRptFilter(this);
    }

    public String getColumn() {
        return this.column.get();
    }

    public void setColumn(String string) {
        this.column.set(string);
    }

    public int getOperator() {
        return this.operator.intValue();
    }

    public void setOperator(int n) {
        this.operator.set(n);
    }

    public String getValue() {
        return this.value.get();
    }

    public void setValue(String string) {
        this.value.set(string);
    }

    public int getLogic() {
        return this.logic.intValue();
    }

    public void setLogic(int n) {
        this.logic.set(n);
    }

    public DbValue getDbValue() {
        return this.compareTo;
    }

    public void setDbValue(DbValue dbValue) {
        this.compareTo = dbValue;
    }

    public int getPageNum() {
        return this.add;
    }

    public void setPageNum(int n) {
        this.add = n;
    }

    public void setIsSel(boolean bl) {
        this.LOGIC_STR_NAMES = bl;
    }

    public boolean isSel() {
        return this.LOGIC_STR_NAMES;
    }

    public int getIndex() {
        return this.SEDU;
    }

    public void setIndex(int n) {
        this.SEDU = n;
    }

    public boolean isDisable() {
        return this.OPERATOR_STR_NAMES;
    }

    public void setDisable(boolean bl) {
        this.OPERATOR_STR_NAMES = bl;
    }

    public boolean isValid() {
        String string = this.getColumn();
        return string != null && string.length() > 0;
    }

    public boolean isEquals(JetRptFilter jetRptFilter) {
        if (this.getColumn().equals(jetRptFilter.getColumn()) && this.getOperator() == jetRptFilter.getOperator() && this.getLogic() == jetRptFilter.getLogic()) {
            boolean bl = this.getValue().equals(jetRptFilter.getValue());
            if (bl) {
                bl = this.compareTo == null && jetRptFilter.getDbValue() == null ? true : (this.compareTo != null && jetRptFilter.getDbValue() != null ? this.compareTo.compareTo(jetRptFilter.getDbValue()) == 0 : false);
            }
            return bl;
        }
        return false;
    }

    public boolean isConflict(JetRptFilter jetRptFilter) {
        if (!this.isEquals(jetRptFilter) && this.getColumn().equals(jetRptFilter.getColumn()) && this.getLogic() == 0) {
            int n = this.compareTo.compareTo(jetRptFilter.getDbValue());
            switch (this.getOperator()) {
                case 1: {
                    switch (jetRptFilter.getOperator()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            return false;
                        }
                        case 0: {
                            return n < 0;
                        }
                        case 3: {
                            return n > 0;
                        }
                        case 4: {
                            return n > 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (jetRptFilter.getOperator()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            return false;
                        }
                        case 0: {
                            return n > 0;
                        }
                        case 3: {
                            return n >= 0;
                        }
                        case 4: {
                            return n > 0;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (jetRptFilter.getOperator()) {
                        case 1: {
                            return n < 0;
                        }
                        case 2: {
                            return n <= 0;
                        }
                        case 0: {
                            return n != 0;
                        }
                        case 3: {
                            return n >= 0;
                        }
                        case 4: {
                            return n > 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (jetRptFilter.getOperator()) {
                        case 1: {
                            return n <= 0;
                        }
                        case 2: {
                            return n < 0;
                        }
                        case 0: {
                            return n <= 0;
                        }
                        case 3: {
                            return false;
                        }
                        case 4: {
                            return false;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (jetRptFilter.getOperator()) {
                        case 1: {
                            return n < 0;
                        }
                        case 2: {
                            return n <= 0;
                        }
                        case 0: {
                            return n < 0;
                        }
                        case 3: {
                            return false;
                        }
                        case 4: {
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void updatePage(int n, DbBuffer dbBuffer) throws SQLException {
        if (dbBuffer == null) {
            this.LOGIC_STR_NAMES = false;
        } else if (this.compareTo != null) {
            this.SEDU = JetRptFilter.getIndex(this.compareTo, dbBuffer);
            if (this.SEDU == -1) {
                this.LOGIC_STR_NAMES = false;
                this.add = 0;
            } else {
                this.LOGIC_STR_NAMES = true;
                this.add = this.SEDU / n;
            }
        }
    }

    public String toString() {
        return "JetRptFilter[" + this.getColumn() + " : " + this.getValue() + " : " + this.getOperator() + " : " + this.getLogic() + "]";
    }

    public static int getIndex(DbValue dbValue, DbBuffer dbBuffer) throws SQLException {
        int n = -1;
        Record record = dbBuffer.getRecordModel().createRecord();
        dbBuffer.setReadCursor(0);
        for (int i = 0; i < dbBuffer.getRecords(); ++i) {
            dbBuffer.nextRecord(record, false);
            DbValue dbValue2 = record.getCell(0);
            if (dbValue2.compareTo(dbValue) != 0) continue;
            n = i;
            break;
        }
        dbBuffer.setReadCursor(0);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (createRecord == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (createRecord == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Value", n++);
                    hashMap.put("Logic", n++);
                    hashMap.put("Operator", n++);
                    hashMap.put("Column", n++);
                    createRecord = hashMap;
                }
            }
        }
        return createRecord;
    }

    private void LOGIC() {
        this.column = new JetString(this, "Column");
        this.operator = new JetEnumeration(this, "Operator", 70);
        this.value = new JetString(this, "Value");
        this.logic = new JetEnumeration(this, "Logic", 67);
        this.column.setCanChangeByOthers(false);
        this.operator.setCanChangeByOthers(false);
        this.value.setCanChangeByOthers(false);
        this.logic.setCanChangeByOthers(false);
        this.column.setEditFlag(0);
        this.operator.setEditFlag(0);
        this.value.setEditFlag(0);
        this.logic.setEditFlag(0);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return equals;
        }
        return null;
    }

    static {
        String string = null;
        Vector<String> vector = null;
        string = "FilterInfo";
        vector = new Vector<String>(4);
        vector.add("Column");
        vector.add("Operator");
        vector.add("Value");
        vector.add("Logic");
        equals.put(string, vector);
    }
}

