/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetColor;
import jet.datastream.JRObjectResult;
import jet.ie.WriterTool;
import jet.naming.EnumerationConstant;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptLineStyle;
import jet.report.JetRptLineWidth;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.image.ImageProvider;

public class JetRptGTBox
extends JetRptGeometryObject {
    public JetRptLineStyle borderStyle;
    public JetRptLineWidth borderWidth;
    public JetColor borderColor;
    public int iNBorderStyle;
    public int iNBorderWidth = Unit.convertPixelToUnit(1);
    public Color cNBorderColor = Color.lightGray;
    private boolean LINESTYLE_ALL_STR_NAMES = false;
    private Hashtable _mapStringToColor = new Hashtable();
    private static Hashtable black = new Hashtable();
    private static HashMap convertPixelToUnit;
    private static HashVector enableAllChangeBys;

    public JetRptGTBox() {
        this.setObjectType(23);
        this.primProSize = (short)(this.primProSize + 3);
        this.iNBorderStyle = 1;
        this.cNBorderColor = Color.black;
        this.style.setDefault("Box");
        if (this.style.getList() == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("Box");
            this.style.setList(vector);
        } else if (!this.style.getList().contains("Box")) {
            this.style.getList().insertElementAt("Box", 0);
        }
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.LINESTYLE_ALL_STR_NAMES) {
            this.LINESTYLE_ALL_STR_NAMES = true;
            this._mapStringToColor = super.getPrimProp();
            this._mapStringToColor.put("BorderStyle", 107);
            this._mapStringToColor.put("BorderWidth", 31);
            this._mapStringToColor.put("BorderColor", 42);
        }
        return this._mapStringToColor;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.LINESTYLE_ALL_STR_NAMES();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.borderColor != null) {
            int n = 0;
            Integer n2 = (Integer)black.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch (n) {
                case 107: {
                    this.iNBorderStyle = this.borderStyle.intValue();
                    break;
                }
                case 31: {
                    this.iNBorderWidth = this.borderWidth.getUnit();
                    break;
                }
                case 42: {
                    this.cNBorderColor = this.borderColor.get();
                }
            }
        }
    }

    @Override
    public String getInstancePrefix() {
        return "Box";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Box");
    }

    @Override
    public Color getBorderColor(JRObjectResult jRObjectResult) {
        return this.cNBorderColor;
    }

    @Override
    public int getBorderStyle(JRObjectResult jRObjectResult) {
        return this.iNBorderStyle;
    }

    @Override
    public int getBorderWidth(JRObjectResult jRObjectResult) {
        return this.iNBorderWidth;
    }

    @Override
    public boolean getBorderStyleChBy() {
        return false;
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        Integer n4 = (Integer)black.get(string);
        if (n4 != null) {
            n3 = n4;
        } else {
            super.setInt(string, n, n2);
        }
        switch (n3) {
            case 31: {
                this.iNBorderWidth = Unit.upgrade(n, n2, true);
                bl = true;
            }
        }
        if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)black.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setPrimUnit(string, string2);
        }
        switch (n) {
            case 107: {
                if (string2.equals(EnumerationConstant.LINESTYLE_ALL_STR_NAMES[1])) {
                    this.iNBorderStyle = 1;
                } else if (string2.equals(EnumerationConstant.LINESTYLE_ALL_STR_NAMES[2])) {
                    this.iNBorderStyle = 2;
                } else if (string2.equals(EnumerationConstant.LINESTYLE_ALL_STR_NAMES[3])) {
                    this.iNBorderStyle = 3;
                } else if (string2.equals(EnumerationConstant.LINESTYLE_ALL_STR_NAMES[4])) {
                    this.iNBorderStyle = 4;
                } else if (string2.equals(EnumerationConstant.LINESTYLE_ALL_STR_NAMES[0])) {
                    this.iNBorderStyle = 0;
                }
                bl = true;
                break;
            }
            case 42: {
                bl = true;
                this.cNBorderColor = MiscTools._mapStringToColor(string2);
            }
        }
        if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get("BorderColor");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("BorderColor", s2);
        }
        WriterTool.writePrimColor(s2, false, this.cNBorderColor, null, dataOutput);
        s2 = (Short)hashVector.get("BorderStyle");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("BorderStyle", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNBorderStyle, null, dataOutput, 3);
        s2 = (Short)hashVector.get("BorderWidth");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("BorderWidth", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNBorderWidth, null, dataOutput, 4);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (convertPixelToUnit == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (convertPixelToUnit == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("BorderColor", n++);
                    hashMap.put("BorderWidth", n++);
                    hashMap.put("BorderStyle", n++);
                    convertPixelToUnit = hashMap;
                }
            }
        }
        return convertPixelToUnit;
    }

    private void LINESTYLE_ALL_STR_NAMES() {
        this.borderStyle = new JetRptLineStyle(this, "BorderStyle", 61);
        this.borderWidth = new JetRptLineWidth(this, "BorderWidth");
        this.borderColor = new JetColor(this, "BorderColor");
        this.borderStyle.set(1);
        this.borderColor.set(Color.black);
        this.borderStyle.enableAllChangeBys(false);
        this.borderWidth.enableAllChangeBys(false);
        this.borderColor.enableAllChangeBys(false);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (enableAllChangeBys != null) {
                return enableAllChangeBys;
            }
            enableAllChangeBys = JetRptGTBox.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (enableAllChangeBys == null) {
                enableAllChangeBys = new HashVector();
            }
            String string = "BoxProperty";
            List<String> list = new Vector<String>(3);
            list.add("BorderColor");
            list.add("BorderStyle");
            list.add("BorderWidth");
            enableAllChangeBys.put(string, list);
            string = "Accessibility";
            list = (List)enableAllChangeBys.get(string);
            enableAllChangeBys.remove(string);
            enableAllChangeBys.put(string, list);
            return enableAllChangeBys;
        }
        return null;
    }

    static {
        black.put("BorderStyle", 107);
        black.put("BorderWidth", 31);
        black.put("BorderColor", 42);
        convertPixelToUnit = null;
        enableAllChangeBys = null;
    }
}

