/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetColor;
import jet.datastream.JRObjectResult;
import jet.ie.WriterTool;
import jet.naming.EnumerationConstant;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptLineStyle;
import jet.report.JetRptLineWidth;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.image.ImageProvider;

public class JetRptLine
extends JetRptGeometryObject {
    public JetColor lineColor;
    public JetRptLineStyle lineStyle;
    public JetRptLineWidth lineWidth;
    public Color cNLineColor = Color.lightGray;
    public int iNLineStyle;
    public int iNLineWidth = Unit.convertPixelToUnit(1);
    private boolean LINESTYLE_SIM_STR_NAMES = false;
    private Hashtable S = new Hashtable();
    private static Hashtable SEDU = new Hashtable();
    private static HashMap _mapStringToColor;
    private static HashVector add;

    public JetRptLine() {
        this.primProSize = (short)(this.primProSize + 3);
        this.cNLineColor = Color.black;
        this.iNLineStyle = 1;
        this.setObjectType(22);
        this.style.setDefault("Line");
        if (this.style.getList() == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("Line");
            this.style.setList(vector);
        } else if (!this.style.getList().contains("Line")) {
            this.style.getList().insertElementAt("Line", 0);
        }
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.LINESTYLE_SIM_STR_NAMES) {
            this.LINESTYLE_SIM_STR_NAMES = true;
            this.S = super.getPrimProp();
            this.S.put("LineColor", 104);
            this.S.put("LineStyle", 105);
            this.S.put("LineWidth", 106);
        }
        return this.S;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.LINESTYLE_SIM_STR_NAMES();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.lineWidth != null) {
            int n = 0;
            Integer n2 = (Integer)SEDU.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch (n) {
                case 104: {
                    this.cNLineColor = this.lineColor.get();
                    break;
                }
                case 105: {
                    this.iNLineStyle = this.lineStyle.intValue();
                    break;
                }
                case 106: {
                    this.iNLineWidth = this.lineWidth.getUnit();
                }
            }
        }
    }

    @Override
    public String getInstancePrefix() {
        return "Line";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Line");
    }

    @Override
    public Color getLineColor(JRObjectResult jRObjectResult) {
        return this.cNLineColor;
    }

    @Override
    public int getLineStyle(JRObjectResult jRObjectResult) {
        return this.iNLineStyle;
    }

    @Override
    public int getLineWidth(JRObjectResult jRObjectResult) {
        return this.iNLineWidth;
    }

    @Override
    public boolean getLineColorChBy() {
        return false;
    }

    @Override
    public boolean getLineStyleChBy() {
        return false;
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        Integer n4 = (Integer)SEDU.get(string);
        if (n4 != null) {
            n3 = n4;
        } else {
            super.setInt(string, n, n2);
        }
        switch (n3) {
            case 106: {
                this.iNLineWidth = Unit.upgrade(n, n2, true);
                bl = true;
            }
        }
        if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)SEDU.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setPrimUnit(string, string2);
        }
        switch (n) {
            case 105: {
                for (int i = 0; i < EnumerationConstant.LINESTYLE_SIM_STR_NAMES.length; ++i) {
                    if (!string2.equals(EnumerationConstant.LINESTYLE_SIM_STR_NAMES[i])) continue;
                    this.iNLineStyle = i;
                    break;
                }
                bl = true;
                break;
            }
            case 104: {
                bl = true;
                this.cNLineColor = MiscTools._mapStringToColor(string2);
            }
        }
        if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get("LineColor");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("LineColor", s2);
        }
        WriterTool.writePrimColor(s2, false, this.cNLineColor, null, dataOutput);
        s2 = (Short)hashVector.get("LineStyle");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("LineStyle", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNLineStyle, null, dataOutput, 3);
        s2 = (Short)hashVector.get("LineWidth");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("LineWidth", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNLineWidth, null, dataOutput, 4);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (_mapStringToColor == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (_mapStringToColor == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("LineStyle", n++);
                    hashMap.put("LineColor", n++);
                    hashMap.put("LineWidth", n++);
                    _mapStringToColor = hashMap;
                }
            }
        }
        return _mapStringToColor;
    }

    private void LINESTYLE_SIM_STR_NAMES() {
        this.lineColor = new JetColor(this, "LineColor");
        this.lineStyle = new JetRptLineStyle(this, "LineStyle");
        this.lineWidth = new JetRptLineWidth(this, "LineWidth");
        this.lineColor.set(Color.black);
        this.lineStyle.set(1);
        this.lineStyle.enableAllChangeBys(false);
        this.lineWidth.enableAllChangeBys(false);
        this.lineColor.enableAllChangeBys(false);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (add != null) {
                return add;
            }
            add = JetRptLine.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (add == null) {
                add = new HashVector();
            }
            String string = "Color";
            add.remove(string);
            string = "LineProperty";
            List<String> list = new Vector<String>(3);
            list.add("LineColor");
            list.add("LineStyle");
            list.add("LineWidth");
            add.put(string, list);
            string = "Accessibility";
            list = (List)add.get(string);
            add.remove(string);
            add.put(string, list);
            return add;
        }
        return null;
    }

    static {
        SEDU.put("LineColor", 104);
        SEDU.put("LineStyle", 105);
        SEDU.put("LineWidth", 106);
        _mapStringToColor = null;
        add = null;
    }
}

