/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import com.jinfonet.util.JRLog;
import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetBLColumnName;
import jet.controls.JetBoolean;
import jet.controls.JetBytes;
import jet.controls.JetColumnName;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetMappingTable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.dataengine.groupengine.GroupModel;
import jet.report.JetRptArea;
import jet.report.JetRptDataContainer;
import jet.report.JetRptGroupFilter;
import jet.report.JetRptMapAddTextField;
import jet.report.JetRptMapDBField;
import jet.report.JetRptMapTextField;
import jet.report.JetRptPolyLine;
import jet.report.JetRptTextField;
import jet.report.specialFunc.SpecialFunction;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.util.HashVector;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceUtil;

public class JetRptMap
extends JetRptDataContainer {
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int CUSTOMIZED = 2;
    public JetBLColumnName blColumnName;
    public JetString name;
    public JetImgProperty src;
    public JetEnumeration altContentType;
    public JetBoolean show;
    public JetColumnName columnName;
    public JetBoolean isData;
    public JetString inReportPosition;
    public JetBytes[] image;
    public JetBoolean bEmbed;
    public JetMappingTable areaFml;
    public JetUnitNumber actWidth;
    public JetUnitNumber actHeight;
    public JetVector sortBy;
    public JetVector sortOrder;
    public JetVector branch;
    public JetNumber groupType;
    public JetColumnName groupBy;
    public JetString groupOrder;
    public JetString othersName;
    public JetBoolean keepOthers;
    public JetVector specNames;
    public JetVector specOperators;
    public JetVector specOprands;
    public JetVector specOpNum;
    public JetNumber selectStartPosition;
    public JetEnumeration selectType;
    public JetNumber selectN;
    public JetString secuGrant;
    public JetString secuGroups;
    public JetString secuRoles;
    public JetBoolean gotoDetail;
    private JetStringList DBCOL_EDITOR;
    public JetBoolean invisibleInBrowserFilterDialog;
    public JetNumber indexInBrowseFilterDialog;
    private static HashMap SEDU = null;
    private static HashVector Z = null;

    public JetRptMap() {
        this.DBCOL_EDITOR();
        this.setObjectType(40);
    }

    @Override
    public void afterInit() {
        super.afterInit();
    }

    public int indexOf(JetRptArea jetRptArea) {
        JetRptArea[] jetRptAreaArray = this.getAreas(true);
        if (jetRptAreaArray != null) {
            int n = jetRptAreaArray.length;
            while (--n >= 0) {
                if (jetRptArea != jetRptAreaArray[n]) continue;
                return n;
            }
        }
        return -1;
    }

    public JetRptArea getArea(int n) {
        JetRptArea[] jetRptAreaArray = this.getAreas(true);
        if (jetRptAreaArray.length > 0 && n >= 0 && n < jetRptAreaArray.length) {
            return jetRptAreaArray[n];
        }
        return null;
    }

    public JetRptMapTextField getLabel() {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptMapTextField)) continue;
            return (JetRptMapTextField)e;
        }
        return null;
    }

    public JetRptMapDBField[] getSummaries() {
        Vector vector = this.getChildren();
        Vector<JetRptMapDBField> vector2 = new Vector<JetRptMapDBField>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptMapDBField)) continue;
            vector2.addElement((JetRptMapDBField)e);
        }
        return vector2.toArray(new JetRptMapDBField[0]);
    }

    @Override
    public String getInstancePrefix() {
        if (this.name.get().length() > 0) {
            return this.name.get();
        }
        return "Map";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Map");
    }

    public boolean isEmbed() {
        return this.bEmbed.booleanValue() || this.src.isEmbed();
    }

    public void setEmbedImage(Image image, int n) {
        this.bEmbed.set(true);
        this.src.setEmbedImage(new ImageResource(image, n));
    }

    public void setEmbedImage(byte[] byArray) {
        block6: {
            this.bEmbed.set(true);
            if (byArray != null && byArray.length > 8) {
                try {
                    ImageResource imageResource = ImageResourceUtil.loadImageResourceFromBytes(byArray);
                    this.src.setEmbedImage(imageResource);
                    if (imageResource.getImage() == null && JRLog.isError(3)) {
                        JRLog.error(3, "Unkown exception on set embed image to Map");
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, "Unkown exception on set embed image to Map, IOException", (Throwable)iOException);
                    }
                    break block6;
                }
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, "Exception on set embed image to Map, this byte array incorrect.");
            }
        }
    }

    public int getActualHeight() {
        return this.actHeight.getUnit();
    }

    public int getActualWidth() {
        return this.actWidth.getUnit();
    }

    public void setActualWidth(int n) {
        this.actWidth.setUnitValue(n);
    }

    public void setActualHeight(int n) {
        this.actHeight.setUnitValue(n);
    }

    public JetRptArea[] getAreas(boolean bl) {
        Vector vector = this.getChildren();
        Vector<JetRptArea> vector2 = new Vector<JetRptArea>();
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof JetRptArea)) continue;
                vector2.addElement((JetRptArea)e);
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof JetRptArea) || ((JetRptArea)e).type.intValue() == 0) continue;
                vector2.addElement((JetRptArea)e);
            }
        }
        return vector2.toArray(new JetRptArea[0]);
    }

    public JetRptTextField[] getMapLabels() {
        Vector vector = this.getChildren();
        Vector<JetRptMapAddTextField> vector2 = new Vector<JetRptMapAddTextField>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptMapAddTextField)) continue;
            vector2.addElement((JetRptMapAddTextField)e);
        }
        return vector2.toArray(new JetRptMapAddTextField[0]);
    }

    public JetRptPolyLine[] getMapPolyline() {
        Vector vector = this.getChildren();
        Vector<JetRptPolyLine> vector2 = new Vector<JetRptPolyLine>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!e.getClass().getName().equals("jet.report.JetRptPolyLine")) continue;
            vector2.addElement((JetRptPolyLine)e);
        }
        return vector2.toArray(new JetRptPolyLine[0]);
    }

    public JetRptArea getDefaultArea() {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptArea) || !((JetRptArea)e).isDefaultTypeArea()) continue;
            return (JetRptArea)e;
        }
        return null;
    }

    public Vector getGroupFilters() {
        Vector<JetRptGroupFilter> vector = new Vector<JetRptGroupFilter>();
        Vector vector2 = this.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            if (!(vector2.elementAt(i) instanceof JetRptGroupFilter)) continue;
            vector.add((JetRptGroupFilter)vector2.elementAt(i));
        }
        return vector;
    }

    public SpecialFunction getSpecialFunction() {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof SpecialFunction)) continue;
            return (SpecialFunction)vector.elementAt(i);
        }
        return null;
    }

    public SpecialFunction setSpecialFunction(SpecialFunction specialFunction) {
        SpecialFunction specialFunction2 = this.getSpecialFunction();
        if (specialFunction2 != null) {
            ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction2));
        }
        if (specialFunction != null) {
            ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction));
            ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction));
        }
        return specialFunction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (SEDU == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (SEDU == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("BLColumnName", n++);
                    hashMap.put("Name", n++);
                    hashMap.put("ImageSource", n++);
                    hashMap.put("AltContentType", n++);
                    hashMap.put("ShowFlag", n++);
                    hashMap.put("ColumnName", n++);
                    hashMap.put("FromDatabase", n++);
                    hashMap.put("Position", n++);
                    hashMap.put("Embed", n++);
                    hashMap.put("Image0", n++);
                    hashMap.put("Image1", n++);
                    hashMap.put("Image2", n++);
                    hashMap.put("Image3", n++);
                    hashMap.put("Image4", n++);
                    hashMap.put("Image5", n++);
                    hashMap.put("Image6", n++);
                    hashMap.put("Image7", n++);
                    hashMap.put("CondiArea", n++);
                    hashMap.put("ActualWidth", n++);
                    hashMap.put("ActualHeight", n++);
                    hashMap.put("SortBy", n++);
                    hashMap.put("SortOrder", n++);
                    hashMap.put("Branch", n++);
                    hashMap.put("GroupType", n++);
                    hashMap.put("GroupBy", n++);
                    hashMap.put("GroupOrder", n++);
                    hashMap.put("OthersName", n++);
                    hashMap.put("KeepOthers", n++);
                    hashMap.put("SpecialNames", n++);
                    hashMap.put("SpecialOperators", n++);
                    hashMap.put("SpecialOperands", n++);
                    hashMap.put("SpecialOpNum", n++);
                    hashMap.put("SelectStartPosition", n++);
                    hashMap.put("SelectType", n++);
                    hashMap.put("SelectN", n++);
                    hashMap.put("Grant", n++);
                    hashMap.put("Groups", n++);
                    hashMap.put("Roles", n++);
                    hashMap.put("GotoDetail", n++);
                    hashMap.put("DetailTargetFrame", n++);
                    hashMap.put("InvisibleInBFDlg", n++);
                    hashMap.put("IndexInBFDlg", n++);
                    SEDU = hashMap;
                }
            }
        }
        return SEDU;
    }

    private void DBCOL_EDITOR() {
        this.blColumnName = new JetBLColumnName(this, "BLColumnName");
        this.name = new JetString(this, "Name");
        this.src = new JetImgProperty(this, "ImageSource");
        this.altContentType = new JetEnumeration(this, "AltContentType", 7);
        this.show = new JetBoolean(this, "ShowFlag", true);
        this.columnName = new JetColumnName(this, "ColumnName");
        this.isData = new JetBoolean(this, "FromDatabase", true);
        this.inReportPosition = new JetString(this, "Position");
        this.image = new JetBytes[8];
        this.bEmbed = new JetBoolean(this, "Embed", false);
        int n = this.image.length;
        while (--n >= 0) {
            this.image[n] = new JetBytes(this, "Image" + n);
        }
        this.altContentType.set(2);
        this.columnName.setEditorType(JetProperty.DBCOL_EDITOR);
        this.columnName.setEditFlag(2);
        this.columnName.setCanChangeByOthers(false);
        this.style.setDefault("Map");
        if (this.style.getList() == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("Map");
            this.style.setList(vector);
        } else if (!this.style.getList().contains("Map")) {
            this.style.getList().insertElementAt("Map", 0);
        }
        this.areaFml = new JetMappingTable(this, "CondiArea");
        this.actWidth = new JetUnitNumber(this, "ActualWidth", -1);
        this.actHeight = new JetUnitNumber(this, "ActualHeight", -1);
        this.actWidth.setCanChangeByOthers(false);
        this.actHeight.setCanChangeByOthers(false);
        this.sortBy = new JetColumnVector(this, "SortBy");
        this.sortOrder = new JetVector(this, "SortOrder");
        this.branch = new JetVector(this, "Branch");
        this.groupType = new JetNumber(this, "GroupType", 0);
        this.groupBy = new JetColumnName(this, "GroupBy");
        this.groupOrder = new JetString(this, "GroupOrder", GroupModel.getStringForOrder(0));
        this.othersName = new JetString(this, "OthersName", "Others");
        this.keepOthers = new JetBoolean(this, "KeepOthers", false);
        this.specNames = new JetVector(this, "SpecialNames");
        this.specOperators = new JetVector(this, "SpecialOperators");
        this.specOprands = new JetVector(this, "SpecialOperands");
        this.specOpNum = new JetVector(this, "SpecialOpNum");
        this.selectStartPosition = new JetNumber(this, "SelectStartPosition", 1);
        this.selectType = new JetEnumeration(this, "SelectType", 87);
        this.selectN = new JetNumber(this, "SelectN", -1);
        this.secuGrant = new JetString(this, "Grant");
        this.secuGroups = new JetString(this, "Groups");
        this.secuRoles = new JetString(this, "Roles");
        this.selectType.set(0);
        this.gotoDetail = new JetBoolean(this, "GotoDetail");
        this.DBCOL_EDITOR = new JetStringList(this, "DetailTargetFrame", "");
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("_self");
        vector.add("_top");
        vector.add("_blank");
        vector.add("_parent");
        this.DBCOL_EDITOR.setList(vector);
        this.DBCOL_EDITOR.setCanChangeByOthers(false);
        this.DBCOL_EDITOR.setCanChangeByBL(false);
        this.DBCOL_EDITOR.setCanChangeByFmtt(false);
        this.DBCOL_EDITOR.set("_self");
        this.invisibleInBrowserFilterDialog = new JetBoolean(this, "InvisibleInBFDlg", false);
        this.invisibleInBrowserFilterDialog.enableAllChangeBys(false);
        this.indexInBrowseFilterDialog = new JetNumber(this, "IndexInBFDlg", 0);
        this.indexInBrowseFilterDialog.enableAllChangeBys(false);
    }

    public int getIndexInBrowserFilterDialog() {
        return this.indexInBrowseFilterDialog.intValue();
    }

    public boolean isInvisibleInBrowserFilterDialog() {
        return this.invisibleInBrowserFilterDialog.booleanValue();
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (Z != null) {
                return Z;
            }
            Z = JetRptMap.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (Z == null) {
                Z = new HashVector();
            }
            String string = "CSS";
            Z.remove(string);
            string = "Others";
            List<String> list = (Vector<String>)Z.get(string);
            list.remove("RecordLocation");
            list.remove("ExportToCSV");
            list.add("GotoDetail");
            list.add("DetailTargetFrame");
            list.add("InvisibleInBFDlg");
            list.add("IndexInBFDlg");
            string = "Map";
            list = new Vector<String>(4);
            list.add("Name");
            list.add("ImageSource");
            list.add("AltContentType");
            list.add("ColumnName");
            Z.put(string, list);
            string = "TOC";
            list = new Vector();
            Z.put(string, list);
            list.add("TOCAnchor");
            list.add("AnchorDispValue");
            string = "Accessibility";
            list = (List)Z.get(string);
            list.add("ExternalID");
            list.add("ExternalStyle");
            list.add("Lang");
            Z.remove(string);
            Z.put(string, list);
            return Z;
        }
        return null;
    }
}

