/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.Unit;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.datastream.JRObjectResult;
import jet.ie.WriterTool;
import jet.naming.EnumerationConstant;
import jet.report.JetRptBreakContainer;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSection;
import jet.util.HashVector;
import jet.util.image.ImageProvider;

public class JetRptPagePanel
extends JetRptBreakContainer {
    public JetEnumeration pageType;
    public JetEnumeration pageOrient;
    public JetEnumeration pageUsage;
    public JetUnitNumber width;
    public JetUnitNumber height;
    public JetUnitNumber leftmargin;
    public JetUnitNumber topmargin;
    public JetUnitNumber rightmargin;
    public JetUnitNumber bottommargin;
    public int iNPageType;
    public int iNOrientation;
    public int iNWidth;
    public int iNHeight;
    public int iNLeftMargin = Unit.convertInchToUnit(0.5);
    public int iNTopMargin = Unit.convertInchToUnit(0.5);
    public int iNRightMargin = Unit.convertInchToUnit(0.5);
    public int iNBottomMargin = Unit.convertInchToUnit(0.5);
    private boolean ORIENTATION_STR_NAMES = false;
    private static Hashtable PAGETYPE_STR_NAMES = new Hashtable();
    private static HashMap S;
    private static final HashVector SEDU;

    public JetRptPagePanel() {
        this.primProSize = (short)8;
        this.iNPageType = Unit.getPaperType("A4");
        this.iNOrientation = Unit.getOrientType("Portrait");
        Dimension dimension = Unit.getPixelPaperSize(Unit.getPaperType("A4"), 0);
        this.iNWidth = Unit.convertPixelToUnit(dimension.width);
        this.iNHeight = Unit.convertPixelToUnit(dimension.height);
        this.S();
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.ORIENTATION_STR_NAMES) {
            this.ORIENTATION_STR_NAMES = true;
            PAGETYPE_STR_NAMES.put("PageType", 119);
            PAGETYPE_STR_NAMES.put("Orientation", 120);
            PAGETYPE_STR_NAMES.put("Width", 3);
            PAGETYPE_STR_NAMES.put("Height", 4);
            PAGETYPE_STR_NAMES.put("LeftMargin", 121);
            PAGETYPE_STR_NAMES.put("TopMargin", 122);
            PAGETYPE_STR_NAMES.put("RightMargin", 123);
            PAGETYPE_STR_NAMES.put("BottomMargin", 124);
        }
        return (Hashtable)PAGETYPE_STR_NAMES.clone();
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.PAGETYPE_STR_NAMES();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.bottommargin != null) {
            int n = 0;
            Integer n2 = (Integer)PAGETYPE_STR_NAMES.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch (n) {
                case 119: {
                    this.iNPageType = this.pageType.intValue();
                    break;
                }
                case 120: {
                    this.iNOrientation = this.pageOrient.intValue();
                    break;
                }
                case 3: {
                    this.iNWidth = this.width.getUnit();
                    break;
                }
                case 4: {
                    this.iNHeight = this.height.getUnit();
                    break;
                }
                case 121: {
                    this.iNLeftMargin = this.leftmargin.getUnit();
                    break;
                }
                case 122: {
                    this.iNTopMargin = this.topmargin.getUnit();
                    break;
                }
                case 123: {
                    this.iNRightMargin = this.rightmargin.getUnit();
                    break;
                }
                case 124: {
                    this.iNBottomMargin = this.bottommargin.getUnit();
                }
            }
        }
    }

    public int getPageWidth() {
        return Unit.convertUnitToPixel(this.iNWidth) - Unit.convertUnitToPixel(this.iNRightMargin) - Unit.convertUnitToPixel(this.iNLeftMargin);
    }

    public int getPageHeight() {
        return Unit.convertUnitToPixel(this.iNHeight) - Unit.convertUnitToPixel(this.iNTopMargin) - Unit.convertUnitToPixel(this.iNBottomMargin);
    }

    public int getUnitPageWidth() {
        return this.iNWidth - this.iNRightMargin - this.iNLeftMargin;
    }

    public int getUnitPageHeight() {
        return this.iNHeight - this.iNTopMargin - this.iNBottomMargin;
    }

    public Rectangle getUnitBounds() {
        return new Rectangle(0, 0, this.iNWidth, this.iNHeight);
    }

    public Rectangle getUnitClientBounds() {
        return new Rectangle(this.iNLeftMargin, this.iNTopMargin, this.iNWidth - this.iNLeftMargin - this.iNRightMargin, this.iNHeight - this.iNTopMargin - this.iNBottomMargin);
    }

    public Dimension getSize() {
        return new Dimension(Unit.convertUnitToPixel(this.iNWidth), Unit.convertUnitToPixel(this.iNHeight));
    }

    @Override
    public String getInstancePrefix() {
        return "PagePanel";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("PagePanel");
    }

    @Override
    public void afterInit() {
        super.afterInit();
        Dimension dimension = Unit.getUnitPaperSize(this.iNPageType, this.iNOrientation);
        if (dimension != null) {
            if (this.width != null) {
                this.width.setUnitValue(dimension.width);
                this.height.setUnitValue(dimension.height);
            } else {
                this.iNWidth = dimension.width;
                this.iNHeight = dimension.height;
            }
        }
    }

    public int getPageMinWidth() {
        int n;
        JetObject jetObject;
        int n2 = 0;
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)this.getParent();
        Vector vector = jetRptReportPanel.getChildren();
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            jetObject = (JetObject)vector.elementAt(i);
            if (!(jetObject instanceof JetRptGeometryObject)) continue;
            n = ((JetRptGeometryObject)jetObject).iNTopAttachPosX;
            if (n > n2) {
                n2 = n;
            }
            if ((n = ((JetRptGeometryObject)jetObject).iNBottomAttachPosX) <= n2) continue;
            n2 = n;
        }
        Vector vector2 = new Vector(10);
        this.ORIENTATION_STR_NAMES(vector2, jetRptReportPanel);
        n3 = vector2.size();
        for (int i = 0; i < n3; ++i) {
            JetRptSection jetRptSection = (JetRptSection)vector2.elementAt(i);
            Vector vector3 = jetRptSection.getChildren();
            for (int j = 0; j < vector3.size(); ++j) {
                jetObject = (JetObject)vector3.elementAt(j);
                n = ((JetUnitNumber)jetObject.nameToProperty("X")).get();
                if (n <= n2) continue;
                n2 = n;
            }
        }
        return n2;
    }

    private void ORIENTATION_STR_NAMES(Vector vector, JetRptBreakContainer jetRptBreakContainer) {
        Vector vector2 = jetRptBreakContainer.getChildren();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector2.elementAt(i);
            if (e instanceof JetRptSection) {
                vector.addElement((JetRptSection)e);
                continue;
            }
            if (!(e instanceof JetRptBreakContainer)) continue;
            this.ORIENTATION_STR_NAMES(vector, (JetRptBreakContainer)e);
        }
    }

    public Vector getDetails() {
        Vector vector = this.getChildren();
        Vector<JetRptDetailPanel> vector2 = new Vector<JetRptDetailPanel>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptDetailPanel)) continue;
            vector2.add((JetRptDetailPanel)e);
        }
        return vector2;
    }

    public int getPageType(JRObjectResult jRObjectResult) {
        return this.iNPageType;
    }

    public int getOrientation(JRObjectResult jRObjectResult) {
        return this.iNOrientation;
    }

    public int getWidth(JRObjectResult jRObjectResult) {
        return this.iNWidth;
    }

    public int getHeight(JRObjectResult jRObjectResult) {
        return this.iNHeight;
    }

    public int getLeftMargin(JRObjectResult jRObjectResult) {
        return this.iNLeftMargin;
    }

    public int getTopMargin(JRObjectResult jRObjectResult) {
        return this.iNTopMargin;
    }

    public int getRightMargin(JRObjectResult jRObjectResult) {
        return this.iNRightMargin;
    }

    public int getBottomMargin(JRObjectResult jRObjectResult) {
        return this.iNBottomMargin;
    }

    @Override
    public void setInt(String string, int n, int n2) {
        int n3 = 0;
        Integer n4 = (Integer)PAGETYPE_STR_NAMES.get(string);
        if (n4 == null) {
            return;
        }
        n3 = n4;
        switch (n3) {
            case 3: {
                this.iNWidth = Unit.upgrade(n, n2, false);
                break;
            }
            case 4: {
                this.iNHeight = Unit.upgrade(n, n2, false);
                break;
            }
            case 121: {
                this.iNLeftMargin = Unit.upgrade(n, n2, false);
                break;
            }
            case 122: {
                this.iNTopMargin = Unit.upgrade(n, n2, false);
                break;
            }
            case 123: {
                this.iNRightMargin = Unit.upgrade(n, n2, false);
                break;
            }
            case 124: {
                this.iNBottomMargin = Unit.upgrade(n, n2, false);
            }
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        String[] stringArray = EnumerationConstant.PAGETYPE_STR_NAMES;
        String[] stringArray2 = EnumerationConstant.ORIENTATION_STR_NAMES;
        int n = 0;
        Integer n2 = (Integer)PAGETYPE_STR_NAMES.get(string);
        if (n2 == null) {
            return;
        }
        n = n2;
        block0 : switch (n) {
            case 119: {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string2.equals(stringArray[i])) continue;
                    this.iNPageType = i;
                    break block0;
                }
                break;
            }
            case 120: {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string2.equals(stringArray2[i])) continue;
                    this.iNOrientation = i;
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        Short s2 = (Short)hashVector.get("PageType");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("PageType", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNPageType, null, dataOutput, 3);
        s2 = (Short)hashVector.get("Orientation");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("Orientation", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNOrientation, null, dataOutput, 3);
        s2 = (Short)hashVector.get("Width");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("Width", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNWidth, null, dataOutput, 4);
        s2 = (Short)hashVector.get("Height");
        if (s2 == null) {
            short s6 = s;
            s = (short)(s + 1);
            s2 = s6;
            hashVector.put("Height", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNHeight, null, dataOutput, 4);
        s2 = (Short)hashVector.get("LeftMargin");
        if (s2 == null) {
            short s7 = s;
            s = (short)(s + 1);
            s2 = s7;
            hashVector.put("LeftMargin", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNLeftMargin, null, dataOutput, 4);
        s2 = (Short)hashVector.get("TopMargin");
        if (s2 == null) {
            short s8 = s;
            s = (short)(s + 1);
            s2 = s8;
            hashVector.put("TopMargin", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNTopMargin, null, dataOutput, 4);
        s2 = (Short)hashVector.get("RightMargin");
        if (s2 == null) {
            short s9 = s;
            s = (short)(s + 1);
            s2 = s9;
            hashVector.put("RightMargin", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNRightMargin, null, dataOutput, 4);
        s2 = (Short)hashVector.get("BottomMargin");
        if (s2 == null) {
            short s10 = s;
            s = (short)(s + 1);
            s2 = s10;
            hashVector.put("BottomMargin", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNBottomMargin, null, dataOutput, 4);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (S == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (S == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("BottomMargin", n++);
                    hashMap.put("LeftMargin", n++);
                    hashMap.put("PageType", n++);
                    hashMap.put("TopMargin", n++);
                    hashMap.put("Width", n++);
                    hashMap.put("Height", n++);
                    hashMap.put("RightMargin", n++);
                    hashMap.put("Orientation", n++);
                    hashMap.put("PageUsage", n++);
                    S = hashMap;
                }
            }
        }
        return S;
    }

    private void PAGETYPE_STR_NAMES() {
        this.pageType = new JetEnumeration(this, "PageType", 74);
        this.pageOrient = new JetEnumeration(this, "Orientation", 72);
        this.width = new JetUnitNumber(this, "Width");
        this.height = new JetUnitNumber(this, "Height");
        this.leftmargin = new JetUnitNumber(this, "LeftMargin", Unit.convertInchToUnit(0.5));
        this.topmargin = new JetUnitNumber(this, "TopMargin", Unit.convertInchToUnit(0.5));
        this.rightmargin = new JetUnitNumber(this, "RightMargin", Unit.convertInchToUnit(0.5));
        this.bottommargin = new JetUnitNumber(this, "BottomMargin", Unit.convertInchToUnit(0.5));
        this.pageType.set("A4");
        this.pageOrient.set("Portrait");
        Dimension dimension = Unit.getPixelPaperSize(Unit.getPaperType("A4"), 0);
        this.width.set(dimension.width);
        this.height.set(dimension.height);
        this.pageType.setCanChangeByOthers(false);
        this.pageOrient.setCanChangeByOthers(false);
        this.width.setCanChangeByOthers(false);
        this.height.setCanChangeByOthers(false);
        this.leftmargin.setCanChangeByOthers(false);
        this.topmargin.setCanChangeByOthers(false);
        this.rightmargin.setCanChangeByOthers(false);
        this.bottommargin.setCanChangeByOthers(false);
    }

    private void S() {
        this.pageUsage = new JetEnumeration(this, "PageUsage", 122);
        this.pageUsage.setValue(1);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return SEDU;
        }
        return null;
    }

    static {
        PAGETYPE_STR_NAMES.put("PageType", 119);
        PAGETYPE_STR_NAMES.put("Orientation", 120);
        PAGETYPE_STR_NAMES.put("Width", 3);
        PAGETYPE_STR_NAMES.put("Height", 4);
        PAGETYPE_STR_NAMES.put("LeftMargin", 121);
        PAGETYPE_STR_NAMES.put("TopMargin", 122);
        PAGETYPE_STR_NAMES.put("RightMargin", 123);
        PAGETYPE_STR_NAMES.put("BottomMargin", 124);
        S = null;
        SEDU = new HashVector(3);
        String string = null;
        Vector<String> vector = null;
        string = "Paper";
        vector = new Vector<String>(4);
        vector.add("PageType");
        vector.add("Orientation");
        vector.add("Width");
        vector.add("Height");
        SEDU.put(string, vector);
        string = "Margin";
        vector = new Vector(4);
        vector.add("TopMargin");
        vector.add("LeftMargin");
        vector.add("BottomMargin");
        vector.add("RightMargin");
        SEDU.put(string, vector);
    }
}

