/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetAttachable;
import jet.controls.JetColor;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.report.JetRptBox;
import jet.report.JetRptLineWidth;
import jet.util.HashVector;

public abstract class JetRptRectangle
extends JetRptBox
implements JetContainable {
    public JetRptLineWidth topBorderWidth;
    public JetRptLineWidth bottomBorderWidth;
    public JetRptLineWidth leftBorderWidth;
    public JetRptLineWidth rightBorderWidth;
    public JetColor topBorderColor;
    public JetColor bottomBorderColor;
    public JetColor leftBorderColor;
    public JetColor rightBorderColor;
    public JetUnitNumber topMargin;
    public JetUnitNumber bottomMargin;
    public JetUnitNumber leftMargin;
    public JetUnitNumber rightMargin;
    public JetEnumeration alignment;
    private Vector addElement = new Vector();
    private Vector beforeRemoved = new Vector();
    private static HashMap getParent = null;
    private static HashVector getPropGrpsDesc = null;

    public JetRptRectangle() {
        this.addElement();
        this.iNBorderWidth = 0;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.alignment();
    }

    @Override
    public Vector getChildren() {
        return this.addElement;
    }

    @Override
    public void beforeRemoved() {
        int n = this.addElement.size();
        for (int i = 0; i < n; ++i) {
            JetObject jetObject = (JetObject)this.addElement.elementAt(i);
            jetObject.beforeRemoved();
        }
        super.beforeRemoved();
    }

    @Override
    public JetObject remove(JetObject jetObject) {
        jetObject.beforeRemoved();
        jetObject.setParent(null);
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            this.beforeRemoved.removeElement(jetAttachable);
            jetAttachable.setRefObj(null);
        } else {
            this.addElement.removeElement(jetObject);
        }
        return jetObject;
    }

    @Override
    public JetObject add(JetObject jetObject) {
        JetContainable jetContainable = jetObject.getParent();
        if (jetContainable != null) {
            jetContainable.remove(jetObject);
        }
        jetObject.setParent(this);
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            jetAttachable.setRefObj(this);
            this.beforeRemoved.addElement(jetAttachable);
        } else {
            this.addElement.addElement(jetObject);
        }
        return jetObject;
    }

    public JetObject add(JetObject jetObject, int n) {
        jetObject = this.add(jetObject);
        int n2 = this.addElement.size();
        if (n >= 0 && n != n2) {
            this.addElement.removeElementAt(n2 - 1);
            this.addElement.insertElementAt(jetObject, n);
        }
        return jetObject;
    }

    @Override
    public void broadcast(JetObject jetObject, int n) {
    }

    private void addElement() {
        this.topBorderWidth = new JetRptLineWidth(this, "border-top-width", 0);
        this.bottomBorderWidth = new JetRptLineWidth(this, "border-bottom-width", 0);
        this.leftBorderWidth = new JetRptLineWidth(this, "border-left-width", 0);
        this.rightBorderWidth = new JetRptLineWidth(this, "border-right-width", 0);
        this.topBorderColor = new JetColor(this, "border-top-color", Color.black);
        this.bottomBorderColor = new JetColor(this, "border-bottom-color", Color.black);
        this.leftBorderColor = new JetColor(this, "border-left-color", Color.black);
        this.rightBorderColor = new JetColor(this, "border-right-color", Color.black);
        this.topMargin = new JetUnitNumber(this, "margin-top");
        this.bottomMargin = new JetUnitNumber(this, "margin-bottom");
        this.leftMargin = new JetUnitNumber(this, "margin-left");
        this.rightMargin = new JetUnitNumber(this, "margin-right");
        this.alignment = new JetEnumeration(this, "Alignment", 0);
        this.alignment.set(5);
    }

    private void alignment() {
        this.borderWidth.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (getParent == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (getParent == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("border-top-width", n++);
                    hashMap.put("border-bottom-width", n++);
                    hashMap.put("border-left-width", n++);
                    hashMap.put("border-right-width", n++);
                    hashMap.put("border-top-color", n++);
                    hashMap.put("border-bottom-color", n++);
                    hashMap.put("border-left-color", n++);
                    hashMap.put("border-right-color", n++);
                    hashMap.put("margin-top", n++);
                    hashMap.put("margin-bottom", n++);
                    hashMap.put("margin-left", n++);
                    hashMap.put("margin-right", n++);
                    hashMap.put("Alignment", n++);
                    getParent = hashMap;
                }
            }
        }
        return getParent;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (getPropGrpsDesc != null) {
                return getPropGrpsDesc;
            }
            getPropGrpsDesc = JetRptRectangle.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (getPropGrpsDesc == null) {
                getPropGrpsDesc = new HashVector();
            }
            String string = "Padding";
            getPropGrpsDesc.remove(string);
            string = "Border";
            List list = (List)getPropGrpsDesc.get(string);
            list.remove("Shadow");
            list.remove("ShadowColor");
            getPropGrpsDesc.put(string, list);
            string = "Accessibility";
            list = (List)getPropGrpsDesc.get(string);
            list.remove("ExternalID");
            list.remove("ExternalStyle");
            list.remove("Lang");
            getPropGrpsDesc.remove(string);
            getPropGrpsDesc.put(string, list);
            return getPropGrpsDesc;
        }
        return null;
    }
}

