/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import com.jinfonet.resstore.ResourceStore;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.JResource;
import jet.ReportEnv;
import jet.connect.Record;
import jet.controls.JetAttachable;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetMultiSel;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetURLCommand;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JRObjectResult;
import jet.exception.UserException;
import jet.formula.ParamDesc;
import jet.ie.WriterTool;
import jet.report.JRObjectTemplate;
import jet.report.JReportChangeListener;
import jet.report.JReportUtil;
import jet.report.JetRptBreakContainer;
import jet.report.JetRptDataSource;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptFooterPanel;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptHeaderPanel;
import jet.report.JetRptPagePanel;
import jet.report.JetRptSection;
import jet.report.JetRptTOC;
import jet.report.JetTemplateProperty;
import jet.universe.JetUUniverse;
import jet.util.HashVector;
import jet.util.image.ImageProvider;

public class JetRptReportPanel
extends JetRptGroupPanel
implements JetRootable {
    private int COMBO_EDITOR = 65648;
    public String errorMsg = "";
    private Hashtable S = new Hashtable();
    private Hashtable SEDU = new Hashtable();
    boolean bStandAlone = false;
    private int add = 0;
    private boolean addElement = false;
    public JetString universeName;
    public JetTemplateProperty templateName;
    public JetStringList dataDriver;
    public JetString noRecordTip;
    public JetString tplName;
    public JetString groupID;
    public JetString itemID;
    public JetString rootLabel;
    public JetString colWidthList;
    public JetBoolean compressIfNoRecord;
    public JetUnitNumber appletWidth;
    public JetUnitNumber appletHeight;
    public JetBoolean zipResult;
    public JetBoolean horizontal;
    public JetBoolean showSubHeaderFooter;
    public JetNumber recordsPerPage;
    public JetNumber maxPageNumber;
    public JetNumber resultBufferSize;
    public JetNumber excelBufferSize;
    public JetNumber rowsPerSheet;
    public JetNumber key;
    public JetNumber restrict;
    public JetNumber maxRecords;
    public JetBoolean paraListAuto;
    public boolean bNCompressIfNoRecord;
    public boolean bNZipResult;
    public boolean bNHorizontal;
    public boolean bNShowSubHeaderFooter;
    public boolean bFNoRecordTip = false;
    public boolean bFCompressIfNoRecord = false;
    public boolean bFZipResult = false;
    public boolean bFShowSubHeaderFooter = false;
    public boolean bNParaListAuto = true;
    public boolean bFParaListAuto = false;
    public int iNAppletWidth;
    public int iNAppletHeight;
    public int iNRecordsPerPage = -1;
    public int iNMaxPageNumber = -1;
    public int iNResultBufferSize = 4;
    public int iNExcelBufferSize = 1;
    public int iNRowsPerSheet = -1;
    public int iNKey;
    public int iNRestrict;
    public int iNMaxRecords = -1;
    public String sNCatalogName = "";
    public String sNTemplate = "";
    public String sNDataDriver = "";
    public String sNNoRecordTip = "";
    public String sNTplName = "";
    public String sNGroupID = "";
    public String sNItemID = "";
    public String sNRootLabel = "";
    public String sNColWidthList = "";
    public String cFNoRecordTip;
    public String cFCompressIfNoRecord;
    public String cFZipResult;
    public String cFShowSubHeaderFooter;
    public String cFParaListAuto;
    private boolean addPrimByF = false;
    private Hashtable afterInit = new Hashtable();
    private static Hashtable append = new Hashtable();
    public JetStringList stlGroup;
    public JetBoolean fastPass;
    public JetBoolean columned;
    public JetBoolean noTempFile;
    public JetURLCommand beforeRun;
    public JetURLCommand afterRun;
    public JetURLCommand afterInitParameter;
    public JetURLCommand importParamValues;
    public JetColor background;
    public JetBoolean nationalLanguageSupport;
    protected JetVector sortParameter;
    public JetBoolean isOlap;
    public JetMultiSel fontNamess;
    public JetString importJavaScript;
    private static HashMap beforeSave;
    private static final HashVector buildKeyRect;
    private JetRptDataSource clear = null;
    private int clearMem = 2;
    public static final int PAINT = 0;
    public static final int RECREATE_DATASTREAM = 1;
    public static final int RELOAD_DATASOURCE = 2;
    public static final int DATASOURCE_ERROR = 4;
    public static final String PRINT = "print";
    public static final String PREVIEW = "preview";
    public static final String VIEWER = "viewer";
    public static final String PAGING = "paging";
    public static final String DATABUFFER = "databuffer";
    public static final String FETCHENGINE = "fetchengine";
    private JetRptPagePanel close = null;
    Vector changeListeners = new Vector();
    static Vector styles;
    private Vector convertPixelToUnit = new Vector(3);

    public JetRptReportPanel() {
        this.add();
        this.primProSize = (short)(this.primProSize + 21);
        this.bNCompressIfNoRecord = false;
        this.sNNoRecordTip = "There is no record fetched.";
        this.sNTemplate = "Normal";
        this.sNRootLabel = "Report";
        this.iNAppletWidth = Unit.convertPixelToUnit(500);
        this.iNAppletHeight = Unit.convertPixelToUnit(300);
    }

    @Override
    public Hashtable getPrimProp() {
        if (!this.addPrimByF) {
            this.addPrimByF = true;
            this.afterInit = super.getPrimProp();
            this.afterInit.put("CatalogName", 125);
            this.afterInit.put("Template", 141);
            this.afterInit.put("DataDriver", 126);
            this.afterInit.put("NoRecordTip", 127);
            this.afterInit.put("tplName", 128);
            this.afterInit.put("groupID", 129);
            this.afterInit.put("itemID", 130);
            this.afterInit.put("CompressIfNoRecord", 131);
            this.afterInit.put("ZipResult", 132);
            this.afterInit.put("Horizontal", 133);
            this.afterInit.put("ShowSubHeaderFooter", 134);
            this.afterInit.put("AppletWidth", 135);
            this.afterInit.put("AppletHeight", 136);
            this.afterInit.put("RecordsPerPage", 79);
            this.afterInit.put("MaxPageNumber", 80);
            this.afterInit.put("ResultBufferSize", 137);
            this.afterInit.put("ExcelBufferSize", 137);
            this.afterInit.put("RowsPerSheet", 150);
            this.afterInit.put("key", 138);
            this.afterInit.put("restrict", 139);
            this.afterInit.put("MaxRecords", 140);
            this.afterInit.put("ParaListAuto", 142);
        }
        return this.afterInit;
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.addElement();
    }

    @Override
    public void toPrimitive(String string) {
        if (this.paraListAuto != null) {
            boolean bl = false;
            String string2 = null;
            int n = 0;
            Integer n2 = (Integer)append.get(string);
            if (n2 == null) {
                super.toPrimitive(string);
                return;
            }
            n = n2;
            switch (n) {
                case 125: {
                    this.sNCatalogName = this.universeName.get();
                    bl = true;
                    break;
                }
                case 126: {
                    this.sNDataDriver = this.dataDriver.get();
                    bl = true;
                    break;
                }
                case 127: {
                    this.sNNoRecordTip = this.noRecordTip.get();
                    this.cFNoRecordTip = (String)this.noRecordTip.getRuntimeChangeBy();
                    boolean bl2 = this.bFNoRecordTip = this.cFNoRecordTip != null;
                    if (this.bFNoRecordTip) {
                        string2 = this.cFNoRecordTip;
                    }
                    bl = true;
                    break;
                }
                case 128: {
                    this.sNTplName = this.tplName.get();
                    bl = true;
                    break;
                }
                case 129: {
                    this.sNGroupID = this.groupID.get();
                    bl = true;
                    break;
                }
                case 130: {
                    this.sNItemID = this.itemID.get();
                    bl = true;
                    break;
                }
                case 131: {
                    this.bNCompressIfNoRecord = this.compressIfNoRecord.get();
                    this.cFCompressIfNoRecord = (String)this.compressIfNoRecord.getRuntimeChangeBy();
                    boolean bl3 = this.bFCompressIfNoRecord = this.cFCompressIfNoRecord != null;
                    if (this.bFCompressIfNoRecord) {
                        string2 = this.cFCompressIfNoRecord;
                    }
                    bl = true;
                    break;
                }
                case 132: {
                    this.bNZipResult = this.zipResult.get();
                    this.cFZipResult = (String)this.zipResult.getRuntimeChangeBy();
                    boolean bl4 = this.bFZipResult = this.cFZipResult != null;
                    if (this.bFZipResult) {
                        string2 = this.cFZipResult;
                    }
                    bl = true;
                    break;
                }
                case 133: {
                    this.bNHorizontal = this.horizontal.get();
                    bl = true;
                    break;
                }
                case 134: {
                    this.bNShowSubHeaderFooter = this.showSubHeaderFooter.get();
                    this.cFShowSubHeaderFooter = (String)this.showSubHeaderFooter.getRuntimeChangeBy();
                    boolean bl5 = this.bFShowSubHeaderFooter = this.cFZipResult != null;
                    if (this.bFShowSubHeaderFooter) {
                        string2 = this.cFShowSubHeaderFooter;
                    }
                    bl = true;
                    break;
                }
                case 135: {
                    this.iNAppletWidth = this.appletWidth.getUnit();
                    bl = true;
                    break;
                }
                case 136: {
                    this.iNAppletHeight = this.appletHeight.getUnit();
                    bl = true;
                    break;
                }
                case 137: {
                    this.iNResultBufferSize = this.resultBufferSize.get();
                    bl = true;
                    break;
                }
                case 147: {
                    this.iNExcelBufferSize = this.excelBufferSize.get();
                    bl = true;
                    break;
                }
                case 150: {
                    this.iNRowsPerSheet = this.rowsPerSheet.get();
                    bl = true;
                    break;
                }
                case 138: {
                    this.iNKey = this.key.get();
                    bl = true;
                    break;
                }
                case 139: {
                    this.iNRestrict = this.restrict.get();
                    bl = true;
                    break;
                }
                case 140: {
                    this.iNMaxRecords = this.maxRecords.get();
                    bl = true;
                    break;
                }
                case 141: {
                    this.sNTemplate = this.templateName.get();
                    bl = true;
                    break;
                }
                case 142: {
                    this.bNParaListAuto = this.paraListAuto.get();
                    bl = true;
                    break;
                }
                case 79: {
                    this.iNRecordsPerPage = this.recordsPerPage.get();
                    bl = true;
                    break;
                }
                case 80: {
                    this.iNMaxPageNumber = this.maxPageNumber.get();
                    bl = true;
                    break;
                }
                case 153: {
                    this.sNColWidthList = this.colWidthList.get();
                    bl = true;
                    break;
                }
            }
            if (string2 != null) {
                this.addPrimByF(string2, n);
            }
        }
    }

    public static void changeTemplateEditor(Vector vector) {
        JetTemplateProperty.templates = vector;
    }

    @Override
    public void setNamingTable(Hashtable hashtable) {
        this.S = hashtable;
    }

    @Override
    public Hashtable getNamingTable() {
        return this.S;
    }

    @Override
    public void setNamingCount(Hashtable hashtable) {
        this.SEDU = hashtable;
    }

    @Override
    public Hashtable getNamingCount() {
        if (this.SEDU == null) {
            this.SEDU = new Hashtable();
        }
        return this.SEDU;
    }

    @Override
    public JetObject add(JetObject jetObject) {
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            this.convertPixelToUnit.addElement(jetAttachable);
            jetAttachable.setRefObj(this);
            jetObject.setParent(this);
            return jetObject;
        }
        JetObject jetObject2 = super.add(jetObject);
        if (jetObject instanceof JetRptPagePanel) {
            this.close = (JetRptPagePanel)jetObject;
            this.close.setOrientation(this.bNHorizontal);
        } else if (jetObject instanceof JetRptDataSource) {
            this.clear = (JetRptDataSource)jetObject;
            Vector vector = this.getChildren();
            vector.removeElement(jetObject2);
            vector.insertElementAt(jetObject2, 0);
        }
        if (this.bEditable && jetObject instanceof JetRptSection) {
            ((JetRptSection)jetObject).width.setEditFlag(this.horizontal.get() ? 2 : 0);
            ((JetRptSection)jetObject).height.setEditFlag(this.horizontal.get() ? 0 : 2);
        }
        return jetObject2;
    }

    @Override
    public JetObject remove(JetObject jetObject) {
        jetObject.setParent(null);
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            this.convertPixelToUnit.removeElement(jetAttachable);
            jetAttachable.setRefObj(null);
        } else {
            this.children.removeElement(jetObject);
        }
        if (jetObject instanceof JRObjectTemplate) {
            // empty if block
        }
        return jetObject;
    }

    @Override
    public String getInstancePrefix() {
        return "Report";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("Report");
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.COMBO_EDITOR = 65648;
        if (this.getTOC() == null) {
            JetRptTOC jetRptTOC = new JetRptTOC();
            jetRptTOC.setEditable();
            this.add(jetRptTOC, 1);
        }
    }

    public void setStandAlone(boolean bl) {
        this.bStandAlone = bl;
    }

    public boolean isStandAlone() {
        return this.bStandAlone;
    }

    private final int[] COMBO_EDITOR(boolean bl) {
        String string = this.getInstName();
        String string2 = ReportEnv.getuid();
        return JReportUtil.buildKeyRect(string, bl, string2);
    }

    public boolean ie() {
        return this.COMBO_EDITOR(false)[0] != this.iNKey;
    }

    public boolean ir() {
        return this.COMBO_EDITOR(false)[1] != this.iNRestrict;
    }

    public boolean ieir() {
        int[] nArray = this.COMBO_EDITOR(false);
        return nArray[0] == this.iNKey && nArray[1] != this.iNRestrict && nArray[2] != this.iNRestrict;
    }

    public void beforeSave() {
        this.beforeSave(null, null);
    }

    public void beforeSave(JetUUniverse jetUUniverse, ResourceStore resourceStore) {
        int[] nArray = null;
        nArray = this.COMBO_EDITOR(ReportEnv.ie());
        if (this.key != null) {
            this.key.set(nArray[0]);
        }
        if (this.restrict != null) {
            this.restrict.set(nArray[1]);
        }
        this.iNKey = nArray[0];
        this.iNRestrict = nArray[1];
    }

    @Override
    public void clearMem() {
        this.fullDestory();
    }

    @Override
    public void destory() {
        super.destory();
        this.S.clear();
        this.SEDU.clear();
    }

    @Override
    public synchronized int getRefCount() {
        return this.add;
    }

    @Override
    public synchronized void refer() {
        ++this.add;
    }

    @Override
    public synchronized void free() {
        if (this.add > 0) {
            --this.add;
        }
        if (!this.bStandAlone && !this.addElement && this.add == 0) {
            this.clearMem();
        }
    }

    @Override
    public void setCached(boolean bl) {
        this.addElement = bl;
    }

    @Override
    public boolean isCached() {
        return this.addElement;
    }

    public String getCatalogName() {
        return this.sNCatalogName;
    }

    public String getCatalogName(JRObjectResult jRObjectResult) {
        return this.sNCatalogName;
    }

    public String getTemplate(JRObjectResult jRObjectResult) {
        return this.sNTemplate;
    }

    public String getDataDriver(JRObjectResult jRObjectResult) {
        return this.sNDataDriver;
    }

    public String getNoRecordTip(JRObjectResult jRObjectResult) {
        if (!this.bFNoRecordTip) {
            return this.sNNoRecordTip;
        }
        return jRObjectResult.getString(this.cFNoRecordTip, this.sNNoRecordTip);
    }

    public String getTplName(JRObjectResult jRObjectResult) {
        return this.sNTplName;
    }

    public String getGroupID(JRObjectResult jRObjectResult) {
        return this.sNGroupID;
    }

    public String getItemID(JRObjectResult jRObjectResult) {
        return this.sNItemID;
    }

    public String getRootLabel(JRObjectResult jRObjectResult) {
        return this.sNRootLabel;
    }

    public String getColWidthList(JRObjectResult jRObjectResult) {
        return this.sNColWidthList;
    }

    public boolean getCompressIfNoRecord(JRObjectResult jRObjectResult) {
        if (!this.bFCompressIfNoRecord) {
            return this.bNCompressIfNoRecord;
        }
        return jRObjectResult.getBoolean(this.cFCompressIfNoRecord, this.bNCompressIfNoRecord);
    }

    public boolean getZipResult(JRObjectResult jRObjectResult) {
        if (!this.bFZipResult) {
            return this.bNZipResult;
        }
        return jRObjectResult.getBoolean(this.cFZipResult, this.bNZipResult);
    }

    public boolean getHorizontal(JRObjectResult jRObjectResult) {
        return this.bNHorizontal;
    }

    public boolean getShowSubHeaderFooter(JRObjectResult jRObjectResult) {
        if (!this.bFShowSubHeaderFooter) {
            return this.bNShowSubHeaderFooter;
        }
        return jRObjectResult.getBoolean(this.cFShowSubHeaderFooter, this.bNShowSubHeaderFooter);
    }

    public int getAppletWidth(JRObjectResult jRObjectResult) {
        return this.iNAppletWidth;
    }

    public int getAppletHeight(JRObjectResult jRObjectResult) {
        return this.iNAppletHeight;
    }

    @Override
    public int getRecordsPerPage(JRObjectResult jRObjectResult) {
        return this.iNRecordsPerPage;
    }

    @Override
    public int getMaxPageNumber(JRObjectResult jRObjectResult) {
        return this.iNMaxPageNumber;
    }

    public int getResultBufferSize(JRObjectResult jRObjectResult) {
        return this.iNResultBufferSize;
    }

    public int getExcelBufferSize(JRObjectResult jRObjectResult) {
        return this.iNExcelBufferSize;
    }

    public int getRowsPerSheet(JRObjectResult jRObjectResult) {
        return this.iNRowsPerSheet;
    }

    public int getKey(JRObjectResult jRObjectResult) {
        return this.iNKey;
    }

    public int getRestrict(JRObjectResult jRObjectResult) {
        return this.iNRestrict;
    }

    public int getMaxRecords(JRObjectResult jRObjectResult) {
        return this.iNMaxRecords;
    }

    public boolean getParaListAuto(JRObjectResult jRObjectResult) {
        if (!this.bFParaListAuto) {
            return this.bNParaListAuto;
        }
        return jRObjectResult.getBoolean(this.cFParaListAuto, this.bNParaListAuto);
    }

    public String getNoRecordTip(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFNoRecordTip) {
            return this.sNNoRecordTip;
        }
        return jRObjectResult.getString(this.cFNoRecordTip, record, this.sNNoRecordTip);
    }

    public boolean getCompressIfNoRecord(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFCompressIfNoRecord) {
            return this.bNCompressIfNoRecord;
        }
        return jRObjectResult.getBoolean(this.cFCompressIfNoRecord, record, this.bNCompressIfNoRecord);
    }

    public boolean getZipResult(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFZipResult) {
            return this.bNZipResult;
        }
        return jRObjectResult.getBoolean(this.cFZipResult, record, this.bNZipResult);
    }

    public boolean getShowSubHeaderFooter(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFShowSubHeaderFooter) {
            return this.bNShowSubHeaderFooter;
        }
        return jRObjectResult.getBoolean(this.cFShowSubHeaderFooter, record, this.bNShowSubHeaderFooter);
    }

    public boolean getParaListAuto(JRObjectResult jRObjectResult, Record record) {
        if (!this.bFParaListAuto) {
            return this.bNParaListAuto;
        }
        return jRObjectResult.getBoolean(this.cFParaListAuto, record, this.bNParaListAuto);
    }

    @Override
    public void setInt(String string, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        Integer n4 = (Integer)append.get(string);
        if (n4 != null) {
            n3 = n4;
        } else {
            super.setInt(string, n, n2);
        }
        switch (n3) {
            case 131: {
                this.bNCompressIfNoRecord = n != 0;
                bl = true;
                break;
            }
            case 132: {
                this.bNZipResult = n != 0;
                bl = true;
                break;
            }
            case 133: {
                this.bNHorizontal = n != 0;
                bl = true;
                break;
            }
            case 134: {
                this.bNShowSubHeaderFooter = n != 0;
                bl = true;
                break;
            }
            case 135: {
                this.iNAppletWidth = Unit.upgrade(n, n2, false);
                bl = true;
                break;
            }
            case 136: {
                this.iNAppletHeight = Unit.upgrade(n, n2, false);
                bl = true;
                break;
            }
            case 79: {
                this.iNRecordsPerPage = n;
                bl = true;
                break;
            }
            case 80: {
                this.iNMaxPageNumber = n;
                bl = true;
                break;
            }
            case 137: {
                this.iNResultBufferSize = n;
                bl = true;
                break;
            }
            case 147: {
                this.iNExcelBufferSize = n;
                bl = true;
                break;
            }
            case 150: {
                this.iNRowsPerSheet = n;
                bl = true;
                break;
            }
            case 138: {
                this.iNKey = n;
                bl = true;
                break;
            }
            case 139: {
                this.iNRestrict = n;
                bl = true;
                break;
            }
            case 140: {
                this.iNMaxRecords = n;
                bl = true;
                break;
            }
            case 142: {
                this.bNParaListAuto = n != 0;
                bl = true;
                break;
            }
        }
        if (!bl) {
            super.setInt(string, n, n2);
        }
    }

    @Override
    public void setPrimUnit(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)append.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setPrimUnit(string, string2);
        }
        switch (n) {
            case 125: {
                this.sNCatalogName = string2;
                bl = true;
                break;
            }
            case 141: {
                this.sNTemplate = string2;
                bl = true;
                break;
            }
            case 126: {
                this.sNDataDriver = string2;
                bl = true;
                break;
            }
            case 127: {
                this.sNNoRecordTip = string2;
                bl = true;
                break;
            }
            case 128: {
                this.sNTplName = string2;
                bl = true;
                break;
            }
            case 129: {
                this.sNGroupID = string2;
                bl = true;
                break;
            }
            case 130: {
                this.sNItemID = string2;
                bl = true;
                break;
            }
            case 146: {
                this.sNRootLabel = string2;
                bl = true;
                break;
            }
            case 153: {
                this.sNColWidthList = string2;
                bl = true;
                break;
            }
        }
        if (!bl) {
            super.setPrimUnit(string, string2);
        }
    }

    @Override
    public void setChangeBy(String string, String string2) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)append.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            super.setChangeBy(string, string2);
        }
        switch (n) {
            case 127: {
                this.bFNoRecordTip = true;
                this.cFNoRecordTip = string2;
                bl = true;
                break;
            }
            case 131: {
                this.bFCompressIfNoRecord = true;
                this.cFCompressIfNoRecord = string2;
                bl = true;
                break;
            }
            case 132: {
                this.bFZipResult = true;
                this.cFZipResult = string2;
                bl = true;
                break;
            }
            case 134: {
                this.bFShowSubHeaderFooter = true;
                this.cFShowSubHeaderFooter = string2;
                bl = true;
                break;
            }
            case 142: {
                this.bFParaListAuto = true;
                this.cFParaListAuto = string2;
                bl = true;
                break;
            }
        }
        if (!bl) {
            super.setChangeBy(string, string2);
        } else {
            this.addPrimByF(string2, n);
        }
    }

    @Override
    public short writePrim(short s, HashVector hashVector, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        s = super.writePrim(s, hashVector, dataOutput, imageProvider);
        Short s2 = (Short)hashVector.get("CatalogName");
        if (s2 == null) {
            short s3 = s;
            s = (short)(s + 1);
            s2 = s3;
            hashVector.put("CatalogName", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNCatalogName, null, dataOutput);
        s2 = (Short)hashVector.get("Template");
        if (s2 == null) {
            short s4 = s;
            s = (short)(s + 1);
            s2 = s4;
            hashVector.put("Template", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNTemplate, null, dataOutput);
        s2 = (Short)hashVector.get("DataDriver");
        if (s2 == null) {
            short s5 = s;
            s = (short)(s + 1);
            s2 = s5;
            hashVector.put("DataDriver", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNDataDriver, null, dataOutput);
        s2 = (Short)hashVector.get("NoRecordTip");
        if (s2 == null) {
            short s6 = s;
            s = (short)(s + 1);
            s2 = s6;
            hashVector.put("NoRecordTip", s2);
        }
        WriterTool.writePrimString(s2, this.bFNoRecordTip, this.sNNoRecordTip, this.cFNoRecordTip, dataOutput);
        s2 = (Short)hashVector.get("tplName");
        if (s2 == null) {
            short s7 = s;
            s = (short)(s + 1);
            s2 = s7;
            hashVector.put("tplName", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNTplName, null, dataOutput);
        s2 = (Short)hashVector.get("groupID");
        if (s2 == null) {
            short s8 = s;
            s = (short)(s + 1);
            s2 = s8;
            hashVector.put("groupID", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNGroupID, null, dataOutput);
        s2 = (Short)hashVector.get("itemID");
        if (s2 == null) {
            short s9 = s;
            s = (short)(s + 1);
            s2 = s9;
            hashVector.put("itemID", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNItemID, null, dataOutput);
        s2 = (Short)hashVector.get("rootLabel");
        if (s2 == null) {
            short s10 = s;
            s = (short)(s + 1);
            s2 = s10;
            hashVector.put("rootLabel", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNRootLabel, null, dataOutput);
        s2 = (Short)hashVector.get("CompressIfNoRecord");
        if (s2 == null) {
            short s11 = s;
            s = (short)(s + 1);
            s2 = s11;
            hashVector.put("CompressIfNoRecord", s2);
        }
        WriterTool.writePrimBool(s2, this.bFCompressIfNoRecord, this.bNCompressIfNoRecord, this.cFCompressIfNoRecord, dataOutput);
        s2 = (Short)hashVector.get("ZipResult");
        if (s2 == null) {
            short s12 = s;
            s = (short)(s + 1);
            s2 = s12;
            hashVector.put("ZipResult", s2);
        }
        WriterTool.writePrimBool(s2, this.bFZipResult, this.bNZipResult, this.cFZipResult, dataOutput);
        s2 = (Short)hashVector.get("Horizontal");
        if (s2 == null) {
            short s13 = s;
            s = (short)(s + 1);
            s2 = s13;
            hashVector.put("Horizontal", s2);
        }
        WriterTool.writePrimBool(s2, false, this.bNHorizontal, null, dataOutput);
        s2 = (Short)hashVector.get("ShowSubHeaderFooter");
        if (s2 == null) {
            short s14 = s;
            s = (short)(s + 1);
            s2 = s14;
            hashVector.put("ShowSubHeaderFooter", s2);
        }
        WriterTool.writePrimBool(s2, this.bFShowSubHeaderFooter, this.bNShowSubHeaderFooter, this.cFShowSubHeaderFooter, dataOutput);
        s2 = (Short)hashVector.get("AppletWidth");
        if (s2 == null) {
            short s15 = s;
            s = (short)(s + 1);
            s2 = s15;
            hashVector.put("AppletWidth", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNAppletWidth, null, dataOutput, 4);
        s2 = (Short)hashVector.get("AppletHeight");
        if (s2 == null) {
            short s16 = s;
            s = (short)(s + 1);
            s2 = s16;
            hashVector.put("AppletHeight", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNAppletHeight, null, dataOutput, 4);
        s2 = (Short)hashVector.get("RecordsPerPage");
        if (s2 == null) {
            short s17 = s;
            s = (short)(s + 1);
            s2 = s17;
            hashVector.put("RecordsPerPage", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNRecordsPerPage, null, dataOutput, 5);
        s2 = (Short)hashVector.get("MaxPageNumber");
        if (s2 == null) {
            short s18 = s;
            s = (short)(s + 1);
            s2 = s18;
            hashVector.put("MaxPageNumber", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNMaxPageNumber, null, dataOutput, 5);
        s2 = (Short)hashVector.get("ResultBufferSize");
        if (s2 == null) {
            short s19 = s;
            s = (short)(s + 1);
            s2 = s19;
            hashVector.put("ResultBufferSize", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNResultBufferSize, null, dataOutput, 5);
        s2 = (Short)hashVector.get("ExcelBufferSize");
        if (s2 == null) {
            short s20 = s;
            s = (short)(s + 1);
            s2 = s20;
            hashVector.put("ExcelBufferSize", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNExcelBufferSize, null, dataOutput, 5);
        s2 = (Short)hashVector.get("RowsPerSheet");
        if (s2 == null) {
            short s21 = s;
            s = (short)(s + 1);
            s2 = s21;
            hashVector.put("RowsPerSheet", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNRowsPerSheet, null, dataOutput, 5);
        s2 = (Short)hashVector.get("ColumnWidthList");
        if (s2 == null) {
            short s22 = s;
            s = (short)(s + 1);
            s2 = s22;
            hashVector.put("ColumnWidthList", s2);
        }
        WriterTool.writePrimString(s2, false, this.sNColWidthList, null, dataOutput);
        s2 = (Short)hashVector.get("key");
        if (s2 == null) {
            short s23 = s;
            s = (short)(s + 1);
            s2 = s23;
            hashVector.put("key", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNKey, null, dataOutput, 5);
        s2 = (Short)hashVector.get("restrict");
        if (s2 == null) {
            short s24 = s;
            s = (short)(s + 1);
            s2 = s24;
            hashVector.put("restrict", s2);
        }
        WriterTool.writePrimUnit(s2, false, this.iNRestrict, null, dataOutput, 5);
        s2 = (Short)hashVector.get("ParaListAuto");
        if (s2 == null) {
            short s25 = s;
            s = (short)(s + 1);
            s2 = s25;
            hashVector.put("ParaListAuto", s2);
        }
        WriterTool.writePrimBool(s2, this.bFParaListAuto, this.bNParaListAuto, this.cFParaListAuto, dataOutput);
        return s;
    }

    @Override
    public void setVersion(int n) {
        this.COMBO_EDITOR = n;
    }

    @Override
    public int getVersion() {
        return this.COMBO_EDITOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (beforeSave == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (beforeSave == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("StyleGroup", n++);
                    hashMap.put("RecordsPerPage", n++);
                    hashMap.put("restrict", n++);
                    hashMap.put("AfterInitParameter", n++);
                    hashMap.put("BeforeRun", n++);
                    hashMap.put("Columned", n++);
                    hashMap.put("Template", n++);
                    hashMap.put("NoRecordTip", n++);
                    hashMap.put("Horizontal", n++);
                    hashMap.put("AppletWidth", n++);
                    hashMap.put("FastPass", n++);
                    hashMap.put("itemID", n++);
                    hashMap.put("AfterRun", n++);
                    hashMap.put("CompressIfNoRecord", n++);
                    hashMap.put("CatalogName", n++);
                    hashMap.put("ZipResult", n++);
                    hashMap.put("RowsPerSheet", n++);
                    hashMap.put("ImportJavaScript", n++);
                    hashMap.put("MaxPageNumber", n++);
                    hashMap.put("EmbeddedFonts", n++);
                    hashMap.put("ExcelBufferSize", n++);
                    hashMap.put("PageBackground", n++);
                    hashMap.put("tplName", n++);
                    hashMap.put("MaxRecords", n++);
                    hashMap.put("Olap", n++);
                    hashMap.put("ImportParamValues", n++);
                    hashMap.put("key", n++);
                    hashMap.put("ColumnWidthList", n++);
                    hashMap.put("groupID", n++);
                    hashMap.put("RootLabel", n++);
                    hashMap.put("AppletHeight", n++);
                    hashMap.put("NoTempFile", n++);
                    hashMap.put("ParaListAuto", n++);
                    hashMap.put("DataDriver", n++);
                    hashMap.put("SortParameter", n++);
                    hashMap.put("ShowSubHeaderFooter", n++);
                    hashMap.put("nationalLanguageSupport", n++);
                    hashMap.put("ResultBufferSize", n++);
                    beforeSave = hashMap;
                }
            }
        }
        return beforeSave;
    }

    private void add() {
        this.stlGroup = new JetStringList(this, "StyleGroup");
        this.fastPass = new JetBoolean(this, "FastPass");
        this.columned = new JetBoolean(this, "Columned");
        this.noTempFile = new JetBoolean(this, "NoTempFile", false);
        this.beforeRun = new JetURLCommand(this, "BeforeRun");
        this.afterRun = new JetURLCommand(this, "AfterRun");
        this.afterInitParameter = new JetURLCommand(this, "AfterInitParameter");
        this.background = new JetColor(this, "PageBackground", Color.white, true);
        this.nationalLanguageSupport = new JetBoolean(this, "nationalLanguageSupport", true);
        this.sortParameter = new JetVector(this, "SortParameter");
        this.importParamValues = new JetURLCommand(this, "ImportParamValues");
        this.isOlap = new JetBoolean(this, "Olap", false);
        this.fontNamess = new JetMultiSel(this, "EmbeddedFonts");
        this.importJavaScript = new JetString(this, "ImportJavaScript");
    }

    private void addElement() {
        this.universeName = new JetString(this, "CatalogName");
        this.templateName = new JetTemplateProperty(this, "Template");
        this.dataDriver = new JetStringList(this, "DataDriver");
        this.noRecordTip = new JetString(this, "NoRecordTip");
        this.tplName = new JetString(this, "tplName");
        this.groupID = new JetString(this, "groupID");
        this.itemID = new JetString(this, "itemID");
        this.compressIfNoRecord = new JetBoolean(this, "CompressIfNoRecord");
        this.appletWidth = new JetUnitNumber(this, "AppletWidth");
        this.appletHeight = new JetUnitNumber(this, "AppletHeight");
        this.zipResult = new JetBoolean(this, "ZipResult");
        this.horizontal = new JetBoolean(this, "Horizontal");
        this.showSubHeaderFooter = new JetBoolean(this, "ShowSubHeaderFooter");
        this.recordsPerPage = new JetNumber(this, "RecordsPerPage", -1);
        this.maxPageNumber = new JetNumber(this, "MaxPageNumber", -1);
        this.resultBufferSize = new JetNumber(this, "ResultBufferSize", 4);
        this.excelBufferSize = new JetNumber(this, "ExcelBufferSize", 1);
        this.rowsPerSheet = new JetNumber(this, "RowsPerSheet", -1);
        this.key = new JetNumber(this, "key");
        this.restrict = new JetNumber(this, "restrict");
        this.maxRecords = new JetNumber(this, "MaxRecords", -1);
        this.paraListAuto = new JetBoolean(this, "ParaListAuto", true);
        this.colWidthList = new JetString(this, "ColumnWidthList");
        this.rootLabel = new JetString(this, "RootLabel", "Report");
        this.templateName.setEditorType(JetProperty.COMBO_EDITOR);
        this.dataDriver.setCanChangeByOthers(false);
        this.recordsPerPage.setCanChangeByOthers(false);
        this.maxPageNumber.setCanChangeByOthers(false);
        this.resultBufferSize.setCanChangeByOthers(false);
        this.maxRecords.setTransient(true);
        this.noRecordTip.set("There is no record fetched.");
        this.templateName.set("Normal");
        this.appletWidth.set(500);
        this.appletHeight.set(300);
        this.stlGroup.setCanChangeByOthers(false);
        this.fastPass.setCanChangeByOthers(false);
        this.columned.setCanChangeByOthers(false);
        this.noTempFile.setCanChangeByOthers(false);
        this.importJavaScript.setCanChangeByOthers(false);
        this.beforeRun.setCanChangeByOthers(false);
        this.afterRun.setCanChangeByOthers(false);
        this.afterInitParameter.setCanChangeByOthers(false);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return buildKeyRect;
        }
        return null;
    }

    public JetRptDataSource getDataSource(Object object) {
        return this.clear;
    }

    public JetRptPagePanel getPage(Object object) {
        return this.close;
    }

    public Vector getGroupPanels(Object object) {
        Vector<JetRptGroupPanel> vector = new Vector<JetRptGroupPanel>();
        Enumeration enumeration = this.close.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof JetRptGroupPanel)) continue;
            vector.addElement((JetRptGroupPanel)e);
            enumeration = ((JetRptGroupPanel)e).getChildren().elements();
        }
        return vector;
    }

    public Vector getBodyObjects(Object object) {
        Vector<JetRptGeometryObject> vector = new Vector<JetRptGeometryObject>();
        Vector vector2 = this.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (!(e instanceof JetRptGeometryObject)) continue;
            vector.addElement((JetRptGeometryObject)e);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveParamDesc(Object object, String string) throws IOException, UserException {
        Hashtable hashtable = this.clear.prepareParameter(object, true);
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            printWriter = new PrintWriter(fileOutputStream);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
                printWriter.println("Name:" + paramDesc.name);
                printWriter.println("PromptText:" + paramDesc.promptText);
                printWriter.println("Type:" + paramDesc.type);
                printWriter.println("Value:" + paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
            }
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    printWriter = null;
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    fileOutputStream = null;
                }
            }
        }
        return true;
    }

    public Vector getQueryCompnents(Object object) {
        Vector vector = new Vector();
        Vector vector2 = this.getSections(object);
        for (int i = 0; i < vector2.size(); ++i) {
            Vector vector3 = ((JetRptSection)vector2.elementAt(i)).getQueryCompoents(object);
            for (int j = 0; j < vector3.size(); ++j) {
                vector.addElement(vector3.elementAt(j));
            }
        }
        return vector;
    }

    public Vector getSections(Object object) {
        Vector vector = new Vector();
        JetRptReportPanel.addPrimByF(this, vector);
        return vector;
    }

    private static void addPrimByF(JetRptBreakContainer jetRptBreakContainer, Vector vector) {
        int n;
        Vector vector2 = jetRptBreakContainer.getChildren();
        Object e = null;
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            e = vector2.elementAt(n);
            if (!(e instanceof JetRptHeaderPanel)) continue;
            vector.addElement(e);
        }
        for (n = 0; n < n2; ++n) {
            e = vector2.elementAt(n);
            if (e instanceof JetRptBreakContainer) {
                JetRptReportPanel.addPrimByF((JetRptBreakContainer)e, vector);
                continue;
            }
            if (!(e instanceof JetRptDetailPanel)) continue;
            vector.addElement(e);
        }
        for (n = 0; n < n2; ++n) {
            e = vector2.elementAt(n);
            if (!(e instanceof JetRptFooterPanel)) continue;
            vector.addElement(e);
        }
    }

    public void setLevel(Object object, int n) throws UserException {
        if (n == 2) {
            if (this.clear != null) {
                this.clear.prepareDataSource(object);
            }
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                JReportChangeListener jReportChangeListener = (JReportChangeListener)this.changeListeners.elementAt(i);
                jReportChangeListener.reportChanged(this);
            }
        }
        this.afterInit(n);
    }

    private void afterInit(int n) {
        this.clearMem |= n;
    }

    public Vector getGroupbys(Object object) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.afterInitParameter();
        for (int i = 0; i < vector2.size(); ++i) {
            JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)vector2.elementAt(i);
            String string = jetRptGroupPanel.sNGroupBy;
            vector.add(string);
        }
        return vector;
    }

    private Vector afterInitParameter() {
        Vector<JetRptGroupPanel> vector = new Vector<JetRptGroupPanel>();
        Vector vector2 = this.close.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (!(e instanceof JetRptGroupPanel)) continue;
            vector.addElement((JetRptGroupPanel)e);
            this.afterRun((JetRptGroupPanel)e, vector);
        }
        return vector;
    }

    private void afterRun(JetRptGroupPanel jetRptGroupPanel, Vector vector) {
        Vector vector2 = jetRptGroupPanel.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (!(e instanceof JetRptGroupPanel)) continue;
            vector.addElement((JetRptGroupPanel)e);
            this.afterRun((JetRptGroupPanel)e, vector);
        }
    }

    public static JetRptReportPanel getReportPanel(Object object, JetObject jetObject) {
        for (JetObject jetObject2 = jetObject; jetObject2 != null; jetObject2 = (JetObject)((Object)jetObject2.getParent())) {
            if (!(jetObject2 instanceof JetRptReportPanel)) continue;
            jetObject = jetObject2;
            break;
        }
        if (!(jetObject instanceof JetRptReportPanel)) {
            return null;
        }
        return (JetRptReportPanel)jetObject;
    }

    public void addChangeListener(JReportChangeListener jReportChangeListener) {
        this.changeListeners.addElement(jReportChangeListener);
    }

    public void removeChangeListener(JReportChangeListener jReportChangeListener) {
        this.changeListeners.removeElement(jReportChangeListener);
    }

    public void changeStyleEditor(Vector vector) {
        styles.removeAllElements();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            styles.addElement(string);
        }
    }

    public Vector getJetGuidelines() {
        return this.convertPixelToUnit;
    }

    public JetRptTOC getTOC() {
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptTOC)) continue;
            return (JetRptTOC)e;
        }
        return null;
    }

    static {
        append.put("CatalogName", 125);
        append.put("Template", 141);
        append.put("DataDriver", 126);
        append.put("NoRecordTip", 127);
        append.put("tplName", 128);
        append.put("groupID", 129);
        append.put("itemID", 130);
        append.put("rootLabel", 146);
        append.put("CompressIfNoRecord", 131);
        append.put("ZipResult", 132);
        append.put("Horizontal", 133);
        append.put("ShowSubHeaderFooter", 134);
        append.put("AppletWidth", 135);
        append.put("AppletHeight", 136);
        append.put("RecordsPerPage", 79);
        append.put("MaxPageNumber", 80);
        append.put("ResultBufferSize", 137);
        append.put("ExcelBufferSize", 147);
        append.put("RowsPerSheet", 150);
        append.put("ColumnWidthList", 153);
        append.put("key", 138);
        append.put("restrict", 139);
        append.put("MaxRecords", 140);
        append.put("ParaListAuto", 142);
        beforeSave = null;
        buildKeyRect = new HashVector(5);
        String string = null;
        Vector<String> vector = null;
        string = "DataBuffer";
        vector = new Vector<String>(2);
        vector.add("RecordsPerPage");
        vector.add("MaxPageNumber");
        buildKeyRect.put(string, vector);
        string = "ResultBuffer";
        vector = new Vector(1);
        vector.add("ResultBufferSize");
        buildKeyRect.put(string, vector);
        string = "Others";
        vector = new Vector(19);
        vector.add("ShrinkFooter");
        vector.add("DataDriver");
        vector.add("CompressIfNoRecord");
        vector.add("NoRecordTip");
        vector.add("MaxRecords");
        vector.add("nationalLanguageSupport");
        vector.add("AppletWidth");
        vector.add("AppletHeight");
        vector.add("PageBackground");
        vector.add("BeforeRun");
        vector.add("AfterRun");
        vector.add("AfterInitParameter");
        vector.add("ShowSubHeaderFooter");
        vector.add("ImportParamValues");
        vector.add("ParaListAuto");
        vector.add("EmbeddedFonts");
        vector.add("StyleGroup");
        vector.add("NoTempFile");
        vector.add("ImportJavaScript");
        buildKeyRect.put(string, vector);
        string = "TOC";
        vector = new Vector(2);
        vector.add("TOCAnchor");
        vector.add("AnchorDispValue");
        buildKeyRect.put(string, vector);
        string = "Excel";
        vector = new Vector(5);
        vector.add("ExcelBufferSize");
        vector.add("RowsPerSheet");
        vector.add("ColumnWidthList");
        vector.add("FastPass");
        vector.add("Columned");
        buildKeyRect.put(string, vector);
        styles = new Vector(10);
    }
}

