/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.io.File;
import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReportLoader;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.report.JetRptArea;
import jet.report.JetRptBarcode;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggSpecialField;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptDBField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMap;
import jet.report.JetRptMapDBField;
import jet.report.JetRptMediaField;
import jet.report.JetRptParameterField;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSubReport;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.util.WildcardMatcher;

public class UpgradeName {
    private static JRLogger SEDU = JRLogger.getLogger(UpgradeName.class.getName());
    private static final String UPDATENAME = "-vDebug";
    private static final String Z = "-vError";
    private static final String add = "-log";
    private static final String addElement = "-help";
    private static final String append = "UpgradeName.log";

    private static String SEDU(JetObject jetObject) {
        String string = null;
        if (jetObject instanceof JetRptCTHdDBField) {
            string = "CTDBField";
        } else if (jetObject instanceof JetRptCTAggSpecialField) {
            string = "CTAggSpecialField";
        } else if (jetObject instanceof JetRptCTAggField) {
            string = "CTAggField";
        } else if (jetObject instanceof JetRptMap) {
            string = "Map";
        } else if (jetObject instanceof JetRptMapDBField) {
            string = "MapDBField";
        } else if (jetObject instanceof JetRptMediaField) {
            string = "MediaField";
        } else if (jetObject instanceof JetRptBarcode) {
            string = "Barcode";
        } else if (jetObject instanceof JetRptDBField) {
            string = "DBField";
        } else if (jetObject instanceof JetRptArea) {
            string = "Area";
        } else if (jetObject instanceof JetRptParameterField) {
            string = "ParameterField";
        } else if (jetObject instanceof JetRptSystemField) {
            string = "SpecialField";
        } else if (jetObject instanceof JetRptSubReport) {
            string = "Subreport";
        }
        return string;
    }

    public static String getInstancePrefix(JetObject jetObject) {
        String string = UpgradeName.SEDU(jetObject);
        if (string == null) {
            string = jetObject.getInstancePrefix();
        }
        return string;
    }

    public static String getInstancePrefixTag(JetObject jetObject) {
        String string = UpgradeName.getInstancePrefix(jetObject);
        if (jetObject instanceof JetRptTextField && string.equals("Label")) {
            string = "TextField";
        }
        return string;
    }

    private static void UPDATENAME(JetObject jetObject, Vector vector) {
        String string = jetObject.getInstName();
        String string2 = string.toUpperCase();
        String string3 = UpgradeName.SEDU(jetObject);
        if (string3 != null && string2.startsWith(string3.toUpperCase()) || jetObject instanceof JetRptSystemField && string2.startsWith("SYSTEMFIELD")) {
            string2 = jetObject.getInstancePrefix();
            if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase(string)) {
                if (vector.contains(string2)) {
                    int n = 1;
                    while (vector.contains(string2 + n)) {
                        ++n;
                    }
                    string2 = string2 + n;
                }
                vector.add(string2);
                if (!string2.equalsIgnoreCase(string)) {
                    if (SEDU.isDebugEnabled()) {
                        SEDU.debug("Upgrade Name\n[" + string + "] upgrade to [" + string2 + "]");
                    }
                    jetObject.setInstName(string2);
                }
            } else if ((string2 == null || string2.length() == 0) && SEDU.isErrorEnabled()) {
                SEDU.error("Upgrade Name\nFail to change the " + string + "!");
            }
        }
        vector.add(string);
    }

    private static void Z(JetContainable jetContainable, Vector vector) {
        UpgradeName.UPDATENAME((JetObject)((Object)jetContainable), vector);
        Vector vector2 = jetContainable.getChildren();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            JetObject jetObject = (JetObject)vector2.elementAt(i);
            if (jetObject instanceof JetContainable) {
                UpgradeName.Z((JetContainable)((Object)jetObject), vector);
                continue;
            }
            UpgradeName.UPDATENAME(jetObject, vector);
        }
    }

    public static void updateName(JetRootable jetRootable) {
        UpgradeName.Z((JetContainable)((Object)jetRootable), new Vector());
        ((JetObject)((Object)jetRootable)).createNamingSystem();
    }

    private static void add() {
        System.out.println("java -Dreporthome=<reportHome> jet.report.UpgradeName [-options] reportfiles");
        System.out.println("Usage: Update the name of DBFields in the report using the field name in catalog for exporting to XML file.");
        System.out.println("\n     <reportHome>\t specify the JReport install path.");
        System.out.println("     reportfiles\t Specify the location of the existing report.\n\t\t\t If the location is not specified, the current user path will be used.");
        System.out.println("If the report file is created by JReport Designer that is higher than build 589, please do not use this program.");
        System.out.println("\nwhere options include:");
        System.out.println("    -help\t\t Print this help message.");
        System.out.println("    -vDebug\t\t Enable output debug message.");
        System.out.println("    -vError\t\t Enable output error message.");
        System.out.println("    -log[:<file>] \t Output debug message to .\\UpgradeName.log or .\\<file>.");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase(addElement)) continue;
            bl = true;
            break;
        }
        if (bl) {
            UpgradeName.add();
            return;
        }
        n = 1;
        String string = null;
        boolean bl2 = false;
        String string2 = append;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length && n != 0; ++i) {
            if (stringArray[i].equalsIgnoreCase(Z)) {
                n2 |= 4;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(UPDATENAME)) {
                n2 |= 1;
                continue;
            }
            if (stringArray[i].toUpperCase().startsWith(add.toUpperCase())) {
                if (!stringArray[i].equalsIgnoreCase(add)) {
                    try {
                        if (stringArray[i].charAt(add.length()) == ':') {
                            string2 = stringArray[i].substring(add.length() + 1);
                            bl2 = true;
                            continue;
                        }
                        n = 0;
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                    continue;
                }
                bl2 = true;
                continue;
            }
            String string3 = stringArray[i];
            object = new File(string3);
            if (((File)object).exists()) {
                if (((File)object).isFile() && string3.endsWith(".cls".toLowerCase())) {
                    vector.add(((File)object).getAbsolutePath());
                    continue;
                }
                if (string != null || !vector.isEmpty()) continue;
                string = string3;
                continue;
            }
            n = 0;
        }
        if (n == 0) {
            UpgradeName.add();
            System.exit(1);
        }
        ReportEnv.checkEnv(new Object(), null, 0);
        if (ReportEnv.ie()) {
            System.out.println("This is an evaluation version.");
            System.exit(1);
        }
        if (bl2) {
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            JRLoggingUtil.configLog(string2);
        }
        JRLogger.setDebugLevel(n2);
        boolean bl3 = vector.isEmpty();
        if (string == null && bl3) {
            string = System.getProperty("user.dir");
        }
        if (bl3 && !((File)(object = new File(string))).isFile() && (stringArray2 = ((File)object).list(new WildcardMatcher("*.cls", false))) != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                vector.addElement(stringArray2[i]);
            }
        }
        if (!vector.isEmpty()) {
            JetObject.UPDATENAME = true;
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = null;
                string4 = (String)vector.elementAt(i);
                if (string != null) {
                    string4 = new File(string, string4).getAbsolutePath();
                }
                try {
                    File file = new File(string4);
                    JetObject jetObject = new LoaderNoCache(file.getAbsolutePath()).loadNoInit();
                    if (!(jetObject instanceof JetRptReportPanel)) continue;
                    object = (JetRptReportPanel)jetObject;
                    UpgradeName.updateName((JetRootable)object);
                    ((JetObject)object).createNamingSystem();
                    ReportLoader.save(null, (JetObject)object, ((JetRptGroupPanel)object).getInstName(), string4);
                    continue;
                }
                catch (Exception exception) {
                    if (!SEDU.isErrorEnabled()) continue;
                    SEDU.error("", exception);
                }
            }
        } else {
            System.exit(0);
        }
    }
}

