/*
 * Decompiled with CFR 0.152.
 */
package jet.report.bursting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.naming.ClassType;
import jet.report.JetRptObject;
import jet.report.bursting.BurstingRecipientServerInformationImpl;
import jet.report.bursting.RecipientMappingIdentifierImpl;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientServerInformation;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectInfo.bursting.RecipientMappingIdentifier;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;

public class JetRptBurstingSchema
extends JetRptObject
implements BurstingSchema,
BurstingRecipientSchema {
    public JetVector burstingDataSets;
    public JetString recipientDatasourceName;
    public JetString recipientQueryName;
    public JetString recipientMappingDisk;
    public JetString recipientMappingFTP;
    public JetString recipientMappingMail;
    public JetString recipientMappingServerVersionSystem;
    public JetBoolean selectedDefaultly = new JetBoolean(this, "SelectedDefaultly", true);
    public JetVector burstingKeyColumns;
    public JetVector recipientColumns;
    public JetString recipientMappingGroup;
    public JetBoolean userMailGroup;
    public JetBoolean usePrivateFolderGroup;
    public JetString privateFolderGroup;
    public JetString recipientMappingRole;
    public JetBoolean userMailRole;
    public JetBoolean usePrivateFolderRole;
    public JetString privateFolderRole;
    public JetString recipientMappingUser;
    public JetBoolean userMailUser;
    public JetBoolean usePrivateFolderUser;
    public JetString privateFolderUser;
    private static HashMap SEDU = null;

    public JetRptBurstingSchema() {
        this.burstingDataSets = new JetVector(this, "BurstingDataSets");
        this.recipientDatasourceName = new JetString(this, "RecipientDatasourceName", "Data Source 1");
        this.recipientQueryName = new JetString(this, "RecipientQueryName");
        this.recipientMappingDisk = new JetString(this, "RecipientMappingDisk");
        this.recipientMappingFTP = new JetString(this, "RecipientMappingFTP");
        this.recipientMappingMail = new JetString(this, "RecipientMappingMail");
        this.recipientMappingServerVersionSystem = new JetString(this, "RecipientMappingSerVerSys");
        this.burstingKeyColumns = new JetVector(this, "BurstingKeyColumns");
        this.recipientColumns = new JetVector(this, "RecipientColumns");
        this.recipientMappingGroup = new JetString(this, "RecipientMappingGroup");
        this.userMailGroup = new JetBoolean(this, "UserMailGroup");
        this.usePrivateFolderGroup = new JetBoolean(this, "UsePrivateFolderGroup");
        this.privateFolderGroup = new JetString(this, "PrivateFolderGroup");
        this.recipientMappingRole = new JetString(this, "RecipientMappingRole");
        this.userMailRole = new JetBoolean(this, "UserMailRole");
        this.usePrivateFolderRole = new JetBoolean(this, "UsePrivateFolderRole");
        this.privateFolderRole = new JetString(this, "PrivateFolderRole");
        this.recipientMappingUser = new JetString(this, "RecipientMappingUser");
        this.userMailUser = new JetBoolean(this, "UserMailUser");
        this.usePrivateFolderUser = new JetBoolean(this, "UsePrivateFolderUser");
        this.privateFolderUser = new JetString(this, "PrivateFolderUser");
        this.selectedDefaultly.setCanChangeByOthers(false);
        this.recipientDatasourceName.setCanChangeByOthers(false);
        this.recipientQueryName.setCanChangeByOthers(false);
        this.recipientMappingDisk.setCanChangeByOthers(false);
        this.recipientMappingFTP.setCanChangeByOthers(false);
        this.recipientMappingMail.setCanChangeByOthers(false);
        this.recipientMappingServerVersionSystem.setCanChangeByOthers(false);
        this.recipientMappingGroup.setCanChangeByOthers(false);
        this.userMailGroup.setCanChangeByOthers(false);
        this.privateFolderGroup.setCanChangeByOthers(false);
        this.recipientMappingRole.setCanChangeByOthers(false);
        this.userMailRole.setCanChangeByOthers(false);
        this.privateFolderRole.setCanChangeByOthers(false);
        this.recipientMappingUser.setCanChangeByOthers(false);
        this.userMailUser.setCanChangeByOthers(false);
        this.privateFolderUser.setCanChangeByOthers(false);
    }

    @Override
    public void afterInit() {
        if (!this.isAfterInit()) {
            String string = this.getInstName();
            if (string.startsWith("jet_report_bursting_JetRptBurstingSchema")) {
                String string2 = this.getInstancePrefix();
                string2 = string2.concat(string.substring("jet_report_bursting_JetRptBurstingSchema".length()));
                this.setInstName(string2);
            }
            super.afterInit();
        }
    }

    @Override
    public String[] getBurstingDataSetNames() {
        return this.burstingDataSets.toStringArray();
    }

    @Override
    public BurstingRecipientSchema getBurstingRecipientSchema() {
        return this;
    }

    @Override
    public String[] getSharedDataSetNames() {
        JetObject jetObject = ObjectLogicFactory.getBasicComponentLogic().getAncestorComponentByClass((JetObject)this, "jet.reportset.JetRptReport");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jetObject != null && jetObject instanceof JetRptReport) {
            List list = ObjectLogicFactory.getReportLogic().getUsedDataSet((JetRptReport)jetObject);
            for (JetRptDataSet jetRptDataSet : list) {
                String string = jetRptDataSet.getInstName();
                if (this.burstingDataSets.get().contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String getDatasourceName() {
        return this.recipientDatasourceName.get();
    }

    @Override
    public String getQueryName() {
        return this.recipientQueryName.get();
    }

    @Override
    public String getRecipientMappingDisk() {
        String string = this.recipientMappingDisk.get();
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getRecipientMappingFTP() {
        String string = this.recipientMappingFTP.get();
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public RecipientMappingIdentifier[] getRecipientMappingIdentifiers() {
        Vector vector = this.burstingKeyColumns.get();
        Vector vector2 = this.recipientColumns.get();
        Vector<RecipientMappingIdentifierImpl> vector3 = new Vector<RecipientMappingIdentifierImpl>();
        for (int i = 0; i < Math.min(vector.size(), vector2.size()); ++i) {
            String string = (String)vector.get(i);
            String string2 = (String)vector2.get(i);
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            vector3.add(new RecipientMappingIdentifierImpl(string, string2));
        }
        return vector3.toArray(new RecipientMappingIdentifier[0]);
    }

    @Override
    public String getRecipientMappingMail() {
        String string = this.recipientMappingMail.get();
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getRecipientMappingServerVersionSystem() {
        String string = this.recipientMappingServerVersionSystem.get();
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public BurstingRecipientServerInformation getRecipientServerInformationGroup() {
        String string = this.recipientMappingGroup.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailGroup.get(), this.usePrivateFolderGroup.get(), this.privateFolderGroup.get());
    }

    @Override
    public BurstingRecipientServerInformation getRecipientServerInformationRole() {
        String string = this.recipientMappingRole.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailRole.get(), this.usePrivateFolderRole.get(), this.privateFolderRole.get());
    }

    @Override
    public BurstingRecipientServerInformation getRecipientServerInformationUser() {
        String string = this.recipientMappingUser.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailUser.get(), this.usePrivateFolderUser.get(), this.privateFolderUser.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (SEDU == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (SEDU == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("RecipientMappingGroup", n++);
                    hashMap.put("RecipientMappingDisk", n++);
                    hashMap.put("RecipientMappingRole", n++);
                    hashMap.put("RecipientDatasourceName", n++);
                    hashMap.put("UsePrivateFolderUser", n++);
                    hashMap.put("BurstingDataSets", n++);
                    hashMap.put("UserMailUser", n++);
                    hashMap.put("PrivateFolderRole", n++);
                    hashMap.put("UserMailGroup", n++);
                    hashMap.put("RecipientMappingSerVerSys", n++);
                    hashMap.put("SelectedDefaultly", n++);
                    hashMap.put("BurstingKeyColumns", n++);
                    hashMap.put("RecipientColumns", n++);
                    hashMap.put("UserMailRole", n++);
                    hashMap.put("UsePrivateFolderGroup", n++);
                    hashMap.put("RecipientMappingMail", n++);
                    hashMap.put("PrivateFolderUser", n++);
                    hashMap.put("RecipientQueryName", n++);
                    hashMap.put("UsePrivateFolderRole", n++);
                    hashMap.put("PrivateFolderGroup", n++);
                    hashMap.put("RecipientMappingUser", n++);
                    hashMap.put("RecipientMappingFTP", n++);
                    SEDU = hashMap;
                }
            }
        }
        return SEDU;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("schema name: ").append(this.getName()).append(" [isSelectedDefaultly: ").append(this.isSelectedDefaultly()).append("]\n");
        stringBuffer.append("{BurstingDataSetNames:[");
        JetRptBurstingSchema jetRptBurstingSchema = this;
        String[] stringArray = this.getBurstingDataSetNames();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        BurstingRecipientSchema burstingRecipientSchema = jetRptBurstingSchema.getBurstingRecipientSchema();
        stringBuffer.append("]\n BurstingRecipientSchema:{datasource:");
        stringBuffer.append(burstingRecipientSchema.getDatasourceName()).append("; query: ").append(burstingRecipientSchema.getQueryName()).append(";\n\t RecipientMappingIdentifiers: [");
        RecipientMappingIdentifier[] recipientMappingIdentifierArray = burstingRecipientSchema.getRecipientMappingIdentifiers();
        for (int i = 0; i < recipientMappingIdentifierArray.length; ++i) {
            stringBuffer.append(recipientMappingIdentifierArray[i]);
            if (i >= recipientMappingIdentifierArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("];\n\t disk: ").append(burstingRecipientSchema.getRecipientMappingDisk()).append(";\n\t ftp: ").append(burstingRecipientSchema.getRecipientMappingFTP()).append(";\n\t mail: ").append(burstingRecipientSchema.getRecipientMappingMail()).append(";\n\t version: ").append(burstingRecipientSchema.getRecipientMappingServerVersionSystem()).append(";\n\t group: ").append(burstingRecipientSchema.getRecipientServerInformationGroup()).append(";\n\t role: ").append(burstingRecipientSchema.getRecipientServerInformationRole()).append(";\n\t user: ").append(burstingRecipientSchema.getRecipientServerInformationUser()).append("}}");
        return stringBuffer.toString();
    }

    @Override
    public boolean canBeBrowse() {
        return false;
    }

    @Override
    public boolean isSelectedDefaultly() {
        return this.selectedDefaultly.booleanValue();
    }

    @Override
    public String getName() {
        return this.getInstName();
    }

    @Override
    public void setName(String string) {
        if (JetRptBurstingSchema.getRoot(this) instanceof JetRootable) {
            this.setInstName(string);
        } else {
            this.setInstNameDirectly(string);
        }
    }

    @Override
    public String getInstancePrefix() {
        return ClassType.getClassTagByClassName(this.getClass().getName());
    }

    @Override
    public void setSelectedDefaultly(boolean bl) {
        this.selectedDefaultly.set(bl);
    }
}

