/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.properties.ChartAxisProperties;
import chart.properties.ChartAxisTickProperties;
import chart.properties.ChartAxisUnitProperties;
import guitools.toolkit.Unit;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetChartGroupedProperties;
import jet.report.chart.JetChartPenStyle;
import jet.report.chart.JetChartTextStyle;
import jet.report.chart.JetRptChartPaper;

public class JetChartCategoryAxisProperties
extends JetChartGroupedProperties {
    public JetChartPenStyle axisPen;
    public JetBoolean showGrid;
    public JetChartPenStyle gridPen;
    public JetBoolean showTickMarkLabels;
    public JetChartPenStyle tickMarkPen;
    public JetEnumeration tickMarkType;
    public JetUnitNumber tickMarkLength;
    public JetChartTextStyle labelTextStyle;
    public JetNumber labelEveryNTickMarks;
    public JetNumber numOfLabels;
    public JetBoolean isBestEffort;
    public JetUnitNumber labelAxisGap;
    public JetEnumeration placement;
    public JetEnumeration minorTickMarkType;
    public JetUnitNumber minorTickMarkLength;
    public JetBoolean labelFontAutomaticOrientation;
    public JetBoolean showLabelTips;
    public JetNumber position;
    public JetEnumeration labelPosition;
    public JetBoolean scrollableChart;
    public JetNumber scrollableVisibleValue;
    public JetNumber displayAreaPercent;
    public JetQualifyReference axisMode;
    public JetString maxLEDValue;
    public JetString minLEDValue;
    public JetBoolean correlateMajorTickMark;
    public JetBoolean correlateMinorTickMark;
    public JetBoolean correlateMinorLabelFont;
    public JetChartPenStyle minorTickMarkPen;
    public JetBoolean showMinorTickMarkLabels;
    public JetNumber numOfMinorTickMarkLabels;
    public JetNumber labelEveryNTMinorTickMarks;
    public JetChartTextStyle minorLabelTextStyle;
    public JetBoolean minorlabelFontAutomaticOrientation;
    public JetBoolean correlateMinorFilter;
    public JetVector dataMinorFilter;
    public JetNumber scaleValueDataType;
    public JetBoolean scaleIsUseConstantInterval;
    public JetBoolean scaleIsMinValAuto;
    public JetBoolean scaleIsMaxValAuto;
    public JetBoolean scaleIsMajorUnitAuto;
    public JetBoolean scaleIsMinorUnitAuto;
    public JetString scaleMinValue;
    public JetString scaleMaxValue;
    public JetString scaleMajorInterval;
    public JetString scaleMinorInterval;
    public JetNumber scaleMajorUnit;
    public JetNumber scaleMinorUnit;
    public JetBoolean showChartInScoll;
    public JetBoolean autoNumOfLabels;
    public JetBoolean autoNumOfMinorTickMarkLabels;
    public JetBoolean autoScaleYAxis;

    JetChartCategoryAxisProperties(JetObject jetObject, String string) {
        super(jetObject, "Axis" + string);
        this.axisPen = new JetChartPenStyle(jetObject, this.prefix);
        this.showGrid = new JetBoolean(jetObject, this.prefix + "ShowGrid", false);
        this.gridPen = new JetChartPenStyle(jetObject, this.prefix + "Grid");
        this.showTickMarkLabels = new JetBoolean(jetObject, this.prefix + "ShowTickMarkLabels", true);
        this.tickMarkPen = new JetChartPenStyle(jetObject, this.prefix + "TickMark");
        this.tickMarkType = new JetEnumeration(jetObject, this.prefix + "TickMarkType", 97);
        this.tickMarkLength = new JetUnitNumber(jetObject, this.prefix + "TickMarkLength", JRObjectTemplate.convertSize(5));
        this.minorTickMarkType = new JetEnumeration(jetObject, this.prefix + "MinorTickMarkType", 97);
        this.minorTickMarkLength = new JetUnitNumber(jetObject, this.prefix + "MinorTickMarkLength", JRObjectTemplate.convertSize(3));
        this.labelTextStyle = new JetChartTextStyle(jetObject, this.prefix + "Label");
        this.labelEveryNTickMarks = new JetNumber(jetObject, this.prefix + "LabelEveryNTickMarks", 1);
        this.numOfLabels = new JetNumber(jetObject, this.prefix + "NumOfLabels", -1);
        this.isBestEffort = new JetBoolean(jetObject, this.prefix + "IsBestEffort", true);
        this.labelAxisGap = new JetUnitNumber(jetObject, this.prefix + "LabelAxisGap", JRObjectTemplate.convertSize(5));
        this.placement = new JetEnumeration(jetObject, this.prefix + "Placement", 19);
        this.tickMarkType.set("Outside");
        this.minorTickMarkType.set("None");
        this.placement.set("Bottom");
        this.labelFontAutomaticOrientation = new JetBoolean(jetObject, this.prefix + "LabelFontAutomaticOrientation", true);
        this.showLabelTips = new JetBoolean(jetObject, this.prefix + "ShowLabelTips", true);
        this.labelPosition = new JetEnumeration(jetObject, this.prefix + "LabelPosition");
        this.labelPosition.add("outside", 0);
        this.labelPosition.add("inside", 1);
        this.labelPosition.set("outside");
        this.scrollableChart = new JetBoolean(jetObject, this.prefix + "ScrollableChart", false);
        this.scrollableVisibleValue = new JetNumber(jetObject, this.prefix + "ScrollableVisibleValue", 10);
        this.displayAreaPercent = new JetNumber(jetObject, this.prefix + "DisplayAreaPercentage", 15);
        this.position = new JetNumber(jetObject, this.prefix + "Position", 1);
        this.position.enableAllChangeBys(false);
        Vector<String> vector = new Vector<String>(2);
        vector.add(String.valueOf(0));
        vector.add(String.valueOf(1));
        this.position.setPropertyChoice(vector);
        this.position.setEditorType(JetNumber.CHOICE_EDITOR);
        this.axisMode = new JetQualifyReference(jetObject, this.prefix + "Mode");
        this.minLEDValue = new JetString(jetObject, this.prefix + "AxisMinValue", "");
        this.minLEDValue.enableAllChangeBys(false);
        this.maxLEDValue = new JetString(jetObject, this.prefix + "AxisMaxValue", "");
        this.maxLEDValue.enableAllChangeBys(false);
        this.correlateMajorTickMark = new JetBoolean(jetObject, this.prefix + "CorrelateAxisInMajorTickMark", false);
        this.correlateMinorTickMark = new JetBoolean(jetObject, this.prefix + "CorrelateAxisInMinorTickMark", false);
        this.correlateMinorLabelFont = new JetBoolean(jetObject, this.prefix + "CorrelateFontInMinorTickMark", false);
        this.minorTickMarkPen = new JetChartPenStyle(jetObject, this.prefix + "MinorTickMark");
        this.showMinorTickMarkLabels = new JetBoolean(jetObject, this.prefix + "ShowMinorTickMarkLabels", false);
        this.numOfMinorTickMarkLabels = new JetNumber(jetObject, this.prefix + "NumOfMinorTickMarkLabels", -1);
        this.labelEveryNTMinorTickMarks = new JetNumber(jetObject, this.prefix + "LabelEveryNMinorTickMarks", 1);
        this.minorLabelTextStyle = new JetChartTextStyle(jetObject, this.prefix + "MinorLabel");
        this.minorLabelTextStyle.fontSize.setUnitValue(Unit.convertInchToUnit(0.1111111111111111));
        this.minorlabelFontAutomaticOrientation = new JetBoolean(jetObject, this.prefix + "MinorLabelFontAutomaticOrientation", true);
        this.correlateMinorFilter = new JetBoolean(jetObject, this.prefix + "CorrelateDataFilterInMinorTickMark", false);
        this.dataMinorFilter = new JetVector(jetObject, this.prefix + "DataFilterInMinorTickMark");
        this.dataMinorFilter.setEditorType(JetVector.CHART_FILTER_EDITOR);
        this.scaleIsUseConstantInterval = new JetBoolean(jetObject, this.prefix + "ScaleUseConstant", false);
        this.scaleIsUseConstantInterval.enableAllChangeBys(false);
        this.scaleIsMinValAuto = new JetBoolean(jetObject, this.prefix + "ScaleMinValueAuto", true);
        this.scaleIsMinValAuto.enableAllChangeBys(false);
        this.scaleIsMaxValAuto = new JetBoolean(jetObject, this.prefix + "ScaleMaxValueAuto", true);
        this.scaleIsMaxValAuto.enableAllChangeBys(false);
        this.scaleIsMajorUnitAuto = new JetBoolean(jetObject, this.prefix + "ScaleMajorUnitAuto", true);
        this.scaleIsMajorUnitAuto.enableAllChangeBys(false);
        this.scaleIsMinorUnitAuto = new JetBoolean(jetObject, this.prefix + "ScaleMinorUnitAuto", true);
        this.scaleIsMinorUnitAuto.enableAllChangeBys(false);
        this.scaleValueDataType = new JetNumber(jetObject, this.prefix + "ScaleValueSQLType", 0);
        this.scaleValueDataType.enableAllChangeBys(false);
        this.scaleMinValue = new JetString(jetObject, this.prefix + "ScaleMinValue", "");
        this.scaleMinValue.enableAllChangeBys(false);
        this.scaleMaxValue = new JetString(jetObject, this.prefix + "ScaleMaxValue", "");
        this.scaleMaxValue.enableAllChangeBys(false);
        this.scaleMajorInterval = new JetString(jetObject, this.prefix + "ScaleMajorInterval", "");
        this.scaleMajorInterval.enableAllChangeBys(false);
        this.scaleMinorInterval = new JetString(jetObject, this.prefix + "ScaleMinorInterval", "");
        this.scaleMinorInterval.enableAllChangeBys(false);
        this.scaleMajorUnit = new JetNumber(jetObject, this.prefix + "ScaleMajorIntervalUnit", -1);
        this.scaleMajorUnit.enableAllChangeBys(false);
        this.scaleMinorUnit = new JetNumber(jetObject, this.prefix + "ScaleMinorIntervalUnit", -1);
        this.scaleMinorUnit.enableAllChangeBys(false);
        this.showChartInScoll = new JetBoolean(jetObject, this.prefix + "ShowChartInScroll", true);
        this.showChartInScoll.enableAllChangeBys(false);
        this.autoNumOfLabels = new JetBoolean(jetObject, this.prefix + "AutoNumOfLabels", true);
        this.autoNumOfMinorTickMarkLabels = new JetBoolean(jetObject, this.prefix + "AutoNumOfMinorTickMarkLabels", true);
        this.autoScaleYAxis = new JetBoolean(jetObject, this.prefix + "AutoScaleYAxis");
    }

    @Override
    public String getGroupName() {
        return "Axis";
    }

    @Override
    public void addToGroup(String string) {
        if (string != null) {
            this.axisPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "ShowGrid", string);
            this.gridPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "ShowTickMarkLabels", string);
            this.tickMarkPen.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "TickMarkType", string);
            this.owner.addPropertyToGroup(this.prefix + "TickMarkLength", string);
            this.owner.addPropertyToGroup(this.prefix + "MinorTickMarkType", string);
            this.owner.addPropertyToGroup(this.prefix + "MinorTickMarkLength", string);
            this.labelTextStyle.addToGroup(string);
            this.owner.addPropertyToGroup(this.prefix + "LabelEveryNTickMarks", string);
            this.owner.addPropertyToGroup(this.prefix + "NumOfLabels", string);
            this.owner.addPropertyToGroup(this.prefix + "IsBestEffort", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelAxisGap", string);
            this.owner.addPropertyToGroup(this.prefix + "Placement", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelPosition", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelFontAutomaticOrientation", string);
            this.owner.addPropertyToGroup(this.prefix + "ShowLabelTips", string);
            if (this.prefix.startsWith("AxisX")) {
                this.owner.addPropertyToGroup(this.prefix + "Position", string);
                this.owner.addPropertyToGroup(this.prefix + "ScrollableChart", string);
                this.owner.addPropertyToGroup(this.prefix + "ScrollableVisibleValue", string);
                this.owner.addPropertyToGroup(this.prefix + "DisplayAreaPercentage", string);
                this.owner.addPropertyToGroup(this.prefix + "ShowChartInScroll", string);
            } else if (this.prefix.startsWith("AxisY")) {
                this.owner.addPropertyToGroup(this.prefix + "AutoScaleYAxis", string);
            }
        }
    }

    public ChartAxisProperties getChartAxisProperties() {
        ChartAxisProperties chartAxisProperties = new ChartAxisProperties();
        this.toChartAxisProperties(chartAxisProperties);
        return chartAxisProperties;
    }

    protected void toChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        chartAxisProperties.setAxisPen(this.axisPen.getChartPenStyle());
        chartAxisProperties.setShowGrid(this.showGrid.booleanValue());
        chartAxisProperties.setGridPen(this.gridPen.getChartPenStyle());
        chartAxisProperties.setBestEffort(this.isBestEffort.booleanValue());
        chartAxisProperties.setLabelAxisGap(this.labelAxisGap.intValue());
        chartAxisProperties.setPlacement(this.placement.intValue());
        chartAxisProperties.setShowLabelTips(this.showLabelTips.booleanValue());
        chartAxisProperties.setLabelPosition(this.labelPosition.intValue());
        chartAxisProperties.setPositionAxis(((Number)this.position.getObject()).intValue());
        chartAxisProperties.setScrollableChart(this.scrollableChart.booleanValue());
        chartAxisProperties.setScrollableVisibleValue(this.scrollableVisibleValue.intValue());
        chartAxisProperties.setDisplayAreaPercent(this.displayAreaPercent.intValue());
        if (this.owner instanceof JetRptChartPaper) {
            boolean bl = this.axisMode.getName().startsWith("AxisX");
            chartAxisProperties.setAxisMessage(((JetRptChartPaper)this.owner).getAxisBehaviourFuncAsChartMessageProperties(bl));
        }
        ChartAxisTickProperties chartAxisTickProperties = chartAxisProperties.getMajorTickMarkProperties();
        chartAxisTickProperties.setTickMarkPen(this.tickMarkPen.getChartPenStyle());
        chartAxisTickProperties.setTickMarkType(this.tickMarkType.intValue());
        chartAxisTickProperties.setTickMarkLength(this.tickMarkLength.intValue());
        chartAxisTickProperties.setShowTickMarkLabels(this.showTickMarkLabels.booleanValue());
        chartAxisTickProperties.setTickMarkLabel(this.labelTextStyle.getChartTextStyle());
        chartAxisTickProperties.setLabelEveryTickMark(this.labelEveryNTickMarks.intValue());
        chartAxisTickProperties.setLabelNumber(this.numOfLabels.intValue());
        chartAxisTickProperties.setAutoRotate(this.labelFontAutomaticOrientation.booleanValue());
        ChartAxisTickProperties chartAxisTickProperties2 = chartAxisProperties.getMinorTickMarkProperties();
        chartAxisTickProperties2.setTickMarkType(this.minorTickMarkType.intValue());
        chartAxisTickProperties2.setTickMarkLength(this.minorTickMarkLength.intValue());
        chartAxisProperties.setMinStringValue(this.minLEDValue.get());
        chartAxisProperties.setMaxStringValue(this.maxLEDValue.get());
        chartAxisTickProperties.setCorrelateTickMark(this.correlateMajorTickMark.booleanValue());
        chartAxisTickProperties.setCorrelateLabel(false);
        chartAxisTickProperties2.setCorrelateTickMark(this.correlateMinorTickMark.booleanValue());
        chartAxisTickProperties2.setCorrelateLabel(this.correlateMinorLabelFont.booleanValue());
        chartAxisTickProperties2.setTickMarkPen(this.minorTickMarkPen.getChartPenStyle());
        chartAxisTickProperties2.setShowTickMarkLabels(this.showMinorTickMarkLabels.booleanValue());
        chartAxisTickProperties2.setTickMarkLabel(this.minorLabelTextStyle.getChartTextStyle());
        chartAxisTickProperties2.setLabelEveryTickMark(this.labelEveryNTMinorTickMarks.intValue());
        chartAxisTickProperties2.setLabelNumber(this.numOfMinorTickMarkLabels.intValue());
        chartAxisTickProperties2.setAutoRotate(this.minorlabelFontAutomaticOrientation.booleanValue());
        chartAxisTickProperties2.setCorelateLabelFormat(this.correlateMinorFilter.booleanValue());
        chartAxisProperties.setMinorDataFilter(JetChartPropertyValues.mapChartDataFilter(this.dataMinorFilter.get()));
        ChartAxisUnitProperties chartAxisUnitProperties = chartAxisProperties.getUnitProperties();
        chartAxisUnitProperties.setDataType(this.scaleValueDataType.intValue());
        chartAxisUnitProperties.setUseConstantInterval(this.scaleIsUseConstantInterval.booleanValue());
        chartAxisUnitProperties.setStart(this.scaleIsMinValAuto.booleanValue(), this.scaleMinValue.get());
        chartAxisUnitProperties.setEnd(this.scaleIsMaxValAuto.booleanValue(), this.scaleMaxValue.get());
        chartAxisUnitProperties.setMajorUnit(this.scaleIsMajorUnitAuto.booleanValue(), this.scaleMajorInterval.get(), this.scaleMajorUnit.intValue());
        chartAxisUnitProperties.setMinorUnit(this.scaleIsMinorUnitAuto.booleanValue(), this.scaleMinorInterval.get(), this.scaleMinorUnit.intValue());
        chartAxisProperties.setIsShowChartInScroll(this.showChartInScoll.booleanValue());
        chartAxisTickProperties.setAutoLabelNumber(this.autoNumOfLabels.booleanValue());
        chartAxisTickProperties2.setAutoLabelNumber(this.autoNumOfMinorTickMarkLabels.booleanValue());
        chartAxisProperties.setAutoScaleYAxis(this.autoScaleYAxis.booleanValue());
    }

    public void setChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        this.fromChartAxisProperties(chartAxisProperties);
    }

    protected void fromChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        this.axisPen.setChartPenStyle(chartAxisProperties.getAxisPen());
        this.showGrid.set(chartAxisProperties.isShowGrid());
        this.gridPen.setChartPenStyle(chartAxisProperties.getGridPen());
        this.isBestEffort.set(chartAxisProperties.isBestEffort());
        this.labelAxisGap.set((int)chartAxisProperties.getLabelAxisGap());
        this.placement.set((String)JetChartPropertyValues.AXIS_PLACEMENT_INTEGERS.get(chartAxisProperties.getPlacement()));
        this.showLabelTips.set(chartAxisProperties.IsShowLabelTips());
        this.labelPosition.set(chartAxisProperties.getLabelPosition());
        this.position.set(chartAxisProperties.getPositionAxis());
        this.scrollableChart.set(chartAxisProperties.getScrollableChart());
        this.scrollableVisibleValue.set(chartAxisProperties.getScrollableVisibleValue());
        this.displayAreaPercent.set(chartAxisProperties.getDisplayAreaPercent());
        if (this.owner instanceof JetRptChartPaper) {
            boolean bl = this.axisMode.getName().startsWith("AxisX");
            ((JetRptChartPaper)this.owner).setAxisBehaviourFuncAsChartMessageProperties(bl, chartAxisProperties.getAxisMessage());
        }
        ChartAxisTickProperties chartAxisTickProperties = chartAxisProperties.getMajorTickMarkProperties();
        this.tickMarkPen.setChartPenStyle(chartAxisTickProperties.getTickMarkPen());
        this.tickMarkType.set(chartAxisTickProperties.getTickMarkType());
        this.tickMarkLength.set((int)chartAxisTickProperties.getTickMarkLength());
        this.showTickMarkLabels.set(chartAxisTickProperties.getShowMarkLabels());
        this.labelTextStyle.setChartTextStyle(chartAxisTickProperties.getTickMarkLabel());
        this.labelEveryNTickMarks.set(chartAxisTickProperties.getLabelEveryTickMark());
        this.numOfLabels.set(chartAxisTickProperties.getLabelNumber());
        this.labelFontAutomaticOrientation.set(chartAxisTickProperties.getAutoRotate());
        ChartAxisTickProperties chartAxisTickProperties2 = chartAxisProperties.getMinorTickMarkProperties();
        this.minorTickMarkType.set(chartAxisTickProperties2.getTickMarkType());
        this.minorTickMarkLength.set((int)chartAxisTickProperties2.getTickMarkLength());
        this.minLEDValue.set(chartAxisProperties.getMinStringValue());
        this.maxLEDValue.set(chartAxisProperties.getMaxStringValue());
        this.correlateMajorTickMark.set(chartAxisTickProperties.getCorrelateTickMark());
        this.correlateMinorTickMark.set(chartAxisTickProperties2.getCorrelateTickMark());
        this.correlateMinorLabelFont.set(chartAxisTickProperties2.getCorrelateLabel());
        this.minorTickMarkPen.setChartPenStyle(chartAxisTickProperties2.getTickMarkPen());
        this.showMinorTickMarkLabels.set(chartAxisTickProperties2.getShowMarkLabels());
        this.minorLabelTextStyle.setChartTextStyle(chartAxisTickProperties2.getTickMarkLabel());
        this.labelEveryNTMinorTickMarks.set(chartAxisTickProperties2.getLabelEveryTickMark());
        this.numOfMinorTickMarkLabels.set(chartAxisTickProperties2.getLabelNumber());
        this.minorlabelFontAutomaticOrientation.set(chartAxisTickProperties2.getAutoRotate());
        this.correlateMinorFilter.set(chartAxisTickProperties2.getCorrelateLabelFormat());
        this.dataMinorFilter.set(JetChartPropertyValues.mapFilterString(chartAxisProperties.getMinorDataFilter()));
        ChartAxisUnitProperties chartAxisUnitProperties = chartAxisProperties.getUnitProperties();
        this.scaleValueDataType.set(chartAxisUnitProperties.getDataType());
        this.scaleIsUseConstantInterval.set(chartAxisUnitProperties.getUseConstantInterva());
        this.scaleIsMinValAuto.set(chartAxisUnitProperties.getAutoStart());
        this.scaleMinValue.set(chartAxisUnitProperties.getStart());
        this.scaleIsMaxValAuto.set(chartAxisUnitProperties.getAutoEnd());
        this.scaleMaxValue.set(chartAxisUnitProperties.getEnd());
        this.scaleIsMajorUnitAuto.set(chartAxisUnitProperties.getAutoMajorUnit());
        this.scaleMajorInterval.set(chartAxisUnitProperties.getMajorUnit());
        this.scaleMajorUnit.set(chartAxisUnitProperties.getMajorUnitDateType());
        this.scaleIsMinorUnitAuto.set(chartAxisUnitProperties.getAutoMinorUnit());
        this.scaleMinorInterval.set(chartAxisUnitProperties.getMinorUnit());
        this.scaleMinorUnit.set(chartAxisUnitProperties.getMinorUnitDateType());
        this.showChartInScoll.set(chartAxisProperties.getIsShowChartInScroll());
        this.autoNumOfLabels.set(chartAxisTickProperties.getAutoLabelNumber());
        this.autoNumOfMinorTickMarkLabels.set(chartAxisTickProperties2.getAutoLabelNumber());
        this.autoScaleYAxis.set(chartAxisProperties.isAutoScaleYAxis());
    }
}

