/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.groupengine.GroupConstant;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.RangGroupBreaker;
import jet.naming.EnumerationConstant;
import jet.report.chart.JetChartElement;
import jet.reportLogic.objectInfo.AdvanceOption;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectInfo.SortInfo;
import jet.reportLogic.objectInfo.SpecifieldDesc;
import jet.reportLogic.objectInfo.SpecifieldOption;

public class JetChartGroupInfo
extends JetChartElement {
    public JetString groupOrder = null;
    public JetNumber groupType = null;
    public JetVector sortBy = null;
    public JetVector sortOrder = null;
    public JetVector specNames = null;
    public JetVector specOperators = null;
    public JetVector specOprands = null;
    public JetVector specOpNum = null;
    public JetBoolean keepOthers = null;
    public JetString othersName = null;
    public JetEnumeration selectType = null;
    public JetNumber selectN = null;
    public JetNumber selectStartPosition = null;
    public JetNumber selectSkip = null;

    public JetChartGroupInfo(JetObject jetObject, String string) {
        super(jetObject, string);
        this.groupOrder = new JetString(jetObject, string + "GroupOrder");
        this.groupOrder.set(GroupModel.getStringForOrder(0));
        this.groupType = new JetNumber(jetObject, string + "GroupType", 0);
        this.sortBy = new JetColumnVector(jetObject, string + "SortBy");
        this.sortOrder = new JetVector(jetObject, string + "SortOrder");
        this.specNames = new JetVector(jetObject, string + "SpecialNames");
        this.specOperators = new JetVector(jetObject, string + "SpecialOperators");
        this.specOprands = new JetVector(jetObject, string + "SpecialOperands");
        this.specOpNum = new JetVector(jetObject, string + "SpecialOpNum");
        this.keepOthers = new JetBoolean(jetObject, string + "KeepOthers", false);
        this.othersName = new JetString(jetObject, string + "OthersName", "Others");
        this.selectType = new JetEnumeration(jetObject, string + "SelectType", 87);
        this.selectN = new JetNumber(jetObject, string + "SelectN", -1);
        this.selectStartPosition = new JetNumber(jetObject, string + "SelectStartPosition", 1);
        this.selectType.set(EnumerationConstant.SELECTTYPE_STR_NAMES[0]);
        this.selectSkip = new JetNumber(jetObject, string + "Skip");
    }

    @Override
    public String getGroupName() {
        return null;
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        int n = groupInfo.getSortType();
        String string = GroupConstant.getStringForOrder(n);
        if (string != null) {
            this.groupOrder.set(string);
            this.groupType.set(0);
            this.clearSpecifieldOption();
            this.SEDU(groupInfo.getAdvOption());
        } else {
            this.SELECTTYPE_STR_NAMES();
            this.add(groupInfo.getSpecOption());
        }
        Vector vector = groupInfo.getSortInfos();
        this.sortBy.clear();
        this.sortOrder.clear();
        int n2 = vector.size();
        if (n2 > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                SortInfo sortInfo = (SortInfo)vector.get(i);
                this.sortBy.add(sortInfo.getFieldName());
                int n3 = sortInfo.getSortType();
                String string2 = GroupConstant.getStringForOrder(n3);
                this.sortOrder.add(string2);
            }
            this.groupType.set(1);
        }
    }

    private void SEDU(AdvanceOption advanceOption) {
        if (advanceOption == null) {
            return;
        }
        this.keepOthers.set(advanceOption.isKeepOthers());
        this.othersName.set(advanceOption.getOtherName());
        String string = advanceOption.getParameterNameForSelectN();
        this.selectType.set(advanceOption.getSelectType());
        if (string != null) {
            this.selectN.setChangeByObject(string);
        } else {
            int n = advanceOption.getSelectN();
            this.selectN.setChangeByObject(null);
            this.selectN.set(n);
        }
        this.selectStartPosition.set(advanceOption.getSelectStartPosition());
        this.selectSkip.set(advanceOption.getSelectSkip());
    }

    private void SELECTTYPE_STR_NAMES() {
        this.othersName.set("");
        this.selectType.set(EnumerationConstant.SELECTTYPE_STR_NAMES[0]);
        if (this.selectN.isChangeByOther()) {
            this.selectN.setChangeByObject(null);
        }
        this.selectN.set(-1);
        this.selectStartPosition.set(-1);
        this.selectSkip.set(0);
    }

    private void add(SpecifieldOption specifieldOption) {
        if (specifieldOption == null) {
            return;
        }
        String string = specifieldOption.getOtherName();
        this.keepOthers.set(specifieldOption.isKeepOthers());
        this.othersName.set(string);
        Vector vector = specifieldOption.getSpecifieldDescs();
        if (vector != null && vector.size() > 0) {
            this.groupOrder.set("");
            this.groupType.set(2);
            this.specNames.clear();
            this.specOperators.clear();
            this.specOpNum.clear();
            this.specOprands.clear();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Vector vector2;
                int n2;
                SpecifieldDesc specifieldDesc = (SpecifieldDesc)vector.get(i);
                this.specNames.add(specifieldDesc.getGroupName());
                int n3 = specifieldDesc.getOperator();
                String string2 = RangGroupBreaker.getPresentationName(n3);
                if (string2 != null) {
                    this.specOperators.add(string2);
                }
                if ((n2 = (vector2 = specifieldDesc.getOperands()).size()) <= 0) continue;
                this.specOpNum.add("" + n2);
                for (int j = 0; j < n2; ++j) {
                    this.specOprands.add(vector2.get(j).toString());
                }
            }
        } else {
            this.specNames.clear();
            this.specOperators.clear();
            this.specOpNum.clear();
            this.specOprands.clear();
        }
    }

    public void clearSpecifieldOption() {
        this.specNames.clear();
        this.specOperators.clear();
        this.specOpNum.clear();
        this.specOprands.clear();
    }

    public GroupInfo getGroupInfo() {
        int n = this.groupType.get();
        String string = this.groupOrder.get();
        int n2 = n == 2 ? -1 : GroupConstant.getOrderForString(string);
        GroupInfo groupInfo = new GroupInfo(null, null, n2);
        if (n2 != -1) {
            groupInfo.setAdvOption(this.append());
        } else {
            groupInfo.setSpecOption(this.getSpecOption());
        }
        groupInfo.setSortInfos(this.getSortInfos());
        return groupInfo;
    }

    public Vector getSortInfos() {
        Vector<SortInfo> vector = new Vector<SortInfo>();
        Vector vector2 = this.sortBy.get();
        Vector vector3 = this.sortOrder.get();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector2.get(i);
            String string2 = (String)vector3.get(i);
            int n2 = GroupConstant.getOrderForString(string2);
            SortInfo sortInfo = new SortInfo(string, n2);
            vector.add(sortInfo);
        }
        return vector;
    }

    public SpecifieldOption getSpecOption() {
        String string = null;
        if (this.keepOthers.get()) {
            string = this.othersName.get();
        }
        SpecifieldOption specifieldOption = new SpecifieldOption(string);
        specifieldOption.setKeepOthers(this.keepOthers.get());
        Vector vector = this.specNames.get();
        Vector vector2 = this.specOperators.get();
        Vector vector3 = this.specOpNum.get();
        Vector vector4 = this.specOprands.get();
        Vector<SpecifieldDesc> vector5 = new Vector<SpecifieldDesc>();
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)vector.get(i);
            String string3 = (String)vector2.get(i);
            int n3 = RangGroupBreaker.getOperatorByName(string3);
            int n4 = Integer.parseInt((String)vector3.get(i));
            Vector vector6 = new Vector();
            for (int j = 0; j < n4; ++j) {
                vector6.add(vector4.get(n + j));
            }
            n += n4;
            SpecifieldDesc specifieldDesc = new SpecifieldDesc(string2, n3, vector6);
            vector5.add(specifieldDesc);
        }
        specifieldOption.setSpecifieldDescs(vector5);
        return specifieldOption;
    }

    private AdvanceOption append() {
        AdvanceOption advanceOption = new AdvanceOption();
        String string = this.othersName.get();
        advanceOption.setKeepOthers(this.keepOthers.get());
        if (advanceOption.isKeepOthers()) {
            advanceOption.setOtherName(string);
        }
        advanceOption.setSelectType(this.selectType.getCurKey());
        advanceOption.setSelectStartPosition(this.selectStartPosition.get());
        advanceOption.setSelectN(this.selectN.get());
        advanceOption.setParameterNameForSelectN(this.selectN.getChangeByObjectName());
        advanceOption.setSelectSkip(this.selectSkip.intValue());
        return advanceOption;
    }

    public boolean hasGroupInfo() {
        return this.groupOrder.get() != null && !this.groupOrder.get().equals(GroupModel.getStringForOrder(0)) || this.sortBy.get() != null && this.sortBy.get().size() != 0 || this.keepOthers.get() || this.selectN.getChangeByObjectName() != null || this.selectN.get() != -1;
    }

    protected void makeToNoGroupInfo() {
        this.groupOrder.set(GroupModel.getStringForOrder(0));
        this.sortBy.set("");
        this.keepOthers.set(false);
        this.selectN.setChangeByObject(null);
        this.selectN.set(-1);
    }
}

