/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.graphics.ChartTextStyle;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetFontStyle;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetChartElement;
import jet.report.chart.JetChartFillPattern;
import jet.report.chart.JetChartPenStyle;

public class JetChartTextStyle
extends JetChartElement {
    public JetFont fontName;
    public JetUnitNumber fontSize;
    public JetFontStyle fontStyle;
    public JetChartPenStyle pen;
    public JetChartFillPattern pattern;
    public JetNumber rotation;
    public JetNumber shearing;
    public JetEnumeration underline;
    public JetEnumeration strikethrough;
    public JetEnumeration specialEffect1;
    public JetEnumeration specialEffect2;
    public JetBoolean wordWrap;

    public JetChartTextStyle(JetObject jetObject, String string) {
        super(jetObject, string + "Text");
        string = this.prefix;
        this.fontName = new JetFont(jetObject, string + "FontName");
        this.fontSize = new JetUnitNumber(jetObject, string + "FontSize", JRObjectTemplate.convertSize(12));
        this.fontStyle = new JetFontStyle(jetObject, string + "FontStyle");
        this.pen = new JetChartPenStyle(jetObject, string);
        this.pattern = new JetChartFillPattern(jetObject, string, false);
        this.rotation = new JetNumber(jetObject, string + "Rotation");
        this.shearing = new JetNumber(jetObject, string + "Shearing");
        this.underline = new JetEnumeration(jetObject, string + "Underline", 29);
        this.strikethrough = new JetEnumeration(jetObject, string + "Strikethrough", 25);
        this.specialEffect1 = new JetEnumeration(jetObject, string + "SpecialEffect1", 22);
        this.specialEffect2 = new JetEnumeration(jetObject, string + "SpecialEffect2", 23);
        this.wordWrap = new JetBoolean(jetObject, string + "WordWrap", false);
        this.underline.set("None");
        this.strikethrough.set("None");
        this.specialEffect1.set("None");
        this.specialEffect2.set("None");
    }

    @Override
    public String getGroupName() {
        return "Text";
    }

    @Override
    public void addToGroup(String string) {
        this.owner.addPropertyToGroup(this.fontName.getName(), string);
        this.owner.addPropertyToGroup(this.fontSize.getName(), string);
        this.owner.addPropertyToGroup(this.fontStyle.getName(), string);
        this.owner.addPropertyToGroup(this.rotation.getName(), string);
        this.owner.addPropertyToGroup(this.shearing.getName(), string);
        this.owner.addPropertyToGroup(this.underline.getName(), string);
        this.owner.addPropertyToGroup(this.strikethrough.getName(), string);
        this.owner.addPropertyToGroup(this.specialEffect1.getName(), string);
        this.owner.addPropertyToGroup(this.specialEffect2.getName(), string);
        this.owner.addPropertyToGroup(this.wordWrap.getName(), string);
        this.pen.addToGroup(string);
        this.pattern.addToGroupExceptImage(string);
    }

    public ChartTextStyle getChartTextStyle() {
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        chartTextStyle.setFontName(this.fontName.get());
        chartTextStyle.setFontSize(this.fontSize.intValue());
        chartTextStyle.setFontStyle(this.fontStyle.intValue());
        chartTextStyle.setUnderline(this.underline.intValue());
        chartTextStyle.setStrikethrough(this.strikethrough.intValue());
        chartTextStyle.setShearing((float)this.shearing.intValue() / 100.0f);
        chartTextStyle.setRotation(this.rotation.doubleValue() * Math.PI / 180.0);
        chartTextStyle.setFontPen(this.pen.getChartPenStyle());
        chartTextStyle.setFontColor(this.pattern.getChartFillPattern());
        JetChartPropertyValues.setFontSpecialEffect1(chartTextStyle, this.specialEffect1.intValue());
        JetChartPropertyValues.setFontSpecialEffect2(chartTextStyle, this.specialEffect2.intValue());
        chartTextStyle.setWordWrapper(this.wordWrap.booleanValue());
        return chartTextStyle;
    }

    public void setChartTextStyle(ChartTextStyle chartTextStyle) {
        this.fontName.set(chartTextStyle.getFontName());
        this.fontSize.set(chartTextStyle.getFontSize());
        this.fontStyle.set((String)JetChartPropertyValues.TEXT_STYLE_INTEGERS.get(chartTextStyle.getFontStyle()));
        this.underline.set((String)JetChartPropertyValues.TEXT_UNDERLINE_INTEGERS.get(chartTextStyle.getUnderline()));
        this.strikethrough.set((String)JetChartPropertyValues.TEXT_STRIKETHROUGH_INTEGERS.get(chartTextStyle.getStrikethrough()));
        this.shearing.set(chartTextStyle.getShearing() * 100.0f);
        this.rotation.set(chartTextStyle.getRotation() * 180.0 / Math.PI);
        this.pen.setChartPenStyle(chartTextStyle.getFontPen());
        this.pattern.setChartFillPattern(chartTextStyle.getFontColor());
        this.specialEffect1.set(JetChartPropertyValues.getFontSpecialEffect1String(chartTextStyle));
        this.specialEffect2.set(JetChartPropertyValues.getFontSpecialEffect2String(chartTextStyle));
        this.wordWrap.set(chartTextStyle.getWordWrapper());
    }
}

