/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.ChartDefinition;
import chart.ChartPropertyValues;
import chart.ChartShowValueInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartLineStyle;
import chart.properties.ChartColorBySummaryProperties;
import chart.properties.ChartMessageProperties;
import chart.properties.ChartPlatformProperties;
import chart.properties.ChartSizeBySummaryProperties;
import chart.properties.control.ChartValProperties;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.JetRptDBField;
import jet.report.JetRptObject;
import jet.report.JetRptTitleTextField;
import jet.report.chart.JetChartBackground;
import jet.report.chart.JetChartCreateInfos;
import jet.report.chart.JetChartDefinition;
import jet.report.chart.JetChartGroupInfo;
import jet.report.chart.JetRptChartComponent;
import jet.report.chart.JetRptChartGroupRect;
import jet.report.chart.JetRptChartLabel;
import jet.report.chart.JetRptChartLegend;
import jet.report.chart.JetRptChartOrgNode;
import jet.report.chart.JetRptChartPaper;
import jet.report.chart.JetRptChartShowValueFunc;
import jet.report.chart.JetRptChartShowValueFuncContainer;
import jet.report.mode.common.RptMode;
import jet.report.mode.common.RptRenderer;
import jet.report.onTheFlyFormula.Scope;
import jet.report.specialFunc.SpecialFunction;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DataElementInfo;
import jet.util.HashVector;
import jet.util.ReportFormat;
import jet.util.ValueToUnit;

public class JetRptChartPlatform
extends JetRptChartComponent {
    public static final int WIDTH_DEF = 500;
    public static final int HEIGHT_DEF = 335;
    public static final int X_DEF = 0;
    public static final int Y_DEF = 0;
    public JetChartDefinition definition;
    public JetUnitNumber topMargin;
    public JetUnitNumber leftMargin;
    public JetUnitNumber rightMargin;
    public JetUnitNumber bottomMargin;
    public JetChartBackground background;
    public JetBoolean autoLayout;
    public JetBoolean showLegend;
    public JetVector patternList;
    public JetBoolean antiAliasing;
    public JetBoolean interactive;
    public JetEnumeration sortCategory;
    public JetEnumeration sortSeries;
    public JetBoolean reverseCategory;
    public JetBoolean reverseSeries;
    public JetNumber categoryStartOffset;
    public JetNumber categoryEndOffset;
    public JetNumber seriesStartOffset;
    public JetNumber seriesEndOffset;
    public JetVector categoryFilter;
    public JetVector seriesFilter;
    public JetVector primaryDataFilter;
    public JetVector secondaryDataFilter;
    public JetVector hintFilter;
    public JetString hyperlink;
    public JetString xhyperlink;
    public JetString zhyperlink;
    public JetVector motionFieldFilter;
    public JetStringList hyperlinkTarget;
    public JetStringList xhyperlinkTarget;
    public JetStringList zhyperlinkTarget;
    public JetString section;
    public JetBoolean level;
    public JetNumber columnNum;
    public JetNumber rowNum;
    public JetStringList grpValueFormat;
    public JetStringList serGrpValueFormat;
    public JetVector blCategory;
    public JetVector blSeries;
    public JetVector blValue;
    public JetBoolean gotoDetail;
    public JetBoolean cache;
    public JetBoolean needCreateModel;
    public JetVector runtimeCategory;
    public JetVector runtimeSeries;
    public JetVector runtimeValue;
    public JetBoolean isBVData;
    public JetBoolean swapGroup;
    public JetChartGroupInfo categoryGroupInfo;
    public JetChartGroupInfo seriesGroupInfo;
    public JetVector bindedValues;
    public JetVector bindedPatterns;
    public JetBoolean styleInherit;
    public JetVector styleList;
    public JetString boundDataContainer;
    public JetBoolean haveSeriesSF;
    public JetBoolean haveCategorySF;
    public JetString alt;
    public JetString longDesc;
    public JetString externalTitle;
    public JetVector hintPercentFilter;
    private JetQualifyReference CHART_FILTER_EDITOR;
    private JetNumber CHART_FILTER_EDITOR_NO_DATE;
    private JetString CHART_PATTERN_LIST_EDITOR;
    private JetString CHOICE_EDITOR;
    private JetString COMBO_EDITOR;
    public JetVector bindedLineStyles;
    public JetVector bindedLineValues;
    public JetBoolean runInFlash;
    public JetChartGroupInfo motionGroupInfo;
    public JetBoolean haveMotionSF;
    public JetVector runtimeMotion;
    public JetUnitNumber minSpaceInTMs;
    public JetVector runtimeUniqueKeys;
    public JetColor hmGradientStartColor;
    public JetColor hmGradientEndColor;
    public JetBoolean hmIsGradientReverse;
    public JetNumber hmSizeByAlgorithm;
    public JetNumber hmColorByAlgorithm;
    public JetString hmColorBySummary;
    public JetString runtimeHMColorBySummary;
    public JetString hmSizeBySummary;
    public JetString runtimeHMSizeBySummary;
    public JetBoolean hmUseColorForZero;
    public JetColor hmColorOfNullValue;
    public JetColor hmColorOfZeroValue;
    public JetBoolean overallSeries;
    public JetString categoryDataMappingFile;
    public JetString seriesDataMappingFile;
    public JetBoolean invisibleInBrowserFilterDialog;
    public JetNumber indexInBrowseFilterDialog;
    ChartDataSetModel model = null;
    private static HashMap CSS_CHART_TYPE = null;
    private static HashVector SEDU = null;
    private static HashVector WHITE = null;
    private static HashVector Z = null;

    private void CHART_FILTER_EDITOR() {
        this.bindedValues = new JetVector(this, "BindedValues");
        this.bindedPatterns = new JetVector(this, "BindedPatterns");
        this.topMargin = new JetUnitNumber(this, "TopMargin", JRObjectTemplate.convertSize(0));
        this.leftMargin = new JetUnitNumber(this, "LeftMargin", JRObjectTemplate.convertSize(0));
        this.rightMargin = new JetUnitNumber(this, "RightMargin", JRObjectTemplate.convertSize(0));
        this.bottomMargin = new JetUnitNumber(this, "BottomMargin", JRObjectTemplate.convertSize(0));
        this.background = new JetChartBackground(this, "Platform");
        this.autoLayout = new JetBoolean(this, "AutoLayout", true);
        this.showLegend = new JetBoolean(this, "ShowLegend", true);
        this.patternList = new JetVector(this, "PatternList");
        this.antiAliasing = new JetBoolean(this, "AntiAliasing", true);
        this.interactive = new JetBoolean(this, "Interactive", true);
        this.sortCategory = new JetEnumeration(this, "SortCategory", 88);
        this.sortSeries = new JetEnumeration(this, "SortSeries", 88);
        this.reverseCategory = new JetBoolean(this, "ReverseCategory", false);
        this.reverseSeries = new JetBoolean(this, "ReverseSeries", false);
        this.categoryStartOffset = new JetNumber(this, "CategoryStartOffset", -1);
        this.categoryEndOffset = new JetNumber(this, "CategoryEndOffset", -1);
        this.seriesStartOffset = new JetNumber(this, "SeriesStartOffset", -1);
        this.seriesEndOffset = new JetNumber(this, "SeriesEndOffset", -1);
        this.categoryFilter = new JetVector(this, "CategoryFilter");
        this.motionFieldFilter = new JetVector(this, "MotionFilter");
        this.seriesFilter = new JetVector(this, "SeriesFilter");
        this.primaryDataFilter = new JetVector(this, "PrimaryDataFilter");
        this.secondaryDataFilter = new JetVector(this, "SecondaryDataFilter");
        this.hintFilter = new JetVector(this, "HintFilter");
        this.hyperlink = new JetString(this, "HyperLink");
        this.xhyperlink = new JetString(this, "XHyperLink");
        this.zhyperlink = new JetString(this, "ZHyperLink");
        this.hintPercentFilter = new JetVector(this, "HintPercentFilter");
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("_blank");
        vector.add("_top");
        vector.add("_self");
        vector.add("_parent");
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("_blank");
        vector2.add("_top");
        vector2.add("_self");
        vector2.add("_parent");
        Vector<String> vector3 = new Vector<String>();
        vector3.add("");
        vector3.add("_blank");
        vector3.add("_top");
        vector3.add("_self");
        vector3.add("_parent");
        this.hyperlinkTarget = new JetStringList(this, "HyperLinkTarget");
        this.xhyperlinkTarget = new JetStringList(this, "XHyperLinkTarget");
        this.zhyperlinkTarget = new JetStringList(this, "ZHyperLinkTarget");
        this.hyperlinkTarget.setList(vector);
        this.xhyperlinkTarget.setList(vector2);
        this.zhyperlinkTarget.setList(vector3);
        this.section = new JetString(this, "Section");
        this.level = new JetBoolean(this, "SameLevel");
        this.columnNum = new JetNumber(this, "ColumnNumber", 0);
        this.rowNum = new JetNumber(this, "RowNumber", 0);
        this.grpValueFormat = new JetStringList(this, "GroupValueFormat");
        this.serGrpValueFormat = new JetStringList(this, "SeriesValueEncoding");
        this.blCategory = new JetVector(this, "BLCategory");
        this.blSeries = new JetVector(this, "BLSeries");
        this.blValue = new JetVector(this, "BLValue");
        this.gotoDetail = new JetBoolean(this, "GotoDetail", false);
        this.cache = new JetBoolean(this, "Cache", true);
        this.needCreateModel = new JetBoolean(this, "NeedCreateChartDataSetModel", false);
        this.runtimeCategory = new JetVector(this, "RuntimeCategory");
        this.runtimeSeries = new JetVector(this, "RuntimeSeries");
        this.runtimeValue = new JetVector(this, "RuntimeValue");
        this.isBVData = new JetBoolean(this, "IsBVData", false);
        this.swapGroup = new JetBoolean(this, "SwapGroup", false);
        this.categoryGroupInfo = new JetChartGroupInfo(this, "Category");
        this.seriesGroupInfo = new JetChartGroupInfo(this, "Series");
        this.styleInherit = new JetBoolean(this, "StyleInherit", true);
        this.styleList = new JetVector(this, "StyleList");
        this.haveSeriesSF = new JetBoolean(this, "HaveSeriesSpecialFuncation", false);
        this.haveCategorySF = new JetBoolean(this, "HaveCategorySpecialFuncation", false);
        this.boundDataContainer = new JetString(this, "BoundDataContainer");
        this.alt = new JetString(this, "Alt");
        this.longDesc = new JetString(this, "LongDesc");
        this.externalTitle = new JetString(this, "ExternalTitle");
        this.CHART_FILTER_EDITOR_NO_DATE = new JetNumber(this, "LogicColumn", 1);
        this.CHART_FILTER_EDITOR_NO_DATE.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> vector4 = new Vector<String>();
        vector4.add(String.valueOf(1));
        vector4.add(String.valueOf(2));
        this.CHART_FILTER_EDITOR_NO_DATE.setPropertyChoice(vector4);
        this.CHART_FILTER_EDITOR_NO_DATE.enableAllChangeBys(false);
        this.CHART_FILTER_EDITOR = new JetQualifyReference(this, "TitleObject");
        this.CHART_PATTERN_LIST_EDITOR = new JetString(this, "DetailFields");
        this.CHART_PATTERN_LIST_EDITOR.enableAllChangeBys(false);
        this.bindedLineStyles = new JetVector(this, "BindedLineStyles");
        this.bindedLineValues = new JetVector(this, "BindedLineValues");
        this.runInFlash = new JetBoolean(this, "RunInFlash", false);
        this.runInFlash.enableAllChangeBys(false);
        this.haveMotionSF = new JetBoolean(this, "HaveMotionSpecialFuncation", false);
        this.motionGroupInfo = new JetChartGroupInfo(this, "Motion");
        this.runtimeMotion = new JetVector(this, "RuntimeMotion");
        this.minSpaceInTMs = new JetUnitNumber(this, "MinSpaceInTickMarks", Unit.convertInchToUnit(0.012));
        this.minSpaceInTMs.enableAllChangeBys(false);
        this.runtimeUniqueKeys = new JetVector(this, "RuntimeUniqueKeys");
        this.hmGradientStartColor = new JetColor(this, "HMChartGradientStartColor", new Color(195842));
        this.hmGradientStartColor.enableAllChangeBys(false);
        this.hmGradientEndColor = new JetColor(this, "HMChartGradientEndColor", new Color(16384514));
        this.hmGradientEndColor.enableAllChangeBys(false);
        this.hmIsGradientReverse = new JetBoolean(this, "HMChartGradientIsReverse");
        this.hmIsGradientReverse.enableAllChangeBys(false);
        this.hmSizeByAlgorithm = new JetNumber(this, "HMChartSizeByAlgorithm", 0);
        this.hmColorByAlgorithm = new JetNumber(this, "HMChartColorByAlgorithm", 0);
        this.hmSizeByAlgorithm.enableAllChangeBys(false);
        this.hmColorByAlgorithm.enableAllChangeBys(false);
        this.hmSizeByAlgorithm.setEditorType(JetNumber.CHOICE_EDITOR);
        this.hmColorByAlgorithm.setEditorType(JetNumber.CHOICE_EDITOR);
        vector4 = new Vector();
        vector4.add(String.valueOf(0));
        vector4.add(String.valueOf(1));
        vector4.add(String.valueOf(2));
        this.hmSizeByAlgorithm.setPropertyChoice(vector4);
        this.hmColorByAlgorithm.setPropertyChoice((Vector)vector4.clone());
        this.hmColorBySummary = new JetString(this, "HMChartColorBySummary");
        this.hmColorBySummary.enableAllChangeBys(false);
        this.hmSizeBySummary = new JetString(this, "HMChartSizeBySummary");
        this.hmSizeBySummary.enableAllChangeBys(false);
        this.runtimeHMColorBySummary = new JetString(this, "RuntimeHMChartColorBySummary");
        this.runtimeHMColorBySummary.enableAllChangeBys(false);
        this.runtimeHMSizeBySummary = new JetString(this, "RuntimeHMChartSizeBySummary");
        this.runtimeHMSizeBySummary.enableAllChangeBys(false);
        this.hmUseColorForZero = new JetBoolean(this, "HMUseColorForZero");
        this.hmUseColorForZero.enableAllChangeBys(false);
        this.hmColorOfNullValue = new JetColor(this, "HMColorOfNullValue", new Color(0xA0A0A0));
        this.hmColorOfNullValue.enableAllChangeBys(false);
        this.hmColorOfZeroValue = new JetColor(this, "HMColorOfZeroValue", Color.WHITE);
        this.hmColorOfZeroValue.enableAllChangeBys(false);
        this.overallSeries = new JetBoolean(this, "OverallSeries", true);
        this.overallSeries.enableAllChangeBys(false);
        this.exportToText.set(false);
        this.exportToXML.set(false);
        this.categoryDataMappingFile = new JetString(this, "CategoryDataMappingFile");
        this.categoryDataMappingFile.enableAllChangeBys(false);
        this.categoryDataMappingFile.setEditorType(JetString.COMBO_EDITOR);
        this.seriesDataMappingFile = new JetString(this, "SeriesDataMappingFile");
        this.seriesDataMappingFile.enableAllChangeBys(false);
        this.seriesDataMappingFile.setEditorType(JetString.COMBO_EDITOR);
        this.CHOICE_EDITOR = new JetString(this, "DetailFieldsTargetFrame");
        this.CHOICE_EDITOR.set(String.valueOf(4));
        this.COMBO_EDITOR = new JetString(this, "DetailFieldsCusTargetFrame");
        this.COMBO_EDITOR.enableAllChangeBys(false);
        this.invisibleInBrowserFilterDialog = new JetBoolean(this, "InvisibleInBFDlg", false);
        this.invisibleInBrowserFilterDialog.enableAllChangeBys(false);
        this.indexInBrowseFilterDialog = new JetNumber(this, "IndexInBFDlg", 0);
        this.indexInBrowseFilterDialog.enableAllChangeBys(false);
    }

    public JetRptChartPlatform() {
        this(new ChartDefinition());
    }

    private JetRptChartPlatform(JetChartCreateInfos jetChartCreateInfos) {
        this(jetChartCreateInfos.getChartDefinition());
        this.dataSet.setObject(jetChartCreateInfos.getDataset());
        Hashtable hashtable = jetChartCreateInfos.getTitles();
        this.CHART_FILTER_EDITOR_NO_DATE(hashtable);
        ObjectLogicFactory.getDataContainerLogic().setIExpression(this, jetChartCreateInfos.getExpression());
    }

    private void CHART_FILTER_EDITOR_NO_DATE(Hashtable hashtable) {
        String string = (String)hashtable.get(1);
        String string2 = (String)hashtable.get(2);
        String string3 = (String)hashtable.get(3);
        String string4 = (String)hashtable.get(4);
        if (string != null) {
            this.WHITE(1, string);
        }
        if (string2 != null) {
            this.WHITE(2, string2);
        }
        if (string3 != null) {
            this.WHITE(3, string3);
        }
        if (string4 != null) {
            this.WHITE(4, string4);
        }
    }

    public JetRptChartPlatform(ChartDefinition chartDefinition) {
        this.CHART_FILTER_EDITOR();
        this.setTemplateIndex(71);
        this.definition = new JetChartDefinition(this, chartDefinition);
        this.isBVData.set(chartDefinition.isBVData());
        Vector vector = ReportFormat.getMoreFormat(12, 0);
        this.grpValueFormat.setList(vector);
        this.grpValueFormat.set((String)vector.elementAt(0));
        this.serGrpValueFormat.setList(vector);
        this.serGrpValueFormat.set((String)vector.elementAt(0));
        this.CHART_PATTERN_LIST_EDITOR();
        this.sortCategory.set("None");
        this.sortSeries.set("None");
        this.categoryFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.motionFieldFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.seriesFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.primaryDataFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.secondaryDataFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.hintFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.hintPercentFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.patternList.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.cache.setCanChangeByOthers(false);
        this.CHART_PATTERN_LIST_EDITOR.set(chartDefinition.toShowValuesGotoDetailFieldsString());
        this.CHOICE_EDITOR.set(chartDefinition.toShowValuesGotoDetailTargetString());
        this.COMBO_EDITOR.set(chartDefinition.toShowValuesGotoDetailFrameString());
    }

    private void CHART_PATTERN_LIST_EDITOR() {
        this.iNHeight = JetRptChartPlatform.convertSize(335);
        this.iNWidth = JetRptChartPlatform.convertSize(500);
        this.patternList.set(JetChartPropertyValues.getDefaultPatternString());
        this.background.borderStyle.set("Solid");
        Vector<String> vector = new Vector<String>();
        vector.add("10.00%");
        this.hintPercentFilter.set(vector);
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.height.setUnitValue(JetRptChartPlatform.convertSize(335));
        this.width.setUnitValue(JetRptChartPlatform.convertSize(500));
    }

    public ChartDefinition getChartDefinition() {
        ChartDefinition chartDefinition = this.definition.getChartDefinition();
        chartDefinition.setBVData(this.isBVData.get());
        chartDefinition.loadFromShowValuesGotoDetailFieldsString(this.CHART_PATTERN_LIST_EDITOR.get());
        chartDefinition.loadFromShowValuesGotoDetailTargetString(this.CHOICE_EDITOR.get());
        chartDefinition.loadFromShowValuesGotoDetailFrameString(this.COMBO_EDITOR.get());
        return chartDefinition;
    }

    public ChartDataSetModel createFakeData(JetUUniverse jetUUniverse, String[] stringArray, String[] stringArray2) {
        this.model = new ChartDataSetModel();
        double[] dArray = new double[6];
        JetRptChartPaper jetRptChartPaper = this.getPaper();
        if (jetRptChartPaper != null) {
            dArray[0] = jetRptChartPaper.axisX.minValue.doubleValue();
            dArray[1] = jetRptChartPaper.axisX.maxValue.doubleValue();
            dArray[2] = jetRptChartPaper.axisY.minValue.doubleValue();
            dArray[3] = jetRptChartPaper.axisY.maxValue.doubleValue();
            dArray[4] = jetRptChartPaper.axisY2.minValue.doubleValue();
            dArray[5] = jetRptChartPaper.axisY2.maxValue.doubleValue();
        }
        ChartDefinition chartDefinition = this.getChartDefinition();
        this.model.setBulletDataSize(chartDefinition.getDataSplitSize());
        this.model.createFakeData(this.getChartDefinition(), dArray, stringArray, stringArray2);
        if (chartDefinition.isBVData()) {
            this.model.setValuesName(this.getQualifyValueNames(this.getChartDefinition(), jetUUniverse));
        }
        if (ChartDefinition.version >= 257) {
            this.model.setAllShowValue(chartDefinition.getAllShowValues());
            this.model.addValueNames();
            this.model.setOrignValuesName(chartDefinition.getAllShowValues());
            if (chartDefinition.isBVData()) {
                this.model.replaceShowValueNames();
            }
        }
        this.model.setCategoryFilter(JetChartPropertyValues.mapChartDataFilter(this.categoryFilter.get()));
        this.model.setSeriesFilter(JetChartPropertyValues.mapChartDataFilter(this.seriesFilter.get()));
        this.model.setPrimFilter(JetChartPropertyValues.mapChartDataFilter(this.primaryDataFilter.get()));
        this.model.setSecFilter(JetChartPropertyValues.mapChartDataFilter(this.secondaryDataFilter.get()));
        this.model.setHintFilter(JetChartPropertyValues.mapChartDataFilter(this.hintFilter.get()));
        this.model.setHintPercentFilter(JetChartPropertyValues.mapChartDataFilter(this.hintPercentFilter.get()));
        this.model.setReverseCategory(this.reverseCategory.booleanValue());
        this.model.setReverseSeries(this.reverseSeries.booleanValue());
        this.model.setDataWindow(this.categoryStartOffset.intValue(), this.seriesStartOffset.intValue(), this.categoryEndOffset.intValue(), this.seriesEndOffset.intValue());
        this.model.setSwapGroup(this.swapGroup.booleanValue());
        this.model.init();
        return this.model;
    }

    public ChartDataSetModel createFakeData(JetUUniverse jetUUniverse) {
        this.model = new ChartDataSetModel();
        double[] dArray = new double[6];
        JetRptChartPaper jetRptChartPaper = this.getPaper();
        if (jetRptChartPaper != null) {
            dArray[0] = jetRptChartPaper.axisX.minValue.doubleValue();
            dArray[1] = jetRptChartPaper.axisX.maxValue.doubleValue();
            dArray[2] = jetRptChartPaper.axisY.minValue.doubleValue();
            dArray[3] = jetRptChartPaper.axisY.maxValue.doubleValue();
            dArray[4] = jetRptChartPaper.axisY2.minValue.doubleValue();
            dArray[5] = jetRptChartPaper.axisY2.maxValue.doubleValue();
        }
        ChartDefinition chartDefinition = this.getChartDefinition();
        this.model.setBulletDataSize(chartDefinition.getDataSplitSize());
        this.model.createFakeData(this.getChartDefinition(), dArray);
        if (chartDefinition.isBVData()) {
            this.model.setValuesName(this.getQualifyValueNames(this.getChartDefinition(), jetUUniverse));
        }
        if (ChartDefinition.version >= 257) {
            this.model.setAllShowValue(chartDefinition.getAllShowValues());
            this.model.addValueNames();
            this.model.setOrignValuesName(chartDefinition.getAllShowValues());
            if (chartDefinition.isBVData()) {
                this.model.replaceShowValueNames();
            }
        }
        this.model.setCategoryFilter(JetChartPropertyValues.mapChartDataFilter(this.categoryFilter.get()));
        this.model.setSeriesFilter(JetChartPropertyValues.mapChartDataFilter(this.seriesFilter.get()));
        this.model.setPrimFilter(JetChartPropertyValues.mapChartDataFilter(this.primaryDataFilter.get()));
        this.model.setSecFilter(JetChartPropertyValues.mapChartDataFilter(this.secondaryDataFilter.get()));
        this.model.setHintFilter(JetChartPropertyValues.mapChartDataFilter(this.hintFilter.get()));
        this.model.setHintPercentFilter(JetChartPropertyValues.mapChartDataFilter(this.hintPercentFilter.get()));
        this.model.setReverseCategory(this.reverseCategory.booleanValue());
        this.model.setReverseSeries(this.reverseSeries.booleanValue());
        this.model.setDataWindow(this.categoryStartOffset.intValue(), this.seriesStartOffset.intValue(), this.categoryEndOffset.intValue(), this.seriesEndOffset.intValue());
        this.model.setSwapGroup(this.swapGroup.booleanValue());
        this.model.init();
        return this.model;
    }

    private Map COMBO_EDITOR() {
        Hashtable<String, ChartFillPattern> hashtable = new Hashtable<String, ChartFillPattern>();
        Vector vector = this.bindedValues.get();
        ChartFillPattern[] chartFillPatternArray = JetChartPropertyValues.mapPatterns(this.bindedPatterns.get());
        for (int i = 0; i != vector.size(); ++i) {
            if (chartFillPatternArray[i] != null) {
                hashtable.put((String)vector.get(i), chartFillPatternArray[i]);
                continue;
            }
            ChartColorPattern chartColorPattern = new ChartColorPattern();
            chartColorPattern.setNoFill(true);
            hashtable.put((String)vector.get(i), chartColorPattern);
        }
        return hashtable;
    }

    private void CSS_CHART_TYPE(Map map) {
        if (!map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[map.size()];
            this.bindedValues.clear();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.bindedValues.add(string);
                chartFillPatternArray[n] = (ChartFillPattern)map.get(string);
                if (chartFillPatternArray[n] instanceof ChartColorPattern && ((ChartColorPattern)chartFillPatternArray[n]).getNoFill()) {
                    chartFillPatternArray[n] = null;
                }
                ++n;
            }
            this.bindedPatterns.set(JetChartPropertyValues.mapPatternList(chartFillPatternArray));
        }
    }

    public ChartPlatformProperties getChartPlatformProperties() {
        ChartPlatformProperties chartPlatformProperties = new ChartPlatformProperties();
        chartPlatformProperties.setTopMargin(this.topMargin.intValue());
        chartPlatformProperties.setLeftMargin(this.leftMargin.intValue());
        chartPlatformProperties.setRightMargin(this.rightMargin.intValue());
        chartPlatformProperties.setBottomMargin(this.bottomMargin.intValue());
        chartPlatformProperties.setBackground(this.background.getChartBackground());
        chartPlatformProperties.setAutoLayout(this.autoLayout.booleanValue());
        chartPlatformProperties.setShowLegend(this.showLegend.booleanValue());
        chartPlatformProperties.setPatterns(JetChartPropertyValues.mapPatterns(this.patternList.get()));
        chartPlatformProperties.setAntiAliasing(this.antiAliasing.booleanValue());
        chartPlatformProperties.setBindedPatterns(this.COMBO_EDITOR());
        chartPlatformProperties.setBindedLineStyles(this.axisY());
        chartPlatformProperties.setValueMessage(this.getShowValueBehaviourFunctionsAsChartMessageProperties());
        chartPlatformProperties.setChartValProperties(this.getChartValueProperties());
        chartPlatformProperties.setMinTickMarkerSpace(this.minSpaceInTMs.getUnit());
        ChartColorBySummaryProperties chartColorBySummaryProperties = chartPlatformProperties.getColorBySummaryProperty();
        chartColorBySummaryProperties.setStartColor(this.hmGradientStartColor.toUnitString());
        chartColorBySummaryProperties.setEndColor(this.hmGradientEndColor.toUnitString());
        chartColorBySummaryProperties.setReverse(this.hmIsGradientReverse.booleanValue());
        String string = this.hmColorBySummary.get();
        chartColorBySummaryProperties.setSummaryName(string == null ? null : (string.isEmpty() ? null : string));
        chartColorBySummaryProperties.setMapZeroToWhite(this.hmUseColorForZero.booleanValue());
        chartColorBySummaryProperties.setNullValueColor(this.hmColorOfNullValue.get());
        chartColorBySummaryProperties.setZeroValueColor(this.hmColorOfZeroValue.toUnitString());
        chartPlatformProperties.setSizeByLogarithm(this.hmSizeByAlgorithm.intValue());
        chartPlatformProperties.setColorByLogarithm(this.hmColorByAlgorithm.intValue());
        ChartSizeBySummaryProperties chartSizeBySummaryProperties = chartPlatformProperties.getSizeBySummaryProperty();
        string = this.hmSizeBySummary.get();
        chartSizeBySummaryProperties.setSummaryName(string == null ? null : (string.isEmpty() ? null : string));
        chartPlatformProperties.setIsOverallSeries(this.overallSeries.booleanValue());
        return chartPlatformProperties;
    }

    public void setChartPlatformProperties(ChartPlatformProperties chartPlatformProperties) {
        this.topMargin.set((int)chartPlatformProperties.getTopMargin());
        this.leftMargin.set((int)chartPlatformProperties.getLeftMargin());
        this.rightMargin.set((int)chartPlatformProperties.getRightMargin());
        this.bottomMargin.set((int)chartPlatformProperties.getBottomMargin());
        this.background.setChartBackground(chartPlatformProperties.getBackground());
        this.autoLayout.set(chartPlatformProperties.isAutoLayout());
        this.showLegend.set(chartPlatformProperties.isShowLegend());
        this.patternList.set(JetChartPropertyValues.mapPatternList(chartPlatformProperties.getPatterns()));
        this.CSS_CHART_TYPE(chartPlatformProperties.getBindedPatterns());
        this.antiAliasing.set(chartPlatformProperties.isAntiAliasing());
        this.axisY2(chartPlatformProperties.getBindedLineStyles());
        this.setChartValueProperties(chartPlatformProperties.getChartValProperties());
        this.minSpaceInTMs.setUnitValue(chartPlatformProperties.getMinTickMarkerSpace());
        ChartColorBySummaryProperties chartColorBySummaryProperties = chartPlatformProperties.getColorBySummaryProperty();
        this.hmGradientStartColor.set(chartColorBySummaryProperties.getStartColorObject());
        this.hmGradientEndColor.set(chartColorBySummaryProperties.getEndColorObject());
        this.hmIsGradientReverse.set(chartColorBySummaryProperties.getReverse());
        String string = chartColorBySummaryProperties.getSummaryName();
        this.hmColorBySummary.set(string == null ? "" : string);
        this.hmUseColorForZero.set(chartColorBySummaryProperties.getMapZeroToWhite());
        this.hmColorOfNullValue.set(chartColorBySummaryProperties.getNullValueColor());
        this.hmColorOfZeroValue.set(chartColorBySummaryProperties.getZeroValueColor());
        this.hmSizeByAlgorithm.set(chartPlatformProperties.getSizeByLogarithm());
        this.hmColorByAlgorithm.set(chartPlatformProperties.getColorByLogarithm());
        ChartSizeBySummaryProperties chartSizeBySummaryProperties = chartPlatformProperties.getSizeBySummaryProperty();
        string = chartSizeBySummaryProperties.getSummaryName();
        this.hmSizeBySummary.set(string == null ? "" : string);
        this.overallSeries.set(chartPlatformProperties.getIsOverallSeries());
        JetRptChartPlatform.applyViewLogic(this);
    }

    protected final Vector getShowValueBehaviourFunctionsAsChartMessageProperties() {
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(false);
        if (jetRptChartShowValueFuncContainer == null) {
            return new Vector();
        }
        return jetRptChartShowValueFuncContainer.getAllBehaviourFunctionsAsChartMessageProperties();
    }

    protected final void setShowValueBehaviourFunctionsAsChartMessageProperties(Vector vector) {
        if (vector == null || vector.size() == 0) {
            JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(false);
            if (jetRptChartShowValueFuncContainer != null) {
                jetRptChartShowValueFuncContainer.setBehaviourFunctionsAsChartMessageProperties(null, null);
            }
        } else {
            JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(true);
            List list = this.getChartDefinition().getShowValueInfoList();
            Vector<Integer> vector2 = new Vector<Integer>(vector.size());
            for (ChartMessageProperties chartMessageProperties : vector) {
                int n = 0;
                for (ChartShowValueInfo chartShowValueInfo : list) {
                    if (chartShowValueInfo.getChartType() != chartMessageProperties.getChartType() || chartShowValueInfo.getValueType() != Integer.parseInt(chartMessageProperties.getOrignValueNames()[0]) || !chartShowValueInfo.getValueOrignName().equalsIgnoreCase(chartMessageProperties.getOrignValueNames()[2])) continue;
                    n = chartShowValueInfo.getAixsType();
                    break;
                }
                vector2.add(n);
            }
            jetRptChartShowValueFuncContainer.setBehaviourFunctionsAsChartMessageProperties(vector, vector2);
        }
    }

    public JetRptChartPaper getPaper() {
        return (JetRptChartPaper)this.SEDU(72);
    }

    public JetRptChartLegend getLegend() {
        JetRptChartLegend jetRptChartLegend = (JetRptChartLegend)this.SEDU(70);
        if (jetRptChartLegend == null) {
            jetRptChartLegend = (JetRptChartLegend)this.SEDU(80);
        }
        return jetRptChartLegend;
    }

    private JRObjectTemplate SEDU(int n) {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        for (Object e : vector) {
            if (!(e instanceof JRObjectTemplate) || ((JRObjectTemplate)e).getObjectType() != n) continue;
            jRObjectTemplate = (JRObjectTemplate)e;
            break;
        }
        return jRObjectTemplate;
    }

    public List getLabels() {
        Vector vector = this.getChildren();
        ArrayList<JRObjectTemplate> arrayList = new ArrayList<JRObjectTemplate>();
        JRObjectTemplate jRObjectTemplate = null;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JRObjectTemplate) || (jRObjectTemplate = (JRObjectTemplate)e).getObjectType() != 69) continue;
            arrayList.add(jRObjectTemplate);
        }
        return arrayList;
    }

    @Override
    public String getInstancePrefix() {
        return "ChartObject";
    }

    public ChartDefinition getDefinition() {
        ChartDefinition chartDefinition = this.definition.getChartDefinition();
        chartDefinition.setBVData(this.isBVData.booleanValue());
        chartDefinition.loadFromShowValuesGotoDetailFieldsString(this.CHART_PATTERN_LIST_EDITOR.get());
        return chartDefinition;
    }

    public void setDefinition(ChartDefinition chartDefinition) {
        this.definition = new JetChartDefinition(this, chartDefinition);
        this.isBVData.set(chartDefinition.isBVData());
        this.getPaper().bulletChartData.set(chartDefinition.getDataSplitSize());
        this.CHART_PATTERN_LIST_EDITOR.set(chartDefinition.toShowValuesGotoDetailFieldsString());
        this.CHOICE_EDITOR.set(chartDefinition.toShowValuesGotoDetailTargetString());
        this.COMBO_EDITOR.set(chartDefinition.toShowValuesGotoDetailFrameString());
        JetRptChartPlatform.applyViewLogic(this);
    }

    public void setCreateInfos(JetChartCreateInfos jetChartCreateInfos) {
        this.definition = new JetChartDefinition(this, jetChartCreateInfos.getChartDefinition());
        this.isBVData.set(jetChartCreateInfos.getChartDefinition().isBVData());
    }

    public Vector getUserDefinedSummary() {
        return new Vector();
    }

    public String[] getMappingNames() {
        ArrayList<String> arrayList;
        block15: {
            ChartDefinition chartDefinition;
            block16: {
                JetRptChartPaper jetRptChartPaper;
                block14: {
                    chartDefinition = this.getChartDefinition();
                    arrayList = new ArrayList<String>();
                    if (!chartDefinition.isORGChart()) break block14;
                    JetRptChartPaper jetRptChartPaper2 = this.getPaper();
                    if (jetRptChartPaper2 == null) break block15;
                    JetRptChartOrgNode jetRptChartOrgNode = jetRptChartPaper2.getOrgNode();
                    arrayList.add(jetRptChartOrgNode.getParentColumn());
                    arrayList.add(jetRptChartOrgNode.getChildColumn());
                    List list = jetRptChartOrgNode.getAllElements();
                    for (JRObjectTemplate jRObjectTemplate : list) {
                        if (!(jRObjectTemplate instanceof JetRptDBField)) continue;
                        if (chartDefinition.isBVData()) {
                            arrayList.add(((JetRptDBField)jRObjectTemplate).blColumnName.get());
                            continue;
                        }
                        arrayList.add(((JetRptDBField)jRObjectTemplate).getColumnName());
                    }
                    break block15;
                }
                if (!chartDefinition.isHeatMapChart()) break block16;
                String string = this.hmColorBySummary.get();
                if (string != null && string.length() > 0) {
                    arrayList.add(string);
                }
                if ((string = this.hmSizeBySummary.get()) != null && string.length() > 0) {
                    arrayList.add(string);
                }
                if ((jetRptChartPaper = this.getPaper()) == null) break block15;
                JetRptChartGroupRect jetRptChartGroupRect = jetRptChartPaper.getGroupRectangle();
                while (jetRptChartGroupRect != null) {
                    if (chartDefinition.isBVData()) {
                        arrayList.add(jetRptChartGroupRect.blColumnName.get());
                    } else {
                        arrayList.add(jetRptChartGroupRect.sNGroupBy);
                    }
                    JetRptChartGroupRect jetRptChartGroupRect2 = jetRptChartGroupRect.getNextChartGroupRect();
                    if (jetRptChartGroupRect2 == null) {
                        List list = jetRptChartGroupRect.getAllElements();
                        for (JRObjectTemplate jRObjectTemplate : list) {
                            if (!(jRObjectTemplate instanceof JetRptDBField)) continue;
                            if (chartDefinition.isBVData()) {
                                arrayList.add(((JetRptDBField)jRObjectTemplate).blColumnName.get());
                                continue;
                            }
                            arrayList.add(((JetRptDBField)jRObjectTemplate).getColumnName());
                        }
                    }
                    jetRptChartGroupRect = jetRptChartGroupRect2;
                }
                break block15;
            }
            String string = chartDefinition.getSeries();
            String string2 = chartDefinition.getCategory();
            String string3 = chartDefinition.getMotionField();
            String[] stringArray = chartDefinition.getIndexedFieldNames();
            if (string2 != null) {
                arrayList.add(string2);
            }
            if (string != null) {
                arrayList.add(string);
            }
            if (string3 != null) {
                arrayList.add(string3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public int getObjectType() {
        return 71;
    }

    private void WHITE(int n, String string) {
        JetRptChartLabel jetRptChartLabel = new JetRptChartLabel();
        jetRptChartLabel.titleType.set(n);
        jetRptChartLabel.text.set(string);
        jetRptChartLabel.setChartTitleDefaults(n);
        jetRptChartLabel.textStyle.pattern.color.set(new Color(0x555555));
        this.add(jetRptChartLabel);
    }

    public JetRptChartLabel searchChartTitle(int n) {
        JetRptChartLabel jetRptChartLabel = null;
        List list = this.getLabels();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JetRptChartLabel jetRptChartLabel2 = (JetRptChartLabel)list.get(i);
            if (jetRptChartLabel2.titleType.intValue() != n) continue;
            jetRptChartLabel = jetRptChartLabel2;
            break;
        }
        return jetRptChartLabel;
    }

    public static final void applyViewLogic(JetRptObject jetRptObject) {
        String[] stringArray = jetRptObject.getPropNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equalsIgnoreCase("RuntimeSeries") || stringArray[i].equalsIgnoreCase("RuntimeCategory") || stringArray[i].equalsIgnoreCase("RuntimeValue") || stringArray[i].equalsIgnoreCase("GotoDetail") || stringArray[i].equalsIgnoreCase("BulletData") || stringArray[i].equalsIgnoreCase("RuntimeMotion") || stringArray[i].equalsIgnoreCase("RuntimeUniqueKeys")) continue;
            JetProperty jetProperty = jetRptObject.nameToProperty(stringArray[i]);
            ObjectLogicFactory.getViewLogic().setProperty(jetRptObject, jetProperty);
        }
    }

    private void Z(Rectangle rectangle) {
        JetRptChartPaper jetRptChartPaper = this.getPaper();
        boolean bl = false;
        if (jetRptChartPaper != null && jetRptChartPaper.axisX != null) {
            bl = jetRptChartPaper.axisX.scrollableChart.booleanValue();
            if (!bl) {
                return;
            }
            float f = jetRptChartPaper.axisX.displayAreaPercent.intValue();
            f = (100.0f - f) / 100.0f;
            boolean bl2 = this.getChartDefinition().isBenchCoordinateType();
            if (bl2) {
                int n = (int)((float)rectangle.width * (1.0f - f));
                rectangle.x += n;
                rectangle.width -= n;
                rectangle.width = rectangle.width < 0 ? 0 : rectangle.width;
            } else {
                rectangle.height -= (int)((float)rectangle.height * (1.0f - f));
                rectangle.height = rectangle.height < 0 ? 0 : rectangle.height;
            }
        }
    }

    private void add(Rectangle rectangle) {
        int n = ChartTypeInfo.getPrimType(this.getChartDefinition().getChartDataSetInfos()[0].getChartType());
        if (!this.getChartDefinition().isComboChart() && this.getChartDefinition().isMotionChart() && (n == 0 || n == 9 || n == 1)) {
            rectangle.height -= 57;
        }
    }

    boolean scrollBench() {
        boolean bl = false;
        JetRptChartPaper jetRptChartPaper = this.getPaper();
        if (jetRptChartPaper != null && jetRptChartPaper.axisX != null && this.getChartDefinition() != null) {
            bl = jetRptChartPaper.axisX.scrollableChart.booleanValue();
            bl = bl && this.getChartDefinition().isBenchCoordinateType();
        }
        return bl;
    }

    public Rectangle reloadPaperBoundsByLegendPlacement(int n, int n2) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        int n3 = chartPlatformProperties.getBackground().getBorderStyle();
        int n4 = n3 == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n5 = Unit.convertUnitToPixel(this.width.getUnit(), n2) - 2 * n4;
        int n6 = Unit.convertUnitToPixel(this.height.getUnit(), n2) - 2 * n4;
        Rectangle rectangle = new Rectangle(n4, n4, n5, n6);
        this.Z(rectangle);
        this.add(rectangle);
        Rectangle rectangle2 = this.addModeToContainer(this.getPaper(), rectangle, n, n2);
        return rectangle2;
    }

    public Rectangle reloadPaperBoundsByLegendPlacement(int n) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        int n2 = chartPlatformProperties.getBackground().getBorderStyle();
        int n3 = n2 == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n4 = this.width.intValue() - 2 * n3;
        int n5 = this.height.intValue() - 2 * n3;
        Rectangle rectangle = new Rectangle(n3, n3, n4, n5);
        this.Z(rectangle);
        this.add(rectangle);
        Rectangle rectangle2 = this.addValueNames(this.getPaper(), rectangle, n);
        return rectangle2;
    }

    public Rectangle reloadPaperBoundsByShowLegend(boolean bl, int n) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        if (bl) {
            int n2 = this.getLegend().placement.intValue();
            return this.reloadPaperBoundsByLegendPlacement(n2, n);
        }
        int n3 = chartPlatformProperties.getBackground().getBorderStyle();
        int n4 = n3 == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n5 = Unit.convertUnitToPixel(this.width.getUnit(), n) - 2 * n4;
        int n6 = Unit.convertUnitToPixel(this.height.getUnit(), n) - 2 * n4;
        Rectangle rectangle = new Rectangle(n4, n4, n5, n6);
        this.Z(rectangle);
        this.add(rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle.x + 10, rectangle.y + 10, rectangle.width - 20, rectangle.height - 20);
        return rectangle2;
    }

    public Rectangle reloadPaperBoundsByShowLegend(boolean bl) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        if (bl) {
            int n = this.getLegend().placement.intValue();
            return this.reloadPaperBoundsByLegendPlacement(n);
        }
        int n = chartPlatformProperties.getBackground().getBorderStyle();
        int n2 = n == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n3 = this.width.intValue() - 2 * n2;
        int n4 = this.height.intValue() - 2 * n2;
        Rectangle rectangle = new Rectangle(n2, n2, n3, n4);
        this.Z(rectangle);
        this.add(rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle.x + 10, rectangle.y + 10, rectangle.width - 20, rectangle.height - 20);
        return rectangle2;
    }

    private Rectangle addModeToContainer(JetRptChartPaper jetRptChartPaper, Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2 = jetRptChartPaper.getBound();
        int n3 = Unit.convertUnitToPixel(Unit.convertPixelToUnit(rectangle2.x), n2);
        int n4 = Unit.convertUnitToPixel(Unit.convertPixelToUnit(rectangle2.y), n2);
        int n5 = Unit.convertUnitToPixel(Unit.convertPixelToUnit(rectangle2.width), n2);
        int n6 = Unit.convertUnitToPixel(Unit.convertPixelToUnit(rectangle2.height), n2);
        rectangle2.setBounds(n3, n4, n5, n6);
        switch (n) {
            case 2: 
            case 4: {
                rectangle2.setSize((int)((float)(rectangle.width * 12) / 16.0f), (int)((float)(rectangle.height * 15) / 16.0f));
                break;
            }
            case 1: 
            case 3: {
                rectangle2.setSize((int)((float)(rectangle.width * 15) / 16.0f), (int)((float)(rectangle.height * 12) / 16.0f));
                break;
            }
        }
        int n7 = (int)rectangle2.getSize().getWidth();
        int n8 = (int)rectangle2.getSize().getHeight();
        switch (n) {
            case 2: {
                boolean bl = false;
                if (this.getPaper() == null || this.getPaper().axisX == null || this.getChartDefinition() != null) {
                    // empty if block
                }
                if (this.scrollBench()) {
                    rectangle2.setLocation(rectangle.x, rectangle.y + (rectangle.height - n8) / 2);
                    break;
                }
                rectangle2.setLocation((rectangle.x + rectangle.width * 12 / 16 - n7) / 2, rectangle.y + (rectangle.height - n8) / 2);
                break;
            }
            case 4: {
                rectangle2.setLocation(rectangle.x + rectangle.width * 4 / 16 + (rectangle.width * 12 / 16 - n7) / 2, rectangle.y + (rectangle.height - n8) / 2);
                break;
            }
            case 1: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n7) / 2, rectangle.y + rectangle.height * 4 / 16 + (rectangle.height * 12 / 16 - n8) / 2);
                break;
            }
            case 3: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n7) / 2, rectangle.y + (rectangle.height * 12 / 16 - n8) / 2);
                break;
            }
        }
        return rectangle2;
    }

    private Rectangle addValueNames(JetRptChartPaper jetRptChartPaper, Rectangle rectangle, int n) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2 = jetRptChartPaper.getBound();
        switch (n) {
            case 2: 
            case 4: {
                rectangle2.setSize((int)((float)(rectangle.width * 12) / 16.0f), (int)((float)(rectangle.height * 15) / 16.0f));
                break;
            }
            case 1: 
            case 3: {
                rectangle2.setSize((int)((float)(rectangle.width * 15) / 16.0f), (int)((float)(rectangle.height * 12) / 16.0f));
                break;
            }
        }
        int n2 = (int)rectangle2.getSize().getWidth();
        int n3 = (int)rectangle2.getSize().getHeight();
        switch (n) {
            case 2: {
                boolean bl = false;
                if (this.getPaper() == null || this.getPaper().axisX == null || this.getChartDefinition() != null) {
                    // empty if block
                }
                if (this.scrollBench()) {
                    rectangle2.setLocation(rectangle.x, rectangle.y + (rectangle.height - n3) / 2);
                    break;
                }
                rectangle2.setLocation((rectangle.x + rectangle.width * 12 / 16 - n2) / 2, rectangle.y + (rectangle.height - n3) / 2);
                break;
            }
            case 4: {
                rectangle2.setLocation(rectangle.x + rectangle.width * 4 / 16 + (rectangle.width * 12 / 16 - n2) / 2, rectangle.y + (rectangle.height - n3) / 2);
                break;
            }
            case 1: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + rectangle.height * 4 / 16 + (rectangle.height * 12 / 16 - n3) / 2);
                break;
            }
            case 3: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + (rectangle.height * 12 / 16 - n3) / 2);
                break;
            }
        }
        return rectangle2;
    }

    public void setCagegoryGroupInfo(GroupInfo groupInfo) {
        this.categoryGroupInfo.setGroupInfo(groupInfo);
        this.applyViewLogic(groupInfo.getSpecialFunction(), 1);
        this.haveCategorySF.set(groupInfo.getSpecialFunction() != null);
        String string = (String)groupInfo.getGroupFieldInfo().getProperty("Format");
        if (string != null) {
            this.categoryFilter.set(string);
            ObjectLogicFactory.getViewLogic().removeViewProperty(this, this.categoryFilter);
            JetRptChartPaper jetRptChartPaper = this.getPaper();
            if (jetRptChartPaper != null && jetRptChartPaper.axisX.dataMinorFilter.get().size() == 0) {
                jetRptChartPaper.axisX.dataMinorFilter.set(string);
            }
        }
    }

    public void setSeriesGroupInfo(GroupInfo groupInfo) {
        this.seriesGroupInfo.setGroupInfo(groupInfo);
        this.applyViewLogic(groupInfo.getSpecialFunction(), 0);
        this.haveSeriesSF.set(groupInfo.getSpecialFunction() != null);
    }

    public void setMotionGroupInfo(GroupInfo groupInfo) {
        this.motionGroupInfo.setGroupInfo(groupInfo);
        this.applyViewLogic(groupInfo.getSpecialFunction(), 2);
        this.haveMotionSF.set(groupInfo.getSpecialFunction() != null);
    }

    public void clearCategoryGroupInfo() {
        this.categoryGroupInfo.makeToNoGroupInfo();
        this.applyViewLogic(null, 1);
        this.haveCategorySF.set(false);
    }

    public void clearSeriesGroupInfo() {
        this.seriesGroupInfo.makeToNoGroupInfo();
        this.applyViewLogic(null, 0);
        this.haveSeriesSF.set(false);
    }

    public void clearMotionGroupInfo() {
        this.motionGroupInfo.makeToNoGroupInfo();
        this.applyViewLogic(null, 2);
        this.haveMotionSF.set(false);
    }

    public GroupInfo getCategoryGropInfo() {
        GroupInfo groupInfo = this.categoryGroupInfo.getGroupInfo();
        groupInfo.setSpecialFunction(this.antiAliasing(1));
        groupInfo.getGroupFieldInfo().setProperty("Format", this.categoryFilter.toString());
        return groupInfo;
    }

    public GroupInfo getSeriesGropInfo() {
        GroupInfo groupInfo = this.seriesGroupInfo.getGroupInfo();
        groupInfo.setSpecialFunction(this.antiAliasing(0));
        return groupInfo;
    }

    public GroupInfo getMotionGropInfo() {
        GroupInfo groupInfo = this.motionGroupInfo.getGroupInfo();
        groupInfo.setSpecialFunction(this.antiAliasing(2));
        return groupInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (CSS_CHART_TYPE == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (CSS_CHART_TYPE == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("PlatformBackgroundBorderPenTransparency", n++);
                    hashMap.put("CategorySpecialOperators", n++);
                    hashMap.put("AntiAliasing", n++);
                    hashMap.put("BLValue", n++);
                    hashMap.put("Section", n++);
                    hashMap.put("ColumnNumber", n++);
                    hashMap.put("CategorySpecialNames", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageFile", n++);
                    hashMap.put("StyleList", n++);
                    hashMap.put("BLSeries", n++);
                    hashMap.put("CategoryEndOffset", n++);
                    hashMap.put("Cache", n++);
                    hashMap.put("SeriesValueEncoding", n++);
                    hashMap.put("SeriesFilter", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageX", n++);
                    hashMap.put("CategoryOthersName", n++);
                    hashMap.put("GroupValueFormat", n++);
                    hashMap.put("SeriesSelectN", n++);
                    hashMap.put("HaveCategorySpecialFuncation", n++);
                    hashMap.put("RuntimeSeries", n++);
                    hashMap.put("PrimaryDataFilter", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientStyle", n++);
                    hashMap.put("CategorySelectType", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageY", n++);
                    hashMap.put("PlatformBackgroundRight", n++);
                    hashMap.put("CategorySpecialOpNum", n++);
                    hashMap.put("GotoDetail", n++);
                    hashMap.put("SeriesSortOrder", n++);
                    hashMap.put("ZHyperLinkTarget", n++);
                    hashMap.put("PlatformBackgroundLeft", n++);
                    hashMap.put("HyperLinkTarget", n++);
                    hashMap.put("PlatformBackgroundBorderPenStyle", n++);
                    hashMap.put("SeriesSelectType", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientStartY", n++);
                    hashMap.put("PlatformBackgroundBorderPenEndCaps", n++);
                    hashMap.put("HintPercentFilter", n++);
                    hashMap.put("BLCategory", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientStartX", n++);
                    hashMap.put("ExternalTitle", n++);
                    hashMap.put("PlatformBackgroundFillPatternTextureBackColor", n++);
                    hashMap.put("CategorySelectStartPosition", n++);
                    hashMap.put("CategoryKeepOthers", n++);
                    hashMap.put("SeriesStartOffset", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientEndX", n++);
                    hashMap.put("SeriesSpecialOpNum", n++);
                    hashMap.put("PlatformBackgroundBorderPenOutlined", n++);
                    hashMap.put("RowNumber", n++);
                    hashMap.put("SortCategory", n++);
                    hashMap.put("SeriesEndOffset", n++);
                    hashMap.put("SeriesGroupType", n++);
                    hashMap.put("CategorySortBy", n++);
                    hashMap.put("PatternList", n++);
                    hashMap.put("CategorySpecialOperands", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageLayout", n++);
                    hashMap.put("PlatformBackgroundBorderPenThickness", n++);
                    hashMap.put("ChartDefinition", n++);
                    hashMap.put("LeftMargin", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageWidth", n++);
                    hashMap.put("Alt", n++);
                    hashMap.put("PlatformBackgroundBorderPenLineJoint", n++);
                    hashMap.put("BindedPatterns", n++);
                    hashMap.put("NeedCreateChartDataSetModel", n++);
                    hashMap.put("SeriesKeepOthers", n++);
                    hashMap.put("CategorySelectN", n++);
                    hashMap.put("PlatformBackgroundTop", n++);
                    hashMap.put("StyleInherit", n++);
                    hashMap.put("TopMargin", n++);
                    hashMap.put("ReverseSeries", n++);
                    hashMap.put("PlatformBackgroundBorderPenVariabledDash", n++);
                    hashMap.put("SeriesSpecialOperators", n++);
                    hashMap.put("AutoLayout", n++);
                    hashMap.put("SeriesOthersName", n++);
                    hashMap.put("XHyperLinkTarget", n++);
                    hashMap.put("PlatformBackgroundFillPatternImageHeight", n++);
                    hashMap.put("CategoryStartOffset", n++);
                    hashMap.put("CategoryFilter", n++);
                    hashMap.put("MotionFilter", n++);
                    hashMap.put("SecondaryDataFilter", n++);
                    hashMap.put("RuntimeCategory", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientEndY", n++);
                    hashMap.put("IsBVData", n++);
                    hashMap.put("RightMargin", n++);
                    hashMap.put("PlatformBackgroundFillPatternTextureForeColor", n++);
                    hashMap.put("PlatformBackgroundFillPatternTransparency", n++);
                    hashMap.put("PlatformBackgroundFillPatternTextureStyle", n++);
                    hashMap.put("LongDesc", n++);
                    hashMap.put("SwapGroup", n++);
                    hashMap.put("PlatformBackgroundFillPatternType", n++);
                    hashMap.put("SeriesSpecialOperands", n++);
                    hashMap.put("BindedValues", n++);
                    hashMap.put("ZHyperLink", n++);
                    hashMap.put("PlatformBackgroundBottom", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientStartColor", n++);
                    hashMap.put("SeriesSortBy", n++);
                    hashMap.put("PlatformBackgroundFillPatternColor", n++);
                    hashMap.put("BottomMargin", n++);
                    hashMap.put("SortSeries", n++);
                    hashMap.put("SeriesGroupOrder", n++);
                    hashMap.put("HintFilter", n++);
                    hashMap.put("CategoryGroupOrder", n++);
                    hashMap.put("ShowLegend", n++);
                    hashMap.put("PlatformBackgroundBorderStyle", n++);
                    hashMap.put("PlatformBackgroundFillPatternGradientEndColor", n++);
                    hashMap.put("HyperLink", n++);
                    hashMap.put("HaveSeriesSpecialFuncation", n++);
                    hashMap.put("PlatformBackgroundBorderPenColor", n++);
                    hashMap.put("Interactive", n++);
                    hashMap.put("SeriesSpecialNames", n++);
                    hashMap.put("CategorySortOrder", n++);
                    hashMap.put("BoundDataContainer", n++);
                    hashMap.put("SeriesSelectStartPosition", n++);
                    hashMap.put("ReverseCategory", n++);
                    hashMap.put("RuntimeValue", n++);
                    hashMap.put("SameLevel", n++);
                    hashMap.put("XHyperLink", n++);
                    hashMap.put("CategoryGroupType", n++);
                    hashMap.put("TitleObject", n++);
                    hashMap.put("LogicColumn", n++);
                    hashMap.put("DetailFields", n++);
                    hashMap.put("PlatformBackgroundBorderPenLineJointRadius", n++);
                    hashMap.put("SeriesSkip", n++);
                    hashMap.put("CategorySkip", n++);
                    hashMap.put("BindedLineStyles", n++);
                    hashMap.put("BindedLineValues", n++);
                    hashMap.put("RunInFlash", n++);
                    hashMap.put("RuntimeMotion", n++);
                    hashMap.put("HaveMotionSpecialFuncation", n++);
                    hashMap.put("MotionSortOrder", n++);
                    hashMap.put("MotionGroupType", n++);
                    hashMap.put("MotionSelectN", n++);
                    hashMap.put("MotionSpecialOpNum", n++);
                    hashMap.put("MotionSelectStartPosition", n++);
                    hashMap.put("MotionSelectType", n++);
                    hashMap.put("MotionKeepOthers", n++);
                    hashMap.put("MotionSpecialNames", n++);
                    hashMap.put("MotionSpecialOperands", n++);
                    hashMap.put("MotionGroupOrder", n++);
                    hashMap.put("MotionSortBy", n++);
                    hashMap.put("MotionSkip", n++);
                    hashMap.put("MotionSpecialOperators", n++);
                    hashMap.put("MotionOthersName", n++);
                    hashMap.put("RuntimeUniqueKeys", n++);
                    hashMap.put("HMChartGradientStartColor", n++);
                    hashMap.put("HMChartGradientEndColor", n++);
                    hashMap.put("HMChartGradientIsReverse", n++);
                    hashMap.put("HMChartSizeByAlgorithm", n++);
                    hashMap.put("HMChartColorByAlgorithm", n++);
                    hashMap.put("HMChartColorBySummary", n++);
                    hashMap.put("HMChartSizeBySummary", n++);
                    hashMap.put("RuntimeHMChartColorBySummary", n++);
                    hashMap.put("RuntimeHMChartSizeBySummary", n++);
                    hashMap.put("HMUseColorForZero", n++);
                    hashMap.put("HMColorOfNullValue", n++);
                    hashMap.put("HMColorOfZeroValue", n++);
                    hashMap.put("OverallSeries", n++);
                    hashMap.put("CategoryDataMappingFile", n++);
                    hashMap.put("SeriesDataMappingFile", n++);
                    hashMap.put("DetailFieldsTargetFrame", n++);
                    hashMap.put("DetailFieldsCusTargetFrame", n++);
                    hashMap.put("InvisibleInBFDlg", n++);
                    hashMap.put("IndexInBFDlg", n++);
                    CSS_CHART_TYPE = hashMap;
                }
            }
        }
        return CSS_CHART_TYPE;
    }

    @Override
    public HashVector getPropertyGroups() {
        ChartDefinition chartDefinition;
        HashVector hashVector = super.getPropertyGroups();
        if (this.bEditable && hashVector != null && (chartDefinition = this.getChartDefinition()) != null && chartDefinition.isHeatMapChart()) {
            JetRptChartPaper jetRptChartPaper = this.getPaper();
            JetRptChartGroupRect jetRptChartGroupRect = jetRptChartPaper.getGroupRectangle();
            if (jetRptChartGroupRect == null) {
                return hashVector;
            }
            String string = this.hmColorBySummary.get();
            boolean bl = false;
            while (jetRptChartGroupRect != null) {
                if (jetRptChartGroupRect.isDoColorBy.booleanValue()) {
                    bl = true;
                    break;
                }
                jetRptChartGroupRect = jetRptChartGroupRect.getNextChartGroupRect();
            }
            if (string == null || string.isEmpty()) {
                if (bl) {
                    this.patternList.setEditFlag(2);
                } else {
                    this.patternList.setEditFlag(2);
                }
                this.hmGradientStartColor.setEditFlag(0);
                this.hmGradientEndColor.setEditFlag(0);
                this.hmIsGradientReverse.setEditFlag(0);
                this.hmUseColorForZero.setEditFlag(0);
                this.hmColorOfNullValue.setEditFlag(0);
                this.hmColorOfZeroValue.setEditFlag(0);
            } else {
                boolean bl2;
                if (bl) {
                    this.patternList.setEditFlag(2);
                } else {
                    this.patternList.setEditFlag(0);
                }
                JetRptChartShowValueFunc jetRptChartShowValueFunc = this.background(true, null);
                boolean bl3 = jetRptChartShowValueFunc == null ? true : (bl2 = !jetRptChartShowValueFunc.isHaveFillColorFunctionInLogical());
                if (bl2) {
                    this.hmGradientStartColor.setEditFlag(2);
                    this.hmGradientEndColor.setEditFlag(2);
                    this.hmIsGradientReverse.setEditFlag(2);
                    this.hmUseColorForZero.setEditFlag(2);
                    this.hmColorOfNullValue.setEditFlag(2);
                    this.hmColorOfZeroValue.setEditFlag(2);
                } else {
                    this.hmGradientStartColor.setEditFlag(0);
                    this.hmGradientEndColor.setEditFlag(0);
                    this.hmIsGradientReverse.setEditFlag(0);
                    this.hmUseColorForZero.setEditFlag(0);
                    this.hmColorOfNullValue.setEditFlag(0);
                    this.hmColorOfZeroValue.setEditFlag(0);
                }
            }
        }
        return hashVector;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            ChartDefinition chartDefinition = this.getChartDefinition();
            if (chartDefinition != null) {
                if (chartDefinition.isORGChart()) {
                    if (WHITE != null) {
                        return WHITE;
                    }
                    WHITE = JetRptChartPlatform.duplicatePropGrpsDesc(this.alt());
                    String string = "Platform";
                    WHITE.remove(string);
                    string = "Data";
                    WHITE.remove(string);
                    return WHITE;
                }
                if (chartDefinition.isHeatMapChart()) {
                    if (Z != null) {
                        return Z;
                    }
                    Z = JetRptChartPlatform.duplicatePropGrpsDesc(this.alt());
                    String string = "Platform";
                    List list = (List)Z.get(string);
                    list.add("HMChartGradientStartColor");
                    list.add("HMChartGradientEndColor");
                    list.add("HMChartGradientIsReverse");
                    list.add("HMUseColorForZero");
                    list.add("HMColorOfZeroValue");
                    list.add("HMColorOfNullValue");
                    string = "Data";
                    list = (List)Z.get(string);
                    list.clear();
                    list.add("HMChartSizeByAlgorithm");
                    list.add("HMChartColorByAlgorithm");
                    return Z;
                }
                return this.alt();
            }
            return this.alt();
        }
        return null;
    }

    private HashVector alt() {
        if (SEDU != null) {
            return SEDU;
        }
        SEDU = JetRptChartPlatform.duplicatePropGrpsDesc(super.getPropGrpsDesc());
        if (SEDU == null) {
            SEDU = new HashVector();
        }
        String string = "Color";
        SEDU.remove(string);
        string = "Border";
        SEDU.remove(string);
        string = "Others";
        List<String> list = (Vector<String>)SEDU.get(string);
        list.remove("RecordLocation");
        list.add("Cache");
        list.add("Alt");
        list.add("LogicColumn");
        list.remove("ExportToCSV");
        list.add("ExportToHTML");
        list.add("ExportToPDF");
        list.add("ExportToRTF");
        list.add("ExportToPostScript");
        list.add("ExportToApplet");
        list.add("InvisibleInBFDlg");
        list.add("IndexInBFDlg");
        string = "Excel";
        list = (List)SEDU.get(string);
        list.add("ColumnNumber");
        list.add("RowNumber");
        string = "TOC";
        list = new Vector<String>();
        SEDU.put(string, list);
        list.add("TOCAnchor");
        list.add("AnchorDispValue");
        string = "Platform";
        list = new Vector(4);
        SEDU.put(string, list);
        list.add("ShowLegend");
        list.add("AntiAliasing");
        list.add("PatternList");
        list.add("MinSpaceInTickMarks");
        string = "Background";
        list = new Vector(32);
        SEDU.put(string, list);
        list.add("PlatformBackgroundBorderStyle");
        list.add("PlatformBackgroundBorderPenStyle");
        list.add("PlatformBackgroundBorderPenColor");
        list.add("PlatformBackgroundBorderPenTransparency");
        list.add("PlatformBackgroundBorderPenThickness");
        list.add("PlatformBackgroundBorderPenEndCaps");
        list.add("PlatformBackgroundBorderPenLineJoint");
        list.add("PlatformBackgroundBorderPenOutlined");
        list.add("PlatformBackgroundBorderPenLineJointRadius");
        list.add("PlatformBackgroundBorderPenVariabledDash");
        list.add("PlatformBackgroundFillPatternType");
        list.add("PlatformBackgroundFillPatternTransparency");
        list.add("PlatformBackgroundFillPatternColor");
        list.add("PlatformBackgroundFillPatternTextureStyle");
        list.add("PlatformBackgroundFillPatternTextureForeColor");
        list.add("PlatformBackgroundFillPatternTextureBackColor");
        list.add("PlatformBackgroundFillPatternGradientStyle");
        list.add("PlatformBackgroundFillPatternGradientStartColor");
        list.add("PlatformBackgroundFillPatternGradientEndColor");
        list.add("PlatformBackgroundFillPatternGradientStartX");
        list.add("PlatformBackgroundFillPatternGradientStartY");
        list.add("PlatformBackgroundFillPatternGradientEndX");
        list.add("PlatformBackgroundFillPatternGradientEndY");
        list.add("PlatformBackgroundFillPatternImageFile");
        list.add("PlatformBackgroundFillPatternImageLayout");
        list.add("PlatformBackgroundFillPatternImageX");
        list.add("PlatformBackgroundFillPatternImageY");
        list.add("PlatformBackgroundFillPatternImageWidth");
        list.add("PlatformBackgroundFillPatternImageHeight");
        list.add("PlatformBackgroundTop");
        list.add("PlatformBackgroundLeft");
        list.add("PlatformBackgroundRight");
        list.add("PlatformBackgroundBottom");
        string = "Data";
        list = new Vector(26);
        list.add("SortCategory");
        list.add("SortSeries");
        list.add("ReverseCategory");
        list.add("ReverseSeries");
        list.add("CategoryStartOffset");
        list.add("CategoryEndOffset");
        list.add("SeriesStartOffset");
        list.add("SeriesEndOffset");
        list.add("CategoryFilter");
        list.add("MotionFilter");
        list.add("SeriesFilter");
        list.add("PrimaryDataFilter");
        list.add("SecondaryDataFilter");
        list.add("HintFilter");
        list.add("GotoDetail");
        list.add("HyperLink");
        list.add("XHyperLink");
        list.add("ZHyperLink");
        list.add("GroupValueFormat");
        list.add("SeriesValueEncoding");
        list.add("SwapGroup");
        list.add("HyperLinkTarget");
        list.add("XHyperLinkTarget");
        list.add("ZHyperLinkTarget");
        list.add("HintPercentFilter");
        list.add("OverallSeries");
        list.add("CategoryDataMappingFile");
        list.add("SeriesDataMappingFile");
        SEDU.put(string, list);
        string = "Accessibility";
        list = (List)SEDU.get(string);
        list.add("LongDesc");
        list.add("ExternalTitle");
        list.add("ExternalID");
        SEDU.remove(string);
        SEDU.put(string, list);
        return SEDU;
    }

    public SpecialFunction getCategorySpecialFunction() {
        return this.antiAliasing(1);
    }

    public SpecialFunction getSeriesSpecialFunction() {
        return this.antiAliasing(0);
    }

    public SpecialFunction getMotionFieldSpecialFunction() {
        return this.antiAliasing(2);
    }

    private SpecialFunction antiAliasing(int n) {
        int n2 = this.append(n);
        if (n2 < 0) {
            return null;
        }
        return (SpecialFunction)this.getChildren().get(n2);
    }

    private int append(int n) {
        Vector vector = this.getChildren();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof SpecialFunction)) continue;
            if (n2 == 0) {
                n3 = i;
            } else if (n2 == 1) {
                n4 = i;
            } else if (n2 == 2) {
                n5 = i;
            }
            ++n2;
        }
        if (n == 0 && this.haveSeriesSF.get()) {
            return n3;
        }
        if (n == 1 && this.haveCategorySF.get()) {
            if (n4 == -1) {
                return n3;
            }
            return n4;
        }
        if (n == 2 && this.haveMotionSF.get()) {
            if (n5 != -1) {
                return n5;
            }
            if (n4 != -1) {
                return n4;
            }
            return n3;
        }
        return -1;
    }

    private void applyViewLogic(SpecialFunction specialFunction, int n) {
        int n2 = this.append(0);
        int n3 = this.append(1);
        int n4 = this.append(2);
        int n5 = -1;
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof SpecialFunction)) continue;
            n5 = i;
            break;
        }
        if (n == 0) {
            if (n2 >= 0) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)this.getChildren().get(n2));
                --n3;
                --n4;
            }
            JetObject jetObject = null;
            JetObject jetObject2 = null;
            if (n3 >= 0) {
                jetObject = (JetObject)this.getChildren().remove(n3);
                --n4;
            }
            if (n4 >= 0) {
                jetObject2 = (JetObject)this.getChildren().remove(n4);
            }
            if (specialFunction != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction), n5);
                ++n5;
            }
            if (jetObject != null) {
                this.getChildren().add(n5, jetObject);
                ++n5;
            }
            if (jetObject2 != null) {
                this.getChildren().add(n5, jetObject2);
                ++n5;
            }
        } else if (n == 1) {
            JetObject jetObject = null;
            JetObject jetObject3 = null;
            if (n2 >= 0) {
                jetObject = (JetObject)this.getChildren().remove(n2);
                --n3;
                --n4;
            }
            if (n3 >= 0) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)this.getChildren().get(n3));
                --n4;
            }
            if (n4 >= 0) {
                jetObject3 = (JetObject)this.getChildren().remove(n4);
            }
            if (jetObject != null) {
                this.getChildren().add(n5, jetObject);
                ++n5;
            }
            if (specialFunction != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction), n5);
                ++n5;
            }
            if (jetObject3 != null) {
                this.getChildren().add(n5, jetObject3);
            }
        } else if (n == 2) {
            JetObject jetObject = null;
            JetObject jetObject4 = null;
            if (n2 >= 0) {
                jetObject4 = (JetObject)this.getChildren().remove(n2);
                --n3;
                --n4;
            }
            if (n3 >= 0) {
                jetObject = (JetObject)this.getChildren().remove(n3);
                --n4;
            }
            if (n4 >= 0) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)this.getChildren().get(n4));
            }
            if (jetObject4 != null) {
                this.getChildren().add(n5, jetObject4);
                ++n5;
            }
            if (jetObject != null) {
                this.getChildren().add(n5, jetObject);
                ++n5;
            }
            if (specialFunction != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction), n5);
                ++n5;
            }
        }
    }

    public void setCreateInfoAndDataSet(JetChartCreateInfos jetChartCreateInfos) {
        this.setCreateInfos(jetChartCreateInfos);
        this.dataSet.setObject(jetChartCreateInfos.getDataset());
    }

    public String[] getCategoryAndSeriesDisplayName(JetUUniverse jetUUniverse) {
        String[] stringArray = null;
        ChartDefinition chartDefinition = this.getChartDefinition();
        if (this.isBVData.booleanValue()) {
            String string;
            stringArray = new String[2];
            String string2 = chartDefinition.getCategory();
            if (string2 != null) {
                stringArray[0] = this.axisX(string2, this, jetUUniverse);
            }
            if ((string = chartDefinition.getSeries()) != null) {
                stringArray[1] = this.axisX(string, this, jetUUniverse);
            }
        }
        return stringArray;
    }

    public String[] getCategoryAndSeriesDisplayName(Scope scope) {
        String[] stringArray = null;
        ChartDefinition chartDefinition = this.getChartDefinition();
        if (this.isBVData.booleanValue()) {
            String string;
            stringArray = new String[2];
            String string2 = chartDefinition.getCategory();
            if (string2 != null) {
                stringArray[0] = this.autoLayout(string2, this, scope);
            }
            if ((string = chartDefinition.getSeries()) != null) {
                stringArray[1] = this.autoLayout(string, this, scope);
            }
        }
        return stringArray;
    }

    public String getMotionDisplayName(JetUUniverse jetUUniverse) {
        String string;
        String string2 = "";
        ChartDefinition chartDefinition = this.getChartDefinition();
        if (this.isBVData.booleanValue() && (string = chartDefinition.getMotionField()) != null) {
            string2 = this.axisX(string, this, jetUUniverse);
        }
        return string2;
    }

    public String getMotionDisplayName(Scope scope) {
        String string;
        String string2 = "";
        ChartDefinition chartDefinition = this.getChartDefinition();
        if (this.isBVData.booleanValue() && (string = chartDefinition.getMotionField()) != null) {
            string2 = this.autoLayout(string, this, scope);
        }
        return string2;
    }

    @Override
    public JetRptTitleTextField getTitleObject() {
        return (JetRptTitleTextField)this.CHART_FILTER_EDITOR.getObject();
    }

    @Override
    public void setTitleObject(JetRptTitleTextField jetRptTitleTextField) {
        this.CHART_FILTER_EDITOR.setObject(jetRptTitleTextField);
    }

    @Override
    public void clearTitleObject() {
        this.CHART_FILTER_EDITOR.set(null);
    }

    public String[] getQualifyValueNames(ChartDefinition chartDefinition, Scope scope) {
        String[] stringArray = chartDefinition.getIndexedValueNames();
        if (chartDefinition.isBVData()) {
            if (stringArray == null) {
                return null;
            }
            int n = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = this.autoLayout(stringArray[i], this, scope);
            }
            return stringArray2;
        }
        return stringArray;
    }

    public String[] getQualifyValueNames(ChartDefinition chartDefinition, JetUUniverse jetUUniverse) {
        String[] stringArray = chartDefinition.getIndexedValueNames();
        if (chartDefinition.isBVData()) {
            if (stringArray == null) {
                return null;
            }
            int n = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = this.axisX(stringArray[i], this, jetUUniverse);
            }
            return stringArray2;
        }
        return stringArray;
    }

    private String autoLayout(String string, JetRptChartPlatform jetRptChartPlatform, Scope scope) {
        if (string == null) {
            return null;
        }
        DataSet dataSet = ReportTools.getDataSet(jetRptChartPlatform);
        if (dataSet == null) {
            return string;
        }
        DataElementInfo dataElementInfo = (DataElementInfo)scope.getBLNodeByQualifiedDisplayName(string);
        if (dataElementInfo == null) {
            return null;
        }
        return dataElementInfo.getDisplayName();
    }

    private String axisX(String string, JetRptChartPlatform jetRptChartPlatform, JetUUniverse jetUUniverse) {
        if (string == null) {
            return null;
        }
        DataSet dataSet = ReportTools.getDataSet(jetRptChartPlatform);
        if (dataSet == null) {
            return string;
        }
        Scope scope = new Scope(ObjectLogicFactory.getBasicComponentLogic().getIReportOf(jetRptChartPlatform), jetUUniverse, dataSet.getDataSourceName(), dataSet.getQueryName(), dataSet.getBlName(), dataSet.getDataResourceType());
        DataElementInfo dataElementInfo = (DataElementInfo)scope.getBLNodeByQualifiedDisplayName(string);
        if (dataElementInfo == null) {
            return null;
        }
        return dataElementInfo.getDisplayName();
    }

    private Map axisY() {
        Hashtable hashtable = new Hashtable();
        Vector vector = this.bindedLineValues.get();
        Vector vector2 = this.bindedLineStyles.get();
        ChartLineStyle[] chartLineStyleArray = new ChartLineStyle[vector2.size()];
        if (vector != null && vector.size() > 0) {
            int n;
            int n2 = 1;
            int n3 = 9;
            int n4 = 2;
            for (n = 0; n < vector2.size(); ++n) {
                n2 = 1;
                n3 = 9;
                n4 = 2;
                String[] stringArray = vector2.get(n).toString().split(",");
                if (stringArray != null) {
                    n2 = Integer.parseInt(stringArray[0]);
                    n3 = Integer.parseInt(stringArray[1]);
                    if (stringArray.length > 2) {
                        n4 = ValueToUnit.convertUnitToPixel((int)Double.parseDouble(stringArray[2]));
                    }
                } else {
                    n2 = 1;
                    n3 = 0;
                    n4 = ValueToUnit.convertUnitToPixel(180);
                }
                chartLineStyleArray[n] = new ChartLineStyle(n2, n3, n4);
            }
            for (n = 0; n != vector.size(); ++n) {
                hashtable.put(vector.get(n), chartLineStyleArray[n]);
            }
        }
        return hashtable;
    }

    private void axisY2(Map map) {
        if (!map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            ChartLineStyle[] chartLineStyleArray = new ChartLineStyle[map.size()];
            this.bindedLineValues.clear();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.bindedLineValues.add(string);
                chartLineStyleArray[n] = (ChartLineStyle)map.get(string);
                this.bindedLineStyles.set(chartLineStyleArray[n].getCureType() + "," + chartLineStyleArray[n].getPenStyleType() + "," + (int)ValueToUnit.convertPixelToUnit(chartLineStyleArray[n].getPenWidth()));
                ++n;
            }
        }
    }

    protected static void setMessageProperties(JetQualifyReference jetQualifyReference, JetRptObject jetRptObject, Vector vector) {
        RptMode rptMode = (RptMode)jetQualifyReference.getObject();
        if (vector == null || vector.size() == 0) {
            if (rptMode != null) {
                RptRenderer rptRenderer = JetRptChartPlatform.bEditable(jetQualifyReference, rptMode);
                ObjectLogicFactory.getModeRendererLogic().resetEventActionListOfRender(rptRenderer, null);
            }
        } else {
            boolean bl = rptMode == null;
            RptRenderer rptRenderer = JetRptChartPlatform.bEditable(jetQualifyReference, rptMode);
            ObjectLogicFactory.getModeRendererLogic().resetEventActionListOfRender(rptRenderer, vector);
            if (bl) {
                ObjectLogicFactory.getModeRendererLogic().addModeToContainer(jetRptObject);
            }
        }
    }

    private static RptRenderer bEditable(JetQualifyReference jetQualifyReference, RptMode rptMode) {
        RptRenderer rptRenderer = null;
        if (rptMode == null) {
            rptMode = ObjectLogicFactory.getModeRendererLogic().createMode(16);
            jetQualifyReference.setObject(rptMode);
            rptRenderer = rptMode.getCurrentRender();
        } else if (((JetObject)((Object)rptMode)).getRefObjects().size() == 1) {
            rptRenderer = rptMode.getCurrentRender();
        } else {
            RptMode rptMode2 = (RptMode)((Object)((JetObject)((Object)rptMode)).deepDup());
            jetQualifyReference.setObject(rptMode2);
            ObjectLogicFactory.getBasicComponentLogic().add(((JetObject)((Object)rptMode)).getParent(), (JetObject)((Object)rptMode2));
            rptRenderer = rptMode2.getCurrentRender();
        }
        return rptRenderer;
    }

    public final JetRptChartShowValueFunc getShowValueFunction(ChartShowValueInfo chartShowValueInfo) {
        return this.background(this.getDefinition().isHeatMapChart(), chartShowValueInfo);
    }

    private final JetRptChartShowValueFunc background(boolean bl, ChartShowValueInfo chartShowValueInfo) {
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer;
        if (bl) {
            chartShowValueInfo = (ChartShowValueInfo)this.getChartDefinition().getShowValueInfoList().get(0);
        }
        if ((jetRptChartShowValueFuncContainer = this.bindedLineStyles(false)) == null) {
            return null;
        }
        return jetRptChartShowValueFuncContainer.getShowValueFunction(chartShowValueInfo);
    }

    public final List getAllShowValueFunction() {
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(false);
        if (jetRptChartShowValueFuncContainer == null) {
            return null;
        }
        return jetRptChartShowValueFuncContainer.getAllRptShowValueFunctionInsts();
    }

    public final ChartValProperties getChartValueProperties() {
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(false);
        if (jetRptChartShowValueFuncContainer == null) {
            return null;
        }
        return jetRptChartShowValueFuncContainer.getFillColorFunctionsAsChartValProperties();
    }

    public final void setChartValueProperties(ChartValProperties chartValProperties) {
        if (chartValProperties == null) {
            JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(false);
            if (jetRptChartShowValueFuncContainer != null) {
                jetRptChartShowValueFuncContainer.setFillColorFunctionsAsChartValProperties(chartValProperties);
            }
        } else {
            JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = this.bindedLineStyles(true);
            jetRptChartShowValueFuncContainer.setFillColorFunctionsAsChartValProperties(chartValProperties);
        }
    }

    private final JetRptChartShowValueFuncContainer bindedLineStyles(boolean bl) {
        Vector vector = this.getChildren();
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = null;
        for (JetObject jetObject : vector) {
            if (!(jetObject instanceof JetRptChartShowValueFuncContainer)) continue;
            jetRptChartShowValueFuncContainer = (JetRptChartShowValueFuncContainer)jetObject;
        }
        if (jetRptChartShowValueFuncContainer == null && bl) {
            jetRptChartShowValueFuncContainer = new JetRptChartShowValueFuncContainer();
            jetRptChartShowValueFuncContainer.setEditable();
            ObjectLogicFactory.getBasicComponentLogic().add(this, jetRptChartShowValueFuncContainer);
        }
        return jetRptChartShowValueFuncContainer;
    }

    public int getIndexInBrowserFilterDialog() {
        return this.indexInBrowseFilterDialog.intValue();
    }

    public boolean isInvisibleInBrowserFilterDialog() {
        return this.invisibleInBrowserFilterDialog.booleanValue();
    }

    public List getChartTypeAttributeValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ChartDefinition chartDefinition = this.getChartDefinition();
        List list = chartDefinition.getChartDatasetSequence();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            if (list.get(i) == null || (string = (String)ChartPropertyValues.CSS_CHART_TYPE.get(list.get(i))) == null) continue;
            arrayList.add("" + string);
        }
        return arrayList;
    }
}

