/*
 * Decompiled with CFR 0.152.
 */
package jet.report.crosstabFormula.compiler;

import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.exception.ParseFormulaFailedException;
import jet.formula.JetRptFormula;
import jet.formula.application.flyformula.FlyFormulaContainer;
import jet.formula.util.RefObjectCollector;
import jet.ireport.IReport;
import jet.report.JetRptCTCrossTab;
import jet.report.crosstabFormula.compiler.CrosstabFormulaContainer;
import jet.report.formula.compiler.AbstractFormulaCompiler;
import jet.report.onTheFlyFormula.DCScope;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.reportLogic.objectLogic.UseTypeNotValidateException;
import jet.universe.JetUUniverse;

public class CrosstabFormulaCompiler
extends AbstractFormulaCompiler {
    public static final String CLASSNAME_PREFIX = "CTF_";
    private DCScope SEDU = null;
    private final CrosstabFormulaContainer append;

    public CrosstabFormulaCompiler(JetUUniverse jetUUniverse, IReport iReport, JetRptCTCrossTab jetRptCTCrossTab, ResourceStore resourceStore) {
        super(CLASSNAME_PREFIX);
        this.SEDU = new DCScope(jetUUniverse, iReport, jetRptCTCrossTab);
        this.init(this.SEDU, resourceStore);
        this.append = new CrosstabFormulaContainer(this.SEDU, false);
    }

    public CrosstabFormulaCompiler(DCScope dCScope, ResourceStore resourceStore) {
        super(CLASSNAME_PREFIX);
        this.SEDU = dCScope;
        this.init(dCScope, resourceStore);
        this.append = new CrosstabFormulaContainer(dCScope, false);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[CrosstabFormulaCompiler]: new CrosstabFormulaCompiler... scope is: " + dCScope + ", ResourceStore = " + resourceStore);
        }
    }

    public synchronized void compileCTFormulas() {
        this.compileCTFormulas(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compileCTFormulas(Vector vector, Vector vector2) {
        this.append.resetCoordinate(vector, vector2);
        try {
            super.compileFormulas(this.append, true);
        }
        finally {
            this.append.resetCoordinate(null, null);
        }
    }

    public synchronized void checkExpressionSyntax(String string, String string2, int n, boolean bl, boolean bl2) throws ParseFormulaFailedException, UseTypeNotValidateException {
        this.checkExpressionSyntax(string, string2, n, null, null, bl, bl2);
    }

    public synchronized void checkExpressionSyntax(String string, String string2, int n, Vector vector, Vector vector2, boolean bl, boolean bl2) throws ParseFormulaFailedException, UseTypeNotValidateException {
        CrosstabFormulaContainer crosstabFormulaContainer = this.append.createInstanceForChecking();
        crosstabFormulaContainer.resetCoordinate(vector, vector2);
        JetRptFormula jetRptFormula = super.checkFormulaSyntax(crosstabFormulaContainer, string, string2, true, bl2);
        if (this.SEDU.isBL() && !this.SEDU(jetRptFormula, n, crosstabFormulaContainer)) {
            int n2 = JetRptFlyFormula.getErrorMessageId(n);
            throw new UseTypeNotValidateException(n2);
        }
    }

    public synchronized boolean checkOnTheFlyFormulaUseTypeValidate(JetRptFlyFormula jetRptFlyFormula, int n) throws ParseFormulaFailedException {
        JetRptFormula jetRptFormula = this.checkCTFormulaSyntax(jetRptFlyFormula.getFormulaExpression(), jetRptFlyFormula.getQualifiedDisplayName(), true, true);
        return this.SEDU(jetRptFormula, n, (FlyFormulaContainer)jetRptFormula.getDataSource());
    }

    private boolean SEDU(JetRptFormula jetRptFormula, int n, FlyFormulaContainer flyFormulaContainer) {
        int n2;
        boolean bl = false;
        if (n == 1) {
            return true;
        }
        if (n == 2 ? DataTypeUtils.isCompareAble(n2 = jetRptFormula.getColDesc().getSqlType()) && RefObjectCollector.isPass1Formula(jetRptFormula, flyFormulaContainer) : n == 3 && RefObjectCollector.isGroupLevelFormula(jetRptFormula)) {
            return true;
        }
        return bl;
    }

    public synchronized JetRptFormula checkCTFormulaSyntax(String string, String string2, boolean bl, boolean bl2) throws ParseFormulaFailedException {
        return this.checkCTFormulaSyntax(string, string2, null, null, bl, bl2);
    }

    public synchronized JetRptFormula checkCTFormulaSyntax(String string, String string2, Vector vector, Vector vector2, boolean bl, boolean bl2) throws ParseFormulaFailedException {
        CrosstabFormulaContainer crosstabFormulaContainer = this.append.createInstanceForChecking();
        crosstabFormulaContainer.resetCoordinate(vector, vector2);
        return super.checkFormulaSyntax(crosstabFormulaContainer, string, string2, bl, bl2);
    }
}

