/*
 * Decompiled with CFR 0.152.
 */
package jet.report.fax;

import com.jinfonet.util.JRLog;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jet.ReportEnv;
import jet.bean.JRCoverInfo;
import jet.bean.JRFaxServerException;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.report.fax.CoverImage;
import jet.report.fax.ExportToImage;
import jet.util.JRInterruptedException;

public class ExportCommsToStream {
    private Communicator SEDU;
    private int add = 0;
    Image coverImg;
    private boolean append;
    private JRCoverInfo close;
    ExportToImage imageProducer;
    private ArrayList comment;
    private String comments;
    private String company;
    private ExportAuxInfo createImageEncoder = null;
    String temppath = ReportEnv.homePath + "faxtemp.tif";
    private Communicator[] date;

    public ExportCommsToStream(Communicator communicator, String string, JRCoverInfo jRCoverInfo) {
        this.SEDU = communicator;
        this.company = string;
        this.close = jRCoverInfo;
        this.initReport();
        this.initCover();
    }

    public ExportCommsToStream(Communicator[] communicatorArray, String string, JRCoverInfo jRCoverInfo) {
        this.date = communicatorArray;
        this.company = string;
        this.close = jRCoverInfo;
        this.initReport();
        this.initCover();
    }

    public InputStream create() throws JRFaxServerException {
        BufferedInputStream bufferedInputStream = null;
        File file = new File(this.temppath);
        try {
            this.saveAsTIFF(this.temppath);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new JRFaxServerException("Temp file can't found");
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Fax ExportReportToStream JRInterruptedException", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, exception);
            }
            throw new JRFaxServerException(exception.getMessage());
        }
        return bufferedInputStream;
    }

    public void deleteTempfile() {
        File file = new File(this.temppath);
        file.delete();
    }

    void initReport() {
        if (this.date.length > 0) {
            ExportToImage exportToImage = new ExportToImage(this.date);
            exportToImage.setAuxinfo(this.createImageEncoder);
            this.imageProducer = exportToImage;
        }
    }

    void initCover() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.close != null) {
            this.append = true;
        }
        if (this.append) {
            CoverImage coverImage = new CoverImage(this.company, this.close.from, this.close.to, this.close.company, this.close.phone, this.close.date, this.close.re, this.close.comments, this.close.urgent, this.close.review, this.close.comment, this.close.reply, this.imageProducer.getPageNumber());
            coverImage.setComm(this.date[0]);
            this.coverImg = coverImage.getCoverImage();
        }
    }

    public ArrayList getFaxPages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (this.append) {
            arrayList.add(this.coverImg);
        }
        int n = 0;
        for (int i = 0; i < this.date.length; ++i) {
            for (int j = 0; j < this.date[i].getPageNum(); ++j) {
                arrayList.add(this.imageProducer.getImage(j, this.date[i]));
                n += this.date[i].getPhysicalTotalPageNum();
            }
        }
        return arrayList;
    }

    void saveAsTIFF(String string) throws IOException {
        ArrayList arrayList = this.getFaxPages();
        RenderedImage renderedImage = (RenderedImage)arrayList.get(0);
        arrayList.remove(0);
        String string2 = string;
        if (!string2.endsWith(".tif")) {
            string2 = new String(string + ".tif");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        tIFFEncodeParam.setCompression(32946);
        TIFFField[] tIFFFieldArray = new TIFFField[2];
        long[][] lArray = new long[1][2];
        lArray[0][0] = 72L;
        lArray[0][1] = 1L;
        tIFFFieldArray[0] = new TIFFField(282, 5, 1, (Object)lArray);
        long[][] lArray2 = new long[1][2];
        lArray2[0][0] = 72L;
        lArray2[0][1] = 1L;
        tIFFFieldArray[1] = new TIFFField(283, 5, 1, (Object)lArray2);
        tIFFEncodeParam.setExtraFields(tIFFFieldArray);
        tIFFEncodeParam.setExtraImages(arrayList.iterator());
        ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)fileOutputStream, (ImageEncodeParam)tIFFEncodeParam);
        imageEncoder.encode(renderedImage);
        ((OutputStream)fileOutputStream).close();
    }

    protected void setAuxinfo(ExportAuxInfo exportAuxInfo) {
        this.createImageEncoder = exportAuxInfo;
    }
}

