/*
 * Decompiled with CFR 0.152.
 */
package jet.report.fax.HylaFax;

import com.jinfonet.util.JRLog;
import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.ConnectionListener;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import jet.bean.JRFaxServer;
import jet.bean.JRFaxServerException;
import jet.bean.JRFaxServerInfo;
import jet.util.JRInterruptedException;

public class JRHylaFaxServer
implements JRFaxServer {
    private HylaFAXClient SEDU;
    private ConnectionHandler addDocument = new ConnectionHandler();
    private Object append = new Object();
    private String close = "jrfax";
    private String compareTo;
    private int concat = 59;
    private int createJob = 0;
    private int error = 0;

    @Override
    public void setBasicParameters(JRFaxServerInfo jRFaxServerInfo) {
        this.close = jRFaxServerInfo.userName;
        this.concat = jRFaxServerInfo.timeout;
        this.createJob = jRFaxServerInfo.retry;
    }

    @Override
    public void setSpecParameters(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String string, InputStream inputStream) throws JRFaxServerException {
        if (!this.SEDU()) {
            throw new JRFaxServerException("JDK version less than 1.5.0");
        }
        this.compareTo = string;
        try {
            String string2;
            this.SEDU.mode('S');
            this.SEDU.type('I');
            try {
                string2 = this.SEDU.putTemporary(inputStream);
            }
            finally {
                inputStream.close();
            }
            Job job = this.SEDU.createJob();
            job.setFromUser(this.close);
            job.setDialstring(string);
            job.setKilltime(this.handleTimeout(this.concat));
            job.addDocument(string2);
            this.SEDU.submit(job);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "JRHylarFax JRInterruptedException", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            throw new JRFaxServerException(exception.getMessage());
        }
    }

    String handleTimeout(int n) throws JRFaxServerException {
        String string = Integer.toString(n);
        if (string.length() > 6) {
            throw new JRFaxServerException("The digits of timeout can not be over 6");
        }
        if (string.length() < 6) {
            String string2 = new String();
            for (int i = 0; i < 6 - string.length(); ++i) {
                string2 = string2.concat("0");
            }
            string2 = string2.concat(string);
            return string2;
        }
        return string;
    }

    private boolean SEDU() {
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        return string.compareTo("1.5.0") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String string, int n, String string2, String string3) throws JRFaxServerException, IOException {
        if (!this.SEDU()) {
            throw new JRFaxServerException("JDK version less than 1.5.0");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "fax port:" + n);
            JRLog.trace(6, "fax userid:" + string2);
        }
        Object object = this.append;
        synchronized (object) {
            block16: {
                if (this.SEDU == null) {
                    this.SEDU = new HylaFAXClient();
                    this.SEDU.setPassive(false);
                }
                try {
                    this.SEDU.open(string, n);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new JRFaxServerException("Unknown host");
                }
                catch (ServerResponseException serverResponseException) {
                    throw new JRFaxServerException("Server response error");
                }
                try {
                    if (!this.SEDU.user(string2)) break block16;
                    if (string3 == null || string3.length() == 0) {
                        throw new JRFaxServerException("Need password");
                    }
                    try {
                        this.SEDU.pass(string3);
                    }
                    catch (ServerResponseException serverResponseException) {
                        throw new JRFaxServerException("Password error");
                    }
                }
                catch (ServerResponseException serverResponseException) {
                    throw new JRFaxServerException("Connection failed,maybe userid doesn't exist");
                }
            }
            try {
                this.SEDU.noop();
                this.SEDU.tzone("LOCAL");
            }
            catch (ServerResponseException serverResponseException) {
                throw new JRFaxServerException("Connect failed");
            }
        }
        return this.SEDU != null;
    }

    @Override
    public void disconnect() throws JRFaxServerException {
        try {
            this.SEDU.quit();
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "JRHylarFax JRInterruptedException", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            throw new JRFaxServerException(exception.getMessage());
        }
    }

    public void setTimeOut(int n) {
        this.concat = n;
    }

    public void setRetry(int n) {
        this.createJob = n;
    }

    public void setUserName(String string) {
        this.close = string;
    }

    private class ConnectionHandler
    implements ConnectionListener {
        private ConnectionHandler() {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            JRHylaFaxServer.this.SEDU.removeConnectionListener((ConnectionListener)this);
            JRHylaFaxServer.this.SEDU = null;
        }

        public void connectionFailed(Exception exception) {
            JRHylaFaxServer.this.SEDU.removeConnectionListener((ConnectionListener)this);
            JRHylaFaxServer.this.SEDU = null;
        }
    }
}

