/*
 * Decompiled with CFR 0.152.
 */
package jet.report.fax;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import jet.bean.JRCoverInfo;
import jet.bean.JRFaxServer;
import jet.bean.JRFaxServerException;
import jet.bean.JRFaxServerInfo;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.report.fax.ExportCommsToStream;
import jet.report.fax.ExportReportToStream;
import jet.util.JRInterruptedException;

public class JRExportToFax {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportToFaxServer(Communicator communicator, String string, JRFaxServerInfo jRFaxServerInfo, JRCoverInfo jRCoverInfo, ExportAuxInfo exportAuxInfo) throws JRFaxServerException {
        Object object;
        if (!JRExportToFax.I() && string.equalsIgnoreCase("jet.report.fax.HylaFax.JRHylaFaxServer")) {
            throw new JRFaxServerException("JDK version less than 1.5.0");
        }
        Object var5_5 = null;
        try {
            try {
                object = Class.forName("gnu.hylafax.ClientProtocol");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRFaxServerException("can't find class gnu.hylafax.ClientProtocol");
            }
            object = Class.forName(string);
            var5_5 = ((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRFaxServerException("can't find class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRFaxServerException("Illegal access");
        }
        catch (InstantiationException instantiationException) {
            throw new JRFaxServerException("can't instance class " + string);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (!JRLog.isError(2)) throw jRInterruptedException;
            JRLog.error(2, "Fax JRExportToFax JRInterruptedException", (Throwable)jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            throw new JRFaxServerException(exception.getMessage());
        }
        if (!(var5_5 instanceof JRFaxServer)) throw new JRFaxServerException("Class is not a JRFaxServer");
        object = var5_5;
        object.setBasicParameters(jRFaxServerInfo);
        object.setSpecParameters(jRFaxServerInfo.specPars);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "fax port:" + jRFaxServerInfo.port);
            JRLog.trace(6, "fax host:" + jRFaxServerInfo.host);
            JRLog.trace(6, "fax userid:" + jRFaxServerInfo.userid);
            JRLog.trace(6, "fax faxnumber:" + jRFaxServerInfo.faxnumber);
            JRLog.trace(6, "fax userName:" + jRFaxServerInfo.userName);
            JRLog.trace(6, "fax timeout:" + jRFaxServerInfo.timeout);
            JRLog.trace(6, "fax specPars:" + jRFaxServerInfo.specPars);
        }
        try {
            if (!object.connect(jRFaxServerInfo.host, jRFaxServerInfo.port, jRFaxServerInfo.userid, jRFaxServerInfo.password)) return;
            ExportReportToStream exportReportToStream = new ExportReportToStream(communicator, jRFaxServerInfo.faxnumber, jRCoverInfo);
            exportReportToStream.setAuxinfo(exportAuxInfo);
            int n = 0;
            if (jRFaxServerInfo.retry < 0) {
                jRFaxServerInfo.retry = 0;
            }
            while (n <= jRFaxServerInfo.retry) {
                try {
                    object.send(jRFaxServerInfo.faxnumber, exportReportToStream.create());
                    n = jRFaxServerInfo.retry + 1;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (!JRLog.isError(2)) throw jRInterruptedException;
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (n == jRFaxServerInfo.retry) {
                        object.disconnect();
                        throw new JRFaxServerException(exception.getMessage());
                    }
                    ++n;
                }
            }
            object.disconnect();
            exportReportToStream.deleteTempfile();
            return;
        }
        catch (IOException iOException) {
            throw new JRFaxServerException("Connection failed,please check your server or settings");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportToFaxServer(Communicator[] communicatorArray, String string, JRFaxServerInfo jRFaxServerInfo, JRCoverInfo jRCoverInfo, ExportAuxInfo exportAuxInfo) throws JRFaxServerException {
        Object object;
        if (!JRExportToFax.I() && string.equalsIgnoreCase("jet.report.fax.HylaFax.JRHylaFaxServer")) {
            throw new JRFaxServerException("JDK version less than 1.5.0");
        }
        Object var5_5 = null;
        try {
            try {
                object = Class.forName("gnu.hylafax.ClientProtocol");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRFaxServerException("can't find class gnu.hylafax.ClientProtocol");
            }
            object = Class.forName(string);
            var5_5 = ((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRFaxServerException("can't find class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRFaxServerException("Illegal access");
        }
        catch (InstantiationException instantiationException) {
            throw new JRFaxServerException("can't instance class " + string);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (!JRLog.isError(2)) throw jRInterruptedException;
            JRLog.error(2, "Fax JRExportToFax JRInterruptedException", (Throwable)jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            throw new JRFaxServerException(exception.getMessage());
        }
        if (!(var5_5 instanceof JRFaxServer)) throw new JRFaxServerException("Class is not a JRFaxServer");
        object = var5_5;
        object.setBasicParameters(jRFaxServerInfo);
        object.setSpecParameters(jRFaxServerInfo.specPars);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "fax port:" + jRFaxServerInfo.port);
            JRLog.trace(6, "fax host:" + jRFaxServerInfo.host);
            JRLog.trace(6, "fax userid:" + jRFaxServerInfo.userid);
            JRLog.trace(6, "fax faxnumber:" + jRFaxServerInfo.faxnumber);
            JRLog.trace(6, "fax userName:" + jRFaxServerInfo.userName);
            JRLog.trace(6, "fax timeout:" + jRFaxServerInfo.timeout);
            JRLog.trace(6, "fax specPars:" + jRFaxServerInfo.specPars);
        }
        try {
            if (!object.connect(jRFaxServerInfo.host, jRFaxServerInfo.port, jRFaxServerInfo.userid, jRFaxServerInfo.password)) return;
            ExportCommsToStream exportCommsToStream = new ExportCommsToStream(communicatorArray, jRFaxServerInfo.faxnumber, jRCoverInfo);
            exportCommsToStream.setAuxinfo(exportAuxInfo);
            int n = 0;
            if (jRFaxServerInfo.retry < 0) {
                jRFaxServerInfo.retry = 0;
            }
            while (n <= jRFaxServerInfo.retry) {
                try {
                    object.send(jRFaxServerInfo.faxnumber, exportCommsToStream.create());
                    n = jRFaxServerInfo.retry + 1;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (!JRLog.isError(2)) throw jRInterruptedException;
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (n == jRFaxServerInfo.retry) {
                        object.disconnect();
                        throw new JRFaxServerException(exception.getMessage());
                    }
                    ++n;
                }
            }
            object.disconnect();
            exportCommsToStream.deleteTempfile();
            return;
        }
        catch (IOException iOException) {
            throw new JRFaxServerException("Connection failed,please check your server or settings");
        }
    }

    private static boolean I() {
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        return string.compareTo("1.5.0") >= 0;
    }
}

