/*
 * Decompiled with CFR 0.152.
 */
package jet.report.formula;

import com.jinfonet.util.JRLog;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jet.controls.JetBytes;
import jet.controls.JetNumber;
import jet.controls.JetString;
import jet.report.JetRptObject;

public abstract class JetRptAbstractFormulaClass
extends JetRptObject {
    private static final boolean deflate = true;
    private JetString end;
    private JetBytes error;
    private JetNumber finish;
    private static HashMap getClass = null;

    protected JetRptAbstractFormulaClass() {
        this.removePropertiesAndGroups();
        this.error = new JetBytes(this, "FormulaClassBytes");
        this.end = new JetString(this, "ClassName");
        this.finish = new JetNumber(this, "OriginalClassBytesLength");
    }

    protected JetRptAbstractFormulaClass(String string, byte[] byArray) {
        this();
        this.reinit(string, byArray);
    }

    protected void reinit(String string, byte[] byArray) {
        this.finish.set(byArray.length);
        byte[] byArray2 = new byte[byArray.length];
        Deflater deflater = new Deflater(9);
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = byArray2[i];
        }
        byArray2 = null;
        this.error.set(byArray3);
        this.end.set(string);
    }

    @Override
    public boolean canBeBrowse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (getClass == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (getClass == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("FormulaClassBytes", n++);
                    hashMap.put("OriginalClassBytesLength", n++);
                    hashMap.put("ClassName", n++);
                    getClass = hashMap;
                }
            }
        }
        return getClass;
    }

    public String getClassName() {
        return this.end.get();
    }

    public byte[] getClassBytes() throws DataFormatException {
        byte[] byArray = this.error.get();
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        byte[] byArray2 = new byte[this.finish.get()];
        int n = inflater.inflate(byArray2);
        inflater.end();
        if (n != this.finish.get() && JRLog.isError(2)) {
            JRLog.error(2, new Exception("When decompress the class bytes , the length of the decompressed bytes not equals the original "));
        }
        return byArray2;
    }
}

