/*
 * Decompiled with CFR 0.152.
 */
package jet.report.formula.compiler;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import jet.controls.JetObject;
import jet.dataengine.api.config.JavaFormulaConfigImpl;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompiler;
import jet.formula.FormulaCompilerListener;
import jet.formula.JetRptFormula;
import jet.report.JetRptObject;
import jet.report.conditionalFormatting.JetRptUFormula;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.formula.compiler.AbstractFormulaContainer;
import jet.report.onTheFlyFormula.JetRptFlyFormulaClass;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.universe.JetUFormula;
import jet.universe.exception.GenerateFormulasCodeException;

public abstract class AbstractFormulaCompiler
implements FormulaCompilerListener {
    private Scope I;
    private ResourceStore add = null;
    private final String addElement;
    private Vector checkFormulas = new Vector();
    private static final boolean clear = System.getProperty("recomplieFailed") != null;

    protected AbstractFormulaCompiler(String string) {
        this.addElement = string;
    }

    protected void init(Scope scope, ResourceStore resourceStore) {
        this.I = scope;
        this.add = resourceStore;
    }

    public Vector getCompileError() {
        return this.checkFormulas;
    }

    @Override
    public void translateComplete(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            FormulaSyntaxErrorException formulaSyntaxErrorException = (FormulaSyntaxErrorException)vector.get(i);
            this.checkFormulas.add(formulaSyntaxErrorException);
            if (!JRLog.isTrace(5)) continue;
            JRLog.trace(5, "[" + this.addElement + "FormulaCompiler] Compile Formula Error: " + formulaSyntaxErrorException.getMessage());
        }
    }

    protected synchronized void compileFormulas(AbstractFormulaContainer abstractFormulaContainer, boolean bl) {
        JetRptObject jetRptObject;
        Object object;
        Object object2;
        Hashtable<JetRptAbstractFormula, JetRptFormula> hashtable;
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet;
        block21: {
            Object object3;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() begin... shouldRecompile=" + bl + ", formulacontainer=" + abstractFormulaContainer);
            }
            jetRptFlyFormulaMeasureSet = this.I.getFlyFormulaMeasureSet();
            this.checkFormulas.clear();
            if (jetRptFlyFormulaMeasureSet == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() end, no JetRptFlyFormulaMeasureSet");
                }
                return;
            }
            if (!bl && this.I(jetRptFlyFormulaMeasureSet)) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() end,  Because flag of shouldRecompile is " + bl + " , and formula compile version is suitable with the newest formula version upgraged!");
                }
                return;
            }
            Vector<JetRptFormula> vector = new Vector<JetRptFormula>();
            Vector vector2 = jetRptFlyFormulaMeasureSet.getChildren();
            hashtable = new Hashtable<JetRptAbstractFormula, JetRptFormula>();
            Vector<JetRptFormula> vector3 = new Vector<JetRptFormula>();
            for (int i = 0; i < vector2.size(); ++i) {
                object3 = vector2.get(i);
                if (!(object3 instanceof JetRptAbstractFormula)) continue;
                object2 = (JetRptAbstractFormula)object3;
                object = new JetRptFormula(((JetRptAbstractFormula)object2).getMappingName(), ((JetRptAbstractFormula)object2).getFormulaExpression(), abstractFormulaContainer);
                hashtable.put((JetRptAbstractFormula)object2, (JetRptFormula)object);
                vector.add((JetRptFormula)object);
                vector3.add((JetRptFormula)object);
            }
            JetRptFlyFormulaClass jetRptFlyFormulaClass = jetRptFlyFormulaMeasureSet.getFormulaClass();
            if (jetRptFlyFormulaClass != null) {
                ObjectLogicFactory.getBasicComponentLogic().remove(jetRptFlyFormulaClass);
            }
            if (vector.isEmpty()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() end. befause no formula to compile");
                }
                return;
            }
            abstractFormulaContainer.setWaitForCompileFormulaList(vector3);
            object3 = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.add));
            object2 = this.addElement + UUID.randomUUID().toString().replace('-', '_');
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.addElement + "FormulaCompiler#compileFormulas(), Generate Formulas Code Start.....");
            }
            object = null;
            try {
                object = ((FormulaCompiler)object3).compileFormulas(vector, (String)object2, abstractFormulaContainer);
            }
            catch (GenerateFormulasCodeException generateFormulasCodeException) {
                if (!JRLog.isTrace(5)) break block21;
                JRLog.trace(5, this.addElement + "FormulaCompiler#compileFormulas(), get GenerateFormulasCodeException: " + generateFormulasCodeException.getMessage());
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.addElement + "FormulaCompiler#compileFormulas(), Generate Formulas Code End");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            jetRptObject = (JetRptAbstractFormula)enumeration.nextElement();
            JetRptFormula jetRptFormula = (JetRptFormula)hashtable.get(jetRptObject);
            JetRptUFormula jetRptUFormula = (JetRptUFormula)((JetRptAbstractFormula)jetRptObject).getJetUFormula();
            jetRptUFormula.setFormulaType(jetRptFormula.formulainfo);
            if (jetRptFormula.formulainfo == null) {
                jetRptUFormula.setParsedOK(false);
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, this.addElement + "FormulaCompiler#compileFormulas() fName = " + ((JetRptAbstractFormula)jetRptObject).getName() + ", jpf.formulainfo.parse Failed.");
                }
                ((JetRptAbstractFormula)jetRptObject).needCheckGrammarOnCompile(true);
                continue;
            }
            jetRptUFormula.setParsedOK(jetRptFormula.formulainfo.parseOK);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.addElement + "FormulaCompiler#compileFormulas()fName = " + ((JetRptAbstractFormula)jetRptObject).getName() + ", jpf.formulainfo.parse OK=" + jetRptFormula.formulainfo.parseOK);
            }
            ((JetRptAbstractFormula)jetRptObject).getJetUFormula().setSqlType(jetRptFormula.getColDesc().sqlType);
            ((JetRptAbstractFormula)jetRptObject).getJetUFormula().setScale(jetRptFormula.getColDesc().scale);
            ((JetRptAbstractFormula)jetRptObject).getJetUFormula().setPrecision(jetRptFormula.getColDesc().precision);
            ((JetRptAbstractFormula)jetRptObject).needCheckGrammarOnCompile(false);
        }
        if (object != null) {
            jetRptObject = new JetRptFlyFormulaClass((String)object2, (String)object);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptFlyFormulaMeasureSet, jetRptObject);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() end.");
            }
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, this.addElement + "FormulaCompiler#compileFormulas() end, BUT compile Formula fail for the classFile is null. ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized JetRptFormula checkFormulaSyntax(AbstractFormulaContainer abstractFormulaContainer, String string, String string2, boolean bl, boolean bl2) throws ParseFormulaFailedException {
        Vector<JetObject> vector;
        Object object;
        if (!abstractFormulaContainer.isForCheck()) {
            abstractFormulaContainer = abstractFormulaContainer.createInstanceForChecking();
        }
        List list = this.I.getDynamicFormulaList();
        Vector vector2 = new Vector();
        for (int i = 0; i < list.size(); ++i) {
            object = (JetRptAbstractFormula)list.get(i);
            vector = new JetRptFormula(((JetRptAbstractFormula)object).getName(), ((JetRptAbstractFormula)object).getFormulaExpression(), abstractFormulaContainer);
            vector2.addElement(vector);
        }
        abstractFormulaContainer.setWaitForCompileFormulaList(vector2);
        JetObject jetObject = null;
        if (!bl2) {
            object = null;
            for (JetRptFormula jetRptFormula : vector2) {
                if (!jetRptFormula.getName().equalsIgnoreCase(string)) continue;
                object = jetRptFormula;
                break;
            }
            if (object == null) {
                if (!JRLog.isTrace(6)) throw new FormulaNotFoundException(string);
                JRLog.trace(6, this.addElement + "FormulaCompiler#checkCTFormulaSyntax( @FC, " + string + ", " + string2 + " ," + bl + "," + bl2 + "): FormulaNotFound!");
                throw new FormulaNotFoundException(string);
            }
            jetObject = object;
            ((JetRptFormula)object).setExpression(string2);
            ((JetRptFormula)jetObject).setDataSource(abstractFormulaContainer);
        } else {
            jetObject = new JetRptFormula(string, string2, abstractFormulaContainer);
        }
        object = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.add));
        vector = new Vector<JetObject>(3);
        vector.add(jetObject);
        if (bl) {
            ((FormulaCompiler)object).checkFormulas(vector);
            if (!JRLog.isTrace(6)) return jetObject;
            JRLog.trace(6, this.addElement + "FormulaCompiler#checkCTFormulaSyntax( @FC, " + string + ", " + string2 + " ," + bl + "," + bl2 + "): ALL OK");
            return jetObject;
        }
        try {
            ((FormulaCompiler)object).checkFormulas(vector);
            if (!JRLog.isTrace(6)) return jetObject;
            JRLog.trace(6, this.addElement + "FormulaCompiler#checkCTFormulaSyntax( @FC, " + string + ", " + string2 + " ," + bl + "," + bl2 + "): ALL OK");
            return jetObject;
        }
        catch (Exception exception) {
            if (!JRLog.isTrace(6)) return jetObject;
            JRLog.trace(6, this.addElement + "FormulaCompiler#checkCTFormulaSyntax( @FC, " + string + ", " + string2 + " ," + bl + "," + bl2 + "): " + exception.getMessage());
        }
        return jetObject;
    }

    private boolean I(JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet) {
        List list = jetRptFlyFormulaMeasureSet.getDynamicFormulaList();
        for (int i = 0; i < list.size(); ++i) {
            JetRptAbstractFormula jetRptAbstractFormula = (JetRptAbstractFormula)list.get(i);
            if (this.SEDU(jetRptAbstractFormula)) continue;
            return false;
        }
        return true;
    }

    private boolean SEDU(JetRptAbstractFormula jetRptAbstractFormula) {
        boolean bl;
        JetUFormula jetUFormula = jetRptAbstractFormula.getJetUFormula();
        if (jetUFormula == null || jetUFormula.formulainfo == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, this.addElement + "FormulaCompiler#versionSuit() return false : formula is " + jetRptAbstractFormula.getName() + ", uf or uf.formulaInfo is null--> FALSE");
            }
            return false;
        }
        int n = jetUFormula.formulainfo.getMajorVersion();
        int n2 = jetUFormula.formulainfo.getMinorVersion();
        boolean bl2 = bl = n >= 1 && n2 >= 14;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, this.addElement + "FormulaCompiler#versionSuit() : formula is " + jetRptAbstractFormula.getName() + ", f_MajV = " + n + ", f_MinV = " + n2 + ", FormulaInfo.MAJOR_VERSION = " + 1 + ", FormulaInfo.MINOR_VERSION = " + 14 + " ***** bVersionSame = " + bl);
        }
        if (bl) {
            if (clear && !jetUFormula.isParsedOK()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, this.addElement + "FormulaCompiler#versionSuit() return false : formula is " + jetRptAbstractFormula.getName() + ", uf.isParsedOK() = false --> FALSE");
                }
                return false;
            }
        } else {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, this.addElement + "FormulaCompiler#versionSuit() return false : formula is " + jetRptAbstractFormula.getName() + ", SameVersion = false --> FALSE");
            }
            return false;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, this.addElement + "FormulaCompiler#versionSuit() return true : formula is " + jetRptAbstractFormula.getName() + ", SameVersion = true --> TRUE");
        }
        return true;
    }

    public class FormulaNotFoundException
    extends ParseFormulaFailedException {
        private String SEDU;

        public FormulaNotFoundException(String string) {
            super((Vector)null);
            this.SEDU = string;
        }

        @Override
        public String toString() {
            return this.SEDU + " does not exists.";
        }
    }
}

