/*
 * Decompiled with CFR 0.152.
 */
package jet.report.geomap;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.icontrols.PropValueInfo;
import jet.report.JetRptContainer;
import jet.report.mode.common.RptEventToActionItem;
import jet.report.mode.common.RptMode;
import jet.util.HashVector;

public class JetRptGeoArea
extends JetRptContainer {
    protected JetBoolean invisible = new JetBoolean(this, "Invisible", false);
    protected JetBoolean suppressed = new JetBoolean(this, "Suppressed", false);
    protected JetBoolean suppressedIfNoRecords = new JetBoolean(this, "SuppressedIfNoRecords", false);
    protected JetString areaTip;
    protected JetUnitNumber boundaryWidth;
    protected JetColor boundaryColor;
    protected JetEnumeration boundaryStyle;
    private JetQualifyReference SEDU;
    private static HashVector Z = null;
    private static HashMap add = null;

    public JetRptGeoArea() {
        this.suppressed.setTransient(true);
        this.areaTip = new JetString(this, "AreaTip", "");
        this.boundaryWidth = new JetUnitNumber(this, "BoundaryWidth");
        this.boundaryWidth.setUnitValue(Unit.convertInchToUnit(0.01));
        this.boundaryColor = new JetColor(this, "BoundaryColor", new Color(0xD1D1D1));
        this.boundaryStyle = new JetEnumeration(this, "BoundaryStyle", 12);
        this.boundaryStyle.set(0);
        this.boundaryWidth.setCanChangeByOthers(true);
        this.boundaryStyle.enableAllChangeBys(true);
        this.SEDU = new JetQualifyReference(this, "refMode");
    }

    public JetBoolean getInvisibleProperty() {
        return this.invisible;
    }

    public JetBoolean getSuppressedProperty() {
        return this.suppressed;
    }

    public JetBoolean getSuppressedIfNoRecordsProperty() {
        return this.suppressedIfNoRecords;
    }

    protected PropValueInfo getAreaTip() {
        return this.areaTip.getCurrentValue();
    }

    @Override
    public String getInstancePrefix() {
        return "GeoArea";
    }

    @Override
    public boolean canBeBrowse() {
        return true;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (Z != null) {
                return Z;
            }
            Z = new HashVector();
            String string = "Boundary";
            Vector<String> vector = new Vector<String>(3);
            vector.add("BoundaryColor");
            vector.add("BoundaryStyle");
            vector.add("BoundaryWidth");
            Z.put(string, vector);
            string = "Others";
            vector = new Vector(3);
            vector.add("Invisible");
            vector.add("Suppressed");
            vector.add("SuppressedIfNoRecords");
            Z.put(string, vector);
            return Z;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (add == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (add == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Invisible", n++);
                    hashMap.put("Suppressed", n++);
                    hashMap.put("SuppressedIfNoRecords", n++);
                    hashMap.put("AreaTip", n++);
                    hashMap.put("BoundaryColor", n++);
                    hashMap.put("BoundaryStyle", n++);
                    hashMap.put("BoundaryWidth", n++);
                    hashMap.put("refMode", n++);
                    add = hashMap;
                }
            }
        }
        return add;
    }

    public JetQualifyReference getModeProperty() {
        return this.SEDU;
    }

    public List getEventToActionItemList() {
        Vector<RptEventToActionItem> vector = new Vector<RptEventToActionItem>();
        RptMode rptMode = (RptMode)this.SEDU.getObject();
        Vector vector2 = rptMode.getCurrentRender().getSupportEvents();
        for (Object e : vector2) {
            vector.add((RptEventToActionItem)e);
        }
        return vector;
    }
}

