/*
 * Decompiled with CFR 0.152.
 */
package jet.report.grpProps;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.icontrols.PropValueInfo;

public class JetColorByProperties {
    public JetColor groundColor;
    public JetNumber transparency;
    public JetString patternName;
    public JetBoolean isReverse;
    public JetBoolean isCustomized;
    public JetColor[] cusGadientClrs = new JetColor[2];
    public JetVector memberKeys;
    public JetVector memberVals;

    public JetColorByProperties(JetObject jetObject) {
        this.groundColor = new JetColor(jetObject, "Color", null, true);
        this.groundColor.enableAllChangeBys(false);
        this.transparency = new JetNumber(jetObject, "Transparency", 100);
        this.transparency.enableAllChangeBys(false);
        this.patternName = new JetString(jetObject, "PatternName");
        this.patternName.enableAllChangeBys(false);
        this.isReverse = new JetBoolean(jetObject, "IsReverse", false);
        this.isReverse.enableAllChangeBys(false);
        this.isCustomized = new JetBoolean(jetObject, "IsCustomized", false);
        this.isCustomized.enableAllChangeBys(false);
        this.cusGadientClrs[0] = new JetColor(jetObject, "CusGradientStartColor", null, true);
        this.cusGadientClrs[0].enableAllChangeBys(false);
        this.cusGadientClrs[1] = new JetColor(jetObject, "CusGradientEndColor", null, true);
        this.cusGadientClrs[1].enableAllChangeBys(false);
        this.memberKeys = new JetVector(jetObject, "MemberKeys");
        this.memberVals = new JetVector(jetObject, "MemberValues");
    }

    public static int fillIndecialMap(HashMap hashMap) {
        int n = hashMap.size();
        hashMap.put("Color", n++);
        hashMap.put("Transparency", n++);
        hashMap.put("PatternName", n++);
        hashMap.put("IsReverse", n++);
        hashMap.put("IsCustomized", n++);
        hashMap.put("CusGradientStartColor", n++);
        hashMap.put("CusGradientEndColor", n++);
        hashMap.put("MemberKeys", n++);
        hashMap.put("MemberValues", n++);
        return hashMap.size();
    }

    public PropValueInfo getDefaultColorValue() {
        return this.groundColor.getCurrentValue();
    }

    public PropValueInfo getTransparencyInPercentValue() {
        return this.transparency.getCurrentValue();
    }

    public PropValueInfo getUsedPatternNameValue() {
        return this.patternName.getCurrentValue();
    }

    public PropValueInfo isReverseIfGradient() {
        return this.isReverse.getCurrentValue();
    }

    public PropValueInfo isUseCustomizedSetting() {
        return this.isCustomized.getCurrentValue();
    }

    public Object getMemberMapping() {
        throw new UnsupportedOperationException("DIDN'T IMPLEEMENT");
    }

    public PropValueInfo getCustomiedGradientStartColorValue() {
        return this.cusGadientClrs[0].getCurrentValue();
    }

    public PropValueInfo getCustomiedGradientEndColorValue() {
        return this.cusGadientClrs[1].getCurrentValue();
    }

    public Map toMemberMappingTable() {
        Vector vector = this.memberKeys.get();
        Vector vector2 = this.memberVals.get();
        int n = Math.min(vector.size(), vector2.size());
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        for (int i = 0; i < n; ++i) {
            hashtable.put(String.valueOf(vector.get(i)), String.valueOf(vector2.get(i)));
        }
        return hashtable;
    }
}

