/*
 * Decompiled with CFR 0.152.
 */
package jet.report.navigation;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetNumber;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBorderStyle;
import jet.report.JetRptLineWidth;
import jet.report.Renderable;
import jet.report.mode.JetRptMode;
import jet.report.mode.common.RptRenderer;
import jet.report.mode.renderer.JetRptButtonRender;
import jet.report.navigation.NavigationConstant;
import jet.util.HashVector;
import jet.util.ValueToUnit;

public class JetRptNavigationItem
extends JRObjectTemplate
implements NavigationConstant,
Renderable {
    public static final int IDX_TOP = 0;
    public static final int IDX_RIGHT = 1;
    public static final int IDX_BOTTOM = 2;
    public static final int IDX_LEFT = 3;
    private JetNumber BLACK;
    private JetRptBorderStyle BorderColor;
    private JetRptBorderStyle BorderWidth;
    private JetRptBorderStyle BottomLine;
    private JetRptBorderStyle GRAY;
    private JetColor HorizontalAlignment;
    private JetColor LeftLine;
    private JetRptLineWidth RightLine;
    private JetBoolean SEDU;
    private JetColor[] Shadow = new JetColor[4];
    private JetRptLineWidth[] ShadowColor = new JetRptLineWidth[4];
    private JetString TopLine;
    private JetColor VerticalAlignment;
    private JetBoolean Z;
    private JetBoolean add;
    private JetBoolean black;
    private JetBoolean convertInchToUnit;
    private JetBoolean duplicatePropGrpsDesc;
    private JetBoolean enableAllChangeBys;
    private JetFont get;
    private JetUnitNumber getClass;
    private JetEnumeration getCurrentRender;
    private JetEnumeration getCurrentUsedRenderer;
    private JetUnitNumber getDefinitionName;
    private JetUnitNumber getIndecialMap;
    private JetUnitNumber getJetRptMode;
    private JetUnitNumber getPropGrpsDesc;
    private JetColor getPropGrpsDescDirectly;
    private JetEnumeration getRenderType;
    private static RptRenderer intValue = null;
    private static HashMap padding_bottom = null;
    private static HashVector padding_left = null;

    public JetRptNavigationItem() {
        this.setObjectType(65541);
        this.BLACK = new JetNumber(this, "NavItemType", 5);
        this.HorizontalAlignment = new JetColor(this, PropertyNames.getDefinitionName(PropertyNames.BorderColor), Color.black);
        this.RightLine = new JetRptLineWidth(this, PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
        this.BorderColor = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.TopLine));
        this.BorderWidth = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.BottomLine));
        this.BottomLine = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.LeftLine));
        this.GRAY = new JetRptBorderStyle(this, PropertyNames.getDefinitionName(PropertyNames.RightLine));
        this.SEDU = new JetBoolean(this, PropertyNames.getDefinitionName(PropertyNames.Shadow));
        this.LeftLine = new JetColor(this, PropertyNames.getDefinitionName(PropertyNames.ShadowColor), Color.black);
        this.Shadow[0] = new JetColor(this, "border-top-color", Color.GRAY);
        this.Shadow[1] = new JetColor(this, "border-right-color", Color.GRAY);
        this.Shadow[2] = new JetColor(this, "border-bottom-color", Color.GRAY);
        this.Shadow[3] = new JetColor(this, "border-left-color", Color.GRAY);
        this.ShadowColor[0] = new JetRptLineWidth(this, "border-top-width");
        this.ShadowColor[1] = new JetRptLineWidth(this, "border-right-width");
        this.ShadowColor[2] = new JetRptLineWidth(this, "border-bottom-width");
        this.ShadowColor[3] = new JetRptLineWidth(this, "border-left-width");
        this.TopLine = new JetString(this, "Text");
        this.Z = new JetBoolean(this, "Bold");
        this.add = new JetBoolean(this, "Italic");
        this.get = new JetFont(this, "FontFace");
        this.getClass = new JetUnitNumber(this, "FontSize");
        this.VerticalAlignment = new JetColor(this, "Foreground", Color.BLACK);
        this.getCurrentRender = new JetEnumeration(this, PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment), 2);
        this.getCurrentUsedRenderer = new JetEnumeration(this, PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment), 6);
        this.black = new JetBoolean(this, "StrikeOut");
        this.convertInchToUnit = new JetBoolean(this, "Underline");
        this.duplicatePropGrpsDesc = new JetBoolean(this, "AutoFit");
        this.enableAllChangeBys = new JetBoolean(this, "WordWrap");
        this.getDefinitionName = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_top));
        this.getIndecialMap = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_bottom));
        this.getJetRptMode = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_left));
        this.getPropGrpsDesc = new JetUnitNumber(this, PropertyNames.getDefinitionName(PropertyNames.padding_right));
        this.getRenderType = new JetEnumeration(this, "PatternStyle", 78);
        this.getPropGrpsDescDirectly = new JetColor(this, "PatternColor", Color.BLACK, false);
        this.BLACK.setCanChangeByOthers(false);
        this.BLACK.setCanChangeByFmtt(false);
        this.BLACK.setCanChangeByFmtt(false);
        this.getCurrentRender.set(2);
        this.getCurrentUsedRenderer.set(0);
        this.BorderColor.set(0);
        this.BorderWidth.set(0);
        this.BottomLine.set(0);
        this.GRAY.set(0);
        this.getRenderType.set(0);
        this.getClass.setUnitValue(DEFAULT_FONTSIZE);
        this.iNWidth = ValueToUnit.convertInchToUnit(0.8);
        this.iNHeight = ValueToUnit.convertInchToUnit(0.2);
        this.exportToPDF.enableAllChangeBys(false);
    }

    @Override
    public void setEditable() {
        super.setEditable();
        this.width.setUnitValue(ValueToUnit.convertInchToUnit(0.8));
        this.height.setUnitValue(ValueToUnit.convertInchToUnit(0.2));
    }

    public JetRptNavigationItem(int n) {
        this();
        this.BLACK.setValue(n);
    }

    public int getNavigationItemType() {
        return this.BLACK.intValue();
    }

    public JetColor getForegroundProperty() {
        return this.VerticalAlignment;
    }

    public JetBoolean getIsBoldProperty() {
        return this.Z;
    }

    public JetBoolean getIsItalicProperty() {
        return this.add;
    }

    public JetString getTextProperty() {
        return this.TopLine;
    }

    public JetFont getFontFaceProperty() {
        return this.get;
    }

    public JetUnitNumber getFontSizeProperty() {
        return this.getClass;
    }

    public JetBoolean getIsUnderLineProperty() {
        return this.convertInchToUnit;
    }

    public JetBoolean getIsStrikeOutProperty() {
        return this.black;
    }

    public int getHorizontalAlignment() {
        return this.getCurrentRender.intValue();
    }

    public int getVerticalAlignment() {
        return this.getCurrentUsedRenderer.intValue();
    }

    public JetBoolean getAutoFitProperty() {
        return this.duplicatePropGrpsDesc;
    }

    public JetBoolean getWordWrapProperty() {
        return this.enableAllChangeBys;
    }

    public JetRptBorderStyle[] getBorderStyleProperties() {
        return new JetRptBorderStyle[]{this.BorderColor, this.GRAY, this.BorderWidth, this.BottomLine};
    }

    public JetColor[] getBorderColorProperties() {
        return new JetColor[]{this.HorizontalAlignment, this.HorizontalAlignment, this.HorizontalAlignment, this.HorizontalAlignment};
    }

    public JetRptLineWidth[] getBorderWidthProperties() {
        return new JetRptLineWidth[]{this.RightLine, this.RightLine, this.RightLine, this.RightLine};
    }

    public JetUnitNumber[] getPaddingProperties() {
        return new JetUnitNumber[]{this.getDefinitionName, this.getPropGrpsDesc, this.getIndecialMap, this.getJetRptMode};
    }

    public JetColor getShadowColorProperty() {
        return this.LeftLine;
    }

    public JetBoolean getIsDrawShadowProperty() {
        return this.SEDU;
    }

    public JetColor getPatternColorProperty() {
        return this.getPropGrpsDescDirectly;
    }

    public int getPatternStyle() {
        return this.getRenderType.intValue();
    }

    @Override
    public int[] getCanUsedRenderTypes() {
        return new int[]{11, 10};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RptRenderer getCurrentUsedRenderer() {
        JetRptMode jetRptMode = this.getJetRptMode();
        if (jetRptMode == null) {
            JetRptNavigationItem jetRptNavigationItem = this;
            synchronized (jetRptNavigationItem) {
                if (intValue == null) {
                    intValue = new JetRptButtonRender();
                }
            }
            return intValue;
        }
        return jetRptMode.getCurrentRender();
    }

    @Override
    public String getInstancePrefix() {
        return "NavigationItem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (padding_bottom == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (padding_bottom == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("NavItemType", n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.BorderColor), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.BorderWidth), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.TopLine), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.BottomLine), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.LeftLine), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.RightLine), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.Shadow), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.ShadowColor), n++);
                    hashMap.put("border-top-width", n++);
                    hashMap.put("border-bottom-width", n++);
                    hashMap.put("border-left-width", n++);
                    hashMap.put("border-right-width", n++);
                    hashMap.put("border-top-color", n++);
                    hashMap.put("border-bottom-color", n++);
                    hashMap.put("border-left-color", n++);
                    hashMap.put("border-right-color", n++);
                    hashMap.put("Text", n++);
                    hashMap.put("Bold", n++);
                    hashMap.put("Italic", n++);
                    hashMap.put("FontFace", n++);
                    hashMap.put("FontSize", n++);
                    hashMap.put("Foreground", n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment), n++);
                    hashMap.put("StrikeOut", n++);
                    hashMap.put("Underline", n++);
                    hashMap.put("AutoFit", n++);
                    hashMap.put("WordWrap", n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.padding_top), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.padding_bottom), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.padding_left), n++);
                    hashMap.put(PropertyNames.getDefinitionName(PropertyNames.padding_right), n++);
                    hashMap.put("PatternStyle", n++);
                    hashMap.put("PatternColor", n++);
                    padding_bottom = hashMap;
                }
            }
        }
        return padding_bottom;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        RptRenderer rptRenderer = this.getCurrentUsedRenderer();
        int n = rptRenderer == null ? 11 : rptRenderer.getRenderType();
        HashVector hashVector = this.getPropGrpsDescDirectly();
        if (n == 11) {
            return hashVector;
        }
        hashVector = JetRptNavigationItem.duplicatePropGrpsDesc(hashVector);
        List list = (List)hashVector.get("Others");
        list.remove("ExportToCSV");
        list.remove("ExportToText");
        list.remove("ExportToXML");
        return hashVector;
    }

    public HashVector getPropGrpsDescDirectly() {
        if (this.bEditable) {
            if (padding_left != null) {
                return padding_left;
            }
            padding_left = JetRptNavigationItem.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (padding_left == null) {
                padding_left = new HashVector();
            }
            String string = null;
            List<String> list = null;
            list = (Vector<String>)padding_left.get("Color");
            list.add("Foreground");
            string = "TextFormat";
            list = new Vector<String>(11);
            list.add("AutoFit");
            list.add("Bold");
            list.add("Italic");
            list.add("FontFace");
            list.add("FontSize");
            list.add("Underline");
            list.add("Text");
            list.add("StrikeOut");
            list.add("WordWrap");
            list.add(PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
            list.add(PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment));
            padding_left.putAt(string, list, 0);
            string = "Padding";
            list = new Vector(4);
            list.add(PropertyNames.getDefinitionName(PropertyNames.padding_top));
            list.add(PropertyNames.getDefinitionName(PropertyNames.padding_bottom));
            list.add(PropertyNames.getDefinitionName(PropertyNames.padding_left));
            list.add(PropertyNames.getDefinitionName(PropertyNames.padding_right));
            padding_left.put(string, list);
            string = "Border";
            list = new Vector(6);
            list.add(PropertyNames.getDefinitionName(PropertyNames.BorderColor));
            list.add(PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
            list.add(PropertyNames.getDefinitionName(PropertyNames.TopLine));
            list.add(PropertyNames.getDefinitionName(PropertyNames.BottomLine));
            list.add(PropertyNames.getDefinitionName(PropertyNames.LeftLine));
            list.add(PropertyNames.getDefinitionName(PropertyNames.RightLine));
            list.add(PropertyNames.getDefinitionName(PropertyNames.Shadow));
            list.add(PropertyNames.getDefinitionName(PropertyNames.ShadowColor));
            padding_left.put(string, list);
            string = "Pattern";
            list = new Vector(2);
            list.add("PatternStyle");
            list.add("PatternColor");
            padding_left.put(string, list);
            string = "Geometry";
            padding_left.remove(string);
            string = "Excel";
            padding_left.remove(string);
            string = "CSS";
            padding_left.remove(string);
            string = "Others";
            list = (List)padding_left.get("Others");
            list.clear();
            list.add("ExportToDHTML");
            list.add("ExportToCSV");
            list.add("ExportToXLS");
            list.add("ExportToHTML");
            list.add("ExportToPDF");
            list.add("ExportToText");
            list.add("ExportToRTF");
            list.add("ExportToXML");
            list.add("ExportToPostScript");
            list.add("ExportToApplet");
            string = "Accessibility";
            padding_left.remove(string);
            return padding_left;
        }
        return null;
    }
}

