/*
 * Decompiled with CFR 0.152.
 */
package jet.report.specialFuncImpl.grpByRange;

import java.util.HashMap;
import java.util.TimeZone;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.report.specialFunc.grpByRange.DateTimeIntervalGrpBy;
import jet.report.specialFunc.grpByRange.GroupByRange;
import jet.report.specialFuncImpl.grpByRange.JetRptGrpByRangeFunc;

public class JetRptDateInterval
extends JetRptGrpByRangeFunc
implements DateTimeIntervalGrpBy {
    private JetNumber SEDU = new JetNumber(this, "DateUnit", 13);
    private JetNumber equals = new JetNumber(this, "FirstDayOfWeek", 1);
    private JetNumber get = new JetNumber(this, "TimeZoneOffset", 0);
    private JetBoolean getClass = new JetBoolean(this, "UseRuntimeTimeZone", false);
    private static HashMap getDateDesc = null;

    public JetRptDateInterval() {
        this.SEDU.setCanChangeByOthers(false);
        this.equals.setCanChangeByOthers(false);
        this.get.setCanChangeByOthers(false);
        this.getClass.setCanChangeByOthers(false);
        this.grpStart.set("0");
    }

    @Override
    public void setIntervalUnit(int n) {
        this.SEDU.set(n);
    }

    @Override
    public int getIntervalUnit() {
        return this.SEDU.intValue();
    }

    @Override
    public Number getStartLine() {
        return super.getStartLineNumber();
    }

    @Override
    public int getGroupByRangeType() {
        return 3;
    }

    @Override
    public String getInstancePrefix() {
        return "DateTimeIntervalGBR";
    }

    @Override
    public void setDateUnit(int n) {
        this.setIntervalUnit(n);
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.equals.intValue();
    }

    @Override
    public int getTimeZoneOffset() {
        if (this.getClass.get()) {
            return TimeZone.getDefault().getRawOffset() / 60000;
        }
        return this.get.intValue();
    }

    @Override
    public boolean isRuntimeTimezoneUsed() {
        return this.getClass.get();
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        this.equals.set(n);
    }

    @Override
    public void setTimeZone(int n) {
        this.get.set(n);
    }

    @Override
    public void setRuntimeTimezoneUsed(boolean bl) {
        this.getClass.set(bl);
    }

    @Override
    protected boolean isEquals(GroupByRange groupByRange) {
        boolean bl = super.isEquals(groupByRange);
        if (bl) {
            DateTimeIntervalGrpBy dateTimeIntervalGrpBy = (DateTimeIntervalGrpBy)groupByRange;
            bl = bl && dateTimeIntervalGrpBy.getStartLine().equals(this.getStartLine());
            bl = bl && dateTimeIntervalGrpBy.getInterval().equals(this.getInterval());
            bl = bl && dateTimeIntervalGrpBy.getIntervalUnit() == this.getIntervalUnit();
            bl = bl && dateTimeIntervalGrpBy.getFirstDayOfWeek() == this.getFirstDayOfWeek();
            bl = bl && dateTimeIntervalGrpBy.getTimeZoneOffset() == this.getTimeZoneOffset();
            boolean bl2 = bl = bl && dateTimeIntervalGrpBy.isGroupingToOthers() == this.isGroupingToOthers();
            if (bl && dateTimeIntervalGrpBy.isGroupingToOthers()) {
                bl = dateTimeIntervalGrpBy.getOthersGroupingName().equals(this.getOthersGroupingName());
            }
        }
        return bl;
    }

    public String toString() {
        return this.getSimpleDescription();
    }

    public String stringOfDateUnit(int n) {
        switch (n) {
            case 13: {
                return "second(s)".intern();
            }
            case 12: {
                return "minute(s)".intern();
            }
            case 22: {
                return "quarter(s)".intern();
            }
            case 10: {
                return "hour(s)".intern();
            }
            case 5: {
                return "day(s)".intern();
            }
            case 24: {
                return "week(s)".intern();
            }
            case 23: {
                return "bi-week(s)".intern();
            }
            case 21: {
                return "half-month(s)".intern();
            }
            case 2: {
                return "month(s)".intern();
            }
            case 20: {
                return "half-year(s)".intern();
            }
            case 1: {
                return "year(s)".intern();
            }
        }
        return "<UNKOWN UNIT>".intern();
    }

    @Override
    public String getSimpleDescription() {
        try {
            return SumrySpecKeyTool.getDateDesc(this.SEDU.intValue(), this.interval.get());
        }
        catch (DSException dSException) {
            throw new RuntimeException(dSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (getDateDesc == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (getDateDesc == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("UseRuntimeTimeZone", n++);
                    hashMap.put("TimeZoneOffset", n++);
                    hashMap.put("DateUnit", n++);
                    hashMap.put("FirstDayOfWeek", n++);
                    getDateDesc = hashMap;
                }
            }
        }
        return getDateDesc;
    }
}

