/*
 * Decompiled with CFR 0.152.
 */
package jet.report.specialFuncImpl.grpByRange;

import java.math.BigDecimal;
import java.util.HashMap;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetString;
import jet.report.JetRptObject;
import jet.report.specialFunc.SpecialFunction;
import jet.report.specialFunc.grpByRange.GroupByRange;

public abstract class JetRptGrpByRangeFunc
extends JetRptObject
implements GroupByRange {
    protected JetString interval;
    protected JetNumber intervalType;
    protected JetNumber grpStartType;
    protected JetString otherGrpName;
    protected JetString grpStart;
    protected JetBoolean isGrpOther;
    private static HashMap afterInit = null;

    JetRptGrpByRangeFunc() {
        this.removePropertiesAndGroups();
        this.interval = new JetString(this, "Interval", "0");
        this.otherGrpName = new JetString(this, "OtherGrpName", "Others");
        this.grpStart = new JetString(this, "GroupStart", "0");
        this.isGrpOther = new JetBoolean(this, "IsGroupingOther", false);
        this.intervalType = new JetNumber(this, "IntervalType", -5);
        this.grpStartType = new JetNumber(this, "GroupStartType", -5);
        this.interval.setCanChangeByOthers(false);
        this.otherGrpName.setCanChangeByOthers(false);
        this.grpStart.setCanChangeByOthers(false);
        this.isGrpOther.setCanChangeByOthers(false);
    }

    @Override
    public void afterInit() {
        String string;
        int n;
        if (this.grpStartType.intValue() == -5 && (n = (string = this.grpStart.get()).lastIndexOf(46)) > 0) {
            this.grpStart.set(string.substring(0, n));
        }
        super.afterInit();
    }

    @Override
    public Number getInterval() {
        Number number = this.SEDU(this.interval.get(), this.intervalType.intValue());
        return number.intValue();
    }

    private Number SEDU(String string, int n) {
        switch (n) {
            case 5: {
                return Short.valueOf(string);
            }
            case -6: {
                return new Byte(string);
            }
            case 4: {
                return Integer.valueOf(string);
            }
            case -5: {
                return Long.valueOf(string);
            }
            case 7: {
                return new Float(string);
            }
            case 2: 
            case 3: {
                return new BigDecimal(string);
            }
            case 6: 
            case 8: {
                return new Double(string);
            }
        }
        throw new NumberFormatException(string);
    }

    @Override
    public String getOthersGroupingName() {
        return this.otherGrpName.get();
    }

    @Override
    public Number getStartLine() {
        Number number = this.SEDU(this.grpStart.get(), this.grpStartType.intValue());
        return number.intValue();
    }

    protected final Number getStartLineNumber() {
        return this.SEDU(this.grpStart.get(), this.grpStartType.intValue());
    }

    @Override
    public boolean isGroupingToOthers() {
        return this.isGrpOther.get();
    }

    @Override
    public int getFunctionType() {
        return 1;
    }

    @Override
    public void setStartLine(Number number) {
        this.setStartLine(String.valueOf(number), -5);
    }

    public void setStartLine(String string) {
        this.setStartLine(string, -5);
    }

    @Override
    public void setStartLine(String string, int n) {
        this.grpStart.set(string);
        this.grpStartType.set(n);
    }

    @Override
    public void setInterval(String string) {
        this.setInterval(string, -5);
    }

    @Override
    public void setInterval(String string, int n) {
        this.interval.set(string);
        this.intervalType.set(n);
    }

    @Override
    public void setOtherGroupName(String string) {
        this.otherGrpName.set(string);
    }

    @Override
    public void setIsGroupingOther(boolean bl) {
        this.isGrpOther.set(bl);
    }

    @Override
    public boolean canBeBrowse() {
        return false;
    }

    @Override
    public boolean equals(SpecialFunction specialFunction) {
        if (specialFunction != null && specialFunction.getFunctionType() == 1) {
            return this.isEquals((GroupByRange)specialFunction);
        }
        return false;
    }

    protected boolean isEquals(GroupByRange groupByRange) {
        return groupByRange.getGroupByRangeType() == this.getGroupByRangeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (afterInit == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (afterInit == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    int n = 0;
                    hashMap.put("IntervalType", n++);
                    hashMap.put("Interval", n++);
                    hashMap.put("OtherGrpName", n++);
                    hashMap.put("IsGroupingOther", n++);
                    hashMap.put("GroupStart", n++);
                    afterInit = hashMap;
                }
            }
        }
        return afterInit;
    }
}

