/*
 * Decompiled with CFR 0.152.
 */
package jet.report.tabular;

import com.jinfonet.util.JRLog;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetUnitNumber;
import jet.report.JetRptDataContainer;
import jet.report.tabular.JetRptColumnGroupSet;
import jet.report.tabular.JetRptGridColumn;
import jet.report.tabular.JetRptGridRow;
import jet.report.tabular.JetRptRowGroupSet;
import jet.report.tabular.JetRptTabularCell;
import jet.report.tabular.JetRptTabularColumns;
import jet.report.tabular.JetRptTabularRows;
import jet.reportLogic.objectLogic.tabularLogic.Columns;
import jet.reportLogic.objectLogic.tabularLogic.GridCell;
import jet.reportLogic.objectLogic.tabularLogic.GridColumn;
import jet.reportLogic.objectLogic.tabularLogic.GridRow;
import jet.reportLogic.objectLogic.tabularLogic.Rows;
import jet.reportLogic.objectLogic.tabularLogic.Tabular;
import jet.reportLogic.objectLogic.tabularLogic.TabularCell;
import jet.reportLogic.objectLogic.tabularLogic.TabularTree;
import jet.util.HashVector;
import jet.util.IntVector;

public class JetRptTabular
extends JetRptDataContainer {
    public static final int VBORDERSPACING = 0;
    public static final int HBORDERSPACING = 1;
    private Tabular SEDU = null;
    public JetNumber columnNumber;
    public JetNumber rowNumber;
    public JetBoolean verticalAutoSize;
    public JetBoolean horizontalAutoSize;
    public JetBoolean horizontal;
    public JetBoolean borderCollapse;
    public JetUnitNumber vBorderSpacing;
    public JetUnitNumber hBorderSpacing;
    private static HashMap Z = null;
    private static HashVector add = null;

    public JetRptTabular() {
        this.Z();
        this.setObjectType(46);
    }

    @Override
    public void setEditable() {
        super.setEditable();
    }

    @Override
    public void afterInit() {
        this.SEDU = this.parseTabularFrame();
        super.afterInit();
    }

    public int[] getBorderSpacing() {
        int[] nArray = new int[]{this.vBorderSpacing.getUnit(), this.hBorderSpacing.getUnit()};
        return nArray;
    }

    public void setBorderSpacing(int n, int n2) {
        this.vBorderSpacing.setUnitValue(n);
        this.hBorderSpacing.setUnitValue(n2);
    }

    public Tabular parseTabularFrame() {
        this.SEDU = new Tabular();
        this.SEDU.setBottomBorder(this.bottomBorderWidth.getUnit());
        this.SEDU.setTopBorder(this.topBorderWidth.getUnit());
        this.SEDU.setLeftBorder(this.leftBorderWidth.getUnit());
        this.SEDU.setRightBorder(this.rightBorderWidth.getUnit());
        int[] nArray = this.getBorderSpacing();
        Rows rows = this.SEDU.getRows();
        rows.vCellSpacing = nArray[0];
        JetRptTabularRows jetRptTabularRows = this.getTabularRows();
        Vector vector = jetRptTabularRows.getRptGridRows();
        for (int i = 0; i < vector.size(); ++i) {
            rows.add(new GridRow(((JetRptGridRow)vector.elementAt((int)i)).rowHeight.get()));
        }
        Columns columns = this.SEDU.getColumns();
        columns.hCellSpacing = nArray[1];
        JetRptTabularColumns jetRptTabularColumns = this.getTabularColumns();
        Vector vector2 = jetRptTabularColumns.getRptGridColumns();
        for (int i = 0; i < vector2.size(); ++i) {
            columns.add(new GridColumn(((JetRptGridColumn)vector2.elementAt((int)i)).columnWidth.get()));
        }
        JetRptTabularCell[] jetRptTabularCellArray = this.getTabularCells();
        for (int i = 0; i < jetRptTabularCellArray.length; ++i) {
            TabularCell tabularCell = new TabularCell(jetRptTabularCellArray[i].getTabularCellId());
            this.SEDU.markAddress(tabularCell.getAddress());
            GridCell[] gridCellArray = this.getCells(jetRptTabularCellArray[i]);
            for (int j = 0; j < gridCellArray.length; ++j) {
                tabularCell.addGridCell(gridCellArray[j]);
            }
            this.SEDU.addTabularCell(tabularCell);
        }
        return this.SEDU;
    }

    public JetRptTabularRows getTabularRows() {
        JetRptTabularRows jetRptTabularRows = null;
        Vector vector = this.getChildren();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof JetRptTabularRows)) continue;
                jetRptTabularRows = (JetRptTabularRows)vector.elementAt(i);
                break;
            }
        }
        return jetRptTabularRows;
    }

    public JetRptTabularColumns getTabularColumns() {
        JetRptTabularColumns jetRptTabularColumns = null;
        Vector vector = this.getChildren();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof JetRptTabularColumns)) continue;
                jetRptTabularColumns = (JetRptTabularColumns)vector.elementAt(i);
                break;
            }
        }
        return jetRptTabularColumns;
    }

    public JetRptTabularCell[] getTabularCells() {
        Vector vector = this.getChildren();
        Vector vector2 = new Vector();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptTabularCell)) continue;
            vector2.add(vector.elementAt(i));
        }
        JetRptTabularCell[] jetRptTabularCellArray = new JetRptTabularCell[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            jetRptTabularCellArray[i] = (JetRptTabularCell)vector2.elementAt(i);
        }
        return jetRptTabularCellArray;
    }

    public IntVector getIntIDTabularCells() {
        Vector vector = this.getChildren();
        IntVector intVector = new IntVector();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptTabularCell)) continue;
            intVector.addElement(((JetRptTabularCell)vector.elementAt(i)).getTabularCellId());
        }
        return intVector;
    }

    public JetRptRowGroupSet getRowGroupSet() {
        Vector vector = this.getChildren();
        JetRptRowGroupSet jetRptRowGroupSet = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptRowGroupSet)) continue;
            jetRptRowGroupSet = (JetRptRowGroupSet)vector.elementAt(i);
            break;
        }
        return jetRptRowGroupSet;
    }

    public JetRptColumnGroupSet getColumnGroupSet() {
        Vector vector = this.getChildren();
        JetRptColumnGroupSet jetRptColumnGroupSet = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptColumnGroupSet)) continue;
            jetRptColumnGroupSet = (JetRptColumnGroupSet)vector.elementAt(i);
            break;
        }
        return jetRptColumnGroupSet;
    }

    public Vector getColumnGroups() {
        return this.getColumnGroupSet().getChildren();
    }

    public Vector getRowGroups() {
        return this.getRowGroupSet().getChildren();
    }

    public Vector getTabularTree() {
        Vector<IntVector> vector = new Vector<IntVector>();
        TabularTree tabularTree = this.SEDU().generateTtree();
        for (int i = 0; i < tabularTree.getRowSize(); ++i) {
            IntVector intVector = tabularTree.getRow(i);
            vector.add(intVector);
        }
        return vector;
    }

    public String getRptCellInstName(int n) {
        return this.getInstName() + "@TCell" + n;
    }

    public JetRptTabularCell getTabularCell(String string) {
        Vector vector = this.getChildren();
        JetRptTabularCell jetRptTabularCell = null;
        for (int i = 0; !(i >= vector.size() || vector.elementAt(i) instanceof JetRptTabularCell && (jetRptTabularCell = (JetRptTabularCell)vector.elementAt(i)).getInstName().equals(string)); ++i) {
        }
        return jetRptTabularCell;
    }

    public JetRptTabularCell getTabularCell(int n) {
        Vector vector = this.getChildren();
        JetRptTabularCell jetRptTabularCell = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JetRptTabularCell)) continue;
            jetRptTabularCell = (JetRptTabularCell)vector.elementAt(i);
            if (jetRptTabularCell.cellId.get() == n) break;
        }
        return jetRptTabularCell;
    }

    public int getAmountOfTabularCells() {
        return this.SEDU().getTabularCellAmount();
    }

    public GridCell[] getCells(JetRptTabularCell jetRptTabularCell) {
        int n = jetRptTabularCell.startX.get();
        int n2 = jetRptTabularCell.startY.get();
        int n3 = jetRptTabularCell.gridWidth.get();
        int n4 = jetRptTabularCell.gridHeight.get();
        GridCell[] gridCellArray = new GridCell[n3 * n4];
        int n5 = 0;
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                GridCell gridCell = new GridCell(i, j);
                gridCellArray[n5++] = gridCell;
            }
        }
        return gridCellArray;
    }

    private Tabular SEDU() {
        if (this.SEDU == null) {
            this.SEDU = this.parseTabularFrame();
        }
        return this.SEDU;
    }

    public void setTabularFrame(Tabular tabular) {
        this.SEDU = tabular;
    }

    public int getTabularHeight() {
        return this.SEDU().getTabulaHeight();
    }

    public int getTabularWidth() {
        return this.SEDU().getTabularWidth();
    }

    public int getTabularCellWidth(int n) {
        return this.SEDU().getTabularCellWidth(n);
    }

    public int getTabularCellHeight(int n) {
        return this.SEDU().getTabularCellHeight(n);
    }

    public int getTabualrCellHorizontalDistance(int n) {
        return this.SEDU().getTabualrCellHorizontalDistance(n);
    }

    public int getTabularCellVerticalDistance(int n) {
        return this.SEDU().getTabularCellVerticalDistance(n);
    }

    public int getGridCellHeightAt(int n) {
        return this.SEDU().getRows().getGridRowHeightAt(n);
    }

    public int getGridCellWidthAt(int n) {
        return this.SEDU().getColumns().getGridColumnWidthAt(n);
    }

    @Override
    public String getInstancePrefix() {
        return "Tabular";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (Z == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (Z == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("VerticalBorderSpacing", n++);
                    hashMap.put("HorizontalBorderSpacing", n++);
                    hashMap.put("border-collapse", n++);
                    hashMap.put("HorizontalAutoSize", n++);
                    hashMap.put("rowNumber", n++);
                    hashMap.put("Horizontal", n++);
                    hashMap.put("VerticalAutoSize", n++);
                    hashMap.put("columnNumber", n++);
                    Z = hashMap;
                }
            }
        }
        return Z;
    }

    private void Z() {
        this.columnNumber = new JetNumber(this, "columnNumber");
        this.rowNumber = new JetNumber(this, "rowNumber");
        this.verticalAutoSize = new JetBoolean(this, "VerticalAutoSize", true);
        this.horizontalAutoSize = new JetBoolean(this, "HorizontalAutoSize", false);
        this.horizontal = new JetBoolean(this, "Horizontal", false);
        this.borderCollapse = new JetBoolean(this, "border-collapse", false);
        this.vBorderSpacing = new JetUnitNumber(this, "VerticalBorderSpacing");
        this.hBorderSpacing = new JetUnitNumber(this, "HorizontalBorderSpacing");
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            if (add != null) {
                return add;
            }
            add = JetRptTabular.duplicatePropGrpsDesc(super.getPropGrpsDesc());
            if (add == null) {
                add = new HashVector();
            }
            String string = "Others";
            List<String> list = (Vector<String>)add.get(string);
            list.add("VerticalAutoSize");
            list.add("HorizontalAutoSize");
            list.remove("direction");
            list.remove("SuppressedIfNoRecords");
            list.remove("RecordLocation");
            list.add("ExportToHTML");
            list.add("ExportToPDF");
            list.add("ExportToText");
            list.add("ExportToRTF");
            list.add("ExportToXML");
            list.add("ExportToPostScript");
            list.add("ExportToApplet");
            string = "Border";
            add.remove(string);
            string = "TOC";
            list = new Vector<String>(2);
            add.put(string, list);
            list.add("TOCAnchor");
            list.add("AnchorDispValue");
            string = "Accessibility";
            list = (List)add.get(string);
            add.remove(string);
            add.put(string, list);
            return add;
        }
        return null;
    }

    public String toString() {
        if (JRLog.isTrace(6) && this.SEDU != null) {
            return this.SEDU.toString();
        }
        return "";
    }
}

