/*
 * Decompiled with CFR 0.152.
 */
package jet.report.vct;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetColor;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.ireport.IComponent;
import jet.ireport.IDataContainer;
import jet.report.JetRptColumns;
import jet.report.JetRptMsgToActionItem;
import jet.report.JetRptTemplatibleContainer;
import jet.report.JetRptTitleTextField;
import jet.report.grpProps.JetGradientGroundProperties;
import jet.report.grpProps.JetTextureGroundProperties;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.report.vct.JetRptVCTBodys;
import jet.report.vct.JetRptVCTDisplayType;
import jet.report.vct.JetRptVCTFilters;
import jet.report.vct.JetRptVCTGroup;
import jet.report.vct.JetRptVCTSorters;
import jet.report.vct.disp.JetRptVCTDispTypeAuto;
import jet.report.vct.header.JetRptVCTAxisDB;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.util.HashVector;

public class JetRptVCTObject
extends JetRptTemplatibleContainer
implements IDataContainer,
IComponent {
    private volatile JetQualifyReference SEDU = new JetQualifyReference(this, "ColumnAttrs");
    protected JetQualifyReference dataSet = new JetQualifyReference(this, "dataSet");
    private volatile JetString WHITE = new JetString(this, "RunTimeInstName");
    protected JetNumber displayTypeScope;
    protected JetNumber rowBgType;
    protected JetNumber colBgType;
    protected JetColor rowBgColor;
    protected JetColor colBgColor;
    protected JetGradientGroundProperties rowBgGradient;
    protected JetGradientGroundProperties colBgGradient;
    protected JetTextureGroundProperties rowBgTexture;
    protected JetTextureGroundProperties colBgTexture;
    private JetRptVCTGroup Z;
    private JetRptVCTGroup add;
    private JetRptVCTBodys afterInit;
    private JetRptVCTFilters background;
    private JetRptVCTSorters enableAllChangeBys;
    private JetRptFlyFormulaMeasureSet endClr;
    private static HashMap endX = null;

    public JetRptVCTObject() {
        this.WHITE.enableAllChangeBys(false);
        this.displayTypeScope = new JetNumber(this, "DisplayTypeScope", 0);
        this.displayTypeScope.enableAllChangeBys(false);
        this.rowBgType = new JetNumber(this, "RowBackgroundType", 1);
        this.setChangeByAndAuto(this.rowBgType, false, true, true);
        this.rowBgColor = new JetColor(this, "RowBackground", Color.WHITE, true);
        this.setChangeByAndAuto(this.rowBgColor, false, true, true);
        this.rowBgGradient = new JetGradientGroundProperties(this, "RowBG");
        this.setChangeByAndAuto(this.rowBgGradient.style, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.startClr, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.endClr, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.startX, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.startY, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.endX, false, true, true);
        this.setChangeByAndAuto(this.rowBgGradient.endY, false, true, true);
        this.rowBgTexture = new JetTextureGroundProperties(this, "RowBG");
        this.setChangeByAndAuto(this.rowBgTexture.style, false, true, true);
        this.setChangeByAndAuto(this.rowBgTexture.background, false, true, true);
        this.setChangeByAndAuto(this.rowBgTexture.foreground, false, true, true);
        this.colBgType = new JetNumber(this, "ColBackgroundType", 0);
        this.colBgColor = new JetColor(this, "ColBackground", Color.WHITE, true);
        this.setChangeByAndAuto(this.colBgColor, false, true, true);
        this.colBgGradient = new JetGradientGroundProperties(this, "ColBG");
        this.setChangeByAndAuto(this.colBgGradient.style, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.startClr, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.endClr, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.startX, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.startY, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.endX, false, true, true);
        this.setChangeByAndAuto(this.colBgGradient.endY, false, true, true);
        this.colBgTexture = new JetTextureGroundProperties(this, "ColBG");
        this.setChangeByAndAuto(this.colBgTexture.style, false, true, true);
        this.setChangeByAndAuto(this.colBgTexture.background, false, true, true);
        this.setChangeByAndAuto(this.colBgTexture.foreground, false, true, true);
    }

    protected final void setChangeByAndAuto(JetProperty jetProperty, boolean bl, boolean bl2, boolean bl3) {
        jetProperty.enableAllChangeBys(bl);
        jetProperty.setEnableAutoValue(bl2);
        if (bl2 && bl3) {
            jetProperty.setAsAutoValue(true);
        }
    }

    @Override
    public void afterInit() {
        if (!this.bAfterInited) {
            this.resetVCTStatus();
        }
        super.afterInit();
        this.bAfterInited = true;
    }

    public void resetVCTStatus() {
        super.afterInit();
        Vector vector = this.getChildren();
        for (Object e : vector) {
            if (e instanceof JetRptVCTBodys) {
                this.afterInit = (JetRptVCTBodys)e;
                continue;
            }
            if (e instanceof JetRptVCTGroup) {
                if (((JetRptVCTGroup)e).isColumnGroup()) {
                    this.Z = (JetRptVCTGroup)e;
                    continue;
                }
                this.add = (JetRptVCTGroup)e;
                continue;
            }
            if (e instanceof JetRptVCTFilters) {
                this.background = (JetRptVCTFilters)e;
                continue;
            }
            if (e instanceof JetRptVCTSorters) {
                this.enableAllChangeBys = (JetRptVCTSorters)e;
                continue;
            }
            if (!(e instanceof JetRptFlyFormulaMeasureSet)) continue;
            this.endClr = (JetRptFlyFormulaMeasureSet)e;
        }
    }

    @Override
    public String getInstancePrefix() {
        return "VCTObject";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (endX == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (endX == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("dataSet", n++);
                    hashMap.put("RunTimeInstName", n++);
                    hashMap.put("DisplayTypeScope", n++);
                    hashMap.put("RowBackgroundType", n++);
                    hashMap.put("RowBackground", n++);
                    n = JetGradientGroundProperties.fillIndecialMap("RowBG", hashMap);
                    n = JetTextureGroundProperties.fillIndecialMap("RowBG", hashMap);
                    hashMap.put("ColBackgroundType", n++);
                    hashMap.put("ColBackground", n++);
                    n = JetGradientGroundProperties.fillIndecialMap("ColBG", hashMap);
                    n = JetTextureGroundProperties.fillIndecialMap("ColBG", hashMap);
                    endX = hashMap;
                }
            }
        }
        return endX;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return new HashVector(0);
    }

    @Override
    public final boolean canBeBrowse() {
        return false;
    }

    @Override
    public int getObjectType() {
        return 262186;
    }

    @Override
    public final boolean isInheritDataSet() {
        return false;
    }

    @Override
    public final DataSet getBindedDataSet() {
        return (DataSet)this.dataSet.getObject();
    }

    @Override
    public void setBindedDataSet(boolean bl, DataSet dataSet) {
        if (bl || dataSet == null) {
            throw new IllegalArgumentException("Can not set inherit or null dataset to VCT now");
        }
        this.dataSet.setObject(dataSet);
    }

    @Override
    public JetRptColumns getColumnAttrs() {
        return (JetRptColumns)this.SEDU.getObject();
    }

    @Override
    public void setColumnAttrs(JetRptColumns jetRptColumns) {
        this.SEDU.setObject(jetRptColumns);
    }

    @Override
    public List getAllMessageToItemList() {
        Vector<JetRptMsgToActionItem> vector = new Vector<JetRptMsgToActionItem>();
        for (JetObject jetObject : this.getChildren()) {
            if (!(jetObject instanceof JetRptMsgToActionItem)) continue;
            vector.add((JetRptMsgToActionItem)jetObject);
        }
        return vector;
    }

    @Override
    public void setRuntimeInstName(String string) {
        this.WHITE.set(string);
    }

    @Override
    public String getRuntimeInstName() {
        return this.WHITE.get();
    }

    @Override
    public JetRptFlyFormulaMeasureSet getFlyFormulaMeasureSet() {
        if (this.endClr == null) {
            for (JetObject jetObject : this.getChildren()) {
                if (!(jetObject instanceof JetRptFlyFormulaMeasureSet)) continue;
                this.endClr = (JetRptFlyFormulaMeasureSet)jetObject;
            }
        }
        return this.endClr;
    }

    @Override
    public JetRptTitleTextField getTitleObject() {
        return null;
    }

    @Override
    public void setTitleObject(JetRptTitleTextField jetRptTitleTextField) {
    }

    @Override
    public void clearTitleObject() {
    }

    public int getDisplayTypeScope() {
        return this.displayTypeScope.intValue();
    }

    public void setDisplayTypeScope(int n) {
        this.displayTypeScope.set(n);
    }

    public List getDisplayTypes() {
        Vector<JetRptVCTDisplayType> vector = new Vector<JetRptVCTDisplayType>();
        int n = this.displayTypeScope.intValue();
        if (n == 0) {
            vector.add(this.SEDU());
        } else if (n == 1 || n == 2) {
            JetRptVCTGroup jetRptVCTGroup = this.getVCTGroup(n == 2);
            List list = jetRptVCTGroup.getAllVCTAxisDBs();
            if (list.size() == 0) {
                vector.add(this.SEDU());
            } else {
                for (JetRptVCTAxisDB jetRptVCTAxisDB : list) {
                    vector.add(jetRptVCTAxisDB.getUsedDisplayType());
                }
            }
        } else {
            throw new UnsupportedOperationException("Error Usage");
        }
        return vector;
    }

    private JetRptVCTDisplayType SEDU() {
        Vector vector = this.getChildren();
        JetRptVCTDisplayType jetRptVCTDisplayType = null;
        for (Object e : vector) {
            if (!(e instanceof JetRptVCTDisplayType)) continue;
            jetRptVCTDisplayType = (JetRptVCTDisplayType)e;
        }
        return jetRptVCTDisplayType;
    }

    public JetRptVCTDisplayType getCalculatedAutoDispType(JetRptVCTDispTypeAuto jetRptVCTDispTypeAuto) {
        return ObjectLogicFactory.getVCTLogic().getCalculatedAutoDispType(this, jetRptVCTDispTypeAuto);
    }

    public JetRptVCTGroup getVCTGroup(boolean bl) {
        if (bl) {
            if (this.Z == null) {
                Vector vector = this.getChildren();
                for (Object e : vector) {
                    if (!(e instanceof JetRptVCTGroup) || !((JetRptVCTGroup)e).isColumnGroup()) continue;
                    this.Z = (JetRptVCTGroup)e;
                    break;
                }
            }
            return this.Z;
        }
        if (this.add == null) {
            Vector vector = this.getChildren();
            for (Object e : vector) {
                if (!(e instanceof JetRptVCTGroup) || ((JetRptVCTGroup)e).isColumnGroup()) continue;
                this.add = (JetRptVCTGroup)e;
                break;
            }
        }
        return this.add;
    }

    public JetRptVCTBodys getVCTBodys() {
        if (this.afterInit == null) {
            Vector vector = this.getChildren();
            for (Object e : vector) {
                if (!(e instanceof JetRptVCTBodys)) continue;
                this.afterInit = (JetRptVCTBodys)e;
                break;
            }
        }
        return this.afterInit;
    }

    public JetRptVCTFilters getVCTFilterContainer() {
        if (this.background == null) {
            Vector vector = this.getChildren();
            for (Object e : vector) {
                if (!(e instanceof JetRptVCTFilters)) continue;
                this.background = (JetRptVCTFilters)e;
                break;
            }
        }
        return this.background;
    }

    public JetRptVCTSorters getVCTSorterContainer() {
        if (this.enableAllChangeBys == null) {
            Vector vector = this.getChildren();
            for (Object e : vector) {
                if (!(e instanceof JetRptVCTSorters)) continue;
                this.enableAllChangeBys = (JetRptVCTSorters)e;
                break;
            }
        }
        return this.enableAllChangeBys;
    }
}

