/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.builder;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.controls.JetObject;
import jet.ireport.IReport;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.TabulaAction;
import jet.reportLogic.builder.ResizingActionBuilder;

public class ChangeTabulaCellHeightBuilder
extends ResizingActionBuilder {
    private IReport SEDU;
    private JetRptTabular addAtomicAction;
    private JetRptTabular append;
    private int[] cellId;
    private boolean getAction = true;
    private int getChildren;
    private int getHeight;
    private int getOriginalObject;
    private boolean getUnit = false;
    private boolean hasNext;

    public ChangeTabulaCellHeightBuilder(Object object, Object object2, int n, int n2) {
        this(object, object2, n, n2, true);
    }

    public ChangeTabulaCellHeightBuilder(Object object, Object object2, int n, int n2, boolean bl) {
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = new int[]{n};
        this.getHeight = n2;
        this.hasNext = bl;
    }

    public ChangeTabulaCellHeightBuilder(Object object, Object object2, int[] nArray, int n) {
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = nArray;
        this.getOriginalObject = n;
        this.getUnit = true;
        this.hasNext = true;
    }

    public ChangeTabulaCellHeightBuilder(Object object, Object object2, int[] nArray, int n, int n2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ChangeTabulaCellHeightBuilder: to change cell ids = " + this.SEDU(nArray) + " dispersion = " + n, null);
            JRLog.trace(6, object2, null);
            JRLog.trace(6, "RptTabular:" + this.addAtomicAction(object2), null);
        }
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = nArray;
        this.getAction = false;
        this.getHeight = n;
        this.getChildren = n2;
    }

    private String SEDU(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int n : nArray) {
            stringBuffer.append(n);
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String addAtomicAction(Object object) {
        if (!(object instanceof JetRptTabular)) {
            return null;
        }
        Vector vector = ((JetRptTabular)object).getChildren();
        StringBuffer stringBuffer = new StringBuffer();
        for (JetObject jetObject : vector) {
            if (!(jetObject instanceof JetRptTabularCell)) continue;
            JetRptTabularCell jetRptTabularCell = (JetRptTabularCell)jetObject;
            stringBuffer.append(jetRptTabularCell.cellId);
            stringBuffer.append("( w = ");
            stringBuffer.append(jetRptTabularCell.getHeight().getUnit());
            stringBuffer.append("), ");
        }
        return stringBuffer.toString();
    }

    @Override
    public Action build() {
        TabulaAction tabulaAction = new TabulaAction();
        if (!this.getAction) {
            tabulaAction.prepareToChangeCellsHeight(this.addAtomicAction, this.cellId, this.getHeight, this.getChildren);
        } else if (this.getUnit) {
            tabulaAction.prepareToChangeCellsHeightByRow(this.addAtomicAction, this.cellId, this.getOriginalObject);
        } else {
            tabulaAction.prepareToChangeCellHeight(this.addAtomicAction, this.cellId[0], this.getHeight, this.hasNext);
        }
        this.getAction().addAtomicAction(tabulaAction);
        if (this.append != this.addAtomicAction) {
            tabulaAction = new TabulaAction();
            if (!this.getAction) {
                tabulaAction.prepareToChangeCellsHeight(this.append, this.cellId, this.getHeight, this.getChildren);
            } else if (this.getUnit) {
                tabulaAction.prepareToChangeCellsHeightByRow(this.append, this.cellId, this.getOriginalObject);
            } else {
                tabulaAction.prepareToChangeCellHeight(this.append, this.cellId[0], this.getHeight, this.hasNext);
            }
            this.getAction().addAtomicAction(tabulaAction);
        }
        return this.getAction();
    }
}

