/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.builder;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.controls.JetObject;
import jet.ireport.IReport;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.TabulaAction;
import jet.reportLogic.builder.ResizingActionBuilder;

public class ChangeTabulaCellWidthBuilder
extends ResizingActionBuilder {
    private IReport SEDU;
    private JetRptTabular addAtomicAction;
    private JetRptTabular append;
    private int[] cellId;
    private boolean getAction = true;
    private int getChildren;
    private int getOriginalObject;
    private int getUnit;
    private boolean getWidth;
    private boolean hasNext = false;

    public ChangeTabulaCellWidthBuilder(Object object, Object object2, int n, int n2) {
        this(object, object2, n, n2, false);
    }

    public ChangeTabulaCellWidthBuilder(Object object, Object object2, int n, int n2, boolean bl) {
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = new int[]{n};
        this.getOriginalObject = n2;
        this.getWidth = bl;
    }

    public ChangeTabulaCellWidthBuilder(Object object, Object object2, int[] nArray, int n) {
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = nArray;
        this.getUnit = n;
        this.getWidth = true;
        this.hasNext = true;
    }

    public ChangeTabulaCellWidthBuilder(Object object, Object object2, int[] nArray, int n, int n2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ChangeTabulaCellWidthBuilder: to change cell ids = " + this.SEDU(nArray) + " dispersion = " + n, null);
            JRLog.trace(6, object2, null);
            JRLog.trace(6, "RptTabular:" + this.addAtomicAction(object2), null);
        }
        this.SEDU = object == null ? null : (IReport)object;
        this.addAtomicAction = (JetRptTabular)object2;
        this.append = (JetRptTabular)this.getOriginalObject(this.SEDU, this.addAtomicAction);
        this.cellId = nArray;
        this.getOriginalObject = n;
        this.getChildren = n2;
        this.getAction = false;
    }

    private String SEDU(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int n : nArray) {
            stringBuffer.append(n);
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String addAtomicAction(Object object) {
        if (!(object instanceof JetRptTabular)) {
            return null;
        }
        Vector vector = ((JetRptTabular)object).getChildren();
        StringBuffer stringBuffer = new StringBuffer();
        for (JetObject jetObject : vector) {
            if (!(jetObject instanceof JetRptTabularCell)) continue;
            JetRptTabularCell jetRptTabularCell = (JetRptTabularCell)jetObject;
            stringBuffer.append(jetRptTabularCell.cellId);
            stringBuffer.append("( w = ");
            stringBuffer.append(jetRptTabularCell.getWidth().getUnit());
            stringBuffer.append("), ");
        }
        return stringBuffer.toString();
    }

    @Override
    public Action build() {
        TabulaAction tabulaAction = new TabulaAction();
        if (!this.getAction) {
            tabulaAction.prepareToChangeCellsWidth(this.addAtomicAction, this.cellId, this.getOriginalObject, this.getChildren);
        } else if (this.hasNext) {
            tabulaAction.prepareToChangeCellsWidthByColumn(this.addAtomicAction, this.cellId, this.getUnit);
        } else {
            tabulaAction.prepareToChangeCellWidth(this.addAtomicAction, this.cellId[0], this.getOriginalObject, this.getWidth);
        }
        this.getAction().addAtomicAction(tabulaAction);
        if (this.append != this.addAtomicAction) {
            tabulaAction = new TabulaAction();
            if (!this.getAction) {
                tabulaAction.prepareToChangeCellsWidth(this.append, this.cellId, this.getOriginalObject, this.getChildren);
            } else if (this.hasNext) {
                tabulaAction.prepareToChangeCellsWidthByColumn(this.append, this.cellId, this.getUnit);
            } else {
                tabulaAction.prepareToChangeCellWidth(this.append, this.cellId[0], this.getOriginalObject, this.getWidth);
            }
            this.getAction().addAtomicAction(tabulaAction);
        }
        return this.getAction();
    }
}

