/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.builder;

import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.icontrols.PropValueInfo;
import jet.ireport.IReport;
import jet.report.JetRptArea;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.report.JetRptField;
import jet.report.JetRptMap;
import jet.report.JetRptMapDBField;
import jet.report.JetRptMapTextField;
import jet.report.JetRptPolyLine;
import jet.report.JetRptView;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.PropertyAction;
import jet.reportLogic.builder.EditingActionBuilder;
import jet.reportLogic.objectInfo.JPropValueInfoImpl;
import jet.util.MapUtil;

public class EditMapActualSizeActionBuilder
extends EditingActionBuilder {
    private IReport SEDU;
    private JetRptMap actHeight;
    private double actWidth;
    private double addAtomicAction;
    private boolean append;

    public EditMapActualSizeActionBuilder(Object object, JetRptMap jetRptMap, int n, int n2) {
        this(object, jetRptMap, n, n2, true);
    }

    public EditMapActualSizeActionBuilder(Object object, JetRptMap jetRptMap, int n, int n2, boolean bl) {
        this.SEDU = object == null ? null : (IReport)object;
        this.actHeight = jetRptMap;
        int n3 = jetRptMap.getActualWidth();
        int n4 = jetRptMap.getActualHeight();
        this.actWidth = (double)n / ((double)n3 * 1.0);
        this.addAtomicAction = (double)n2 / ((double)n4 * 1.0);
        this.append = bl;
    }

    @Override
    public Action build() {
        if (this.actWidth != 1.0 || this.addAtomicAction != 1.0) {
            JetRptView jetRptView = null;
            if (this.SEDU != null) {
                jetRptView = (JetRptView)this.getCurrentViewObj(this.SEDU);
            }
            this.coordParts(this.actHeight, jetRptView, this.actHeight.actWidth, this.actWidth);
            this.coordParts(this.actHeight, jetRptView, this.actHeight.actHeight, this.addAtomicAction);
            Vector vector = this.actHeight.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                JetObject jetObject = (JetObject)vector.get(i);
                if (jetObject instanceof JetRptArea) {
                    this.SEDU((JetRptArea)jetObject, jetRptView);
                    continue;
                }
                if (jetObject instanceof JetRptField) {
                    this.actWidth((JetRptField)jetObject, jetRptView);
                    continue;
                }
                if (!(jetObject instanceof JetRptPolyLine)) continue;
                this.addAtomicAction((JetRptPolyLine)jetObject, jetRptView);
            }
        }
        return this.getAction();
    }

    private void SEDU(JetRptArea jetRptArea, JetRptView jetRptView) {
        block15: {
            Vector vector;
            int n;
            block14: {
                int n2;
                Object object;
                if (jetRptArea.isDefaultTypeArea()) {
                    return;
                }
                int[][] nArray = jetRptArea.parseShapeInUnit();
                StringBuffer stringBuffer = new StringBuffer();
                switch (jetRptArea.type.intValue()) {
                    case 2: {
                        stringBuffer.append((int)((double)nArray[0][0] * this.actWidth)).append(",");
                        stringBuffer.append((int)((double)nArray[0][1] * this.addAtomicAction)).append(",");
                        stringBuffer.append((int)((double)nArray[0][2] * Math.min(this.actWidth, this.addAtomicAction))).append(",");
                        break;
                    }
                    case 1: {
                        stringBuffer.append((int)((double)nArray[0][0] * this.actWidth)).append(",");
                        stringBuffer.append((int)((double)nArray[0][1] * this.addAtomicAction)).append(",");
                        stringBuffer.append((int)((double)nArray[0][2] * this.actWidth)).append(",");
                        stringBuffer.append((int)((double)nArray[0][3] * this.addAtomicAction)).append(",");
                        break;
                    }
                    case 3: 
                    case 4: {
                        for (int i = 0; i < nArray.length; ++i) {
                            for (n = 0; n < nArray[i].length; n += 2) {
                                stringBuffer.append((int)((double)nArray[i][n] * this.actWidth)).append(",");
                                stringBuffer.append((int)((double)nArray[i][n + 1] * this.addAtomicAction)).append(",");
                            }
                        }
                        break;
                    }
                }
                this.append(jetRptView, jetRptArea, jetRptArea.coords.getName(), stringBuffer.substring(0, stringBuffer.length() - 1));
                vector = jetRptArea.getChildren();
                n = vector.size();
                if (!this.append) break block14;
                JetRptAreaText jetRptAreaText = null;
                for (int i = 0; i < n; ++i) {
                    object = (JetObject)vector.get(i);
                    if (!(object instanceof JetRptAreaText)) continue;
                    jetRptAreaText = (JetRptAreaText)object;
                    break;
                }
                if (jetRptAreaText == null) break block15;
                double[][] dArray = MapUtil.getLargestShapeResult(jetRptArea.type.intValue(), jetRptArea.coords.get(), jetRptArea.coordParts.get());
                object = MapUtil.getGeomertyCenterWithoutEmpty(jetRptArea.type.intValue(), dArray[0][0], dArray[1]);
                if (object[2] == 0.0) {
                    object = MapUtil.getNearestPointToGCenter(dArray[1], (double[])object);
                }
                object[0] = object[0] * this.actWidth;
                object[1] = object[1] * this.addAtomicAction;
                dArray[0][0] = dArray[0][0] * this.actWidth * this.addAtomicAction;
                int n3 = jetRptAreaText.width.getUnit();
                int n4 = jetRptAreaText.height.getUnit();
                int n5 = (int)(object[0] - (double)(n3 / 2));
                if (n5 < 0) {
                    n5 = 0;
                }
                if ((n2 = (int)(object[1] - (double)(n4 / 2))) < 0) {
                    n2 = 0;
                }
                boolean bl = (double)(n3 * n4) > dArray[0][0];
                this.actHeight(jetRptAreaText, jetRptView, bl, n5, n2, (int)object[0], (int)object[1], (int)object[0], (int)object[1]);
                n2 += jetRptAreaText.height.getUnit();
                for (int i = 0; i < n; ++i) {
                    JetObject jetObject = (JetObject)vector.get(i);
                    if (!(jetObject instanceof JetRptField) || jetObject == jetRptAreaText) continue;
                    this.actHeight((JetRptField)jetObject, jetRptView, bl, n5, n2, (int)object[0], (int)object[1], (int)object[0], (int)object[1]);
                    n2 += jetRptAreaText.height.getUnit();
                }
                break block15;
            }
            for (int i = 0; i < n; ++i) {
                JetObject jetObject = (JetObject)vector.get(i);
                if (!(jetObject instanceof JetRptField)) continue;
                this.actWidth((JetRptField)jetObject, jetRptView);
            }
        }
    }

    private void actHeight(JetRptField jetRptField, JetRptView jetRptView, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        PropertyAction propertyAction = new PropertyAction();
        propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetRptField, jetRptField.x.getName(), String.valueOf(n), false);
        this.getAction().addAtomicAction(propertyAction);
        propertyAction = new PropertyAction();
        propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetRptField, jetRptField.y.getName(), String.valueOf(n2), false);
        this.getAction().addAtomicAction(propertyAction);
        propertyAction = new PropertyAction();
        propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetRptField, jetRptField.invisible.getName(), String.valueOf(bl), false);
        this.getAction().addAtomicAction(propertyAction);
        Vector vector = ((JetContainable)((Object)jetRptField)).getChildren();
        int n7 = vector.size();
        for (int i = 0; i < n7; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (!(jetObject instanceof JetRptPolyLine)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n3).append(",").append(n4).append(",");
            stringBuffer.append(n5).append(",").append(n6);
            this.append(jetRptView, jetObject, "Coordinates", stringBuffer.toString());
            propertyAction = new PropertyAction();
            propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetObject, ((JetRptPolyLine)jetObject).invisible.getName(), String.valueOf(false), false);
            this.getAction().addAtomicAction(propertyAction);
        }
    }

    private void actWidth(JetRptField jetRptField, JetRptView jetRptView) {
        if (!(jetRptField instanceof JetRptMapTextField) && !(jetRptField instanceof JetRptMapDBField)) {
            this.coordParts(jetRptField, jetRptView, jetRptField.x, this.actWidth);
            this.coordParts(jetRptField, jetRptView, jetRptField.y, this.addAtomicAction);
            if (jetRptField instanceof JetRptAreaText || jetRptField instanceof JetRptAreaDBText) {
                Vector vector = ((JetContainable)((Object)jetRptField)).getChildren();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    JetObject jetObject = (JetObject)vector.get(i);
                    if (!(jetObject instanceof JetRptPolyLine)) continue;
                    this.addAtomicAction((JetRptPolyLine)jetObject, jetRptView);
                }
            } else {
                this.coordParts(jetRptField, jetRptView, jetRptField.width, this.actWidth);
                this.coordParts(jetRptField, jetRptView, jetRptField.height, this.addAtomicAction);
            }
        }
    }

    private void addAtomicAction(JetRptPolyLine jetRptPolyLine, JetRptView jetRptView) {
        int[] nArray = jetRptPolyLine.parsePointsInUnit();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; i += 2) {
            stringBuffer.append((int)((double)nArray[i] * this.actWidth)).append(",");
            stringBuffer.append((int)((double)nArray[i + 1] * this.addAtomicAction)).append(",");
        }
        this.append(jetRptView, jetRptPolyLine, "Coordinates", stringBuffer.substring(0, stringBuffer.length() - 1));
    }

    private void append(JetRptView jetRptView, JetObject jetObject, String string, Object object) {
        PropertyAction propertyAction = new PropertyAction();
        PropValueInfo propValueInfo = JPropValueInfoImpl.createNormalValueInfo(object);
        propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetObject, string, propValueInfo, 0);
        this.getAction().addAtomicAction(propertyAction);
    }

    private void coordParts(JetObject jetObject, JetRptView jetRptView, JetUnitNumber jetUnitNumber, double d) {
        int n;
        if (jetUnitNumber.isChangeByOther() || jetUnitNumber.isChangeByBL() || jetUnitNumber.isChagneByFmtt()) {
            return;
        }
        int n2 = jetUnitNumber.getUnit();
        if (n2 != (n = (int)((double)n2 * d * (double)(d < 0.0 ? -1 : 1)))) {
            PropertyAction propertyAction = new PropertyAction();
            propertyAction.prepareToEditProperty(null, (Object)jetRptView, (Object)jetObject, jetUnitNumber.getName(), String.valueOf(n), false);
            this.getAction().addAtomicAction(propertyAction);
        }
    }
}

