/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.builder.chart;

import chart.ChartDefinition;
import chart.ChartShowValueInfo;
import java.util.List;
import java.util.Vector;
import jet.controls.JetObject;
import jet.report.chart.JetRptChartAxisBehaviourFunction;
import jet.report.chart.JetRptChartAxisLinkFunction;
import jet.report.chart.JetRptChartPaper;
import jet.report.chart.JetRptChartPlatform;
import jet.report.chart.JetRptChartShValBehaviourFunction;
import jet.report.chart.JetRptChartShValLinkFunction;
import jet.report.chart.JetRptChartShowValueFunc;
import jet.report.chart.JetRptChartShowValueFuncContainer;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;

class EditChartsFunctionToolkit {
    BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();

    EditChartsFunctionToolkit() {
    }

    protected static void validateEditFunctionOnShowValue(ChartDefinition chartDefinition, ChartShowValueInfo chartShowValueInfo) throws IllegalArgumentException {
        List list = chartDefinition.getShowValueInfoList();
        boolean bl = false;
        for (ChartShowValueInfo chartShowValueInfo2 : list) {
            if (!chartShowValueInfo2.isEqual(chartShowValueInfo)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("The Editing Chart doesn't has this ShowValue: " + EditChartsFunctionToolkit.toString(chartShowValueInfo));
        }
    }

    private static String toString(ChartShowValueInfo chartShowValueInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ChartShowValueInfo@[VT=").append(chartShowValueInfo.getValueType()).append(",");
        stringBuilder.append("CT=").append(chartShowValueInfo.getChartType()).append(",");
        stringBuilder.append("AT=").append(chartShowValueInfo.getAixsType()).append(",");
        stringBuilder.append("VN=").append(chartShowValueInfo.getValueOrignName()).append(",");
        stringBuilder.append("VD=").append(chartShowValueInfo.getValueDisplayName()).append("]");
        return stringBuilder.toString();
    }

    protected JetRptChartShValBehaviourFunction forShowValueBehaviourFunction(JetRptChartPlatform jetRptChartPlatform, ChartShowValueInfo chartShowValueInfo) {
        JetRptChartShowValueFunc jetRptChartShowValueFunc = this.SEDU(jetRptChartPlatform, chartShowValueInfo);
        JetRptChartShValBehaviourFunction jetRptChartShValBehaviourFunction = jetRptChartShowValueFunc.getRptShowValueBehaviourFunctionInst();
        if (jetRptChartShValBehaviourFunction == null) {
            jetRptChartShValBehaviourFunction = new JetRptChartShValBehaviourFunction();
            jetRptChartShValBehaviourFunction.setEditable();
            this.basicComponentLogic.add(jetRptChartShowValueFunc, jetRptChartShValBehaviourFunction);
        }
        return jetRptChartShValBehaviourFunction;
    }

    protected JetRptChartShValLinkFunction forShowValueLinkFunction(JetRptChartPlatform jetRptChartPlatform, ChartShowValueInfo chartShowValueInfo) {
        JetRptChartShowValueFunc jetRptChartShowValueFunc = this.SEDU(jetRptChartPlatform, chartShowValueInfo);
        JetRptChartShValLinkFunction jetRptChartShValLinkFunction = jetRptChartShowValueFunc.getRptShowValueLinkFunctionInst();
        if (jetRptChartShValLinkFunction == null) {
            jetRptChartShValLinkFunction = new JetRptChartShValLinkFunction();
            jetRptChartShValLinkFunction.setEditable();
            this.basicComponentLogic.add(jetRptChartShowValueFunc, jetRptChartShValLinkFunction);
        }
        return jetRptChartShValLinkFunction;
    }

    protected static JetRptChartAxisLinkFunction forAxisLinkFunction(JetRptChartPaper jetRptChartPaper, boolean bl) {
        return jetRptChartPaper.getRptAxisLinkFunctionInst(bl, true);
    }

    protected static JetRptChartAxisBehaviourFunction forAxisBehaviourFunction(JetRptChartPaper jetRptChartPaper, boolean bl) {
        return jetRptChartPaper.getRptAxisBehaviourFunctionInst(bl, true);
    }

    private JetRptChartShowValueFunc SEDU(JetRptChartPlatform jetRptChartPlatform, ChartShowValueInfo chartShowValueInfo) {
        Vector vector = jetRptChartPlatform.getChildren();
        JetRptChartShowValueFuncContainer jetRptChartShowValueFuncContainer = null;
        JetRptChartShowValueFunc jetRptChartShowValueFunc = null;
        for (JetObject jetObject : vector) {
            if (!(jetObject instanceof JetRptChartShowValueFuncContainer)) continue;
            jetRptChartShowValueFuncContainer = (JetRptChartShowValueFuncContainer)jetObject;
            break;
        }
        if (jetRptChartShowValueFuncContainer == null) {
            jetRptChartShowValueFuncContainer = new JetRptChartShowValueFuncContainer();
            jetRptChartShowValueFuncContainer.setEditable();
            this.basicComponentLogic.add(jetRptChartPlatform, jetRptChartShowValueFuncContainer);
            jetRptChartShowValueFunc = new JetRptChartShowValueFunc(chartShowValueInfo);
            jetRptChartShowValueFunc.setEditable();
            this.basicComponentLogic.add(jetRptChartShowValueFuncContainer, jetRptChartShowValueFunc);
        } else {
            if (jetRptChartPlatform.getChartDefinition().isHeatMapChart()) {
                chartShowValueInfo = (ChartShowValueInfo)jetRptChartPlatform.getChartDefinition().getShowValueInfoList().get(0);
            }
            vector = jetRptChartShowValueFuncContainer.getChildren();
            for (JetObject jetObject : vector) {
                JetRptChartShowValueFunc jetRptChartShowValueFunc2;
                if (!(jetObject instanceof JetRptChartShowValueFunc) || !(jetRptChartShowValueFunc2 = (JetRptChartShowValueFunc)jetObject).isForShowValue(chartShowValueInfo)) continue;
                jetRptChartShowValueFunc = jetRptChartShowValueFunc2;
                break;
            }
            if (jetRptChartShowValueFunc == null) {
                jetRptChartShowValueFunc = new JetRptChartShowValueFunc(chartShowValueInfo);
                jetRptChartShowValueFunc.setEditable();
                this.basicComponentLogic.add(jetRptChartShowValueFuncContainer, jetRptChartShowValueFunc);
            }
        }
        return jetRptChartShowValueFunc;
    }
}

