/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectInfo;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;
import jet.controls.JetProperty;
import jet.icontrols.PropValueInfo;
import jet.reportLogic.objectInfo.JPropValueInfoImpl;

public abstract class AbstractObjectInfo {
    Map properties = new Hashtable();

    public Map getPropertyValues() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = new Hashtable();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void setPropertyValues(Map map) {
        this.properties = new Hashtable();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.setPropertyValue((String)entry.getKey(), (PropValueInfo)entry.getValue());
            }
        }
    }

    public void setPropertyValue(String string, PropValueInfo propValueInfo) {
        if (this.isSkipProperty(string)) {
            return;
        }
        if (propValueInfo == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, propValueInfo);
        }
    }

    public PropValueInfo getPropertyValue(String string) {
        return (PropValueInfo)this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (object instanceof PropValueInfo) {
            this.setPropertyValue(string, (PropValueInfo)object);
        } else if (object instanceof JetProperty) {
            this.setPropertyValue(string, ((JetProperty)object).getCurrentValue());
        } else if (object instanceof Color) {
            this.setPropertyValue(string, new JPropValueInfoImpl((Color)object));
        } else {
            this.setPropertyValue(string, new JPropValueInfoImpl(object, JPropValueInfoImpl.createUnitStringValue(object)));
        }
    }

    public void setPropertyValue(String string, Color color) {
        this.setPropertyValue(string, new JPropValueInfoImpl(color));
    }

    public void setPropertyValue(String string, Object object, String string2) {
        if (object instanceof PropValueInfo) {
            this.setPropertyValue(string, (PropValueInfo)object);
        } else if (object instanceof JetProperty) {
            this.setPropertyValue(string, ((JetProperty)object).getCurrentValue());
        } else if (object instanceof Color) {
            this.setPropertyValue(string, new JPropValueInfoImpl((Color)object));
        } else {
            this.setPropertyValue(string, new JPropValueInfoImpl(object, string2));
        }
    }

    public void setPropertyChangedBy(String string, Object object, int n, short s) {
        this.setPropertyValue(string, new JPropValueInfoImpl(n, s, object));
    }

    public boolean isPropertyChangeBy(String string) {
        PropValueInfo propValueInfo = (PropValueInfo)this.properties.get(string);
        if (propValueInfo == null) {
            return false;
        }
        int n = propValueInfo.getValueType();
        return n == 1 || n == 2 || n == 0;
    }

    protected boolean isSkipProperty(String string) {
        return false;
    }
}

