/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectInfo;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.icontrols.PropValueInfo;
import jet.naming.EnumerationConstant;
import jet.reportLogic.objectInfo.FormattedInfo;
import jet.reportLogic.objectInfo.JPropValueInfoImpl;
import jet.reportLogic.objectInfo.ObjectPropVFInfo;
import jet.util.MapUtil;
import jet.util.MiscTools;

public class AreaInfo
extends ObjectPropVFInfo
implements FormattedInfo {
    public static int AREATYPE_DEFAULT = 0;
    public static int AREATYPE_CIRCLE = 2;
    public static int AREATYPE_POLYGON = 3;
    public static int AREATYPE_RECTANGLE = 1;
    public static int AREATYPE_POLYGONS = 4;
    public static final int EDIT_CANRECOORD = 0;
    private static final int AREATYPE_STR_NAMES = 31;
    public static final String AREATYPE_DEFAULT_STR = EnumerationConstant.AREATYPE_STR_NAMES[0];
    public static final String DEFAULT_NAME = "Area";
    private String BLACK = null;
    List areaTextInfos = new Vector();

    public void resetAllProperties(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null) {
            super.setPropertyValues(new Hashtable());
        } else {
            Hashtable<String, JPropValueInfoImpl> hashtable3 = new Hashtable<String, JPropValueInfoImpl>(hashtable.size());
            for (Map.Entry entry : hashtable.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                Boolean bl = (Boolean)hashtable2.get(string);
                if (bl == null || !bl.booleanValue()) {
                    hashtable3.put(string, new JPropValueInfoImpl((Object)string2, string2));
                    continue;
                }
                hashtable3.put(string, new JPropValueInfoImpl(0, 0, string2));
            }
            super.setPropertyValues(hashtable3);
        }
    }

    public void appendProperties(Hashtable hashtable, Hashtable hashtable2) {
        for (Map.Entry entry : hashtable.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            Boolean bl = (Boolean)hashtable2.get(string);
            if (bl != null && bl.booleanValue()) {
                this.setPropertyChangedBy(string, string2, 0, (short)0);
                continue;
            }
            this.setPropertyValue(string, string2, string2);
        }
    }

    public AreaInfo(int n, String string) {
        this(n, string, 0, 31);
    }

    public AreaInfo(int n, String string, int n2, int n3) {
        if (n == AREATYPE_DEFAULT || string == null) {
            this.setPropertyValue("Type", 0, AREATYPE_DEFAULT_STR);
        } else {
            this.setPropertyValue("Type", n, EnumerationConstant.AREATYPE_STR_NAMES[n]);
            this.setPropertyValue("Coordinates", string, string);
            this.setPropertyValue("CoordEditable", n3, String.valueOf(n3));
            this.setPropertyValue("CoordParts", n2, String.valueOf(n2));
        }
    }

    public boolean isDefaultArea() {
        String string = (String)this.getProperty("Type");
        return string != null && AREATYPE_DEFAULT_STR.equals(string);
    }

    public int getAreaType() {
        String string = (String)this.getProperty("Type");
        for (int i = AREATYPE_DEFAULT; i <= AREATYPE_POLYGONS; ++i) {
            if (!EnumerationConstant.AREATYPE_STR_NAMES[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getCoordinates() {
        return (String)this.getProperty("Coordinates");
    }

    public String getCoordinateParts() {
        return (String)this.getProperty("CoordParts");
    }

    public int getCoordinatePartsInt() {
        String string = (String)this.getProperty("CoordParts");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public boolean isCoordinateEditable(int n) {
        String string = (String)this.getProperty("CoordEditable");
        if (string == null) {
            return true;
        }
        int n2 = Integer.parseInt(string);
        return (n2 & n) > 0;
    }

    public void setAreaTextInfo(List list) {
        this.areaTextInfos = list;
    }

    public List getAreaTextInfos() {
        return this.areaTextInfos;
    }

    public static Hashtable getConditionDefault() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("FillColor", "Transparent");
        hashtable.put("BoundaryColor", MiscTools.mapColorToString(Color.BLACK));
        hashtable.put("BoundaryStyle", EnumerationConstant.BORDERSTYLE_STR_NAMES[1]);
        hashtable.put("BoundaryWidth", String.valueOf(Unit.convertPixelToUnit(1)));
        return hashtable;
    }

    public boolean isFromDataBase() {
        PropValueInfo propValueInfo = this.getPropertyValue("Coordinates");
        return propValueInfo != null && propValueInfo.getValueType() == 0;
    }

    public void setInstName(String string) {
        this.BLACK = string;
    }

    public String getInstName() {
        return this.BLACK;
    }

    public AreaInfo() {
    }

    @Override
    public double getInfoVersion() {
        return 1.1;
    }

    @Override
    public List getToXMLChildren() {
        return null;
    }

    @Override
    public Hashtable getToXMLPropMarks() {
        return new Hashtable();
    }

    @Override
    public Hashtable getToXMLProperties() {
        Map map = this.getPropertyValues();
        Hashtable hashtable = new Hashtable(map.size());
        for (Map.Entry entry : map.entrySet()) {
            String string;
            PropValueInfo propValueInfo = (PropValueInfo)entry.getValue();
            if (propValueInfo.getValueType() != -1 || (string = propValueInfo.toUnitString()) == null) continue;
            hashtable.put(entry.getKey(), string);
        }
        return hashtable;
    }

    @Override
    public String getXMLTagName() {
        return DEFAULT_NAME;
    }

    @Override
    public void setXMLChildren(List list) {
    }

    @Override
    public void setXMLProperty(String string, String string2, boolean bl) {
        if (bl) {
            return;
        }
        this.setPropertyValue(string, string2, string2);
    }

    public static int[][] parseAreaShapeCoordinate(int n, String string, String string2) {
        return MapUtil.parseAreaShapeCoordinate(n, string, string2);
    }

    protected void resetConditionalSettings(Map map) {
        Iterator iterator = map.entrySet().iterator();
        Hashtable hashtable = AreaInfo.getConditionDefault();
        Vector vector = new Vector(hashtable.keySet());
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setPropertyChangedBy((String)entry.getKey(), entry.getValue(), 0, (short)0);
            vector.remove(entry.getKey());
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            this.setPropertyValue(string, hashtable.get(string), (String)hashtable.get(string));
        }
    }

    protected void restoreConditionalSettings() {
        Hashtable hashtable = AreaInfo.getConditionDefault();
        for (Map.Entry entry : hashtable.entrySet()) {
            this.setPropertyValue((String)entry.getKey(), entry.getValue(), (String)entry.getValue());
        }
    }
}

