/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectInfo;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import jet.report.mode.common.RptAction;
import jet.report.mode.common.RptAtomicAction;
import jet.report.mode.common.RptEventToActionItem;
import jet.report.mode.common.cusAction.CustomAtomicAction;

public class EventToActionInfo
implements RptEventToActionItem {
    private int emIdType;
    private List<Object> emCondition;
    private boolean isMessageDef = false;
    private RptAction action;

    public EventToActionInfo(int eventType, RptAction action) {
        this(eventType, null, action);
    }

    public EventToActionInfo(int eventType, int[] condition, RptAction action) {
        if (action == null) {
            throw new IllegalAccessError();
        }
        this.isMessageDef = false;
        this.emIdType = eventType;
        this.setCondition(null, condition);
        this.action = action;
    }

    public EventToActionInfo(int msgId, String msgName, int[] condition, RptAction action) {
        if (!this.validateAction(action)) {
            throw new IllegalAccessError("Null Action or Contains SendMessage[Debug:Report created in developing version before 201105");
        }
        this.isMessageDef = true;
        this.emIdType = msgId;
        this.setCondition(msgName, condition);
        this.action = action;
    }

    private void setCondition(String msgName, int[] condition) {
        int sz = condition == null ? 0 : condition.length;
        Vector<Integer> tempList = new Vector<Integer>();
        for (int i = 0; i < sz; ++i) {
            if (tempList.contains(condition[i])) continue;
            tempList.add(condition[i]);
        }
        sz = tempList.size();
        if (this.isMessageDef) {
            this.emCondition = new Vector<Object>(sz + 1);
            this.emCondition.add(msgName == null ? "" : msgName);
            this.emCondition.addAll(tempList);
        } else {
            this.emCondition = new Vector<Object>(sz);
            this.emCondition.addAll(tempList);
        }
        tempList.clear();
        tempList = null;
    }

    public boolean isForMessageAction() {
        return this.isMessageDef;
    }

    @Override
    public int getEventType() {
        if (this.isMessageDef) {
            throw new IllegalAccessError();
        }
        return this.emIdType;
    }

    @Override
    public void setEventType(int eventType) {
        if (this.isMessageDef) {
            throw new IllegalAccessError();
        }
        this.emIdType = eventType;
    }

    @Override
    public int[] getCondition() {
        int sz = this.emCondition.size();
        int offset = this.isMessageDef ? 1 : 0;
        int[] ret = new int[sz - offset];
        for (int sIdx = offset; sIdx < sz; ++sIdx) {
            ret[sIdx - offset] = (Integer)this.emCondition.get(sIdx);
        }
        return ret;
    }

    @Override
    public void setContintion(int[] condition) {
        if (this.isMessageDef) {
            this.setCondition(this.getMessageName(), condition);
        } else {
            this.setCondition(null, condition);
        }
    }

    public void setMessage(int msgId, String msgName, int[] condition) {
        if (!this.isMessageDef) {
            throw new IllegalAccessError();
        }
        this.emIdType = msgId;
        this.setCondition(msgName, condition);
    }

    public int getMessageId() {
        if (this.isMessageDef) {
            return this.emIdType;
        }
        throw new IllegalAccessError();
    }

    public String getMessageName() {
        if (this.isMessageDef) {
            return (String)this.emCondition.get(0);
        }
        throw new IllegalAccessError();
    }

    public RptAction getAction() {
        return this.action;
    }

    public void setAction(RptAction action) {
        if (action == null) {
            throw new IllegalAccessError();
        }
        this.action = action;
    }

    public boolean isEqualEventCondition(int eventType, int[] condition) {
        if (this.isMessageDef) {
            return false;
        }
        return this.emIdType == eventType && this.isEqualsCondition(this.getCondition(), condition);
    }

    public boolean isEqualMessageCondition(int msgId, String msgName, int[] condition) {
        if (this.isMessageDef) {
            boolean isEquals;
            if (this.emIdType != msgId) {
                return false;
            }
            boolean bl = isEquals = msgId == this.emIdType;
            isEquals = isEquals && this.getMessageName().equals(msgName == null ? "" : msgName);
            return isEquals && this.isEqualsCondition(this.getCondition(), condition);
        }
        return false;
    }

    private boolean isEqualsCondition(int[] thisCondition, int[] checkCondition) {
        int objLen;
        int thisLen = thisCondition.length;
        int n = objLen = checkCondition == null ? 0 : checkCondition.length;
        if (thisLen != objLen) {
            return false;
        }
        int fitCount = 0;
        block0: for (int i = 0; i < thisLen; ++i) {
            for (int j = 0; j < objLen; ++j) {
                if (checkCondition[j] != thisCondition[i]) continue;
                ++fitCount;
                continue block0;
            }
        }
        return fitCount == thisLen;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventToActionInfo) {
            EventToActionInfo objInfo = (EventToActionInfo)obj;
            if (objInfo.isMessageDef != this.isMessageDef) {
                return false;
            }
            if (objInfo.isMessageDef) {
                if (this.isEqualMessageCondition(objInfo.getMessageId(), objInfo.getMessageName(), objInfo.getCondition())) {
                    return this.action == objInfo.action || this.action.equals(objInfo.action);
                }
                return false;
            }
            if (this.isEqualEventCondition(objInfo.getEventType(), objInfo.getCondition())) {
                return this.action == objInfo.action || this.action.equals(objInfo.action);
            }
            return false;
        }
        return false;
    }

    @Override
    @Deprecated
    public void appendCondition(int condition) {
        int sz = this.emCondition.size();
        int offset = this.isMessageDef ? 1 : 0;
        Vector<Integer> tempList = new Vector<Integer>(sz - offset);
        for (int sIdx = offset; sIdx < sz; ++sIdx) {
            tempList.add((Integer)this.emCondition.get(sIdx));
        }
        if (!tempList.contains(condition)) {
            this.emCondition.add(condition);
        }
        tempList.clear();
        tempList = null;
    }

    @Override
    @Deprecated
    public RptAction getRefAction() {
        return this.getAction();
    }

    @Override
    @Deprecated
    public void setRefAction(RptAction act) {
        this.setAction(act);
    }

    @Override
    @Deprecated
    public boolean isThisItem(int eventType, int[] conditions) {
        return this.isEqualEventCondition(eventType, conditions);
    }

    @Override
    @Deprecated
    public boolean equalAs(RptEventToActionItem eaItem) {
        if (this.isMessageDef) {
            return false;
        }
        if (this.isEqualEventCondition(eaItem.getEventType(), eaItem.getCondition())) {
            return this.action == eaItem.getRefAction() || this.action.equals(eaItem.getRefAction());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DebugInfo ");
        buf.append(this.isMessageDef ? "For Receive-Event]" : "For Normal-Event]");
        if (!this.isMessageDef) {
            buf.append("event-type:").append(this.getEventType());
        } else {
            buf.append("message-Id:").append(this.getMessageId());
            buf.append(",message-Name:").append(this.getMessageName());
        }
        buf.append(",condition:").append(Arrays.toString(this.getCondition()));
        buf.append(",action:").append(String.valueOf(this.action));
        return buf.toString();
    }

    private boolean validateAction(RptAction action) {
        RptAtomicAction[] atomics;
        if (action == null) {
            return false;
        }
        for (RptAtomicAction atomic : atomics = action.expandAndGetAllAtomicAction()) {
            if (atomic.getAtomicType() != 4 || ((CustomAtomicAction)atomic).getCustomizeActionType() != 11) continue;
            return false;
        }
        return true;
    }
}

