/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectInfo;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.icontrols.PropValueInfo;
import jet.reportLogic.objectInfo.ObjectTemplatePropInfo;
import jet.reportLogic.objectInfo.TabularCellInfo;
import jet.util.HashVector;
import jet.util.ValueToUnit;

public class TabularInfo
extends ObjectTemplatePropInfo {
    public static int ERR_COUNT_PERMIT = -1;
    public static int X_ERROR_PERMIT = ValueToUnit.convertPixelToUnit(1);
    public static int Y_ERROR_PERMIT = ValueToUnit.convertPixelToUnit(1);
    private static Comparator SEDU = new Comparator(){

        public int compare(TabularCellInfo tabularCellInfo, TabularCellInfo tabularCellInfo2) {
            return tabularCellInfo.getStartX() - tabularCellInfo2.getStartX();
        }
    };
    private static Comparator abs = new Comparator(){

        public int compare(TabularCellInfo tabularCellInfo, TabularCellInfo tabularCellInfo2) {
            return tabularCellInfo.getStartY() - tabularCellInfo2.getStartY();
        }
    };
    private List add;
    private List append;
    private List booleanValue;
    private List clear;
    private List containsKey;

    public TabularInfo(List list) throws IllegalArgumentException {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No TabularCellInfo");
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        this.containsKey = this.ERR_COUNT_PERMIT(list, hashtable, hashtable2);
        this.SEDU(hashtable, true);
        this.SEDU(hashtable2, false);
        int[] nArray = this.abs(hashtable, hashtable2);
        this.setProperty("Width", String.valueOf(nArray[0]), false);
        this.setProperty("Height", String.valueOf(nArray[1]), false);
        this.add = this.add(hashtable, true);
        this.append = this.add(hashtable2, false);
        this.clear = this.append(hashtable, true);
        this.booleanValue = this.append(hashtable2, false);
        this.setProperty("columnNumber", String.valueOf(hashtable.size()), false);
        this.setProperty("rowNumber", String.valueOf(hashtable2.size()), false);
    }

    private List ERR_COUNT_PERMIT(List list, Hashtable hashtable, Hashtable hashtable2) {
        Object object2;
        for (Object object2 : list) {
            Vector vector = (Vector)hashtable.get(((TabularCellInfo)object2).getStartX());
            if (vector == null) {
                vector = new Vector();
                hashtable.put(((TabularCellInfo)object2).getStartX(), vector);
            }
            vector.add(object2);
            Vector vector2 = (Vector)hashtable2.get(((TabularCellInfo)object2).getStartY());
            if (vector2 == null) {
                vector2 = new Vector();
                hashtable2.put(((TabularCellInfo)object2).getStartY(), vector2);
            }
            vector2.add(object2);
        }
        object2 = hashtable.values().iterator();
        while (object2.hasNext()) {
            Collections.sort((List)object2.next(), abs);
        }
        object2 = hashtable2.values().iterator();
        while (object2.hasNext()) {
            Collections.sort((List)object2.next(), SEDU);
        }
        return list;
    }

    private void SEDU(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector(hashtable.keySet());
        Collections.sort(vector);
        HashVector<Integer, Integer> hashVector = new HashVector<Integer, Integer>();
        HashSet<Integer> hashSet = null;
        if (ERR_COUNT_PERMIT >= 0) {
            hashSet = new HashSet<Integer>(ERR_COUNT_PERMIT);
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            int n2;
            List list = (List)hashtable.get(vector.get(i));
            int n3 = Integer.MAX_VALUE;
            for (n2 = 0; n2 < list.size(); ++n2) {
                Integer n4;
                int n5;
                TabularCellInfo tabularCellInfo = (TabularCellInfo)list.get(n2);
                if (bl) {
                    n = tabularCellInfo.getGridWidth();
                    n5 = tabularCellInfo.getCellWidth();
                } else {
                    n = tabularCellInfo.getGridHeight();
                    n5 = tabularCellInfo.getCellHeight();
                }
                if (n < n3) {
                    n3 = n;
                }
                if ((n4 = (Integer)hashVector.get(new Integer(n))) == null) {
                    hashVector.put(n, n5);
                    continue;
                }
                if (hashSet == null || n4 == n5) continue;
                int n6 = n4 - n5;
                int n7 = Math.abs(n6);
                if (bl) {
                    if (n7 > X_ERROR_PERMIT) {
                        throw new IllegalArgumentException("same grid col span but dif width");
                    }
                    hashSet.add(n6);
                    if (hashSet.size() < ERR_COUNT_PERMIT) continue;
                    throw new IllegalArgumentException("same grid col span but dif width");
                }
                if (n7 > Y_ERROR_PERMIT) {
                    throw new IllegalArgumentException("same grid row span but dif height");
                }
                hashSet.add(n6);
                if (hashSet.size() < ERR_COUNT_PERMIT) continue;
                throw new IllegalArgumentException("same grid row span but dif height");
            }
            if (hashSet != null) {
                hashSet.clear();
            }
            Collections.sort(hashVector);
            for (n2 = 0; n2 < hashVector.size() - 1; ++n2) {
                int n8 = (Integer)hashVector.get(hashVector.get(n2));
                if (n8 < (n = ((Integer)hashVector.get(hashVector.get(n2 + 1))).intValue())) continue;
                throw new IllegalArgumentException("little grid-span has long size");
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                TabularCellInfo tabularCellInfo = (TabularCellInfo)list.get(n2);
                n = bl ? tabularCellInfo.getGridWidth() : tabularCellInfo.getGridHeight();
                Integer n9 = (Integer)hashVector.get(new Integer(n));
                if (bl) {
                    tabularCellInfo.setCellWidth(n9);
                    continue;
                }
                tabularCellInfo.setCellHeight(n9);
            }
            Integer n10 = (Integer)hashVector.get(new Integer(n3));
            hashVector.remove(new Integer(n3));
            for (int j = 0; j < hashVector.size(); ++j) {
                Integer n11 = (Integer)hashVector.get(j);
                Integer n12 = (Integer)hashVector.get(n11);
                hashVector.remove(n11);
                hashVector.putAt(n11 - n3, n12 - n10, j);
            }
        }
    }

    private void X_ERROR_PERMIT(TabularCellInfo tabularCellInfo, Hashtable hashtable, Integer n, boolean bl) {
        int n2;
        int n3;
        Integer n4 = null;
        if (bl) {
            n4 = tabularCellInfo.getStartX() + tabularCellInfo.getGridWidth();
            n3 = tabularCellInfo.getStartY();
            n2 = tabularCellInfo.getGridHeight();
        } else {
            n4 = tabularCellInfo.getStartY() + tabularCellInfo.getGridHeight();
            n3 = tabularCellInfo.getStartX();
            n2 = tabularCellInfo.getGridWidth();
        }
        if (hashtable.containsKey(n4)) {
            Iterator iterator = ((List)hashtable.get(n4)).iterator();
            boolean bl2 = false;
            while (!bl2 && iterator.hasNext()) {
                int n5;
                int n6;
                TabularCellInfo tabularCellInfo2 = (TabularCellInfo)iterator.next();
                if (bl) {
                    n6 = tabularCellInfo2.getStartY();
                    n5 = tabularCellInfo2.getGridHeight();
                } else {
                    n6 = tabularCellInfo2.getStartX();
                    n5 = tabularCellInfo2.getGridWidth();
                }
                int n7 = n3 - n6;
                bl2 = n7 < n5 && n7 > -1 * n2;
            }
            if (!bl2) {
                throw new IllegalArgumentException("Not all grid used at " + (bl ? "y=" : "x=") + n3);
            }
        } else if (n4 < n) {
            throw new IllegalArgumentException("Not all grid used at " + (bl ? "y=" : "x=") + n3);
        }
    }

    private int Y_ERROR_PERMIT(Hashtable hashtable, Integer n, boolean bl) {
        TabularCellInfo tabularCellInfo;
        int n2 = 0;
        Integer n3 = n;
        List list = null;
        do {
            list = (List)hashtable.get(n3);
            tabularCellInfo = (TabularCellInfo)list.get(0);
            int n4 = bl ? tabularCellInfo.getCellWidth() : tabularCellInfo.getCellHeight();
            for (int i = 1; i < list.size(); ++i) {
                TabularCellInfo tabularCellInfo2 = (TabularCellInfo)list.get(i);
                if (bl) {
                    if (tabularCellInfo2.getCellWidth() <= n4) continue;
                    tabularCellInfo = tabularCellInfo2;
                    n4 = tabularCellInfo2.getCellWidth();
                    continue;
                }
                if (tabularCellInfo2.getCellHeight() <= n4) continue;
                tabularCellInfo = tabularCellInfo2;
                n4 = tabularCellInfo2.getCellHeight();
            }
            n2 = n4 + n2;
        } while (hashtable.containsKey(n3 = bl ? Integer.valueOf(tabularCellInfo.getStartX() + tabularCellInfo.getGridWidth()) : Integer.valueOf(tabularCellInfo.getStartY() + tabularCellInfo.getGridHeight())));
        return n2;
    }

    private int[] abs(Hashtable hashtable, Hashtable hashtable2) {
        int n;
        Vector vector = new Vector(hashtable.keySet());
        Vector vector2 = new Vector(hashtable2.keySet());
        Collections.sort(vector);
        Collections.sort(vector2);
        int n2 = (Integer)vector.lastElement();
        int n3 = (Integer)vector2.lastElement();
        long l = 0L;
        for (n = 0; n < vector.size(); ++n) {
            Integer n4 = (Integer)vector.get(n);
            List list = (List)hashtable.get(n4);
            for (int i = 0; i < list.size(); ++i) {
                Integer n5;
                TabularCellInfo tabularCellInfo;
                TabularCellInfo tabularCellInfo2 = (TabularCellInfo)list.get(i);
                l += tabularCellInfo2.getCellArea();
                tabularCellInfo2.getCellArea();
                if (i + 1 < list.size() && (tabularCellInfo = (TabularCellInfo)list.get(i + 1)).getStartY() < tabularCellInfo2.getStartY() + tabularCellInfo2.getGridHeight()) {
                    throw new IllegalArgumentException("Cell overlap at start x=" + n4);
                }
                this.X_ERROR_PERMIT(tabularCellInfo2, hashtable2, n3, false);
                this.X_ERROR_PERMIT(tabularCellInfo2, hashtable, n2, true);
                for (int j = n + 1; j < vector.size() && (n5 = (Integer)vector.get(j)) < tabularCellInfo2.getStartX() + tabularCellInfo2.getGridWidth(); ++j) {
                    List list2 = (List)hashtable.get(n5);
                    for (int k = 0; k < list2.size(); ++k) {
                        TabularCellInfo tabularCellInfo3 = (TabularCellInfo)list2.get(k);
                        if (tabularCellInfo3.getStartY() + tabularCellInfo3.getGridHeight() <= tabularCellInfo2.getStartY() || tabularCellInfo3.getStartY() >= tabularCellInfo2.getStartY() + tabularCellInfo2.getGridHeight()) continue;
                        throw new IllegalArgumentException("Cell overlap at x=" + n4 + " with x=" + n5);
                    }
                }
            }
        }
        n = this.Y_ERROR_PERMIT(hashtable, (Integer)vector.firstElement(), true);
        int n6 = this.Y_ERROR_PERMIT(hashtable2, (Integer)vector2.firstElement(), false);
        long l2 = 1L * (long)n * (long)n6;
        long l3 = Math.max(n * X_ERROR_PERMIT, n6 * Y_ERROR_PERMIT);
        if (Math.abs(l2 - l) > l3) {
            throw new IllegalArgumentException("Doesn't a Rectangle");
        }
        return new int[]{n, n6};
    }

    private List add(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector(hashtable.keySet());
        Collections.sort(vector);
        HashVector<Integer, Integer> hashVector = new HashVector<Integer, Integer>();
        int n = vector.size();
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)vector.get(i);
            Integer n3 = i;
            List list = (List)hashtable.remove(n2);
            for (int j = 0; j < list.size(); ++j) {
                Integer n4;
                Integer n5;
                int n6;
                Integer n7;
                TabularCellInfo tabularCellInfo = (TabularCellInfo)list.get(j);
                if (bl) {
                    n7 = tabularCellInfo.getStartX() + tabularCellInfo.getGridWidth();
                    n6 = vector.indexOf(n7);
                    tabularCellInfo.setStartX(n3);
                    if (n6 < 0) {
                        tabularCellInfo.setGridWidth(n - i);
                    } else {
                        tabularCellInfo.setGridWidth(n6 - i);
                    }
                    n5 = tabularCellInfo.getStartX() + tabularCellInfo.getGridWidth();
                    n4 = (Integer)hashVector.get((Object)tabularCellInfo.getStartX());
                    if (n4 == null) {
                        hashVector.put(n5, tabularCellInfo.getCellWidth());
                        continue;
                    }
                    hashVector.put(n5, n4 + tabularCellInfo.getCellWidth());
                    continue;
                }
                n7 = tabularCellInfo.getStartY() + tabularCellInfo.getGridHeight();
                n6 = vector.indexOf(n7);
                tabularCellInfo.setStartY(n3);
                if (n6 < 0) {
                    tabularCellInfo.setGridHeight(n - i);
                } else {
                    tabularCellInfo.setGridHeight(n6 - i);
                }
                n5 = tabularCellInfo.getStartY() + tabularCellInfo.getGridHeight();
                n4 = (Integer)hashVector.get((Object)tabularCellInfo.getStartY());
                if (n4 == null) {
                    hashVector.put(n5, tabularCellInfo.getCellHeight());
                    continue;
                }
                hashVector.put(n5, n4 + tabularCellInfo.getCellHeight());
            }
            hashtable.put(n3, list);
        }
        Collections.sort(hashVector);
        Vector<Object> vector2 = new Vector<Object>(hashVector.size());
        vector2.add(hashVector.get(hashVector.get(0)));
        for (int i = 1; i < hashVector.size(); ++i) {
            int n8 = (Integer)hashVector.get(hashVector.get(i - 1));
            int n9 = (Integer)hashVector.get(hashVector.get(i));
            vector2.add(n9 - n8);
        }
        return vector2;
    }

    private List append(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector(hashtable.keySet());
        Collections.sort(vector);
        int n = -1;
        Vector vector2 = new Vector();
        Vector<TabularCellInfo> vector3 = new Vector<TabularCellInfo>();
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)vector.get(i);
            List list = (List)hashtable.get(n2);
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            for (int j = 0; j < list.size(); ++j) {
                int n5;
                TabularCellInfo tabularCellInfo = (TabularCellInfo)list.get(j);
                int n6 = n5 = bl ? tabularCellInfo.getGridWidth() : tabularCellInfo.getGridHeight();
                if (n5 > n3) {
                    n3 = n5;
                }
                if (n5 < n4) {
                    n4 = n5;
                }
                vector3.add(tabularCellInfo);
            }
            if (n3 == n4) {
                if ((n = n == -1 ? 0 : Math.abs(n3 - n)) != 0) continue;
                vector2.add(vector3);
                vector3 = new Vector();
                n = -1;
                continue;
            }
            n = n3 - n4;
        }
        return vector2;
    }

    protected final void setProperty(String string, String string2, boolean bl) {
        if (bl) {
            super.setPropertyChangedBy(string, string2, 0, (short)0);
        } else {
            super.setPropertyValue(string, string2, string2);
        }
    }

    protected int getIntPropVal(String string, int n) {
        PropValueInfo propValueInfo = this.getPropertyValue(string);
        if (propValueInfo == null) {
            return n;
        }
        Object object = propValueInfo.getValueObj();
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        String string2 = propValueInfo.toUnitString();
        if (string2 != null) {
            return Integer.parseInt((String)object);
        }
        return n;
    }

    public List getGridColumnWidths() {
        return this.add;
    }

    public List getGridRowHeights() {
        return this.append;
    }

    public List getTabularColumGroups() {
        return this.clear;
    }

    public List getTabularRowGroups() {
        return this.booleanValue;
    }

    public List getTabularCellInfos() {
        return this.containsKey;
    }

    public int getTabularWidth() {
        return this.getIntPropVal("Width", 0);
    }

    public int getTabularHeight() {
        return this.getIntPropVal("Height", 0);
    }

    public void setProperties(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        for (Map.Entry entry : hashtable.entrySet()) {
            Boolean bl = (Boolean)hashtable2.get(entry.getKey());
            this.setProperty((String)entry.getKey(), (String)entry.getValue(), bl != null && bl != false);
        }
    }
}

