/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import chart.ChartDefinition;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.util.JRLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetColumnName;
import jet.controls.JetColumnVector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.expression.IExpression;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IRptBody;
import jet.naming.PropertyNames;
import jet.report.JetChartProperty;
import jet.report.JetLink;
import jet.report.JetRpt2DGeometryObject;
import jet.report.JetRptArea;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggInfo;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptContainer;
import jet.report.JetRptDBField;
import jet.report.JetRptField;
import jet.report.JetRptFilterControl;
import jet.report.JetRptGroupFilter;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMap;
import jet.report.JetRptMsgToActionItem;
import jet.report.JetRptPageBreaker;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPageStart;
import jet.report.JetRptParamLink;
import jet.report.JetRptParameterField;
import jet.report.JetRptRefParameterField;
import jet.report.JetRptSection;
import jet.report.JetRptSectionColumnInfo;
import jet.report.JetRptSectionFooter;
import jet.report.JetRptSectionHeader;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSectionPagePanel;
import jet.report.JetRptSortContainer;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSubReturnValueContainer;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.report.Renderable;
import jet.report.chart.JetChartDefinition;
import jet.report.chart.JetRptChartLabel;
import jet.report.chart.JetRptChartLegend;
import jet.report.chart.JetRptChartPaper;
import jet.report.chart.JetRptChartPlatform;
import jet.report.chart.JetRptChartShowValueFuncContainer;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.JetRptTypedFilterExpression;
import jet.report.filter.variable.JetFormulaExpression;
import jet.report.filter.variable.JetReferenceExpression;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.geomap.JetRptGeoMap;
import jet.report.gmap.JetRptGMap;
import jet.report.gmap.JetRptGMarker;
import jet.report.lc.JetRptConfig;
import jet.report.link.JetLinkProperties;
import jet.report.link.Linkable;
import jet.report.link.SimpleLinkValue;
import jet.report.link.URLPattern;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.report.onTheFlyFormula.JetRptQueryFlyFormula;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.specialFunc.SpecialFunction;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableCell;
import jet.report.table.JetRptTableColumn;
import jet.report.table.JetRptTableGrid;
import jet.report.table.JetRptTableGroup;
import jet.report.table.JetRptTableRowObject;
import jet.report.tabular.JetRptTabularCell;
import jet.report.vct.JetRptVCTObject;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.resourceLogic.validation.service.ResourceValidataionService;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.util.TreeIterater;

public class DataContainerConvertor {
    DataContainerLogic dcLogic = ObjectLogicFactory.getDataContainerLogic();
    private static final List AnchorDispValue = new Vector(24);
    private static final List Background;
    private static final int BorderColor = 0;
    private static final int ColumnName = 1;
    private static final int ExportToApplet = 2;
    private static final int ExportToCSV = 3;
    private static final int ExportToDHTML = 10;
    private static final int ExportToHTML = 11;
    private static final int ExportToPDF = Integer.MAX_VALUE;
    private static DataContainerConvertor ExportToPostScript;
    private final boolean ExportToRTF;
    private final boolean ExportToText;

    private int AnchorDispValue(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return Integer.MAX_VALUE;
        }
        String string3 = queryInfo.getDatasourceName();
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string3, string2 = queryInfo.getQueryName(), string);
        if (jetUResourceEntity instanceof JetUSummary) {
            boolean bl = ReportTools.isUseDynamicSummary((JetUSummary)jetUResourceEntity);
            if (bl) {
                String string4 = ((JetUSummary)jetUResourceEntity).getGroupByFld();
                try {
                    if (Integer.parseInt(string4) != 0) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210515, string);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210515, string);
                        }
                        return 0;
                    }
                    return Integer.MAX_VALUE;
                }
                catch (NumberFormatException numberFormatException) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210515, string);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210515, string);
                    }
                    return 0;
                }
            }
            return 1;
        }
        if (jetUResourceEntity instanceof JetUFormula) {
            boolean bl;
            int n = ReportTools.getFormulaType(jetUUniverse, string3, (JetUFormula)jetUResourceEntity);
            boolean bl2 = n == 105;
            boolean bl3 = n == 103;
            boolean bl4 = bl = n == 101;
            if (bl2 || bl3 || bl) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210511, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210511, string);
                }
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            return 2;
        }
        if (jetUResourceEntity != null) {
            return Integer.MAX_VALUE;
        }
        if (JRLog.isError(3)) {
            JRLog.error(3, 3210522, string);
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, 3210522, string);
        }
        return 0;
    }

    private Object[] Background(boolean bl, String string, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        int n = this.AnchorDispValue(jetUUniverse, queryInfo, string);
        if (n == Integer.MAX_VALUE) {
            String string2 = bVResourceContainer.getMappingNameConvertTo(string, 7, 4);
            if (string2 == null) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210512, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210512, string);
                }
                return null;
            }
            return new Object[]{false, string2};
        }
        if (n == 2) {
            if (bl2) {
                return new Object[]{true, string};
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210513, string);
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210513, string);
            }
            return null;
        }
        if (n == 1) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210514, string);
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210514, string);
            }
            return null;
        }
        return null;
    }

    private boolean BorderColor(boolean bl, JetObject jetObject, Collection collection, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        boolean bl2;
        Vector vector = new Vector(jetObject.getProperties().keySet());
        if (collection != null) {
            vector.removeAll(collection);
        }
        if (jetObject instanceof Linkable) {
            bl2 = this.ColumnName(bl, (Linkable)((Object)jetObject), jetUUniverse, queryInfo, bVResourceContainer);
            if (!bl2) {
                return false;
            }
            vector.removeAll(Background);
        }
        if (jetObject instanceof Renderable && !(bl2 = this.ExportToApplet(bl, (Renderable)((Object)jetObject), jetUUniverse, queryInfo, bVResourceContainer))) {
            return false;
        }
        Iterator iterator = vector.iterator();
        boolean bl3 = true;
        while (bl3 && iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            JetProperty jetProperty = jetObject.nameToProperty(string);
            if (jetProperty instanceof JetChartDefinition || jetProperty instanceof JetChartProperty || jetProperty.isChangeByBL() || jetProperty.isChagneByFmtt()) continue;
            if (jetProperty.isChangeByOther()) {
                short s = jetProperty.getChangeByOtherType();
                if (s == 0) {
                    String string2 = (String)jetProperty.getChangeByObject();
                    Object[] objectArray = this.Background(bl, string2 = string2.toUpperCase(), true, jetUUniverse, queryInfo, bVResourceContainer);
                    if (objectArray == null) {
                        bl3 = false;
                        continue;
                    }
                    if (bl || ((Boolean)objectArray[0]).booleanValue()) continue;
                    object = (String)objectArray[1];
                    jetProperty.setChangeByObject(null, (short)0);
                    jetProperty.setChangeByBL(object, (short)0);
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6205123, new Object[]{jetProperty.getName(), string2, object});
                    continue;
                }
                if (s == 1) continue;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "ChangeBy Other Type:" + s);
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205118, new Object[]{s, string});
                }
                return false;
            }
            if (jetProperty instanceof JetColumnName) {
                String string3 = ((JetColumnName)jetProperty).get();
                if (string3 == null || string3.trim().isEmpty()) continue;
                Object[] objectArray = this.Background(bl, string3, false, jetUUniverse, queryInfo, bVResourceContainer);
                if (objectArray == null) {
                    bl3 = false;
                    continue;
                }
                String string4 = (String)objectArray[1];
                object = DataContainerConvertor.ExportToCSV(jetObject, jetProperty);
                if (object != null) {
                    jetProperty.set("");
                    object.set(string4);
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6505134, new Object[]{jetProperty.getName(), object.getName(), string3, string4});
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210560, new Object[]{jetProperty.getName(), jetObject.getInstNameDirectly()});
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6505135, jetProperty.getName());
                continue;
            }
            if (jetProperty instanceof JetColumnVector) {
                Vector vector2 = ((JetVector)jetProperty).get();
                if (vector2 == null || vector2.isEmpty()) continue;
                if (bl) {
                    for (int i = 0; bl3 && i < vector2.size(); ++i) {
                        String string5 = (String)vector2.elementAt(i);
                        if (string5 == null || string5.trim().length() == 0) continue;
                        object = this.Background(bl, string5 = string5.toUpperCase(), false, jetUUniverse, queryInfo, bVResourceContainer);
                        bl3 = object != null;
                    }
                    continue;
                }
                Vector<Object> vector3 = new Vector<Object>();
                for (int i = 0; bl3 && i < vector2.size(); ++i) {
                    object = (String)vector2.elementAt(i);
                    if (object == null || object.trim().isEmpty()) {
                        vector3.add(object);
                        continue;
                    }
                    Object[] objectArray = this.Background(bl, (String)(object = object.toUpperCase()), false, jetUUniverse, queryInfo, bVResourceContainer);
                    if (objectArray != null) {
                        vector3.add((String)objectArray[1]);
                        continue;
                    }
                    bl3 = false;
                }
                if (!bl3) continue;
                JetProperty jetProperty2 = DataContainerConvertor.ExportToCSV(jetObject, jetProperty);
                if (jetProperty2 instanceof JetVector) {
                    ((JetVector)jetProperty).set(new Vector());
                    ((JetVector)jetProperty2).set(vector3);
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6505134, new Object[]{jetProperty.getName(), jetProperty2.getName(), vector2, vector3});
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210560, new Object[]{jetProperty.getName(), jetObject.getInstNameDirectly()});
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6505135, jetProperty.getName());
                continue;
            }
            if (!(jetProperty instanceof JetLink)) continue;
        }
        return bl3;
    }

    private boolean ColumnName(boolean bl, Linkable linkable, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (linkable.getConditionalLinkValue() != null) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "Conditional-link");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "Conditional-Link");
            }
            return false;
        }
        SimpleLinkValue simpleLinkValue = linkable.getSimpleLinkValue();
        if (simpleLinkValue != null) {
            int n = simpleLinkValue.getNormalLinkType();
            if (n == 0 || n == 2) {
                boolean bl2 = true;
                List list = simpleLinkValue.getLinkToRptValue().getParameterLinks();
                boolean bl3 = bl2 = list == null || list.isEmpty();
                if (!bl2) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "Link to report with parameters");
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210510, "ParamLinks in LinkToReport");
                    }
                    return false;
                }
                List list2 = simpleLinkValue.getLinkToRptValue().getTargetConditions();
                boolean bl4 = bl2 = list2 == null || list2.isEmpty();
                if (!bl2) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "Link to report with conditions");
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210510, "Conditions in LinkToReport");
                    }
                    return false;
                }
            } else if (n == 1 || n == 3) {
                List list = simpleLinkValue.getLinkToURLValue().getURLPatterns();
                if (list != null) {
                    boolean bl5 = true;
                    Iterator iterator = list.iterator();
                    while (bl5 && iterator.hasNext()) {
                        URLPattern uRLPattern = (URLPattern)iterator.next();
                        if (uRLPattern.getPatternType() != 2) continue;
                        String string = uRLPattern.getPatternValue();
                        Object[] objectArray = this.Background(bl, string, true, jetUUniverse, queryInfo, bVResourceContainer);
                        if (objectArray == null) {
                            bl5 = false;
                            continue;
                        }
                        if (bl || ((Boolean)objectArray[0]).booleanValue()) continue;
                        String string2 = (String)objectArray[1];
                        uRLPattern.resetInstance("", string2);
                        if (!JRLog.isTrace(6)) continue;
                        JRLog.trace(6, 6505136, new Object[]{string, string2});
                    }
                    if (bl5) {
                        if (!bl) {
                            linkable.getLinkableSetor().setSimpleLinkValue(simpleLinkValue, true, null);
                        }
                        return true;
                    }
                    return false;
                }
            } else if (n == 6) {
                if (this.ExportToRTF) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "LinkToContent");
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210510, "LinkToContent");
                    }
                    return false;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210562, "Link To Content");
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205121, ((JetObject)((Object)linkable)).getInstNameDirectly());
                }
            } else if (n != -1) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Link whose type is" + n);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "LinkTo " + n);
                }
                return false;
            }
        }
        return true;
    }

    private boolean ExportToApplet(boolean bl, Renderable renderable, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        Object object;
        Object object22;
        JetObject jetObject = (JetObject)((Object)renderable.getCurrentUsedRenderer());
        JetObject jetObject2 = (JetObject)((Object)jetObject.getParent());
        int n = 0;
        n = jetObject2 == null || jetObject2.getRefObjects() == null ? 0 : jetObject2.getRefObjects().size();
        Vector vector = jetObject2.getChildren();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (Object object22 : vector) {
            object = ((JetObject)object22).getProperties();
            for (Object[] objectArray : ((Hashtable)object).values()) {
                if (objectArray.isChangeByBL() || objectArray.isChagneByFmtt() || !objectArray.isChangeByOther()) continue;
                short s = objectArray.getChangeByOtherType();
                if (s == 0) {
                    vector2.add(objectArray);
                    continue;
                }
                if (s == 1) continue;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "ChangeBy Other Type:" + s);
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205118, new Object[]{s, objectArray.getName() + " in " + ((JetObject)object22).getInstNameDirectly()});
                }
                return false;
            }
        }
        if (vector2.isEmpty()) {
            return true;
        }
        if (n > 1) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "Shared Renderer");
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205119, n);
            }
            return false;
        }
        boolean bl2 = true;
        object22 = vector2.iterator();
        while (bl2 && object22.hasNext()) {
            Object[] objectArray;
            object = (JetProperty)object22.next();
            Object object3 = (String)((JetProperty)object).getChangeByObject();
            objectArray = this.Background(bl, (String)(object3 = ((String)object3).toUpperCase()), true, jetUUniverse, queryInfo, bVResourceContainer);
            if (objectArray == null) {
                bl2 = false;
                continue;
            }
            if (bl || ((Boolean)objectArray[0]).booleanValue()) continue;
            String string = (String)objectArray[1];
            ((JetProperty)object).setChangeByObject(null, (short)0);
            ((JetProperty)object).setChangeByBL(string, (short)0);
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, 6205123, new Object[]{((JetProperty)object).getName(), object3, string});
        }
        return bl2;
    }

    private static JetProperty ExportToCSV(JetObject jetObject, JetProperty jetProperty) {
        String string = jetProperty.getName();
        JetProperty jetProperty2 = jetObject.nameToProperty("BL" + string);
        if (jetProperty2 == null) {
            jetProperty2 = jetObject.nameToProperty("Bl" + string);
        }
        if (jetProperty2 == null) {
            jetProperty2 = jetObject.nameToProperty("bl" + string);
        }
        return jetProperty2;
    }

    private int ExportToDHTML(boolean bl, IDataContainer iDataContainer, JetObject jetObject, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (jetObject instanceof JetRptSubLink) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "DataContainer-link");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "DataContainer-link");
            }
            return 0;
        }
        if (jetObject instanceof JetFilterExpression) {
            boolean bl2 = this.bEditable(bl, (JetFilterExpression)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            return bl2 ? Integer.MAX_VALUE : 0;
        }
        if (jetObject instanceof JetRptTypedFilterExpression) {
            boolean bl3 = this.bEditable(bl, ((JetRptTypedFilterExpression)jetObject).getJetFilterExpression(), jetUUniverse, queryInfo, bVResourceContainer);
            return bl3 ? Integer.MAX_VALUE : 0;
        }
        if (jetObject instanceof JetRptSortContainer) {
            return Integer.MAX_VALUE;
        }
        if (jetObject instanceof JetRptMsgToActionItem) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "Receive Message");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "receive message");
            }
            return 0;
        }
        if (jetObject instanceof JetRptFlyFormulaMeasureSet) {
            return 10;
        }
        if (jetObject instanceof JetRptPageStart) {
            return 3;
        }
        return 11;
    }

    public static synchronized DataContainerConvertor getConvertInstant() {
        if (ExportToPostScript == null) {
            ExportToPostScript = new DataContainerConvertor(false, false);
        }
        return ExportToPostScript;
    }

    public static DataContainerConvertor getConvertInstantForLCLogic() {
        return new DataContainerConvertor(true, true);
    }

    DataContainerConvertor(boolean bl, boolean bl2) {
        this.ExportToRTF = bl;
        this.ExportToText = bl2;
    }

    public boolean isCanConvertDataContainerToBV(JetUUniverse jetUUniverse, IDataContainer iDataContainer) {
        return this.isCanConvertDataContainerToBV(jetUUniverse, null, iDataContainer);
    }

    public boolean isCanConvertDataContainerToBV(JetUUniverse jetUUniverse, JUnifiedBusinessView jUnifiedBusinessView, IDataContainer iDataContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205100, new Object[]{jetUUniverse, jUnifiedBusinessView == null ? "${auto}" : jUnifiedBusinessView.getQualifyDisplayName(), iDataContainer.getInstNameDirectly(), this.ExportToRTF, this.ExportToText});
        }
        boolean bl = this.ExportToPDF(true, jetUUniverse, jUnifiedBusinessView, iDataContainer, false);
        if (JRLog.isError(2) && !bl) {
            JRLog.error(2, 2210700, iDataContainer.getInstNameDirectly());
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205101, new Object[]{jetUUniverse, jUnifiedBusinessView == null ? "${auto}" : jUnifiedBusinessView.getQualifyDisplayName(), iDataContainer.getInstNameDirectly(), bl});
        }
        return bl;
    }

    public boolean doConvertDataContainerToBV(JetUUniverse jetUUniverse, IDataContainer iDataContainer, boolean bl) {
        return this.doConvertDataContainerToBV(jetUUniverse, null, iDataContainer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doConvertDataContainerToBV(JetUUniverse jetUUniverse, JUnifiedBusinessView jUnifiedBusinessView, IDataContainer iDataContainer, boolean bl) {
        IDataContainer iDataContainer2 = iDataContainer;
        synchronized (iDataContainer2) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 0x5EAEAE, new Object[]{jetUUniverse, jUnifiedBusinessView == null ? "${auto}" : jUnifiedBusinessView.getQualifyDisplayName(), iDataContainer.getInstNameDirectly(), bl, this.ExportToRTF, this.ExportToText});
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210530, new Object[]{jetUUniverse, iDataContainer.getInstNameDirectly()}, null);
            }
            boolean bl2 = this.ExportToPDF(false, jetUUniverse, jUnifiedBusinessView, iDataContainer, bl);
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210559);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205103, new Object[]{jetUUniverse, jUnifiedBusinessView == null ? "${auto}" : jUnifiedBusinessView.getQualifyDisplayName(), iDataContainer.getInstNameDirectly(), bl, bl2});
            }
            if (!bl2 && JRLog.isError(2)) {
                JRLog.error(2, 2210701, new Object[]{iDataContainer.getInstNameDirectly(), jetUUniverse}, null);
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doConvertDataContainerInReport(JetUUniverse jetUUniverse, JetRptReport jetRptReport) {
        int n;
        if (this.ExportToRTF || this.ExportToText) {
            throw new UnsupportedOperationException("Argument error, the convertor MUST get from 'getConvertInstant()' ");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205104, new Object[]{jetUUniverse, jetRptReport.getInstNameDirectly() + "_" + jetRptReport.hashCode()});
        }
        if (jetRptReport.initRptCube.booleanValue()) {
            n = 0;
            Vector vector = new Vector();
            ObjectLogicFactory.getBasicComponentLogic().getAllPosterityComponentByClass((JetObject)jetRptReport, IDataContainer.class, vector);
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                IDataContainer iDataContainer;
                IDataContainer iDataContainer2 = iDataContainer = (IDataContainer)vector.get(i);
                synchronized (iDataContainer2) {
                    boolean bl = this.ExportToPDF(false, jetUUniverse, null, iDataContainer, true);
                    if (bl) {
                        ++n;
                    }
                    continue;
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205105, new Object[]{jetUUniverse, jetRptReport.getInstNameDirectly() + "_" + jetRptReport.hashCode(), n + " of " + n2});
            }
        } else {
            n = -1;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205105, new Object[]{jetUUniverse, jetRptReport.getInstNameDirectly() + "_" + jetRptReport.hashCode(), "Disable"});
            }
        }
        return n;
    }

    private int ExportToHTML(IDataContainer iDataContainer) {
        int n = this.dcLogic.getDataContainerType(iDataContainer);
        if (n == 0) {
            DataSet dataSet = this.dcLogic.getUsedDataSet(iDataContainer);
            if (dataSet == null) {
                return 0;
            }
            if (dataSet.getDataResourceType() == 2) {
                return 2;
            }
            return 1;
        }
        return n;
    }

    private boolean ExportToPDF(boolean bl, JetUUniverse jetUUniverse, JUnifiedBusinessView jUnifiedBusinessView, IDataContainer iDataContainer, boolean bl2) {
        int n = this.ExportToPostScript(bl, iDataContainer);
        if (n == 0) {
            return false;
        }
        if (n == Integer.MAX_VALUE) {
            return true;
        }
        PrepareDataStruct prepareDataStruct = this.ExportToRTF(jetUUniverse, jUnifiedBusinessView, iDataContainer);
        if (prepareDataStruct == null) {
            return false;
        }
        if (bl) {
            return prepareDataStruct.SEDU;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6505130);
        }
        BVResourceContainer bVResourceContainer = new BVResourceContainer(prepareDataStruct.canUsedBVs, false);
        boolean bl3 = this.GroupBy(false, iDataContainer, true, prepareDataStruct.isInSectionObj, false, null, jetUUniverse, prepareDataStruct.dataset.getQueryInfo(), bVResourceContainer);
        if (bl3) {
            bl3 = this.ExportToXLS(iDataContainer, prepareDataStruct.dataset, bl2, jetUUniverse, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6505199);
        }
        return bl3;
    }

    private int ExportToPostScript(boolean bl, IDataContainer iDataContainer) {
        if (!((JetObject)((Object)iDataContainer)).bEditable) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210500, iDataContainer.getInstNameDirectly());
            }
            return 0;
        }
        if (!this.ExportToText && iDataContainer.isInheritDataSet()) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210501, iDataContainer.getInstNameDirectly());
            }
            return 0;
        }
        int n = this.ExportToHTML(iDataContainer);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205110, new Object[]{iDataContainer.getInstNameDirectly(), n});
        }
        if (n != 1) {
            switch (n) {
                case 0: {
                    if (!bl && JRLog.isError(3)) {
                        JRLog.error(3, 3210564, iDataContainer.getInstNameDirectly());
                    }
                    return Integer.MAX_VALUE;
                }
                case 2: {
                    if (!bl && JRLog.isError(3)) {
                        JRLog.error(3, 3210563, iDataContainer.getInstNameDirectly());
                    }
                    return Integer.MAX_VALUE;
                }
                case 3: {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210502, iDataContainer.getInstNameDirectly());
                    }
                    return 0;
                }
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210503, iDataContainer.getInstNameDirectly());
            }
            return 0;
        }
        return 11;
    }

    private PrepareDataStruct ExportToRTF(JetUUniverse jetUUniverse, JUnifiedBusinessView jUnifiedBusinessView, IDataContainer iDataContainer) {
        boolean bl;
        Object object;
        DataSet dataSet = this.dcLogic.getUsedDataSet(iDataContainer);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205111, new Object[]{iDataContainer == null ? "" : iDataContainer.getInstNameDirectly(), dataSet == null ? "" : ((JetObject)((Object)dataSet)).getInstNameDirectly(), dataSet == null ? "" : dataSet.getQueryInfo()});
        }
        List<JUnifiedBusinessView> list = null;
        if (jUnifiedBusinessView == null) {
            if (jetUUniverse != null && dataSet != null) {
                list = jetUUniverse.getUbvByQuery(dataSet.getDataSourceName(), dataSet.getQueryName());
            }
            if (list == null || list.isEmpty()) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210505, jetUUniverse);
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205112, new Object[]{jetUUniverse, dataSet == null ? "" : dataSet.getDataSourceName(), dataSet == null ? "" : dataSet.getQueryName()});
                }
                return null;
            }
        } else {
            String string;
            object = jUnifiedBusinessView.getDatabase().getResourceName();
            String string2 = string = dataSet == null ? "" : dataSet.getDataSourceName();
            if (((String)object).equalsIgnoreCase(string)) {
                list = new Vector<JUnifiedBusinessView>();
                list.add(jUnifiedBusinessView);
            } else {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210505, jUnifiedBusinessView.getQualifyDisplayName());
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205113, new Object[]{jUnifiedBusinessView.getQualifyDisplayName(), dataSet == null ? "" : ((JetObject)((Object)dataSet)).getInstNameDirectly()});
                }
                return null;
            }
        }
        if (!(bl = this.ExportToText(dataSet, jetUUniverse, (BVResourceContainer)(object = new BVResourceContainer(list, true))))) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210507);
            }
            return null;
        }
        boolean bl2 = false;
        JetObject jetObject = (JetObject)((Object)iDataContainer.getParent());
        while (!(jetObject instanceof IRptBody)) {
            if (jetObject instanceof JetRptTableRowObject) {
                bl2 = false;
                break;
            }
            if (jetObject instanceof JetRptSection) {
                bl2 = true;
                break;
            }
            if (jetObject == null) break;
            jetObject = (JetObject)((Object)jetObject.getParent());
        }
        if (!(bl = this.GroupBy(true, iDataContainer, true, bl2, false, null, jetUUniverse, dataSet.getQueryInfo(), (BVResourceContainer)object)) || list.isEmpty()) {
            return null;
        }
        PrepareDataStruct prepareDataStruct = new PrepareDataStruct(true);
        prepareDataStruct.canUsedBVs = list;
        prepareDataStruct.isInSectionObj = bl2;
        prepareDataStruct.dataset = dataSet;
        return prepareDataStruct;
    }

    public List getCanUsedBVInfosOnConverting(JetUUniverse jetUUniverse, IDataContainer iDataContainer) {
        int n = this.ExportToPostScript(true, iDataContainer);
        if (n == 11) {
            PrepareDataStruct prepareDataStruct = this.ExportToRTF(jetUUniverse, null, iDataContainer);
            if (prepareDataStruct == null) {
                return new Vector(0);
            }
            return new Vector(prepareDataStruct.canUsedBVs);
        }
        return new Vector(0);
    }

    private boolean ExportToText(DataSet dataSet, JetUUniverse jetUUniverse, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{((JetObject)((Object)dataSet)).getInstancePrefix(), true, ((JetObject)((Object)dataSet)).getInstNameDirectly()});
        }
        QueryInfo queryInfo = dataSet.getQueryInfo();
        Vector vector = ((JetRptDataSet)dataSet).getChildren();
        int n = vector == null ? 0 : vector.size();
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptTypedFilterExpression) {
                JetFilterExpression jetFilterExpression = ((JetRptTypedFilterExpression)jetObject).getJetFilterExpression();
                bl = this.bEditable(true, jetFilterExpression, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (!(jetObject instanceof JetFilterExpression)) continue;
            bl = this.bEditable(true, (JetFilterExpression)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{((JetObject)((Object)dataSet)).getInstNameDirectly(), true, bl});
        }
        return bl;
    }

    private boolean ExportToXLS(IDataContainer iDataContainer, DataSet dataSet, boolean bl, JetUUniverse jetUUniverse, BVResourceContainer bVResourceContainer) {
        JetRptDataSet jetRptDataSet = (JetRptDataSet)dataSet;
        Vector vector = jetRptDataSet.getRefObjects();
        if (vector.size() > 1 || vector.get(0) != iDataContainer) {
            jetRptDataSet = (JetRptDataSet)jetRptDataSet.deepDupWithName();
        }
        QueryInfo queryInfo = jetRptDataSet.getQueryInfo();
        Vector vector2 = jetRptDataSet.getChildren();
        int n = vector2 == null ? 0 : vector2.size();
        Vector<JetObject> vector3 = new Vector<JetObject>(n);
        boolean bl2 = true;
        for (int i = 0; bl2 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector2.get(i);
            if (jetObject instanceof JetRptTypedFilterExpression) {
                JetFilterExpression jetFilterExpression = ((JetRptTypedFilterExpression)jetObject).getJetFilterExpression();
                bl2 = this.bEditable(false, jetFilterExpression, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetFilterExpression) {
                bl2 = this.bEditable(true, (JetFilterExpression)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            vector3.add(jetObject);
        }
        if (bl2) {
            jetRptDataSet.setQueryName("");
            jetRptDataSet.setBlName(bVResourceContainer.getBVName());
            jetRptDataSet.setDataResourceType(2);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6505142, new Object[]{queryInfo.getQueryName(), bVResourceContainer.getBVName()});
            }
            for (JetObject jetObject : vector3) {
                ObjectLogicFactory.getBasicComponentLogic().remove(jetObject);
            }
        }
        if (jetRptDataSet != dataSet) {
            JetContainable jetContainable = ((JetObject)((Object)dataSet)).getParent();
            if (jetContainable != null) {
                boolean bl3 = false;
                vector2 = jetContainable.getChildren();
                for (Object e : vector2) {
                    if (!DataContainerConvertor.ExportToXML((DataSet)e, jetRptDataSet)) continue;
                    iDataContainer.setBindedDataSet(false, (DataSet)e);
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    iDataContainer.setBindedDataSet(false, jetRptDataSet);
                    if (bl) {
                        ObjectLogicFactory.getBasicComponentLogic().add(jetContainable, jetRptDataSet);
                    }
                }
            } else {
                iDataContainer.setBindedDataSet(false, jetRptDataSet);
            }
        }
        return bl2;
    }

    private static boolean ExportToXML(DataSet dataSet, DataSet dataSet2) {
        int n;
        int n2 = dataSet.getDatasetType();
        if (n2 != (n = dataSet2.getDatasetType())) {
            return false;
        }
        QueryInfo queryInfo = dataSet.getQueryInfo();
        QueryInfo queryInfo2 = dataSet2.getQueryInfo();
        if (queryInfo != null ? !queryInfo.isEquals(queryInfo2) : queryInfo2 != null && !queryInfo2.isEquals(queryInfo)) {
            return false;
        }
        IExpression iExpression = null;
        IExpression iExpression2 = null;
        try {
            iExpression = dataSet.getPreIExpression();
            iExpression2 = dataSet2.getPreIExpression();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iExpression != null ? !((Object)iExpression).equals(iExpression2) : iExpression2 != null && !((Object)iExpression2).equals(iExpression)) {
            return false;
        }
        n2 = dataSet.getMappingListType();
        if (n2 != (n = dataSet2.getMappingListType())) {
            return false;
        }
        try {
            iExpression = dataSet.getIExpression();
            iExpression2 = dataSet2.getIExpression();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !(iExpression != null ? !((Object)iExpression).equals(iExpression2) : iExpression2 != null && !((Object)iExpression2).equals(iExpression));
    }

    private boolean GroupBy(boolean bl, IDataContainer iDataContainer, boolean bl2, boolean bl3, boolean bl4, String string, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{((JetObject)((Object)iDataContainer)).getInstancePrefix(), bl, iDataContainer.getInstNameDirectly()});
        }
        if (!bl2 && !iDataContainer.isInheritDataSet()) {
            if (this.ExportToRTF) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Not Inherit DC");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "Not Inherit DC");
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205115, new Object[]{iDataContainer.getInstNameDirectly(), bl, false});
                }
                return false;
            }
            if (JRLog.isTrace(3)) {
                JRLog.error(3, 3210561, iDataContainer.getInstNameDirectly());
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205116, new Object[]{iDataContainer.getInstNameDirectly(), bl});
            }
            return true;
        }
        boolean bl5 = true;
        if (iDataContainer instanceof JetRptCTCrossTab) {
            bl5 = this.Parameter(bl, (JetRptCTCrossTab)iDataContainer, bl2, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (iDataContainer instanceof JetRptChartPlatform) {
            bl5 = this.RecordLocation(bl, (JetRptChartPlatform)iDataContainer, bl2, bl3, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (iDataContainer instanceof JetRptNewTable) {
            bl5 = this.SuppressEmpty(bl, (JetRptNewTable)iDataContainer, bl2, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (iDataContainer instanceof JetRptSectionObject) {
            bl5 = this.Suppressed(bl, (JetRptSectionObject)iDataContainer, bl2, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (iDataContainer instanceof JetRptSubReport) {
            bl5 = this.aggFunc(bl, (JetRptSubReport)iDataContainer, bl2, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (iDataContainer instanceof JetRptGMap) {
            bl5 = this.access$000(bl, (JetRptGMap)iDataContainer, bl2, jetUUniverse, queryInfo, bVResourceContainer);
        } else {
            if (iDataContainer instanceof JetRptVCTObject || iDataContainer instanceof JetRptGeoMap) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210563, iDataContainer.getInstNameDirectly());
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205117, new Object[]{iDataContainer.getInstNameDirectly(), bl});
                }
                return true;
            }
            if (iDataContainer instanceof JetRptParagraph) {
                bl5 = this.append(bl, (JetRptParagraph)iDataContainer, bl4, string, jetUUniverse, queryInfo, bVResourceContainer);
            } else if (iDataContainer instanceof JetRptMap || iDataContainer instanceof JetRptConfig) {
                bl5 = false;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "ShapeMap");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(3, 3210510, "ShapeMap:" + iDataContainer.getInstNameDirectly());
                }
            } else {
                if (bl2 && (iDataContainer instanceof JetRptSection || iDataContainer instanceof JetRptTableCell || iDataContainer instanceof JetRptTabularCell || iDataContainer instanceof JetRptParaReplaceElement || iDataContainer instanceof JetRptArea || iDataContainer instanceof JetRptChartLabel || iDataContainer instanceof JetRptChartLegend || iDataContainer instanceof JetRptChartPaper)) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210506, iDataContainer.getInstNameDirectly());
                    }
                    bl5 = false;
                }
                if (bl5) {
                    bl5 = bl2 ? this.BorderColor(bl, (JetObject)((Object)iDataContainer), AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, (JetObject)((Object)iDataContainer), null, jetUUniverse, queryInfo, bVResourceContainer);
                    Vector vector = iDataContainer.getChildren();
                    JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
                    int n = vector.size();
                    for (int i = 0; bl5 && i < n; ++i) {
                        JetObject jetObject = (JetObject)vector.get(i);
                        if (jetObject instanceof IDataContainer) {
                            bl5 = this.GroupBy(bl, (IDataContainer)((Object)jetObject), false, bl3, bl4, string, jetUUniverse, queryInfo, bVResourceContainer);
                            continue;
                        }
                        int n2 = this.ExportToDHTML(bl, iDataContainer, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                        if (n2 == 10) {
                            jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                            continue;
                        }
                        if (n2 == 3) {
                            JetRptPageStart jetRptPageStart = (JetRptPageStart)jetObject;
                            bl5 = this.Invisible(bl, jetRptPageStart.getPagePanel(), bl3, bl4, string, jetUUniverse, queryInfo, bVResourceContainer);
                            continue;
                        }
                        if (n2 == 11) {
                            if (jetObject instanceof JetRptField) {
                                bl5 = this.blColumnName(bl, (JetRptField)jetObject, bl4, string, jetUUniverse, queryInfo, bVResourceContainer);
                                continue;
                            }
                            if (jetObject instanceof JetContainable) {
                                bl5 = this.Invisible(bl, (JetContainable)((Object)jetObject), bl3, bl4, string, jetUUniverse, queryInfo, bVResourceContainer);
                                continue;
                            }
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, 6205114, new Object[]{jetObject.getInstancePrefix(), bl, jetObject.getInstNameDirectly()});
                            }
                            bl5 = this.BorderColor(bl, jetObject, null, jetUUniverse, queryInfo, bVResourceContainer);
                            if (!JRLog.isTrace(6)) continue;
                            JRLog.trace(6, 6205115, new Object[]{jetObject.getInstNameDirectly(), bl, bl5});
                            continue;
                        }
                        bl5 = n2 == Integer.MAX_VALUE;
                    }
                    if (bl5 && jetRptFlyFormulaMeasureSet != null) {
                        bl5 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, iDataContainer, queryInfo, bVResourceContainer);
                    }
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{iDataContainer.getInstNameDirectly(), bl, bl5});
        }
        return bl5;
    }

    private boolean Invisible(boolean bl, JetContainable jetContainable, boolean bl2, boolean bl3, String string, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        JetObject jetObject = (JetObject)((Object)jetContainable);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{jetObject.getInstancePrefix(), bl, jetObject.getInstNameDirectly()});
        }
        boolean bl4 = this.BorderColor(bl, jetObject, null, jetUUniverse, queryInfo, bVResourceContainer);
        Vector vector = jetObject.getChildren();
        int n = vector != null ? vector.size() : 0;
        for (int i = 0; bl4 && i < n; ++i) {
            JetObject jetObject2 = (JetObject)vector.get(i);
            if (jetObject2 instanceof IDataContainer) {
                bl4 = this.GroupBy(bl, (IDataContainer)((Object)jetObject2), false, bl2, bl3, string, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject2 instanceof JetRptFilterControl) {
                if (this.ExportToRTF) {
                    bl4 = false;
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "OSF");
                        continue;
                    }
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 3210510, "OSF");
                    continue;
                }
                bl4 = true;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210562, jetObject2.getInstNameDirectly());
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6205120, jetObject2.getInstNameDirectly());
                continue;
            }
            if (jetObject2 instanceof JetContainable) {
                bl4 = this.Invisible(bl, (JetContainable)((Object)jetObject2), bl2, bl3, string, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject2 instanceof JetRptField) {
                bl4 = this.blColumnName(bl, (JetRptField)jetObject2, bl3, string, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205114, new Object[]{jetObject2.getInstancePrefix(), bl, jetObject2.getInstNameDirectly()});
            }
            bl4 = this.BorderColor(bl, jetObject2, null, jetUUniverse, queryInfo, bVResourceContainer);
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, 6205115, new Object[]{jetObject2.getInstNameDirectly(), bl, bl4});
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetObject.getInstNameDirectly(), bl, bl4});
        }
        return bl4;
    }

    private boolean Parameter(boolean bl, JetRptCTCrossTab jetRptCTCrossTab, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"CTCrosstab", bl, jetRptCTCrossTab.getInstNameDirectly()});
        }
        boolean bl3 = true;
        bl3 = bl2 ? this.BorderColor(bl, jetRptCTCrossTab, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, jetRptCTCrossTab, null, jetUUniverse, queryInfo, bVResourceContainer);
        Vector vector = jetRptCTCrossTab.getChildren();
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
        int n = vector.size();
        for (int i = 0; bl3 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptField) {
                bl3 = this.blColumnName(bl, (JetRptField)jetObject, false, null, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            int n2 = this.ExportToDHTML(bl, jetRptCTCrossTab, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            if (n2 == 10) {
                jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                continue;
            }
            if (n2 == 11) {
                if (jetObject instanceof JetRptCTAggInfo) {
                    bl3 = true;
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in CTCrosstab");
                }
                bl3 = false;
                continue;
            }
            bl3 = n2 == Integer.MAX_VALUE;
        }
        if (bl3 && jetRptFlyFormulaMeasureSet != null) {
            bl3 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, jetRptCTCrossTab, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptCTCrossTab.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean RecordLocation(boolean bl, JetRptChartPlatform jetRptChartPlatform, boolean bl2, boolean bl3, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        ChartDefinition chartDefinition;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"ChartObject", bl, jetRptChartPlatform.getInstNameDirectly()});
        }
        boolean bl4 = true;
        if (!bl2 && jetRptChartPlatform.isInheritDataSet() && bl3) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210524, jetRptChartPlatform.getInstNameDirectly());
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210524, jetRptChartPlatform.getInstNameDirectly());
            }
            bl4 = false;
        }
        if ((chartDefinition = jetRptChartPlatform.getChartDefinition()).isORGChart()) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "ORG-Chart");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "ORG-Chart");
            }
            bl4 = false;
        } else if (chartDefinition.isHeatMapChart()) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "HeatMap-Chart");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "HeatMap-Chart");
            }
            bl4 = false;
        } else if (chartDefinition.isMotionChart()) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, "Motion-Chart");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, "Motion-Chart");
            }
            bl4 = false;
        }
        bl4 = bl4 && this.SEDU(bl, chartDefinition, true, jetUUniverse, queryInfo, bVResourceContainer);
        bl4 = bl4 && this.SEDU(bl, chartDefinition, false, jetUUniverse, queryInfo, bVResourceContainer);
        bl4 = bl4 && this.SelectStartPosition(bl, chartDefinition, true, jetUUniverse, queryInfo, bVResourceContainer);
        boolean bl5 = bl4 = bl4 && this.SelectStartPosition(bl, chartDefinition, false, jetUUniverse, queryInfo, bVResourceContainer);
        if (!bl && bl4) {
            jetRptChartPlatform.setDefinition(chartDefinition);
        }
        bl4 = bl2 ? bl4 && this.BorderColor(bl, jetRptChartPlatform, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : bl4 && this.BorderColor(bl, jetRptChartPlatform, null, jetUUniverse, queryInfo, bVResourceContainer);
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
        Vector vector = jetRptChartPlatform.getChildren();
        int n = vector.size();
        for (int i = 0; bl4 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptChartPaper || jetObject instanceof JetRptChartLegend || jetObject instanceof JetRptChartLabel) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205114, new Object[]{jetObject.getInstancePrefix(), bl, jetObject.getInstNameDirectly()});
                }
                bl4 = this.BorderColor(bl, jetObject, null, jetUUniverse, queryInfo, bVResourceContainer);
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6205115, new Object[]{jetObject.getInstNameDirectly(), bl, bl4});
                continue;
            }
            int n2 = this.ExportToDHTML(bl, jetRptChartPlatform, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            if (n2 == 10) {
                jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                continue;
            }
            if (n2 == 11) {
                if (jetObject instanceof SpecialFunction) {
                    bl4 = true;
                    continue;
                }
                if (jetObject instanceof JetRptChartShowValueFuncContainer) {
                    Vector vector2 = ((JetRptChartShowValueFuncContainer)jetObject).getChildren();
                    if (vector2 == null || vector2.size() <= 0) continue;
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "ShowValue Function");
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210510, "ShowValue Function");
                    }
                    bl4 = false;
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in ChartObject");
                }
                bl4 = false;
                continue;
            }
            bl4 = n2 == Integer.MAX_VALUE;
        }
        if (bl4 && jetRptFlyFormulaMeasureSet != null) {
            bl4 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, jetRptChartPlatform, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptChartPlatform.getInstNameDirectly(), bl, bl4});
        }
        return bl4;
    }

    private boolean SEDU(boolean bl, ChartDefinition chartDefinition, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        String string;
        String string2 = string = bl2 ? chartDefinition.getCategory() : chartDefinition.getSeries();
        if (string != null) {
            int n = this.AnchorDispValue(jetUUniverse, queryInfo, string = string.toUpperCase());
            if (n == Integer.MAX_VALUE) {
                String string3 = bVResourceContainer.getMappingNameConvertTo(string, 4);
                if (string3 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210519, string);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210519, string);
                    }
                    return false;
                }
                if (!bl) {
                    if (bl2) {
                        chartDefinition.setCategory(string3);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6505131, new Object[]{"Category", string, string3});
                        }
                    } else {
                        chartDefinition.setSeries(string3);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6505131, new Object[]{"Series", string, string3});
                        }
                    }
                    chartDefinition.setBVData(true);
                }
                return true;
            }
            if (n == 2) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210516, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210516, string);
                }
                return false;
            }
            if (n == 1) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210514, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210514, string);
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean SelectStartPosition(boolean bl, ChartDefinition chartDefinition, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        Map map;
        Map map2 = map = bl2 ? chartDefinition.getY1Datasets() : chartDefinition.getY2Datasets();
        if (map == null) {
            return true;
        }
        boolean bl3 = chartDefinition.isDetail();
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                JetUResourceEntity jetUResourceEntity;
                String[] stringArray = (String[])list.get(i);
                if (stringArray[0].equals(String.valueOf(1))) continue;
                String string = stringArray[2];
                int n = this.AnchorDispValue(jetUUniverse, queryInfo, string = string.toUpperCase());
                if (n == 0) {
                    return false;
                }
                if (n == 2) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210516, string);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210516, string);
                    }
                    return false;
                }
                if (n == 1) {
                    if (bl3) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210514, string);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210514, string);
                        }
                        return false;
                    }
                    jetUResourceEntity = jetUUniverse.getResourceByName(queryInfo.getDatasourceName(), queryInfo.getQueryName(), string);
                    String string2 = bVResourceContainer.getAggregation(((JetUSummary)jetUResourceEntity).getFieldName(), ((JetUSummary)jetUResourceEntity).getFunction());
                    if (string2 == null) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210517, new String[]{((JetUSummary)jetUResourceEntity).getFieldName(), ((JetUSummary)jetUResourceEntity).getFunction()}, null);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210517, new String[]{((JetUSummary)jetUResourceEntity).getFieldName(), ((JetUSummary)jetUResourceEntity).getFunction()});
                        }
                        return false;
                    }
                    if (bl) continue;
                    stringArray[2] = string2;
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6505131, new Object[]{"ShowValue", string, string2});
                    continue;
                }
                jetUResourceEntity = jetUUniverse.getResourceByName(queryInfo.getDatasourceName(), queryInfo.getQueryName(), string);
                boolean bl4 = Types.isNumeric(jetUResourceEntity.getColDesc().getSqlType());
                if (bl4) {
                    String string3 = bVResourceContainer.getMappingNameConvertTo(string, 7);
                    if (string3 == null) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210518, string);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210518, string);
                        }
                        return false;
                    }
                    if (bl) continue;
                    stringArray[2] = string3;
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6505131, new Object[]{"ShowValue", string, string3});
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Non-Numeric used in Chart_Y");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "Non-Numeric used in Chart_Y");
                }
                return false;
            }
            if (bl) continue;
            if (bl2) {
                chartDefinition.resetY1Dataset((String)entry.getKey(), list);
                continue;
            }
            chartDefinition.resetY2Dataset((String)entry.getKey(), list);
        }
        return true;
    }

    private boolean SuppressEmpty(boolean bl, JetRptNewTable jetRptNewTable, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        boolean bl3 = true;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"TableComp", bl, jetRptNewTable.getInstNameDirectly()});
        }
        bl3 = bl2 ? this.BorderColor(bl, jetRptNewTable, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, jetRptNewTable, null, jetUUniverse, queryInfo, bVResourceContainer);
        Vector vector = jetRptNewTable.getChildren();
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
        int n = vector.size();
        for (int i = 0; bl3 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptTableRowObject) {
                bl3 = this.Invisible(bl, (JetRptTableRowObject)jetObject, false, false, null, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptTableGroup) {
                bl3 = this.SuppressedIfNoRecords(bl, (JetRptTableGroup)jetObject, false, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptTableGrid) {
                TreeIterater treeIterater = new TreeIterater(jetObject, false);
                JetObject jetObject2 = null;
                while (bl3 && (jetObject2 = (JetObject)treeIterater.next()) != null) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 6205114, new Object[]{jetObject2.getInstancePrefix(), bl, jetObject2.getInstNameDirectly()});
                    }
                    if (jetObject2 instanceof JetRptTableColumn) {
                        String string = ((JetRptTableColumn)jetObject2).getBindDataName();
                        if (!string.isEmpty()) {
                            Object[] objectArray = this.Background(bl, string, true, jetUUniverse, queryInfo, bVResourceContainer);
                            if (objectArray == null) {
                                bl3 = false;
                            } else {
                                if (!bl && !((Boolean)objectArray[0]).booleanValue()) {
                                    ((JetRptTableColumn)jetObject2).setBindDataName((String)objectArray[1]);
                                    if (JRLog.isTrace(6)) {
                                        JRLog.trace(6, 6505137, new Object[]{jetObject2.getInstNameDirectly(), string, (String)objectArray[1]});
                                    }
                                }
                                bl3 = this.BorderColor(bl, jetObject2, null, jetUUniverse, queryInfo, bVResourceContainer);
                            }
                        }
                    } else {
                        bl3 = this.BorderColor(bl, jetObject2, null, jetUUniverse, queryInfo, bVResourceContainer);
                    }
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6205115, new Object[]{jetObject2.getInstNameDirectly(), bl, bl3});
                }
                continue;
            }
            int n2 = this.ExportToDHTML(bl, jetRptNewTable, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            if (n2 == 10) {
                jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                continue;
            }
            if (n2 == 11) {
                if (!JRLog.isError(3)) continue;
                JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in TableComp");
                continue;
            }
            bl3 = n2 == Integer.MAX_VALUE;
        }
        if (bl3 && jetRptFlyFormulaMeasureSet != null) {
            bl3 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, jetRptNewTable, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptNewTable.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean Suppressed(boolean bl, JetRptSectionObject jetRptSectionObject, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"BandedObject", bl, jetRptSectionObject.getInstNameDirectly()});
        }
        boolean bl3 = true;
        bl3 = bl2 ? this.BorderColor(bl, jetRptSectionObject, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, jetRptSectionObject, null, jetUUniverse, queryInfo, bVResourceContainer);
        Vector vector = jetRptSectionObject.getChildren();
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
        int n = vector.size();
        for (int i = 0; bl3 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptSectionHeader || jetObject instanceof JetRptSectionFooter) {
                bl3 = this.Invisible(bl, (JetRptSection)jetObject, true, false, null, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptSectionPagePanel) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205114, new Object[]{jetObject.getInstancePrefix(), bl, jetObject.getInstNameDirectly()});
                }
                Vector vector2 = ((JetRptSectionPagePanel)jetObject).getChildren();
                int n2 = vector2.size();
                for (int j = 0; bl3 && j < n2; ++j) {
                    JetObject jetObject2 = (JetObject)vector2.get(j);
                    if (jetObject2 instanceof JetRptGroupPanel) {
                        bl3 = this.SuppressedIfNoRecords(bl, (JetRptGroupPanel)jetObject2, true, jetUUniverse, queryInfo, bVResourceContainer);
                        continue;
                    }
                    if (jetObject2 instanceof JetRptSection) {
                        bl3 = this.Invisible(bl, (JetRptSection)jetObject2, true, false, null, jetUUniverse, queryInfo, bVResourceContainer);
                        continue;
                    }
                    if (jetObject2 instanceof JetRptPageStart || jetObject2 instanceof JetRptPageEnd || jetObject2 instanceof JetRptPageBreaker) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205122, "PageControl");
                        }
                        bl3 = true;
                        continue;
                    }
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in BandedPagePanel");
                    }
                    bl3 = false;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6205115, new Object[]{jetObject.getInstNameDirectly(), bl, bl3});
                continue;
            }
            int n3 = this.ExportToDHTML(bl, jetRptSectionObject, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            if (n3 == 10) {
                jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                continue;
            }
            if (n3 == 11) {
                if (jetObject instanceof JetRpt2DGeometryObject) {
                    bl3 = true;
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6205122, "GeometryObject");
                    continue;
                }
                if (jetObject instanceof JetRptPageStart || jetObject instanceof JetRptPageEnd || jetObject instanceof JetRptPageBreaker) {
                    bl3 = true;
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 6205122, "PageControl");
                    continue;
                }
                if (jetObject instanceof JetRptSectionColumnInfo) {
                    TreeIterater treeIterater = new TreeIterater(jetObject, false);
                    JetObject jetObject3 = null;
                    while (bl3 && (jetObject3 = (JetObject)treeIterater.next()) != null) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205114, new Object[]{jetObject3.getInstancePrefix(), bl, jetObject3.getInstNameDirectly()});
                        }
                        bl3 = this.BorderColor(bl, jetObject3, null, jetUUniverse, queryInfo, bVResourceContainer);
                        if (!JRLog.isTrace(6)) continue;
                        JRLog.trace(6, 6205115, new Object[]{jetObject3.getInstNameDirectly(), bl, bl3});
                    }
                    continue;
                }
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in BandedObject");
                }
                bl3 = false;
                continue;
            }
            bl3 = n3 == Integer.MAX_VALUE;
        }
        if (bl3 && jetRptFlyFormulaMeasureSet != null) {
            bl3 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, jetRptSectionObject, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptSectionObject.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean SuppressedIfNoRecords(boolean bl, JetRptGroupPanel jetRptGroupPanel, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{jetRptGroupPanel.getInstancePrefix(), bl, jetRptGroupPanel.getInstNameDirectly()});
        }
        Vector<String> vector = new Vector<String>(1);
        vector.add(PropertyNames.getDefinitionName(PropertyNames.GroupBy));
        boolean bl3 = this.BorderColor(bl, jetRptGroupPanel, vector, jetUUniverse, queryInfo, bVResourceContainer);
        String string = jetRptGroupPanel.getGroupByName();
        if (bl3) {
            int n = this.AnchorDispValue(jetUUniverse, queryInfo, string);
            if (n == 2) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210520, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210520, string);
                }
                bl3 = false;
            } else {
                boolean bl4 = bl3 = n == Integer.MAX_VALUE;
            }
            if (bl3) {
                String string2 = bVResourceContainer.getMappingNameConvertTo(string, 4);
                if (string2 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210519, string);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210519, string);
                    }
                    bl3 = false;
                } else {
                    if (!bl) {
                        jetRptGroupPanel.groupBy.set("");
                        jetRptGroupPanel.blColumnName.set(string2);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205132, new Object[]{"GroupBy", string, string2});
                        }
                    }
                    bl3 = true;
                }
            }
        }
        Vector vector2 = jetRptGroupPanel.getChildren();
        int n = vector2.size();
        for (int i = 0; bl3 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector2.get(i);
            if (jetObject instanceof SpecialFunction) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210523, jetRptGroupPanel.getInstNameDirectly());
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210523, jetRptGroupPanel.getInstNameDirectly());
                }
                bl3 = false;
                continue;
            }
            if (jetObject instanceof JetRptGroupFilter) {
                bl3 = this.TOCAnchor(bl, (JetRptGroupFilter)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptSection) {
                bl3 = this.Invisible(bl, (JetRptSection)jetObject, bl2, true, string, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptGroupPanel) {
                bl3 = this.SuppressedIfNoRecords(bl, (JetRptGroupPanel)jetObject, bl2, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, jetObject.getClass().getName() + " in GroupPanel");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210520, jetObject.getClass().getName() + " in GroupPanel");
            }
            bl3 = false;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptGroupPanel.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean TOCAnchor(boolean bl, JetRptGroupFilter jetRptGroupFilter, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        JetUResourceEntity jetUResourceEntity;
        String string;
        String string2 = jetRptGroupFilter.dbField.get();
        Object[] objectArray = this.Background(bl, string2, true, jetUUniverse, queryInfo, bVResourceContainer);
        if (objectArray == null) {
            return false;
        }
        if (!bl && !((Boolean)objectArray[0]).booleanValue()) {
            jetRptGroupFilter.dbField.set("");
            jetRptGroupFilter.blDBField.set((String)objectArray[1]);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6505138, new Object[]{"DBFieldName", string2, (String)objectArray[1]});
            }
        }
        if ((objectArray = this.Background(bl, string2 = jetRptGroupFilter.exp1.get(), true, jetUUniverse, queryInfo, bVResourceContainer)) == null) {
            return false;
        }
        if (!bl && !((Boolean)objectArray[0]).booleanValue()) {
            jetRptGroupFilter.exp1.set("");
            jetRptGroupFilter.blExp1.set((String)objectArray[1]);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6505138, new Object[]{"Expression1", string2, (String)objectArray[1]});
            }
        }
        if (((string2 = (string = jetRptGroupFilter.exp2.get())).startsWith("@") || string2.startsWith(":")) && (string2 = string2.substring(1)).startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if ((jetUResourceEntity = jetUUniverse.getResourceByName(queryInfo.getDatasourceName(), queryInfo.getQueryName(), string2)) != null) {
            objectArray = this.Background(bl, string2, true, jetUUniverse, queryInfo, bVResourceContainer);
            if (objectArray == null) {
                return false;
            }
            if (!bl && !((Boolean)objectArray[0]).booleanValue()) {
                String string3 = (String)objectArray[1];
                if (string.startsWith("@\"")) {
                    string3 = "@\"" + string3 + "\"";
                } else if (string.startsWith(":\"")) {
                    string3 = ":\"" + string3 + "\"";
                } else if (string.startsWith("@")) {
                    string3 = "@" + string3;
                } else if (string.startsWith(":")) {
                    string3 = ":" + string3;
                }
                jetRptGroupFilter.exp2.set(string3);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6505138, new Object[]{"Expression2", string, string3});
                }
            }
        }
        return true;
    }

    private boolean access$000(boolean bl, JetRptGMap jetRptGMap, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"GoogleMap", bl, jetRptGMap.getInstNameDirectly()});
        }
        boolean bl3 = false;
        boolean bl4 = true;
        bl4 = bl2 ? this.BorderColor(bl, jetRptGMap, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, jetRptGMap, null, jetUUniverse, queryInfo, bVResourceContainer);
        JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet = null;
        Vector vector = jetRptGMap.getChildren();
        int n = vector.size();
        for (int i = 0; bl4 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptGMarker) {
                bl4 = this.add(bl, (JetRptGMarker)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            int n2 = this.ExportToDHTML(bl, jetRptGMap, jetObject, jetUUniverse, queryInfo, bVResourceContainer);
            if (n2 == 10) {
                jetRptFlyFormulaMeasureSet = (JetRptFlyFormulaMeasureSet)jetObject;
                continue;
            }
            if (n2 == 11) {
                if (!JRLog.isError(3)) continue;
                JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in GoogleMap");
                continue;
            }
            bl4 = n2 == Integer.MAX_VALUE;
        }
        if (jetRptFlyFormulaMeasureSet != null && bl4) {
            bl4 = this.blExp1(bl, jetRptFlyFormulaMeasureSet, jetRptGMap, queryInfo, bVResourceContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptGMap.getInstNameDirectly(), bl, bl4});
        }
        return bl4;
    }

    private boolean add(boolean bl, JetRptGMarker jetRptGMarker, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        Vector<String> vector = new Vector<String>(1);
        vector.add(PropertyNames.getDefinitionName(PropertyNames.GroupBy));
        boolean bl2 = this.BorderColor(bl, jetRptGMarker, vector, jetUUniverse, queryInfo, bVResourceContainer);
        String string = jetRptGMarker.getGroupByName();
        if (bl2) {
            int n = this.AnchorDispValue(jetUUniverse, queryInfo, string);
            if (n == 2) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210520, string);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210520, string);
                }
                bl2 = false;
            } else {
                boolean bl3 = bl2 = n == Integer.MAX_VALUE;
            }
            if (bl2) {
                String string2 = bVResourceContainer.getMappingNameConvertTo(string, 4);
                if (string2 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210519, string);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210519, string);
                    }
                    bl2 = false;
                } else {
                    if (!bl) {
                        jetRptGMarker.groupBy.set("");
                        jetRptGMarker.blColumnName.set(string2);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205132, new Object[]{"GroupBy", string, string2});
                        }
                    }
                    bl2 = true;
                }
            }
        }
        Vector vector2 = jetRptGMarker.getChildren();
        int n = vector2.size();
        for (int i = 0; bl2 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector2.get(i);
            if (jetObject instanceof SpecialFunction) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210523, jetRptGMarker.getInstNameDirectly());
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210523, jetRptGMarker.getInstNameDirectly());
                }
                bl2 = false;
                continue;
            }
            if (jetObject instanceof JetRptGroupFilter) {
                bl2 = this.TOCAnchor(bl, (JetRptGroupFilter)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptGMarker) {
                bl2 = this.add(bl, (JetRptGMarker)jetObject, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, jetObject.getClass().getName() + " in GMarker");
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, jetObject.getClass().getName() + " in GMarker");
            }
            bl2 = false;
        }
        return bl2;
    }

    private boolean aggFunc(boolean bl, JetRptSubReport jetRptSubReport, boolean bl2, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"SubReport", bl, jetRptSubReport.getInstNameDirectly()});
        }
        boolean bl3 = false;
        boolean bl4 = true;
        bl4 = bl2 ? this.BorderColor(bl, jetRptSubReport, AnchorDispValue, jetUUniverse, queryInfo, bVResourceContainer) : this.BorderColor(bl, jetRptSubReport, null, jetUUniverse, queryInfo, bVResourceContainer);
        Vector vector = jetRptSubReport.getChildren();
        int n = vector.size();
        for (int i = 0; i < n && bl4; ++i) {
            List list;
            JetObject jetObject = (JetObject)vector.get(i);
            if (jetObject instanceof JetRptSubLinkContainer) {
                list = ((JetRptSubLinkContainer)jetObject).getSubLinks();
                bl4 = list.isEmpty();
                if (bl4) continue;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "SubReport with conditions");
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 3210510, "SubReport with conditions");
                continue;
            }
            if (jetObject instanceof JetRptSubReturnValueContainer) {
                list = ((JetRptSubReturnValueContainer)jetObject).getReturnVlaues();
                bl4 = list.isEmpty();
                if (bl4) continue;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "SubReport with return-values");
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 3210510, "SubReport with conditions");
                continue;
            }
            if (jetObject instanceof JetRptParamLink) {
                bl4 = false;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "SubReport with parameters");
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 3210510, "SubReport with conditions");
                continue;
            }
            bl4 = false;
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, jetObject.getInstancePrefix() + " in SubReport");
                continue;
            }
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, 3210510, "SubReport with conditions");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptSubReport.getInstNameDirectly(), bl, bl4});
        }
        return bl4;
    }

    private boolean append(boolean bl, JetRptParagraph jetRptParagraph, boolean bl2, String string, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"Paragraph", bl, jetRptParagraph.getInstNameDirectly()});
        }
        Vector vector = jetRptParagraph.getChildren();
        boolean bl3 = true;
        int n = vector.size();
        for (int i = 0; bl3 && i < n; ++i) {
            JetObject jetObject = (JetObject)vector.get(i);
            if (!(jetObject instanceof JetRptParaReplaceElement) || (jetObject = ((JetRptParaReplaceElement)jetObject).getObject()) == null) continue;
            if (jetObject instanceof JetRptField) {
                bl3 = this.blColumnName(bl, (JetRptField)jetObject, bl2, string, jetUUniverse, queryInfo, bVResourceContainer);
                continue;
            }
            if (jetObject instanceof JetRptFilterControl) {
                if (this.ExportToRTF) {
                    bl3 = false;
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "OSF");
                        continue;
                    }
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, 3210510, "OSF");
                    continue;
                }
                bl3 = true;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210562, jetObject.getInstNameDirectly());
                    continue;
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 6205120, jetObject.getInstNameDirectly());
                continue;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205114, new Object[]{jetObject.getInstancePrefix(), bl, jetObject.getInstNameDirectly()});
            }
            bl3 = this.BorderColor(bl, jetObject, null, jetUUniverse, queryInfo, bVResourceContainer);
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, 6205115, new Object[]{jetObject.getInstNameDirectly(), bl, bl3});
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptParagraph.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean bEditable(boolean bl, JetFilterExpression jetFilterExpression, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (jetFilterExpression == null) {
            return true;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"IExpression", bl, jetFilterExpression.getInstNameDirectly()});
        }
        boolean bl2 = true;
        TreeIterater treeIterater = new TreeIterater(jetFilterExpression, false);
        JetFilterExpression jetFilterExpression2 = (JetFilterExpression)treeIterater.next();
        while (bl2 && jetFilterExpression2 != null) {
            JetReferenceExpression jetReferenceExpression;
            if (jetFilterExpression2 instanceof JetFormulaExpression) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "IFormula Usage");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "IFormula usage");
                }
                return false;
            }
            if (jetFilterExpression2 instanceof JetReferenceExpression && !(jetReferenceExpression = (JetReferenceExpression)jetFilterExpression2).isQualifyName()) {
                if (jetReferenceExpression.getQueryInfoProperty().convertToQueryInfo() != null) {
                    if (this.ExportToRTF) {
                        return false;
                    }
                } else {
                    String string = jetReferenceExpression.getAtrributeName();
                    Object[] objectArray = this.Background(bl, string, false, jetUUniverse, queryInfo, bVResourceContainer);
                    if (objectArray == null) {
                        bl2 = false;
                    } else if (!bl) {
                        String string2 = (String)objectArray[1];
                        jetReferenceExpression.setAttributeName(string2);
                        jetReferenceExpression.setName(string2);
                        jetReferenceExpression.setIsQualifyName(true);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6505139, new Object[]{string, string2});
                        }
                    }
                }
            }
            if (!bl2) continue;
            jetFilterExpression2 = (JetFilterExpression)treeIterater.next();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetFilterExpression.getInstNameDirectly(), bl, bl2});
        }
        return bl2;
    }

    private boolean blColumnName(boolean bl, JetRptField jetRptField, boolean bl2, String string, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{jetRptField.getClass().getSimpleName(), bl, jetRptField.getInstNameDirectly()});
        }
        boolean bl3 = true;
        if (jetRptField instanceof JetRptTextField || jetRptField instanceof JetRptSystemField) {
            bl3 = this.BorderColor(bl, jetRptField, null, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (jetRptField instanceof JetRptDBField) {
            bl3 = bl2 ? this.blDBField(bl, (JetRptDBField)jetRptField, string, jetUUniverse, queryInfo, bVResourceContainer) : this.blDBField(bl, (JetRptDBField)jetRptField, null, jetUUniverse, queryInfo, bVResourceContainer);
        } else if (jetRptField instanceof JetRptParameterField || jetRptField instanceof JetRptRefParameterField) {
            Vector<String> vector = new Vector<String>(1);
            vector.add(PropertyNames.getDefinitionName(PropertyNames.Parameter));
            bl3 = this.BorderColor(bl, jetRptField, vector, jetUUniverse, queryInfo, bVResourceContainer);
        } else {
            bl3 = false;
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210510, jetRptField.getClass().getName());
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210510, jetRptField.getClass().getName() + ":" + jetRptField.getInstNameDirectly());
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptField.getInstNameDirectly(), bl, bl3});
        }
        return bl3;
    }

    private boolean blDBField(boolean bl, JetRptDBField jetRptDBField, String string, JetUUniverse jetUUniverse, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        int n;
        Vector<String> vector = new Vector<String>(1);
        vector.add(PropertyNames.getDefinitionName(PropertyNames.ColumnName));
        if (jetRptDBField instanceof JetRptCTAggField) {
            n = ((JetRptCTAggField)jetRptDBField).getUseTypeValue();
            if (n == 2) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Component Level Formula(CTF)");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "CTF");
                }
                return false;
            }
            if (n == 1) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Measure used in Query Context.");
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "Measure");
                }
                return false;
            }
            if (n != 3 && n != 0) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Unkown AggType:" + n);
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 3210510, "AggType:" + n);
                }
                return false;
            }
        }
        if ((n = (int)(this.BorderColor(bl, jetRptDBField, vector, jetUUniverse, queryInfo, bVResourceContainer) ? 1 : 0)) != 0) {
            String string2 = jetRptDBField.columnName.get();
            int n2 = this.AnchorDispValue(jetUUniverse, queryInfo, string2);
            if (n2 == Integer.MAX_VALUE) {
                if (jetRptDBField instanceof JetRptCTHdDBField) {
                    String string3 = bVResourceContainer.getMappingNameConvertTo(string2, 4);
                    if (string3 == null) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210519, string2);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210519, string2);
                        }
                        return false;
                    }
                    if (!bl) {
                        jetRptDBField.columnName.set("");
                        jetRptDBField.blColumnName.set(string3);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205132, new Object[]{"ColumnName", string2, string3});
                        }
                    }
                    return true;
                }
                if (jetRptDBField instanceof JetRptCTAggField) {
                    String string4 = null;
                    String string5 = null;
                    boolean bl2 = false;
                    int n3 = ((JetRptCTAggField)jetRptDBField).getUseTypeValue();
                    if (n3 == 3) {
                        string4 = bVResourceContainer.getMappingNameConvertTo(string2, 5);
                        bl2 = false;
                    } else {
                        string5 = ((JetRptCTAggField)jetRptDBField).aggFunc.get();
                        if ((string2 == null || string2.isEmpty()) && string5.isEmpty()) {
                            bl2 = true;
                        } else {
                            string4 = bVResourceContainer.getAggregation(string2, string5);
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return true;
                    }
                    if (string4 == null) {
                        if (JRLog.isError(3)) {
                            JRLog.error(3, 3210517, new String[]{string2, string5}, null);
                        } else if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 3210517, new String[]{string2, string5});
                        }
                        return false;
                    }
                    if (!bl) {
                        jetRptDBField.columnName.set("");
                        jetRptDBField.blColumnName.set(string4);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205132, new Object[]{"ColumnName", string2, string4});
                        }
                    }
                    return true;
                }
                String string6 = bVResourceContainer.getMappingNameConvertTo(string2, 7, 4);
                if (string6 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210512, string2);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210512, string2);
                    }
                    return false;
                }
                if (!bl) {
                    jetRptDBField.columnName.set("");
                    jetRptDBField.blColumnName.set(string6);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 6205132, new Object[]{"ColumnName", string2, string6});
                    }
                }
                return true;
            }
            if (n2 == 1) {
                if (string == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210514, string2);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210514, string2);
                    }
                    return false;
                }
                JetUSummary jetUSummary = (JetUSummary)jetUUniverse.getResourceByName(queryInfo.getDatasourceName(), queryInfo.getQueryName(), string2);
                String string7 = jetUSummary.getGroupByFld();
                if (!string.equalsIgnoreCase(string7)) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210521, string2);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210521, string2);
                    }
                    return false;
                }
                String string8 = bVResourceContainer.getMappingNameConvertTo(string2, 7, 4);
                if (string8 == null) {
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210512, string2);
                    } else if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 3210512, string2);
                    }
                    return false;
                }
                if (!bl) {
                    jetRptDBField.columnName.set("");
                    jetRptDBField.blColumnName.set(string8);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 6205132, new Object[]{"ColumnName", string2, string8});
                    }
                }
                return true;
            }
            if (JRLog.isError(3)) {
                JRLog.error(3, 3210513, string2);
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, 3210513, string2);
            }
            return false;
        }
        return false;
    }

    private boolean blExp1(boolean bl, JetRptFlyFormulaMeasureSet jetRptFlyFormulaMeasureSet, IDataContainer iDataContainer, QueryInfo queryInfo, BVResourceContainer bVResourceContainer) {
        Map map;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205114, new Object[]{"FlyFormulaMeasureSe", bl, jetRptFlyFormulaMeasureSet.getInstNameDirectly()});
        }
        if (bl) {
            boolean bl2 = true;
            ResourceValidataionService resourceValidataionService = new ResourceValidataionService();
            Vector vector = jetRptFlyFormulaMeasureSet.getChildren();
            for (Object e : vector) {
                if (!(e instanceof JetRptQueryFlyFormula)) continue;
                JetRptQueryFlyFormula jetRptQueryFlyFormula = (JetRptQueryFlyFormula)e;
                if (!jetRptQueryFlyFormula.isAnonymousFormula()) {
                    bl2 = false;
                    if (JRLog.isError(3)) {
                        JRLog.error(3, 3210510, "Non-Anonymous Component-Formula");
                        break;
                    }
                    if (!JRLog.isTrace(6)) break;
                    JRLog.trace(6, 3210510, "MIX Anonymous QF");
                    break;
                }
                if (resourceValidataionService.validateDCResources(null, null, iDataContainer, jetRptQueryFlyFormula.getMappingName(), false)) continue;
                bl2 = false;
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3210510, "Non-Constant Component-Formula");
                    break;
                }
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, 3210510, "NonConstant QF");
                break;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205115, new Object[]{jetRptFlyFormulaMeasureSet.getInstNameDirectly(), bl, bl2});
            }
            return bl2;
        }
        boolean bl3 = iDataContainer instanceof JetRptCTCrossTab;
        Hashtable<String, JetRptFlyFormula> hashtable = new Hashtable<String, JetRptFlyFormula>();
        Vector<JetRptQueryFlyFormula> vector = new Vector<JetRptQueryFlyFormula>();
        Vector<JetRptFlyFormula> vector2 = new Vector<JetRptFlyFormula>();
        Vector vector3 = jetRptFlyFormulaMeasureSet.getChildren();
        for (Object object52 : vector3) {
            if (!(object52 instanceof JetRptQueryFlyFormula)) continue;
            object4 = (JetRptQueryFlyFormula)object52;
            object3 = new JetRptFlyFormula();
            JetRptFlyFormula.copyProperties((JetObject)object3, (JetObject)object4);
            ((JetObject)object3).setInstNameDirectly(((JetObject)object4).getInstNameDirectly());
            object2 = ((JetRptContainer)object4).getChildren();
            while (!((Vector)object2).isEmpty()) {
                object = (JetObject)((Vector)object2).remove(0);
                ((JetObject)object).setParentDirectly((JetContainable)object3);
                ((JetRptContainer)object3).getChildren().add(object);
            }
            hashtable.put((bl3 ? ((JetRptQueryFlyFormula)object4).getColumnDisplayName() : ((JetRptAbstractFormula)object4).getMappingName()).toUpperCase(), (JetRptFlyFormula)object3);
            vector.add((JetRptQueryFlyFormula)object4);
            vector2.add((JetRptFlyFormula)object3);
        }
        for (JetRptQueryFlyFormula jetRptQueryFlyFormula : vector) {
            ObjectLogicFactory.getBasicComponentLogic().remove(jetRptQueryFlyFormula);
        }
        for (JetRptFlyFormula jetRptFlyFormula : vector2) {
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptFlyFormulaMeasureSet, jetRptFlyFormula);
        }
        QueryInfoImpl queryInfoImpl = new QueryInfoImpl(queryInfo.getCatalogName(), queryInfo.getDatasourceName(), "", bVResourceContainer.getBVName(), 2);
        jetRptFlyFormulaMeasureSet.resetQueryInfo(queryInfoImpl);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6505142, new Object[]{queryInfo.getQueryName(), bVResourceContainer.getBVName()});
        }
        if ((object4 = (List)(map = ObjectLogicFactory.getDataContainerLogic().getChangeByDynamicFormulaByUsage(iDataContainer, false, true, 0)).get(iDataContainer)) == null || object4.isEmpty()) {
            return true;
        }
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (JetProperty)object3.next();
            object = (String)((JetProperty)object2).getChangeByObject();
            JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)hashtable.get(((String)object).toUpperCase());
            if (jetRptFlyFormula == null) continue;
            ((JetProperty)object2).setChangeByObject(null, (short)1);
            if (((JetProperty)object2).isChangeByBL()) {
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, 650141, ((JetProperty)object2).getName());
                continue;
            }
            ((JetProperty)object2).setChangeByBL(jetRptFlyFormula.getQualifyDisplayName(), (short)1);
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, 650140, new String[]{((JetProperty)object2).getName(), object, jetRptFlyFormula.getQualifyDisplayName()});
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205115, new Object[]{jetRptFlyFormulaMeasureSet.getInstNameDirectly(), bl, true});
        }
        return true;
    }

    static {
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.Background));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.Invisible));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.Suppressed));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.SuppressedIfNoRecords));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.TOCAnchor));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToApplet));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToCSV));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToDHTML));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToHTML));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToPDF));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToPostScript));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToRTF));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToText));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToXLS));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.ExportToXML));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.AnchorDispValue));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.BorderColor));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.border_top_color));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.border_right_color));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.border_bottom_color));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.border_left_color));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.SelectStartPosition));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.RecordLocation));
        AnchorDispValue.add(PropertyNames.getDefinitionName(PropertyNames.SuppressEmpty));
        HashMap hashMap = new HashMap();
        JetLinkProperties.fillIndecialMap(true, true, true, hashMap);
        Background = new Vector(hashMap.keySet());
        hashMap.clear();
        hashMap = null;
        ExportToPostScript = null;
    }

    private static class PrepareDataStruct {
        private final boolean SEDU;
        List canUsedBVs = null;
        boolean isInSectionObj = false;
        DataSet dataset = null;

        PrepareDataStruct(boolean bl) {
            this.SEDU = bl;
        }
    }

    private class BVResourceContainer {
        private List SEDU;
        private JUnifiedBusinessView get;
        private boolean getAgginfo;

        private BVResourceContainer(List list, boolean bl) {
            if (bl) {
                this.SEDU = new Vector(list);
                this.getAgginfo = true;
            } else {
                this.get = (JUnifiedBusinessView)list.get(0);
                this.getAgginfo = false;
            }
        }

        public String getMappingNameConvertTo(String string, int ... nArray) {
            if (this.getAgginfo) {
                String string2 = null;
                int n = this.SEDU.size();
                for (int i = n - 1; i >= 0; --i) {
                    JUnifiedBusinessView jUnifiedBusinessView = (JUnifiedBusinessView)this.SEDU.get(i);
                    BLNode bLNode = jUnifiedBusinessView.getBlNodeByMappingName(string, nArray);
                    if (bLNode == null) {
                        this.SEDU.remove(i);
                        continue;
                    }
                    string2 = bLNode.getQualifyDisplayName();
                }
                return this.SEDU.isEmpty() ? null : string2;
            }
            BLNode bLNode = this.get.getBlNodeByMappingName(string, nArray);
            if (bLNode == null) {
                return null;
            }
            return bLNode.getQualifyDisplayName();
        }

        public String getAggregation(String string, String string2) {
            if (this.getAgginfo) {
                String string3 = null;
                int n = this.SEDU.size();
                for (int i = n - 1; i >= 0; --i) {
                    JUnifiedBusinessView jUnifiedBusinessView = (JUnifiedBusinessView)this.SEDU.get(i);
                    AggregationInfo aggregationInfo = jUnifiedBusinessView.getAgginfo(string, string2);
                    if (aggregationInfo == null) {
                        this.SEDU.remove(i);
                        continue;
                    }
                    string3 = aggregationInfo.getQualifyDisplayName();
                }
                return string3;
            }
            AggregationInfo aggregationInfo = this.get.getAgginfo(string, string2);
            if (aggregationInfo == null) {
                return null;
            }
            return aggregationInfo.getQualifyDisplayName();
        }

        public String getBVName() {
            if (this.getAgginfo) {
                throw new IllegalAccessError();
            }
            return this.get.getQualifyDisplayName();
        }
    }
}

