/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jet.controls.JetBigString;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.QueryInfoImpl;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSectionObject;
import jet.report.chart.JetRptChartPlatform;
import jet.report.gmap.JetRptGMarker;
import jet.report.mode.actions.JetRptAction;
import jet.report.mode.actions.JetRptActionContainer;
import jet.report.mode.actions.JetRptAtomicAction;
import jet.report.mode.actions.JetRptSubActionItem;
import jet.report.mode.actions.argExp.JetRptAtomicParamColumnArgExp;
import jet.report.mode.actions.argExp.JetRptAtomicParamConstArgExp;
import jet.report.mode.actions.argExp.JetRptAtomicParamJRObjArgExp;
import jet.report.mode.actions.argExp.JetRptAtomicParamKwdArgExp;
import jet.report.mode.actions.argExp.JetRptAtomicParamRefArgExp;
import jet.report.mode.actions.cusAct.JetRptCusBatchSetParameterAction;
import jet.report.mode.actions.cusAct.JetRptCusBatchSetParameterActionParam;
import jet.report.mode.actions.cusAct.JetRptCusBatchSetPropertyAction;
import jet.report.mode.actions.cusAct.JetRptCusBatchSetPropertyActionParam;
import jet.report.mode.actions.cusAct.JetRptCusCustomizeCtrlAction;
import jet.report.mode.actions.cusAct.JetRptCusDoFilterAction;
import jet.report.mode.actions.cusAct.JetRptCusDoFilterActionParam;
import jet.report.mode.actions.cusAct.JetRptCusDoSortAction;
import jet.report.mode.actions.cusAct.JetRptCusDoSortActionParam;
import jet.report.mode.actions.cusAct.JetRptCusSendMessageAction;
import jet.report.mode.actions.cusAct.JetRptCusSendMessageActionParam;
import jet.report.mode.actions.jsAct.JetRptJSAction;
import jet.report.mode.actions.jsAct.JetRptJSActionParam;
import jet.report.mode.common.RptAction;
import jet.report.mode.common.RptAtomicAction;
import jet.report.mode.common.RptAtomicParam;
import jet.report.mode.common.RptSubActionItem;
import jet.report.mode.common.argExpression.AtomicParamArgExp;
import jet.report.mode.common.argExpression.AtomicParamColArgExp;
import jet.report.mode.common.argExpression.AtomicParamConstArgExp;
import jet.report.mode.common.argExpression.AtomicParamJRObjArgExp;
import jet.report.mode.common.argExpression.AtomicParamKeywordArgExp;
import jet.report.mode.common.argExpression.AtomicParamRefArgExp;
import jet.report.mode.common.argExpression.AtomicParamValueArgExp;
import jet.report.mode.common.cusAction.CusBatchSetParameterAction;
import jet.report.mode.common.cusAction.CusBatchSetParameterActionParam;
import jet.report.mode.common.cusAction.CusBatchSetPropertyAction;
import jet.report.mode.common.cusAction.CusBatchSetPropertyActionParam;
import jet.report.mode.common.cusAction.CusCustomizeCtrlAction;
import jet.report.mode.common.cusAction.CusDoFilterAction;
import jet.report.mode.common.cusAction.CusDoFilterActionParam;
import jet.report.mode.common.cusAction.CusDoSortAction;
import jet.report.mode.common.cusAction.CusDoSortActionParam;
import jet.report.mode.common.cusAction.CusSendMessageAction;
import jet.report.mode.common.cusAction.CusSendMessageActionParam;
import jet.report.mode.common.cusAction.CustomActionParam;
import jet.report.mode.common.cusAction.CustomAtomicAction;
import jet.report.mode.common.jsAction.JSAction;
import jet.report.mode.common.jsAction.JSActionParam;
import jet.report.table.JetRptNewTable;
import jet.reportLogic.objectInfo.ObjectResourceInfo;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.EventActionLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.resourceLogic.DataContainerInfo;
import jet.reportLogic.objectLogic.resourceLogic.DataContainerInfoFactory;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.util.TreeIterater;

class EventActionLogicImpl
implements EventActionLogic {
    private BasicComponentLogic I = ObjectLogicFactory.getBasicComponentLogic();

    EventActionLogicImpl() {
    }

    @Override
    public JSAction createJSAction(String string, String string2, AtomicParamArgExp atomicParamArgExp, JSActionParam[] jSActionParamArray) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        JetRptJSAction jetRptJSAction = new JetRptJSAction();
        jetRptJSAction.setEditable();
        jetRptJSAction.setArgumentScope(atomicParamArgExp);
        jetRptJSAction.setFunctionName(string);
        jetRptJSAction.setFunctionURI(string2);
        jetRptJSAction.setArgumentScope(atomicParamArgExp);
        int n = jSActionParamArray == null ? 0 : jSActionParamArray.length;
        for (int i = 0; i < n; ++i) {
            this.I.add(jetRptJSAction, (JetObject)((Object)jSActionParamArray[i]));
        }
        return jetRptJSAction;
    }

    @Override
    public JSActionParam createJSActionParam(String string, String string2, AtomicParamArgExp atomicParamArgExp) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (atomicParamArgExp == null) {
            return null;
        }
        JetRptJSActionParam jetRptJSActionParam = new JetRptJSActionParam();
        jetRptJSActionParam.setEditable();
        jetRptJSActionParam.setArgumentName(string);
        jetRptJSActionParam.setArgumentType(string2);
        jetRptJSActionParam.setArgumentValue(atomicParamArgExp);
        return jetRptJSActionParam;
    }

    @Override
    public CustomAtomicAction createCustomAction(int n, String string, AtomicParamArgExp atomicParamArgExp, int n2, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, CustomActionParam[] customActionParamArray) {
        switch (n) {
            case 3: {
                return this.createCustomSetParameterAction(string, atomicParamArgExp, n2, atomicParamArgExp2, atomicParamArgExp3, customActionParamArray);
            }
            case 2: {
                return this.createCustomSortAction(string, atomicParamArgExp, n2, atomicParamArgExp2, atomicParamArgExp3, customActionParamArray);
            }
            case 1: {
                return this.createCustomFilterAction(string, atomicParamArgExp, n2, atomicParamArgExp2, atomicParamArgExp3, customActionParamArray);
            }
            case 4: {
                return this.createCustomSetPropertyAction(string, atomicParamArgExp, n2, atomicParamArgExp2, atomicParamArgExp3, customActionParamArray);
            }
        }
        return null;
    }

    CusBatchSetParameterAction createCustomSetParameterAction(String string, AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, CustomActionParam[] customActionParamArray) {
        if (atomicParamArgExp == null || customActionParamArray == null || n != 1 && atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusBatchSetParameterAction jetRptCusBatchSetParameterAction = new JetRptCusBatchSetParameterAction();
        jetRptCusBatchSetParameterAction.setEditable();
        for (int i = 0; i < customActionParamArray.length; ++i) {
            if (!(customActionParamArray[i] instanceof CusBatchSetParameterActionParam)) continue;
            this.I.add(jetRptCusBatchSetParameterAction, (JetObject)((Object)customActionParamArray[i]));
        }
        this.setCustomAtomicCommons(jetRptCusBatchSetParameterAction, string, atomicParamArgExp, n, atomicParamArgExp2, atomicParamArgExp3);
        return jetRptCusBatchSetParameterAction;
    }

    CusDoSortAction createCustomSortAction(String string, AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, CustomActionParam[] customActionParamArray) {
        if (atomicParamArgExp == null || customActionParamArray == null || n != 1 && atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusDoSortAction jetRptCusDoSortAction = new JetRptCusDoSortAction();
        jetRptCusDoSortAction.setEditable();
        for (int i = 0; i < customActionParamArray.length; ++i) {
            if (!(customActionParamArray[i] instanceof CusDoSortActionParam)) continue;
            this.I.add(jetRptCusDoSortAction, (JetObject)((Object)customActionParamArray[i]));
        }
        this.setCustomAtomicCommons(jetRptCusDoSortAction, string, atomicParamArgExp, n, atomicParamArgExp2, atomicParamArgExp3);
        return jetRptCusDoSortAction;
    }

    CusDoFilterAction createCustomFilterAction(String string, AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, CustomActionParam[] customActionParamArray) {
        if (atomicParamArgExp == null || customActionParamArray == null || n != 1 && atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusDoFilterAction jetRptCusDoFilterAction = new JetRptCusDoFilterAction();
        jetRptCusDoFilterAction.setEditable();
        for (int i = 0; i < customActionParamArray.length; ++i) {
            if (!(customActionParamArray[i] instanceof CusDoFilterActionParam)) continue;
            this.I.add(jetRptCusDoFilterAction, (JetObject)((Object)customActionParamArray[i]));
        }
        this.setCustomAtomicCommons(jetRptCusDoFilterAction, string, atomicParamArgExp, n, atomicParamArgExp2, atomicParamArgExp3);
        return jetRptCusDoFilterAction;
    }

    CusBatchSetPropertyAction createCustomSetPropertyAction(String string, AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, CustomActionParam[] customActionParamArray) {
        if (atomicParamArgExp == null || customActionParamArray == null || n != 1 && atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusBatchSetPropertyAction jetRptCusBatchSetPropertyAction = new JetRptCusBatchSetPropertyAction();
        jetRptCusBatchSetPropertyAction.setEditable();
        for (int i = 0; i < customActionParamArray.length; ++i) {
            if (!(customActionParamArray[i] instanceof CusBatchSetPropertyActionParam)) continue;
            this.I.add(jetRptCusBatchSetPropertyAction, (JetObject)((Object)customActionParamArray[i]));
        }
        this.setCustomAtomicCommons(jetRptCusBatchSetPropertyAction, string, atomicParamArgExp, n, atomicParamArgExp2, atomicParamArgExp3);
        return jetRptCusBatchSetPropertyAction;
    }

    @Override
    public CusSendMessageAction createCustomSendMessageAction(int n, String string, CustomActionParam[] customActionParamArray) {
        return this.createCustomSendMessageAction(n, string, null, customActionParamArray);
    }

    @Override
    public CusSendMessageAction createCustomSendMessageAction(int n, String string, int[] nArray, CustomActionParam[] customActionParamArray) {
        JetRptCusSendMessageAction jetRptCusSendMessageAction = new JetRptCusSendMessageAction(n, string, nArray);
        jetRptCusSendMessageAction.setEditable();
        for (int i = 0; i < customActionParamArray.length; ++i) {
            if (!(customActionParamArray[i] instanceof CusSendMessageActionParam)) continue;
            this.I.add(jetRptCusSendMessageAction, (JetObject)((Object)customActionParamArray[i]));
        }
        this.setCustomAtomicCommons(jetRptCusSendMessageAction, null, new JetRptAtomicParamKwdArgExp(), Integer.MAX_VALUE, new JetRptAtomicParamKwdArgExp(), new JetRptAtomicParamKwdArgExp());
        return jetRptCusSendMessageAction;
    }

    @Override
    public CusCustomizeCtrlAction createCustomCustomizeControlAction(String string, boolean bl, int n, int n2, int n3, int n4, int n5, String string2) {
        if (string == null || string.isEmpty()) {
            JetRptCusCustomizeCtrlAction jetRptCusCustomizeCtrlAction = new JetRptCusCustomizeCtrlAction();
            jetRptCusCustomizeCtrlAction.setAutoSize(bl);
            if (!bl) {
                jetRptCusCustomizeCtrlAction.setWidth(n);
                jetRptCusCustomizeCtrlAction.setHeight(n2);
            }
            jetRptCusCustomizeCtrlAction.setLocationType(n3);
            jetRptCusCustomizeCtrlAction.setLocation(n4, n5);
            jetRptCusCustomizeCtrlAction.setContent(string2);
            return jetRptCusCustomizeCtrlAction;
        }
        return new JetRptCusCustomizeCtrlAction(string);
    }

    void setCustomAtomicCommons(CustomAtomicAction customAtomicAction, String string, AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3) {
        customAtomicAction.setActionHandler(string);
        customAtomicAction.setScope(atomicParamArgExp);
        customAtomicAction.setApplyTo(n, atomicParamArgExp2);
        customAtomicAction.setApplyToTarget(atomicParamArgExp3);
    }

    public CusDoFilterActionParam createCustomFilterActParam(AtomicParamArgExp atomicParamArgExp, int n, AtomicParamArgExp atomicParamArgExp2, int n2) {
        JetRptCusDoFilterActionParam jetRptCusDoFilterActionParam = new JetRptCusDoFilterActionParam();
        jetRptCusDoFilterActionParam.setEditable();
        jetRptCusDoFilterActionParam.setParamName(atomicParamArgExp);
        jetRptCusDoFilterActionParam.setParamValue(atomicParamArgExp2);
        jetRptCusDoFilterActionParam.setParamRelationOp(this.createConstArgExp(n));
        jetRptCusDoFilterActionParam.setLogicOperator(n2);
        return jetRptCusDoFilterActionParam;
    }

    @Override
    public CusDoFilterActionParam createCustomFilterActParam(AtomicParamArgExp atomicParamArgExp, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3, int n) {
        if (atomicParamArgExp == null || atomicParamArgExp2 == null || atomicParamArgExp3 == null) {
            return null;
        }
        JetRptCusDoFilterActionParam jetRptCusDoFilterActionParam = new JetRptCusDoFilterActionParam();
        jetRptCusDoFilterActionParam.setEditable();
        jetRptCusDoFilterActionParam.setParamName(atomicParamArgExp);
        jetRptCusDoFilterActionParam.setParamValue(atomicParamArgExp3);
        jetRptCusDoFilterActionParam.setParamRelationOp(atomicParamArgExp2);
        jetRptCusDoFilterActionParam.setLogicOperator(n);
        return jetRptCusDoFilterActionParam;
    }

    @Override
    public CusBatchSetParameterActionParam createCustomSetParamActParam(AtomicParamArgExp atomicParamArgExp, AtomicParamArgExp atomicParamArgExp2) {
        if (atomicParamArgExp == null || atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusBatchSetParameterActionParam jetRptCusBatchSetParameterActionParam = new JetRptCusBatchSetParameterActionParam();
        jetRptCusBatchSetParameterActionParam.setEditable();
        jetRptCusBatchSetParameterActionParam.setParameterName(atomicParamArgExp);
        jetRptCusBatchSetParameterActionParam.setParameterValue(atomicParamArgExp2);
        return jetRptCusBatchSetParameterActionParam;
    }

    @Override
    public CusDoSortActionParam createCustomSortActParam(AtomicParamArgExp atomicParamArgExp, AtomicParamArgExp atomicParamArgExp2) {
        if (atomicParamArgExp == null || atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusDoSortActionParam jetRptCusDoSortActionParam = new JetRptCusDoSortActionParam();
        jetRptCusDoSortActionParam.setEditable();
        jetRptCusDoSortActionParam.setParamName(atomicParamArgExp);
        jetRptCusDoSortActionParam.setParamValue(atomicParamArgExp2);
        return jetRptCusDoSortActionParam;
    }

    @Override
    public CusSendMessageActionParam createCustomSendMessageActParam(AtomicParamArgExp atomicParamArgExp, AtomicParamArgExp atomicParamArgExp2, AtomicParamArgExp atomicParamArgExp3) {
        if (atomicParamArgExp == null || atomicParamArgExp2 == null || atomicParamArgExp3 == null) {
            return null;
        }
        JetRptCusSendMessageActionParam jetRptCusSendMessageActionParam = new JetRptCusSendMessageActionParam();
        jetRptCusSendMessageActionParam.setEditable();
        jetRptCusSendMessageActionParam.setParameterKey(atomicParamArgExp);
        jetRptCusSendMessageActionParam.setParameterDataType(atomicParamArgExp2);
        jetRptCusSendMessageActionParam.setParameterValue(atomicParamArgExp3);
        return jetRptCusSendMessageActionParam;
    }

    @Override
    public CusBatchSetPropertyActionParam createCustomSetPropActionParam(AtomicParamArgExp atomicParamArgExp, AtomicParamArgExp atomicParamArgExp2) {
        if (atomicParamArgExp == null || atomicParamArgExp2 == null) {
            return null;
        }
        JetRptCusBatchSetPropertyActionParam jetRptCusBatchSetPropertyActionParam = new JetRptCusBatchSetPropertyActionParam();
        jetRptCusBatchSetPropertyActionParam.setEditable();
        jetRptCusBatchSetPropertyActionParam.setPropertyName(atomicParamArgExp);
        jetRptCusBatchSetPropertyActionParam.setPropertyValue(atomicParamArgExp2);
        return jetRptCusBatchSetPropertyActionParam;
    }

    @Override
    public AtomicParamConstArgExp createConstArgExp(Object object) {
        JetRptAtomicParamConstArgExp jetRptAtomicParamConstArgExp = new JetRptAtomicParamConstArgExp();
        jetRptAtomicParamConstArgExp.setConst(object);
        return jetRptAtomicParamConstArgExp;
    }

    @Override
    public AtomicParamRefArgExp createRefrenceArgExp(String string) {
        JetRptAtomicParamRefArgExp jetRptAtomicParamRefArgExp = new JetRptAtomicParamRefArgExp();
        jetRptAtomicParamRefArgExp.setRefValue(string);
        return jetRptAtomicParamRefArgExp;
    }

    @Override
    public AtomicParamJRObjArgExp createJRObjArgExp(JetObject jetObject) {
        JetRptAtomicParamJRObjArgExp jetRptAtomicParamJRObjArgExp = new JetRptAtomicParamJRObjArgExp();
        jetRptAtomicParamJRObjArgExp.setJRValue(jetObject);
        return jetRptAtomicParamJRObjArgExp;
    }

    @Override
    public AtomicParamKeywordArgExp createKeywordArgExp(int n) {
        return new JetRptAtomicParamKwdArgExp(n);
    }

    @Override
    public AtomicParamColArgExp createColumnArgExp(String string) {
        return new JetRptAtomicParamColumnArgExp(string);
    }

    @Override
    public RptAtomicAction appendParamterTo(RptAtomicAction rptAtomicAction, RptAtomicParam rptAtomicParam) {
        if (rptAtomicAction != null && rptAtomicParam != null) {
            int n = rptAtomicAction.getAtomicType();
            int n2 = rptAtomicParam.getActionArgInfoType();
            if (n == 1) {
                if (n2 == 2) {
                    this.I.add((JetContainable)((Object)rptAtomicAction), (JetObject)((Object)rptAtomicParam));
                }
            } else if (n == 4 && n2 == 1) {
                this.I.add((JetContainable)((Object)rptAtomicAction), (JetObject)((Object)rptAtomicParam));
            }
        }
        return rptAtomicAction;
    }

    @Override
    public RptAction createAction(RptAction[] rptActionArray) {
        JetRptAction jetRptAction = null;
        if (rptActionArray != null && rptActionArray.length != 0) {
            jetRptAction = new JetRptAction();
            jetRptAction.setEditable();
            int n = rptActionArray.length;
            for (int i = 0; i < n; ++i) {
                RptAtomicAction[] rptAtomicActionArray = rptActionArray[i].expandAndGetAllAtomicAction();
                int n2 = rptAtomicActionArray.length;
                for (int j = 0; j < n2; ++j) {
                    JetRptSubActionItem jetRptSubActionItem = new JetRptSubActionItem(rptAtomicActionArray[i]);
                    jetRptSubActionItem.setEditable();
                    this.I.add(jetRptAction, jetRptSubActionItem);
                }
            }
        }
        return jetRptAction;
    }

    @Override
    public RptAction createAction(RptAtomicAction[] rptAtomicActionArray) {
        JetRptAction jetRptAction = null;
        if (rptAtomicActionArray != null && rptAtomicActionArray.length != 0) {
            jetRptAction = new JetRptAction();
            jetRptAction.setEditable();
            int n = rptAtomicActionArray.length;
            for (int i = 0; i < n; ++i) {
                JetRptSubActionItem jetRptSubActionItem = new JetRptSubActionItem(rptAtomicActionArray[i]);
                jetRptSubActionItem.setEditable();
                this.I.add(jetRptAction, jetRptSubActionItem);
            }
        }
        return jetRptAction;
    }

    @Override
    public RptAction appendToAction(RptAction rptAction, RptAction[] rptActionArray) {
        if (rptAction == null) {
            return null;
        }
        int n = rptActionArray == null ? 0 : rptActionArray.length;
        for (int i = 0; i < n; ++i) {
            RptAtomicAction[] rptAtomicActionArray = rptActionArray[i].expandAndGetAllAtomicAction();
            this.addAtomicActionsToAction(rptAction, rptAtomicActionArray);
        }
        return rptAction;
    }

    @Override
    public RptAction appendToAction(RptAction rptAction, RptAtomicAction[] rptAtomicActionArray) {
        if (rptAction == null) {
            return null;
        }
        this.addAtomicActionsToAction(rptAction, rptAtomicActionArray);
        return rptAction;
    }

    RptAction addAtomicActionsToAction(RptAction rptAction, RptAtomicAction[] rptAtomicActionArray) {
        if (rptAction == null) {
            return null;
        }
        int n = rptAtomicActionArray == null ? 0 : rptAtomicActionArray.length;
        JetContainable jetContainable = ((JetRptObject)((Object)rptAction)).getParent();
        JetRptActionContainer jetRptActionContainer = null;
        if (jetContainable != null && jetContainable instanceof JetRptActionContainer) {
            jetRptActionContainer = (JetRptActionContainer)jetContainable;
        }
        for (int i = 0; i < n; ++i) {
            JetRptSubActionItem jetRptSubActionItem = new JetRptSubActionItem(rptAtomicActionArray[i]);
            jetRptSubActionItem.setEditable();
            jetRptSubActionItem.setAtomicAction(this.I(jetRptActionContainer, rptAtomicActionArray[i]));
            this.I.add((JetContainable)((Object)rptAction), jetRptSubActionItem);
        }
        return rptAction;
    }

    @Override
    public RptAction removeAtomicActionFromAction(RptAction rptAction, RptAtomicAction rptAtomicAction) {
        if (rptAction == null || rptAtomicAction == null) {
            return rptAction;
        }
        int n = rptAction.indexOf(rptAtomicAction);
        if (n < 0) {
            return rptAction;
        }
        JetContainable jetContainable = ((JetRptObject)((Object)rptAction)).getParent();
        if (jetContainable != null && jetContainable instanceof JetRptActionContainer) {
            this.SEDU((JetRptActionContainer)jetContainable, rptAtomicAction);
        }
        return rptAction;
    }

    @Override
    public RptAction addActionToActionContainer(JetRptActionContainer jetRptActionContainer, RptAction rptAction) {
        if (jetRptActionContainer == null) {
            return rptAction;
        }
        Vector vector = jetRptActionContainer.getChildren();
        int n = vector.size();
        RptAction rptAction2 = null;
        for (int i = 0; i < n; ++i) {
            RptAction rptAction3;
            if (!(vector.get(i) instanceof RptAction) || !(rptAction3 = (RptAction)vector.get(i)).isEqual(rptAction)) continue;
            rptAction2 = rptAction3;
            break;
        }
        if (rptAction2 != null) {
            return rptAction2;
        }
        this.I.add(jetRptActionContainer, (JetRptAction)rptAction);
        Vector vector2 = ((JetRptAction)rptAction).getChildren();
        n = vector2.size();
        for (int i = 0; i < n; ++i) {
            RptSubActionItem rptSubActionItem = (RptSubActionItem)vector2.get(i);
            if (rptSubActionItem.getType() != 2) continue;
            rptSubActionItem.setAtomicAction(this.I(jetRptActionContainer, rptSubActionItem.getAtomicAction()));
        }
        return rptAction;
    }

    @Override
    public boolean removeActionFromActionContainer(JetRptActionContainer jetRptActionContainer, RptAction rptAction) {
        if (rptAction == null || jetRptActionContainer == null) {
            return false;
        }
        if (((JetRptObject)((Object)rptAction)).getRefObjects().size() > 0) {
            return false;
        }
        Vector vector = ((JetContainable)((Object)rptAction)).getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            RptSubActionItem rptSubActionItem = (RptSubActionItem)vector.get(i);
            if (rptSubActionItem.getType() == 1) continue;
            RptAtomicAction rptAtomicAction = rptSubActionItem.getAtomicAction();
            rptSubActionItem.setAtomicAction(rptAtomicAction.cloneThis());
            this.removeAtomicActionFromAction(rptAction, rptAtomicAction);
        }
        this.I.remove((JetRptObject)((Object)rptAction));
        return true;
    }

    private RptAtomicAction I(JetRptActionContainer jetRptActionContainer, RptAtomicAction rptAtomicAction) {
        if (jetRptActionContainer == null) {
            return rptAtomicAction;
        }
        RptAtomicAction rptAtomicAction2 = null;
        Vector vector = jetRptActionContainer.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RptAtomicAction rptAtomicAction3;
            if (!(vector.get(i) instanceof RptAtomicAction) || !(rptAtomicAction3 = (RptAtomicAction)vector.get(i)).isEqual(rptAtomicAction)) continue;
            rptAtomicAction2 = rptAtomicAction3;
            break;
        }
        if (rptAtomicAction2 != null) {
            rptAtomicAction = null;
            return rptAtomicAction2;
        }
        this.I.add(jetRptActionContainer, (JetRptAtomicAction)rptAtomicAction);
        return rptAtomicAction;
    }

    private boolean SEDU(JetRptActionContainer jetRptActionContainer, RptAtomicAction rptAtomicAction) {
        if (jetRptActionContainer == null) {
            return false;
        }
        RptAtomicAction rptAtomicAction2 = this.add(jetRptActionContainer, rptAtomicAction);
        if (rptAtomicAction2 == null) {
            return false;
        }
        if (((JetRptObject)((Object)rptAtomicAction2)).getRefObjects().size() > 0) {
            return false;
        }
        this.I.remove((JetRptObject)((Object)rptAtomicAction2));
        return true;
    }

    private RptAtomicAction add(JetRptActionContainer jetRptActionContainer, RptAtomicAction rptAtomicAction) {
        if (jetRptActionContainer == null || rptAtomicAction == null) {
            return null;
        }
        Vector vector = jetRptActionContainer.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RptAtomicAction rptAtomicAction2;
            if (!(vector.get(i) instanceof RptAtomicAction) || !(rptAtomicAction2 = (RptAtomicAction)vector.get(i)).isEqual(rptAtomicAction)) continue;
            return rptAtomicAction2;
        }
        return null;
    }

    @Override
    public boolean exchangeActomicActionOnAction(RptAction rptAction, RptAtomicAction rptAtomicAction, RptAtomicAction rptAtomicAction2) {
        if (rptAction == null || rptAtomicAction == null || rptAtomicAction2 == null) {
            return false;
        }
        int n = rptAction.indexOf(rptAtomicAction);
        int n2 = rptAction.indexOf(rptAtomicAction2);
        if (n == -1 || n2 == -1) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        RptSubActionItem rptSubActionItem = rptAction.getSubActionAt(n);
        RptSubActionItem rptSubActionItem2 = rptAction.getSubActionAt(n2);
        RptAtomicAction rptAtomicAction3 = rptSubActionItem.getAtomicAction();
        rptSubActionItem.setAtomicAction(rptSubActionItem2.getAtomicAction());
        rptSubActionItem2.setAtomicAction(rptAtomicAction3);
        return true;
    }

    @Override
    public boolean moveAtomicAction(RptAction rptAction, RptAtomicAction rptAtomicAction, int n) {
        if (rptAction == null || rptAtomicAction == null) {
            return false;
        }
        Vector vector = ((JetContainable)((Object)rptAction)).getChildren();
        int n2 = vector.size();
        if (n < 0 || n >= n2) {
            return false;
        }
        int n3 = rptAction.indexOf(rptAtomicAction);
        if (n == n3) {
            return true;
        }
        int n4 = n3 < n ? n3 : n;
        int n5 = n3 < n ? n : n3;
        RptAtomicAction rptAtomicAction2 = rptAction.getSubActionAt(n4).getAtomicAction();
        for (int i = n4 + 1; i <= n5; ++i) {
            RptSubActionItem rptSubActionItem = rptAction.getSubActionAt(i - 1);
            RptSubActionItem rptSubActionItem2 = rptAction.getSubActionAt(i);
            rptSubActionItem.setAtomicAction(rptSubActionItem2.getAtomicAction());
        }
        rptAction.getSubActionAt(n5).setAtomicAction(rptAtomicAction2);
        return true;
    }

    @Override
    public boolean addAtomicActionToAction(RptAction rptAction, RptAtomicAction rptAtomicAction, int n) {
        JetContainable jetContainable;
        if (rptAction == null || rptAtomicAction == null) {
            return false;
        }
        JetRptSubActionItem jetRptSubActionItem = new JetRptSubActionItem(rptAtomicAction);
        jetRptSubActionItem.setEditable();
        if (n < 0 || n >= ((JetContainable)((Object)rptAction)).getChildren().size()) {
            n = -1;
        }
        if ((jetContainable = ((JetRptObject)((Object)rptAction)).getParent()) != null && jetContainable instanceof JetRptActionContainer) {
            jetRptSubActionItem.setAtomicAction(this.I((JetRptActionContainer)jetContainable, rptAtomicAction));
        }
        this.I.add((JetContainable)((Object)rptAction), jetRptSubActionItem, n);
        return true;
    }

    @Override
    public List[] getCustomizedActionCanApplyTo(IReport iReport, int n) {
        switch (n) {
            case 1: {
                return this.getCusFilterActCanApplyTo(iReport);
            }
            case 2: {
                return this.getCusSortActCanApplyTo(iReport);
            }
            case 3: {
                return this.getCusSetParamActCanApplyTo(iReport);
            }
            case 5: {
                return this.getCusGotoPageActCanApplyTo(iReport);
            }
            case 6: {
                return this.getCusChgStyleActCanApplyTo(iReport);
            }
            case 4: {
                return this.getCusSetPropActCanApplyTo(iReport);
            }
            case 7: {
                return this.getCusRotateActApplyTo(iReport);
            }
            case 8: {
                return this.getChgChartTypeActApplyTo(iReport);
            }
        }
        return new Vector[0];
    }

    protected List[] getCusFilterActCanApplyTo(IReport iReport) {
        List[] listArray = new List[5];
        for (int i = 0; i < 5; ++i) {
            listArray[i] = new Vector();
        }
        listArray[0] = iReport.getIRptBody().getUsedDataSet();
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptSectionObject) {
                listArray[1].add((JetObject)object);
            } else if (object instanceof JetRptNewTable) {
                listArray[2].add((JetObject)object);
            } else if (object instanceof JetRptCTCrossTab) {
                listArray[3].add(object);
            } else if (object instanceof JetRptChartPlatform) {
                listArray[4].add(object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getCusSortActCanApplyTo(IReport iReport) {
        List[] listArray = new List[6];
        for (int i = 0; i < 6; ++i) {
            listArray[i] = new Vector();
        }
        listArray[0] = iReport.getIRptBody().getUsedDataSet();
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptSectionObject) {
                listArray[1].add((JetObject)object);
            } else if (object instanceof JetRptNewTable) {
                listArray[2].add((JetObject)object);
            } else if (object instanceof JetRptGroupPanel) {
                if (!(object instanceof JetRptGMarker)) {
                    listArray[3].add((JetObject)object);
                }
            } else if (object instanceof JetRptChartPlatform) {
                listArray[4].add(object);
            } else if (object instanceof JetRptCTCrossTab) {
                listArray[5].add(object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getCusSetParamActCanApplyTo(IReport iReport) {
        List[] listArray = new List[2];
        for (int i = 0; i < 2; ++i) {
            listArray[i] = new Vector();
        }
        if (iReport instanceof JetRptReport) {
            List list = ((JetRptReport)iReport).getUsedDataSet();
            for (DataSet dataSet : list) {
                listArray[0].add(dataSet.getCatalogName());
            }
        }
        return listArray;
    }

    protected List[] getCusGotoPageActCanApplyTo(IReport iReport) {
        List[] listArray = new List[5];
        for (int i = 0; i < 5; ++i) {
            listArray[i] = new Vector();
        }
        listArray[0] = iReport.getIRptBody().getUsedDataSet();
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptSectionObject) {
                listArray[1].add((JetObject)object);
            } else if (object instanceof JetRptNewTable) {
                listArray[2].add((JetObject)object);
            } else if (object instanceof JetRptCTCrossTab) {
                listArray[3].add((JetObject)object);
            } else if (object instanceof JetRptChartPlatform) {
                listArray[4].add((JetObject)object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getCusChgStyleActCanApplyTo(IReport iReport) {
        List[] listArray = new List[]{new Vector()};
        listArray[0].add((JetObject)((Object)iReport));
        return listArray;
    }

    protected List[] getCusSetPropActCanApplyTo(IReport iReport) {
        List[] listArray = new List[2];
        for (int i = 0; i < 2; ++i) {
            listArray[i] = new Vector();
        }
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JRObjectTemplate) {
                listArray[1].add((JetObject)object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getCusRotateActApplyTo(IReport iReport) {
        List[] listArray = new List[2];
        for (int i = 0; i < 2; ++i) {
            listArray[i] = new Vector();
        }
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptNewTable) {
                listArray[0].add((JetObject)object);
            } else if (object instanceof JetRptCTCrossTab) {
                listArray[1].add((JetObject)object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getChgChartTypeActApplyTo(IReport iReport) {
        List[] listArray = new List[]{new Vector()};
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptChartPlatform) {
                listArray[0].add((JetObject)object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    protected List[] getConvertToActApplyTo(IReport iReport) {
        List[] listArray = new List[3];
        for (int i = 0; i < 3; ++i) {
            listArray[i] = new Vector();
        }
        TreeIterater treeIterater = new TreeIterater(iReport.getIRptBody(), false);
        treeIterater.next();
        Object object = treeIterater.next();
        while (object != null) {
            if (object instanceof JetRptNewTable) {
                listArray[0].add((JetObject)object);
            } else if (object instanceof JetRptCTCrossTab) {
                listArray[1].add((JetObject)object);
            } else if (object instanceof JetRptChartPlatform) {
                listArray[2].add((JetObject)object);
            }
            object = treeIterater.next();
        }
        return listArray;
    }

    @Override
    public List getCanUsedColumnsOnApplyTo(JetUUniverse jetUUniverse, JetRptObject jetRptObject) {
        int n;
        if (jetUUniverse == null) {
            throw new IllegalArgumentException("Universe = null");
        }
        Vector<String> vector = new Vector<String>();
        IDataContainer iDataContainer = ReportTools.getDataContainer(jetRptObject, true);
        DataContainerInfo dataContainerInfo = DataContainerInfoFactory.newInstance().createDataContainerInfo(null, null, (JetObject)((Object)iDataContainer), true, true, false);
        DataSet dataSet = ReportTools.getDataSet(jetRptObject);
        if (dataSet == null) {
            return vector;
        }
        Vector vector2 = dataContainerInfo.getDbFields(true);
        List list = dataContainerInfo.getFmlNames(true);
        list = (List)ResourceTool.classfyFmlNames(jetUUniverse, new QueryInfoImpl(null, dataSet.getDataSourceName(), dataSet.getQueryName(), dataSet.getBlName(), 0), (Vector)list).get(new Integer(104));
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                vector.add((String)vector2.get(n));
            }
        }
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                vector.add((String)list.get(n));
            }
        }
        if (jetRptObject instanceof JetRptGroupPanel && !(jetRptObject instanceof JetRptReportPanel) && !(jetRptObject instanceof JetRptGMarker)) {
            Hashtable hashtable = this.addAtomicActionsToAction(jetUUniverse, (JetRptDataSet)dataSet);
            String[] stringArray = this.addBLColumnName((JetRptGroupPanel)jetRptObject, hashtable);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    private Hashtable addAtomicActionsToAction(JetUUniverse jetUUniverse, JetRptDataSet jetRptDataSet) {
        Hashtable<String, JetUSummary> hashtable = new Hashtable<String, JetUSummary>();
        if (jetRptDataSet == null) {
            return hashtable;
        }
        String string = jetRptDataSet.getDataSourceName();
        String string2 = jetRptDataSet.getQueryName();
        if (jetUUniverse == null) {
            return hashtable;
        }
        Vector vector = jetUUniverse.getAvailableResourceEntitys(string, string2);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetUSummary)) continue;
            hashtable.put(((JetUSummary)e).getResourceNameInUpperCase(), (JetUSummary)e);
        }
        return hashtable;
    }

    private String[] addBLColumnName(JetRptGroupPanel jetRptGroupPanel, Hashtable hashtable) {
        Vector vector = new Vector();
        for (Map.Entry entry : hashtable.entrySet()) {
            String string = ((JetUSummary)entry.getValue()).getGroupByFld().toUpperCase();
            if (string != null && string.trim().length() != 0 && !string.equals(jetRptGroupPanel.groupBy.get())) continue;
            vector.add(entry.getKey());
        }
        return vector.toArray(new String[0]);
    }

    @Override
    public List getCanUsedDynamicColumnsOnCrosstab(JetRptCTAggField jetRptCTAggField) {
        JetRptCTCrossTab jetRptCTCrossTab = jetRptCTAggField == null ? null : (JetRptCTCrossTab)jetRptCTAggField.getParent();
        Vector<String> vector = new Vector<String>();
        if (jetRptCTCrossTab == null) {
            return vector;
        }
        JetRptDataSet jetRptDataSet = jetRptCTCrossTab.getDataSet();
        if (jetRptDataSet == null) {
            return vector;
        }
        boolean bl = jetRptDataSet.getDataResourceType() == 0 || jetRptDataSet.getDataResourceType() == 3;
        int n = jetRptCTAggField.xdepth.intValue();
        int n2 = jetRptCTAggField.ydepth.intValue();
        Vector vector2 = jetRptCTCrossTab.getChildren();
        for (JetObject jetObject : vector2) {
            String string;
            if (!(jetObject instanceof JetRptCTHdDBField)) continue;
            JetRptCTHdDBField jetRptCTHdDBField = (JetRptCTHdDBField)jetObject;
            int n3 = jetRptCTHdDBField.depth.intValue();
            String string2 = string = bl ? jetRptCTHdDBField.columnName.get() : jetRptCTHdDBField.blColumnName.get();
            if (jetRptCTHdDBField.isXheader.booleanValue()) {
                if (n3 >= n || vector.contains(string)) continue;
                vector.add(string);
                continue;
            }
            if (n3 >= n2 || vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    @Override
    public RptAction getReceiveBuildInFitlerMessageDefaultAction() {
        AtomicParamRefArgExp atomicParamRefArgExp = this.createRefrenceArgExp("Column Name");
        AtomicParamRefArgExp atomicParamRefArgExp2 = this.createRefrenceArgExp("Operator");
        AtomicParamRefArgExp atomicParamRefArgExp3 = this.createRefrenceArgExp("Filter Value");
        CusDoFilterActionParam cusDoFilterActionParam = this.createCustomFilterActParam((AtomicParamArgExp)atomicParamRefArgExp, atomicParamRefArgExp2, (AtomicParamArgExp)atomicParamRefArgExp3, -1);
        AtomicParamConstArgExp atomicParamConstArgExp = this.createConstArgExp("Other in report...");
        CustomAtomicAction customAtomicAction = this.createCustomAction(1, "", atomicParamConstArgExp, 1, null, null, new CustomActionParam[]{cusDoFilterActionParam});
        customAtomicAction.setFunctionName("*Filter");
        return this.createAction(new CustomAtomicAction[]{customAtomicAction});
    }

    @Override
    public RptAction getReceiveBuildInSortMessageDefaultAction() {
        AtomicParamRefArgExp atomicParamRefArgExp = this.createRefrenceArgExp("Sort On");
        AtomicParamRefArgExp atomicParamRefArgExp2 = this.createRefrenceArgExp("Sort Order");
        CusDoSortActionParam cusDoSortActionParam = this.createCustomSortActParam(atomicParamRefArgExp, atomicParamRefArgExp2);
        AtomicParamConstArgExp atomicParamConstArgExp = this.createConstArgExp("Other in report...");
        CustomAtomicAction customAtomicAction = this.createCustomAction(2, "", atomicParamConstArgExp, 1, null, null, new CustomActionParam[]{cusDoSortActionParam});
        customAtomicAction.setFunctionName("*Sort");
        return this.createAction(new CustomAtomicAction[]{customAtomicAction});
    }

    @Override
    public RptAction getReceiveBuildInParameterMessageDefaultAction(int[] nArray) {
        AtomicParamRefArgExp atomicParamRefArgExp = null;
        AtomicParamRefArgExp atomicParamRefArgExp2 = null;
        if (nArray == null || nArray.length == 0 || nArray[0] == 0) {
            atomicParamRefArgExp = this.createRefrenceArgExp("Parameter Name*");
            atomicParamRefArgExp2 = this.createRefrenceArgExp("Parameter Value*");
        } else {
            atomicParamRefArgExp = this.createRefrenceArgExp("Parameter Name");
            atomicParamRefArgExp2 = this.createRefrenceArgExp("Parameter Value");
        }
        CusBatchSetParameterActionParam cusBatchSetParameterActionParam = this.createCustomSetParamActParam(atomicParamRefArgExp, atomicParamRefArgExp2);
        AtomicParamConstArgExp atomicParamConstArgExp = this.createConstArgExp("Other in report...");
        CustomAtomicAction customAtomicAction = this.createCustomAction(3, "", atomicParamConstArgExp, 1, null, null, new CustomActionParam[]{cusBatchSetParameterActionParam});
        customAtomicAction.setFunctionName("*Parameter");
        return this.createAction(new CustomAtomicAction[]{customAtomicAction});
    }

    @Override
    public void writeCusCustomizeControlAction(CusCustomizeCtrlAction cusCustomizeCtrlAction, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        Object object32;
        if (cusCustomizeCtrlAction == null || cusCustomizeCtrlAction.isReferencedAction() || !(cusCustomizeCtrlAction instanceof JetObject)) {
            throw new IllegalArgumentException("Please check agument, Possible reasons: null object, Lib-Refered Action, Not JReport object.");
        }
        CusCustomizeCtrlAction cusCustomizeCtrlAction2 = null;
        try {
            cusCustomizeCtrlAction2 = (CusCustomizeCtrlAction)cusCustomizeCtrlAction.getClass().newInstance();
        }
        catch (Throwable throwable) {
            cusCustomizeCtrlAction2 = null;
        }
        Vector<Object> vector = new Vector<Object>();
        for (Object object32 : ((JetObject)((Object)cusCustomizeCtrlAction)).getProperties().values()) {
            if (cusCustomizeCtrlAction2 != null) {
                if (((JetProperty)object32).isSetAnyChangeBy()) {
                    vector.add(object32);
                } else {
                    object2 = ((JetObject)((Object)cusCustomizeCtrlAction2)).nameToProperty(((JetProperty)object32).getName());
                    if (object2 != null) {
                        if (((JetProperty)object32).isCurrentAutoValue()) {
                            if (((JetProperty)object2).isCurrentAutoValue()) {
                                continue;
                            }
                        } else if (!((JetProperty)object2).isCurrentAutoValue()) {
                            object = ((JetProperty)object32).toUnitString();
                            String string = ((JetProperty)object2).toUnitString();
                            if (object == null ? string == null : ((String)object).equals(string)) continue;
                        }
                    }
                }
            }
            vector.add(object32);
        }
        object32 = new DataOutputStream(outputStream);
        ((DataOutputStream)object32).writeInt(-566227701);
        ((DataOutputStream)object32).writeInt(1);
        object2 = new GZIPOutputStream(outputStream);
        object32 = new DataOutputStream((OutputStream)object2);
        ((DataOutputStream)object32).writeInt(1);
        ((DataOutputStream)object32).writeInt(0);
        object = Calendar.getInstance();
        ((DataOutputStream)object32).writeUTF(((Calendar)object).getTimeZone().getID());
        ((DataOutputStream)object32).writeLong(((Calendar)object).getTime().getTime());
        ((DataOutputStream)object32).writeInt(0);
        ((DataOutputStream)object32).writeInt(0);
        ((DataOutputStream)object32).writeInt(1);
        int n = vector.size();
        ((DataOutputStream)object32).writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((DataOutputStream)object32).writeUTF(((JetProperty)vector.get(i)).getName());
        }
        ((DataOutputStream)object32).flush();
        ((DataOutputStream)object32).writeInt(1);
        ((DataOutputStream)object32).writeByte(224);
        String string = cusCustomizeCtrlAction.getClass().getName();
        byte[] byArray = string.getBytes("Unicode");
        ((DataOutputStream)object32).writeInt(byArray.length);
        ((FilterOutputStream)object32).write(byArray);
        string = ((JetObject)((Object)cusCustomizeCtrlAction)).getInstNameDirectly();
        if (string == null) {
            string = ((JetObject)((Object)cusCustomizeCtrlAction)).getInstancePrefix();
        }
        byArray = string.getBytes("Unicode");
        ((DataOutputStream)object32).writeInt(byArray.length);
        ((FilterOutputStream)object32).write(byArray);
        ((DataOutputStream)object32).writeByte(225);
        ((DataOutputStream)object32).writeInt(n);
        ((DataOutputStream)object32).flush();
        for (int i = 0; i < n; ++i) {
            JetProperty jetProperty = (JetProperty)vector.get(i);
            ((DataOutputStream)object32).writeInt(i);
            if (jetProperty.isSetAnyChangeBy()) {
                ((DataOutputStream)object32).writeByte(210);
                string = jetProperty.saveFullChangeBy();
                byArray = string.getBytes("Unicode");
                ((DataOutputStream)object32).writeInt(byArray.length);
                ((FilterOutputStream)object32).write(byArray);
            } else if (jetProperty.isCurrentAutoValue()) {
                ((DataOutputStream)object32).writeByte(208);
            } else {
                ((DataOutputStream)object32).writeByte(209);
                if (jetProperty instanceof JetBigString) {
                    ((DataOutputStream)object32).writeByte(207);
                    string = jetProperty.toUnitString();
                    ((DataOutputStream)object32).writeBoolean(string == null);
                    if (string != null) {
                        int n2 = string.length();
                        int n3 = n2 / 1240;
                        ((DataOutputStream)object32).writeInt(n3);
                        int n4 = 0;
                        for (int j = 0; j < n3; ++j) {
                            ((DataOutputStream)object32).writeUTF(string.substring(n4, n4 + 1240));
                            n4 += 1240;
                            ((DataOutputStream)object32).flush();
                        }
                        ((DataOutputStream)object32).writeUTF(string.substring(n4));
                    }
                } else {
                    ((DataOutputStream)object32).writeByte(192);
                    string = jetProperty.toUnitString();
                    ((DataOutputStream)object32).writeBoolean(string == null);
                    if (string != null) {
                        byArray = string.getBytes("Unicode");
                        ((DataOutputStream)object32).writeInt(byArray.length);
                        ((FilterOutputStream)object32).write(byArray);
                    }
                }
            }
            if (i % 10 != 0) continue;
            ((DataOutputStream)object32).flush();
        }
        ((DataOutputStream)object32).writeByte(226);
        ((DataOutputStream)object32).writeByte(239);
        ((DataOutputStream)object32).flush();
        ((GZIPOutputStream)object2).finish();
    }

    @Override
    public CusCustomizeCtrlAction readCusCustomizeControlAction(InputStream inputStream) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != -566227701) {
            throw new IllegalAccessException("What your inputted is not fit this API.");
        }
        n2 = dataInputStream.readInt();
        if (n2 != 1) {
            throw new IllegalAccessException("What your inputted is created by higher(or internal) Version. ");
        }
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        dataInputStream = new DataInputStream(gZIPInputStream);
        n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        dataInputStream.readUTF();
        dataInputStream.readLong();
        dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        if (n2 > 0) {
            dataInputStream.read(new byte[n2]);
        }
        if (n3 != 0) {
            throw new UnsupportedOperationException("What your inputted is created by higher Version.");
        }
        n2 = dataInputStream.readInt();
        if (n2 > 1) {
            throw new UnsupportedOperationException("What your inputted is created by higher Version");
        }
        n2 = dataInputStream.readInt();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>(n2);
        for (n = 0; n < n2; ++n) {
            hashtable.put(n, dataInputStream.readUTF());
        }
        n2 = dataInputStream.readInt();
        if (n2 != 1) {
            throw new UnsupportedOperationException("What your inputted is created by higher Version");
        }
        n = dataInputStream.readByte();
        n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.read(byArray);
        String string = new String(byArray, "Unicode");
        CusCustomizeCtrlAction cusCustomizeCtrlAction = (CusCustomizeCtrlAction)Class.forName(string).newInstance();
        n2 = dataInputStream.readInt();
        byArray = new byte[n2];
        dataInputStream.read(byArray);
        string = new String(byArray, "Unicode");
        ((JetObject)((Object)cusCustomizeCtrlAction)).setInstNameDirectly(string);
        n = dataInputStream.readByte();
        do {
            if (n == -31) {
                n2 = dataInputStream.readInt();
                for (int i = 0; i < n2; ++i) {
                    int n4;
                    int n5;
                    int n6 = dataInputStream.readInt();
                    JetProperty jetProperty = ((JetObject)((Object)cusCustomizeCtrlAction)).nameToProperty((String)hashtable.get(n6));
                    n = dataInputStream.readByte();
                    if (n == -46) {
                        n5 = dataInputStream.readInt();
                        byArray = new byte[n5];
                        dataInputStream.read(byArray);
                        string = new String(byArray, "Unicode");
                        if (jetProperty == null) continue;
                        jetProperty.loadFullChangeBy(string);
                        continue;
                    }
                    if (n == -48) {
                        if (jetProperty == null || !jetProperty.isEnableAutoValue()) continue;
                        jetProperty.setAsAutoValue(true);
                        continue;
                    }
                    n = dataInputStream.readByte();
                    if (n == -64) {
                        n5 = dataInputStream.readBoolean() ? 1 : 0;
                        if (n5 != 0) {
                            if (jetProperty == null) continue;
                            jetProperty.setUnitValue(null);
                            continue;
                        }
                        n4 = dataInputStream.readInt();
                        byArray = new byte[n4];
                        dataInputStream.read(byArray);
                        string = new String(byArray, "Unicode");
                        if (jetProperty == null) continue;
                        jetProperty.setUnitValue(string);
                        continue;
                    }
                    if (n == -49) {
                        n5 = dataInputStream.readBoolean() ? 1 : 0;
                        if (n5 != 0) {
                            if (jetProperty == null) continue;
                            jetProperty.setUnitValue(null);
                            continue;
                        }
                        n4 = dataInputStream.readInt();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int j = 0; j < n4; ++j) {
                            stringBuilder.append(dataInputStream.readUTF());
                        }
                        stringBuilder.append(dataInputStream.readUTF());
                        string = stringBuilder.toString();
                        if (jetProperty == null) continue;
                        jetProperty.setUnitValue(string);
                        continue;
                    }
                    throw new UnsupportedOperationException("What your inputted is created by higher Version");
                }
            } else {
                throw new UnsupportedOperationException("What your inputted is created by higher Version");
            }
            n = dataInputStream.readByte();
        } while ((n = (int)dataInputStream.readByte()) != -17);
        ((JetObject)((Object)cusCustomizeCtrlAction)).nameToProperty(PropertyNames.getDefinitionName(PropertyNames.refName)).set("");
        return cusCustomizeCtrlAction;
    }

    @Override
    public void collectActionDirectUsedSelfResource(RptAction rptAction, QueryInfo queryInfo, Map map) {
        RptAtomicAction[] rptAtomicActionArray;
        if (rptAction == null) {
            return;
        }
        ObjectResourceInfo objectResourceInfo = (ObjectResourceInfo)map.get(queryInfo);
        if (objectResourceInfo == null) {
            objectResourceInfo = new ObjectResourceInfo();
            map.put(queryInfo, objectResourceInfo);
        }
        for (RptAtomicAction rptAtomicAction : rptAtomicActionArray = rptAction.expandAndGetAllAtomicAction()) {
            int n;
            if (rptAtomicAction == null) continue;
            List list = rptAtomicAction.getAtomicParams();
            int n2 = n = list == null ? 0 : list.size();
            if (n == 0 || rptAtomicAction.getAtomicType() == 1) continue;
            for (int i = 0; i < n; ++i) {
                QueryInfo queryInfo2;
                Object object;
                AtomicParamArgExp atomicParamArgExp;
                CustomActionParam customActionParam = (CustomActionParam)list.get(i);
                int n3 = ((CustomAtomicAction)rptAtomicAction).getCustomizeActionType();
                if (n3 == 3) {
                    if (((CustomAtomicAction)rptAtomicAction).getApplyToType() != 1 || (atomicParamArgExp = customActionParam.getName()).getArgumentExpType() != 65541) continue;
                    object = (String)((AtomicParamValueArgExp)atomicParamArgExp).getValue();
                    objectResourceInfo.addMappingName((String)object);
                    continue;
                }
                if (n3 != 1 && n3 != 2 || (atomicParamArgExp = ((CustomAtomicAction)rptAtomicAction).getApplyTo()).getArgumentExpType() != 65539 || (object = (JetRptObject)((AtomicParamValueArgExp)atomicParamArgExp).getValue()) == null) continue;
                IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getBindDataContainer((JetObject)object);
                DataSet dataSet = iDataContainer == null ? null : ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
                QueryInfo queryInfo3 = queryInfo2 = dataSet != null ? dataSet.getQueryInfo() : null;
                if (queryInfo2 == null || (atomicParamArgExp = customActionParam.getName()).getArgumentExpType() != 65541) continue;
                String string = (String)((AtomicParamValueArgExp)atomicParamArgExp).getValue();
                ObjectResourceInfo objectResourceInfo2 = (ObjectResourceInfo)map.get(queryInfo2);
                if (objectResourceInfo2 == null) {
                    objectResourceInfo2 = new ObjectResourceInfo();
                    map.put(queryInfo2, objectResourceInfo2);
                }
                if (queryInfo2.getDataResoureType() == 2) {
                    objectResourceInfo2.addBLColumnName(string);
                    continue;
                }
                objectResourceInfo2.addMappingName(string);
            }
        }
    }
}

