/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.controls.JetVector;
import jet.report.JRObjectTemplate;
import jet.report.JetRptForm;
import jet.report.JetRptObject;
import jet.report.mode.JetRptMode;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.FormLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;

class FormLogicImpl
implements FormLogic {
    FormLogicImpl() {
    }

    @Override
    public JetRptForm createForm() {
        JetRptForm jetRptForm = new JetRptForm();
        jetRptForm.setEditable();
        return jetRptForm;
    }

    @Override
    public void addObjectsToForm(JetRptForm jetRptForm, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addObjectToForm(jetRptForm, (JetRptObject)vector.elementAt(i));
        }
    }

    @Override
    public void addObjectToForm(JetRptForm jetRptForm, JetRptObject jetRptObject) {
        Object object;
        if (this.canAddToForm(jetRptObject)) {
            JetVector jetVector;
            object = null;
            if (this.SEDU(jetRptForm, jetRptObject) && (jetVector = jetRptForm.formComps).get().indexOf(jetRptObject.getInstName()) == -1) {
                object = this.getObjectBelongFrom(jetRptObject);
                if (object != null) {
                    this.deleteObjectFromForm((JetRptForm)object, jetRptObject);
                }
                jetVector.add(jetRptObject.getInstName());
            }
        }
        if ((object = jetRptObject.getChildren()) != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.addObjectsToForm(jetRptForm, (Vector)object);
            }
        }
    }

    @Override
    public void deleteObjectsFromForm(JetRptForm jetRptForm, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.deleteObjectFromForm(jetRptForm, (JetRptObject)vector.elementAt(i));
        }
    }

    @Override
    public void deleteObjectFromForm(JetRptForm jetRptForm, JetRptObject jetRptObject) {
        jetRptForm.formComps.get().remove(jetRptObject.getInstName());
    }

    @Override
    public JetRptForm getObjectBelongFrom(JetRptObject jetRptObject) {
        Vector<JetRptObject> vector = new Vector<JetRptObject>();
        vector.add(jetRptObject);
        Vector vector2 = this.getLegalityFromContainer(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            JetRptForm jetRptForm = (JetRptForm)vector2.elementAt(i);
            Vector vector3 = jetRptForm.formComps.get();
            if (vector3.indexOf(jetRptObject.getInstName()) == -1) continue;
            return jetRptForm;
        }
        return null;
    }

    @Override
    public Vector getFromContainObjects(JetRptForm jetRptForm) {
        Vector<JetObject> vector = new Vector<JetObject>();
        JetRptObject jetRptObject = (JetRptObject)JetObject.getRoot(jetRptForm);
        if (jetRptObject instanceof JetRootable) {
            Vector vector2 = jetRptForm.formComps.get();
            JetObject jetObject = null;
            for (int i = 0; i < vector2.size(); ++i) {
                jetObject = jetRptObject.nameToObject((String)vector2.elementAt(i));
                if (jetObject == null) continue;
                vector.add(jetObject);
            }
        }
        return vector;
    }

    @Override
    public Vector getLegalityFromContainer(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return new Vector(0);
        }
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        JetObject jetObject = (JetObject)((Object)basicComponentLogic.getIReportOf((JetRptObject)vector.get(0)));
        if (jetObject == null) {
            return new Vector(0);
        }
        return basicComponentLogic.getObjectsOnDeepTravelTree(jetObject, JetRptForm.class, vector);
    }

    private boolean SEDU(JetRptForm jetRptForm, JetRptObject jetRptObject) {
        JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptForm.getParent());
        if (jetRptObject2 == null) {
            return false;
        }
        JetObject jetObject = JetObject.getRoot(jetRptForm);
        if (!(jetObject instanceof JetRootable)) {
            return false;
        }
        if (JetObject.getRoot(jetRptObject) != jetObject) {
            return false;
        }
        Vector<JetRptObject> vector = new Vector<JetRptObject>();
        vector.add(jetRptObject);
        Vector vector2 = this.getLegalityFromContainer(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector2.elementAt(i) != jetRptForm) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector getFormNodes(JetRptObject jetRptObject) {
        Vector vector = new Vector();
        Vector vector2 = jetRptObject.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            if (!(vector2.elementAt(i) instanceof JetRptForm)) continue;
            vector.add(vector2.elementAt(i));
        }
        return vector;
    }

    @Override
    public boolean canAddToForm(JetRptObject jetRptObject) {
        JetRptMode jetRptMode;
        return jetRptObject instanceof JRObjectTemplate && (jetRptMode = ((JRObjectTemplate)jetRptObject).getJetRptMode()) != null;
    }
}

