/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import com.jinfonet.util.JRLog;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.ireport.IRptBody;
import jet.ireport.osf.OnScreenFilter;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptPagePanel;
import jet.report.JetRptSectionObject;
import jet.report.chart.JetRptChartPlatform;
import jet.report.geomap.JetRptGeoMap;
import jet.report.gmap.JetRptGMap;
import jet.report.table.JetRptNewTable;
import jet.report.vct.JetRptVCTFilter;
import jet.report.vct.JetRptVCTFilters;
import jet.report.vct.JetRptVCTObject;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnScreenFilterLogic;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.universe.JetUUniverse;
import jet.util.QueryKeyInfo;
import jet.util.QueryKeyInfoComparator;

class OnScreenFilterLogicImpl
implements OnScreenFilterLogic {
    private QueryKeyInfoComparator SEDU = new QueryKeyInfoComparator(){

        @Override
        public boolean isCatalogInfoEquals(QueryKeyInfo.CatalogInfo catalogInfo, QueryKeyInfo.CatalogInfo catalogInfo2) {
            if (catalogInfo == null) {
                return catalogInfo2 == null;
            }
            if (catalogInfo2 != null) {
                return catalogInfo.getCatalog() == catalogInfo2.getCatalog();
            }
            return false;
        }

        public String toString() {
            return "DEFAULT_SQ_COMPARATOR";
        }
    };

    OnScreenFilterLogicImpl() {
    }

    private QueryInfo SEDU(OnScreenFilter.OSFEntry oSFEntry) {
        QueryInfo queryInfo = null;
        int n = oSFEntry.getFieldsCount();
        for (int i = 0; i < n; ++i) {
            QueryInfo queryInfo2 = oSFEntry.getFieldAt(i).getQueryInfo();
            if (queryInfo2 == null) continue;
            queryInfo = queryInfo2;
            break;
        }
        return queryInfo;
    }

    @Override
    public List getOnScreenFilterCanApplyTo(JetUUniverse jetUUniverse, OnScreenFilter onScreenFilter, IReport iReport) {
        DefaultOSFRTQKeyCatalogInfo defaultOSFRTQKeyCatalogInfo = new DefaultOSFRTQKeyCatalogInfo(jetUUniverse);
        return this.getOnScreenFilterCanApplyTo(defaultOSFRTQKeyCatalogInfo, onScreenFilter, iReport, defaultOSFRTQKeyCatalogInfo, this.SEDU);
    }

    private List add(QueryKeyInfo.CatalogInfo catalogInfo, List list) {
        Vector<DefaultOSFRTQueryKeyImpl> vector = new Vector<DefaultOSFRTQueryKeyImpl>(list.size());
        HashSet<QueryInfo> hashSet = new HashSet<QueryInfo>();
        for (OnScreenFilter.OSFEntry object : list) {
            QueryInfo queryInfo = this.SEDU(object);
            hashSet.add(queryInfo);
        }
        for (QueryInfo queryInfo : hashSet) {
            vector.add(new DefaultOSFRTQueryKeyImpl(catalogInfo, queryInfo));
        }
        hashSet.clear();
        hashSet = null;
        return vector;
    }

    @Override
    public List getOnScreenFilterCanApplyTo(QueryKeyInfo.CatalogInfo catalogInfo, OnScreenFilter onScreenFilter, IReport iReport, QueryKeyInfo.CatalogInfo catalogInfo2, QueryKeyInfoComparator queryKeyInfoComparator) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getOnScreenFilterCanApplyTo(" + catalogInfo + "," + onScreenFilter + "," + iReport + "," + catalogInfo2 + "," + queryKeyInfoComparator);
        }
        if (onScreenFilter instanceof JetRptVCTFilter) {
            JetRptVCTFilter jetRptVCTFilter = (JetRptVCTFilter)onScreenFilter;
            JetRptVCTFilters jetRptVCTFilters = jetRptVCTFilter.getParent();
            JetRptVCTObject jetRptVCTObject = jetRptVCTFilters == null ? null : jetRptVCTFilters.getParent();
            Vector<JetRptVCTObject> vector = new Vector<JetRptVCTObject>();
            if (jetRptVCTObject != null) {
                vector.add(jetRptVCTObject);
            }
            return vector;
        }
        List list = this.add(catalogInfo, onScreenFilter.getFilterEntries());
        return this.append(list, iReport, catalogInfo2, queryKeyInfoComparator);
    }

    private List append(List list, IReport iReport, QueryKeyInfo.CatalogInfo catalogInfo, QueryKeyInfoComparator queryKeyInfoComparator) {
        Object object;
        Vector vector = new Vector();
        IRptBody iRptBody = iReport.getIRptBody();
        Hashtable<DataSet, Boolean> hashtable = new Hashtable<DataSet, Boolean>();
        boolean bl = false;
        DataSet dataSet = iRptBody.getBindedDataSet();
        if (dataSet != null) {
            object = new DefaultOSFRTQueryKeyImpl(catalogInfo, dataSet.getQueryInfo());
            bl = this.get(list, (QueryKeyInfo)object, queryKeyInfoComparator);
            hashtable.put(dataSet, bl);
        }
        this.booleanValue(iRptBody, catalogInfo, vector, list, queryKeyInfoComparator, bl, hashtable);
        if (iReport instanceof JetRptReport) {
            object = ObjectLogicFactory.getPageLogic().getPagePanels((JetRptReport)iReport);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                JetRptPagePanel jetRptPagePanel = (JetRptPagePanel)iterator.next();
                this.booleanValue(jetRptPagePanel, catalogInfo, vector, list, queryKeyInfoComparator, bl, hashtable);
            }
        }
        hashtable.clear();
        hashtable = null;
        return vector;
    }

    private void booleanValue(JetContainable jetContainable, QueryKeyInfo.CatalogInfo catalogInfo, List list, List list2, QueryKeyInfoComparator queryKeyInfoComparator, boolean bl, Hashtable hashtable) {
        for (JetObject jetObject : jetContainable.getChildren()) {
            if (!(jetObject instanceof JetContainable)) continue;
            if (jetObject instanceof IDataContainer) {
                IDataContainer iDataContainer = (IDataContainer)((Object)jetObject);
                boolean bl2 = this.clear(iDataContainer, bl, catalogInfo, list2, queryKeyInfoComparator, hashtable);
                if (bl2) {
                    if (OnScreenFilterLogicImpl.getApplyToInstNames(iDataContainer)) {
                        list.add(iDataContainer);
                        if (!(jetObject instanceof JetRptSectionObject) && !(jetObject instanceof JetRptNewTable)) continue;
                        this.booleanValue(iDataContainer, catalogInfo, list, list2, queryKeyInfoComparator, true, hashtable);
                        continue;
                    }
                    this.booleanValue(iDataContainer, catalogInfo, list, list2, queryKeyInfoComparator, true, hashtable);
                    continue;
                }
                this.booleanValue(iDataContainer, catalogInfo, list, list2, queryKeyInfoComparator, false, hashtable);
                continue;
            }
            this.booleanValue((JetContainable)((Object)jetObject), catalogInfo, list, list2, queryKeyInfoComparator, bl, hashtable);
        }
    }

    private boolean clear(IDataContainer iDataContainer, boolean bl, QueryKeyInfo.CatalogInfo catalogInfo, List list, QueryKeyInfoComparator queryKeyInfoComparator, Map map) {
        boolean bl2 = iDataContainer.isInheritDataSet();
        boolean bl3 = false;
        if (!bl2) {
            DataSet dataSet = iDataContainer.getBindedDataSet();
            if (dataSet != null) {
                Boolean bl4 = (Boolean)map.get(dataSet);
                if (bl4 == null) {
                    DefaultOSFRTQueryKeyImpl defaultOSFRTQueryKeyImpl = new DefaultOSFRTQueryKeyImpl(catalogInfo, dataSet.getQueryInfo());
                    bl3 = this.get(list, defaultOSFRTQueryKeyImpl, queryKeyInfoComparator);
                    map.put(dataSet, bl3);
                } else {
                    bl3 = bl4;
                }
            }
        } else {
            bl3 = bl;
        }
        return bl3;
    }

    private boolean get(List list, QueryKeyInfo queryKeyInfo, QueryKeyInfoComparator queryKeyInfoComparator) {
        QueryKeyInfo queryKeyInfo2;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !(bl = queryKeyInfoComparator.isEquals(queryKeyInfo2 = (QueryKeyInfo)iterator.next(), queryKeyInfo))) {
        }
        return bl;
    }

    private static boolean getApplyToInstNames(IDataContainer iDataContainer) {
        return iDataContainer instanceof JetRptSectionObject || iDataContainer instanceof JetRptNewTable || iDataContainer instanceof JetRptChartPlatform || iDataContainer instanceof JetRptCTCrossTab || iDataContainer instanceof JetRptGMap || iDataContainer instanceof JetRptGeoMap || iDataContainer instanceof JetRptVCTObject;
    }

    @Override
    public List getOSFEntryCanApplyTo(JetUUniverse jetUUniverse, OnScreenFilter.OSFEntry oSFEntry, IReport iReport) {
        DefaultOSFRTQKeyCatalogInfo defaultOSFRTQKeyCatalogInfo = new DefaultOSFRTQKeyCatalogInfo(jetUUniverse);
        QueryInfo queryInfo = this.SEDU(oSFEntry);
        return this.getSameQueryDataContainerForOSF(defaultOSFRTQKeyCatalogInfo, queryInfo, iReport, defaultOSFRTQKeyCatalogInfo, this.SEDU);
    }

    @Override
    public List getOSFEntryCanApplyTo(QueryKeyInfo.CatalogInfo catalogInfo, OnScreenFilter.OSFEntry oSFEntry, IReport iReport, QueryKeyInfo.CatalogInfo catalogInfo2, QueryKeyInfoComparator queryKeyInfoComparator) {
        QueryInfo queryInfo = this.SEDU(oSFEntry);
        return this.getSameQueryDataContainerForOSF(catalogInfo, queryInfo, iReport, catalogInfo2, queryKeyInfoComparator);
    }

    @Override
    public List getSameQueryDataContainerForOSF(JetUUniverse jetUUniverse, QueryInfo queryInfo, IReport iReport) {
        DefaultOSFRTQKeyCatalogInfo defaultOSFRTQKeyCatalogInfo = new DefaultOSFRTQKeyCatalogInfo(jetUUniverse);
        return this.getSameQueryDataContainerForOSF(defaultOSFRTQKeyCatalogInfo, queryInfo, iReport, defaultOSFRTQKeyCatalogInfo, this.SEDU);
    }

    @Override
    public List getSameQueryDataContainerForOSF(QueryKeyInfo.CatalogInfo catalogInfo, QueryInfo queryInfo, IReport iReport, QueryKeyInfo.CatalogInfo catalogInfo2, QueryKeyInfoComparator queryKeyInfoComparator) {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getSameQueryDataContainerForOSF(" + catalogInfo + "," + queryInfo + "," + iReport + "," + catalogInfo2 + "," + queryKeyInfoComparator);
        }
        Vector vector = new Vector();
        if (queryInfo == null) {
            return new Vector();
        }
        Vector<DefaultOSFRTQueryKeyImpl> vector2 = new Vector<DefaultOSFRTQueryKeyImpl>();
        vector2.add(new DefaultOSFRTQueryKeyImpl(catalogInfo, queryInfo));
        IRptBody iRptBody = iReport.getIRptBody();
        Hashtable<DataSet, Boolean> hashtable = new Hashtable<DataSet, Boolean>();
        boolean bl = false;
        DataSet dataSet = iRptBody.getBindedDataSet();
        if (dataSet != null) {
            object = new DefaultOSFRTQueryKeyImpl(catalogInfo2, dataSet.getQueryInfo());
            bl = this.get(vector2, (QueryKeyInfo)object, queryKeyInfoComparator);
            hashtable.put(dataSet, bl);
        }
        this.booleanValue(iRptBody, catalogInfo2, vector, vector2, queryKeyInfoComparator, bl, hashtable);
        if (iReport instanceof JetRptReport) {
            object = ObjectLogicFactory.getPageLogic().getPagePanels((JetRptReport)iReport);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                JetRptPagePanel jetRptPagePanel = (JetRptPagePanel)iterator.next();
                this.booleanValue(jetRptPagePanel, catalogInfo2, vector, vector2, queryKeyInfoComparator, bl, hashtable);
            }
        }
        hashtable.clear();
        hashtable = null;
        return vector;
    }

    @Override
    public List getOnScreenFilterAppliedTo(JetUUniverse jetUUniverse, OnScreenFilter onScreenFilter, IReport iReport, boolean bl) {
        DefaultOSFRTQKeyCatalogInfo defaultOSFRTQKeyCatalogInfo = new DefaultOSFRTQKeyCatalogInfo(jetUUniverse);
        return this.getOnScreenFilterAppliedTo(defaultOSFRTQKeyCatalogInfo, onScreenFilter, "~@IDCURRENT@~", iReport, defaultOSFRTQKeyCatalogInfo, bl, this.SEDU);
    }

    @Override
    public List getOnScreenFilterAppliedTo(QueryKeyInfo.CatalogInfo catalogInfo, OnScreenFilter onScreenFilter, String string, IReport iReport, QueryKeyInfo.CatalogInfo catalogInfo2, boolean bl, QueryKeyInfoComparator queryKeyInfoComparator) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getOnScreenFilterAppliedTo(" + catalogInfo + "," + onScreenFilter + "," + string + "," + iReport + "," + catalogInfo2 + "," + queryKeyInfoComparator);
        }
        if (onScreenFilter.isApplyToAllDataContainer(string)) {
            return this.getOnScreenFilterCanApplyTo(catalogInfo, onScreenFilter, iReport, catalogInfo2, queryKeyInfoComparator);
        }
        if (onScreenFilter instanceof JetRptVCTFilter) {
            JetRptVCTFilter jetRptVCTFilter = (JetRptVCTFilter)onScreenFilter;
            JetRptVCTFilters jetRptVCTFilters = jetRptVCTFilter.getParent();
            JetRptVCTObject jetRptVCTObject = jetRptVCTFilters == null ? null : jetRptVCTFilters.getParent();
            Vector<JetRptVCTObject> vector = new Vector<JetRptVCTObject>();
            if (jetRptVCTObject != null) {
                vector.add(jetRptVCTObject);
            }
            return vector;
        }
        List list = onScreenFilter.getApplyToInstNames(string);
        Object object5 = new Vector<IDataContainer>();
        for (Object object42 : list) {
            object3 = iReport.nameToObject((String)object42);
            if (object3 == null || !(object3 instanceof IDataContainer) || !OnScreenFilterLogicImpl.getApplyToInstNames((IDataContainer)object3)) continue;
            object5.add((IDataContainer)object3);
        }
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        object42 = new Vector(object5.size());
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object2 = (IDataContainer)object3.next();
            object = basicComponentLogic.getIReportOf((JetObject)object2);
            if (object != iReport) continue;
            object42.add(object2);
        }
        object5.clear();
        object5 = null;
        if (bl) {
            object3 = this.add(catalogInfo, onScreenFilter.getFilterEntries());
            object2 = new Hashtable();
            object5 = object42;
            object42 = new Vector<IDataContainer>(object5.size());
            object = object5.iterator();
            while (object.hasNext()) {
                IDataContainer iDataContainer = (IDataContainer)object.next();
                DataSet dataSet = null;
                dataSet = iDataContainer.isInheritDataSet() ? ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer) : iDataContainer.getBindedDataSet();
                boolean bl2 = false;
                if (dataSet != null) {
                    Boolean bl3 = (Boolean)((Hashtable)object2).get(dataSet);
                    if (bl3 == null) {
                        DefaultOSFRTQueryKeyImpl defaultOSFRTQueryKeyImpl = new DefaultOSFRTQueryKeyImpl(catalogInfo2, dataSet.getQueryInfo());
                        bl2 = this.get((List)object3, defaultOSFRTQueryKeyImpl, this.SEDU);
                        ((Hashtable)object2).put(dataSet, bl2);
                    } else {
                        bl2 = bl3;
                    }
                }
                if (!bl2) continue;
                object42.add(iDataContainer);
            }
            object3.clear();
            object3 = null;
            ((Hashtable)object2).clear();
            object2 = null;
            return object42;
        }
        return object42;
    }

    @Override
    public List getOnScreenFilterEntriesInSameQuery(JetUUniverse jetUUniverse, OnScreenFilter onScreenFilter, QueryInfo queryInfo) {
        DefaultOSFRTQKeyCatalogInfo defaultOSFRTQKeyCatalogInfo = new DefaultOSFRTQKeyCatalogInfo(jetUUniverse);
        return this.getBasicComponentLogic(defaultOSFRTQKeyCatalogInfo, onScreenFilter, defaultOSFRTQKeyCatalogInfo, queryInfo, this.SEDU);
    }

    private List getBasicComponentLogic(QueryKeyInfo.CatalogInfo catalogInfo, OnScreenFilter onScreenFilter, QueryKeyInfo.CatalogInfo catalogInfo2, QueryInfo queryInfo, QueryKeyInfoComparator queryKeyInfoComparator) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getOnScreenFilterAppliedTo(" + catalogInfo + "," + onScreenFilter + "," + catalogInfo2 + "," + queryInfo + "," + queryKeyInfoComparator);
        }
        if (queryInfo == null) {
            return new Vector();
        }
        DefaultOSFRTQueryKeyImpl defaultOSFRTQueryKeyImpl = new DefaultOSFRTQueryKeyImpl(catalogInfo2, queryInfo);
        return this.getBindedDataSet(catalogInfo, onScreenFilter, defaultOSFRTQueryKeyImpl, queryKeyInfoComparator);
    }

    private List getBindedDataSet(QueryKeyInfo.CatalogInfo catalogInfo, OnScreenFilter onScreenFilter, QueryKeyInfo queryKeyInfo, QueryKeyInfoComparator queryKeyInfoComparator) {
        Vector<OnScreenFilter.OSFEntry> vector = new Vector<OnScreenFilter.OSFEntry>();
        if (queryKeyInfo == null) {
            return vector;
        }
        List list = onScreenFilter.getFilterEntries();
        for (OnScreenFilter.OSFEntry oSFEntry : list) {
            DefaultOSFRTQueryKeyImpl defaultOSFRTQueryKeyImpl;
            QueryInfo queryInfo = this.SEDU(oSFEntry);
            if (queryInfo == null || !queryKeyInfoComparator.isEquals(queryKeyInfo, defaultOSFRTQueryKeyImpl = new DefaultOSFRTQueryKeyImpl(catalogInfo, queryInfo))) continue;
            vector.add(oSFEntry);
        }
        return vector;
    }

    private class DefaultOSFRTQueryKeyImpl
    implements QueryKeyInfo {
        private final QueryKeyInfo.CatalogInfo SEDU;
        private final QueryInfo getBLName;

        DefaultOSFRTQueryKeyImpl(QueryKeyInfo.CatalogInfo catalogInfo, QueryInfo queryInfo) {
            this.SEDU = catalogInfo;
            this.getBLName = queryInfo;
        }

        @Override
        public QueryKeyInfo.CatalogInfo getCatalogInfo() {
            return this.SEDU;
        }

        @Override
        public String getDataSourceName() {
            return this.getBLName.getDatasourceName();
        }

        @Override
        public String getQueryName() {
            return this.getBLName.getQueryName();
        }

        @Override
        public String getBVName() {
            return this.getBLName.getBLName();
        }

        @Override
        public int getDataResourceType() {
            return this.getBLName.getDataResoureType();
        }
    }

    private class DefaultOSFRTQKeyCatalogInfo
    implements QueryKeyInfo.CatalogInfo {
        private final JetUUniverse SEDU;

        public DefaultOSFRTQKeyCatalogInfo(JetUUniverse jetUUniverse) {
            this.SEDU = jetUUniverse;
        }

        @Override
        public JetUUniverse getCatalog() {
            return this.SEDU;
        }

        public String toString() {
            return String.valueOf(this.SEDU);
        }
    }
}

