/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import com.jinfonet.util.JRLog;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetChangeBy;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetReferences;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBox;
import jet.report.JetRptDBField;
import jet.report.JetRptField;
import jet.report.JetRptObject;
import jet.report.JetRptParameterField;
import jet.report.JetRptPicture;
import jet.report.JetRptRefParameterField;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.report.JetRptTitleTextField;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParaStyleElement;
import jet.report.paragraph.build.JetRptParaTextSegment;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.paragraph.build.ParaNodeListImpl;
import jet.report.paragraph.build.ParaStyle;
import jet.report.paragraph.build.ParaStyleValue;
import jet.report.paragraph.com.NStyle;
import jet.report.paragraph.com.NStyleValue;
import jet.report.paragraph.com.ParaNode;
import jet.report.paragraph.com.ParaNodeList;
import jet.report.paragraph.com.ParaReplaceNode;
import jet.report.paragraph.com.ParaRootNode;
import jet.report.paragraph.com.ParaStyleNode;
import jet.report.paragraph.com.ParaTextNode;
import jet.report.paragraph.com.ParaTrunkNode;
import jet.reportLogic.objectInfo.DisplayFieldInfo;
import jet.reportLogic.objectInfo.PictureInfo;
import jet.reportLogic.objectInfo.paragraph.ElementInfo;
import jet.reportLogic.objectInfo.paragraph.ParagraphObjInfo;
import jet.reportLogic.objectInfo.paragraph.ReplaceInfo;
import jet.reportLogic.objectInfo.paragraph.TextInfo;
import jet.reportLogic.objectLogic.DataContainerLogicImpl;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ParagraphLogic;
import jet.reportLogic.objectLogic.paragraphLogic.ReplaceElement;
import jet.reportset.JetRptDataSet;
import jet.universe.JetUUniverse;
import jet.util.TreeIterater;

class ParagraphLogicImpl
extends DataContainerLogicImpl
implements ParagraphLogic {
    static final HashSet forbid_inline_prop = new HashSet(6);
    static final HashSet forbid_static_prop = new HashSet(2);
    static final HashSet forbid_border_prop = new HashSet(8);
    static final HashSet forbid_padding_prop = new HashSet(8);

    ParagraphLogicImpl() {
    }

    protected ParaStyleNode createStyleElement(NStyle nStyle) {
        JetRptParaStyleElement jetRptParaStyleElement = new JetRptParaStyleElement(nStyle);
        jetRptParaStyleElement.setEditable();
        return jetRptParaStyleElement;
    }

    protected ParaTextNode createTextSegment(String string) {
        JetRptParaTextSegment jetRptParaTextSegment = new JetRptParaTextSegment(string);
        jetRptParaTextSegment.setEditable();
        return jetRptParaTextSegment;
    }

    @Override
    public JetRptParaReplaceElement createReplaceElement(JetRptObject jetRptObject) {
        JetRptParaReplaceElement jetRptParaReplaceElement = new JetRptParaReplaceElement();
        jetRptParaReplaceElement.setEditable();
        if (!(jetRptObject instanceof JRObjectTemplate)) {
            throw new IllegalAccessError("Not JRObjectTemplate");
        }
        JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)jetRptObject;
        jRObjectTemplate.display.set("inline");
        jRObjectTemplate.display.setEditFlag(0);
        this.basicComponentLogic.add(jetRptParaReplaceElement, jetRptObject);
        return jetRptParaReplaceElement;
    }

    @Override
    public JetRptParagraph createParagraphObject() {
        JetRptParagraph jetRptParagraph = new JetRptParagraph();
        jetRptParagraph.setEditable();
        return jetRptParagraph;
    }

    @Override
    public JetRptParagraph createParagraphObject(Map map) {
        JetRptParagraph jetRptParagraph = new JetRptParagraph();
        jetRptParagraph.setEditable();
        LinkedList linkedList = new LinkedList();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof String) || !jetRptParagraph.isStyleProperty((String)entry.getKey())) continue;
            linkedList.add(entry);
        }
        for (Map.Entry entry : linkedList) {
            JetProperty jetProperty = jetRptParagraph.nameToProperty((String)entry.getKey());
            jetProperty.setUnitValue((String)entry.getValue());
        }
        return jetRptParagraph;
    }

    @Override
    public JetRptParagraph removeParagraph(JetRptObject jetRptObject) {
        JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptObject.getParent());
        if (jetRptObject2 instanceof JetRptParagraph) {
            this.basicComponentLogic.remove(jetRptObject2);
            return (JetRptParagraph)jetRptObject2;
        }
        return null;
    }

    @Override
    public Hashtable getStylesByPosition(JetRptParagraph jetRptParagraph, int n) {
        Hashtable hashtable = new Hashtable();
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        if (this.initParagraphLogic(jetRptParagraph, paraNodeListImpl) != null) {
            boolean bl = false;
            int n2 = 0;
            ParaNode paraNode = null;
            for (int i = 0; i < paraNodeListImpl.size(); ++i) {
                int n3;
                paraNode = paraNodeListImpl.item(i);
                if (paraNode.isIncludePosition(false, n3 = n - n2)) {
                    n2 += n3;
                    bl = true;
                    break;
                }
                n2 += paraNode.length();
            }
            if (bl && paraNode.getNodeType() == 257) {
                hashtable = ((ParaTextNode)paraNode).getNodeStyles();
            }
        }
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        return hashtable;
    }

    @Override
    public int getParagraphSize(JetRptParagraph jetRptParagraph) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        int n = 0;
        if (this.initParagraphLogic(jetRptParagraph, paraNodeListImpl) != null) {
            int n2 = paraNodeListImpl.size();
            for (int i = 0; i < n2; ++i) {
                ParaNode paraNode = paraNodeListImpl.item(i);
                n += paraNode.length();
            }
        }
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        return n;
    }

    @Override
    public Object getContentByPosition(JetRptParagraph jetRptParagraph, int n) {
        return this.getContentByPosition(jetRptParagraph, n, true);
    }

    @Override
    public JetRptParagraph getParagraphSegment(JetRptParagraph jetRptParagraph, int n, int n2) {
        JetRptParagraph jetRptParagraph2 = (JetRptParagraph)jetRptParagraph.dup();
        jetRptParagraph2 = this.insertSelectionTo(jetRptParagraph, n, n2, jetRptParagraph2, 0)[1];
        return jetRptParagraph2;
    }

    @Override
    public int getReplaceElementCountInSelection(JetRptParagraph jetRptParagraph, int n, int n2) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return -1;
        }
        if (n <= n2) {
            return 0;
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = paraNodeListImpl.size();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            ParaNode paraNode = paraNodeListImpl.item(i);
            ParaNode paraNode2 = paraNodeListImpl.item(i + 1);
            if (paraNode.getNodeType() == 258) {
                if (bl) {
                    ++n5;
                    if (n3 + paraNode.length() <= n2) {
                        break;
                    }
                } else if (n >= n3 && n <= paraNode2.length() + n3) {
                    bl = true;
                }
            } else if (bl) {
                if (n3 + paraNode.length() <= n2) {
                    break;
                }
            } else {
                if (paraNode2 == null) {
                    return 0;
                }
                if (paraNode2.getNodeType() == 257) {
                    if (n >= n3 && n < paraNode2.length() + n3) {
                        bl = true;
                    }
                } else if (n >= n3 && n <= paraNode2.length() + n3) {
                    bl = true;
                }
            }
            n3 += paraNode.length();
        }
        return n5;
    }

    @Override
    public int getCaretOfStringInParagraph(JetRptParagraph jetRptParagraph, int n, String string, boolean bl, boolean bl2, boolean bl3) {
        Object[] objectArray;
        int n2;
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return -1;
        }
        int n3 = 0;
        int n4 = paraNodeListImpl.size();
        int n5 = -1;
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray = paraNodeListImpl.item(n2);
            if (n >= n3 && n <= n3 + objectArray.length()) {
                n5 = n2;
                break;
            }
            n3 = objectArray.length() + n3;
        }
        if (n5 < 0) {
            return -1;
        }
        n2 = n5;
        while (n2 < n4) {
            objectArray = this.BorderColor(paraNodeListImpl, n2);
            String string2 = (String)objectArray[0];
            n2 = (Integer)objectArray[1];
            int n6 = this.AutoFit(string2, string, n - n3, bl, bl2, bl3);
            if (n6 < 0) {
                if (paraNodeListImpl.item(n2) != null && paraNodeListImpl.item(n2).getNodeType() == 258) {
                    n3 = n3 + string2.length() + 1;
                    ++n2;
                    continue;
                }
                n3 += string2.length();
                continue;
            }
            return n3 + n6;
        }
        return -1;
    }

    @Override
    public int getCaretOfStringInParagraph(JetRptParagraph jetRptParagraph, int n, String string, boolean bl, boolean bl2) {
        return this.getCaretOfStringInParagraph(jetRptParagraph, n, string, bl, bl2, false);
    }

    private int AutoFit(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (bl3) {
            throw new UnsupportedOperationException("We don't implement now");
        }
        int n2 = string.indexOf(string2, n);
        if (bl2) {
            while (n2 >= 0) {
                char c;
                if (n2 == 0) {
                    c = string.charAt(n2 + string2.length());
                    if (c <= '\u007f' && !Character.isLetterOrDigit(c)) {
                        return n2;
                    }
                } else {
                    c = string.charAt(n2 - 1);
                    if (c <= '\u007f' && !Character.isLetterOrDigit(c) && (c = string.charAt(n2 + string2.length())) <= '\u007f' && !Character.isLetterOrDigit(c)) {
                        return n2;
                    }
                }
                n2 = string.indexOf(string2, n2 + string2.length());
            }
        }
        return n2;
    }

    private Object[] BorderColor(ParaNodeList paraNodeList, int n) {
        ParaNode paraNode = paraNodeList.item(n);
        StringBuffer stringBuffer = new StringBuffer("");
        while (paraNode != null && paraNode.getNodeType() == 257) {
            stringBuffer.append(((ParaTextNode)paraNode).getNodeText());
            paraNode = paraNodeList.item(++n);
        }
        return new Object[]{stringBuffer.toString(), new Integer(n)};
    }

    @Override
    public int getReplaceElementPositionIn(JetRptParagraph jetRptParagraph, JetRptParaReplaceElement jetRptParaReplaceElement) {
        return this.getReplaceElementPositionIn(jetRptParagraph, jetRptParaReplaceElement, true);
    }

    @Override
    public JetRptParagraph insertReplaceObjectAtPosition(JetRptParagraph jetRptParagraph, JetRptParaReplaceElement jetRptParaReplaceElement, int n) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        int[] nArray = this.getStartLine(paraNodeListImpl2, n, true, paraNodeListImpl, 0, 0);
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (paraNodeListImpl2.isEmpty()) {
            this.basicComponentLogic.add((JetRptParagraph)paraRootNode, jetRptParaReplaceElement, -1);
            paraNodeListImpl.clear();
            paraNodeListImpl2.clear();
            paraNodeListImpl = null;
            paraNodeListImpl2 = null;
            return (JetRptParagraph)paraRootNode;
        }
        ParaNode paraNode = paraNodeListImpl.item(n2 - 1);
        ParaNode paraNode2 = paraNodeListImpl.item(n2);
        if (paraNode2.isInfiniteLeft()) {
            if (paraNode != null && paraNode2.parent().getNodeType() != 4098 && paraNode.parent().getNodeType() == 4098) {
                // empty if block
            }
        } else {
            this.separateWithStartLine(paraRootNode, paraNodeListImpl, n2, n3);
        }
        this.basicComponentLogic.add((JetRptParagraph)paraRootNode, jetRptParaReplaceElement, paraRootNode.getStartIndex());
        paraNodeListImpl.clear();
        paraNodeListImpl2.clear();
        paraNodeListImpl = null;
        paraNodeListImpl2 = null;
        return (JetRptParagraph)paraRootNode;
    }

    @Override
    public JetRptParagraph applyTextStyle(JetRptParagraph jetRptParagraph, int n, int n2, String string, String string2) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return jetRptParagraph;
        }
        ParaStyle paraStyle = new ParaStyle(string, string2, 0);
        boolean bl = this.Height(paraRootNode, paraStyle);
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        ParaNodeListImpl paraNodeListImpl3 = new ParaNodeListImpl();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int[] nArray = null;
        while (true) {
            int n6;
            int n7;
            ParaStyleNode paraStyleNode;
            Object object;
            paraNodeListImpl2.clear();
            paraNodeListImpl3.clear();
            n4 = n5 + 1;
            if (n >= n2) {
                if (bl || n != 0 || n2 != 0 || this.getParagraphSize(jetRptParagraph) != 0 || (object = jetRptParagraph.nameToProperty(string)) == null) break;
                ((JetProperty)object).setUnitValue(string2);
                break;
            }
            nArray = this.getStartLine(paraNodeListImpl2, n, false, paraNodeListImpl, n4, n3);
            n3 = nArray[0];
            n4 = nArray[1];
            n5 = nArray[2];
            if (paraNodeListImpl2.isEmpty() || n3 >= n2) break;
            nArray = this.getEndLine(paraNodeListImpl3, n2, false, paraNodeListImpl, n4, n3);
            n3 = nArray[0];
            n4 = nArray[1];
            n5 = nArray[2];
            n = n3;
            object = this.getSeparatorNode(paraNodeListImpl2, paraStyle.getStyleType());
            ParaTrunkNode paraTrunkNode = this.getParentNode((ParaTrunkNode)object);
            this.restoreSEStatus(paraNodeListImpl2, null, paraTrunkNode);
            if (object.getNodeType() == 4097 && (paraStyleNode = (ParaStyleNode)object).getStyle().equal(paraStyle) && !bl) continue;
            if (object.getStartIndex() == object.getEndIndex()) {
                if (object.getNodeType() == 4098) {
                    if (bl) continue;
                    nArray = this.LeftLine((ParaRootNode)object, paraStyle, paraNodeListImpl, n4, n5);
                    n4 = nArray[0];
                    n5 = nArray[1];
                    continue;
                }
                paraStyleNode = (ParaStyleNode)object;
                if (paraStyleNode.getStyleType() == paraStyle.getStyleType()) {
                    int n8 = paraTrunkNode.getStartIndex();
                    ParaStyleNode[] paraStyleNodeArray = this.separateStyleNode(paraStyleNode, paraNodeListImpl, n4, n5);
                    if (paraStyleNodeArray[2] != null) {
                        this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNodeArray[2]), n8 + 1);
                    }
                    if (bl) {
                        n7 = paraStyleNodeArray[1].length();
                        this.moveChildrenNode(paraStyleNodeArray[1], 0, n7 - 1, paraTrunkNode, n8);
                        this.basicComponentLogic.remove((JetRptObject)((Object)paraStyleNodeArray[1]));
                        if (n8 + n7 < paraTrunkNode.length()) {
                            nArray = this.mergeParagraphWidth(paraTrunkNode, n8 + n7 - 1, n8 + n7, paraNodeListImpl, n4, n5);
                            n4 = nArray[0];
                            n5 = nArray[1];
                        }
                    } else {
                        paraStyleNodeArray[1].setStyle(paraStyle);
                        if (n8 + 1 < paraTrunkNode.length()) {
                            nArray = this.mergeParagraphWidth(paraTrunkNode, n8, n8 + 1, paraNodeListImpl, n4, n5);
                            n4 = nArray[0];
                            n5 = nArray[1];
                        }
                    }
                    if (paraStyleNodeArray[0] != null) {
                        this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNodeArray[0]), n8);
                    }
                    n7 = n8 == 0 ? 0 : n8 - 1;
                    n6 = n8 + 1 < paraTrunkNode.length() ? n8 + 1 : n8;
                    nArray = this.mergeParagraphWidth(paraTrunkNode, n7, n6, paraNodeListImpl, n4, n5);
                    n4 = nArray[0];
                    n5 = nArray[1];
                    continue;
                }
                if (bl) continue;
                nArray = this.LeftLine(paraStyleNode, paraStyle, paraNodeListImpl, n4, n5);
                n4 = nArray[0];
                n5 = nArray[1];
                continue;
            }
            if (object.getNodeType() == 4098) {
                this.separateWithEndLine((ParaRootNode)object, paraNodeListImpl, n4, n5);
                this.separateWithStartLine((ParaRootNode)object, paraNodeListImpl, n4, n5);
                int n9 = object.getEndIndex();
                int n10 = object.getStartIndex();
                if (bl) {
                    this.RightLine((ParaTrunkNode)object, paraStyle.getStyleType());
                    nArray = this.mergeParagraphWidth((ParaRootNode)object, n10, n9, paraNodeListImpl, n4, n5);
                    n4 = nArray[0];
                    n5 = nArray[1];
                    continue;
                }
                ParaStyleNode paraStyleNode2 = this.createStyleElement(paraStyle);
                this.moveChildrenNode((ParaTrunkNode)object, paraStyleNode2, n10, n9);
                this.RightLine(paraStyleNode2, paraStyle.getStyleType());
                this.basicComponentLogic.add((JetContainable)object, (JetRptObject)((Object)paraStyleNode2), n10);
                n7 = n10 == 0 ? 0 : n10 - 1;
                n6 = n10 + 1 < object.length() ? n10 + 1 : n10;
                nArray = this.mergeParagraphWidth((ParaTrunkNode)object, n7, n6, paraNodeListImpl, n4, n5);
                n4 = nArray[0];
                n5 = nArray[1];
                continue;
            }
            int n11 = paraTrunkNode.getStartIndex();
            ParaStyleNode[] paraStyleNodeArray = this.separateStyleNode((ParaStyleNode)object, paraNodeListImpl, n4, n5);
            if (paraStyleNodeArray[2] != null) {
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNodeArray[2]), n11 + 1);
            }
            if (((ParaStyleNode)object).getStyleType() == paraStyle.getStyleType()) {
                if (!bl) {
                    paraStyleNodeArray[1].setStyle(paraStyle);
                    if (n11 + 1 < paraTrunkNode.length()) {
                        nArray = this.mergeParagraphWidth(paraTrunkNode, n11, n11 + 1, paraNodeListImpl, n4, n5);
                        n4 = nArray[0];
                        n5 = nArray[1];
                    }
                } else {
                    int n12 = object.length();
                    this.moveChildrenNode((ParaTrunkNode)object, 0, object.length() - 1, paraTrunkNode, n11);
                    this.basicComponentLogic.remove((JetRptObject)object);
                    if (n11 + n12 < paraTrunkNode.length()) {
                        nArray = this.mergeParagraphWidth(paraTrunkNode, n11 + n12 - 1, n11 + n12, paraNodeListImpl, n4, n5);
                        n4 = nArray[0];
                        n5 = nArray[1];
                    }
                }
            } else if (!bl) {
                ParaStyleNode paraStyleNode3 = this.createStyleElement(paraStyle);
                this.moveChildrenNode((ParaTrunkNode)object, paraStyleNode3);
                this.RightLine(paraStyleNode3, paraStyle.getStyleType());
                nArray = this.Shadow(paraStyleNode3, paraNodeListImpl, n4, n5);
                n4 = nArray[0];
                n5 = nArray[1];
                this.basicComponentLogic.add((JetContainable)object, (JetRptObject)((Object)paraStyleNode3));
                if (paraStyleNodeArray[2] != null) {
                    nArray = this.mergeParagraphWidth(paraTrunkNode, n11, n11 + 1, paraNodeListImpl, n4, n5);
                    n4 = nArray[0];
                    n5 = nArray[1];
                }
            } else {
                this.RightLine((ParaTrunkNode)object, paraStyle.getStyleType());
                nArray = this.Shadow((ParaTrunkNode)object, paraNodeListImpl, n4, n5);
                n4 = nArray[0];
                n5 = nArray[1];
            }
            if (paraStyleNodeArray[0] != null) {
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNodeArray[0]), n11);
            }
            int n13 = n11 == 0 ? 0 : n11 - 1;
            n7 = n11 + 1 < paraTrunkNode.length() ? n11 + 1 : n11;
            nArray = this.mergeParagraphWidth(paraTrunkNode, n13, n7, paraNodeListImpl, n4, n5);
            n4 = nArray[0];
            n5 = nArray[1];
        }
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        paraNodeListImpl2 = null;
        paraNodeListImpl3 = null;
        return jetRptParagraph;
    }

    @Override
    public JetRptParagraph clearTextStyle(JetRptParagraph jetRptParagraph, int n, int n2) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null || n >= n2) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        ParaNodeListImpl paraNodeListImpl3 = new ParaNodeListImpl();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int[] nArray = null;
        nArray = this.getStartLine(paraNodeListImpl2, n, true, paraNodeListImpl, 0, 0);
        n4 = nArray[0];
        n3 = nArray[1];
        if (paraNodeListImpl2.isEmpty()) {
            return jetRptParagraph;
        }
        nArray = this.getEndLine(paraNodeListImpl3, n2, true, paraNodeListImpl, n3, n4);
        n5 = nArray[2];
        ParaTrunkNode paraTrunkNode = this.getSeparatorNode(paraNodeListImpl2, -1);
        ParaNodeListImpl paraNodeListImpl4 = new ParaNodeListImpl();
        this.BorderWidth(paraNodeListImpl, n3, n5, paraNodeListImpl4);
        if (paraTrunkNode.getNodeType() == 4098) {
            int n6;
            int n7 = paraTrunkNode.getStartIndex();
            if (n7 == (n6 = paraTrunkNode.getEndIndex())) {
                return jetRptParagraph;
            }
            this.separateWithEndLine(paraRootNode, paraNodeListImpl, n3, n5);
            for (int i = n6; i > n7; --i) {
                this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
            }
            ParaNode paraNode = paraRootNode.childAt(paraRootNode.getStartIndex());
            this.deleteNodeOnStartLine(paraNode, paraNodeListImpl);
            int n8 = n7;
            n8 = paraNode.isInfiniteLeft() || paraNode.getNodeType() == 258 ? n7 : n7 + 1;
            int n9 = paraNodeListImpl4.size();
            while (!paraNodeListImpl4.isEmpty()) {
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraNodeListImpl4.pop()), n8);
            }
            if (n8 > 0) {
                this.mergeParagraphWidth(paraRootNode, n8 - 1, n8, paraNodeListImpl, n3, n5);
            }
            if (n8 + n9 < paraTrunkNode.length()) {
                this.mergeParagraphWidth(paraRootNode, n8 + n9 - 1, n8 + n9, paraNodeListImpl, n3, n5);
            }
            return jetRptParagraph;
        }
        int n10 = paraRootNode.getEndIndex();
        ++n10;
        this.separateWithEndLine(paraRootNode, paraNodeListImpl, n3, n5);
        while (!paraNodeListImpl4.isEmpty()) {
            this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraNodeListImpl4.pop()), n10);
        }
        int n11 = paraTrunkNode.length();
        for (int i = n11 - 1; i > paraTrunkNode.getStartIndex(); --i) {
            this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
        }
        this.deleteNodeOnStartLine(paraTrunkNode, paraNodeListImpl);
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        return jetRptParagraph;
    }

    private void BorderWidth(ParaNodeList paraNodeList, int n, int n2, ParaNodeList paraNodeList2) {
        if (n != n2) {
            Object object;
            paraNodeList2.clear();
            ParaNode paraNode = paraNodeList.item(n);
            if (paraNode.getNodeType() == 257) {
                String string = ((ParaTextNode)paraNode).substring(paraNode.getStartIndex());
                object = this.createTextSegment(string);
                paraNodeList2.push((ParaNode)object);
            } else {
                paraNodeList2.push(paraNode);
            }
            for (int i = n + 1; i < n2; ++i) {
                paraNode = paraNodeList.item(i);
                object = paraNodeList2.peek();
                if (object.getNodeType() == 258 || paraNode.getNodeType() == 258) {
                    paraNodeList2.push(paraNode);
                    continue;
                }
                String string = ((ParaTextNode)object).getNodeText();
                string = string.concat(((ParaTextNode)paraNode).getNodeText());
                ((ParaTextNode)object).setNewText(string);
            }
            paraNode = paraNodeList.item(n2);
            if (paraNode.getNodeType() != 257) {
                paraNodeList2.push(paraNode);
            } else {
                ParaNode paraNode2 = paraNodeList2.peek();
                if (paraNode2.getNodeType() != 257) {
                    paraNodeList2.push(paraNode);
                } else {
                    object = ((ParaTextNode)paraNode2).getNodeText();
                    object = ((String)object).concat(((ParaTextNode)paraNode).substring(0, paraNode.getEndIndex()));
                    ((ParaTextNode)paraNode2).setNewText((String)object);
                }
            }
        } else {
            ParaNode paraNode = paraNodeList.item(n);
            if (paraNode.getNodeType() == 257) {
                String string = ((ParaTextNode)paraNode).substring(paraNode.getStartIndex(), paraNode.getEndIndex());
                paraNodeList2.push(this.createTextSegment(string));
            } else {
                paraNodeList2.push(paraNode);
            }
        }
    }

    @Override
    public JetRptParagraph insertText(JetRptParagraph jetRptParagraph, int n, String string) {
        if (string == null || string.length() == 0) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        int[] nArray = this.getStartLine(paraNodeListImpl2, n, true, paraNodeListImpl, 0, 0);
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (paraNodeListImpl2.isEmpty()) {
            ParaNode paraNode = paraNodeListImpl.item(n2 - 1);
            if (paraNode == null || paraNode.getNodeType() == 258 || paraNode.parent().getNodeType() != 4098) {
                ParaTextNode paraTextNode = this.createTextSegment(string);
                this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode));
            } else {
                ((ParaTextNode)paraNode).appendString(string);
            }
        } else {
            ParaNode paraNode = paraNodeListImpl.item(n2);
            if (paraNode.isInfiniteLeft() || paraNode.getNodeType() == 258) {
                ParaNode paraNode2 = paraNodeListImpl.item(n2 - 1);
                if (paraNode2 == null || paraNode2.getNodeType() == 258) {
                    if (paraNode.getNodeType() == 258 || paraNode.parent().getNodeType() != 4098) {
                        ParaTextNode paraTextNode = this.createTextSegment(string);
                        this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode), paraRootNode.getStartIndex());
                    } else {
                        ((ParaTextNode)paraNode).setNewText(string + ((ParaTextNode)paraNode).getNodeText());
                    }
                } else if (paraNode2.parent().getNodeType() == 4098) {
                    ((ParaTextNode)paraNode2).setNewText(((ParaTextNode)paraNode2).getNodeText() + string);
                } else if (paraNode.getNodeType() == 258) {
                    ParaTextNode paraTextNode = this.createTextSegment(string);
                    this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode), paraRootNode.getStartIndex());
                } else if (paraNode.parent().getNodeType() == 4098) {
                    ((ParaTextNode)paraNode).setNewText(string + ((ParaTextNode)paraNode).getNodeText());
                } else {
                    this.separateWithStartLine(paraRootNode, paraNodeListImpl, n2, n3);
                    ParaTextNode paraTextNode = this.createTextSegment(string);
                    this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode), paraRootNode.getStartIndex());
                }
            } else {
                ((ParaTextNode)paraNode).appendString(string);
            }
        }
        paraNodeListImpl2.clear();
        paraNodeListImpl.clear();
        paraNodeListImpl2 = null;
        paraNodeListImpl = null;
        return (JetRptParagraph)paraRootNode;
    }

    @Override
    public JetRptParagraph insertReplaceElement(JetRptParagraph jetRptParagraph, int n, JetRptObject jetRptObject) {
        JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement(jetRptObject);
        JetRptParagraph jetRptParagraph2 = this.insertReplaceObjectAtPosition(jetRptParagraph, jetRptParaReplaceElement, n);
        this.handleSpecialProperty(jetRptParaReplaceElement.getObject());
        return jetRptParagraph2;
    }

    @Override
    public JetRptParagraph deleteParagraphElements(JetRptParagraph jetRptParagraph, int n, int n2) {
        if (n >= n2) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return jetRptParagraph;
        }
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        ParaNodeListImpl paraNodeListImpl3 = new ParaNodeListImpl();
        int[] nArray = this.getStartLine(paraNodeListImpl2, n, true, paraNodeListImpl, 0, 0);
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (paraNodeListImpl2.isEmpty()) {
            paraNodeListImpl.clear();
            paraNodeListImpl = null;
            paraNodeListImpl2 = null;
            return jetRptParagraph;
        }
        nArray = this.getEndLine(paraNodeListImpl3, n2, true, paraNodeListImpl, n4, n3);
        n3 = nArray[0];
        n4 = nArray[2];
        ParaTrunkNode paraTrunkNode = this.getSeparatorNode(paraNodeListImpl2, -1);
        if (paraTrunkNode.getStartIndex() == paraTrunkNode.getEndIndex()) {
            ParaNode paraNode = paraTrunkNode.childAt(paraTrunkNode.getStartIndex());
            if (paraNode.getNodeType() == 257) {
                ParaTextNode paraTextNode = (ParaTextNode)paraNode;
                String string = paraTextNode.substring(0, paraTextNode.getStartIndex());
                String string2 = paraTextNode.substring(paraTextNode.getEndIndex());
                if (string.length() > 0 && string2.length() > 0) {
                    paraTextNode.setNewText(string + string2);
                } else if (string.length() > 0) {
                    paraTextNode.setNewText(string);
                } else if (string2.length() > 0) {
                    paraTextNode.setNewText(string2);
                } else {
                    int n5 = paraTrunkNode.length();
                    if (n5 == 1) {
                        this.deleteNodeFully(paraTrunkNode, paraNodeListImpl);
                    } else {
                        this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
                        if (paraTrunkNode.getStartIndex() > 0 && paraTrunkNode.getStartIndex() < n5 - 1) {
                            this.mergeParagraphWidth(paraTrunkNode, paraTrunkNode.getStartIndex() - 1, paraTrunkNode.getStartIndex(), paraNodeListImpl, -1, -1);
                        }
                    }
                }
            } else if (paraNode.getNodeType() == 258) {
                int n6 = paraTrunkNode.length();
                this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
                if (paraTrunkNode.getStartIndex() > 0 && paraTrunkNode.getStartIndex() < n6 - 1) {
                    this.mergeParagraphWidth(paraTrunkNode, paraTrunkNode.getStartIndex() - 1, paraTrunkNode.getStartIndex(), paraNodeListImpl, -1, -1);
                }
            }
        } else {
            boolean bl = paraTrunkNode.isInfiniteLeft();
            boolean bl2 = paraTrunkNode.isInfiniteRight();
            if (bl && bl2) {
                this.deleteNodeFully(paraTrunkNode, paraNodeListImpl);
            } else if (bl) {
                int n7 = paraTrunkNode.getEndIndex();
                for (int i = n7 - 1; i >= 0; --i) {
                    this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
                }
                this.deleteNodeOnEndLine(paraTrunkNode.childAt(0), paraNodeListImpl);
            } else if (bl2) {
                int n8 = paraTrunkNode.getStartIndex();
                for (int i = paraTrunkNode.length() - 1; i > n8; --i) {
                    this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
                }
                this.deleteNodeOnStartLine(paraTrunkNode.childAt(n8), paraNodeListImpl);
            } else {
                int n9 = paraTrunkNode.getEndIndex();
                int n10 = paraTrunkNode.getStartIndex();
                this.deleteNodeOnEndLine(paraTrunkNode.childAt(n9), paraNodeListImpl);
                for (int i = n9 - 1; i > n10; --i) {
                    this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
                }
                this.deleteNodeOnStartLine(paraTrunkNode.childAt(n10), paraNodeListImpl);
                if (n10 == paraTrunkNode.length()) {
                    this.mergeParagraphWidth(paraTrunkNode, n10, n10, paraNodeListImpl, -1, -1);
                } else {
                    this.mergeParagraphWidth(paraTrunkNode, n10, n10 + 1, paraNodeListImpl, -1, -1);
                }
            }
        }
        paraNodeListImpl2.clear();
        paraNodeListImpl3.clear();
        paraNodeListImpl.clear();
        paraNodeListImpl2 = null;
        paraNodeListImpl3 = null;
        paraNodeListImpl = null;
        return jetRptParagraph;
    }

    @Override
    public JetRptParagraph deleteParagraphReplaceElement(JetRptParagraph jetRptParagraph, JetRptParaReplaceElement jetRptParaReplaceElement) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        if (this.initParagraphLogic(jetRptParagraph, paraNodeListImpl) != null) {
            int n = jetRptParagraph.indexOf(jetRptParaReplaceElement, -1);
            this.basicComponentLogic.remove(jetRptParaReplaceElement);
            if (n >= 1 && n < jetRptParagraph.length()) {
                this.mergeParagraphWidth(jetRptParagraph, n - 1, n, paraNodeListImpl, -1, -1);
            }
        }
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        return jetRptParagraph;
    }

    @Override
    public JetRptParagraph[] insertSelectionTo(JetRptParagraph jetRptParagraph, int n, int n2, JetRptParagraph jetRptParagraph2, int n3) {
        if (jetRptParagraph == null || n2 < 0 || n >= n2 || n3 < 0) {
            return new JetRptParagraph[]{jetRptParagraph, jetRptParagraph2};
        }
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph2, paraNodeListImpl);
        ParaRootNode paraRootNode2 = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl2);
        ParaNodeListImpl paraNodeListImpl3 = new ParaNodeListImpl();
        int[] nArray = this.getStartLine(paraNodeListImpl3, n, true, paraNodeListImpl2, 0, 0);
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (paraRootNode == null || paraRootNode2 == null || paraNodeListImpl3.isEmpty()) {
            return new JetRptParagraph[]{jetRptParagraph, jetRptParagraph2};
        }
        ParaNodeListImpl paraNodeListImpl4 = new ParaNodeListImpl();
        this.getEndLine(paraNodeListImpl4, n2, true, paraNodeListImpl2, n5, n4);
        ParaNodeListImpl paraNodeListImpl5 = new ParaNodeListImpl();
        this.getStartLine(paraNodeListImpl5, n3, true, paraNodeListImpl, 0, 0);
        if (paraNodeListImpl5.isEmpty()) {
            int n6 = paraRootNode.length();
            this.I(paraRootNode2, paraRootNode2.getStartIndex(), paraRootNode2.getEndIndex(), paraRootNode, n6);
            if (n6 > 0) {
                this.mergeParagraphWidth(paraRootNode, n6 - 1, n6, paraNodeListImpl, -1, -1);
            }
        } else {
            this.separateWithStartLine(paraRootNode, paraNodeListImpl, -1, -1);
            int n7 = paraRootNode.getStartIndex();
            int n8 = paraRootNode2.getEndIndex() - paraRootNode2.getStartIndex() + 1;
            int n9 = paraRootNode.length();
            this.I(paraRootNode2, paraRootNode2.getStartIndex(), paraRootNode2.getEndIndex(), paraRootNode, n7);
            if (n7 < n9) {
                this.mergeParagraphWidth(paraRootNode, n7 + n8 - 1, n7 + n8, paraNodeListImpl, -1, -1);
            }
            if (n7 > 0) {
                this.mergeParagraphWidth(paraRootNode, n7 - 1, n7, paraNodeListImpl, -1, -1);
            }
        }
        return new JetRptParagraph[]{jetRptParagraph, jetRptParagraph2};
    }

    @Override
    public JetRptParagraph mergeParagraph(JetRptParagraph jetRptParagraph, JetRptParagraph jetRptParagraph2) {
        if (jetRptParagraph != null) {
            if (jetRptParagraph2 != null) {
                if (jetRptParagraph2.length() == 0) {
                    this.basicComponentLogic.remove(jetRptParagraph2);
                } else if (jetRptParagraph.length() == 0) {
                    this.moveChildrenNode(jetRptParagraph2, jetRptParagraph);
                    this.basicComponentLogic.remove(jetRptParagraph2);
                } else {
                    Object object;
                    int n;
                    ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
                    this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    for (n = 0; n < NStyle.TYPE_NAME.length; ++n) {
                        String string = jetRptParagraph2.nameToProperty(NStyle.TYPE_NAME[n]).toUnitString();
                        if (string.equals(object = jetRptParagraph.nameToProperty(NStyle.TYPE_NAME[n]).toUnitString())) continue;
                        hashtable.put(NStyle.TYPE_NAME[n], string);
                    }
                    n = jetRptParagraph.length();
                    int n2 = 0;
                    object = new Vector(jetRptParagraph2.getChildrenList());
                    if (hashtable.isEmpty()) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.basicComponentLogic.remove((JetObject)e);
                            this.basicComponentLogic.add(jetRptParagraph, (JetObject)e);
                            ++n2;
                        }
                    } else {
                        Vector<ParaNode> vector = new Vector<ParaNode>();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (!(e instanceof ParaNode)) continue;
                            if (((ParaNode)e).getNodeType() == 258) {
                                if (vector.size() > 0) {
                                    this.basicComponentLogic.add(jetRptParagraph, this.BottomLine(hashtable, vector));
                                    ++n2;
                                    vector.clear();
                                }
                                this.basicComponentLogic.remove((JetObject)e);
                                this.basicComponentLogic.add(jetRptParagraph, (JetObject)e);
                                ++n2;
                                continue;
                            }
                            vector.add((ParaNode)e);
                        }
                        if (vector.size() > 0) {
                            this.basicComponentLogic.add(jetRptParagraph, this.BottomLine(hashtable, vector));
                            ++n2;
                            vector.clear();
                        }
                    }
                    this.mergeParagraphWidth(jetRptParagraph, n - 1, n - 1 + n2, paraNodeListImpl, -1, -1);
                    paraNodeListImpl.clear();
                    paraNodeListImpl = null;
                }
            }
            return jetRptParagraph;
        }
        return jetRptParagraph2;
    }

    private JetRptParaStyleElement BottomLine(Hashtable hashtable, List list) {
        JetRptParaStyleElement jetRptParaStyleElement = null;
        ParaNode paraNode = null;
        for (Map.Entry object : hashtable.entrySet()) {
            ParaNode paraNode2 = (JetRptParaStyleElement)this.createStyleElement(new ParaStyle((String)object.getKey(), (NStyleValue)new ParaStyleValue((String)object.getValue(), 9002)));
            if (paraNode == null) {
                jetRptParaStyleElement = (JetRptParaStyleElement)paraNode2;
            } else {
                ((JetObject)((Object)paraNode2)).setParentDirectly((JetContainable)((Object)paraNode));
                ((JetContainable)((Object)paraNode)).getChildren().add((JetObject)((Object)paraNode2));
            }
            paraNode = paraNode2;
        }
        for (ParaNode paraNode2 : list) {
            this.basicComponentLogic.remove((JetObject)((Object)paraNode2));
            this.basicComponentLogic.add((JetContainable)((Object)paraNode), (JetObject)((Object)paraNode2));
        }
        return jetRptParaStyleElement;
    }

    @Override
    public JetRptParagraph[] splitParagraph(JetRptParagraph jetRptParagraph, int n) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return new JetRptParagraph[]{null, null};
        }
        JetRptParagraph[] jetRptParagraphArray = new JetRptParagraph[]{(JetRptParagraph)paraRootNode, new JetRptParagraph()};
        jetRptParagraphArray[1].setEditable();
        JetRptObject.copyProperties(jetRptParagraphArray[1], jetRptParagraphArray[0]);
        ParaNodeListImpl paraNodeListImpl2 = new ParaNodeListImpl();
        int[] nArray = this.getStartLine(paraNodeListImpl2, n, true, paraNodeListImpl, 0, 0);
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (paraNodeListImpl2.isEmpty()) {
            if (paraNodeListImpl.size() != 0) {
                while (!paraNodeListImpl.isEmpty()) {
                    ParaNode paraNode = paraNodeListImpl.pop();
                    if (paraNode.getNodeType() == 257) {
                        JetRptObject.copyProperties(jetRptParagraphArray[1], (JetRptObject)((Object)paraNode));
                        break;
                    }
                    if (((ParaReplaceNode)paraNode).length() <= 0) continue;
                    break;
                }
            }
            paraNodeListImpl2.clear();
            paraNodeListImpl2 = null;
            paraNodeListImpl.clear();
            paraNodeListImpl = null;
            return jetRptParagraphArray;
        }
        ParaNode paraNode = paraNodeListImpl.item(n2 - 1);
        ParaNode paraNode2 = paraNodeListImpl.item(n2);
        if (paraNode == null && paraNode2.isInfiniteLeft() || paraNode2.parent().getNodeType() == 4098 && paraNode2.isInfiniteLeft()) {
            if (paraNode == null && paraNode2.parent().getNodeType() != 4098) {
                JetRptObject.copyProperties(jetRptParagraphArray[0], (JetRptObject)((Object)paraNode2));
            }
        } else if (paraNode == null || paraNode.parent().getNodeType() != 4098 || !paraNode2.isInfiniteLeft()) {
            this.separateWithStartLine(jetRptParagraphArray[0], paraNodeListImpl, n2, n3);
        }
        this.moveChildrenNode(jetRptParagraphArray[0], jetRptParagraphArray[1], jetRptParagraphArray[0].getStartIndex(), jetRptParagraphArray[0].length() - 1);
        paraNodeListImpl2.clear();
        paraNodeListImpl2 = null;
        paraNodeListImpl.clear();
        paraNodeListImpl = null;
        return jetRptParagraphArray;
    }

    private boolean Height(ParaRootNode paraRootNode, NStyle nStyle) {
        String string = nStyle.getStyleName();
        String string2 = nStyle.getValue().getStringValue();
        String string3 = ((JetRptParagraph)paraRootNode).getStyleDefValueString(string);
        if (string3 != null) {
            return string2.equals(string3);
        }
        return false;
    }

    protected ParaRootNode initParagraphLogic(JetRptParagraph jetRptParagraph, ParaNodeList paraNodeList) {
        if (jetRptParagraph == null) {
            return null;
        }
        return this.parseRoot(jetRptParagraph, paraNodeList);
    }

    protected ParaRootNode parseRoot(ParaRootNode paraRootNode, ParaNodeList paraNodeList) {
        ParaRootNode paraRootNode2 = paraRootNode;
        if (paraNodeList == null) {
            paraNodeList = new ParaNodeListImpl();
        } else {
            paraNodeList.clear();
        }
        TreeIterater treeIterater = new TreeIterater(paraRootNode2, false);
        Object object = treeIterater.next();
        while (object != null) {
            ParaNode paraNode = (ParaNode)object;
            if ((paraNode.getNodeType() & 0x100) != 0) {
                paraNodeList.push(paraNode);
            }
            paraNode.resetSEIndex();
            if (paraNode.getNodeType() == 258) {
                treeIterater.skipBranch();
            }
            object = treeIterater.next();
        }
        treeIterater = null;
        return paraRootNode2;
    }

    protected int[] getStartLine(ParaNodeList paraNodeList, int n, boolean bl, ParaNodeList paraNodeList2, int n2, int n3) {
        int n4;
        paraNodeList.clear();
        boolean bl2 = false;
        ParaNode paraNode = null;
        if (bl) {
            while (n2 < paraNodeList2.size()) {
                paraNode = paraNodeList2.item(n2);
                if (paraNode.isIncludePosition(false, n4 = n - n3)) {
                    paraNode.setStartIndex(n4);
                    bl2 = true;
                    break;
                }
                n3 += paraNode.length();
                ++n2;
            }
        } else {
            while (n2 < paraNodeList2.size()) {
                paraNode = paraNodeList2.item(n2);
                n4 = n - n3;
                if (paraNode.getNodeType() == 258) {
                    if (paraNode.isIncludePosition(false, n4)) {
                        n += paraNode.length();
                    }
                    n3 += paraNode.length();
                } else {
                    if (paraNode.isIncludePosition(false, n4)) {
                        paraNode.setStartIndex(n4);
                        bl2 = true;
                        break;
                    }
                    n3 += paraNode.length();
                }
                ++n2;
            }
        }
        if (bl2) {
            while (true) {
                ParaTrunkNode paraTrunkNode = (ParaTrunkNode)paraNode.parent();
                int n5 = paraTrunkNode.indexOf(paraNode);
                paraTrunkNode.setStartIndex(n5);
                paraNodeList.insert(0, paraTrunkNode);
                if (paraTrunkNode.getNodeType() != 4097) break;
                paraNode = paraTrunkNode;
            }
        }
        return new int[]{n3, n2, n2};
    }

    protected int[] getEndLine(ParaNodeList paraNodeList, int n, boolean bl, ParaNodeList paraNodeList2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl2 = false;
        ParaNode paraNode = null;
        if (bl) {
            for (n6 = n2; n6 < paraNodeList2.size(); ++n6) {
                paraNode = paraNodeList2.item(n6);
                if (paraNode.isIncludePosition(true, n5 = n - n3)) {
                    paraNode.setEndIndex(n5);
                    n3 += n5;
                    bl2 = true;
                    break;
                }
                n3 += paraNode.length();
            }
        } else {
            n5 = n2;
            while (n6 < paraNodeList2.size()) {
                paraNode = paraNodeList2.item(n6);
                n4 = n - n3;
                if (paraNode.getNodeType() == 257) {
                    if (paraNode.isIncludePosition(true, n4)) {
                        paraNode.setEndIndex(n4);
                        n3 += n4;
                        n5 = n6;
                        bl2 = true;
                        break;
                    }
                    n5 = n6++;
                    n3 += paraNode.length();
                    continue;
                }
                paraNode = paraNodeList2.item(n5);
                paraNode.setEndIndex(paraNode.length());
                n6 = n5;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            while (true) {
                ParaTrunkNode paraTrunkNode = (ParaTrunkNode)paraNode.parent();
                n4 = paraTrunkNode.indexOf(paraNode);
                paraTrunkNode.setEndIndex(n4);
                paraNodeList.insert(0, paraTrunkNode);
                if (paraTrunkNode.getNodeType() != 4097) break;
                paraNode = paraTrunkNode;
            }
        }
        return new int[]{n3, n2, n6};
    }

    protected ParaTrunkNode getSeparatorNode(ParaNodeList paraNodeList, int n) {
        if (paraNodeList == null || paraNodeList.isEmpty()) {
            return null;
        }
        ParaNode paraNode = null;
        int n2 = 0;
        ParaNode paraNode2 = paraNodeList.item(n2++);
        if (paraNodeList.size() == 1) {
            return (ParaRootNode)paraNode2;
        }
        if (paraNode2.getStartIndex() != paraNode2.getEndIndex()) {
            return (ParaRootNode)paraNode2;
        }
        while (true) {
            ParaNode paraNode3;
            if ((paraNode3 = paraNodeList.item(n2)).getStartIndex() != paraNode3.getEndIndex()) {
                paraNode = paraNodeList.item(n2);
                break;
            }
            if (((ParaStyleNode)paraNode3).getStyleType() == n) {
                paraNode = paraNodeList.item(n2);
                break;
            }
            if (((ParaStyleNode)paraNode3).childAt(paraNode3.getStartIndex()).getNodeType() == 257 || ((ParaStyleNode)paraNode3).childAt(paraNode3.getEndIndex()).getNodeType() == 257) {
                paraNode = paraNodeList.item(n2);
                break;
            }
            ++n2;
        }
        return (ParaTrunkNode)paraNode;
    }

    protected ParaTrunkNode getParentNode(ParaTrunkNode paraTrunkNode) {
        if (paraTrunkNode.getNodeType() == 4098) {
            return paraTrunkNode;
        }
        return (ParaTrunkNode)paraTrunkNode.parent();
    }

    protected void restoreSEStatus(ParaNodeList paraNodeList, ParaNode paraNode, ParaNode paraNode2) {
        int n;
        int n2;
        if (paraNodeList == null || paraNodeList.size() == 0) {
            return;
        }
        int n3 = n2 = paraNode2 == null ? paraNodeList.size() : paraNodeList.indexOf(paraNode2);
        if (n < 0 || n2 < 0) {
            return;
        }
        for (n = paraNode == null ? 0 : paraNodeList.indexOf(paraNode); n < n2; ++n) {
            paraNodeList.item(n).resetSEIndex();
        }
    }

    protected void moveChildrenNode(ParaTrunkNode paraTrunkNode, ParaTrunkNode paraTrunkNode2) {
        this.moveChildrenNode(paraTrunkNode, 0, paraTrunkNode.length() - 1, paraTrunkNode2, paraTrunkNode2.length());
    }

    protected void moveChildrenNode(ParaTrunkNode paraTrunkNode, ParaTrunkNode paraTrunkNode2, int n, int n2) {
        this.moveChildrenNode(paraTrunkNode, n, n2, paraTrunkNode2, 0);
    }

    protected void moveChildrenNode(ParaTrunkNode paraTrunkNode, int n, int n2, ParaTrunkNode paraTrunkNode2, int n3) {
        int n4;
        for (n4 = n2; n4 >= n; --n4) {
            JetRptObject jetRptObject = (JetRptObject)((Object)paraTrunkNode.childAt(n4));
            paraTrunkNode2.getChildrenList().add(n3, jetRptObject);
            jetRptObject.setParent((JetContainable)((Object)paraTrunkNode2));
        }
        for (n4 = n; n4 <= n2; ++n4) {
            paraTrunkNode.getChildrenList().remove(n);
        }
        n4 = paraTrunkNode.getEndIndex();
        int n5 = paraTrunkNode.getStartIndex();
        if (n <= n5) {
            if (n < n5) {
                if (n2 <= n5) {
                    int n6 = n2 - n + 1;
                    paraTrunkNode.setStartIndex(n5 - n6);
                    paraTrunkNode.setEndIndex(n4 - n6);
                } else {
                    paraTrunkNode.setStartIndex(n);
                    if (n2 < n4) {
                        paraTrunkNode.setEndIndex(n4 - (n2 - n + 1));
                    } else {
                        paraTrunkNode.setEndIndex(paraTrunkNode.getStartIndex());
                    }
                }
            } else if (n2 == n5) {
                int n7 = n2 - n + 1;
                paraTrunkNode.setEndIndex(n4 - n7);
            } else if (n2 < n4) {
                int n8 = n2 - n + 1;
                paraTrunkNode.setEndIndex(n4 - n8);
            } else {
                paraTrunkNode.setEndIndex(paraTrunkNode.getStartIndex());
            }
        } else if (n < n4) {
            if (n2 < n4) {
                int n9 = n2 - n + 1;
                paraTrunkNode.setEndIndex(n4 - n9);
            } else {
                paraTrunkNode.setEndIndex(n);
            }
        } else if (n == n4) {
            paraTrunkNode.setEndIndex(n);
        }
    }

    protected void deleteNodeOnStartLine(ParaNode paraNode, ParaNodeList paraNodeList) {
        if (paraNode.getNodeType() == 4097) {
            if (paraNode.isInfiniteLeft()) {
                this.deleteNodeFully((ParaStyleNode)paraNode, paraNodeList);
            } else {
                int n = paraNode.getStartIndex();
                for (int i = paraNode.length() - 1; i > n; --i) {
                    this.basicComponentLogic.remove((JetRptObject)((Object)((ParaStyleNode)paraNode).childAt(i)));
                }
                this.deleteNodeOnStartLine(((ParaStyleNode)paraNode).childAt(n), paraNodeList);
            }
        } else if (paraNode.getNodeType() == 258) {
            this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
        } else if (paraNode.getNodeType() == 257) {
            String string = ((ParaTextNode)paraNode).substring(0, paraNode.getStartIndex());
            if (string.length() == 0) {
                this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
            } else {
                ((ParaTextNode)paraNode).setNewText(string);
            }
        }
    }

    protected void deleteNodeOnEndLine(ParaNode paraNode, ParaNodeList paraNodeList) {
        if (paraNode.getNodeType() == 4097) {
            if (paraNode.isInfiniteRight()) {
                this.deleteNodeFully((ParaStyleNode)paraNode, paraNodeList);
            } else {
                int n = paraNode.getEndIndex();
                this.deleteNodeOnEndLine(((ParaStyleNode)paraNode).childAt(n), paraNodeList);
                for (int i = n - 1; i >= 0; --i) {
                    this.basicComponentLogic.remove((JetRptObject)((Object)((ParaStyleNode)paraNode).childAt(i)));
                }
            }
        } else if (paraNode.getNodeType() == 258) {
            this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
        } else if (paraNode.getNodeType() == 257) {
            String string = ((ParaTextNode)paraNode).substring(paraNode.getEndIndex());
            if (string.length() == 0) {
                this.basicComponentLogic.remove((JetRptObject)((Object)paraNode));
            } else {
                ((ParaTextNode)paraNode).setNewText(string);
            }
        }
    }

    protected ParaTrunkNode deleteNodeFully(ParaTrunkNode paraTrunkNode, ParaNodeList paraNodeList) {
        if (paraTrunkNode.getNodeType() == 4098) {
            for (int i = paraTrunkNode.length() - 1; i >= 0; --i) {
                this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode.childAt(i)));
            }
            return paraTrunkNode;
        }
        ParaTrunkNode paraTrunkNode2 = paraTrunkNode;
        ParaTrunkNode paraTrunkNode3 = null;
        while ((paraTrunkNode3 = (ParaTrunkNode)paraTrunkNode2.parent()).getNodeType() != 4098 && paraTrunkNode3.length() <= 1) {
            paraTrunkNode2 = paraTrunkNode3;
        }
        int n = paraTrunkNode3.indexOf(paraTrunkNode2);
        this.basicComponentLogic.remove((JetRptObject)((Object)paraTrunkNode2));
        if (n < paraTrunkNode3.length() && n > 0) {
            this.mergeParagraphWidth(paraTrunkNode3, n - 1, n, paraNodeList, -1, -1);
        }
        return paraTrunkNode3;
    }

    private void HorizontalAlignment(JetRptParaTextSegment jetRptParaTextSegment, JetRptParaTextSegment jetRptParaTextSegment2) {
    }

    protected void removeDefaultStyleDeepth(ParaRootNode paraRootNode, int n, int n2) {
    }

    private void I(ParaTrunkNode paraTrunkNode, int n, int n2, ParaTrunkNode paraTrunkNode2, int n3) {
        if (n == n2) {
            ParaNode paraNode = paraTrunkNode.childAt(n);
            if (paraNode.getNodeType() == 4097) {
                ParaStyleNode paraStyleNode = (ParaStyleNode)paraNode;
                ParaStyleNode paraStyleNode2 = this.createStyleElement(paraStyleNode.getStyle());
                int n4 = paraStyleNode.getStartIndex() < 0 ? 0 : paraStyleNode.getStartIndex();
                int n5 = paraStyleNode.getEndIndex() < 0 ? paraStyleNode.length() - 1 : paraStyleNode.getEndIndex();
                this.I(paraStyleNode, n4, n5, paraStyleNode2, 0);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)((Object)paraStyleNode2), n3);
            } else if (paraNode.getNodeType() == 257) {
                ParaTextNode paraTextNode = (ParaTextNode)paraNode;
                ParaTextNode paraTextNode2 = this.createTextSegment(paraTextNode.substring(paraTextNode.getStartIndex(), paraTextNode.getEndIndex()));
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)((Object)paraTextNode2), n3);
            } else if (paraNode.getNodeType() == 258) {
                ParaReplaceNode paraReplaceNode = (ParaReplaceNode)paraNode;
                JetRptObject jetRptObject = (JetRptObject)((ReplaceElement)((Object)paraReplaceNode)).getObject().deepDup();
                jetRptObject.displayName.set("");
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement(jetRptObject);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), jetRptParaReplaceElement, n3);
            }
        } else {
            Object object;
            ParaNode paraNode;
            ParaNode paraNode2 = paraTrunkNode.childAt(n2);
            if (paraNode2.getNodeType() == 4097) {
                paraNode = (ParaStyleNode)paraNode2;
                object = this.createStyleElement(paraNode.getStyle());
                int n6 = paraNode.getEndIndex() < 0 ? paraNode.length() - 1 : paraNode.getEndIndex();
                this.I((ParaTrunkNode)paraNode, 0, n6, (ParaTrunkNode)object, 0);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
            } else if (paraNode2.getNodeType() == 257) {
                paraNode = (ParaTextNode)paraNode2;
                object = this.createTextSegment(paraNode.substring(0, paraNode.getEndIndex()));
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
            } else if (paraNode2.getNodeType() == 258) {
                paraNode = (ParaReplaceNode)paraNode2;
                object = (JetRptObject)((ReplaceElement)((Object)paraNode)).getObject().deepDup();
                ((JetRptObject)object).displayName.set("");
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement((JetRptObject)object);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), jetRptParaReplaceElement, n3);
            }
            this.copyChildrenTo(paraTrunkNode, n + 1, n2 - 1, paraTrunkNode2, n3);
            paraNode2 = paraTrunkNode.childAt(n);
            if (paraNode2 == null) {
                // empty if block
            }
            if (paraNode2.getNodeType() == 4097) {
                paraNode = (ParaStyleNode)paraNode2;
                object = this.createStyleElement(paraNode.getStyle());
                int n7 = paraNode.getStartIndex() < 0 ? 0 : paraNode.getStartIndex();
                this.I((ParaTrunkNode)paraNode, n7, paraNode.length() - 1, (ParaTrunkNode)object, 0);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
            } else if (paraNode2.getNodeType() == 257) {
                paraNode = (ParaTextNode)paraNode2;
                object = this.createTextSegment(paraNode.substring(paraNode.getStartIndex()));
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
            } else if (paraNode2.getNodeType() == 258) {
                paraNode = (ParaReplaceNode)paraNode2;
                object = (JetRptObject)((ReplaceElement)((Object)paraNode)).getObject().deepDup();
                ((JetRptObject)object).displayName.set("");
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement((JetRptObject)object);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), jetRptParaReplaceElement, n3);
            }
        }
    }

    protected void copyChildrenTo(ParaTrunkNode paraTrunkNode, int n, int n2, ParaTrunkNode paraTrunkNode2, int n3) {
        for (int i = n2; i >= n; --i) {
            Object object;
            ParaNode paraNode = paraTrunkNode.childAt(i);
            if (paraNode.getNodeType() == 4097) {
                object = this.createStyleElement(((ParaStyleNode)paraNode).getStyle());
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
                this.copyChildrenTo((ParaStyleNode)paraNode, 0, paraNode.length() - 1, (ParaTrunkNode)object, 0);
                continue;
            }
            if (paraNode.getNodeType() == 258) {
                object = (JetRptObject)((JetRptParaReplaceElement)paraNode).getObject().deepDup();
                ((JetRptObject)object).displayName.set("");
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement((JetRptObject)object);
                this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), jetRptParaReplaceElement, n3);
                continue;
            }
            if (paraNode.getNodeType() != 257) continue;
            object = this.createTextSegment(((ParaTextNode)paraNode).getNodeText());
            this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode2), (JetRptObject)object, n3);
        }
    }

    protected ParaStyleNode[] separateStyleNode(ParaStyleNode paraStyleNode, ParaNodeList paraNodeList, int n, int n2) {
        boolean bl = paraStyleNode.isInfiniteLeft();
        boolean bl2 = paraStyleNode.isInfiniteRight();
        if (bl && bl2) {
            return new ParaStyleNode[]{null, paraStyleNode, null};
        }
        if (bl) {
            ParaStyleNode paraStyleNode2 = this.createStyleElement(paraStyleNode.getStyle());
            this.separateWithEndLine(paraStyleNode, paraStyleNode2, paraNodeList, n, n2);
            return new ParaStyleNode[]{null, paraStyleNode, paraStyleNode2};
        }
        if (bl2) {
            ParaStyleNode paraStyleNode3 = this.createStyleElement(paraStyleNode.getStyle());
            this.separateWithStartLine(paraStyleNode, paraStyleNode3, paraNodeList, n, n2);
            return new ParaStyleNode[]{paraStyleNode3, paraStyleNode, null};
        }
        ParaStyleNode paraStyleNode4 = this.createStyleElement(paraStyleNode.getStyle());
        ParaStyleNode paraStyleNode5 = this.createStyleElement(paraStyleNode.getStyle());
        this.separateWithEndLine(paraStyleNode, paraStyleNode4, paraNodeList, n, n2);
        this.separateWithStartLine(paraStyleNode, paraStyleNode5, paraNodeList, n, n2);
        return new ParaStyleNode[]{paraStyleNode5, paraStyleNode, paraStyleNode4};
    }

    protected void separateWithEndLine(ParaStyleNode paraStyleNode, ParaStyleNode paraStyleNode2, ParaNodeList paraNodeList, int n, int n2) {
        int n3 = paraStyleNode.getEndIndex();
        int n4 = paraStyleNode.length();
        this.moveChildrenNode(paraStyleNode, paraStyleNode2, n3 + 1, n4 - 1);
        ParaNode paraNode = paraStyleNode.childAt(paraStyleNode.getEndIndex());
        if (!paraNode.isInfiniteRight()) {
            if (paraNode.getNodeType() == 4097) {
                ParaStyleNode paraStyleNode3 = this.createStyleElement(((ParaStyleNode)paraNode).getStyle());
                this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode2), (JetRptObject)((Object)paraStyleNode3), 0);
                this.separateWithEndLine((ParaStyleNode)paraNode, paraStyleNode3, paraNodeList, n, n2);
            } else if (paraNode.getNodeType() == 257) {
                ParaTextNode paraTextNode = (ParaTextNode)paraNode;
                String string = paraTextNode.substring(0, paraTextNode.getEndIndex());
                String string2 = paraTextNode.substring(paraTextNode.getEndIndex());
                paraTextNode.setNewText(string);
                ParaTextNode paraTextNode2 = this.createTextSegment(string2);
                this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode2);
                this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode2), (JetRptObject)((Object)paraTextNode2), 0);
                paraNodeList.insert(n2 + 1, paraTextNode2);
            }
        }
    }

    protected void separateWithEndLine(ParaRootNode paraRootNode, ParaNodeList paraNodeList, int n, int n2) {
        int n3 = paraRootNode.getEndIndex();
        ParaNode paraNode = paraRootNode.childAt(n3);
        if (!paraNode.isInfiniteRight()) {
            if (paraNode.getNodeType() == 4097) {
                ParaStyleNode paraStyleNode = this.createStyleElement(((ParaStyleNode)paraNode).getStyle());
                this.separateWithEndLine((ParaStyleNode)paraNode, paraStyleNode, paraNodeList, n, n2);
                this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraStyleNode), n3 + 1);
            } else if (paraNode.getNodeType() == 257) {
                String string = ((ParaTextNode)paraNode).substring(paraNode.getEndIndex());
                String string2 = ((ParaTextNode)paraNode).substring(0, paraNode.getEndIndex());
                ((ParaTextNode)paraNode).setNewText(string2);
                ParaTextNode paraTextNode = this.createTextSegment(string);
                this.HorizontalAlignment((JetRptParaTextSegment)paraNode, (JetRptParaTextSegment)paraTextNode);
                this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode), n3 + 1);
                paraNodeList.insert(n2 + 1, paraTextNode);
            }
        }
    }

    protected void separateWithStartLine(ParaStyleNode paraStyleNode, ParaStyleNode paraStyleNode2, ParaNodeList paraNodeList, int n, int n2) {
        int n3 = paraStyleNode.getStartIndex();
        this.moveChildrenNode(paraStyleNode, paraStyleNode2, 0, n3 - 1);
        ParaNode paraNode = paraStyleNode.childAt(0);
        if (!paraNode.isInfiniteLeft()) {
            if (paraNode.getNodeType() == 4097) {
                ParaStyleNode paraStyleNode3 = this.createStyleElement(((ParaStyleNode)paraNode).getStyle());
                this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode2), (JetRptObject)((Object)paraStyleNode3));
                this.separateWithStartLine((ParaStyleNode)paraNode, paraStyleNode3, paraNodeList, n, n2);
            } else {
                ParaTextNode paraTextNode = (ParaTextNode)paraNode;
                String string = paraTextNode.substring(0, paraTextNode.getStartIndex());
                String string2 = paraTextNode.substring(paraTextNode.getStartIndex());
                paraTextNode.setNewText(string2);
                ParaTextNode paraTextNode2 = this.createTextSegment(string);
                this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode2);
                this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode2), (JetRptObject)((Object)paraTextNode2));
                paraNodeList.insert(n, paraTextNode2);
            }
        }
    }

    protected void separateWithStartLine(ParaRootNode paraRootNode, ParaNodeList paraNodeList, int n, int n2) {
        int n3 = paraRootNode.getStartIndex();
        ParaNode paraNode = paraRootNode.childAt(n3);
        if (!paraNode.isInfiniteLeft()) {
            if (paraNode.getNodeType() == 4097) {
                ParaStyleNode paraStyleNode = this.createStyleElement(((ParaStyleNode)paraNode).getStyle());
                this.separateWithStartLine((ParaStyleNode)paraNode, paraStyleNode, paraNodeList, n, n2);
                this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraStyleNode), n3);
            } else if (paraNode.getNodeType() == 257) {
                String string = ((ParaTextNode)paraNode).substring(0, paraNode.getStartIndex());
                String string2 = ((ParaTextNode)paraNode).substring(paraNode.getStartIndex());
                ((ParaTextNode)paraNode).setNewText(string2);
                ParaTextNode paraTextNode = this.createTextSegment(string);
                this.HorizontalAlignment((JetRptParaTextSegment)paraNode, (JetRptParaTextSegment)paraTextNode);
                this.basicComponentLogic.add((JetContainable)((Object)paraRootNode), (JetRptObject)((Object)paraTextNode), n3);
                paraNodeList.insert(n, paraTextNode);
            }
            paraRootNode.increaseStartIndex();
            paraRootNode.increaseEndIndex();
        }
    }

    private int[] LeftLine(ParaTrunkNode paraTrunkNode, NStyle nStyle, ParaNodeList paraNodeList, int n, int n2) {
        int n3 = paraTrunkNode.getStartIndex();
        ParaTextNode paraTextNode = (ParaTextNode)paraTrunkNode.childAt(n3);
        String string = paraTextNode.substring(0, paraTextNode.getStartIndex());
        String string2 = paraTextNode.substring(paraTextNode.getStartIndex(), paraTextNode.getEndIndex());
        String string3 = paraTextNode.substring(paraTextNode.getEndIndex());
        if (string.length() > 0 && string3.length() > 0) {
            ParaTextNode paraTextNode2 = this.createTextSegment(string);
            ParaStyleNode paraStyleNode = this.createStyleElement(nStyle);
            ParaTextNode paraTextNode3 = this.createTextSegment(string2);
            paraTextNode.setNewText(string3);
            this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode2);
            this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode3);
            this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode), (JetRptObject)((Object)paraTextNode3));
            this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNode), n3);
            this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraTextNode2), n3);
            paraNodeList.insert(n, paraTextNode3);
            paraNodeList.insert(n, paraTextNode2);
            return new int[]{n + 2, n2 + 2};
        }
        if (string.length() > 0) {
            ParaTextNode paraTextNode4 = this.createTextSegment(string2 + string3);
            ParaStyleNode paraStyleNode = this.createStyleElement(nStyle);
            paraTextNode.setNewText(string);
            this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode4);
            this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode), (JetRptObject)((Object)paraTextNode4));
            this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNode), n3 + 1);
            paraNodeList.insert(n + 1, paraTextNode4);
            ++n2;
            if (n3 + 2 < paraTrunkNode.length()) {
                return this.mergeParagraphWidth(paraTrunkNode, n3 + 1, n3 + 2, paraNodeList, n, n2);
            }
            return this.mergeParagraphWidth(paraTrunkNode, n3 + 1, n3 + 1, paraNodeList, n, n2);
        }
        if (string3.length() > 0) {
            ParaTextNode paraTextNode5 = this.createTextSegment(string + string2);
            ParaStyleNode paraStyleNode = this.createStyleElement(nStyle);
            paraTextNode.setNewText(string3);
            this.HorizontalAlignment((JetRptParaTextSegment)paraTextNode, (JetRptParaTextSegment)paraTextNode5);
            this.basicComponentLogic.add((JetContainable)((Object)paraStyleNode), (JetRptObject)((Object)paraTextNode5));
            this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNode), n3);
            paraNodeList.insert(n, paraTextNode5);
            return this.mergeParagraphWidth(paraTrunkNode, n3 - 1 < 0 ? 0 : n3 - 1, n3, paraNodeList, ++n, ++n2);
        }
        ParaStyleNode paraStyleNode = this.createStyleElement(nStyle);
        this.moveChildrenNode(paraTrunkNode, n3, n3, paraStyleNode, 0);
        this.basicComponentLogic.add((JetContainable)((Object)paraTrunkNode), (JetRptObject)((Object)paraStyleNode), n3);
        return this.mergeParagraphWidth(paraTrunkNode, n3 <= 0 ? n3 : n3 - 1, n3 + 1 < paraTrunkNode.length() ? n3 + 1 : n3, paraNodeList, n, n2);
    }

    private void RightLine(ParaTrunkNode paraTrunkNode, int n) {
        this.SEDU(paraTrunkNode, n, 0);
    }

    private void SEDU(ParaTrunkNode paraTrunkNode, int n, int n2) {
        this.clearChildrenStyle(paraTrunkNode, n, n2, paraTrunkNode.length() - 1);
    }

    protected void clearChildrenStyle(ParaTrunkNode paraTrunkNode, int n, int n2, int n3) {
        for (int i = n3; i >= n2; --i) {
            ParaNode paraNode = paraTrunkNode.childAt(i);
            if (paraNode.getNodeType() != 4097) continue;
            ParaStyleNode paraStyleNode = (ParaStyleNode)paraNode;
            if (paraStyleNode.getStyleType() == n) {
                this.moveChildrenNode(paraStyleNode, 0, paraStyleNode.length() - 1, paraTrunkNode, i);
                this.basicComponentLogic.remove((JetRptObject)((Object)paraStyleNode));
                continue;
            }
            this.RightLine(paraStyleNode, n);
        }
    }

    private int[] Shadow(ParaTrunkNode paraTrunkNode, ParaNodeList paraNodeList, int n, int n2) {
        return this.ShadowColor(paraTrunkNode, 0, paraNodeList, n, n2);
    }

    private int[] ShadowColor(ParaTrunkNode paraTrunkNode, int n, ParaNodeList paraNodeList, int n2, int n3) {
        return this.mergeParagraphWidth(paraTrunkNode, n, paraTrunkNode.length() - 1, paraNodeList, n2, n3);
    }

    protected int[] mergeParagraphWidth(ParaTrunkNode paraTrunkNode, int n, int n2, ParaNodeList paraNodeList, int n3, int object) {
        Object object2;
        ParaNode paraNode;
        int n4;
        for (n4 = n; n4 <= n2; ++n4) {
            paraNode = paraTrunkNode.childAt(n4);
            if (paraNode.getNodeType() != 4097) continue;
            object2 = this.Shadow((ParaStyleNode)paraNode, paraNodeList, n3, (int)object);
            n3 = object2[0];
            object = object2[1];
        }
        n4 = n;
        while (n4 <= n2 - 1) {
            paraNode = paraTrunkNode.childAt(n4);
            object2 = paraTrunkNode.childAt(n4 + 1);
            if (paraNode.getNodeType() == object2.getNodeType()) {
                int n5;
                ParaNode paraNode2;
                ParaNode paraNode3;
                if (paraNode.getNodeType() == 257) {
                    paraNode3 = (ParaTextNode)paraNode;
                    paraNode2 = (ParaTextNode)object2;
                    paraNode3.setNewText(paraNode3.getNodeText() + paraNode2.getNodeText());
                    this.basicComponentLogic.remove((JetRptObject)((Object)paraNode2));
                    n5 = paraNodeList.indexOf(paraNode2);
                    if (n5 <= n3) {
                        --n3;
                        --object;
                    } else if (n5 <= object) {
                        --object;
                    }
                    paraNodeList.remove(paraNode2);
                    --n2;
                    continue;
                }
                if (paraNode.getNodeType() == 4097) {
                    paraNode3 = (ParaStyleNode)paraNode;
                    paraNode2 = (ParaStyleNode)object2;
                    if (paraNode3.getStyle().equal(paraNode2.getStyle())) {
                        n5 = paraNode3.length();
                        this.moveChildrenNode((ParaTrunkNode)paraNode2, (ParaTrunkNode)paraNode3);
                        this.basicComponentLogic.remove((JetRptObject)((Object)paraNode2));
                        if (n5 > 0) {
                            int[] nArray = this.mergeParagraphWidth((ParaTrunkNode)paraNode3, n5 - 1, n5, paraNodeList, n3, (int)object);
                            n3 = nArray[0];
                            object = nArray[1];
                        }
                        --n2;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                ++n4;
                continue;
            }
            ++n4;
        }
        return new int[]{n3, object};
    }

    @Override
    public void handleSpecialProperty(JetRptObject jetRptObject) {
        JetObject jetObject = (JetObject)((Object)jetRptObject.getParent());
        if (jetObject != null && jetObject instanceof JetRptParaReplaceElement && jetRptObject instanceof JRObjectTemplate && !(jetRptObject instanceof JetRptField)) {
            JetEnumeration jetEnumeration = ((JRObjectTemplate)jetRptObject).position;
            if (jetEnumeration != null && jetEnumeration.intValue() == 0) {
                ParagraphLogicImpl.setPropertiesEditFlag(jetRptObject, forbid_static_prop.iterator(), 0);
            }
            if (jetRptObject.getPropertyGroup("TOC") != null) {
                jetRptObject.removePropertyGroup("TOC");
            }
        }
    }

    static void setPropertiesEditFlag(JetRptObject jetRptObject, Iterator iterator, int n) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                JetProperty jetProperty;
                String string = (String)iterator.next();
                if (string == null || (jetProperty = jetRptObject.nameToProperty(string)) == null) continue;
                jetProperty.setEditFlag(n);
            }
        }
    }

    @Override
    public int getReplaceElementPositionIn(JetRptParagraph jetRptParagraph, JetRptParaReplaceElement jetRptParaReplaceElement, boolean bl) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        int n = paraNodeListImpl.indexOf(jetRptParaReplaceElement);
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ParaNode paraNode = paraNodeListImpl.item(i);
            if (bl) {
                n2 += paraNode.length();
                continue;
            }
            if (paraNode.getNodeType() == 258) {
                ++n2;
                continue;
            }
            n2 += paraNode.length();
        }
        return n2;
    }

    @Override
    public Object getContentByPosition(JetRptParagraph jetRptParagraph, int n, boolean bl) {
        ParaNode paraNode = (ParaNode)this.getParaTreeNodeByPosition(jetRptParagraph, n, bl);
        if (paraNode == null) {
            return null;
        }
        if (paraNode.getNodeType() == 258) {
            return ((JetRptParaReplaceElement)paraNode).getObject();
        }
        int n2 = paraNode.getStartIndex();
        return String.valueOf(((ParaTextNode)paraNode).getNodeText().charAt(n2));
    }

    @Override
    public Object getParaTreeNodeByPosition(JetRptParagraph jetRptParagraph, int n, boolean bl) {
        ParaNodeListImpl paraNodeListImpl = new ParaNodeListImpl();
        ParaRootNode paraRootNode = this.initParagraphLogic(jetRptParagraph, paraNodeListImpl);
        if (paraRootNode == null) {
            return null;
        }
        ParaNode paraNode = null;
        int n2 = 0;
        if (bl) {
            for (int i = 0; i < paraNodeListImpl.size(); ++i) {
                int n3;
                paraNode = paraNodeListImpl.item(i);
                if (paraNode.isIncludePosition(false, n3 = n - n2)) {
                    if (paraNode.getNodeType() == 258) {
                        return paraNode;
                    }
                    paraNode.setStartIndex(n3);
                    return paraNode;
                }
                n2 += paraNode.length();
            }
        } else {
            for (int i = 0; i < paraNodeListImpl.size(); ++i) {
                paraNode = paraNodeListImpl.item(i);
                int n4 = n - n2;
                if (paraNode.getNodeType() == 258) {
                    if (n4 == 0) {
                        return paraNode;
                    }
                    ++n2;
                    continue;
                }
                if (paraNode.isIncludePosition(false, n4)) {
                    paraNode.setStartIndex(n4);
                    return paraNode;
                }
                n2 += paraNode.length();
            }
        }
        return null;
    }

    @Override
    public JetRptParagraph createParagraphObject(ParagraphObjInfo paragraphObjInfo) {
        JetRptParagraph jetRptParagraph = new JetRptParagraph();
        jetRptParagraph.setEditable();
        this.formatParagraphObject(jetRptParagraph, paragraphObjInfo);
        return jetRptParagraph;
    }

    private boolean TRUE(JetProperty jetProperty) {
        return jetProperty == null || jetProperty instanceof JetReference || jetProperty instanceof JetReferences || jetProperty instanceof JetChangeBy && ((JetChangeBy)jetProperty).toUnitString() == null || jetProperty.toUnitString() == null;
    }

    @Override
    public ParagraphObjInfo createParagraphInfo(JetRptParagraph jetRptParagraph, JetUUniverse jetUUniverse) {
        String string;
        Object object2;
        ParagraphObjInfo paragraphObjInfo = new ParagraphObjInfo();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        for (Object object2 : jetRptParagraph.getAllProperties().values()) {
            if (this.TRUE((JetProperty)object2)) continue;
            if (((JetProperty)object2).isChagneByFmtt()) {
                hashtable.put(((JetProperty)object2).getName(), (String)((JetProperty)object2).getChangeByFmtt());
                hashtable2.put(((JetProperty)object2).getName(), Boolean.TRUE);
                hashtable3.put(((JetProperty)object2).getName(), 1);
                continue;
            }
            if (((JetProperty)object2).isChangeByBL()) {
                hashtable.put(((JetProperty)object2).getName(), (String)((JetProperty)object2).getChangeByBL());
                hashtable2.put(((JetProperty)object2).getName(), Boolean.TRUE);
                hashtable3.put(((JetProperty)object2).getName(), 2);
                continue;
            }
            if (((JetProperty)object2).isChangeByOther()) {
                hashtable.put(((JetProperty)object2).getName(), (String)((JetProperty)object2).getChangeByObject());
                hashtable2.put(((JetProperty)object2).getName(), Boolean.TRUE);
                hashtable3.put(((JetProperty)object2).getName(), 0);
                continue;
            }
            hashtable.put(((JetProperty)object2).getName(), ((JetProperty)object2).toUnitString());
        }
        paragraphObjInfo.setProperties(hashtable, hashtable2, hashtable3);
        object2 = jetRptParagraph.getChildrenList().iterator();
        Vector<Object> vector = new Vector<Object>();
        Hashtable hashtable4 = new Hashtable(NStyle.TYPE_NAME.length);
        for (int i = 0; i < NStyle.TYPE_NAME.length; ++i) {
            string = NStyle.TYPE_NAME[i];
            hashtable4.put(string, hashtable.get(string));
        }
        JetRptDataSet jetRptDataSet = jetRptParagraph.getDataSet();
        while (object2.hasNext()) {
            Object object3;
            string = object2.next();
            if (string instanceof JetRptParaReplaceElement) {
                object3 = this.VerticalAlignment((JetRptParaReplaceElement)((Object)string), jetRptDataSet, jetUUniverse);
                if (object3 == null) continue;
                vector.add(object3);
                continue;
            }
            if (string instanceof JetRptParaStyleElement) {
                object3 = new Vector();
                this.TYPE_NAME((JetRptParaStyleElement)((Object)string), hashtable4, (List)object3);
                vector.addAll((Collection<Object>)object3);
                continue;
            }
            if (!(string instanceof JetRptParaTextSegment) || (object3 = this.TopLine((JetRptParaTextSegment)((Object)string), hashtable4)) == null) continue;
            vector.add(object3);
        }
        paragraphObjInfo.setElementList(vector);
        return paragraphObjInfo;
    }

    private void TYPE_NAME(JetRptParaStyleElement jetRptParaStyleElement, Hashtable hashtable, List list) {
        String string = jetRptParaStyleElement.getStyleName();
        String string2 = jetRptParaStyleElement.getStyleStringValue();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
        hashtable2.put(string, string2);
        Vector vector = jetRptParaStyleElement.getChildren();
        for (JetObject jetObject : vector) {
            if (jetObject instanceof JetRptParaTextSegment) {
                TextInfo textInfo = this.TopLine((JetRptParaTextSegment)jetObject, hashtable2);
                if (textInfo == null) continue;
                list.add(textInfo);
                continue;
            }
            this.TYPE_NAME((JetRptParaStyleElement)jetObject, hashtable2, list);
        }
    }

    private TextInfo TopLine(JetRptParaTextSegment jetRptParaTextSegment, Hashtable hashtable) {
        String string = jetRptParaTextSegment.getText();
        if (string == null || string.length() == 0) {
            return null;
        }
        TextInfo textInfo = new TextInfo(string);
        textInfo.setTextStyles(hashtable);
        return textInfo;
    }

    private ReplaceInfo VerticalAlignment(JetRptParaReplaceElement jetRptParaReplaceElement, JetRptDataSet jetRptDataSet, JetUUniverse jetUUniverse) {
        JetRptObject jetRptObject = jetRptParaReplaceElement.getObject();
        int n = jetRptParaReplaceElement.getLayoutPolicy();
        if (jetRptObject instanceof JetRptField) {
            DisplayFieldInfo displayFieldInfo = ObjectLogicFactory.getSimpleComponentLogic().createFieldInfo((JetRptField)jetRptObject, jetRptDataSet, jetUUniverse);
            ReplaceInfo replaceInfo = new ReplaceInfo(displayFieldInfo);
            replaceInfo.setLayoutPolicy(n);
            return replaceInfo;
        }
        if (jetRptObject instanceof JetRptPicture) {
            PictureInfo pictureInfo = ObjectLogicFactory.getSimpleComponentLogic().createPictureInfo((JetRptPicture)jetRptObject);
            ReplaceInfo replaceInfo = new ReplaceInfo(pictureInfo);
            replaceInfo.setLayoutPolicy(n);
            return replaceInfo;
        }
        if (jetRptObject instanceof JRObjectTemplate) {
            ReplaceInfo replaceInfo = new ReplaceInfo(jetRptObject);
            replaceInfo.setLayoutPolicy(n);
            return replaceInfo;
        }
        return null;
    }

    @Override
    public void formatParagraphObject(JetRptParagraph jetRptParagraph, ParagraphObjInfo paragraphObjInfo) {
        Vector<JetRptParaReplaceElement> vector;
        Object object6;
        Iterator<Object> iterator;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Object object5;
        Map.Entry entry2;
        Hashtable hashtable = paragraphObjInfo.getProperties();
        Hashtable hashtable2 = paragraphObjInfo.getMarks();
        Hashtable hashtable3 = paragraphObjInfo.getFlags();
        Hashtable hashtable4 = jetRptParagraph.getProperties();
        for (Map.Entry entry2 : hashtable.entrySet()) {
            object5 = (String)entry2.getKey();
            object4 = (JetProperty)hashtable4.get(object5);
            if (object4 == null || this.TRUE((JetProperty)object4)) continue;
            serializable = (Boolean)hashtable2.get(object5);
            if (serializable == null || !((Boolean)serializable).booleanValue()) {
                ((JetProperty)object4).setUnitValue((String)entry2.getValue());
                ((JetProperty)object4).setChangeByObject(null);
                ((JetProperty)object4).setChangeByBL(null);
                ((JetProperty)object4).setChangeByFmtt(null);
                continue;
            }
            object3 = (Integer)hashtable3.get(object5);
            if (object3 == null || (Integer)object3 == 0) {
                ((JetProperty)object4).setChangeByObject(entry2.getValue());
                ((JetProperty)object4).setChangeByBL(null);
                ((JetProperty)object4).setChangeByFmtt(null);
                continue;
            }
            if ((Integer)object3 == 2) {
                ((JetProperty)object4).setChangeByObject(null);
                ((JetProperty)object4).setChangeByBL(entry2.getValue());
                ((JetProperty)object4).setChangeByFmtt(null);
                continue;
            }
            ((JetProperty)object4).setChangeByObject(null);
            ((JetProperty)object4).setChangeByBL(null);
            ((JetProperty)object4).setChangeByFmtt(entry2.getValue());
        }
        entry2 = new Vector();
        object5 = new Hashtable();
        object4 = new Vector();
        serializable = jetRptParagraph.getChildren();
        object3 = ((Vector)serializable).iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 instanceof JetRptParaTextSegment) {
                ((Vector)((Object)entry2)).add((JetRptParaTextSegment)object2);
                continue;
            }
            if (object2 instanceof JetRptParaStyleElement) {
                ((Vector)object4).add((JetRptParaStyleElement)object2);
                this.Width((JetRptParaStyleElement)object2, (Vector)object4, (Vector)((Object)entry2));
                continue;
            }
            if (!(object2 instanceof JetRptParaReplaceElement)) continue;
            iterator = ((JetRptParaReplaceElement)object2).getObject();
            object6 = null;
            object6 = iterator == null ? Object.class : iterator.getClass();
            vector = (Vector<JetRptParaReplaceElement>)((Hashtable)object5).get(object6);
            if (vector == null) {
                vector = new Vector<JetRptParaReplaceElement>();
                ((Hashtable)object5).put(object6, vector);
            }
            vector.add((JetRptParaReplaceElement)object2);
        }
        object3 = paragraphObjInfo.getElementList();
        object2 = new Vector();
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object6 = (ElementInfo)iterator.next();
            if (object6 instanceof TextInfo) {
                ((Vector)object2).add((TextInfo)object6);
                continue;
            }
            this.WordWrap(jetRptParagraph, jetRptParagraph, (Vector)object2, 0, (Vector)object4, (Vector)((Object)entry2));
            ((Vector)object2).clear();
            this.Y(jetRptParagraph, (ReplaceInfo)object6, (Hashtable)object5);
        }
        this.WordWrap(jetRptParagraph, jetRptParagraph, (Vector)object2, 0, (Vector)object4, (Vector)((Object)entry2));
        ((Vector)object2).clear();
        object2 = null;
        iterator = ((Vector)((Object)entry2)).iterator();
        while (iterator.hasNext()) {
            object6 = (JetRptParaTextSegment)iterator.next();
            this.basicComponentLogic.remove((JetObject)object6);
        }
        iterator = ((Vector)object4).iterator();
        while (iterator.hasNext()) {
            object6 = (JetRptParaStyleElement)iterator.next();
            this.basicComponentLogic.remove((JetObject)object6);
        }
        for (Object object6 : ((Hashtable)object5).values()) {
            vector = ((Vector)object6).iterator();
            while (vector.hasNext()) {
                JetRptParaReplaceElement jetRptParaReplaceElement = (JetRptParaReplaceElement)vector.next();
                this.basicComponentLogic.remove(jetRptParaReplaceElement);
            }
        }
    }

    private void Width(JetRptParaStyleElement jetRptParaStyleElement, Vector vector, Vector vector2) {
        Vector vector3 = jetRptParaStyleElement.getChildren();
        for (Object e : vector3) {
            if (e instanceof JetRptParaTextSegment) {
                vector2.add((JetRptParaTextSegment)e);
                continue;
            }
            if (!(e instanceof JetRptParaStyleElement)) continue;
            vector.add((JetRptParaStyleElement)e);
            this.Width((JetRptParaStyleElement)e, vector, vector2);
        }
    }

    private void WordWrap(JetRptParagraph jetRptParagraph, JetContainable jetContainable, Vector vector, int n, Vector vector2, Vector vector3) {
        int n2 = vector.size();
        if (n2 >= 1) {
            if (n < NStyle.TYPE_NAME.length) {
                String string = NStyle.TYPE_NAME[n];
                String string2 = jetRptParagraph.getStyleDefValueString(string);
                TextInfo textInfo = (TextInfo)vector.get(0);
                Hashtable hashtable = textInfo.getTextStyles();
                String string3 = (String)hashtable.get(string);
                if (string3 == null) {
                    string3 = string2;
                }
                Vector<TextInfo> vector4 = new Vector<TextInfo>();
                vector4.add(textInfo);
                for (int i = 1; i < n2; ++i) {
                    TextInfo textInfo2 = (TextInfo)vector.get(i);
                    Hashtable hashtable2 = textInfo2.getTextStyles();
                    String string4 = (String)hashtable2.get(string);
                    if (string4 == null) {
                        string4 = string2;
                    }
                    if (string4.equals(string3)) {
                        vector4.add(textInfo2);
                        continue;
                    }
                    JetContainable jetContainable2 = this.X(string, string3, string2, jetContainable, vector2);
                    this.WordWrap(jetRptParagraph, jetContainable2, vector4, n + 1, vector2, vector3);
                    vector4.clear();
                    vector4.add(textInfo2);
                    string3 = string4;
                }
                JetContainable jetContainable3 = this.X(string, string3, string2, jetContainable, vector2);
                this.WordWrap(jetRptParagraph, jetContainable3, vector4, n + 1, vector2, vector3);
                vector4.clear();
                vector4 = null;
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                for (Object object2 : vector) {
                    stringBuffer.append(((TextInfo)object2).getTextStr());
                }
                if (vector3.isEmpty()) {
                    object = (JetRptParaTextSegment)this.createTextSegment(stringBuffer.toString());
                    this.basicComponentLogic.add(jetContainable, (JetObject)object);
                } else {
                    Object object2;
                    object = (JetRptParaTextSegment)vector3.remove(0);
                    ((JetRptParaTextSegment)object).setNewText(stringBuffer.toString());
                    object2 = ((JetObject)object).getParent();
                    object2.getChildren().remove(object);
                    ((JetObject)object).setParentDirectly(jetContainable);
                    jetContainable.getChildren().add(object);
                }
                stringBuffer.setLength(0);
                stringBuffer = null;
            }
        }
    }

    private JetContainable X(String string, String string2, String string3, JetContainable jetContainable, Vector vector) {
        if (string2.equals(string3)) {
            return jetContainable;
        }
        if (vector.isEmpty()) {
            JetRptParaStyleElement jetRptParaStyleElement = new JetRptParaStyleElement(new ParaStyle(string, string2, 0));
            this.basicComponentLogic.add(jetContainable, jetRptParaStyleElement);
            jetContainable = jetRptParaStyleElement;
        } else {
            JetRptParaStyleElement jetRptParaStyleElement = (JetRptParaStyleElement)vector.remove(0);
            JetContainable jetContainable2 = jetRptParaStyleElement.getParent();
            jetContainable2.getChildren().remove(jetRptParaStyleElement);
            jetRptParaStyleElement.setParentDirectly(null);
            Vector vector2 = jetContainable2.getChildren();
            Vector vector3 = jetRptParaStyleElement.getChildren();
            int n = vector3.size();
            for (int i = n - 1; i >= 0; --i) {
                JetObject jetObject = (JetObject)vector3.remove(0);
                jetObject.setParentDirectly(jetContainable2);
                vector2.add(jetObject);
            }
            jetRptParaStyleElement.setStyle(new ParaStyle(string, string2, 0));
            jetRptParaStyleElement.setParentDirectly(jetContainable);
            jetContainable.getChildren().add(jetRptParaStyleElement);
            jetContainable = jetRptParaStyleElement;
        }
        return jetContainable;
    }

    private void Y(JetRptParagraph jetRptParagraph, ReplaceInfo replaceInfo, Hashtable hashtable) {
        Object object = replaceInfo.getActualObject();
        if (object instanceof DisplayFieldInfo) {
            DisplayFieldInfo displayFieldInfo = (DisplayFieldInfo)object;
            Class<Object> clazz = Object.class;
            switch (displayFieldInfo.getFieldType()) {
                case 10: {
                    clazz = JetRptDBField.class;
                    break;
                }
                case 9: {
                    clazz = JetRptTextField.class;
                    break;
                }
                case 45: {
                    clazz = JetRptParameterField.class;
                    break;
                }
                case 344: {
                    clazz = JetRptRefParameterField.class;
                    break;
                }
                case 343: {
                    clazz = JetRptTitleTextField.class;
                    break;
                }
                case 37: {
                    clazz = JetRptSystemField.class;
                    break;
                }
                default: {
                    if (JRLog.isError(1)) {
                        JRLog.error(1, "Righit now, Can not insert this field to paragraph, type= " + displayFieldInfo.getFieldType(), (Throwable)new UnsupportedOperationException());
                    }
                    return;
                }
            }
            Vector vector = (Vector)hashtable.get(clazz);
            if (vector == null) {
                vector = (Vector)hashtable.get(Object.class);
            }
            if (vector == null || vector.isEmpty()) {
                JetRptField jetRptField = ObjectLogicFactory.getSimpleComponentLogic().createField(displayFieldInfo);
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement(jetRptField);
                this.basicComponentLogic.add(jetRptParagraph, jetRptParaReplaceElement);
            } else {
                Object object2;
                JetRptParaReplaceElement jetRptParaReplaceElement = null;
                int n = displayFieldInfo.getRenderType();
                for (JetRptBox jetRptBox : vector) {
                    JetRptField jetRptField = (JetRptField)jetRptBox.getObject();
                    if (jetRptField == null) {
                        jetRptParaReplaceElement = jetRptBox;
                        break;
                    }
                    if (jetRptField.getCurrentUsedRenderer() == null || jetRptField.getCurrentUsedRenderer().getRenderType() != n) continue;
                    jetRptParaReplaceElement = jetRptBox;
                    break;
                }
                if (jetRptParaReplaceElement == null) {
                    object2 = ObjectLogicFactory.getSimpleComponentLogic().createField(displayFieldInfo);
                    jetRptParaReplaceElement = this.createReplaceElement((JetRptObject)object2);
                    this.basicComponentLogic.add(jetRptParagraph, jetRptParaReplaceElement);
                } else {
                    vector.remove(jetRptParaReplaceElement);
                    object2 = (JetRptField)jetRptParaReplaceElement.getObject();
                    if (object2 == null) {
                        JetRptBox jetRptBox;
                        jetRptBox = ObjectLogicFactory.getSimpleComponentLogic().createField(displayFieldInfo);
                        this.basicComponentLogic.add(jetRptParaReplaceElement, (JetObject)object2);
                    } else {
                        ObjectLogicFactory.getSimpleComponentLogic().formatField((JetRptField)object2, displayFieldInfo);
                        jetRptParagraph.getChildren().remove(jetRptParaReplaceElement);
                        jetRptParagraph.getChildren().add(jetRptParaReplaceElement);
                    }
                }
            }
        } else if (object instanceof PictureInfo) {
            Class<JetRptPicture> clazz = JetRptPicture.class;
            Vector vector = (Vector)hashtable.get(clazz);
            if (vector == null) {
                vector = (Vector)hashtable.get(Object.class);
            }
            if (vector == null || vector.isEmpty()) {
                JetRptPicture jetRptPicture = ObjectLogicFactory.getSimpleComponentLogic().createSimplePicture((PictureInfo)object);
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement(jetRptPicture);
                this.basicComponentLogic.add(jetRptParagraph, jetRptParaReplaceElement);
            } else {
                JetRptParaReplaceElement jetRptParaReplaceElement = (JetRptParaReplaceElement)vector.remove(0);
                JetRptObject jetRptObject = jetRptParaReplaceElement.getObject();
                if (jetRptObject == null) {
                    JetRptPicture jetRptPicture = ObjectLogicFactory.getSimpleComponentLogic().createSimplePicture((PictureInfo)object);
                    this.basicComponentLogic.add(jetRptParaReplaceElement, jetRptPicture);
                } else {
                    JetRptPicture jetRptPicture = (JetRptPicture)jetRptObject;
                    ObjectLogicFactory.getSimpleComponentLogic().formatSimplePicture((JetRptPicture)jetRptObject, (PictureInfo)object);
                }
                jetRptParagraph.getChildren().remove(jetRptParaReplaceElement);
                jetRptParagraph.getChildren().add(jetRptParaReplaceElement);
            }
        } else if (object instanceof JRObjectTemplate) {
            Class<?> clazz = object.getClass();
            Vector vector = (Vector)hashtable.get(clazz);
            if (vector == null) {
                vector = (Vector)hashtable.get(Object.class);
            }
            if (vector == null || vector.isEmpty()) {
                JetRptParaReplaceElement jetRptParaReplaceElement = this.createReplaceElement((JRObjectTemplate)object);
                this.basicComponentLogic.add(jetRptParagraph, jetRptParaReplaceElement);
            } else {
                JetRptParaReplaceElement jetRptParaReplaceElement = (JetRptParaReplaceElement)vector.remove(0);
                JetRptObject jetRptObject = jetRptParaReplaceElement.getObject();
                if (jetRptObject == null) {
                    this.basicComponentLogic.add(jetRptParaReplaceElement, (JRObjectTemplate)object);
                } else if (jetRptObject != object) {
                    this.basicComponentLogic.remove(jetRptObject);
                    this.basicComponentLogic.add(jetRptParaReplaceElement, (JRObjectTemplate)object);
                }
                jetRptParagraph.getChildren().remove(jetRptParaReplaceElement);
                jetRptParagraph.getChildren().add(jetRptParaReplaceElement);
            }
        } else if (object != null && JRLog.isError(1)) {
            JRLog.error(1, "Righit now, we didn't support this object/info in paragraph info " + object.getClass(), (Throwable)new UnsupportedOperationException());
        }
    }

    static {
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.Width));
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.Height));
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.VerticalAlignment));
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.WordWrap));
        forbid_inline_prop.add(PropertyNames.getDefinitionName(PropertyNames.AutoFit));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.BorderColor));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.TopLine));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.BottomLine));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.LeftLine));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.RightLine));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.Shadow));
        forbid_border_prop.add(PropertyNames.getDefinitionName(PropertyNames.ShadowColor));
        forbid_padding_prop.add(PropertyNames.getDefinitionName(PropertyNames.padding_top));
        forbid_padding_prop.add(PropertyNames.getDefinitionName(PropertyNames.padding_bottom));
        forbid_padding_prop.add(PropertyNames.getDefinitionName(PropertyNames.padding_left));
        forbid_padding_prop.add(PropertyNames.getDefinitionName(PropertyNames.padding_right));
        forbid_static_prop.add(PropertyNames.getDefinitionName(PropertyNames.X));
        forbid_static_prop.add(PropertyNames.getDefinitionName(PropertyNames.Y));
    }
}

