/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import com.jinfonet.util.JRLog;
import java.util.List;
import java.util.Vector;
import jet.controls.JetEnumeration;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.naming.EnumerationConstant;
import jet.report.JRUnSupportedSpecialTypeException;
import jet.report.JetRpt2DGeometryObject;
import jet.report.JetRptArcShape;
import jet.report.JetRptAreaDBText;
import jet.report.JetRptAreaText;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggSpecialField;
import jet.report.JetRptCTDBField;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptCTHdDBTitleField;
import jet.report.JetRptCTHdLabelField;
import jet.report.JetRptCTHdTextField;
import jet.report.JetRptDBField;
import jet.report.JetRptField;
import jet.report.JetRptGTBox;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptLine;
import jet.report.JetRptMapAddTextField;
import jet.report.JetRptMapDBField;
import jet.report.JetRptMapTextField;
import jet.report.JetRptMultiValueContainer;
import jet.report.JetRptOvalShape;
import jet.report.JetRptParameterField;
import jet.report.JetRptPicture;
import jet.report.JetRptPolyLine;
import jet.report.JetRptRefParameterField;
import jet.report.JetRptRoundBoxShape;
import jet.report.JetRptSystemField;
import jet.report.JetRptTextField;
import jet.report.JetRptTitleTextField;
import jet.report.mode.JetRptMode;
import jet.reportLogic.objectInfo.AreaTextInfo;
import jet.reportLogic.objectInfo.DisplayFieldInfo;
import jet.reportLogic.objectInfo.GeometryObjInfo;
import jet.reportLogic.objectInfo.PictureInfo;
import jet.reportLogic.objectLogic.AbstractObjectLogicImpl;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.SimpleComponentLogic;
import jet.reportset.DataSet;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DataElementInfo;
import jet.util.ValueToUnit;
import jet.util.image.ImageResource;

class SimpleComponentLogicImpl
implements SimpleComponentLogic {
    SimpleComponentLogicImpl() {
    }

    @Override
    public JetRptField createSimpleField(String string, int n) {
        return this.createSimpleField(string, null, n, 16);
    }

    @Override
    public JetRptField createSimpleField(String string, String string2, int n) {
        return this.createSimpleField(string, string2, n, 16);
    }

    @Override
    public JetRptField createSimpleField(String string, int n, int n2) {
        return this.createSimpleField(string, null, n, n2);
    }

    @Override
    public JetRptField createSimpleField(String string, String string2, int n, int n2) {
        JetRptField jetRptField = null;
        switch (n) {
            case 10: {
                jetRptField = new JetRptDBField();
                jetRptField.setEditable();
                ((JetRptDBField)jetRptField).columnName.set(string);
                if (string2 == null) break;
                ((JetRptDBField)jetRptField).blColumnName.set(string2);
                break;
            }
            case 60: {
                jetRptField = new JetRptMapDBField();
                jetRptField.setEditable();
                ((JetRptMapDBField)jetRptField).columnName.set(string);
                if (string2 == null) break;
                ((JetRptMapDBField)jetRptField).blColumnName.set(string2);
                break;
            }
            case 37: {
                jetRptField = new JetRptSystemField();
                jetRptField.setEditable();
                ((JetRptSystemField)jetRptField).fieldType.set(string);
                break;
            }
            case 45: {
                jetRptField = new JetRptParameterField();
                jetRptField.setEditable();
                ((JetRptParameterField)jetRptField).param.set(string);
                break;
            }
            case 59: {
                jetRptField = new JetRptMapTextField();
                jetRptField.setEditable();
                ((JetRptMapTextField)jetRptField).text.set(string);
                break;
            }
            case 9: {
                n = 9;
                jetRptField = new JetRptTextField();
                jetRptField.setEditable();
                ((JetRptTextField)jetRptField).text.set(string);
                break;
            }
            case 323: {
                n = 323;
                jetRptField = new JetRptMapAddTextField();
                jetRptField.setEditable();
                ((JetRptMapAddTextField)jetRptField).text.set(string);
                break;
            }
            case 343: {
                n = 343;
                jetRptField = new JetRptTitleTextField();
                jetRptField.setEditable();
                ((JetRptTitleTextField)jetRptField).text.set(string);
                break;
            }
            case 344: {
                n = 344;
                jetRptField = new JetRptRefParameterField();
                jetRptField.setEditable();
                ((JetRptRefParameterField)jetRptField).param.set(string);
                ((JetRptRefParameterField)jetRptField).setDataSourceName(string2);
                break;
            }
            default: {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5210500, new String[]{"" + n, "Simple/Map Field"});
                }
                return null;
            }
        }
        return this.HAlignment(jetRptField, n2);
    }

    private JetRptField HAlignment(JetRptField jetRptField, int n) {
        if (n == 16) {
            n = jetRptField instanceof JetRptMapDBField ? 3 : (jetRptField instanceof JetRptRefParameterField ? 15 : 0);
        } else if (jetRptField instanceof JetRptRefParameterField) {
            n = 15;
        } else if (!(n != 8 && n != 9 || jetRptField instanceof JetRptParameterField)) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5210501);
            }
            n = 0;
        }
        if (jetRptField instanceof JetRptMapDBField || jetRptField instanceof JetRptMapTextField) {
            jetRptField.HAlignment.set(new Integer(2));
            jetRptField.gotoDetail.set(false);
        } else {
            jetRptField.HAlignment.set(new Integer(0));
            if (!(jetRptField instanceof JetRptSystemField) || ((JetRptSystemField)jetRptField).getFieldType() != 9) {
                jetRptField.gotoDetail.set(false);
            }
        }
        if (!(jetRptField instanceof JetRptTitleTextField)) {
            jetRptField.position.set(new Integer(0));
        }
        jetRptField.width.setUnitValue(6000);
        jetRptField.height.setUnitValue(1037);
        JetEnumeration jetEnumeration = (JetEnumeration)jetRptField.nameToProperty("LinkURLTargetFrame");
        jetEnumeration.set(new Integer(4));
        if (jetRptField instanceof JetRptRefParameterField) {
            jetRptField.topPadding.setUnitValue(0);
            jetRptField.bottomPadding.setUnitValue(0);
            jetRptField.leftPadding.setUnitValue(0);
            jetRptField.rightPadding.setUnitValue(0);
            jetRptField.exportToPDF.set(true);
        } else {
            jetRptField.topPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
            jetRptField.bottomPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
            jetRptField.leftPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
            jetRptField.rightPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
        }
        JetRptMode jetRptMode = (JetRptMode)ObjectLogicFactory.getModeRendererLogic().createMode(n);
        jetRptField.refMode.setObject(jetRptMode);
        if (n != 0) {
            if (n == 3 || n == 1 || n == 10) {
                if (jetRptField.exportToCSV != null) {
                    jetRptField.exportToCSV.set(false);
                }
                jetRptField.bNExportToCSV = false;
                jetRptField.exportToText.set(false);
                jetRptField.exportToXML.set(false);
                if (n == 10) {
                    jetRptField.exportToPDF.set(false);
                }
            } else if (n == 4 || n == 5 || n == 6 || n == 7 || n == 11 || n == 12 || n == 13 || n == 8 || n == 9) {
                jetRptField.exportToPDF.set(false);
            }
        }
        return jetRptField;
    }

    @Override
    public JetRptField createRefParameterField(String string, String string2) {
        return this.createSimpleField(string, string2, 344, 15);
    }

    @Override
    public JetRptField createCrosstableField(int n) {
        return this.createCrosstableField(n, null, null, 0);
    }

    @Override
    public JetRptField createCrosstableField(int n, int n2) {
        return this.createCrosstableField(n, null, null, n2);
    }

    @Override
    public JetRptField createCrosstableField(int n, String string, int n2) {
        return this.createCrosstableField(n, null, string, n2);
    }

    @Override
    public JetRptField createCrosstableField(int n, String string, String string2, int n2) {
        Class clazz = null;
        switch (n) {
            case 20: {
                clazz = JetRptCTAggField.class;
                break;
            }
            case 130: {
                clazz = JetRptCTAggSpecialField.class;
                break;
            }
            case 22: {
                clazz = JetRptCTHdDBField.class;
                break;
            }
            case 43: {
                clazz = JetRptCTHdTextField.class;
                break;
            }
            case 131: {
                clazz = JetRptCTHdDBTitleField.class;
                break;
            }
            case 129: {
                clazz = JetRptCTHdLabelField.class;
                break;
            }
            default: {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5210500, new String[]{"" + n, "Crosstable Field"});
                }
                return null;
            }
        }
        return this.createField(clazz, string, string2, n2);
    }

    @Override
    public JetRptField createField(Class clazz, int n) {
        return this.createField(clazz, null, null, n);
    }

    @Override
    public JetRptField createField(Class clazz, String string, int n) {
        return this.createField(clazz, null, string, n);
    }

    @Override
    public JetRptField createField(Class clazz, String string, String string2, int n) {
        JetRptField jetRptField = null;
        try {
            jetRptField = (JetRptField)clazz.newInstance();
            jetRptField.setEditable();
        }
        catch (InstantiationException instantiationException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5210502, instantiationException.getMessage());
            }
            return jetRptField;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5210503, illegalAccessException.getMessage());
            }
            return jetRptField;
        }
        catch (ClassCastException classCastException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5210504, classCastException.getMessage());
            }
            return jetRptField;
        }
        if (jetRptField instanceof JetRptDBField) {
            if (string != null) {
                ((JetRptDBField)jetRptField).columnName.set(string);
            }
            if (string2 != null) {
                ((JetRptDBField)jetRptField).blColumnName.set(string2);
            }
        } else if (jetRptField instanceof JetRptParameterField) {
            if (string != null) {
                ((JetRptParameterField)jetRptField).param.set(string);
            }
        } else if (jetRptField instanceof JetRptRefParameterField) {
            if (string != null) {
                ((JetRptRefParameterField)jetRptField).param.set(string);
            }
            if (string2 != null) {
                ((JetRptRefParameterField)jetRptField).setDataSourceName(string2);
            }
        } else if (jetRptField instanceof JetRptSystemField) {
            if (string != null) {
                ((JetRptSystemField)jetRptField).fieldType.set(string);
            }
        } else if (jetRptField instanceof JetRptTextField) {
            if (string != null) {
                ((JetRptTextField)jetRptField).text.set(string);
            }
        } else {
            return null;
        }
        return this.HAlignment(jetRptField, n);
    }

    @Override
    public int getSimpleComponentType(JetRptField jetRptField) {
        if (jetRptField instanceof JetRptDBField) {
            if (jetRptField instanceof JetRptCTDBField) {
                if (jetRptField instanceof JetRptCTAggField) {
                    if (jetRptField instanceof JetRptCTAggSpecialField) {
                        return 130;
                    }
                    return 20;
                }
                if (jetRptField instanceof JetRptCTHdDBField) {
                    return 22;
                }
                return -1;
            }
            if (jetRptField instanceof JetRptMapDBField) {
                return 60;
            }
            if (jetRptField instanceof JetRptAreaDBText) {
                return 321;
            }
            return 10;
        }
        if (jetRptField instanceof JetRptTextField) {
            if (jetRptField instanceof JetRptCTHdTextField) {
                if (jetRptField instanceof JetRptCTHdDBTitleField) {
                    return 131;
                }
                if (jetRptField instanceof JetRptCTHdLabelField) {
                    return 129;
                }
                return 43;
            }
            if (jetRptField instanceof JetRptMapTextField) {
                return 59;
            }
            if (jetRptField instanceof JetRptAreaText) {
                return 320;
            }
            if (jetRptField instanceof JetRptMapAddTextField) {
                return 323;
            }
            if (jetRptField instanceof JetRptTitleTextField) {
                return 343;
            }
            return 9;
        }
        if (jetRptField instanceof JetRptParameterField) {
            return 45;
        }
        if (jetRptField instanceof JetRptSystemField) {
            return 37;
        }
        if (jetRptField instanceof JetRptRefParameterField) {
            return 344;
        }
        return -1;
    }

    @Override
    public JetRptMultiValueContainer createMultiValueContainer(int n) {
        return ObjectLogicFactory.getMultiValueContainerLogic().createMultiValueContainer(n);
    }

    @Override
    public JetRptSystemField createSystemField(int n) {
        return this.createSystemField(n, 0);
    }

    @Override
    public JetRptSystemField createSystemField(int n, int n2) {
        String string = "";
        try {
            string = JetRptSystemField.getPresentationName(n);
        }
        catch (JRUnSupportedSpecialTypeException jRUnSupportedSpecialTypeException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, jRUnSupportedSpecialTypeException);
            }
            return null;
        }
        return (JetRptSystemField)this.createSimpleField(string, null, 37, n2);
    }

    @Override
    public JetRptPicture createSimplePicture(String string, int n, int n2) {
        JetRptPicture jetRptPicture = new JetRptPicture();
        jetRptPicture.setEditable();
        if (jetRptPicture.exportToCSV != null) {
            jetRptPicture.exportToCSV.set(false);
        }
        jetRptPicture.bNExportToCSV = false;
        jetRptPicture.pictureName.set(string);
        jetRptPicture.width.setUnitValue(n);
        jetRptPicture.height.setUnitValue(n2);
        return jetRptPicture;
    }

    @Override
    public JetRptField createField(DisplayFieldInfo displayFieldInfo) {
        int n = displayFieldInfo.getFieldType();
        JetRptField jetRptField = null;
        if (n == 10 || n == 60 || n == 45) {
            String string = displayFieldInfo.getFieldName();
            String string2 = displayFieldInfo.getBLName();
            jetRptField = this.createSimpleField(string, string2, n, displayFieldInfo.getRenderType());
        } else if (n == 344) {
            String string = displayFieldInfo.getFieldName();
            String string3 = displayFieldInfo.getDataSourceName();
            jetRptField = this.createSimpleField(string, string3, n, displayFieldInfo.getRenderType());
        } else if (n == 37) {
            String string = null;
            try {
                string = JetRptSystemField.getPresentationName(displayFieldInfo.getSystemFieldType());
            }
            catch (JRUnSupportedSpecialTypeException jRUnSupportedSpecialTypeException) {
                return null;
            }
            jetRptField = this.createSimpleField(string, null, n, displayFieldInfo.getRenderType());
        } else if (n == 9 || n == 59 || n == 323 || n == 343) {
            String string = displayFieldInfo.getFieldName();
            if (string == null) {
                string = displayFieldInfo.getDisplayName();
            }
            if (string == null) {
                string = "";
            }
            jetRptField = this.createSimpleField(string, null, n, displayFieldInfo.getRenderType());
        } else if (n == 20 || n == 130 || n == 22) {
            String string = displayFieldInfo.getFieldName();
            String string4 = displayFieldInfo.getBLName();
            jetRptField = this.createCrosstableField(n, string, string4, displayFieldInfo.getRenderType());
        } else if (n == 131 || n == 129 || n == 43) {
            String string = displayFieldInfo.getFieldName();
            if (string == null) {
                string = displayFieldInfo.getDisplayName();
            }
            if (string == null) {
                string = "";
            }
            jetRptField = this.createCrosstableField(n, string, null, displayFieldInfo.getRenderType());
        } else {
            return null;
        }
        this.formatField(jetRptField, displayFieldInfo);
        return jetRptField;
    }

    @Override
    public void formatField(JetRptField jetRptField, DisplayFieldInfo displayFieldInfo) {
        AbstractObjectLogicImpl.fillPropertiesToObject(displayFieldInfo, jetRptField);
        jetRptField.setDisplayName(displayFieldInfo.getDisplayName());
        if (jetRptField instanceof JetRptTextField) {
            String string = displayFieldInfo.getFieldName();
            String string2 = string = string == null ? displayFieldInfo.getDisplayName() : string;
            if (string != null) {
                if (((JetRptTextField)jetRptField).text != null) {
                    ((JetRptTextField)jetRptField).text.set(string);
                } else {
                    ((JetRptTextField)jetRptField).sNText = string;
                }
            }
        } else if (jetRptField instanceof JetRptSystemField) {
            if (((JetRptSystemField)jetRptField).fieldType != null) {
                ((JetRptSystemField)jetRptField).fieldType.set(displayFieldInfo.getSystemFieldType());
            } else {
                ((JetRptSystemField)jetRptField).iNFieldType = displayFieldInfo.getSystemFieldType();
            }
        } else if (jetRptField instanceof JetRptDBField) {
            ((JetRptDBField)jetRptField).blColumnName.set(displayFieldInfo.getBLName());
            if (((JetRptDBField)jetRptField).columnName != null) {
                ((JetRptDBField)jetRptField).columnName.set(displayFieldInfo.getFieldName());
            } else {
                ((JetRptDBField)jetRptField).sNColumnName = displayFieldInfo.getFieldName();
            }
        } else if (jetRptField instanceof JetRptParameterField) {
            String string = displayFieldInfo.getFieldName();
            String string3 = string = string == null ? "" : string;
            if (((JetRptParameterField)jetRptField).param != null) {
                ((JetRptParameterField)jetRptField).param.set(string);
            } else {
                ((JetRptParameterField)jetRptField).sNParameter = displayFieldInfo.getFieldName();
            }
        } else if (jetRptField instanceof JetRptRefParameterField) {
            ((JetRptRefParameterField)jetRptField).param.set(displayFieldInfo.getFieldName());
        }
        if (displayFieldInfo.isSummary() && displayFieldInfo.getBreakFieldName() != null && displayFieldInfo.getBreakFieldName().trim().length() > 0) {
            jetRptField.gotoDetail.set(true);
        }
    }

    @Override
    public DisplayFieldInfo createFieldInfo(JetRptField jetRptField, DataSet dataSet, JetUUniverse jetUUniverse) {
        if (jetRptField instanceof JetRptAreaText) {
            throw new IllegalArgumentException("JetRptAreaText");
        }
        if (jetRptField instanceof JetRptAreaDBText) {
            throw new IllegalArgumentException("JetRptAreaDBText");
        }
        DisplayFieldInfo displayFieldInfo = null;
        if (jetRptField instanceof JetRptTextField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptTextField)jetRptField).sNText, jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(this.getSimpleComponentType(jetRptField));
        } else if (jetRptField instanceof JetRptDBField) {
            displayFieldInfo = new DisplayFieldInfo(((JetRptDBField)jetRptField).blColumnName.get(), ((JetRptDBField)jetRptField).sDisColumnName, ((JetRptDBField)jetRptField).getDisplayName(), null);
            displayFieldInfo.setFieldType(this.getSimpleComponentType(jetRptField));
            if (dataSet != null) {
                String string = "";
                boolean bl = false;
                if (dataSet.getDataResourceType() == 0 || dataSet.getDataResourceType() == 3) {
                    string = ((JetRptDBField)jetRptField).getColumnName();
                    bl = false;
                } else {
                    string = ((JetRptDBField)jetRptField).blColumnName.get();
                    bl = true;
                }
                IReport iReport = ObjectLogicFactory.getBasicComponentLogic().getIReportOf(jetRptField);
                String string2 = ObjectLogicFactory.getDataSetLogic().getRefMappingName(jetUUniverse, iReport, dataSet, string, bl);
                JetUResourceEntity jetUResourceEntity = jetUUniverse == null ? null : (string2 == null ? null : jetUUniverse.getResourceByName(dataSet.getDataSourceName(), dataSet.getQueryName(), string2));
                int n = ObjectLogicFactory.getDataSetLogic().getDataSqlType(jetUResourceEntity);
                if (jetUResourceEntity instanceof JetUSummary) {
                    JetUSummary jetUSummary = (JetUSummary)jetUResourceEntity;
                    displayFieldInfo.setSummaryInfo(true, jetUSummary.getFunction(), jetUSummary.getGroupByFld());
                    displayFieldInfo.setSumOnFieldName(jetUSummary.getFieldName());
                    n = ObjectLogicFactory.getDataSetLogic().getFuncSqlType(jetUSummary.getFunction(), n);
                } else if (jetUResourceEntity instanceof JetUFormula) {
                    displayFieldInfo.setFormula(true);
                }
                displayFieldInfo.setSqlType(n);
            }
        } else if (jetRptField instanceof JetRptParameterField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptParameterField)jetRptField).param.getDispName(), jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(45);
        } else if (jetRptField instanceof JetRptSystemField) {
            int n = ((JetRptSystemField)jetRptField).getFieldType();
            displayFieldInfo = new DisplayFieldInfo(null, EnumerationConstant.SYSTEM_FIELD_TYPE[n], jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(37);
            displayFieldInfo.setSystemFieldType(n);
        } else if (jetRptField instanceof JetRptRefParameterField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptRefParameterField)jetRptField).param.getDispName(), jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(344);
        } else {
            return null;
        }
        displayFieldInfo.setInstName(jetRptField.getInstNameDirectly());
        int n = ObjectLogicFactory.getModeRendererLogic().getComponentCurrentRenderer(jetRptField).getRenderType();
        displayFieldInfo.setRenderType(n);
        AbstractObjectLogicImpl.fillPropertiesToInfo(displayFieldInfo, jetRptField.getProperties());
        return displayFieldInfo;
    }

    @Override
    public DisplayFieldInfo createFieldInfo(JetRptField jetRptField, JetUUniverse jetUUniverse) {
        if (jetRptField instanceof JetRptAreaText) {
            throw new IllegalArgumentException("JetRptAreaText");
        }
        if (jetRptField instanceof JetRptAreaDBText) {
            throw new IllegalArgumentException("JetRptAreaDBText");
        }
        DisplayFieldInfo displayFieldInfo = null;
        if (jetRptField instanceof JetRptTextField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptTextField)jetRptField).sNText, jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(this.getSimpleComponentType(jetRptField));
        } else if (jetRptField instanceof JetRptDBField) {
            displayFieldInfo = new DisplayFieldInfo(((JetRptDBField)jetRptField).blColumnName.get(), ((JetRptDBField)jetRptField).sDisColumnName, ((JetRptDBField)jetRptField).getDisplayName(), null);
            displayFieldInfo.setFieldType(this.getSimpleComponentType(jetRptField));
            String string = ((JetRptDBField)jetRptField).getColumnName();
            IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getBindDataContainer(jetRptField);
            DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
            if (dataSet != null) {
                String string2 = "";
                boolean bl = false;
                if (dataSet.getDataResourceType() == 0 || dataSet.getDataResourceType() == 3) {
                    string2 = ((JetRptDBField)jetRptField).getColumnName();
                    bl = false;
                } else {
                    string2 = ((JetRptDBField)jetRptField).blColumnName.get();
                    bl = true;
                }
                String string3 = ObjectLogicFactory.getDataSetLogic().getRefMappingName(jetUUniverse, null, dataSet, string2, bl);
                JetUResourceEntity jetUResourceEntity = jetUUniverse == null ? null : jetUUniverse.getResourceByName(dataSet.getDataSourceName(), dataSet.getQueryName(), string3);
                int n = ObjectLogicFactory.getDataSetLogic().getDataSqlType(jetUResourceEntity);
                if (jetUResourceEntity instanceof JetUSummary) {
                    JetUSummary jetUSummary = (JetUSummary)jetUResourceEntity;
                    displayFieldInfo.setSummaryInfo(true, jetUSummary.getFunction(), jetUSummary.getGroupByFld());
                    displayFieldInfo.setSumOnFieldName(jetUSummary.getFieldName());
                    n = ObjectLogicFactory.getDataSetLogic().getFuncSqlType(jetUSummary.getFunction(), n);
                } else if (jetUResourceEntity instanceof JetUFormula) {
                    displayFieldInfo.setFormula(true);
                }
                displayFieldInfo.setSqlType(n);
            }
        } else if (jetRptField instanceof JetRptParameterField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptParameterField)jetRptField).param.getDispName(), jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(45);
        } else if (jetRptField instanceof JetRptSystemField) {
            int n = ((JetRptSystemField)jetRptField).getFieldType();
            displayFieldInfo = new DisplayFieldInfo(null, EnumerationConstant.SYSTEM_FIELD_TYPE[n], jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(37);
            displayFieldInfo.setSystemFieldType(n);
        } else if (jetRptField instanceof JetRptRefParameterField) {
            displayFieldInfo = new DisplayFieldInfo(null, ((JetRptRefParameterField)jetRptField).param.getDispName(), jetRptField.getDisplayName(), null);
            displayFieldInfo.setFieldType(344);
        } else {
            return null;
        }
        displayFieldInfo.setInstName(jetRptField.getInstNameDirectly());
        int n = ObjectLogicFactory.getModeRendererLogic().getComponentCurrentRenderer(jetRptField).getRenderType();
        displayFieldInfo.setRenderType(n);
        AbstractObjectLogicImpl.fillPropertiesToInfo(displayFieldInfo, jetRptField.getProperties());
        return displayFieldInfo;
    }

    @Override
    public AreaTextInfo createAreaTextInfo(JetRptAreaText jetRptAreaText) {
        AreaTextInfo areaTextInfo = new AreaTextInfo(320, null);
        AbstractObjectLogicImpl.fillPropertiesToInfo(areaTextInfo, jetRptAreaText.getProperties());
        JetRptMapTextField jetRptMapTextField = (JetRptMapTextField)jetRptAreaText.getBasedMapTextField();
        if (jetRptMapTextField != null) {
            areaTextInfo.setBasedDislayFieldInfo(this.createFieldInfo(jetRptMapTextField, null, null));
        }
        areaTextInfo.setInstName(jetRptAreaText.getInstNameDirectly());
        Vector vector = jetRptAreaText.getChildren();
        Vector<GeometryObjInfo> vector2 = new Vector<GeometryObjInfo>();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof JetRpt2DGeometryObject)) continue;
            vector2.add(this.createGeometryInfo((JetRpt2DGeometryObject)vector.get(i)));
        }
        areaTextInfo.setGeometryInfos(vector2);
        return areaTextInfo;
    }

    @Override
    public AreaTextInfo createAreaTextInfo(JetRptAreaDBText jetRptAreaDBText, DataSet dataSet, JetUUniverse jetUUniverse) {
        AreaTextInfo areaTextInfo = new AreaTextInfo(321, jetRptAreaDBText.getBasedDBColumn());
        AbstractObjectLogicImpl.fillPropertiesToInfo(areaTextInfo, jetRptAreaDBText.getProperties());
        JetRptMapDBField jetRptMapDBField = (JetRptMapDBField)jetRptAreaDBText.getBasedMapDBField();
        if (jetRptMapDBField != null) {
            areaTextInfo.setBasedDislayFieldInfo(this.createFieldInfo(jetRptMapDBField, dataSet, jetUUniverse));
        }
        areaTextInfo.setInstName(jetRptAreaDBText.getInstNameDirectly());
        Vector vector = jetRptAreaDBText.getChildren();
        Vector<GeometryObjInfo> vector2 = new Vector<GeometryObjInfo>();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof JetRpt2DGeometryObject)) continue;
            vector2.add(this.createGeometryInfo((JetRpt2DGeometryObject)vector.get(i)));
        }
        areaTextInfo.setGeometryInfos(vector2);
        return areaTextInfo;
    }

    protected int getGeometryObjType(JetRpt2DGeometryObject jetRpt2DGeometryObject) {
        if (jetRpt2DGeometryObject instanceof JetRptLine) {
            return 5;
        }
        if (jetRpt2DGeometryObject instanceof JetRptGTBox) {
            if (jetRpt2DGeometryObject instanceof JetRptArcShape) {
                return 3;
            }
            if (jetRpt2DGeometryObject instanceof JetRptOvalShape) {
                return 6;
            }
            if (jetRpt2DGeometryObject instanceof JetRptRoundBoxShape) {
                return 7;
            }
            return 4;
        }
        if (jetRpt2DGeometryObject instanceof JetRptPolyLine) {
            return 322;
        }
        return -1;
    }

    @Override
    public GeometryObjInfo createGeometryInfo(JetRpt2DGeometryObject jetRpt2DGeometryObject) {
        int n = this.getGeometryObjType(jetRpt2DGeometryObject);
        GeometryObjInfo geometryObjInfo = new GeometryObjInfo(n);
        AbstractObjectLogicImpl.fillPropertiesToInfo(geometryObjInfo, jetRpt2DGeometryObject.getProperties());
        geometryObjInfo.setInstName(jetRpt2DGeometryObject.getInstNameDirectly());
        if (n != 322) {
            Object object = ((JetRptGeometryObject)jetRpt2DGeometryObject).oNTopAttach;
            int n2 = ((JetRptGeometryObject)jetRpt2DGeometryObject).iNTopAttachPosX;
            int n3 = ((JetRptGeometryObject)jetRpt2DGeometryObject).iNTopAttachPosY;
            geometryObjInfo.appendAttachPos(object, n2, n3);
            Object object2 = ((JetRptGeometryObject)jetRpt2DGeometryObject).oNBottomAttach;
            int n4 = ((JetRptGeometryObject)jetRpt2DGeometryObject).iNBottomAttachPosX;
            int n5 = ((JetRptGeometryObject)jetRpt2DGeometryObject).iNBottomAttachPosY;
            geometryObjInfo.appendAttachPos(object2, n4, n5);
        } else {
            int[] nArray = ((JetRptPolyLine)jetRpt2DGeometryObject).parsePointsInUnit();
            int n6 = 0;
            while (n6 < nArray.length) {
                geometryObjInfo.appendAttachPos(null, nArray[n6++], nArray[n6++]);
            }
        }
        return geometryObjInfo;
    }

    @Override
    public JetRpt2DGeometryObject createGeometryObject(GeometryObjInfo geometryObjInfo) {
        int n = geometryObjInfo.getGeometryType();
        JetRpt2DGeometryObject jetRpt2DGeometryObject = this.I(n);
        this.resetPropertiesToGeometryObj(jetRpt2DGeometryObject, geometryObjInfo);
        return jetRpt2DGeometryObject;
    }

    private JetRpt2DGeometryObject I(int n) {
        JetRpt2DGeometryObject jetRpt2DGeometryObject = null;
        switch (n) {
            case 3: {
                jetRpt2DGeometryObject = new JetRptArcShape();
                jetRpt2DGeometryObject.setEditable();
                break;
            }
            case 4: {
                jetRpt2DGeometryObject = new JetRptGTBox();
                jetRpt2DGeometryObject.setEditable();
                break;
            }
            case 5: {
                jetRpt2DGeometryObject = new JetRptLine();
                jetRpt2DGeometryObject.setEditable();
                break;
            }
            case 6: {
                jetRpt2DGeometryObject = new JetRptOvalShape();
                jetRpt2DGeometryObject.setEditable();
                break;
            }
            case 322: {
                jetRpt2DGeometryObject = new JetRptPolyLine();
                jetRpt2DGeometryObject.setEditable();
                break;
            }
            case 7: {
                jetRpt2DGeometryObject = new JetRptRoundBoxShape();
                jetRpt2DGeometryObject.setEditable();
            }
        }
        return jetRpt2DGeometryObject;
    }

    @Override
    public void resetPropertiesToGeometryObj(JetRpt2DGeometryObject jetRpt2DGeometryObject, GeometryObjInfo geometryObjInfo) {
        if (jetRpt2DGeometryObject == null) {
            return;
        }
        AbstractObjectLogicImpl.fillPropertiesToObject(geometryObjInfo, jetRpt2DGeometryObject);
        int n = geometryObjInfo.getGeometryType();
        if (n == 322) {
            int n2 = geometryObjInfo.getGPointInfoCount();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                GeometryObjInfo.GPointInfo gPointInfo = geometryObjInfo.getGPointInfoAt(i);
                int[] nArray = gPointInfo.getCoordinate();
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(nArray[0]).append(",");
                stringBuffer.append(nArray[1]);
            }
            jetRpt2DGeometryObject.getPropertyByName("Coordinates").set(stringBuffer.toString());
        } else {
            GeometryObjInfo.GPointInfo gPointInfo = geometryObjInfo.getGPointInfoAt(0);
            int[] nArray = gPointInfo.getCoordinate();
            ((JetRptGeometryObject)jetRpt2DGeometryObject).topAttach.setObject(gPointInfo.getAttachedObj());
            ((JetRptGeometryObject)jetRpt2DGeometryObject).topAttachPosX.set(nArray[0]);
            ((JetRptGeometryObject)jetRpt2DGeometryObject).topAttachPosY.set(nArray[1]);
            GeometryObjInfo.GPointInfo gPointInfo2 = geometryObjInfo.getGPointInfoAt(0);
            nArray = gPointInfo2.getCoordinate();
            ((JetRptGeometryObject)jetRpt2DGeometryObject).bottomAttach.setObject(gPointInfo2.getAttachedObj());
            ((JetRptGeometryObject)jetRpt2DGeometryObject).bottomAttachPosX.set(nArray[0]);
            ((JetRptGeometryObject)jetRpt2DGeometryObject).bottomAttachPosY.set(nArray[1]);
        }
    }

    @Override
    public JetRptTitleTextField createComponentTitleField(String string) {
        return (JetRptTitleTextField)this.createSimpleField(string, 343, 0);
    }

    @Override
    public JetRptAreaText createAreaText(String string) {
        JetRptAreaText jetRptAreaText = new JetRptAreaText();
        jetRptAreaText.setEditable();
        jetRptAreaText.text.set(string);
        this.HAlignment(jetRptAreaText, 0);
        jetRptAreaText.HAlignment.set(new Integer(2));
        return jetRptAreaText;
    }

    @Override
    public JetRptAreaText createAreaText(AreaTextInfo areaTextInfo) {
        if (areaTextInfo.getTextInfoType() != 320) {
            throw new IllegalArgumentException();
        }
        JetRptAreaText jetRptAreaText = new JetRptAreaText();
        jetRptAreaText.setEditable();
        this.HAlignment(jetRptAreaText, 0);
        jetRptAreaText.HAlignment.set(new Integer(2));
        AbstractObjectLogicImpl.fillPropertiesToObject(areaTextInfo, jetRptAreaText);
        List list = areaTextInfo.getGeometryInfos();
        for (int i = 0; i < list.size(); ++i) {
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptAreaText, this.createGeometryObject((GeometryObjInfo)list.get(i)));
        }
        return jetRptAreaText;
    }

    @Override
    public JetRptAreaDBText createAreaDBText(String string, String string2) {
        JetRptAreaDBText jetRptAreaDBText = new JetRptAreaDBText();
        jetRptAreaDBText.setEditable();
        jetRptAreaDBText.columnName.set(string);
        jetRptAreaDBText.blColumnName.set(string2);
        this.HAlignment(jetRptAreaDBText, 0);
        jetRptAreaDBText.width.setUnitValue(3000);
        jetRptAreaDBText.HAlignment.set(new Integer(2));
        return jetRptAreaDBText;
    }

    @Override
    public JetRptAreaDBText createAreaDBText(AreaTextInfo areaTextInfo) {
        if (areaTextInfo.getTextInfoType() != 321) {
            throw new IllegalArgumentException();
        }
        JetRptAreaDBText jetRptAreaDBText = this.createAreaDBText(areaTextInfo.getDbColumnText(), null);
        AbstractObjectLogicImpl.fillPropertiesToObject(areaTextInfo, jetRptAreaDBText);
        List list = areaTextInfo.getGeometryInfos();
        for (int i = 0; i < list.size(); ++i) {
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptAreaDBText, this.createGeometryObject((GeometryObjInfo)list.get(i)));
        }
        return jetRptAreaDBText;
    }

    private JetUResourceEntity SEDU(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        if (jetUUniverse == null) {
            return null;
        }
        IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getBindDataContainer(jetRptDBField);
        DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
        String string = "";
        boolean bl = false;
        if (dataSet.getDataResourceType() == 0 || dataSet.getDataResourceType() == 3) {
            string = jetRptDBField.getColumnName();
            bl = false;
        } else {
            string = jetRptDBField.blColumnName.get();
            bl = true;
        }
        String string2 = ObjectLogicFactory.getDataSetLogic().getRefMappingName(jetUUniverse, null, dataSet, string, bl);
        return jetUUniverse.getResourceByName(dataSet.getDataSourceName(), dataSet.getQueryName(), string2);
    }

    @Override
    public String getFunction(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUSummary) {
            return ((JetUSummary)jetUResourceEntity).function.get();
        }
        return null;
    }

    public String getSumFldName(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUSummary) {
            return ((JetUSummary)jetUResourceEntity).fldName.get();
        }
        return null;
    }

    @Override
    public String getGroupByFld(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUSummary) {
            return ((JetUSummary)jetUResourceEntity).groupbyFld.get();
        }
        return null;
    }

    @Override
    public boolean beFormula(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        return jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula;
    }

    public boolean beSummary(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        return jetUResourceEntity != null && jetUResourceEntity instanceof JetUSummary;
    }

    @Override
    public boolean canSummary(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = this.SEDU(jetRptDBField, jetUUniverse);
        if (jetUResourceEntity != null) {
            if (jetUResourceEntity instanceof JetUSummary) {
                return false;
            }
            return !(jetUResourceEntity instanceof JetUFormula) || ((JetUFormula)jetUResourceEntity).canSummary();
        }
        return false;
    }

    @Override
    public boolean checkIsSummary(JetRptDBField jetRptDBField, JetUUniverse jetUUniverse) {
        Object object;
        IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getBindDataContainer(jetRptDBField);
        DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
        if (dataSet == null || jetUUniverse == null) {
            return false;
        }
        String string = jetRptDBField.blColumnName.get();
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            string2 = jetRptDBField.columnName.get();
        } else {
            object = ObjectLogicFactory.getDataSetLogic().getRefDataElement(jetUUniverse, null, dataSet, string);
            if (object == null) {
                return false;
            }
            if (object instanceof DataElementInfo) {
                if (((DataElementInfo)object).getElementType() == 5) {
                    return true;
                }
                string2 = ((DataElementInfo)object).getRefMappingName();
            }
        }
        object = jetUUniverse.getResourceByName(dataSet.getDataSourceName(), dataSet.getQueryName(), string2);
        return object instanceof JetUSummary;
    }

    @Override
    public JetRptPicture createSimplePicture(PictureInfo pictureInfo) {
        JetRptPicture jetRptPicture = new JetRptPicture();
        jetRptPicture.setEditable();
        if (jetRptPicture.exportToCSV != null) {
            jetRptPicture.exportToCSV.set(false);
        }
        jetRptPicture.bNExportToCSV = false;
        this.formatSimplePicture(jetRptPicture, pictureInfo);
        return jetRptPicture;
    }

    @Override
    public PictureInfo createPictureInfo(JetRptPicture jetRptPicture) {
        PictureInfo pictureInfo = new PictureInfo();
        AbstractObjectLogicImpl.fillPropertiesToInfo(pictureInfo, jetRptPicture.getProperties());
        if (jetRptPicture.isEmbed()) {
            pictureInfo.setEmbedImageResource(jetRptPicture.pictureName.getEmbedImageResource());
        } else {
            pictureInfo.setEmbedImageResource(null);
        }
        return pictureInfo;
    }

    @Override
    public void formatSimplePicture(JetRptPicture jetRptPicture, PictureInfo pictureInfo) {
        AbstractObjectLogicImpl.fillPropertiesToObject(pictureInfo, jetRptPicture);
        if (pictureInfo.isImageEmbed()) {
            ImageResource imageResource = pictureInfo.getEmbedImageResource();
            jetRptPicture.setEmbedImage(imageResource.getImage(), imageResource.getImageType());
        } else {
            jetRptPicture.clearEmbedImage();
        }
    }

    @Override
    public JetRptSystemField createSystemField(String string) {
        return (JetRptSystemField)this.createSimpleField(string, null, 37, 0);
    }

    @Override
    public JetRptSystemField createSystemField(String string, int n) {
        return (JetRptSystemField)this.createSimpleField(string, null, 37, n);
    }

    @Override
    public JetRptTextField createTextField(String string) {
        return (JetRptTextField)this.createSimpleField(string, null, 9, 0);
    }

    @Override
    public JetRptTextField createTextField(String string, int n) {
        return (JetRptTextField)this.createSimpleField(string, null, 9, n);
    }

    @Override
    public JetRptDBField createDBField(String string) {
        return (JetRptDBField)this.createSimpleField(string, null, 10, 0);
    }

    @Override
    public JetRptDBField createDBField(String string, int n) {
        return (JetRptDBField)this.createSimpleField(string, null, 10, n);
    }

    @Override
    public JetRptDBField createDBField(String string, String string2) {
        return (JetRptDBField)this.createSimpleField(string, string2, 10, 0);
    }

    @Override
    public JetRptDBField createDBField(String string, String string2, int n) {
        return (JetRptDBField)this.createSimpleField(string, string2, 10, n);
    }

    @Override
    public JetRptParameterField createParameterField(String string) {
        return (JetRptParameterField)this.createSimpleField(string, null, 45, 0);
    }

    @Override
    public JetRptParameterField createParameterField(String string, int n) {
        return (JetRptParameterField)this.createSimpleField(string, null, 45, n);
    }

    @Override
    public JetRptMapDBField createMapDBField(String string) {
        return (JetRptMapDBField)this.createSimpleField(string, null, 60, 3);
    }

    @Override
    public JetRptMapDBField createMapDBField(String string, int n) {
        return (JetRptMapDBField)this.createSimpleField(string, null, 60, n);
    }

    @Override
    public JetRptMapDBField createMapDBField(String string, String string2) {
        return (JetRptMapDBField)this.createSimpleField(string, string2, 60, 3);
    }

    @Override
    public JetRptMapDBField createMapDBField(String string, String string2, int n) {
        return (JetRptMapDBField)this.createSimpleField(string, string2, 60, n);
    }

    @Override
    public JetRptMapTextField createMapTextField(String string) {
        return (JetRptMapTextField)this.createSimpleField(string, null, 59, 0);
    }

    @Override
    public JetRptMapTextField createMapTextField(String string, int n) {
        return (JetRptMapTextField)this.createSimpleField(string, null, 59, n);
    }
}

